# 浏览器行为

浏览器针对不同的用户行为，采取不同的缓存措施。然后不同的浏览器会有不同的策略。我只测试了chrome和firefox。

### 直接输入URL回车

服务端程序：

```js
app.use('/js/:jsName',(req,res)=>{
    let fileName = req.params.jsName;
    setTimeout(()=>{
        res.sendFile(fileName,{
            root: path.join(__dirname,'../js'),
            headers: {
                'Cache-Control': 'public, max-age=86400'
            }
        });
    },2000);
})
```

Chrome和firefox都是直接从缓存中读取，不向服务端发送请求：![](/assets/screenhot1.png)

### 刷新按钮/右键重新加载

即macos上的Command+R键和其他系统的F5。这种行为，两个浏览器的差别比较大。

Chrome: from memory cache，不向服务端发送请求

![](/assets/screenhot2.png)

firefox则会自动在请求头里加上Cache-Control: max-age=0，以及条件验证和Etag验证头，向服务端发送验证请求，服务端返回304:

![](/assets/screenhot3.png)

### Command+shift+R/Ctrl+F5

此种行为两个浏览器表现一致：请求头里添加Cache-Control: no-cache（防止中间的代理缓存起作用）, Pragma: no-cache，除此之外，请求头里并没有带上条件认证和Etag信息，这样就会使得服务器重新发送资源，即返回200的情况。

![](/assets/screenhot4.png)

