# 优化

## 解决兼容性问题

针对HTTP1.1和1.0的差异性，为保证兼容性，可以同时设置Cache-Control头和Expires头，解决兼容性问题

## 控制时长

针对一般页面，设置较短的缓存时长。

对于静态资源，当然是希望其缓存有效时长越长越好，但是如果时长设置得太长，在此期间如果资源发生修改，那么客户端就无法得到及时更新。针对此种情况，可以对使用加版本号或者哈希计算资源名称的方法。（Webpack 打包就使用了此种方案）

这样既可以减少304情况，又可以及时更新资源。

![](/assets/http-cache-hierarchy.png)

## Last-Modified和ETag

前面也讲到了Last-Modified存在的问题，即资源内容不变，但是修改时间发生变化，时间仅能精确到秒的问题。

ETag能够解决这两个问题，但是它每次都要根据资源内容进行计算哈希值，会消耗一定资源。

所以如果有上面两个问题存在的情况下，可以直接使用Last-Modified。但考虑到上面的问题，一般是需要使用ETag的。

