# 缓存机制

缓存一词原本来源于计算机系统结构，提供“缓存”的目的是为了让数据访问的速度适应CPU的处理速度，其基于的原理是内存中“程序执行与数据访问的局域性行为”，即一定程序执行时间和空间内，被访问的代码集中于一部分。

如今缓存的概念已被扩充，不仅在CPU和主内存之间有Cache，而且在内存和[硬盘](https://zh.wikipedia.org/wiki/硬盘)之间也有Cache（[**磁盘缓存**](https://zh.wikipedia.org/wiki/磁盘缓存)），乃至在硬盘与[网络](https://zh.wikipedia.org/wiki/网络)之间也有某种意义上的Cache──称为[**Internet**](https://zh.wikipedia.org/wiki/Internet)**临时文件夹**或**网络内容缓存**等。凡是位于速度相差较大的两种[硬件](https://zh.wikipedia.org/wiki/硬件)之间，用于协调两者数据传输速度差异的结构，均可称之为Cache。

这里要说的是Web上的HTTP缓存。

## 缓存目的

* 减少冗余数据传输
* 缓解网络瓶颈
* 降低服务器负载
* 加快响应

## 缓存分类

* 私有缓存
* 公有缓存

私有缓存针对个体用户，如我们的浏览器就内置了私有缓存；针对一个团体内部，如一个公司，我们还可以针对这个团体架设一个缓存代理服务器，此为公有缓存。代理缓存又会牵扯到许多东西，后面补充。![](/assets/HTTPCachtType.png)

## 缓存结构

上面的缓存分类就提到了私有缓存和公有缓存，而这两者往往是在一个网络架构中都存在的，这就是缓存的分层结构，除了分层结构以外，还有更复杂的网状缓存等结构，这些本文不会详细探讨。

## 缓存的一些参数

* 字节命中率：缓存提供的字节在传输的所有字节中所占的比例
* 缓存命中率（文档命中率）：缓存提供的请求所占比例

参考资料：《HTTP权威指南》

