# 带宽与延迟

## 网络延迟
产生延迟的四种因素：

![/assets/延迟因素.png](/assets/延迟因素.png)

分别对应：
* **处理延迟:** 处理分组首部、检查位错误及确定分组目标所需的时间
* **队列延迟:** 到来的分组排队等待处理的时间
* **发送延迟:** 把消息中的所有比特转移到链路中需要的时间，是消息长度和链路速率的函数
* **传输延迟:** 消息从发送端到接收端需要的时间，是信号传播距离和速度的函数

---
每个分组在通过网络时都会遇到这样或那样的延迟。发送端与接收端的距离越远， 传播时间就越长。一路上经过的路由器越多，每个分组的处理和传输延迟就越多。 最后，网络流量越拥挤，分组在入站缓冲区中被延迟的可能性就越大。

## 宏观角度
另外，从更加宏观角度来讲，网络延迟主要从下面四方面考虑(此部分来自《CDN技术详解》)：

* **"第一公里"**:这是指万维网流量向用户传送的第一个出口，是网站服务器接入互联网的链路所能提供的带宽。这个带宽决定了一个网站能为用户提供的访问速度和并发访问量。一个网站，其服务的用户越多，对其出口带宽的要求就越大，当用户请求的数据量超过网站的出口带宽，就会在出口处形成拥塞。越是业务繁忙时，用户的访问数量越多，这个拥塞就越严重，网站会在最需要向用户提供服务时失去用户。
* **"最后一公里"**: 这是指万维网流量向用户传送的最后一段接入链路，即用户接入带宽。用户的平均接入带宽，是影响互联网上层应用发展的决定性因素之一。在互联网发展的初期，用户主要通过拨号上网或ISDN等方式上网，网络接入速度很低，所以互联网内容以带宽占用非常小的文字为主，Telnet、BBS都是那时的主流应用。当万维网出现后，人机交互更加方便友好的多媒体内容开始在互联网上传播，接入带宽成为制约用户使用互联网的主要瓶颈。从2001年开始，电信运营商开始大力发展ADSL等宽带接入服务，随着带宽的不断提升和接入手段的丰富（光纤入户、Wifi、3G等），近年来"最后一公里"的问题得到很大改善，特别是这两年中国电信等大力开展以光纤接入为手段的宽带提速服务，"最后一公里"的瓶颈问题已经基本得到解决。
* **对等互联关口**: 这里的"对等互联"是指不同基础运营商之间的互联互通，一般两个运营商之间只有两三个互联互通点，可以想象这两三个点上产生多么大的流量。当某个网站服务器部署在运营商A的IDC机房里，运营商B的用户要访问该网站，就必须经过A、B之间的互联互通点进行跨网访问。从互联网的架构来看，不同网络之间的互联互通带宽，对任何一个运营商网络的流量来说，占比都比较小，收敛比是非常高的，因此这里通常都是互联网传输中的拥堵点。
* **长途骨干传输**: 首先是长距离传输时延问题，从网站服务器到用户之间要经过网站所在IDC、骨干网、用户所在城域网、用户所在接入网等，距离非常遥远，因此不可避免地带来较长的传输时延，影响用户体验，这一问题也是互联网本身无法解决的问题。其次是骨干网拥塞问题，由于互联网上的绝大部分流量都要通过骨干网络进行传输，这就要求骨干网络的承载能力必须与互联网的应用同步发展，但实际上两者并不是同步的，当骨干网络的升级和扩容滞后于互联网之上的应用的发展时，就会阶段性地使得大型骨干网的承载能力成为影响互联网性能的瓶颈。

## 传输速率
传输速率取决于传播的媒介，传输媒介多种多样，常用的传输介质有：双绞线、同轴电缆、光纤、无线传输媒介等。

### 与光速对比
光速与分组在介质中传播速度之比，叫做该介质的折射率。这个值越大，光在该介质中传播的速度就越慢。

`光纤`通过波分复用(WDM，Wavelength-Division Multiplexing)技术，可以同时传输很多不同波长(信道)的光，因而具有明显的带宽优势。主要用于要求传输距离较长、布线条件特殊的主干网连接。

### 传输距离
除了从改善传输介质入手，还需要考虑传输距离的影响，通过缩短两点传输距离，可以减少传输时间，常见的缩短路程的方案：

* **CDN：** CDN是构建在网络之上的内容分发网络，依靠部署在各地的边缘服务器，通过中心平台的负载均衡、内容分发、调度等功能模块，使用户就近获取所需内容，降低网络拥塞，提高用户访问响应速度和命中率。
* **架设更短路线：** 如海底光缆，尽量缩短两点之间的距离。

**传输速度受到物理定力（光速限制）的限制，我们需要从协议层面去做优化，解决性能瓶颈**