# Web性能

从底层计算机网络协议到应用层各个方面去理解Web性能，此项目可能会涉及到网络、操作系统、编译原理、工程开发等知识，欢迎贡献。

点击右上角的 **Watch** 订阅项目实时获取更新，点击 **Star** 收藏项目。

## 目录

* [网页渲染原理](/网页渲染原理/README.md)
    * [渲染过程](/网页渲染原理/渲染过程.md)
    * [资源加载顺序](/网页渲染原理/资源加载顺序.md)
    * [浏览器优化策略](/网页渲染原理/浏览器优化策略.md)
    * [repaint与reflow](/网页渲染原理/repaint与reflow.md)
* [带宽与延迟](/带宽与延迟/README.md)
    * [从输入URL开始](/带宽与延迟/从输入URL开始.md)
    * [带宽与延迟](/带宽与延迟/带宽与延迟.md)
    * [TCP协议细节](/带宽与延迟/TCP协议细节.md)
    * HTTP 1.x性能
    * 针对性优化
* [缓存机制](/缓存机制/README.md)
    * [首部字段](/缓存机制/首部字段.md)
    * [浏览器行为](/缓存机制/浏览器行为.md)
    * [优化](/缓存机制/优化.md)
* [静态资源](/静态资源/README.md)
    * [资源压缩](/静态资源/资源压缩.md)
    * [图片资源优化](/静态资源/图像优化.md)
    * [Webpack](/静态资源/Webpack.md)
    * [CDN](/静态资源/CDN.md)
* 响应式编程
    * [Pub/Sub方式](/响应式编程/PubSub方式.md)
    * [Vue的方式](/响应式编程/Vue方式.md)
    * [脏检查机制](/响应式编程/脏检查机制.md)
    * 性能对比
* Virtual DOM
    * [React基础](/虚拟DOM/React基础.md)
    * 实现
    * diff算法
    * 性能考虑
* 混合开发中的性能问题
    * 混合开发方案
    * React Native性能问题
* SPA与SSR
    * SPA问题
    * 服务端渲染
    * 同构应用
    * 性能问题
* HTTP2
    * 新特性概览
    * 性能提升
    * 工程实践
* HTTPS性能影响
    * [TLS原理](/HTTPS性能影响/TLS原理.md)
    * [性能影响](/HTTPS性能影响/性能影响.md)
* [高性能JavaScript](/高性能JavaScript/README.md)
    * [V8与JIT](/高性能JavaScript/V8与JIT.md)
    * [内存管理](/高性能JavaScript/内存管理.md)
    * [GC机制](/高性能JavaScript/GC机制.md)
    * 内存泄露
    * 算法与流程
    * Web worker
* WebAssembly
    * 编译原理
    * 性能提升点
    * 应用场景
* PWA与离线应用
    * PWA简介
    * Service Worker
* 即时应用与P2P
    * UDP协议
    * WebRTC
    * WebSocket
    * 其他解决方案
* Node.js性能优化
    * [多进程架构](/Node性能优化/多进程架构.md)
    * [Node中的多进程](/Node性能优化/Node中的多进程.md)
    * [异步I/O](/Node性能优化/异步IO.md)
    * Buffer与Stream
    * C++扩展
* 云计算相关
    * 三大算法
    * 虚拟技术
    * 分布式集群
    * 大数据计算
* 集群与负载均衡
* 数据库相关
* 性能测试
    * Chrome开发者工具
    * benchmark
    * 压力测试
* 性能案例分析

## 引用说明
此项目会引用许多其他文章书籍的图片或部分内容，我会尽量都加以注明，如果有部分遗漏以致于侵犯到您的版权，烦请联系我修改！此项目旨在整理零碎的知识和实践方案，方便交流学习，请勿用于商业用途。
## 参与贡献

* 提想法和建议
* 纠错完善
* 增加新章节或内容

