# 性能影响

世间万物，必有其多面性，TLS为互联网带来安全性的同时，也会带来额外的成本，而性能就是其中之一。

## 额外的握手时延

在前面的章节中，我们详细讨论过TCP协议的一系列细节问题，而TLS同样是基于TCP的，TCP存在的问题，对于TLS来说同样存在。但是TLS协商过程的引入，必然会引入更多的延迟。

![/assets/TLS握手时延.png](/assets/TLS握手时延.png)

图片来源《HTTPS权威指南》

从图中可以看出，TLS的引入会增加1.5个RTT使得总的往返时延达到`3RTT`。

## 额外的数据包

从上节的原理介绍中我们知道，TLS协商过程中会在客户端和服务端需要带上额外的协商消息，而由于TCP的拥塞控制机制，如慢启动过程，过大的协商消息可能会被拆分成多个部分发送，会带来更多的延迟。

对于传输的数据来说，使用不同的加密算法和完整性约束算法也会导致不同程度的数据包增加。

## 密钥交换的开销

选择不同的加密套件将会带来不同的安全级别和性能影响，通常非对称加密算法的开销比对称加密算法的开销打得多，所以我们使用非对称加密算法用于交换密钥和身份验证，而使用对称加密算法用于后续的数据加密传输。

使用不同的密钥交换算法会带来不同程度的性能影响：

![/assets/密钥交换.png](/assets/密钥交换.png)

## 证书验证的开销

我们知道在握手过程中，有一个客户端对服务端证书验证的过程，这个过程会对性能有一定影响。

* 过长的证书链不仅可能会导致协商消息过大从而导致更多延迟，还会使客户端花更多时间去验证证书
* 提供不完整的证书链，会使得客户端在验证证书过程中产生额外的请求以拿到证书

## 加密解密的开销

后续传输的数据将会使用交换得到的密钥进行加密传输，而加密和解密的过程也会带来一定程度的开销，同样，不同的对称加密算法也会带来不同的开销：

![]()

## 导致代理优化的失效

// todo