/* eslint-disable no-console */
import Tools from "./tools";

export default {
  icons() {
    return {
      word:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAMAAABg3Am1AAAAb1BMVEUAAAAYdtIZdtL6+vrj8v00htjL5PjO4fP09/n4+frd6fW81e9+seVdnt4kfdS40+6wz+2qy+yMuuZSmN0whNYsgdYeedTs8vemyeuHt+ZLlNtFkNrS4/PI3fHA2PCixuqexOp4reNuqOFjod9ZnN5mjmmSAAAAAnRSTlMAiJXwxioAAADJSURBVEjH7dK7koJAEIXh3f53nQEBAcX7Xd//GRUNOrFqjolF4AlOTfJNB90/A469zO+b4N+FBkYuNPDnQgQuROBCBC5E4EIELkTgQgQuNOD5gg+DcQgzsybs5s93GkBp8wgb62CRntDCytbAyaYwToMSaiuApu82DTrIraHvJZRpYDlZlROhCzATQA0lLOESyU0ABUxgE/uuFbCGjIXt702hgH4HTKwFmCrAArCyK5BVEjg+vq4y2JoEzhCrx6DDMM77Cz4LhpsbTWYPsaamtJkAAAAASUVORK5CYII=",
      powerpoint:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAMAAABg3Am1AAAATlBMVEUAAAD/bQD/bQD/////8+D/cgj/fh7/48b/dA3/4sz/cAX/yJ7/8OT/2b3/0a//zqr/t4H//Pr/3ML/zKb/xZn/uof/pWL/pWH/mUz/jDbr9OTtAAAAAnRSTlMAiJXwxioAAACFSURBVEjH7dPJCoAwDEVRTRxb59n//1FTCLhx0YcgFXoX7epQGkgScPRYCoJCBARKERDInICACgCoAIAKAKgAgAoAqACAE37gLoLPgaldkz18Qc5aZ/yBXfqRefAHFdHO3ECgkMsgYINeaNtazhWc0gxMqevtcBIhn5Z+DALchwhegHC7APx/DM504b2GAAAAAElFTkSuQmCC",
      ogg:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAbFBMVEUAAAD/wAb/wgf/xgD/wQf/wQj/wQb/wQfEcgX/8+DzsQbIdgX/yzP9vgfwrQb/3oX/3H/glwbrpgb7uwbPgQX2tAf4twfMfQXoogbKegXtqAblngbVhwbZjgXdkwbXiwXThgbimwbShAb/xyCzBLkBAAAAB3RSTlMAVbsIuT6drnBT7QAAAg1JREFUaN7t1tly2zAMBdAsdc2KEVtqjajV7v//YwmDIprlxUiQZCa4L9bcGfOIpCj7RqP5uBzursnPexZye7wqP+4lEVKEkQdUZJHff1CRRX6RIoiQIoiQIoiQIomQIomQIomQIomQIomQIomQIomQIomQIomQIomQIomQIomQIoeQciuEkPLuyN+Hl7kC4UcRRRRRRBFFPgkpi+C6J03rgqv/Lzos2Eg3WxPTVLl57A3k7J4VTeAiRSQwc5rXavaM2My5OPGQDowUf2m8oRRQnAzFMRC8SzsWYYMhWlDhYnNtBUu0xqLGpcNiYiA4QoBFamAqaSJ9GS8c8PFijJ8DFIWJKRlIBUPi5sLOxs9z3guL6wVbtFwKmIpjIEve8Dbdp80jjd77uIBDLCq8j1gUDAS2xNPCdccy7TeF9pt7TiZ6LnH0ZOWg2r4ZGV9D2uKSOiFUvCfSmEuqjGxYPH5l5Pme4JjWIpL642otF5n3Q5CnQA9Tj4jF4xrTMBGP7w46z3gsCKGh+UjAd0fMKZ34FY8nIUu6Dz5S2nQauyHtTrWvV5nmFKAIqPIQfLGf/QKYrXHsmNUvvUEEH7QJCi5SNgaTt8IZytDiz1qOLTjIsZ7270cDlTzo1mEx7MW55f6RCHNvh8Z35I7bAI3L0x0nKBb31f8SKaKIIooooogiinxL5HD35hxuNJoPyz9FKKu/elCzjQAAAABJRU5ErkJggg==",
      gis:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAflBMVEUAAACczGabzWWqxnCczGWczmeczWWby2SczGUzaR7x+Ok6cSOAslKt1YDN5rHL5K6PwFyby2RqnUNPhDE4biGYyWNekjuGt1ZmmkFAdSaMvVqDtVRilT1UiDRIfSyUxV9ajTiSw155q01DeCl0p0pNgS9LgC1wokY1bB+m0XSICNMeAAAACHRSTlMAVbsIuT6dVGARlPYAAAHjSURBVGje7dbZUsMwDAVQtkJNA9hNnH3tzv//IJFLuIXmBRwVmNF9stUZndhOOr6SSC6X2c13cn/7I+R6/q3c3XIiUJiRJyh8yPMLFD7kEQojAoURgcKIQOFEoHAiUDgRKJwIFE4ECicChROBwolA4USgcCJQOBEonAgUPgTKAx8C5XpS5PXpPBMj4xFEEEEEEUSQ30RMXhS5GenWJYU2kyBNvFB9FmXjpjQJ3GhVUz1LrT+SZ+o9mT5FTDzU684XsWv1kd0pskQ9NJ6I61UWgXvuAIiNaA1B4eqFH2Jos1IaVf0gBpJQc9q/kB7CD8mpV+eOmfYLSEDvwrDUyg+h1pkb6TiOSyAF6Tm9fFrrzg/Z085j+uVMssTzY8S5h2cI3q4qmQ6x+pgTxFTKZRtMhSTKZQGkV9LDsRobLoTSlZErlxMg23GE0qSOyf2QTd9i7UbBOULJSUn9EGodmRGkret6RfXY/2NsVJ9kBKmGBaR0ah4IZUeHYs8ROqzMvv93tZ7ISlG3ctlGn5GG5uvlvqXfN34I7QsSAplvUF5bX8S2Q69DaYD0SjQY+QQXiaLNDmqxTfVxZWEYJm6k0zpS0W5vp7oSmfl4zP+6dwkiiCCCCCKIIIL8IWR2453ZlURysbwBsIK+36QdcJoAAAAASUVORK5CYII=",
      md:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAulBMVEUAAABEWmVFWmREWmREWmRFWmRFWmRFW2VIV2NGRnVEWmNFWWNFWmREWGNFWmVDXl5FWmRFWmVGWmRFXGUzZmZFWmT////ByMuTn6VUZ3Df4+R0g4tkdn7q7O1GW2X8/P3Jz9JwgIibpqv5+vrx8/OFk5labXZJXmdfcnpNYWv19va9xciyu799jJPb3+Gttrt4h45qe4NQZG7h5ObV2tzP1de5wcWPnKLs7u/k5+nEy86hrLGZpKqKl55LU85eAAAAFXRSTlMAROLNHPnBSxYDqGZkMTATz6qlTgWcDiXiAAAB3UlEQVRo3u3Y2W7qMBSFYZfQAh3PtMyBQhgykQKl0Hl6/9eqSDEucSwlkjeq1P1fIfniEyxyEQuO4ziO48yaZwcEnTW18O/EA1HeSUtk1X+BMK+eGTWQVlsrRyDuSIi/IK8hfoO8Y1EDeTVxCPIOBfYQI4ysu2l/Nu3A7LG9CUaxOkpLIP/lpqGPfMtAHcKop446VRA5Rq5VXzpHBiPsNpXuEdnvGCduEXOWXuAaMWdJb6VrxJzlQVIhepZIUiF6lskVFaJnSa4lCRIGehbM1K/nGOlGepa5+hi5RvCgZolD9aUunSNpV/1y23mcI8ZfauhTIIhyjwwJglnu4TeQy0BaCyclkN3nY4wiBJHVCEYoh+hZhn4xgrENiVAWwXw7iAXBrNh4Q3kECzWIDfFfiowZqiDJnRrEgiC9M41hUglBHGaD2BF0nvPGdYpqCOabQawIJuGu0Y9RFYEyrAhGwVfjqofqCGyIbj7QxuAGNAgeNfIOKgQLdfQKOsSfyqypT4gguV8f3CegRLDqSnm7Ai2CuP8UV3sJWqCgXnsTClsuv9PrXBYjPwHZx1XUfi7VjkHeH9EAeY39XNnSXz43xVrxQJhXF1mtUzLGO22JbRfnBwSdXwiO4ziO44w+AJ4bCR4jXPfjAAAAAElFTkSuQmCC",
      gif:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAdVBMVEUAAAA/UbQ/ULU5Vas/UbU+UrU/UbRAUrY/UbXo6vZgcMKhqtvM0etWZr6cpdl7h8xDVLdIWbnHzOqlrd1receZo9dSYr27wuRWZb7b3vGCjs/k5/V5hsxndsVZacDU2O6ep9lJW7lygMm0u+KutuCdptmOmdQ8X77dAAAACHRSTlMAVbsIuT6dVGARlPYAAAFZSURBVGje7dbbUoMwFIXhHqwSwJoSDiIFSj28/yOakNE1g8NFJatOx/1f5Wp/DBsYVpJ0vXabS7rf/gpZRxd1t2UiUMhIDIWHJHsoPERBISJQiAgUIgKFiUBhIlCYCBQmAoWJQGEiUJgIFCYChYlAYSJQmAgUJgKFh0B54CFQ1kGRMv6ZDojMJ4gggggiiCB/izy2bcdFhqJWtjopI1dqz0/WVei4GCntVF/dsRCdYViqSciLspk83zdu2gR5L8bipUjmjK+/rLcJcgiz+EHZxl3k9tBzkNaOajxnjEk4yNFfP2Igbu/ZLNLGrjIQop99E8R3CoSUyqdvG0lnkXPu6pYiZ/fNGk8xkJBPF0aTEd24u8JB0Kvb/EBGWmXrTx+mJiJRolAWkRD9rTTmwEB8sekbVWeFfx9MVVV5FJWVTd/cL5EggggiiCCCCCLIv0J2m8XtVpJ0tT4BD2a5PwqSzzUAAAAASUVORK5CYII=",
      code:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAABAlBMVEUAAAA3ZtY/UbU7VbEhlvM7RMk/UbU/ULZAUrUhlvQ/UbU/UbU/UbYhlvM/UbVAUbVAULY/UbYilPc/UrQ+U7M9TrYjk+4/UbU/UbU+UbU+UbU/UbU/UbU/UbY/UbUhlvQ/UbVAULUhlvM/UbYhlvM/UbUhlvQhl/EhlvMhlvMhlvM/ULUhlvM/UbYglvIhl/MglvQhlvM/UbUhlvI/ULUhlvMhlvMglfM/U7YhlvNATrgflvUglvM+UbUhlvM+ULQhlfIglvU/UbU/UrQ/UbU+UrUglvMhlvMhlvM/UbVAUrQ/ULYgmPQflvMhmPJBUbMmmfIblPIime4kku0/UbUhlvOl1t8LAAAAVHRSTlMABPgJ+wHWPC329O3lxGtPQB4cGxIOCvDhxLSel4iEcWhT17GAWVgj8OjPz8m/trCglIB4d2tlXzQqJBjgrIhiTjHo29HIvbuqqXBJRkA6FxQTDw5ILesUAAACwUlEQVRo3uzT11LbYBQE4JWEELZjU+0EY4fE2Dj00HvvvR2//6sAY60G+HVcBv47fdfSrM5qFolEIpFIJL7DEOwrpCrVTVg22XhVqdZh00KjKVuANc+pMGQa9qw3QsuwZ54hdVjz0BNmzMKeNR4yDnvOGGJxkttsK4uvGljxEW+Vh6zinVw/utaXkUsPsbJhRs82Ik5Z3ABdGv4lIjODiDHEts4RyRdF5GcfujLSK29+bMA0zrbWQFvh44PogjcqTW4Nhlm29YhQkJGm3hF0zCkKpYfxSZ2HzEddZYRGPXTIH5PIXxAtM2QdNOAKFR105rdE9mGYDjNST4j0S6SEjvyRyAoMmzxkQXlnCarYryrDVGXIpHZ9Djqz3zEfpgrbKuCDkvIflaHThAPTIQ+5QBM5u0Ju0HboNOchxh5DDkBMmRPi9NWh00keaNHWvwKI8jNCnL4ydDq+B1q19V+poe30nQnlU5S2DFtHQqeeNvS2pfo7bMtBnI20MX116OkA8e6MtvQBlFoP3b2GYpEhN1DUjOkrQ69B4U+FGVMONLlP01fuvILmlocsQlfWpx+8tGfGKgjEQBDNVVaHcEU6EUTETltBRBuxUP//c2xcm0ccGNhCzPuB5TbJ7M4cinzr1sMrUubQdzCgW6JdzsHf0S1x8M4V3keRZyG8wtZjHLbvGkeMADxGaDjUuiEr5/iQUwFCVqRAsluXAiiQntTXT7cKoNSbQ2sTH7JutAFDyxi/tyhyEAeKy0lmjUWihuFdFYBFwliJRLewEvnL3Q7dcpc7rqkqHuCa6i3cjAcoJuKhS+sg4gFYB8cEiXgAJsixcyoeoJ3zjek1LNxUAIypabF1PDAs4qEbYQHiAWCEBTIeSADxQAKMBxJgPJAA4oEEGA8kwHggjToiHshgWo6IBwRunYgHGvzO34xOp9PpdP6AF/zooIWbzWc5AAAAAElFTkSuQmCC",
      psd:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAkFBMVEUAAAA/UbQ/ULU5Vas+UrU/UbRAUrY/UbXo6vahqtve4fKcpdmlrd1gcMK7wuVodsXm6PWjrNxSYr1DVLeFkdCqst7O0+zCyOh6hsxHWLnh5PPHzOq5wOSUntaOmdSJlNFlc8RMXLrZ3PBZasDLz+vAxee0u+KYoteAjM51gspfbcFVZb7R1u2yueFqeMbR1e3ZOOtbAAAAB3RSTlMAVbsIPp1ULZjL1gAAAfpJREFUaN7t1tlWwjAQBmBFNCnV2B26UChlUVB8/7cz0zYO4I2QDkc9899kueBrJk3oDYdzvQwH5+T+7iLkVpyVwR0lggoxskWFDnFcVOgQiQohggohggohggolggolggolggolggolggolggolggolggolggolggolggolggodgsoDHYLKba9I8PQ94c8QyzDCCCOMMMLIr0GC+TzoExnJJlnyuDVTUQIzyUxAHiVktPTn9ghkKiBhYcYqbBCTOLVAMCVM+Dj2EYGsQhsk3mz8hW69QIjA051i//zejQHJN+4KlI0N8qzb3agt2AR2INVV+9CdqEUc0c5nlQ1iylQIMdPNGMax7riIiBWgtkikO8tuJfDE1W63qw6QKdTVFoEl5N2e5LXogkgES7RF1rrz3pVJenF9isASEzskKGVX83QsG2b9dIy86s6bBWKySAUovtcyJQWSmZujjltm1j9S1DgbOB6o1cmeLC0Qvyyj15Nrdw/KCyLN27ey2niMyvO8KVtxchhdeJqekCUswJx4H5EQ7v9JT4gPZy7sfnT6haQOvH1hT8hWglJGCtp5iyzUOJNmhdZId0eZFMf/J46wRlDxZJtxdYgsInExslZKbcVRajfJ5Ei9hDCYKcjamaR/8pOIEUYYYYQRRhhh5P8jw4F1hjccztXyCanBqxCbtXUfAAAAAElFTkSuQmCC",
      wma:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAZlBMVEUAAAD/wAb/wgf/xgD/wQf/wQj/wQb/wQfEcgX/8+DflgbzsQbUhwbGdQXYjAX/yzP/3oX/3H/PgAXajwXwrQbmnwb8vAbspwbpowbjmwbLewXJeAX3tQfRgwX5uQbdkwbhmAb/xyDFtTbSAAAAB3RSTlMAVbsIuT6drnBT7QAAAmZJREFUaN7t1m1zmzAMB/A+LHNmjLvxFCBA2Pf/kpP8V1B2e6Vu7u026641LkU/yXa4PJUo8XFxerHE59d3Ic/OFJ9ecyKqZEbeoORFvn6Dkhf5IkpeRJWMiCoZEVVyIqrkRFTJiaiSE1ElJ6JKTkSVnIgqORFVciKq5ERUyYmokhNRJR+iynMmRJU/jnx/+zUMyPujIAUpSEEKUpB/DzlTLDS2NA40Rhp7V505RiQa0sQ7iZkmnQ1p6JGLjN0xAmmR6PKI4NbNgkjlNNYP4ybIjES3n5AJd0zIhLoqqXxBBiC8jmhOEJ1VBgRrEZwb+clGpkCkNbedFdGZCdm4dFmSGo35A4nOwde0Pf8f1WNAZBMGF2QRWhyqCqmuDueuViTQjCtaTMiakl9xZjEDEmTpZ1z64zhHXtPJhHBZlwWV+4Q5ILFJqfjWDkTWrmdpNSE9l8W1tVQxP94IEvz9SDT9gUReqdTvZkE6zr8j0zV1IMhKd+qU1k93ZMBGee7HgqTeI0GceOIfQRpeuy79OpaLO44oLFgQ3th65sr4ZPIGCTJzE3vF7XhBcPhwJOvBgsRzis41uNgOZKQeey79Jgi1pTFakB3PDKlMrluQOn1QA2drBemUINuAyEu2wTmj2hVxq7QWBfGPSG1BFnmty7vk9oDs4A9k5gY8R82bZ0Bczamm+0WvCFgviEy3YyNbC7Ji3+UtXimCje4OZOK+9D15tSAt9l0vFGmRSpAmDbrGnQG5hBDicYEcgYLGLoSdholmoxsCRecQkf/0V31bKUhBClKQghSkIAX5z5HTy2/H6alEiQ+LH2wWrAVqXSpiAAAAAElFTkSuQmCC",
      dll:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAY1BMVEUAAABOt6tMtaxUq6pNtqxOta1MtqxMtq1NtqwAaVzg8vEVfnENdmkympAul4yi2NSe19JrwroQem0kjYEchnpErqM3oZYhin4EbWBCrKE/qJ4YgXZLtKoPeGtpwblevbQtlopek779AAAACHRSTlMAVbsIuT6dVGARlPYAAAEbSURBVGje7dbJTsNAEIThLBjGjM3i8XhNgPd/SjoZUAlxSjJlRUn9l+4+fQdbsldKLVexOaXH7VnI2p3Uw5aJQCEjH1B4yOsbFB7yDIWIQCEiUIgIFCYChYlAYSJQmAgUJgKFiUBhIlCYCBQmAoWJQGEiUJgIFB4C5YmHQFlnRT7f/5cdQUiIECFChAi5YaQqDw1NiOmu7arcby92NXmQVOAjVk9F5tAfrY6J1DZ7m3s2shtsmciI87Z8sZHWlsBGeltaNhKEXN0zmZd4u5q0UJFYWpGLRG/TOyJS+X1pDdMPMvjUaAiumOV7UrsjgiZD0JgBqTpHQ1p/aA7dLt2dR+OfK17534oQIUKECBEiRMh9IsXm4oqVUov1DYcdt3zdZD7tAAAAAElFTkSuQmCC",
      wav:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAYFBMVEUAAAD/wAb/wgf/xgD/wQf/wQj/wQb/wQfEcgX/8+DUhwbIdwXgmAb/yzP/3oX/3H/zsAbdkwb3tgfuqgbLewX8vQf6ugbqpQbZjQXknAbOgAXoogbShQbWigXRgwX/xyAoi8qsAAAAB3RSTlMAVbsIuT6drnBT7QAAAjxJREFUaN7t1ttyozAMANBeNhsvuLs2l5gUyP7/X9aSsNSZPtmtOp1WekGBQcfIgsmdhcXnxemhJn4/NiH356r49aiJiKKMPJGii/z9R4ou8ocVTYQVTYQVTUQUTUQUTUQUTUQUTUQUTUQUTUQUTUQUTUQUTUQUTUQUTUQUTUQUPUSUeyVElA9H/j+9jQqkPQwxxBBDDDHkWyLJOXeDJB/3fJhdjgteCjnrMbvASU83dDmdqhCpNBz3BqnhoXTA9DlnG53tcxqrEFl5enXszlzZRfZ6XpRLFQiXCseyRzhiY+jZ+KkCP9QVsrkWWfJNK7XaXelnOh/lpF89XaXrW83Gcy1PVdxSHgxiyx3Ca6X2DskEWjUy4u0XB/FM2FwmaunhHMTK85FjqEYGKI4UlIfSUjYtUJJIyhJuUxXC7YamwTEAtuDpHaZt5ebcaOsiDFwDssEad+rNylVnfKSBt9lDddqysQGJcN+Ua2ctxlIkUdGpvP8B0Rl7Wodw8z3UzsDWlU1YSAN05a5eRnxVKxFeI1RIzvUTDRFPWcLZY9VDN1uQ2R2v9kDJRoPNgRhxHvevAcG+03p7TOKxURKpDPGth8U0Ibs7vuQbJusBSyzHEGPENgQaTbvMH6uALMTC319PyNiGJFc+87wDnt+PmQsHQuY2ZKB9l4Teuau8q5EHDga4GuG7d06KFqSZEw8x0G1I7LpufZ2M+ViWHCAfcKwx+7L/VgwxxBBDDDHEEEN+MnJ6eHec7iwsPi1eAN4UqYKopgjTAAAAAElFTkSuQmCC",
      shell:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAqFBMVEUAAADP19vO2NvQ2N3O19vO19zO2d3P19zO2t0mMjjP2NyXoaYY//8zP0Udra+QpK4czM3L1NkkQ0klNz0a4uPDztO/y9CarLUgfYElPEIY9PQb09S7yM6su8KgsbmesLiUp7EjWl8mMzkY+fkZ6Oi8xcq1w8ocw8Sltr2WqrOcpaoep6kfl5ogjpIhc3cia3AjX2QkTFEZ6eodu70dtLYds7Ufn6Ifi4+96QqzAAAACXRSTlMAgIh3/jJ4dERAp1kSAAABQ0lEQVRo3u3YyVLCQBCAYdBhsROZ7CGEbCKyKri//5uZ1im5sJRmWhOq/8tw+6ro6VQqLY7juMbX6V1qqdc5YgjQlDisdEFb3YNIWx/SPoHYgQ+f+YGgQsa5lKldWpmUi4AGsXNZlgDM8VwIEiSQWAiQS8wnQXyJpQChxGwSRKSybAxwh+ecaPB2EmalUSpZmIhfI3XYE0Z+gCyvK7c8iRhXlTMYYYQRRhhh5D8Q9y+Q2dqlRyzzdnhDj5hmvCVHsOdHagSbvEWESKEUHA3hnjx4iom3hMvovo++FIt0450VNYIVHjniDMj/LnetRjIaUiG7y/XikF3hV0XEBfnGP31vYjTY070GZLKKdpfA3JNVHZnh05EW8TZ40CIbV/04OpMmvEgwwggjjDDCSH2RqVG5aT2+cJ8H0r/QVr/FcRzX8D4AlT7XtbfurrMAAAAASUVORK5CYII=",
      angular:
        "data:image/png;base64,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",
      zip:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAclBMVEUAAAD/kAD/kQD/kQD/jgD/kAD/kQD/kgD/nwD/kQD/4LL/y4P/tVL/v2f/vWL/oST/zYb/yoL/u1//xnj/lQj/3qv/153/tE3/z4v/s07/rkL/pCr/mRL/0pH/w3D/uFn/rDv/zIX/pzL/nBr/sUb/2qNAsIUWAAAACXRSTlMAVbu5CT6dVAhJNunGAAABZ0lEQVRo3u3WX1eCMBzGcbWspvwpGEiAQmDv/y22wcUTCRe2PZ5j/b438+xiH5gTWUnS7dpurunp5VfIWl3VwyMTgUJGYig8JIyg8JAdFCIChYhAISJQmAgUJgKFiUBhIlCYCBQmAoWJQGEiUJgIFCYChYlAYSJQeAiUZx4CZe0VqePLtEdkOUEEEUQQQQT5y8jH7lsnpQIzvJn513Emy9OOjthS7RWJJggUV+ScjKV2b+opsk+SKLdK54SgwqwVqCnybkZ9xK24Iq1ZKtcziDqbD59eEG13pVVzSLUzeUEas1ChuEidmYXiecT6uQ/kNPxGLpBA67q0fugBqYbj+xNBWe+E4Pg2ahkplTtSDsd3ETl2yh3ROS52iqRBcCh7L4/6xF6tmkMO3v5Pent8KjKS4tlEQ6rhu92Phb4R3Agq7hlp9jZsV2uGxMxHZmzv6m1FEEEEEUQQQQQR5D8i241z25Uk3awv7GzNeHfPQK8AAAAASUVORK5CYII=",
      doc:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAflBMVEUAAAC6acm5aMjGcMa6Z8i5Z8q7aMi6aMhKFIzz5fVTG5DGgdHbseLZreCeU7l+O6iGQaxaIJVQGZCTS7RNFo2zYsWwYMOrXcB5OKZ1NKNeI5djJplwMaFsLZ5nKpyCPqpXHZOkV7yPSLK3ZcabULioWr6YT7aKRK6hVbvBd82Na2eCAAAAB3RSTlMAVbsIuT6drnBT7QAAAgdJREFUaN7t1tt6qjAQBeAetnvcdFcgICdBARHt+79gs0LDfNqblnTaXmTdqINffjKBwJ2Pz/dl9fCZ/H1chNzTp/LnUR6BIow8sSKH/H9mRQ75x4ogwoogwoogwookwookwookwookwookwookwookwookwookwookwookwookwoocwsq9KALly5GXp/f5IOIWj3jEIx7xiEd+Atma0HWy5Bwl2VVp64IEa5O4yHm8MjW1JreFQ5WavzghSBrZaVS2FHSEXAL7l94NQcKpsudKfNS/c8WFYTmyr3fpPESPUy7GPkYFs2tQCIek1p/VcmRDlLfAUECzetu1Vh+xGIHduCC0wViZHhtdImRA5UTn6YBOiJY6IYTOJ0Sj/qgJOa7NnMpZBde4IWjGYVqSgsiyETW2j5R1XXdyQ3b6S4nTNZZlQ1vnuCD7abCIkWpGCo/cIHawM0bmNUm+EOGrK+F1VubQ3l7THOf75IKbge+TnOq5UCilGuc7Ps300HoXU9gXzZwUFsluWQ0a54J0se1KiS/Ht92sxNR0OjxVzFwXI3HVYiSVo3BKsTGWjULp8rZYbdKNWJxg6/g8UcNUiW6eMOOaE5EbUue2FKVTJQ1v1ZqWIYcQuX5tyMNdG1ThvBludoZoe9lXomxIxtMvf+/yiEc84hGPeMQjHvmFyOrBOas7H59vyysqPq3N7q+D/AAAAABJRU5ErkJggg==",
      file:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkBAMAAACCzIhnAAAAJFBMVEUAAACQyfmRyvqPxv+Py/mQyvuRyfmQyvnh9f6+4vug0/qZz/ohWhTlAAAAB3RSTlMAVbsIuT6drnBT7QAAAI9JREFUWMPtzbENQFAYRWFb6CV6O9jACiaQSKzABJhAYgTT+ZsbjeC8RHdP/+VkLrWmuK19IPlwW19BEtWUbLGBZI0NJMscG0im2EAyagOINoBoA4g2gGgDiDaAaAOINoBoA4g2hGgDiDaEaAOINpDEpqNk+kyOXX0mVyYmJiYmJiYmJiYmJr+QpnipzFxiJyWDEoYsQsYkAAAAAElFTkSuQmCC",
      tar:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAdVBMVEUAAAD/kAD/kQD/jwD/kQD/kAD/kQD/kgD/kQD/4LL/vGD/skv/oSP/1pz/v2f/y4P/qzr/z4r/lgr/3Kn/0ZD/2qP/r0P/pCv/nx7/yHv/xHP/3q3/vWX/qTT/mxT/1Jf/uFj/tVD/rDz/wWv/zIX/tlH/2qW/7nVbAAAACHRSTlMAVbsIuT6dVGARlPYAAAG4SURBVGje7dbbcoIwEAZgD7UlCKIcBQUpat//EZvl4C/TK3HX6bT7XzhrmMlnTDY602hel9XikbwvJyFz56G8LSURKMKIB0UO2bhQ5BADRRCBIohAEUSgSCJQJBEokggUSQSKJAJFEoEiiUCRRKBIIlAkESiSCBRJBIocAuVDDoEyZ0Uq72fYEQRRRBFFFFFEkT+LJOY+nw7Ft1XWP193Dw5JnrIie6o2QIbEFSNSU+XfEGQ3Faldm8jOkFOR0VBsKB4Q33WPJxprJiK3TdgObyrTxgVCKwhJKRgQTHsw5jRGnJoKNuRiTHS2A/sxktLWcyGhXUW+tQPXMXK1RcCF0Cdeh8PUQGLs0/NITt9UO2U1IKemSS+GxpmQMDImcRyX1tMhyNFhQrbdSS1pB4DAYEEKW6bd9h/CERKFbMiXQZoeib0sojuHC8nMXQqcLmocnws53iMRkPZmLpkQqgp3uDRL9MkOvfgs4hmb8NYvZyApX5/UuKBo9gRI+8Oz4UBwd/S7kAFxcYqnIUUQBBm1e9AXlNzWqVPa17YLK3pW/uJ/K4oooogiiiiiiCL/FVktns5qptG8LN9EZboIaMmx3AAAAABJRU5ErkJggg==",
      otf:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAb1BMVEUAAAC6acm5aMjGcMa6Z8i5Z8q7aMi5Z8i6aMhKFIzz5fW4ZsbGgdGJQ65+PKjbseLZreCmWb1lKJubULiUTLR5OKZ2NaRoK5xuL6BXHZO0ZMWgVbtgJJhbIJVOF4+tXsGpW7+HQayDPqtRGZDBd82cvnlEAAAACHRSTlMAVbsIuT6dVGARlPYAAAFgSURBVGje7dbbToNAFIXhHkRBCspxOFPR939GZw8k60JNWnBVjfu/6b7aX8LMJN1p2u3yDtd0f1yF7P2rujsyEShk5ASFhzw9Q+Ehj1CICBQiAoWIQGEiUJgIFCYChYlAYSJQmAgUJgKFiUBhIlCYCBQmAoWJQOEhUB54CJT9tyJvp49diGxLEUUUUUQRRX4QObftyEWauA5sXe7bOjuhwg8D9LIeGftgqQpZSNhjS8lCJrcsy438tn4U2+TzGRmyGSljV7sWCWXhJFMqH0yGeYzcNCPJxoNv7Y6hkSmz0ysHieyO1E2NrDtTkBgfabBjRkEKd6lccjr5p0ieSONqpHQX1dV/hSxVilx4JpmU/O7bJe+kY78TvPic9OKlejmUppOBhESyJZ3i3m1jIJLBJY19FtJUMEiIlFV1MNQlVhXGmHxBjG38O3+JFFFEEUUUUUQRRf4d4h025+007Wa9AxG2uzcZlFo0AAAAAElFTkSuQmCC",
      ttf:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAY1BMVEUAAAC5aMi7aMe6aci6aMi0acO4Z8m6aMi2bci6aMhKFIzz5fVLFYyBPaqcUbi7aci0YsTGgdGkV7zetuTXp9+qXcBSGpFmKZqmWb6ZULeuX8KWTbWKRK6sXcF4NqXAdM1sLp6fGft1AAAACXRSTlMAu0BrzBEvpg42dNklAAAA9UlEQVRo3u3WyRKCMBREUWcNIgJOiKL+/1cKkbIr5YbBRtS+q7zVeVXJIgOlumw2rNN80QgZmVpNpkwEChmJ1lBoyHYDhYcsoRARKEQEChGBwkSgMBEoTAQKE4HCRKAwEShMBAoTgcJEoDARKEwEChOBwkOgjFkIlHcj1+i1iki7mAgSIkSIECFCPoCkvlMQuvPJBD6KmyKeUxC6c454qNdIuCry8i7FITPunFjEXz1K6yPIrr8zCGtbZG/KhPQHSWwhEXl2FlLtTo627AdelxAhzZFDXmpQMZdonB9v3/BbESJEiBAhQoQI+VdkNmzdaKBUR90BbhDOvKefx90AAAAASUVORK5CYII=",
      raw:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAflBMVEUAAABFiv9Eiv85jf9GjP9Eiv9Eiv/j8v241v6cxP5Okf+hxv5jnv9fnP9Hjf/Y6/2z0/5SlP+Luf7d7v11q/7R5/1upv+Svf7g8P1Kjv+szv6jyP6Bsv58rv5oov9Yl/+ny/5xqP7H4P2Gtf7g7/3N5P282P7D3v2Zwv6Wv/7KXhRkAAAABnRSTlMAVbsIPp2VTiuNAAACa0lEQVRo3u3W6XLiMAwA4JayMkcwSQgk3EeBhfd/wdXhRJ3ZX5iK6UytmWJhSL7alk3eUqR4XfR7j8SfjyjkHR6K3ocloooxkolii4yHotgiThVDRBVDRBVDRBVLRBVLRBVLRBVLRBVLRBVLRBVLRBVLRBVLRBVLRBVLRBVLRBU7RJV3I0SVb0f22f/hH0DiIyEJSUhCEpKQlyMjCQ9fYyk9IVtS0rUYDyMuxHw9UWSAHRvOSsxybPfYrrCdYDuLRejabTe6M9+aYoHZBdsK21No/0YgqrRj2fI7np0Cs8YD1NS1lJEdopBhWedOr4YVmxXnc8z2APz5Th6PyiiERjDEdipdfuqUpOU5iuU+5e0iGplQMurWoUGS6+vG/3rB7FqwIhoZuXC5TAn97dr1GZPLK76kOoSnRtJAuwynnTyLSv8ASqkMz+9iESmfK/dkdH8/k9IFf6ZkhbNHX6QKvsUhm0V1P3f7785rmwccTlTDF5nADY1oG4FoXKXnRPPCE1S39UyTd5ziAMdCxyMDqa297PYsbG3WqL4LHNsVK/jsn0E+paMM6VR2IRypoGgP3fGFagJi1yR33dVX2pUYTcCKME6oJDlEIhPeB7IvRo3T4GqV/X9rtTIagUs4ymHjvkQzkoNFamrOySIeqbE5FyAn4WBNMQvlOnThOzknRTxSNFKyS7p11h2Nq3Zss/a4n0IsEkYw91Dpfepw78yFaj6GZYpHKvkJOfAu4dg5OeU9DXLd1tkwBhlg0HbwOSY1rPA1nBuePqIiPmBbYcsfHn/sI1FCEpKQhCQkIQlJyO9F+r2no/+WIsXL4h/7jJcEpWZxWQAAAABJRU5ErkJggg==",
      java:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAABGlBMVEUAAAAAa8UVZcAVZcAVZcAXY8cVZcATZMITZcDuQjsVZcAVZcEUZMAVZcAVZcEVZcAWY8IWZsARZsEVZcEUZcEVZcAVZcEUZMAWZb/1QzYVZcAUZcAUZcAVZcAVZMEUZcEWZMAUZcL3QzYVZcD0QzYVZcEUZcEVZMAVZcD0Qzb0QzYWZsDxQDgUZsL/Ri70QjYVZcAUZcAVZcEVZMAUZcH0QzYUZcAVZcD1QjUVZcAUZMEVZMD1Qzb0QjX0QzX0QjX0Qzb1Qzb0QzX0QzYVZsDyQzYTYcH2RDXsQTv0Qzb1Qzb0QzX0QzYVZMD0QjUWZMAVZcD0Qzb1Qjb1QjX0Qzb0Qzb0QjYVZMHyQTT0QzX1QjbuRDMVZcD0QzY9RbGFAAAAXHRSTlMABPqY9geKGjMBqndL5pFDIhYQwLvbzqE59ul9cmpcViomIe/txq+mnIpBLhEMBtfW029gPvvhtamFZlNPOy/Bt5NuW0cnHRsM4NvPyLOdgt59YkjovHJjE+SxD8caSAoAAAR9SURBVGje7NZLroJAEAXQO+0lMCVMIJ1mZMJARCQE/MTEb/zk7n8bz6Z9wgKqHHkWQFF9q6Hw8/OjxVh8QYMvSFvoO9TQV58N1G3ZQtuCzKCtIOdQNqd+kTghGUOVzUkmBprsji81NHU5vQUUxRt6BRSVCb1IM/Ym4mCFwCyO+8vKQZBJGTwMXtxpn5DrEpJcwSC3AOI0GcLpIelWMTjHgK1nQzYNRMU5g2QBnO6hpVa4xppBVAIrDpZPiOo+NbJPjdpAlKsYzOZANqOXQtiBbw3gNlT5eHURgyuAI73KQdiVwR4v1XBsLaRdONj0ANyQyBbicg6ysEN4O4jbTh5c0lNYu4p36mMnLCEtDNQJnovCbYc0G3FcggqtVtIwwJNQWEGaTUhGT0xbySBtPvnpdolSKtiTzM10DmYW0txljB5LpfOCzcd73tJrIC9ejy9fhXujoNtwZ8aRjnpo6LZsxiIpdPSPe/+f/PoGKX/t11uPmkAUB/ADw63IRe5EELBGJTUm3qpR3xpjmjbG7VNfzvf/HHVg2SWl3XXQx/29TUTOwPkzDLK5ioxgbJji8x7yV9H4r3Rj9ErZqS45cNBCN3Z7eKVHXXjx5XtxIT8/10r4WPBPwGrqYGG4Ehvbih/faq8TTrazWMeruc1aQ8DSqrlf/fJcwlLSXaAAZRdT2gEbgs+ErdE/mOG0Sw2U0Dym+45E1NETncZGgZLdoyNgs8RbuBZUDDq2gQln8PgevlMLVIxXA2A0kOb4X8MRWZoW1Eh4JQM76xgbE2fRGwpFd3pPvrPNL3ttakHDiB7BQUtWmsH7MrxyoJ0s4L1b5hfQIr+hlT2PqFvQxIUK1KxpDU+ENtZI9S5h/e/cQOtsh8gbM6jMPBq2NbRywYruqBNCiOqOvJdsb7Sq7JbWSKCdbg/fFJVrM6GXq0FbFhHwfzyjbAuXXweBBXew03yDDfOg3636MUYhV+BuVphEgXp2Hd+dkF2cTms5GJwniQ13E5MgeuNXeITwCVH668TH3EvggQZF59XfmcUBiNZU6xO/CPFZhoch+OKvoA2Te/ugrDqXzkqhS/h/CRrcIcuHWJrIto//pu/keuciDlhwEo8FJzqYmsj1/1FmYZgc1A3QZapiPJ9nCpVTIo2dhS4Me0/eaHJZrWfwtwSxz1BDxpICDGSd5vx2U6TYJramK0/KEiwdC/xuBjf5dNzilc/UE42vIqoebHjH7Ch5ZQtlYKINa8ttvtQG4j9DeDKX+aic0Otr0r65lkV4rOP1hTsh0q5Tksjk7Ov4SggGVZI9mSEtnRHeiN8mL81bDUfARO5PPHyH4EbmazyyLaIJzGxzaYwXAjb05i6Jj916oLr0HsfQmihnoZamyX6/Tw/mWpG5RgrMMb1zS2DGiTceF0rll5YCLcha/FsR3y4w3as9pDZLEVoKpbk3lvpaZjf6lWkxGVX9clYi3KPbH+vlw+K4Y5U6O/5GqGcsPsEDnA7SeM5jA+8HnbUID8R114d+ZBCSqwGRomUanjj48OHDQ/wBAue2YPqQmeQAAAAASUVORK5CYII=",
      py:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAA/1BMVEUAAAABd73/wggAeL4Cd73/wQcCd73/wwX/wQgCd73/wQj/wAwCd70EeL0Ddr3/wQf/wQcCeL3/wwAAcrr/wQf/wgcCeL4Cdr3/wQYAd73/wgL/wgD/4AD/wQcCd73/wgcCdr0Cd70Dd74Ad7wAd70Cd74Cd73/wQf/wQb/wgf/wgf/wggAd74Ad77/wQcCdr3/wQcBdr3/wQcBd70CeL3/wQj/wgb/wgf/wQcAdL8Cd73/wQf/wQcBd73/wQf/wQYCdr0Cdr3/wgb/wQcCd73/wQYDd77/wgYAerr/wQf/wQYCd73/wgf/wQb/wgb/wQj/wAj/wwkDdr3/wQcCd710CQFgAAAAU3RSTlMAqqoy75PBM+77zBTMQlU2wZMMBfKKdW0rGBEGAvrq3o2FSz8O5tvSoJdpYDcl7dO8trSvooR9TEMT9efZvK2km3x2cGNbTyYd88Wjm3pVPyAbxlnrk48AAALFSURBVGje7ddXd9pAEIbhj4DtCBOU0E3vBoMLxjT33uOS2f//W4LA5ySOdlcgDzm+0HPF3XuGXYEGHo/HI1X1hy8TpWKxlLisrIFftFw6you/5bsJ3pB/LyAkjD2+TPRUqATKXI0joWYwVc6ETmCTZZC80PKBQUU44BglKSxGqCYUkgyRkhjrjIBLQ0jtMUSK1oNXnX6S6jBEfliHqzudZaZIB5byYiP7kxvUXWxE1MvVzQex4MiEF/kskVu/Td0WSQff7DQHGbDYtkVW6Y/CYNGRiZ//I0IbcLQWLp36dAJOkVwKetfLwpFThHb0UxwJwRAhE2qbNcETeYTSqC6YIrEMVHyCK0LPUGgLN3y2iPZZeRBulACkbJFjyEUDwo02gKEtUlC+xrkRwtg52aQhlRAuGH6MBclmyHe3jDBsR6L9/XLxkOSvYdklux5kqvOPcboGy4AkmpDxCx0j8F5t25ecJvCyRRINyITVgW74NgqVl0OS+aLYERR8t9AwD0iqMc8N3r+GRnopR3LNOXbDfBsq2ddBI0Yq/dknMSqYiLROggdf38uRTmv2M0lME/EYzcuc+XbVJ5dqpUBzy2Vm/jcJY8yM0fzWITUSNgFrkNUDcqEBuZp8sW2QGxeQ60pX9HSO3LiB3Jn0SK6ImI5Esd1+A9AnN1pQGBmyyJKrQbJQ+cUViaWglGSKxIZQq+6zRNZT0CkyRIKtLLSqNcfI8ReNx97VDRy1DadIFh8XNngiev4QU0SvUuyE3vjtEXPlXzf4MOfb9d2LfJbIjhkx7xccWc8AiBQWGzmHJc4YUS5SfaZInKR2MZYNWofDELkguXgGmeY093HPpBAL3tl2BLcyW6S3AQZ90nsFg8gh6ZyARUr3hR2ugqlSIJXdNLhE4nckkTsegs9kZ3w/ztZ9/CkNfhHz6aIXX+qdb1yZaXg8Ho/cb4WcX1psRI9MAAAAAElFTkSuQmCC",
      xml:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAaVBMVEUAAABOt6tMtaxUq6pNtqxOta1MtqxNtqwAaVzg8vEUfnFDrKJIsacYgXVrwrqi2NSe19JHsKYmkIQCa14umI0rlIkFbmFFr6Q9ppxLtKogin4chXkMdWkIcWU1n5Qxm48QeW05opdevbQRyyfXAAAAB3RSTlMAVbsIuT6drnBT7QAAAeRJREFUaN7t1utuwjAMBeDdmLu0u0B6L72w93/I2QnbqbZfQIymzUeIWkj1pyRWxI3Fcr1s7k7J4/1ZyC2dlId7TQSKMvICRQ95fYOihzxBUUSgKCJQFBEomggUTQSKJgJFE4GiiUDRRKBoIlA0ESiaCBRNBIomAkUTgaKHQLlVQqAkR95ffiY5giCGGGKIIYYY8ieROeNUUpVSlVw8SzFSzC6TFFzlUmzPQmjPr+6lWKR1FxBJTiFLCiQuoD32qCggsZQUWRKkG/ndnqjnR10AeSbJlAahKnTvan7sCEjdSd0nQkL7UgbAb4HIFnL2lyMYoMWFTftCfFxWI2USpKizEN8AcfyJA17vL0WwlLAQIDs2O6KBByAR0viA5Ctk4p8ORCOf1pgGicc70hpxvJrQt6nTIIcsZFohc8XDQKV8+TSIi8iyQkpu6YuBl9OlGeFWJks25QCkki2c+Dja4lIETYde5nY1XdSHOR6pSYK0GecQvlsgx4MaKE+CDPGuX+RSBCK3DWdOg+RejgBX/hGJD198Q1zMdCLSHy+UQrABSFAdrRGkOg1p/Oc2DRknB9JIszTI7DhhdlupSi52/JxFdS5ny3EE2Tpk+oX/VgwxxBBDDDHEEEP+M7K5uzibG4vlavkA6bipSuoQS3IAAAAASUVORK5CYII=",
      rar:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAeFBMVEUAAAD/kAD/kQD/jwD/kQD/kAD/kQD/kQD/4LL/v2f/oST/2qP/y4P/vWL/u17/pzD/wGv/lQn/3av/367/s0v/mhT/qjb/uFf/rkH/nRv/3Kf/1Jj/0ZD/x3r/153/yn//xnb/w2//rDv/pSv/tU//zon/xHP/xHJhqd3gAAAAB3RSTlMAVbsIuT6drnBT7QAAAgVJREFUaN7t1tty4jAMBuAelhWkwa2JQ8ohEMKh7/+Ga7nO/pPdmxZVnU6r/wLkDOMviRWHG4vl8zK5e09+31+F3NK78uteE4GijBRQ9JDZHIoeMoWiiEBRRKAoIlA0ESiaCBRNBIomAkUTgaKJQNFEoGgiUDQRKJoIFE0EiiYCRQ+BcquEQPlwpC7+zxsRWQwxxBBDDDHk2yIP05T1drbCwW080o/f8YtdtxQinCpQTs3DFyBD9l6IcIZTDena/kUYFiCdc10Vvzf5WJlmfASyde4pnc3qeoSne8YcvkrIExAu63UsGhlCi6FIXhztxghdYnEQIru/i9LGJpjHUTFGXCwu0isZpvWxOh/jyI2RQyzmMmTJTewpVw1LmxHi+ZfP1yOu7xu+kJaGMz6mDlsNSNn3Ycsr5cXPyboejiyIGr6eVwQJJEV2BXF4NfZERfw6j5HqRGLEUQr3Fc/Gj0U9QjYkQULBMz144mymSMhIWyzzHiDprrrKrcO3CSnRXWe+izKEWt6heNyA4J7OCLYdCfLIcxzzq6R1nPxcZIR4OJMgeSk6ohonfGAOiOMm9zLkxHenpsC9TNgn/YC8LluQIX6RurjEVpsuaom9a89dfB3SlWVZpBWPxYX28XN4Qb7EOlCInyceHsuY1df9t2KIIYYYYoghhhjyU5HJnTiTG4vl0/IH8hin/lpU9H4AAAAASUVORK5CYII=",
      javascript:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAqFBMVEUAAAD/1QD/1wD/1gAAAAE5MAHUsgAFBAH81AAQDQHcuQDMqwAJBwFgUQEiHQH40ABVRwEXEwHxygDqxADivgBaTAFBNgH1zgDtxwDfuwCUfQB5ZgFOQgE9MwE1LAEqIwEdGAEMCgHzzADmwQC+oAC3mgCojQCaggBzYQFwXgGwlACHcQBoVwFHOwEwKAHVswDPrgDDpADBogChhwCMdQDXtADLqgCBbACVKPu6AAAAA3RSTlMAgEC3KR0FAAAB2UlEQVRo3u3Z2XKCMBQG4GqihAjIpoD7vu+17fu/WYWECNrexOTCmfNfxcTxkywn4/gBgUAg755qRVmq/yIVpCwVQAABBBBAAAEEEEAAAQQQrUjUyPJV6gwonahE6jhLTXT417aV9ozsizakY2KRfaIFITYuxmvoQLq4HC9UjxwN/JC2eiSfLGdf41wrUo0QvujLW3vaS7G5+jUJ+bdne6BtrCdIPdJg7SsbSb61nJMja+/EoA4kZm2rrhNBQ/bCXBKNiDiLTkdfgQzGOI+5CjUh6BPfY9ihHgRtcSHWlmhB0MIsMv1YC4KmtlFQhr5aRITurLviqkZE4q0nlLNyRKQpruGWBkRkeuCX4wtIfqLPDwgV7zhhFl8WCVrDJt+ypWs2cK27wieMyiEknXCXKXZxEy08jAdRvix8K0+lkMYApxnMCGou+Set0sfoZc1e+RkNIoUMRXUaiXO3YTVY6Dd+zA+93MLP8VOsdHX9kSjBB0fwHTkErZ+QVdY/M555J5JEiIvLGQVPlZ7HukiXFVJ+FvOUD2zMsjGev1KF506hnif3/qRVNHrha/cJ2bheNuf2rDyQ/LTH2UT1u1TFzejTMPpzIKY0frvfjIAAIoFo+FsWAoFA3jy/zd9WWtgjjBcAAAAASUVORK5CYII=",
      hex:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAZlBMVEUAAABOt6tMtaxUq6pNtqxOta1MtqxNtqwAaVzg8vE/qZ4UfnEjjIFrwrqi2NSe19IbhHkkjYEfiHwPeGwYgXUJc2YGb2JKtKpDrKI1npMslYoDbF9GsKYxmo8nkYULdWg4opdevbTShbprAAAAB3RSTlMAVbsIuT6drnBT7QAAAXhJREFUaN7t1ttugkAUhWEPtZuKtoKonLHv/5KdPbtxxfQKyjJN3f+FM0HDl2GAuPC8x7VZjel1PQlZyqhe1kwEChnZQ+Eh7x9QeMgbFCIChYhAISJQmAgUJgKFiUBhIlCYCBQmAoWJQGEiUJgIFCYChYlAYSJQeAiUJQmBMjvyuf/ZCGR6jjjiiCOOOPJfkV2SJIc42yYhm6BC5KpjL6FKZzUFkWMYTxIqwuR8oSC2gKtIa0uaEdllsU5Cg/2mD0PTzomIoM7OPqgtLORy0g2/KlXSEKnDgUG3PRcecjknVjkdGXKtuEPyWCVWb8ZBpiMIiJXdL2VLRSRN8CBOQ5pT7A45xmoJwe2EuPFSGDKQEHx1xlIoyEHfYpleRB5SNuFAVSb6SUNyu7NSLGUmJLX0Hm4bu5m7+MqfDUGpiGQ6Kb+fyJSDtLdz7/DUj0PqcE162940dJvgclU6VlHXWf1X/6044ogjjjjiiCOOPC2yWf26zcLzHtYXOWalpWSMI00AAAAASUVORK5CYII=",
      txt:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAdVBMVEUAAAC5aMi7aMe6aci0acO6aMi4Z8m6aMi6aMhKFIzz5fVUG5F+O6jGgdGzYsSqXcDetuTXp9+ZT7ZoK5ydUrmvX8KMRbB2NaRPF49hJJhNFo21ZMaiVbu3ZseTSrOHQa1aH5SmWb2CPapvL6BLFIy+ccxtL6AB1V29AAAACHRSTlMAu0BrEMwvppEqA8AAAAF1SURBVGje7dbbbsIwEARQoJRuGiAtuUFuQAL8/yfW46CuUJ9CM6gqOw9mTCQfWZFWmVgsj8xiOiRv87uQmQzK65yPQCEjK1V4yOeHKjzkXRUiogoRUYWIqMJEVGEiqjARVZiIKkxEFSaiChNRhYmowkRUYSKqMBFVmIgqPESVFyoCZXTkvPqZ8wDk/hhiiCGGGGLIf0XS4CbJ8eTWJZ5UgW/bm+fZKIjEbg1rEcldKVIOkuCnEVnj9FxGQdZLJMCBKJHIzvVYJMNF3LbF35A6lGowohKQSPpsXD9F3srlmtBtNr6NhPjjl0dQRx7S4NXjtV+Eh8gh6FMxkaw3YmEideiRhIrIBfuipCJRESB7KpIHPmFJRNICAmYIEcGQ2e3dcqhpiJ+M2RrXaWhI6/q2lA5XYSElDsylH/kbErJHr67DZcdB6hBnf2vJeEgZu6S+JqgNWorWik/navXHv1YMMcQQQwwxxBBDnhVZTH+d2cRieVC+AK8ju3x99/d1AAAAAElFTkSuQmCC",
      "7zip":
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAbFBMVEUAAAD/kAD/kQD/jwD/kQD/kAD/kQD/kgD/kQD/4LL/oST/vWL/y4P/v2f/xXb/wWz/rDr/lQj/3ar/qTT/nBn/z4r/2J//u17/uFj/tE3/nyD/mRH/3q7/2qT/sUn/r0L/pi3/1Jb/t1T/yoCsVSHpAAAACHRSTlMAVbsIuT6dVGARlPYAAAFTSURBVGje7dfZboNADAXQLKXNkCmEJRCWrP3/f6xHDVykvjSNb6Smvi/glznS2JZgZrE8LtHilrwuf4XMVzflZclEoJCRFgoPeV9D4SEOChGBQkSgEBEoTAQKE4HCRKAwEShMBAoTgcJEoDARKEwEChOBwkSgMBEoPATKGw+BMldFuvh7sp8hd8YQQwwxxBBDnh/ZuUmyZ0Fy1nW1m6/UgqTsxqeCnMhIljtXybNIxpTqyPH6idigQ7E6sg2nkpFSDj2Hl40P2Uu5Ve9JmK0dyN65vlVHKkHQaC9VrT5dp+v1YAiqTB1J5NhmKLrQkUJxT7AkfTddy0R/GQ9y7Mf06vJOE8GSHIfiLMVhpYhgSfKh0RfMgCpST5pQ5lL4NKRVRarJNK3dmEITKeTAPX6tOUjjvb+Mg+bHxH/sa8UQQwwxxBBDDDHkfyHR4u5EM4vlYfkE84S0uUVE8WIAAAAASUVORK5CYII=",
      folder:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAk1BMVEUAAAD/yyn/ySf/nwD/wB7/oAD/oQD/nwD/yyn/qgD/xCL/yyf/yij/yyf/wCL/yij/yij/uxn/wyH/oQD/oAD/uBT/nwD/oAD/wR7/vRz/oAD/qgj/vBn/oAD/ySn/yyf/uRj/oQD/oAD/oAD/uhj/txf/ySj/ogD/nQD/zCj/yyn/yij/oAD/xyX/vRv/rgz/qAfeNa39AAAAK3RSTlMAqlVV4/2rWDkD/IZ7Tgr22NHQXE9BOPfl3Nm2rp6dnJKKgXx2WUw/Ly0sB6zbXAAAAORJREFUaN7t0VkOgkAURNFGQQEF53meh34I+1+d/L8mflAmxtTdwEmlDGOMMYYvnY6bjqZA4t6aibOgDTNOgajQykFUcGUsKrgSLeX7yk0+FYxqI0dR4bdsRIXf0pKy/JVZQLG/j6qQIraw4osbyTMLLDu7kKI0oMrEgbwsuLlGVhaenjLAI2uFLPDIQCE+HvGJEPk3ZIhHhgrx8IhHhAgRIkSIECFChAgRIj+LbPHITiEdPNJVSIhHQoVEfbTRj4wqQSNXReBf6RhnXfDr7h5eDyP0vKepLg2TRu2SMDWMMcYYvDcqK0d6s+l/JQAAAABJRU5ErkJggg==",
      exe:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAb1BMVEUAAAD/gav/gKr/jar/gK3/gKv/gKr/gKvpHmP85OzvOHfyRH/6aJn+lLj9utH9t870TIXtMnHrJGjzSILqIWX+e6j9d6TsKWv4XpL0UIj5ZJbxQX38cqH7a5z5Zpj3WI31U4vwPnvtLm/7bp7/jLPzdBCVAAAAB3RSTlMAVbsIPp1ULZjL1gAAAYdJREFUaN7t1tlOwzAQBdBuMCVpIUmdtenO/38jsSflIvFU6lshmPuQ1B7JR6PYVicWy+OymN2Sp/mPkKnclNmciUAhI2soPOT1DQoPeYFCRKAQEShEBAoTgcJEoDARKEwEChOBwkSgMBEoTAQKE4HCRKAwEShMBAoPgfLMQ6BMoyLv6++JjiCIIYYYYoghhvxdZLVEUsmHZ1H6+fPwqxZJl8g+EtL4V3OdPlIQbSARXbwoYyIu0zSirfRSuuHVjlg+lvu7kEKQehhncvB0NSIbVCMhh/DBc12bhZS+lVYboSHSYhdERVwa0mkrRTBc/4mctVxGOYxHncnCYCuKoFzFRLowOMRGXB7S6EwSljwDKbRcRfzwl6WmEeLuOvmD4s85Eel9Fys3PDoesvVNhHYSGlK5sLP2oZ+oiEs0rchmvOLrL1d+PZZ3dyDIVhtJr5fLziNIFwnJxrVVO8VCLgnSyml46oWy8ROlHBNk97v/rRhiiCGGGGKIIYb8U2QxuzuLicXysHwA0QemOVUpFhMAAAAASUVORK5CYII=",
      png:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAh1BMVEUAAAA/UbQ/ULU5Vas/UbU+UrU/UbQ/UbXo6va8wuV3hMtgcMK/xeaQmtSwt+DP1OyLltKGkdBDVLdjcsPf4vNRYr3b3vGapNhWZb7j5vRJWrnm6fXLz+ukrd2OmNRodsV/i85dbMHFyumUnta1vOOpsd2ep9pYaL9NXrtFV7jW2u/T1+5ue8dTiF0NAAAAB3RSTlMAVbsIuT6drnBT7QAAAelJREFUaN7t1tluwjAQheFu1E7YgnFiEsjCTpf3f76OMe5Ae1PiDKrQ/Dc5taJ8lQDBA8fdrt7TNb0+t0IexVW9PFMiqJAifVTokNEQFTpEokKIoEKJoEKJoEKJoEKJoEKJoEKJoEKJoEKJoEKJoEKJoEKJoEKJoEKJoEKJoEKHoPJIgqDSOTLr/079FQmKEUYYYYQRRv4zkk7rpWqLxNKVrYaFsEXwx+i4JrAGx6UmYwnlo2UYYp2pR+azC+Qt8rfkcSgi9f6EyN0Fsj27JW2LZMaYjYQ2HtHFGTK1J1FcJxqupi0ytqOSUGoRW3WGlHBdKRiNvTcIURpW7JF3hYh90RsBFRIqQhCxgJV4RDYecY92bytTlmUajEwcAnPxjcwschBYAJLmsD4dMsxgeqRvEdUFovoDGHnhkGQtZXSB2P9idky1QzAjTsghh5fhB5K5e6aByEB5xL5ttxSIXoPhkf1c5muHLCX0FoxkVVU1NTwHEbGBY4ek7lNqmwcgY+FDpIaLQ1RuH02CiJVDTmtNg8TfyBCu2R6G6hxRHx45aBi6rAycdIyIxCOikdh72ilSaI+ISe6NqNWXVh1F0fYcMXAQH1cCa+cOU7PQUi929R38JGKEEUYYYYQRRhi5O6T3FFzvgeNu1heMCaqMp79tLwAAAABJRU5ErkJggg==",
      aac:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAZlBMVEUAAAD/wAb/wgf/xgD/wQf/wQj/wQb/wgb/wQfEcgX/8+DUhgbflgb/yzP/3oX/3H/MfAXIdwX9vwfWigXknQbbkAXPgQX4twf8vAbyrwbrpgb6ugb1swfuqgbimgbooQbhmAb/xyD2TAKRAAAACHRSTlMAVbsIuT6dVGARlPYAAAISSURBVGje7dbrUtswEAVgLk1bVaL1RU4sx3bS939JtLodM/yyzDIMs2cG4uwQf5a0EnmQSD4vp6c9+flchTz+3pUfz5wIFGbkBQof8vcfFD7kDxRGBAojAoURgcKJQOFEoHAiUDgRKJwIFE4ECicChROBwolA4USgcCJQOBEofAiUX3wIlMcPRf6/vM8OpD6CCCKIIIII8oWR2bnLMaRXStltwflCg7ejaRVVbFePdHSL87ZilM+c310alaK7amRRlOumEu56z89wViVDNTIoyg2FWanN2Ky/ble3YHg1SBunAoW7CrlgWGHFNIa3A8EqkzOWyjkWbFyRMpc3PMoOBKtMP1NZaJr8Nt9wKp220FUl0viP0n37XLAk9vn5bVmebvSpQ2Z6bpLa3J+a5s7mXljh129GuskUOmyJhSs9erD7D0POYV4mbIJbbKLQC4cRPHdDL2W+ehpUfJkOI1jlIQ3IlUOmiwMa0h/og4hWiIkti7SEobsuPjXIqDZp0iGDLNvdMdXuE/ogMsfZQgZarXwa2Nod39MHDYWOqDUdMqEw0FVarXs+jdcKpGvL/ljj3JvUTGkIjhaFStaQoWrWZFGhlSgu3ANnbhyCedsb95ruGsI0Y1B23vzTMGmhR432q0K01rd0bfy1mfyvvPWc9rmG9uhb7w3uO3wlEkQQQQQRRBBBBPl2yOnpcE4PEsmn5RVOlr2WFeWCkgAAAABJRU5ErkJggg==",
      xls:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAnFBMVEUAAAA5jTw4jjw5jTk5jj06kD43jTw4jjz////o9elbo1+eyqCZxpzx9/H+//7K4ctsrG88kUDQ5dFhpWVBk0Q5jz3s9OzE3cW+2sC72bxZoVzl8Obg7eDN486IvIuBuIRvrXJPm1L4+/jz+PPb69zV59W11benzamUwpaMvo57tH1xr3Rdo2BJmE1FlknG38et0K+cx55mqGlMmlDVvqvMAAAAB3RSTlMAVbsIuT6drnBT7QAAAYpJREFUaN7t1llvwjAQBGCO0k25SiDhCLQc5Ybe//+/VfWaDFXFA60HCWnnIdG++NNIjp2CxXK5VErn5Lb8J6QoZ+WmzESgkJEMCg+p1aHwkDsoRAQKEYFCRKAwEShMBAoTgcJEoDARKEwEChOBwkSgMBEoTAQKE4HCRKDwEChFEgIlOPJZ/Z04IHI6hhhiiCGGGHIKSXr3Lh0/T3Tsx0Gb1CKXnh8XOq4lKJJ0dVmtstNhGAdBkMfjKm0dthIYSedu3eZ3lYkaizQQgrR05b4roh5hC7/q0tUDtxQCkjXd2gN5cO/ZlIHIm1bxW+BdKMjzkyru2U04iKwjZCwkJB7mxjxlIbLNkZbQkLThjZHwkHHeZEdBcEpqlZiF1CJkQ0Kms6PvpPHCQQY/vvgVBeng7HJYRkDS9uEU/vD3FwEZR76I+CrRJDiSDH0R3F+jODRSzy9G3PGboAiO+T2uYmzjUMgSRY6qrIIiWUOz93NLx+706v6FDTHEEEMMMcQQJlIp/TuVgsVysXwBMlak1DNsev8AAAAASUVORK5CYII=",
      csharp:
        "data:image/png;base64,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",
      avi:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAk1BMVEUAAADzQjb0Qzf/OTn0RDbzQjX0QzbzQzf0Qzb/6+76pKH4hH39ycn2ZVv6oJz8vr30RDj1T0T/5+n7rar+3d76mJP6nJj4eXH2Yln+2Nr5kIr4fnf1V0z0Rzv8wsH7sK73c2v2XFH1Sj7+4uX909T9zs79xsb8vbv7p6T5lZD3cGf3aWD+3+D8xMP8t7b5iYL1VEgPl/i3AAAACHRSTlMAVbsIuT6dVGARlPYAAAHUSURBVGje7dbZUgIxEAVQAdGEbWbYmY19V+D/v87uDJm2yheRbqrUvg/OLR9yIOkATxrN41Kv3pKX2o+QirkpzzVJhBRhZEyKHNLokCKHWFIEEVIEEVIEEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVLkEFJe5RBSKqxI2v6a7HvInVFEEUUUUUSRv460rbVvGbbIQobGZQu1H5oWPJoMyMBCDtjcku+uhUuoPcOGrBFplF43wza2kIQNSS1mEmI/Yj1iO2OL2JDYurSxh31oMbap2zg2JIcdgpUGxq99wjKBsmdDIjxgWHJtMAlOGuzcxULGbEgTV8E3MPcktsQNMBtyglVSlGKD2RSLNtwAcyELOI+Vm7BNMcR0PUZsyKi4Iyt4XIrrj+gC70vEhvSKl7yDx7kc4ugAf3LDgdCaxRvakoqbFrMhB0vpRn6IOwEOMBeCU0RJ/BC3ltZODBcSTj4jUz/EmB0bMsZdGmLwKJaZgewLZMSG4AHn5X2xMz/EQC/YkHX5yWhy3KJy4GxguJD0+vXhd6kf+iG2MRsyC4Jgm12PJ4DM/X+xuTSgz37LrxVFFFFEEUUUUUSR/4bUq3en/qTRPCwfjDq8iNZ7a4wAAAAASUVORK5CYII=",
      html:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAZlBMVEUAAABOt6tMtaxUq6pNtqxOta1MtqxNtqwAaVzg8vEGb2ITfXAVfnFAqZ8tlos9ppsznJJrwrqi2NSe19INdmkfiHwpkocCa14Jc2c5o5gYgnVIsqg2n5QjjIFEraMnkIQRem5evbS21sD5AAAAB3RSTlMAVbsIuT6drnBT7QAAAXBJREFUaN7t1stuwjAQhWEupTOFXKAldu7Q93/Jjo1gVKEsCD6IxfwLPCQWH5E3WVjW69qsHulzPQtZ0kN9rJGIKmDkoAoO+f5RBYd8qQJEVAEiqgARVZCIKkhEFSSiChJRBYmogkRUQSKqIBFVkIgqSEQVJKIKElEFh6iyBCGqJEd+D/clRKYzxBBDDDHEEEPeFSmZeUuxo4x7qliTG1uWWrp0ZmlHOUtpEd3QeSTCJYV6ToU0zrlWplrW4oo4Cg3JkFARf0u6ItllAxbx8UgYiXjmRsa9TDgkYz7JWMk0H/FVbDuFOObz5U+c5iLaFFJ69h2NQhU4JN8x9+Hi8AxSx/wk4piHcCRNgTv4XDYdqWbfIZHw2YRLUKSV78wnLFJwqMQiI0uesAjVsmT/kCxWpkQqWZwit5qUSB+OZDaSyzO3FKtkbOLUyzRQrJVxJOpk1+3GmN0q3+dtxRBDDDHEEEMMMWQmslk93WZhWS/rD702qQKJu8/ZAAAAAElFTkSuQmCC",
      torrent:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAQlBMVEUAAABMr1BLsE9LsE9OsE9Mr1Bxk3FMsE9LsU5NrlFMsE9NrlFMr1Dc7chwvm6i1Jiw2qNPsVKQzIil1ppxvm9qvGnVfqFUAAAADHRSTlMAg3ddIMYBdUE/x0I6OfvFAAABQklEQVRo3u3ZwW6DMBBFUbBxCKkJ0Cb//6vd5SJV2Ig3KVI0d+nNkazZvcbzPO8z6mIfDtfHbgfxdcti6VohLm02qL0UEQxNKf5VNqr0YzcrJBXuKpu1fWPRDombSLBDwvtui1oNmX7ej0zjiGKNYKBYIxgo1ggGijWCgWKOYKDYIxgo9ggGij2CgaIidQNFRzAIRUXqBoqOYBCKjGAUFBHBKCoSglFRdOQxvZrHVTPvDwH5032N3DM54ogjjjjiiCOOnIc8v19Na2Ti/SkjyzxWmhcBQakZAoJSMSQEpWroCAphyAhK0dARFMKQkLqCoSMoVUNHUDCsERQMawQFwxpBwTBHUDDsERQMewQF4xgS8h4Fo1CvDQILRqF4yrRBycpIzXZXK2T4j+Hs/AmwaYakEmnYNcuG9nAhdo3ned5H9At63gb2rVwlnwAAAABJRU5ErkJggg==",
      jpg:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAilBMVEUAAAA/UbQ/ULU5Vas/UbU+UrU/UbQ/UbXo6vbg4/NgcMKhqtucpdmIk9G/xea8wuWyueKOmNSYotdmdMRWZb5QYbyDj89ndsVDVLfj5vTb3vK3vuSjrNyRnNXDyOhvfMhKW7nm6PWkrNyVn9Z3hMtaasBFVrjW2u/Q1e3Kz+uvtuB/i86rs9+mrtyWEvPmAAAAB3RSTlMAVbsIuT6drnBT7QAAAcVJREFUaN7t1ulygjAUhuFu9kTcAAVZFHDf7//2moShnx1/iTlO2znvD5OJo8+EIOOLJD2vzts9fb63Ql7prj7eOREozIgHhQ/p9aHwIQoKIwKFEYHCiEDhRKBwIlA4ESicCBROBAonAoUTgcKJQOFEoHAiUDgRKJwIFD4EyisTAsU5Enm3JXcg7RNEEEEEEUSQ34okm6kXOUAGSqmhHrvK1t1fvOatydEu7oPELWJbka1Mm4Xh1j2iAruPq5WeQ+QchrNMj6k5B99cvGBc5nbBHTJtNjAnihZ6XJvD3+vJyS1CMz3JidZ62JEpxPVyhdiFQ/3VPpnGy+UydowEelIQXfSwJOQW8estHPUQMiHRXOlibdVINbFFrhC0234jcb0yco50x8SO5Bui+kz6HMgsCAbriKj5uZztLGiPRHEcn/AVFhkTmpv1RxFP6RKivr1jb5HSHE71IFKZZ1NJycE+qm6RbWauH/bUCqFCfzZb5fp1sQGCVkpXrOZ++gBSqqYZAUF6jyhsiVDQ3LJbINdVRUNkA2qL0NTPVFqcyOaPRqMN/WztZ4t0lw+qv/+XSBBBBBFEEEEEEeQfIp23h+u8SNLT+gJSUakHemojGwAAAABJRU5ErkJggg==",
      react:
        "data:image/png;base64,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",
      mov:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAolBMVEUAAADzQjb0Qzf/OTn0RDbzQjX0Qzb0Qzb/6+76pKH4fHX6oJz8v772ZVv5ioP/6ez/5+n9xMT0Rjn+2tz7sa/91NT3cGf1STz+4eP6nJf4gnv3dW32XVL1TUD9ysr+3t/7rqv7qKX6op35ko31V0z+1tf90NH8vLr5joj4eXH3a2L2aF71UUX8tbP6mpT1VEj8wcD7qqf5lZD5ioX2YVf4h4CY71jTAAAAB3RSTlMAVbsIuT6drnBT7QAAAnNJREFUaN7t1tty2jAQBuAcSleAqI0xdjDmfCaQE+37v1q1u8Y7TCcXbKNMm9F/EUlO8GdLuxluQkI+L427a/L9XoXcwlX5du8TEcUz0mHFL9Jss+IXMaJ4RETxiIjiERHFJyKKT0QUn4goPhFRfCKi+ERE8YmI4hMRxSciik9EFJ+IKD4RUfwhotx6QkT5cGTZ+TP5FYg+AQlIQAISkID8S0i5fzx8CPLDYH7yIqNFi+aj9gQXY1rtcVoAZeWmXQ2y5cWTIOXKVJkmAMmDm8wAs8RrCw1y5EW3RnIy5JtJ6sY1YFr05hrkIaEdimqk7cZ4kO2sGyN3ywLHw/n7UQ80iHnE+dCckRy35wQASZf36Rn9IbiM8YIOecP5vEay+u1a9OB878H5bXcKJDbGVg8ZM7JwwwYwz8guAQZUU8zHIwXy4j6XAxwinCJCG/8KmCTizdwb/CMuQAsKZOCeP6OdmTQZmVJRUbBbMixixiwWvAZ5srTfM2PSV0ZSpIHSoxPnS1u2Sg0y39J+993903eRgtqp436uQIPMSmOi0RI7YfMOwkU8ga1bNVVIii+xK/B1rJzJ/OJMuIjLFEkVcsRqak6xW8ZSXdOL6uK6KnpYYyrEYq+v3ec7sJY+sRd9wkVsqX9USBfy2HBn9410PD1xwdeBiphy0iKwMdh+NZL0qkMZreWkU0ZKJcKD2dUI7Zd5eWuvsNGr2xZk9EGNLOlfkiBJ19RZAOcQ4WquR/DELQgCI1sRERvnIjaZAhlaa/HhTtYWbpi65R4ou+MkivuzEur8cr/c5P/jV6KABCQgAQlIQAISkC+ONO7+Oo2bkJBPy28vJrKQVswJOAAAAABJRU5ErkJggg==",
      woff:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAilBMVEUAAAC5aMi7aMe6aci6aMi0acO4Z8m6aMi2bci6aMhKFIzz5fV5OKWnWb5oK5y7aciKRK+kV7zGgdHetuTXp99+O6hdI5ecUbhjJppTGpFPF46tXsG2ZcaWTLV1NKNsLZ5ZH5S4ZseSSbKOR7BWHZOGQaxxMaGpW79MFo2yYsSaT7ehVbuCPqrAdM17FobCAAAACXRSTlMAu0BrzBEvpg42dNklAAACP0lEQVRo3u3WbXOTQBAH8LZqdc/khCqEp/CQhATa+P2/nvsQ3am+IcJmOtP7z7RcGtgfx94xvQsJuWUe76/J5y//hTzAVfn4yRJRxRh5+saKLfLjuyi2yFdVDBFVDBFVDBFVLBFVLBFVLBFVLBFVLBFVLBFVLBFVLBFVLBFVLBFVLBFVLBFV7BBVPlghqiyN/Hz6NxORebFENAEJSEACEpCA3A6pnHNDBwCtcx4PJ/x8AMxL3Q5FuiqBsnJ/sl/rOJuGcHF3AhjxkAPAMx4b0LLFfgmkwZOf8cYdpgSI8JC8qrpdAEnw5IiKEybldkJm/bml+Y3yV59wYkJyGUdTkR1eswKoHaYH8HiI4Yi/jwBQkdILEoGEkPSqxss1HiBzUpeqVl3BFMgEs/lIN/ByKghJebG1EPMSo5TU+242Aind+8lRhm7N89ny/VM6Xg+zEX7+ayzLj4jKn7lPDXBy+paRJKaUjLQxZzrS0zJNsDEHXFf8AfavkZgRyZGRS6qJiGy/vsE7pZ+atqYBQr2taRZnnE3mXAEGCC2slCaA/cgRS2Xv+L97stpQ1tKTDQemI5mjFDglTg0Gq4s2uxTNnWx7g31Cu1peLd5dXmBL73jMRt6uAAkPysvkshGgPEj1+cjoKC/Sb5cD5jTQqGloRodqAUR6MVRYWnqjj5AybGARxP++rODecHYk82KFZZDIe99zLRxsQTLua+/rXXU5Q78ocVy/wf9WAhKQgAQkIAEJSEDePfJ4PzsPdyEhN8ovQ3De7e2LbrIAAAAASUVORK5CYII=",
      "c++":
        "data:image/png;base64,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",
      mp3:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAbFBMVEUAAAD/wAb/wgf/xgD/wQf/wQj/wQb/wgb/wQfEcgX/8+DThgbuqQbmoAbspgf/yzP/3oX/3H/knAbLegXGdQX9vgfRgwXdkwbNfQX7uwbajwXIdwXxrgbglwb1swfWigX4twfqpQboogb/xyBoWPWlAAAACHRSTlMAVbsIuT6dVGARlPYAAAIGSURBVGje7daJbqMwEAbgHpvdYU3prmMbbG76/u9YD24zpRGVMulUVeVfSsxA4IsPObnJyfm6HO4uye97FnILF+XXvSRCijDySIoc8u8/KXLIX1IEEVIEEVIEEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVIkEVLkEFL+yCGk3H4q8vR4ngsQfjKSkYxkJCMZ+c7I1A2WhzwUmCEV3VpUAGWR0jrtIUUf8cQ48BGdin6LJKcDzPhSmo6NjKlwhFDMgP04lUfLRVrA2OItYvq+H7FWAIBjVU+lic3MRYp1EMoNcjxdnmDCL2LTeNYchCalPkdsG48W8MuyVLGccWh5iElDAg4Ptwg4Whb4aX5PVHy4BfB4+DGCl0se0pt1Uqo47vU7xKeuYQat0VDARFR8rVMSwhYZ8LHGA5xWsfJMpI73O4AmLk9CKDW8QQIXCUN88xO+jeeIs7Bmds6kkodgJ6oFu6PeI6a3cIrHZfDAQ0acjjrgMnKEGK310lmgpPOKhyi8uTniZtxsJv4sE57nItYU6fYdZG7bNuBquwZJO3nYRbqXvUtfMVypKao9JG1hau4Nf+JVGmzjd5DN70lj2Qg02OwjUL8aE1yOlEqpGjGl5tiEWHYAXWwCbFKOpjBO25/wlygjGclIRjKSkYxk5Kchh7urc7jJyfmyPAMCocCv5MAhUAAAAABJRU5ErkJggg==",
      pdf:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAh1BMVEUAAAD/VyH/VyL/VRz/VyL/ViH/WCL/VyL/6+776ef+rJT/uar/cUf/dUn/fFX9qI//WST/w7j/4eH/pI3/po//kHD/f1j/dUv/Xyz/0cn/oor/nYP/5uf/29f/ysL/s6H/g1//aTv/397/zcX/6Or/wLL/iGX/bkL/ZDX/rpv/lnn/lXf/i2rWGuWlAAAAB3RSTlMAVbsIuT6drnBT7QAAAXpJREFUaN7t1ttugkAUheGqtUNRW0ZBOYniuYf3f77OwDTL2JvaYZm03f/Vmpj4hUAId5J0u4b9a3oY/Ajpqau6HzARKGRkDIWHhM9QeMgjFCIChYhAISJQmAgUJgKFiUBhIlCYCBQmAoWJQGEiUJgIFCYChYlAYSJQeAiUHgmB0jlST74WfQ/xTBBBBBFEEEH+LPIUtG22+UnZRu0xCyeqaRygtQfims6B2FYRAQnKBRCbjjpEyjiORzsztg6p4rAKTMUnErcdPZCpHUlgmrTIzJzf7A+pQyKFfJBoadYrEJWZ8d4xonTz70BCM14YSH6GFGbojpF0alYCpLlJW4csmk6eSHTcm7GrL5CsRVy5B4JWio9kKR0pw1RdIpVD5k21D1IWRZHMLXGO5Gbsu3y6EJCVGTEVcW+ANRdJ7YUsIyKy1FUZmA6KiLhmio5sEtUVMtZaj9RZhbaNwoN7pGt7/A1fK4IIIogggggiiCD/FBn2vRveSdLN+gDRzag6fGOSLgAAAABJRU5ErkJggg==",
      ppt:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAh1BMVEUAAAD/bAD/bQD/cAD/bQD/awD/bQD/bQD/////8+D/dxH/iC3/9Ov/u4L/qmv/t3z/pGD/4cr/sXf/kkD/28D/2Lv/cQb/+/j/lET/0Kz/7d//n1f/eRT/6tr/dQ//+PP/5dL/xpr/wpT/vYv/r3P/mk3/kDz/izT/giT/fhz/9e7/1bb/rG5NLz2gAAAAB3RSTlMAVbsIuT6drnBT7QAAAXdJREFUaN7t10lXgzAUhuEO1otQWktlHjpP6v//fQaD+aiuoLnVc7zv6jZdPOQkCxhI0v2ajLr0OO6FDKlTD2NOBAoz4kHhQ/w5FD7kCQojAoURgcKIQOFEoHAiUDgRKJwIFE4ECicChROBwolA4USgcCJQOBEonAgUPgTKkAmBYh25eD+LOiD9E0QQQQQRRJBfQCr3s8osRK4uwu92vZCpo4vDXC/MnKZseyHVs3NVT8QUVhoxrXJ7CBSNoHhpD9kEgb9wVHmDZEEQbGI1rIm8QJXqRVVvZFmfb6mGtwZ5MYdxqic9Lwj1RGiuhtc2EtVbebeHmAePDKLK1ORbRJodxARE/zW3i9RnW7YRT18FW8jBdc97R7X7Qly3OC7qrRWWEDQtNIJ8so2smrNBKVlG4vRM10g5I4vIPkmO9TeHQdZJkpwKQnZuF8IVFkSQG5E0DEOPWh3Uwu47kqjF7R9/JRJEEEEEEUQQQQT5r8hkdHOTgSTdrQ+o46cimmRaOwAAAABJRU5ErkJggg==",
      epub:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAxlBMVEUAAAD/cUT/cES/Ngy/NgziVyLlAAC/Ngz/cEL/b0K/NgzANgz/cEO/Ngz/cES+Ng3/b0L/cUO+Ng3/cEK/Ngu/NQ2+Ngv/cUL/cEP/cEP/cEP/b0L/b0P/cUPANgu/Ngv/cEO/NgyjKAzgWDHaUy2rLhH3aj6kKQ3GRCDRTCexMhT6bED2aD3tYTfzZjy2NhfmXTTdVS7kWjOpLA/xZDquMBLoXTXLRyOnKg79bUHfVi/WTyrTTSnQSybDQB7APh29PBu5OBiosyf0AAAAIHRSTlMAqoCAqwgBZ11O6dmrpqKiiHp6aVlMLyzp6NjXrqyJiLVQv/8AAAH6SURBVGje7drZcoIwFAbgbtp93/eDwWrFQNncbfX9X6qJp4rOQBQSnV6c/yZInHzERIaZwxaFQimQ0u3b+Z7IdqGcXRyWlhLl/SMLA0XzcF1eMo09axoonpeSch6nlgkETlRzubHMIHCgQI5NIU/Zxp1lCoH7TGRfgRj7va7MIZeZyK45ZIcQQgghhBBCCCFk7Yhvz+IDNBmm1QRMS5znonVtEehibyC6cyHVyiwdADb74AUgUxeHn4AdNfiYdTd8AwiOnY5g2roIhimRSpAPYQ4Gx4o55z15upGOBJzboWh/8iFfMA37GxtacjieishFH8iL0UXwvJ+JBKKt6iOeOOpnIj3RevpIrJpJdyzaQZHd5a24JqPvn1h+zdFBqoz1hqFcWdUWHn9AMSTX/6SeExkyma9FpNaHdKRv25OJDjUWHlP95gCg3MJhVwOJXdd1AECFQE0cRHpbOEkbb4Xgy0ufQzpy85lC+pMdgZiXIFEl90x8F5OCcDnaoBmEckaIRI7DPTmxQrf6WgoCXtIdSSRJ2xwShdPuASwgDccMgspo0hn7MI906g6sjgQsCT4viGYxTWb3OMh0bYzfcv7fIxEhhBBCCCGEEEKIAtl8ucl84WzzJUDzxcznTZRlDzdSYF5/qfy1tPai/+N1eYXXF951X1+gUCj58wtnbw12f55dNQAAAABJRU5ErkJggg==",
      c:
        "data:image/png;base64,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",
      flv:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAeFBMVEUAAADzQjb0Qzf/OTn0RDbzQjX0Qzb0Qzb/6+72ZVv8vr32YFX3dW36pKH6oJz+2Nr0Rzr6m5f6lpH3cGf+3d7/5uj4fXb4eHD1T0T9xsb7rar2Z131Vkv7p6T3a2L1TD/+2Nn9zs77sK76nZn5jof2W1D8ubf4gXpMF+79AAAAB3RSTlMAVbsIuT6drnBT7QAAAXBJREFUaN7t1tlOwmAUBGAW8dAFLEvL0hYERN//Df3PgXRMvBHbIVHOXNBJSfiS/tOEnsdzv4wGt+R5+CukLzflachEoJCRCAoPmUyh8JAxFCIChYhAISJQmAgUJgKFiUBhIlCYCBQmAoWJQGEiUJgIFCYChYlAYSJQeAiUPgmB0jlSRd+T/QxpGUccccQRRxz5x0gyRlaShs8X0cz1RmX1rHXOQEq9UVj90BoxEFmGOrG2DW0prZHTzJJ8RY6hHqwdQtu2RzK5BogU+sU+lLWWgoPYby9CWWlZcxDZXDd1CteNcBAbcQysNVJGmqpBmhHnIlmOAXcw4VmDYMSR7DBgAmLvx5s9tZqBYMRHede3tAtkYTk3CEb8qg8t3wtjXRhxahvjIBixHgwTicaXJBwEI7Zz6R7J40sSHbGm7hxBdjpiTcpEbMQYcAukikMapIwRPe46XKd/5N+KI4444ogjjjjiyEMio0HrjHoez93yCV71ou+7Uk4XAAAAAElFTkSuQmCC",
      dmg:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAYFBMVEUAAAD/gav/gKr/jar/gK3/gKv/gKvpHmP85OzyQ378c6HyR4H+fKjwOHf+lLj9utH9t870TIX9d6XtLG3rJGf4YJPvNXT3XZL1U4rsKGv7bp76ZZjuMHH6aZv2V43/jLOjGU3yAAAABnRSTlMAVbsIPp2VTiuNAAAB/0lEQVRo3u3W7W7bIBQG4DbNzFxwNwy28efu/y7HOaW8lfYr2KeaKl4pMdgOD/FBJE81NV+X++2R/HgpQp6bh3J7kUSgCCNvUOSQX7+hyCE/oQgiUAQRKIIIFEkEiiQCRRKBIolAkUSgSCJQJBEokggUSQSKJAJFEoEiiUCRQ6A8CyFQLkf+vP2bB5DyVKQiFalIRSryXyOv+74UIa2i+E3vaSDuh3TVU6flprEz39m+FiKc1gDpGs6uMtJvKsXvJxA1AvEMNgHIiPtmU4Js1vIYNiNq5YtjRgZurKul41GC6HicaP59RiyXQWWk+3iGlhqlCM/6IASPbs0Ic1yLhSZTjFgaLiPK0KmMLOlU5NqYYuTg+TMypqJs1GRkxfyRAoSK4hLScVEM1YYRrvt8ATIA2UJ88Rk/AHG09t5zBeKoBH2j4/jTJyTVn6+dR+bGKTXQ23RchaAm2zvi6UvonkYLQOYLkIDVpWg1uYn6FqtLYQMtRjQ10iDGeKU6pUJCMPRJxMXG9IE0naIsTLdpz5/OIkbz9pqRQ3EVMkK3uf4MMnejVzzVjPChBbJQ3+ug5zIkRzdA+OkNQGJxEGdKEX80nxFLByBQ+Cf0QSR0HD2lT/bUi+09nqNtM/ZCw1m0oz8DdvkGf4kqUpGKVKQiFalIRb4Zcr+dzv2ppubL8heKlpRwpzQ/5gAAAABJRU5ErkJggg==",
      tif:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAUVBMVEUAAAA/UbQ/ULU5Vas/UbU+UrU/UbQ/UbXo6vabpNhgcMJKW7l8iM1UZL2hqtvl6PVkcsPL0Ou7wuRsecd4hsxEVbdTY73V2e+osd65wORBU7YNcnYUAAAAB3RSTlMAVbsIuT6drnBT7QAAAOVJREFUaN7t1skSgjAURFEGMZA4Muv/f6hMVV2UGxCaEu27eW+Vs0gW8ZTariiY0zH8CPHNrA4hE4FCRiwUHnJJoPCQGAoRgUJEoBARKEwEChOBwkSgMBEoTAQKE4HCRKAwEShMBAoTgcJEoDARKDwEik9CoKyOlPa9YhqyMCFChAgRIuSXkSIelRvXjrMxpxiVQoaeSdu1OaluFztCqqTPLUBQi9y6bYTczZCQr0Eq2+WoyFAuZNqdZF1u/69LiJAVkEeaprZfi7TJGZM1o97Tb0WIECFChAgRIuQfkShYXOQptVkvGLufPMdKLhUAAAAASUVORK5CYII=",
      apk:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAZlBMVEUAAAD/gav/gKr/jar/gK3/gKv/gKvpHmP85OzuMXHqJGf4YJTsLW71VIv+lLj9utH9t87vN3X+e6fxPnv/fqrzSoPsKmzrJmn6Zpj3W5D9dKL7b5/7a5v2V430T4fyRH/wO3j/jLPUh81YAAAABnRSTlMAVbsIPp2VTiuNAAAB80lEQVRo3u3W61LCMBAFYEVsTAtqk7S03Frf/yXNJsKpODLT1XUc3fMnF5h8ubVwo9H8XJaLObm/YyG3xaws7iQRKMLIIxQ55OkZihzyAEUQgSKIQBFEoEgiUCQRKJIIFEkEiiQCRRKBIolAkUSgSCJQJBEokggUSQSKHALlVgiB8u3Iy+PHzED4UUQRRRRRRJG/jDgb406t3uaMzT53+NjoqNJQd8VEKhNTnVprc45P8urt0z112cBEhjQgEKQOQIKlnh1zu8LGxJRhgmy8H1vqXQNJ6z1yz6QzKd0Eqcn2sdKeEUeoDVykychwgRS7tD0n5EitfcFF2jhDG7foEinKNHpGttRoCi5CE24aTBPIZoLQ5Vg5NnKkMSqSLpCtITkjDU6NhdDNdI4m+h5xI12zQEjOKrARmq8tipoO+YyUbduWJq0OiKnYyCHf/mMqMoJYN0UsG6nzZnc0yCUykAHE9EzEpSnGULmdPPF+OFDzhDR1OhUe0ptJDjj4FCB16NJSeIifIvWnSJVvYes4iKM7NPqYkRR3BanSC5ODVOn9e34X91eQVG4cAxnwS+Kpeg3psZQ5SJ7+AVegdFeQ0KZvzEb2Zcwu17dU7+LTGYtxitjYQUj6pFz/5n8riiiiiCKKKKKIIv8SWS6+nOWNRvNjeQVzuJNKIySCvAAAAABJRU5ErkJggg==",
      php:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAnFBMVEUAAAAAu9MAvdQAvNQAvNQAvNQAt9AAvNUAvNMAvNUAvNQAu9UAvNQAvNQAvNUAvNUAu9UAvtQAvNMA//8AvNT///9m1+X7/v5Azd/r+vwQwNeR4uxV0uLK8faI4Oue5u8rx9yU4+3E8PWt6vJd1eQ5y940yt0aw9kHvtbP8/eB3uoixdq97vRs2edR0eL0/P3j+Pt22+hQ0eEyydypTjXSAAAAFHRSTlMAgHeIXfoK33U/5jDj53NaQi8uAUQzrUoAAAGfSURBVGje7dnZcoIwFIBhpMjmUpejQrTUghRwt33/d+uBofWiTWiTWB3n/DecC5xvkAnDEIOiKOpe6lh9U6q+1fmdYLccUMgx7WZj0APFfK/JsNqgXNsSGx4aGpSByLB7oCXfFiAt0JTJN8ZdXYgz5q8P0NaQi1j6kEcu4upD3Ivfd6xFCCGEEEIIIVXTulWQQ9kG5z1UrXDM8JhO694ySWQ2+Sw8AbbA6QmqQhwDPM4nXyUbNQRLxEhZ+K6GYGsxUnbMJZGAMRYUOBwYD3nGUzZRqewkkVfAsnJacBEoS3DaqiAQ47QWIyucQiUkwWkuRgKcZpqupGBVF7iSZTntETn3Ddkq3JMIV3MU4hAyHhLjKad4gk1V18kOOMi5IldE1vWKP0ZVhx+QIgMVJEzSpmfXLN7lIIukjLH616IVzwCTRpaAiZEXwAgh5O8vEgyqRC8S6e2/EhFCCCGEEHKPiM5Pttf9+NzRh4wMbo4uwzH4mboQU4DYvh6ja//DdpN3/Y0zvBZf+b/yjMZsU9dmprih5T5I5Vojg6Io6k76ALZvtFVPD2lHAAAAAElFTkSuQmCC",
      mpg:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAnFBMVEUAAADzQjb0Qzf/OTn0RDbzQjX0QzbzQzf0Qzb/6+74dm72ZVv5ioP6pKH4fHX6oJz8v73+2Nn/6ez1SDz4hH3+1NT6nJf5k471TUD/5+n9zMz8wcD3bmX2YFb/5ef9x8f9xcT2WU/1UEX+4uT+3uD7qKX5joj2aF/90NH8ubf7sa/7rKn6o5/4gXr7tLH3c2r3amL1V0z+2dv4fXUhZ3yDAAAACHRSTlMAVbsIuT6dVGARlPYAAAIzSURBVGje7dbbcqJAEAbgHNbdbliVgAFFFCPiAc/J+79buqFCGywvHNOpVGr+C+kZq/hmptHizsbm+9J6uCZ/H42Qe7gqfx41EVGUEVcUPaTdFUUPQVEUEVEUEVEUEVE0EVE0EVE0EVE0EVE0EVE0EVE0EVE0EVE0EVE0EVE0EVE0EVH0EFH+6SGi3H8pcnTPE1yBmMciFrGIRSxikZ+MTN3E7Zsg/5EzqgZJOegAOFhllkb1XTupTzP+MDFF5tUgbCLsHBpvE/7cEFlVg4kgkqzc5lwm/IUZkgVc9/1TJAvDcMczHrdjTEX8dug98ZLMECwX5+Ap8lR//VJdZ9yeBRWDvhkScd09R4IZVVuAHV1C4PBWDgbIAHHIdUxlA4GUV1Dd+g048zzPXQNkSDcPAKY+lU0krp49bkkCdQyQcFDeoUPH3m4gZcMdAPkxGSNeeeA5YpF/QoKRx6c5haBEyHwpY9L4zRwxBXimFhc1ImlDjQyrmZ4Bko8Q/f6RPqarcyQNvgQpeBPOFnECwyYy7gZA8al0b0JWsKEzW/OzmgqSRVHUS4jgZDSxB05siHiwR1y+8lqXp42XlPO9m5AJBGOkvFLzLyBrmtjdiMCKkfVlhCf8RPZkhPAFnYtI9YVfRGGM5six+nO9jCwGWGe8MENgyf0/RyT72YcRu3Al4niet2HM87bcYBomtG66FPA5/SjNcPy8dn7BK5FFLGIRi1jEIhaxyC9DWg83p3VnY/NteQehgMZLDySFDwAAAABJRU5ErkJggg==",
      css:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAdVBMVEUAAABOt6tMtaxUq6pNtqxOta1MtqxNtqwAaVzg8vFLtKpDrKEEbWABal1rwrqi2NSe19IPeWw7pJo3oZYul4xIsqcjjYEchXkUfXEGb2I0npMqlIgMdmlGr6U/qJ0IcWQJc2cxmo8nkYUfiX0YgnVAqp9evbSkvhVAAAAAB3RSTlMAVbsIuT6drnBT7QAAAkdJREFUaN7t1tl2mzAQANAsdUUFpEVCYl/t9P8/sRotnjR9svCkJyeaF3nAniuJAfyQIsXHxenplvj+HIU8spvi2zMlggox8oIKHfLzFyp0yA9UCBFUCBFUCBFUKBFUKBFUKBFUKBFUKBFUKBFUKBFUKBFUKBFUKBFUKBFUKBFU6BBUHokQVO6O/H75N25A4iMhCUlIQhKSkP+GqFnOnGHwWb6+zSchcn4MEW2ZZVnZCp+/XiAvmtznss1MdFodQOoyc1HWNu8LnxfS5jrzsebRiATDKwLWgXkBVevsGhWPRPgKv+7FNpqxNQcaqF6LGtajTQ7nx15osPtIpIeasNu5qVJOjC3mwGDywYyLOQxLmE1+MWMTiZyvvx3dVGHGdtugOmcCtpH5bWsjkcpN3E91h5XYgfHcBHeW8PkUicCWb+7qKKW4uyblgJcY0E4euxk7U+OvErPtrnFzTOiuVt4RwftmCatpfP/290SYXHzZyeVD4fKG3xFhvF5t1dFXnXThlFhkcY37ntkss4dc7ZYRkch47a7J9KhCpoWl4PdymM05EoFaw5tPW1VVtpaEVubsbPIacn3gZtR2r3HjtrCAOTOh2DksYIBWiEREeNpKKDqxPDxWajjhhm7ynXyJRFgFVfTeFL5IC8V1rX3Oof3WvW4AH2KR+d37I+/w/TK7x3SIVcUiTIY34SKcOgbTdV3fBWM+8I6f9FhkRbWr673Ydlk56jyc3ys4P6hP8JcoIQlJSEISkpCEJOQLIqenw3F6SJHiw+IP+sut5pdU0NsAAAAASUVORK5CYII=",
      csv:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAdVBMVEUAAABOt6tMtaxUq6pNtqxOta1MtqxMtq1NtqwAaVzg8vFrwrpDrKKi2NSe19JKtKoKdGcDbF8Gb2MWf3Mhi39AqZ46o5gokYYZgnZHsKYznZIbhXgPeGxIsqg3oJUslooSe3Aul4wljoMeiHw8pZsjjYFevbT5wlXDAAAACHRSTlMAVbsIuT6dVGARlPYAAAI4SURBVGje7dbJctswDAbgLHULNWy1kxYla7Hlvv8jliBK4pCTaSOdTPhfZDoz+EgI9OQpJ+fjcni5Jd9fk5BnuCnfXiURVoSRN1JkkV+/SZFFfrIiiLAiiLAiiLAiibAiibAiibAiibAiibAiibAiibAiibAiibAiibAiibAiibAih7DyQw5h5fmhyJ+397kBSU9GMpKRjGQkI/8NKXu9DwCcXvfDYxE11oXLZIEydA2uV41/w08GfCb3sUpEtCtJudAp4hqLV+7Z0nFxK10aouoiZsFaFa9ngM49GtoMfZOEjFhl222LzxJgw1rn3aI1Acy47MHFuA91mYQMeBCNJ8AuWYCjexyxa1hdUZM2cGmpcSmIjW/zQi1fw5tGVFPtEdeoLWnI2W8cY2inx7Bh5VICLLgLPlkScolTVZ5csCh+c+LBwPUAsBGWgNDGzwCck5+uxkQG15YGpHsUAjvdk/o60LrD6mTphyHQT4VPswNm9rOseIDvR6juSofp6aZjeUsDkoJQq6/wLtozLYQLoju6LvdO10m5QMz131TRvBlsoUpFjG8D35h+mqbVdwkRHYZ49S8mFZnj+NOM0rUIN34OQ4y5piD8A27Dj5il2ibc8D4MMUanIlShHk1X4ZFK6l8xLgbXDZ8WJywN4RtOsXi0ldcLn5YHOAUBFZSaRnRogxFfgv9muweBclmboq46FYdhbFzrxh1CbOsyfIZ/iTKSkYxkJCMZyUhGviByeLk7h6ecnA/LX6QwwN6Ew2NRAAAAAElFTkSuQmCC",
      asc:
        "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGQAAABkCAMAAABHPGVmAAAAclBMVEUAAABOt6tMtaxUq6pOta1MtqxNtqwAaVzg8vFLtKoDbF9rwrqi2NSe19JDraJAqZ4jjYEVfnEGb2M8pptIsacJc2Yul4wrlYopkocahHcPeGwMdWkxmo8YgXYRe241n5QljoMhi38eh3s3oZYznJFevbQOHZ8vAAAABnRSTlMAVbsIPp2VTiuNAAACM0lEQVRo3u3W23LaMBAG4IRQq1JaCx/lAwZs0vd/xWq9SNtOrpDZTDLZfyaxZWb209HwJJF8XPa7e/LjJQl5zu7K7oUTIYUZeUWFF/n1GxVe5CcpjAgpjAgpjAgpnAgpnAgpnAgpnAgpnAgpnAgpnAgpnAgpnAgpnAgpnAgpnAgpfAgpz0wIKQ9H/ry+zx1IegQRRBBBBBHk0yDaXq3+r11V+UbkqJQ6UdNOxj8wfShbz6XyGZ3egkxQI/b0zShMeUWzUbcUOh3Ra9U2jAONVQG4blTMnI6csZu3Vg/V26oF6+DbF5i6rjovcM2TkWVFTI2t8jYq56+NH2ZoZyd/06UhWBa6fcQWgBVMG9zorIp+5++mVATKHPxfH0jssM59sqz1zQE3BOywVASAalDK6LgmxmUhXVwuXfukIg3UB+l8GxhkPGrqQr/5xNt1qq/+/4IPWrWmcfoRCM2HW89KGbZ0g8yQPwwZfBWLG7QKp7NFZtQPQnI8DtkFz15gjivT4fNpK+JUDGDEwNBG2l1hTychRSRw2tphGGb44AoP8A09QBvvkpDa/ItcsNQYt7LOrAon6JJ44rFmeYBM2FEbXitO4X4bwxsAVsklIVM4H1g9x/kzc3uAIfZh0aZuBszUKYiGUm94X2JPc7hijMUdENNlCQh+ldT0RXKCxRiDgXp9oiVLQlxRFEsACx+9nsWiVGac87hw0G4W+wV/EgkiiCCCCCKIIIJ8A2S/25z9k0TyYfkLJnKWKZDc4r4AAAAASUVORK5CYII="
    };
  },
  extendIcons() {
    return {
      "org.openxmlformats.wordprocessingml.document": this.icons().word,
      docx: this.icons().word,
      dotx: this.icons().word,
      dot: this.icons().word,
      odt: this.icons().word,
      "org.openxmlformats.spreadsheetml.sheet": this.icons().xls,
      xlxs: this.icons().xls,
      xltx: this.icons().xls,
      xlt: this.icons().xls,
      csv: this.icons().xls,
      ods: this.icons().xls,
      "com.netscape.javascript-source": this.icons().javascript,
      js: this.icons().javascript,
      "com.sun.java-source": this.icons.java
    };
  },
  icon(item) {
    var type = item.kMDItemContentType;
    if (type === "public.folder") {
      return this.icons().folder;
    }
    var icon = this.extendIcons()[type];
    if (icon === undefined) {
      var name = item.kMDItemFSName;
      var extension = Tools.getExtension(name);
      if (extension !== "") {
        icon = this.icons()[extension] || this.extendIcons()[extension];
        if (icon !== undefined) {
          return icon;
        } else {
          return this.icons().file;
        }
      } else {
        return this.icons().file;
      }
    }
    return icon;
  }
};
