---
sidebar_position: 13
---

# Embedding (Vector) Stores

Documentation on embedding stores can be found [here](/tutorials/rag#embedding-store).

All supported embedding stores can be found [here](/integrations/embedding-stores/).

## Examples
- [Example of using in-memory embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/other-examples/src/main/java/embedding/store/InMemoryEmbeddingStoreExample.java)
- [Example of using Chroma embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/chroma-example/src/main/java/ChromaEmbeddingStoreExample.java)
- [Example of using Elasticsearch embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/elasticsearch-example/src/main/java/ElasticsearchEmbeddingStoreExample.java)
- [Example of using Milvus embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/milvus-example/src/main/java/MilvusEmbeddingStoreExample.java)
- [Example of using Neo4j embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/neo4j-example/src/main/java/Neo4jEmbeddingStoreExample.java)
- [Example of using OpenSearch embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/opensearch-example/src/main/java/OpenSearchEmbeddingStoreExample.java)
- [Example of using Pinecone embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/pinecone-example/src/main/java/PineconeEmbeddingStoreExample.java)
- [Example of using Qdrant embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/qdrant-example/src/main/java/QdrantEmbeddingStoreExample.java)
- [Example of using Redis embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/redis-example/src/main/java/RedisEmbeddingStoreExample.java)
- [Example of using Vespa embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/vespa-example/src/main/java/VespaEmbeddingStoreExample.java)
- [Example of using Weaviate embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/weaviate-example/src/main/java/WeaviateEmbeddingStoreExample.java)
- [Example of using PGVector embedding store](https://github.com/langchain4j/langchain4j-examples/blob/main/pgvector-example/src/main/java/PgVectorEmbeddingStoreExample.java)
