---
title: Comparison Table of all supported Language Models
hide_title: false
sidebar_position: 0
---

| Provider                                                                         | [Streaming](/tutorials/response-streaming) | [Tools](/tutorials/tools) (sync/streaming)                          | [Structured Outputs](/tutorials/structured-outputs#structured-outputs-1) | [JSON Mode](/tutorials/ai-services#json-mode) | Supported Modalities (Input)   | [Observability](/tutorials/observability) | Local Deployment                                  | Supports Native Image | Comments                    |
|----------------------------------------------------------------------------------|--------------------------------------------|---------------------------------------------------------------------|--------------------------------------------------------------------------|-----------------------------------------------|--------------------------------|-------------------------------------------|---------------------------------------------------|-----------------------|-----------------------------|
| [Amazon Bedrock](/integrations/language-models/amazon-bedrock)                   | ✅                                          | ✅/🆘[#2114](https://github.com/langchain4j/langchain4j/issues/2114) |                                                                          |                                               | text                           | ✅                                         |                                                   |                       |                             |
| [Anthropic](/integrations/language-models/anthropic)                             | ✅                                          | ✅/✅                                                                 |                                                                          |                                               | text, image                    |                                           |                                                   | ✅                     |                             |
| [Azure OpenAI](/integrations/language-models/azure-open-ai)                      | ✅                                          | ✅/✅                                                                 | 🔜 [#1982](https://github.com/langchain4j/langchain4j/pull/1982)         | ✅                                             | text, image                    | ✅                                         |                                                   |                       |                             |
| [ChatGLM](/integrations/language-models/chatglm)                                 |                                            |                                                                     |                                                                          |                                               | text                           |                                           |                                                   |                       |                             |
| [DashScope](/integrations/language-models/dashscope)                             | ✅                                          | ✅/✅                                                                 |                                                                          |                                               | text, image, audio             | ✅                                         |                                                   |                       |                             |
| [GitHub Models](/integrations/language-models/github-models)                     | ✅                                          | ✅/✅                                                                 | 🔜 [#1911](https://github.com/langchain4j/langchain4j/issues/1911)       | ✅                                             | text                           | ✅                                         |                                                   |                       |                             |
| [Google AI Gemini](/integrations/language-models/google-ai-gemini)               | ✅                                          | ✅/✅                                                                 | ✅                                                                        | ✅                                             | text, image, audio, video, PDF | ✅                                         |                                                   |                       |                             |
| [Google Vertex AI Gemini](/integrations/language-models/google-vertex-ai-gemini) | ✅                                          | ✅/✅                                                                 | 🆘 [#1717](https://github.com/langchain4j/langchain4j/issues/1717)       | ✅                                             | text, image, audio, video, PDF | ✅                                         |                                                   |                       |                             |
| [Google Vertex AI PaLM 2](/integrations/language-models/google-palm)             |                                            |                                                                     |                                                                          |                                               | text                           |                                           |                                                   | ✅                     |                             |
| [Hugging Face](/integrations/language-models/hugging-face)                       |                                            |                                                                     |                                                                          |                                               | text                           |                                           |                                                   |                       |                             |
| [Jlama](/integrations/language-models/jlama)                                     | ✅                                          | ✅/🆘[#2115](https://github.com/langchain4j/langchain4j/issues/2115) |                                                                          |                                               | text                           |                                           | ✅                                                 | ✅                     |                             |
| [LocalAI](/integrations/language-models/local-ai)                                | ✅                                          | ✅/✅                                                                 |                                                                          |                                               | text                           |                                           | ✅                                                 |                       |                             |
| [Mistral AI](/integrations/language-models/mistral-ai)                           | ✅                                          | ✅/✅                                                                 |                                                                          | ✅                                             | text                           |                                           |                                                   |                       |                             |
| [Ollama](/integrations/language-models/ollama)                                   | ✅                                          | ✅/❌ [#5796](https://github.com/ollama/ollama/issues/5796)           |                                                                          | ✅                                             | text, image                    | ✅                                         | ✅                                                 |                       |                             |
| [OpenAI](/integrations/language-models/open-ai)                                  | ✅                                          | ✅/✅                                                                 | ✅                                                                        | ✅                                             | text, image                    | ✅                                         | Compatible with: Ollama, LM Studio, GPT4All, etc. | ✅                     | Compatible with: Groq, etc. |
| [Qianfan](/integrations/language-models/qianfan)                                 | ✅                                          | ✅/✅                                                                 |                                                                          |                                               | text                           |                                           |                                                   |                       |                             |
| [Cloudflare Workers AI](/integrations/language-models/workers-ai)                |                                            |                                                                     |                                                                          |                                               | text                           |                                           |                                                   |                       |                             |
| [Zhipu AI](/integrations/language-models/zhipu-ai)                               | ✅                                          | ✅/✅                                                                 |                                                                          |                                               | text, image                    | ✅                                         |                                                   |                       |                             |

Legend:

- ✅ means "supported"
- 🆘 means "not supported yet; please help us implement it"
- 🔜 means "it is being implemented; please wait"
- ❌ means "not supported by the LLM provider"
- no mark means "not sure, need to double-check"
