unit zint_sjis;

{
  Based on Zint (done by Robin Stuart and the Zint team)
  http://github.com/zint/zint

  Translation by TheUnknownOnes
  http://theunknownones.net

  License: DWYWBDBU (do what you want, but dont blame us)

  Status:
    3432bc9aff311f2aea40f0e9883abfe6564c080b work in progress
}

interface

const
  sjis_lookup : array[0..13685] of Integer = (
      $005C,$815F,      // REVERSE SOLIDUS
      $00A2,$8191,      // CENT SIGN
      $00A3,$8192,      // POUND SIGN
      $00A7,$8198,      // SECTION SIGN
      $00A8,$814E,      // DIAERESIS
      $00AC,$81CA,      // NOT SIGN
      $00B0,$818B,      // DEGREE SIGN
      $00B1,$817D,      // PLUS-MINUS SIGN
      $00B4,$814C,      // ACUTE ACCENT
      $00B6,$81F7,      // PILCROW SIGN
      $00D7,$817E,      // MULTIPLICATION SIGN
      $00F7,$8180,      // DIVISION SIGN
      $0391,$839F,      // GREEK CAPITAL LETTER ALPHA
      $0392,$83A0,      // GREEK CAPITAL LETTER BETA
      $0393,$83A1,      // GREEK CAPITAL LETTER GAMMA
      $0394,$83A2,      // GREEK CAPITAL LETTER DELTA
      $0395,$83A3,      // GREEK CAPITAL LETTER EPSILON
      $0396,$83A4,      // GREEK CAPITAL LETTER ZETA
      $0397,$83A5,      // GREEK CAPITAL LETTER ETA
      $0398,$83A6,      // GREEK CAPITAL LETTER THETA
      $0399,$83A7,      // GREEK CAPITAL LETTER IOTA
      $039A,$83A8,      // GREEK CAPITAL LETTER KAPPA
      $039B,$83A9,      // GREEK CAPITAL LETTER LAMDA
      $039C,$83AA,      // GREEK CAPITAL LETTER MU
      $039D,$83AB,      // GREEK CAPITAL LETTER NU
      $039E,$83AC,      // GREEK CAPITAL LETTER XI
      $039F,$83AD,      // GREEK CAPITAL LETTER OMICRON
      $03A0,$83AE,      // GREEK CAPITAL LETTER PI
      $03A1,$83AF,      // GREEK CAPITAL LETTER RHO
      $03A3,$83B0,      // GREEK CAPITAL LETTER SIGMA
      $03A4,$83B1,      // GREEK CAPITAL LETTER TAU
      $03A5,$83B2,      // GREEK CAPITAL LETTER UPSILON
      $03A6,$83B3,      // GREEK CAPITAL LETTER PHI
      $03A7,$83B4,      // GREEK CAPITAL LETTER CHI
      $03A8,$83B5,      // GREEK CAPITAL LETTER PSI
      $03A9,$83B6,      // GREEK CAPITAL LETTER OMEGA
      $03B1,$83BF,      // GREEK SMALL LETTER ALPHA
      $03B2,$83C0,      // GREEK SMALL LETTER BETA
      $03B3,$83C1,      // GREEK SMALL LETTER GAMMA
      $03B4,$83C2,      // GREEK SMALL LETTER DELTA
      $03B5,$83C3,      // GREEK SMALL LETTER EPSILON
      $03B6,$83C4,      // GREEK SMALL LETTER ZETA
      $03B7,$83C5,      // GREEK SMALL LETTER ETA
      $03B8,$83C6,      // GREEK SMALL LETTER THETA
      $03B9,$83C7,      // GREEK SMALL LETTER IOTA
      $03BA,$83C8,      // GREEK SMALL LETTER KAPPA
      $03BB,$83C9,      // GREEK SMALL LETTER LAMDA
      $03BC,$83CA,      // GREEK SMALL LETTER MU
      $03BD,$83CB,      // GREEK SMALL LETTER NU
      $03BE,$83CC,      // GREEK SMALL LETTER XI
      $03BF,$83CD,      // GREEK SMALL LETTER OMICRON
      $03C0,$83CE,      // GREEK SMALL LETTER PI
      $03C1,$83CF,      // GREEK SMALL LETTER RHO
      $03C3,$83D0,      // GREEK SMALL LETTER SIGMA
      $03C4,$83D1,      // GREEK SMALL LETTER TAU
      $03C5,$83D2,      // GREEK SMALL LETTER UPSILON
      $03C6,$83D3,      // GREEK SMALL LETTER PHI
      $03C7,$83D4,      // GREEK SMALL LETTER CHI
      $03C8,$83D5,      // GREEK SMALL LETTER PSI
      $03C9,$83D6,      // GREEK SMALL LETTER OMEGA
      $0401,$8446,      // CYRILLIC CAPITAL LETTER IO
      $0410,$8440,      // CYRILLIC CAPITAL LETTER A
      $0411,$8441,      // CYRILLIC CAPITAL LETTER BE
      $0412,$8442,      // CYRILLIC CAPITAL LETTER VE
      $0413,$8443,      // CYRILLIC CAPITAL LETTER GHE
      $0414,$8444,      // CYRILLIC CAPITAL LETTER DE
      $0415,$8445,      // CYRILLIC CAPITAL LETTER IE
      $0416,$8447,      // CYRILLIC CAPITAL LETTER ZHE
      $0417,$8448,      // CYRILLIC CAPITAL LETTER ZE
      $0418,$8449,      // CYRILLIC CAPITAL LETTER I
      $0419,$844A,      // CYRILLIC CAPITAL LETTER SHORT I
      $041A,$844B,      // CYRILLIC CAPITAL LETTER KA
      $041B,$844C,      // CYRILLIC CAPITAL LETTER EL
      $041C,$844D,      // CYRILLIC CAPITAL LETTER EM
      $041D,$844E,      // CYRILLIC CAPITAL LETTER EN
      $041E,$844F,      // CYRILLIC CAPITAL LETTER O
      $041F,$8450,      // CYRILLIC CAPITAL LETTER PE
      $0420,$8451,      // CYRILLIC CAPITAL LETTER ER
      $0421,$8452,      // CYRILLIC CAPITAL LETTER ES
      $0422,$8453,      // CYRILLIC CAPITAL LETTER TE
      $0423,$8454,      // CYRILLIC CAPITAL LETTER U
      $0424,$8455,      // CYRILLIC CAPITAL LETTER EF
      $0425,$8456,      // CYRILLIC CAPITAL LETTER HA
      $0426,$8457,      // CYRILLIC CAPITAL LETTER TSE
      $0427,$8458,      // CYRILLIC CAPITAL LETTER CHE
      $0428,$8459,      // CYRILLIC CAPITAL LETTER SHA
      $0429,$845A,      // CYRILLIC CAPITAL LETTER SHCHA
      $042B,$845C,      // CYRILLIC CAPITAL LETTER YERU
      $042C,$845D,      // CYRILLIC CAPITAL LETTER SOFT SIGN
      $042D,$845E,      // CYRILLIC CAPITAL LETTER E
      $042E,$845F,      // CYRILLIC CAPITAL LETTER YU
      $042F,$8460,      // CYRILLIC CAPITAL LETTER YA
      $0430,$8470,      // CYRILLIC SMALL LETTER A
      $0431,$8471,      // CYRILLIC SMALL LETTER BE
      $0432,$8472,      // CYRILLIC SMALL LETTER VE
      $0433,$8473,      // CYRILLIC SMALL LETTER GHE
      $0434,$8474,      // CYRILLIC SMALL LETTER DE
      $0435,$8475,      // CYRILLIC SMALL LETTER IE
      $0436,$8477,      // CYRILLIC SMALL LETTER ZHE
      $0437,$8478,      // CYRILLIC SMALL LETTER ZE
      $0438,$8479,      // CYRILLIC SMALL LETTER I
      $0439,$847A,      // CYRILLIC SMALL LETTER SHORT I
      $043A,$847B,      // CYRILLIC SMALL LETTER KA
      $043B,$847C,      // CYRILLIC SMALL LETTER EL
      $043C,$847D,      // CYRILLIC SMALL LETTER EM
      $043D,$847E,      // CYRILLIC SMALL LETTER EN
      $043E,$8480,      // CYRILLIC SMALL LETTER O
      $043F,$8481,      // CYRILLIC SMALL LETTER PE
      $0440,$8482,      // CYRILLIC SMALL LETTER ER
      $0441,$8483,      // CYRILLIC SMALL LETTER ES
      $0442,$8484,      // CYRILLIC SMALL LETTER TE
      $0443,$8485,      // CYRILLIC SMALL LETTER U
      $0444,$8486,      // CYRILLIC SMALL LETTER EF
      $0445,$8487,      // CYRILLIC SMALL LETTER HA
      $0446,$8488,      // CYRILLIC SMALL LETTER TSE
      $0447,$8489,      // CYRILLIC SMALL LETTER CHE
      $0448,$848A,      // CYRILLIC SMALL LETTER SHA
      $0449,$848B,      // CYRILLIC SMALL LETTER SHCHA
      $044A,$848C,      // CYRILLIC SMALL LETTER HARD SIGN
      $044B,$848D,      // CYRILLIC SMALL LETTER YERU
      $044C,$848E,      // CYRILLIC SMALL LETTER SOFT SIGN
      $044D,$848F,      // CYRILLIC SMALL LETTER E
      $044E,$8490,      // CYRILLIC SMALL LETTER YU
      $044F,$8491,      // CYRILLIC SMALL LETTER YA
      $0451,$8476,      // CYRILLIC SMALL LETTER IO
      $2010,$815D,      // HYPHEN
      $2014,$815C,      // EM DASH
      $2016,$8161,      // DOUBLE VERTICAL LINE
      $2018,$8165,      // LEFT SINGLE QUOTATION MARK
      $2019,$8166,      // RIGHT SINGLE QUOTATION MARK
      $201C,$8167,      // LEFT DOUBLE QUOTATION MARK
      $201D,$8168,      // RIGHT DOUBLE QUOTATION MARK
      $2020,$81F5,      // DAGGER
      $2021,$81F6,      // DOUBLE DAGGER
      $2025,$8164,      // TWO DOT LEADER
      $2026,$8163,      // HORIZONTAL ELLIPSIS
      $2030,$81F1,      // PER MILLE SIGN
      $2032,$818C,      // PRIME
      $2033,$818D,      // DOUBLE PRIME
      $203B,$81A6,      // REFERENCE MARK
      $2103,$818E,      // DEGREE CELSIUS
      $212B,$81F0,      // ANGSTROM SIGN
      $2190,$81A9,      // LEFTWARDS ARROW
      $2191,$81AA,      // UPWARDS ARROW
      $2192,$81A8,      // RIGHTWARDS ARROW
      $2193,$81AB,      // DOWNWARDS ARROW
      $21D2,$81CB,      // RIGHTWARDS DOUBLE ARROW
      $21D4,$81CC,      // LEFT RIGHT DOUBLE ARROW
      $2200,$81CD,      // FOR ALL
      $2202,$81DD,      // PARTIAL DIFFERENTIAL
      $2203,$81CE,      // THERE EXISTS
      $2207,$81DE,      // NABLA
      $2208,$81B8,      // ELEMENT OF
      $220B,$81B9,      // CONTAINS AS MEMBER
      $2212,$817C,      // MINUS SIGN
      $221A,$81E3,      // SQUARE ROOT
      $221D,$81E5,      // PROPORTIONAL TO
      $221E,$8187,      // INFINITY
      $2220,$81DA,      // ANGLE
      $2227,$81C8,      // LOGICAL AND
      $2228,$81C9,      // LOGICAL OR
      $2229,$81BF,      // INTERSECTION
      $222A,$81BE,      // UNION
      $222B,$81E7,      // INTEGRAL
      $222C,$81E8,      // DOUBLE INTEGRAL
      $2234,$8188,      // THEREFORE
      $2235,$81E6,      // BECAUSE
      $223D,$81E4,      // REVERSED TILDE
      $2252,$81E0,      // APPROXIMATELY EQUAL TO OR THE IMAGE OF
      $2260,$8182,      // NOT EQUAL TO
      $2261,$81DF,      // IDENTICAL TO
      $2266,$8185,      // LESS-THAN OVER EQUAL TO
      $2267,$8186,      // GREATER-THAN OVER EQUAL TO
      $226A,$81E1,      // MUCH LESS-THAN
      $226B,$81E2,      // MUCH GREATER-THAN
      $2282,$81BC,      // SUBSET OF
      $2283,$81BD,      // SUPERSET OF
      $2286,$81BA,      // SUBSET OF OR EQUAL TO
      $2287,$81BB,      // SUPERSET OF OR EQUAL TO
      $22A5,$81DB,      // UP TACK
      $2312,$81DC,      // ARC
      $2500,$849F,      // BOX DRAWINGS LIGHT HORIZONTAL
      $2501,$84AA,      // BOX DRAWINGS HEAVY HORIZONTAL
      $2502,$84A0,      // BOX DRAWINGS LIGHT VERTICAL
      $2503,$84AB,      // BOX DRAWINGS HEAVY VERTICAL
      $250C,$84A1,      // BOX DRAWINGS LIGHT DOWN AND RIGHT
      $250F,$84AC,      // BOX DRAWINGS HEAVY DOWN AND RIGHT
      $2510,$84A2,      // BOX DRAWINGS LIGHT DOWN AND LEFT
      $2513,$84AD,      // BOX DRAWINGS HEAVY DOWN AND LEFT
      $2514,$84A4,      // BOX DRAWINGS LIGHT UP AND RIGHT
      $2517,$84AF,      // BOX DRAWINGS HEAVY UP AND RIGHT
      $2518,$84A3,      // BOX DRAWINGS LIGHT UP AND LEFT
      $251B,$84AE,      // BOX DRAWINGS HEAVY UP AND LEFT
      $251C,$84A5,      // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
      $251D,$84BA,      // BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
      $2520,$84B5,      // BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
      $2523,$84B0,      // BOX DRAWINGS HEAVY VERTICAL AND RIGHT
      $2524,$84A7,      // BOX DRAWINGS LIGHT VERTICAL AND LEFT
      $2525,$84BC,      // BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
      $2528,$84B7,      // BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
      $252B,$84B2,      // BOX DRAWINGS HEAVY VERTICAL AND LEFT
      $252C,$84A6,      // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
      $252F,$84B6,      // BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
      $2530,$84BB,      // BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
      $2533,$84B1,      // BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
      $2534,$84A8,      // BOX DRAWINGS LIGHT UP AND HORIZONTAL
      $2537,$84B8,      // BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
      $2538,$84BD,      // BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
      $253B,$84B3,      // BOX DRAWINGS HEAVY UP AND HORIZONTAL
      $253C,$84A9,      // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
      $253F,$84B9,      // BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
      $2542,$84BE,      // BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
      $254B,$84B4,      // BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
      $25A0,$81A1,      // BLACK SQUARE
      $25A1,$81A0,      // WHITE SQUARE
      $25B2,$81A3,      // BLACK UP-POINTING TRIANGLE
      $25B3,$81A2,      // WHITE UP-POINTING TRIANGLE
      $25BC,$81A5,      // BLACK DOWN-POINTING TRIANGLE
      $25BD,$81A4,      // WHITE DOWN-POINTING TRIANGLE
      $25C6,$819F,      // BLACK DIAMOND
      $25C7,$819E,      // WHITE DIAMOND
      $25CB,$819B,      // WHITE CIRCLE
      $25CE,$819D,      // BULLSEYE
      $25CF,$819C,      // BLACK CIRCLE
      $25EF,$81FC,      // LARGE CIRCLE
      $2605,$819A,      // BLACK STAR
      $2606,$8199,      // WHITE STAR
      $2640,$818A,      // FEMALE SIGN
      $2642,$8189,      // MALE SIGN
      $266A,$81F4,      // EIGHTH NOTE
      $266D,$81F3,      // MUSIC FLAT SIGN
      $266F,$81F2,      // MUSIC SHARP SIGN
      $3000,$8140,      // IDEOGRAPHIC SPACE
      $3001,$8141,      // IDEOGRAPHIC COMMA
      $3002,$8142,      // IDEOGRAPHIC FULL STOP
      $3003,$8156,      // DITTO MARK
      $3005,$8158,      // IDEOGRAPHIC ITERATION MARK
      $3006,$8159,      // IDEOGRAPHIC CLOSING MARK
      $3007,$815A,      // IDEOGRAPHIC NUMBER ZERO
      $3008,$8171,      // LEFT ANGLE BRACKET
      $3009,$8172,      // RIGHT ANGLE BRACKET
      $300A,$8173,      // LEFT DOUBLE ANGLE BRACKET
      $300B,$8174,      // RIGHT DOUBLE ANGLE BRACKET
      $300C,$8175,      // LEFT CORNER BRACKET
      $300D,$8176,      // RIGHT CORNER BRACKET
      $300E,$8177,      // LEFT WHITE CORNER BRACKET
      $300F,$8178,      // RIGHT WHITE CORNER BRACKET
      $3010,$8179,      // LEFT BLACK LENTICULAR BRACKET
      $3011,$817A,      // RIGHT BLACK LENTICULAR BRACKET
      $3012,$81A7,      // POSTAL MARK
      $3013,$81AC,      // GETA MARK
      $3014,$816B,      // LEFT TORTOISE SHELL BRACKET
      $3015,$816C,      // RIGHT TORTOISE SHELL BRACKET
      $301C,$8160,      // WAVE DASH
      $3041,$829F,      // HIRAGANA LETTER SMALL A
      $3042,$82A0,      // HIRAGANA LETTER A
      $3043,$82A1,      // HIRAGANA LETTER SMALL I
      $3044,$82A2,      // HIRAGANA LETTER I
      $3045,$82A3,      // HIRAGANA LETTER SMALL U
      $3046,$82A4,      // HIRAGANA LETTER U
      $3047,$82A5,      // HIRAGANA LETTER SMALL E
      $3048,$82A6,      // HIRAGANA LETTER E
      $3049,$82A7,      // HIRAGANA LETTER SMALL O
      $304A,$82A8,      // HIRAGANA LETTER O
      $304B,$82A9,      // HIRAGANA LETTER KA
      $304C,$82AA,      // HIRAGANA LETTER GA
      $304D,$82AB,      // HIRAGANA LETTER KI
      $304E,$82AC,      // HIRAGANA LETTER GI
      $304F,$82AD,      // HIRAGANA LETTER KU
      $3050,$82AE,      // HIRAGANA LETTER GU
      $3051,$82AF,      // HIRAGANA LETTER KE
      $3052,$82B0,      // HIRAGANA LETTER GE
      $3053,$82B1,      // HIRAGANA LETTER KO
      $3054,$82B2,      // HIRAGANA LETTER GO
      $3055,$82B3,      // HIRAGANA LETTER SA
      $3056,$82B4,      // HIRAGANA LETTER ZA
      $3057,$82B5,      // HIRAGANA LETTER SI
      $3058,$82B6,      // HIRAGANA LETTER ZI
      $3059,$82B7,      // HIRAGANA LETTER SU
      $305A,$82B8,      // HIRAGANA LETTER ZU
      $305B,$82B9,      // HIRAGANA LETTER SE
      $305C,$82BA,      // HIRAGANA LETTER ZE
      $305D,$82BB,      // HIRAGANA LETTER SO
      $305E,$82BC,      // HIRAGANA LETTER ZO
      $305F,$82BD,      // HIRAGANA LETTER TA
      $3060,$82BE,      // HIRAGANA LETTER DA
      $3061,$82BF,      // HIRAGANA LETTER TI
      $3062,$82C0,      // HIRAGANA LETTER DI
      $3063,$82C1,      // HIRAGANA LETTER SMALL TU
      $3064,$82C2,      // HIRAGANA LETTER TU
      $3065,$82C3,      // HIRAGANA LETTER DU
      $3066,$82C4,      // HIRAGANA LETTER TE
      $3067,$82C5,      // HIRAGANA LETTER DE
      $3068,$82C6,      // HIRAGANA LETTER TO
      $3069,$82C7,      // HIRAGANA LETTER DO
      $306A,$82C8,      // HIRAGANA LETTER NA
      $306B,$82C9,      // HIRAGANA LETTER NI
      $306C,$82CA,      // HIRAGANA LETTER NU
      $306D,$82CB,      // HIRAGANA LETTER NE
      $306E,$82CC,      // HIRAGANA LETTER NO
      $306F,$82CD,      // HIRAGANA LETTER HA
      $3070,$82CE,      // HIRAGANA LETTER BA
      $3071,$82CF,      // HIRAGANA LETTER PA
      $3072,$82D0,      // HIRAGANA LETTER HI
      $3073,$82D1,      // HIRAGANA LETTER BI
      $3074,$82D2,      // HIRAGANA LETTER PI
      $3075,$82D3,      // HIRAGANA LETTER HU
      $3076,$82D4,      // HIRAGANA LETTER BU
      $3077,$82D5,      // HIRAGANA LETTER PU
      $3078,$82D6,      // HIRAGANA LETTER HE
      $3079,$82D7,      // HIRAGANA LETTER BE
      $307A,$82D8,      // HIRAGANA LETTER PE
      $307B,$82D9,      // HIRAGANA LETTER HO
      $307C,$82DA,      // HIRAGANA LETTER BO
      $307D,$82DB,      // HIRAGANA LETTER PO
      $307E,$82DC,      // HIRAGANA LETTER MA
      $307F,$82DD,      // HIRAGANA LETTER MI
      $3080,$82DE,      // HIRAGANA LETTER MU
      $3081,$82DF,      // HIRAGANA LETTER ME
      $3082,$82E0,      // HIRAGANA LETTER MO
      $3083,$82E1,      // HIRAGANA LETTER SMALL YA
      $3084,$82E2,      // HIRAGANA LETTER YA
      $3085,$82E3,      // HIRAGANA LETTER SMALL YU
      $3086,$82E4,      // HIRAGANA LETTER YU
      $3087,$82E5,      // HIRAGANA LETTER SMALL YO
      $3088,$82E6,      // HIRAGANA LETTER YO
      $3089,$82E7,      // HIRAGANA LETTER RA
      $308A,$82E8,      // HIRAGANA LETTER RI
      $308B,$82E9,      // HIRAGANA LETTER RU
      $308C,$82EA,      // HIRAGANA LETTER RE
      $308D,$82EB,      // HIRAGANA LETTER RO
      $308E,$82EC,      // HIRAGANA LETTER SMALL WA
      $308F,$82ED,      // HIRAGANA LETTER WA
      $3090,$82EE,      // HIRAGANA LETTER WI
      $3091,$82EF,      // HIRAGANA LETTER WE
      $3092,$82F0,      // HIRAGANA LETTER WO
      $3093,$82F1,      // HIRAGANA LETTER N
      $309B,$814A,      // KATAKANA-HIRAGANA VOICED SOUND MARK
      $309C,$814B,      // KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
      $309D,$8154,      // HIRAGANA ITERATION MARK
      $309E,$8155,      // HIRAGANA VOICED ITERATION MARK
      $30A1,$8340,      // KATAKANA LETTER SMALL A
      $30A2,$8341,      // KATAKANA LETTER A
      $30A3,$8342,      // KATAKANA LETTER SMALL I
      $30A4,$8343,      // KATAKANA LETTER I
      $30A5,$8344,      // KATAKANA LETTER SMALL U
      $30A6,$8345,      // KATAKANA LETTER U
      $30A7,$8346,      // KATAKANA LETTER SMALL E
      $30A8,$8347,      // KATAKANA LETTER E
      $30A9,$8348,      // KATAKANA LETTER SMALL O
      $30AA,$8349,      // KATAKANA LETTER O
      $30AB,$834A,      // KATAKANA LETTER KA
      $30AC,$834B,      // KATAKANA LETTER GA
      $30AD,$834C,      // KATAKANA LETTER KI
      $30AE,$834D,      // KATAKANA LETTER GI
      $30AF,$834E,      // KATAKANA LETTER KU
      $30B0,$834F,      // KATAKANA LETTER GU
      $30B1,$8350,      // KATAKANA LETTER KE
      $30B2,$8351,      // KATAKANA LETTER GE
      $30B3,$8352,      // KATAKANA LETTER KO
      $30B4,$8353,      // KATAKANA LETTER GO
      $30B5,$8354,      // KATAKANA LETTER SA
      $30B6,$8355,      // KATAKANA LETTER ZA
      $30B7,$8356,      // KATAKANA LETTER SI
      $30B8,$8357,      // KATAKANA LETTER ZI
      $30B9,$8358,      // KATAKANA LETTER SU
      $30BA,$8359,      // KATAKANA LETTER ZU
      $30BB,$835A,      // KATAKANA LETTER SE
      $30BD,$835C,      // KATAKANA LETTER SO
      $30BE,$835D,      // KATAKANA LETTER ZO
      $30BF,$835E,      // KATAKANA LETTER TA
      $30C0,$835F,      // KATAKANA LETTER DA
      $30C1,$8360,      // KATAKANA LETTER TI
      $30C2,$8361,      // KATAKANA LETTER DI
      $30C3,$8362,      // KATAKANA LETTER SMALL TU
      $30C4,$8363,      // KATAKANA LETTER TU
      $30C5,$8364,      // KATAKANA LETTER DU
      $30C6,$8365,      // KATAKANA LETTER TE
      $30C7,$8366,      // KATAKANA LETTER DE
      $30C8,$8367,      // KATAKANA LETTER TO
      $30C9,$8368,      // KATAKANA LETTER DO
      $30CA,$8369,      // KATAKANA LETTER NA
      $30CB,$836A,      // KATAKANA LETTER NI
      $30CC,$836B,      // KATAKANA LETTER NU
      $30CD,$836C,      // KATAKANA LETTER NE
      $30CE,$836D,      // KATAKANA LETTER NO
      $30CF,$836E,      // KATAKANA LETTER HA
      $30D0,$836F,      // KATAKANA LETTER BA
      $30D1,$8370,      // KATAKANA LETTER PA
      $30D2,$8371,      // KATAKANA LETTER HI
      $30D3,$8372,      // KATAKANA LETTER BI
      $30D4,$8373,      // KATAKANA LETTER PI
      $30D5,$8374,      // KATAKANA LETTER HU
      $30D6,$8375,      // KATAKANA LETTER BU
      $30D7,$8376,      // KATAKANA LETTER PU
      $30D8,$8377,      // KATAKANA LETTER HE
      $30D9,$8378,      // KATAKANA LETTER BE
      $30DA,$8379,      // KATAKANA LETTER PE
      $30DB,$837A,      // KATAKANA LETTER HO
      $30DC,$837B,      // KATAKANA LETTER BO
      $30DD,$837C,      // KATAKANA LETTER PO
      $30DE,$837D,      // KATAKANA LETTER MA
      $30DF,$837E,      // KATAKANA LETTER MI
      $30E0,$8380,      // KATAKANA LETTER MU
      $30E1,$8381,      // KATAKANA LETTER ME
      $30E2,$8382,      // KATAKANA LETTER MO
      $30E3,$8383,      // KATAKANA LETTER SMALL YA
      $30E4,$8384,      // KATAKANA LETTER YA
      $30E5,$8385,      // KATAKANA LETTER SMALL YU
      $30E6,$8386,      // KATAKANA LETTER YU
      $30E7,$8387,      // KATAKANA LETTER SMALL YO
      $30E8,$8388,      // KATAKANA LETTER YO
      $30E9,$8389,      // KATAKANA LETTER RA
      $30EA,$838A,      // KATAKANA LETTER RI
      $30EB,$838B,      // KATAKANA LETTER RU
      $30EC,$838C,      // KATAKANA LETTER RE
      $30ED,$838D,      // KATAKANA LETTER RO
      $30EE,$838E,      // KATAKANA LETTER SMALL WA
      $30EF,$838F,      // KATAKANA LETTER WA
      $30F0,$8390,      // KATAKANA LETTER WI
      $30F1,$8391,      // KATAKANA LETTER WE
      $30F2,$8392,      // KATAKANA LETTER WO
      $30F3,$8393,      // KATAKANA LETTER N
      $30F4,$8394,      // KATAKANA LETTER VU
      $30F5,$8395,      // KATAKANA LETTER SMALL KA
      $30F6,$8396,      // KATAKANA LETTER SMALL KE
      $30FB,$8145,      // KATAKANA MIDDLE DOT
      $30FD,$8152,      // KATAKANA ITERATION MARK
      $30FE,$8153,      // KATAKANA VOICED ITERATION MARK
      $4E00,$88EA,      // <cjk>
      $4E01,$929A,      // <cjk>
      $4E03,$8EB5,      // <cjk>
      $4E07,$969C,      // <cjk>
      $4E08,$8FE4,      // <cjk>
      $4E09,$8E4F,      // <cjk>
      $4E0A,$8FE3,      // <cjk>
      $4E0B,$89BA,      // <cjk>
      $4E0D,$9573,      // <cjk>
      $4E0E,$975E,      // <cjk>
      $4E10,$98A0,      // <cjk>
      $4E11,$894E,      // <cjk>
      $4E14,$8A8E,      // <cjk>
      $4E15,$98A1,      // <cjk>
      $4E16,$90A2,      // <cjk>
      $4E17,$99C0,      // <cjk>
      $4E18,$8B75,      // <cjk>
      $4E19,$95B8,      // <cjk>
      $4E1E,$8FE5,      // <cjk>
      $4E21,$97BC,      // <cjk>
      $4E26,$95C0,      // <cjk>
      $4E2A,$98A2,      // <cjk>
      $4E2D,$9286,      // <cjk>
      $4E31,$98A3,      // <cjk>
      $4E32,$8BF8,      // <cjk>
      $4E36,$98A4,      // <cjk>
      $4E38,$8ADB,      // <cjk>
      $4E39,$924F,      // <cjk>
      $4E3B,$8EE5,      // <cjk>
      $4E3C,$98A5,      // <cjk>
      $4E3F,$98A6,      // <cjk>
      $4E42,$98A7,      // <cjk>
      $4E43,$9454,      // <cjk>
      $4E45,$8B76,      // <cjk>
      $4E4B,$9456,      // <cjk>
      $4E4D,$93E1,      // <cjk>
      $4E4E,$8CC1,      // <cjk>
      $4E4F,$9652,      // <cjk>
      $4E55,$E568,      // <cjk>
      $4E56,$98A8,      // <cjk>
      $4E57,$8FE6,      // <cjk>
      $4E58,$98A9,      // <cjk>
      $4E59,$89B3,      // <cjk>
      $4E5D,$8BE3,      // <cjk>
      $4E5E,$8CEE,      // <cjk>
      $4E5F,$96E7,      // <cjk>
      $4E62,$9BA4,      // <cjk>
      $4E71,$9790,      // <cjk>
      $4E73,$93FB,      // <cjk>
      $4E7E,$8AA3,      // <cjk>
      $4E80,$8B54,      // <cjk>
      $4E82,$98AA,      // <cjk>
      $4E85,$98AB,      // <cjk>
      $4E86,$97B9,      // <cjk>
      $4E88,$975C,      // <cjk>
      $4E89,$9188,      // <cjk>
      $4E8A,$98AD,      // <cjk>
      $4E8B,$8E96,      // <cjk>
      $4E8C,$93F1,      // <cjk>
      $4E8E,$98B0,      // <cjk>
      $4E91,$895D,      // <cjk>
      $4E92,$8CDD,      // <cjk>
      $4E94,$8CDC,      // <cjk>
      $4E95,$88E4,      // <cjk>
      $4E98,$986A,      // <cjk>
      $4E99,$9869,      // <cjk>
      $4E9B,$8DB1,      // <cjk>
      $4E9C,$889F,      // <cjk>
      $4E9E,$98B1,      // <cjk>
      $4E9F,$98B2,      // <cjk>
      $4EA0,$98B3,      // <cjk>
      $4EA1,$9653,      // <cjk>
      $4EA2,$98B4,      // <cjk>
      $4EA4,$8CF0,      // <cjk>
      $4EA5,$88E5,      // <cjk>
      $4EA6,$9692,      // <cjk>
      $4EA8,$8B9C,      // <cjk>
      $4EAB,$8B9D,      // <cjk>
      $4EAC,$8B9E,      // <cjk>
      $4EAD,$92E0,      // <cjk>
      $4EAE,$97BA,      // <cjk>
      $4EB0,$98B5,      // <cjk>
      $4EB3,$98B6,      // <cjk>
      $4EB6,$98B7,      // <cjk>
      $4EBA,$906C,      // <cjk>
      $4EC0,$8F59,      // <cjk>
      $4EC1,$906D,      // <cjk>
      $4EC2,$98BC,      // <cjk>
      $4EC4,$98BA,      // <cjk>
      $4EC6,$98BB,      // <cjk>
      $4EC7,$8B77,      // <cjk>
      $4ECA,$8DA1,      // <cjk>
      $4ECB,$89EE,      // <cjk>
      $4ECD,$98B9,      // <cjk>
      $4ECE,$98B8,      // <cjk>
      $4ECF,$95A7,      // <cjk>
      $4ED4,$8E65,      // <cjk>
      $4ED5,$8E64,      // <cjk>
      $4ED6,$91BC,      // <cjk>
      $4ED7,$98BD,      // <cjk>
      $4ED8,$9574,      // <cjk>
      $4ED9,$90E5,      // <cjk>
      $4EDD,$8157,      // <cjk>
      $4EDE,$98BE,      // <cjk>
      $4EDF,$98C0,      // <cjk>
      $4EE3,$91E3,      // <cjk>
      $4EE4,$97DF,      // <cjk>
      $4EE5,$88C8,      // <cjk>
      $4EED,$98BF,      // <cjk>
      $4EEE,$89BC,      // <cjk>
      $4EF0,$8BC2,      // <cjk>
      $4EF2,$9287,      // <cjk>
      $4EF6,$8C8F,      // <cjk>
      $4EF7,$98C1,      // <cjk>
      $4EFB,$9443,      // <cjk>
      $4F01,$8AE9,      // <cjk>
      $4F09,$98C2,      // <cjk>
      $4F0A,$88C9,      // <cjk>
      $4F0D,$8CDE,      // <cjk>
      $4F0E,$8AEA,      // <cjk>
      $4F0F,$959A,      // <cjk>
      $4F10,$94B0,      // <cjk>
      $4F11,$8B78,      // <cjk>
      $4F1A,$89EF,      // <cjk>
      $4F1C,$98E5,      // <cjk>
      $4F1D,$9360,      // <cjk>
      $4F2F,$948C,      // <cjk>
      $4F30,$98C4,      // <cjk>
      $4F34,$94BA,      // <cjk>
      $4F36,$97E0,      // <cjk>
      $4F38,$904C,      // <cjk>
      $4F3A,$8E66,      // <cjk>
      $4F3C,$8E97,      // <cjk>
      $4F3D,$89BE,      // <cjk>
      $4F43,$92CF,      // <cjk>
      $4F46,$9241,      // <cjk>
      $4F47,$98C8,      // <cjk>
      $4F4D,$88CA,      // <cjk>
      $4F4E,$92E1,      // <cjk>
      $4F4F,$8F5A,      // <cjk>
      $4F50,$8DB2,      // <cjk>
      $4F51,$9743,      // <cjk>
      $4F53,$91CC,      // <cjk>
      $4F55,$89BD,      // <cjk>
      $4F57,$98C7,      // <cjk>
      $4F59,$975D,      // <cjk>
      $4F5A,$98C3,      // <cjk>
      $4F5B,$98C5,      // <cjk>
      $4F5C,$8DEC,      // <cjk>
      $4F5D,$98C6,      // <cjk>
      $4F5E,$9B43,      // <cjk>
      $4F69,$98CE,      // <cjk>
      $4F6F,$98D1,      // <cjk>
      $4F70,$98CF,      // <cjk>
      $4F73,$89C0,      // <cjk>
      $4F75,$95B9,      // <cjk>
      $4F76,$98C9,      // <cjk>
      $4F7B,$98CD,      // <cjk>
      $4F7C,$8CF1,      // <cjk>
      $4F7F,$8E67,      // <cjk>
      $4F83,$8AA4,      // <cjk>
      $4F86,$98D2,      // <cjk>
      $4F88,$98CA,      // <cjk>
      $4F8B,$97E1,      // <cjk>
      $4F8D,$8E98,      // <cjk>
      $4F8F,$98CB,      // <cjk>
      $4F91,$98D0,      // <cjk>
      $4F96,$98D3,      // <cjk>
      $4F98,$98CC,      // <cjk>
      $4F9B,$8B9F,      // <cjk>
      $4F9D,$88CB,      // <cjk>
      $4FA0,$8BA0,      // <cjk>
      $4FA1,$89BF,      // <cjk>
      $4FAB,$9B44,      // <cjk>
      $4FAD,$9699,      // <cjk>
      $4FAE,$958E,      // <cjk>
      $4FAF,$8CF2,      // <cjk>
      $4FB5,$904E,      // <cjk>
      $4FB6,$97B5,      // <cjk>
      $4FBF,$95D6,      // <cjk>
      $4FC2,$8C57,      // <cjk>
      $4FC3,$91A3,      // <cjk>
      $4FC4,$89E2,      // <cjk>
      $4FCA,$8F72,      // <cjk>
      $4FCE,$98D7,      // <cjk>
      $4FD0,$98DC,      // <cjk>
      $4FD1,$98DA,      // <cjk>
      $4FD4,$98D5,      // <cjk>
      $4FD7,$91AD,      // <cjk>
      $4FD8,$98D8,      // <cjk>
      $4FDA,$98DB,      // <cjk>
      $4FDB,$98D9,      // <cjk>
      $4FDD,$95DB,      // <cjk>
      $4FDF,$98D6,      // <cjk>
      $4FE1,$904D,      // <cjk>
      $4FE3,$9693,      // <cjk>
      $4FE4,$98DD,      // <cjk>
      $4FE5,$98DE,      // <cjk>
      $4FEE,$8F43,      // <cjk>
      $4FEF,$98EB,      // <cjk>
      $4FF3,$946F,      // <cjk>
      $4FF5,$9555,      // <cjk>
      $4FF6,$98E6,      // <cjk>
      $4FF8,$95EE,      // <cjk>
      $4FFA,$89B4,      // <cjk>
      $4FFE,$98EA,      // <cjk>
      $5005,$98E4,      // <cjk>
      $5006,$98ED,      // <cjk>
      $5009,$9171,      // <cjk>
      $500B,$8CC2,      // <cjk>
      $500D,$947B,      // <cjk>
      $500F,$E0C5,      // <cjk>
      $5011,$98EC,      // <cjk>
      $5012,$937C,      // <cjk>
      $5014,$98E1,      // <cjk>
      $5016,$8CF4,      // <cjk>
      $5019,$8CF3,      // <cjk>
      $501A,$98DF,      // <cjk>
      $501F,$8ED8,      // <cjk>
      $5021,$98E7,      // <cjk>
      $5023,$95ED,      // <cjk>
      $5024,$926C,      // <cjk>
      $5025,$98E3,      // <cjk>
      $5026,$8C91,      // <cjk>
      $5028,$98E0,      // <cjk>
      $5029,$98E8,      // <cjk>
      $502A,$98E2,      // <cjk>
      $502B,$97CF,      // <cjk>
      $502C,$98E9,      // <cjk>
      $502D,$9860,      // <cjk>
      $5036,$8BE4,      // <cjk>
      $5039,$8C90,      // <cjk>
      $5043,$98EE,      // <cjk>
      $5047,$98EF,      // <cjk>
      $5048,$98F3,      // <cjk>
      $5049,$88CC,      // <cjk>
      $504F,$95CE,      // <cjk>
      $5050,$98F2,      // <cjk>
      $5055,$98F1,      // <cjk>
      $5056,$98F5,      // <cjk>
      $505A,$98F4,      // <cjk>
      $505C,$92E2,      // <cjk>
      $5065,$8C92,      // <cjk>
      $506C,$98F6,      // <cjk>
      $5072,$8EC3,      // <cjk>
      $5074,$91A4,      // <cjk>
      $5075,$92E3,      // <cjk>
      $5076,$8BF4,      // <cjk>
      $5078,$98F7,      // <cjk>
      $507D,$8B55,      // <cjk>
      $5080,$98F8,      // <cjk>
      $5085,$98FA,      // <cjk>
      $508D,$9654,      // <cjk>
      $5091,$8C86,      // <cjk>
      $5098,$8E50,      // <cjk>
      $5099,$94F5,      // <cjk>
      $509A,$98F9,      // <cjk>
      $50AC,$8DC3,      // <cjk>
      $50AD,$9762,      // <cjk>
      $50B2,$98FC,      // <cjk>
      $50B3,$9942,      // <cjk>
      $50B4,$98FB,      // <cjk>
      $50B5,$8DC2,      // <cjk>
      $50B7,$8F9D,      // <cjk>
      $50BE,$8C58,      // <cjk>
      $50C2,$9943,      // <cjk>
      $50C5,$8BCD,      // <cjk>
      $50C9,$9940,      // <cjk>
      $50CA,$9941,      // <cjk>
      $50CD,$93AD,      // <cjk>
      $50CF,$919C,      // <cjk>
      $50D1,$8BA1,      // <cjk>
      $50D5,$966C,      // <cjk>
      $50D6,$9944,      // <cjk>
      $50DA,$97BB,      // <cjk>
      $50DE,$9945,      // <cjk>
      $50E3,$9948,      // <cjk>
      $50E5,$9946,      // <cjk>
      $50E7,$916D,      // <cjk>
      $50ED,$9947,      // <cjk>
      $50EE,$9949,      // <cjk>
      $50F5,$994B,      // <cjk>
      $50F9,$994A,      // <cjk>
      $50FB,$95C6,      // <cjk>
      $5100,$8B56,      // <cjk>
      $5101,$994D,      // <cjk>
      $5102,$994E,      // <cjk>
      $5104,$89AD,      // <cjk>
      $5109,$994C,      // <cjk>
      $5112,$8EF2,      // <cjk>
      $5114,$9951,      // <cjk>
      $5115,$9950,      // <cjk>
      $5116,$994F,      // <cjk>
      $5118,$98D4,      // <cjk>
      $511A,$9952,      // <cjk>
      $511F,$8F9E,      // <cjk>
      $5121,$9953,      // <cjk>
      $512A,$9744,      // <cjk>
      $5132,$96D7,      // <cjk>
      $5137,$9955,      // <cjk>
      $513A,$9954,      // <cjk>
      $513B,$9957,      // <cjk>
      $513C,$9956,      // <cjk>
      $513F,$9958,      // <cjk>
      $5140,$9959,      // <cjk>
      $5141,$88F2,      // <cjk>
      $5143,$8CB3,      // <cjk>
      $5144,$8C5A,      // <cjk>
      $5146,$929B,      // <cjk>
      $5147,$8BA2,      // <cjk>
      $5148,$90E6,      // <cjk>
      $5149,$8CF5,      // <cjk>
      $514B,$8D8E,      // <cjk>
      $514D,$96C6,      // <cjk>
      $514E,$9365,      // <cjk>
      $5150,$8E99,      // <cjk>
      $5152,$995A,      // <cjk>
      $5154,$995C,      // <cjk>
      $515A,$937D,      // <cjk>
      $515C,$8A95,      // <cjk>
      $5162,$995D,      // <cjk>
      $5165,$93FC,      // <cjk>
      $5168,$9153,      // <cjk>
      $5169,$995F,      // <cjk>
      $516A,$9960,      // <cjk>
      $516B,$94AA,      // <cjk>
      $516C,$8CF6,      // <cjk>
      $516D,$985A,      // <cjk>
      $516E,$9961,      // <cjk>
      $5171,$8BA4,      // <cjk>
      $5175,$95BA,      // <cjk>
      $5176,$91B4,      // <cjk>
      $5177,$8BEF,      // <cjk>
      $5178,$9354,      // <cjk>
      $517C,$8C93,      // <cjk>
      $5180,$9962,      // <cjk>
      $5182,$9963,      // <cjk>
      $5185,$93E0,      // <cjk>
      $5186,$897E,      // <cjk>
      $5189,$9966,      // <cjk>
      $518A,$8DFB,      // <cjk>
      $518C,$9965,      // <cjk>
      $518D,$8DC4,      // <cjk>
      $518F,$9967,      // <cjk>
      $5190,$E3EC,      // <cjk>
      $5191,$9968,      // <cjk>
      $5192,$9660,      // <cjk>
      $5193,$9969,      // <cjk>
      $5195,$996A,      // <cjk>
      $5196,$996B,      // <cjk>
      $5197,$8FE7,      // <cjk>
      $5199,$8ECA,      // <cjk>
      $51A0,$8AA5,      // <cjk>
      $51A2,$996E,      // <cjk>
      $51A4,$996C,      // <cjk>
      $51A5,$96BB,      // <cjk>
      $51A6,$996D,      // <cjk>
      $51A8,$9579,      // <cjk>
      $51A9,$996F,      // <cjk>
      $51AA,$9970,      // <cjk>
      $51AB,$9971,      // <cjk>
      $51AC,$937E,      // <cjk>
      $51B0,$9975,      // <cjk>
      $51B1,$9973,      // <cjk>
      $51B2,$9974,      // <cjk>
      $51B3,$9972,      // <cjk>
      $51B4,$8DE1,      // <cjk>
      $51B5,$9976,      // <cjk>
      $51B6,$96E8,      // <cjk>
      $51B7,$97E2,      // <cjk>
      $51BD,$9977,      // <cjk>
      $51C4,$90A6,      // <cjk>
      $51C5,$9978,      // <cjk>
      $51C6,$8F79,      // <cjk>
      $51C9,$9979,      // <cjk>
      $51CB,$929C,      // <cjk>
      $51CC,$97BD,      // <cjk>
      $51CD,$9380,      // <cjk>
      $51D6,$99C3,      // <cjk>
      $51DB,$997A,      // <cjk>
      $51DC,$EAA3,      // <cjk>
      $51DD,$8BC3,      // <cjk>
      $51E0,$997B,      // <cjk>
      $51E1,$967D,      // <cjk>
      $51E6,$8F88,      // <cjk>
      $51E7,$91FA,      // <cjk>
      $51E9,$997D,      // <cjk>
      $51EA,$93E2,      // <cjk>
      $51ED,$997E,      // <cjk>
      $51F0,$9980,      // <cjk>
      $51F1,$8A4D,      // <cjk>
      $51F5,$9981,      // <cjk>
      $51F6,$8BA5,      // <cjk>
      $51F8,$93CA,      // <cjk>
      $51F9,$899A,      // <cjk>
      $51FA,$8F6F,      // <cjk>
      $51FD,$949F,      // <cjk>
      $51FE,$9982,      // <cjk>
      $5200,$9381,      // <cjk>
      $5203,$906E,      // <cjk>
      $5204,$9983,      // <cjk>
      $5206,$95AA,      // <cjk>
      $5207,$90D8,      // <cjk>
      $5208,$8AA0,      // <cjk>
      $520A,$8AA7,      // <cjk>
      $520B,$9984,      // <cjk>
      $520E,$9986,      // <cjk>
      $5211,$8C59,      // <cjk>
      $5214,$9985,      // <cjk>
      $5217,$97F1,      // <cjk>
      $521D,$8F89,      // <cjk>
      $5224,$94BB,      // <cjk>
      $5225,$95CA,      // <cjk>
      $5227,$9987,      // <cjk>
      $5229,$9798,      // <cjk>
      $522A,$9988,      // <cjk>
      $522E,$9989,      // <cjk>
      $5230,$939E,      // <cjk>
      $5233,$998A,      // <cjk>
      $5236,$90A7,      // <cjk>
      $5237,$8DFC,      // <cjk>
      $5238,$8C94,      // <cjk>
      $5239,$998B,      // <cjk>
      $523A,$8E68,      // <cjk>
      $523B,$8D8F,      // <cjk>
      $5243,$92E4,      // <cjk>
      $5244,$998D,      // <cjk>
      $5247,$91A5,      // <cjk>
      $524A,$8DED,      // <cjk>
      $524B,$998E,      // <cjk>
      $524C,$998F,      // <cjk>
      $524D,$914F,      // <cjk>
      $524F,$998C,      // <cjk>
      $5254,$9991,      // <cjk>
      $5256,$9655,      // <cjk>
      $525B,$8D84,      // <cjk>
      $525E,$9990,      // <cjk>
      $5263,$8C95,      // <cjk>
      $5264,$8DDC,      // <cjk>
      $5265,$948D,      // <cjk>
      $5269,$9994,      // <cjk>
      $526A,$9992,      // <cjk>
      $526F,$959B,      // <cjk>
      $5270,$8FE8,      // <cjk>
      $5271,$999B,      // <cjk>
      $5272,$8A84,      // <cjk>
      $5273,$9995,      // <cjk>
      $5274,$9993,      // <cjk>
      $5275,$916E,      // <cjk>
      $527D,$9997,      // <cjk>
      $527F,$9996,      // <cjk>
      $5283,$8A63,      // <cjk>
      $5287,$8C80,      // <cjk>
      $5288,$999C,      // <cjk>
      $5289,$97AB,      // <cjk>
      $528D,$9998,      // <cjk>
      $5291,$999D,      // <cjk>
      $5292,$999A,      // <cjk>
      $5294,$9999,      // <cjk>
      $529B,$97CD,      // <cjk>
      $529F,$8CF7,      // <cjk>
      $52A0,$89C1,      // <cjk>
      $52A3,$97F2,      // <cjk>
      $52A9,$8F95,      // <cjk>
      $52AA,$9377,      // <cjk>
      $52AB,$8D85,      // <cjk>
      $52AC,$99A0,      // <cjk>
      $52AD,$99A1,      // <cjk>
      $52B1,$97E3,      // <cjk>
      $52B4,$984A,      // <cjk>
      $52B5,$99A3,      // <cjk>
      $52B9,$8CF8,      // <cjk>
      $52BC,$99A2,      // <cjk>
      $52BE,$8A4E,      // <cjk>
      $52C1,$99A4,      // <cjk>
      $52C3,$9675,      // <cjk>
      $52C5,$92BA,      // <cjk>
      $52C7,$9745,      // <cjk>
      $52C9,$95D7,      // <cjk>
      $52CD,$99A5,      // <cjk>
      $52D2,$E8D3,      // <cjk>
      $52D5,$93AE,      // <cjk>
      $52D7,$99A6,      // <cjk>
      $52D8,$8AA8,      // <cjk>
      $52D9,$96B1,      // <cjk>
      $52DD,$8F9F,      // <cjk>
      $52DE,$99A7,      // <cjk>
      $52DF,$95E5,      // <cjk>
      $52E0,$99AB,      // <cjk>
      $52E2,$90A8,      // <cjk>
      $52E3,$99A8,      // <cjk>
      $52E4,$8BCE,      // <cjk>
      $52E6,$99A9,      // <cjk>
      $52E7,$8AA9,      // <cjk>
      $52F2,$8C4D,      // <cjk>
      $52F3,$99AC,      // <cjk>
      $52F5,$99AD,      // <cjk>
      $52F8,$99AE,      // <cjk>
      $52F9,$99AF,      // <cjk>
      $52FA,$8ED9,      // <cjk>
      $52FE,$8CF9,      // <cjk>
      $52FF,$96DC,      // <cjk>
      $5301,$96E6,      // <cjk>
      $5302,$93F5,      // <cjk>
      $5305,$95EF,      // <cjk>
      $5306,$99B0,      // <cjk>
      $5308,$99B1,      // <cjk>
      $530D,$99B3,      // <cjk>
      $530F,$99B5,      // <cjk>
      $5310,$99B4,      // <cjk>
      $5315,$99B6,      // <cjk>
      $5316,$89BB,      // <cjk>
      $5317,$966B,      // <cjk>
      $5319,$8DFA,      // <cjk>
      $531A,$99B7,      // <cjk>
      $531D,$9178,      // <cjk>
      $5320,$8FA0,      // <cjk>
      $5321,$8BA7,      // <cjk>
      $5323,$99B8,      // <cjk>
      $532A,$94D9,      // <cjk>
      $532F,$99B9,      // <cjk>
      $5331,$99BA,      // <cjk>
      $5333,$99BB,      // <cjk>
      $5338,$99BC,      // <cjk>
      $5339,$9543,      // <cjk>
      $533A,$8BE6,      // <cjk>
      $533B,$88E3,      // <cjk>
      $533F,$93BD,      // <cjk>
      $5340,$99BD,      // <cjk>
      $5341,$8F5C,      // <cjk>
      $5343,$90E7,      // <cjk>
      $5345,$99BF,      // <cjk>
      $5346,$99BE,      // <cjk>
      $5347,$8FA1,      // <cjk>
      $5348,$8CDF,      // <cjk>
      $5349,$99C1,      // <cjk>
      $534A,$94BC,      // <cjk>
      $534D,$99C2,      // <cjk>
      $5351,$94DA,      // <cjk>
      $5352,$91B2,      // <cjk>
      $5353,$91EC,      // <cjk>
      $5354,$8BA6,      // <cjk>
      $5357,$93EC,      // <cjk>
      $5358,$9250,      // <cjk>
      $535A,$948E,      // <cjk>
      $535C,$966D,      // <cjk>
      $535E,$99C4,      // <cjk>
      $5360,$90E8,      // <cjk>
      $5366,$8C54,      // <cjk>
      $5369,$99C5,      // <cjk>
      $536E,$99C6,      // <cjk>
      $536F,$894B,      // <cjk>
      $5370,$88F3,      // <cjk>
      $5371,$8AEB,      // <cjk>
      $5373,$91A6,      // <cjk>
      $5374,$8B70,      // <cjk>
      $5375,$9791,      // <cjk>
      $5377,$99C9,      // <cjk>
      $5378,$89B5,      // <cjk>
      $537B,$99C8,      // <cjk>
      $537F,$8BA8,      // <cjk>
      $5382,$99CA,      // <cjk>
      $5384,$96EF,      // <cjk>
      $5396,$99CB,      // <cjk>
      $5398,$97D0,      // <cjk>
      $539A,$8CFA,      // <cjk>
      $539F,$8CB4,      // <cjk>
      $53A0,$99CC,      // <cjk>
      $53A5,$99CE,      // <cjk>
      $53A6,$99CD,      // <cjk>
      $53A8,$907E,      // <cjk>
      $53A9,$8958,      // <cjk>
      $53AD,$897D,      // <cjk>
      $53AE,$99CF,      // <cjk>
      $53B0,$99D0,      // <cjk>
      $53B3,$8CB5,      // <cjk>
      $53B6,$99D1,      // <cjk>
      $53BB,$8B8E,      // <cjk>
      $53C2,$8E51,      // <cjk>
      $53C3,$99D2,      // <cjk>
      $53C8,$9694,      // <cjk>
      $53C9,$8DB3,      // <cjk>
      $53CA,$8B79,      // <cjk>
      $53CB,$9746,      // <cjk>
      $53CC,$916F,      // <cjk>
      $53CD,$94BD,      // <cjk>
      $53CE,$8EFB,      // <cjk>
      $53D4,$8F66,      // <cjk>
      $53D6,$8EE6,      // <cjk>
      $53D7,$8EF3,      // <cjk>
      $53D9,$8F96,      // <cjk>
      $53DB,$94BE,      // <cjk>
      $53DF,$99D5,      // <cjk>
      $53E1,$8962,      // <cjk>
      $53E2,$9170,      // <cjk>
      $53E3,$8CFB,      // <cjk>
      $53E4,$8CC3,      // <cjk>
      $53E5,$8BE5,      // <cjk>
      $53E8,$99D9,      // <cjk>
      $53E9,$9240,      // <cjk>
      $53EA,$91FC,      // <cjk>
      $53EB,$8BA9,      // <cjk>
      $53EC,$8FA2,      // <cjk>
      $53ED,$99DA,      // <cjk>
      $53EE,$99D8,      // <cjk>
      $53EF,$89C2,      // <cjk>
      $53F0,$91E4,      // <cjk>
      $53F1,$8EB6,      // <cjk>
      $53F2,$8E6A,      // <cjk>
      $53F3,$8945,      // <cjk>
      $53F6,$8A90,      // <cjk>
      $53F7,$8D86,      // <cjk>
      $53F8,$8E69,      // <cjk>
      $53FA,$99DB,      // <cjk>
      $5401,$99DC,      // <cjk>
      $5403,$8B68,      // <cjk>
      $5404,$8A65,      // <cjk>
      $5408,$8D87,      // <cjk>
      $5409,$8B67,      // <cjk>
      $540A,$92DD,      // <cjk>
      $540B,$8944,      // <cjk>
      $540C,$93AF,      // <cjk>
      $540D,$96BC,      // <cjk>
      $540E,$8D40,      // <cjk>
      $540F,$9799,      // <cjk>
      $5410,$9366,      // <cjk>
      $5411,$8CFC,      // <cjk>
      $541B,$8C4E,      // <cjk>
      $541D,$99E5,      // <cjk>
      $541F,$8BE1,      // <cjk>
      $5420,$9669,      // <cjk>
      $5426,$94DB,      // <cjk>
      $5429,$99E4,      // <cjk>
      $542B,$8ADC,      // <cjk>
      $542C,$99DF,      // <cjk>
      $542D,$99E0,      // <cjk>
      $542E,$99E2,      // <cjk>
      $5436,$99E3,      // <cjk>
      $5438,$8B7A,      // <cjk>
      $5439,$9081,      // <cjk>
      $543B,$95AB,      // <cjk>
      $543C,$99E1,      // <cjk>
      $543D,$99DD,      // <cjk>
      $543E,$8CE1,      // <cjk>
      $5440,$99DE,      // <cjk>
      $5442,$9843,      // <cjk>
      $5446,$95F0,      // <cjk>
      $5448,$92E6,      // <cjk>
      $5449,$8CE0,      // <cjk>
      $544A,$8D90,      // <cjk>
      $544E,$99E6,      // <cjk>
      $5451,$93DB,      // <cjk>
      $545F,$99EA,      // <cjk>
      $5468,$8EFC,      // <cjk>
      $546A,$8EF4,      // <cjk>
      $5470,$99ED,      // <cjk>
      $5471,$99EB,      // <cjk>
      $5473,$96A1,      // <cjk>
      $5475,$99E8,      // <cjk>
      $5476,$99F1,      // <cjk>
      $5477,$99EC,      // <cjk>
      $547B,$99EF,      // <cjk>
      $547C,$8CC4,      // <cjk>
      $547D,$96BD,      // <cjk>
      $5480,$99F0,      // <cjk>
      $5484,$99F2,      // <cjk>
      $5486,$99F4,      // <cjk>
      $548B,$8DEE,      // <cjk>
      $548C,$9861,      // <cjk>
      $548E,$99E9,      // <cjk>
      $548F,$99E7,      // <cjk>
      $5490,$99F3,      // <cjk>
      $5492,$99EE,      // <cjk>
      $54A2,$99F6,      // <cjk>
      $54A4,$9A42,      // <cjk>
      $54A5,$99F8,      // <cjk>
      $54A8,$99FC,      // <cjk>
      $54AB,$9A40,      // <cjk>
      $54AC,$99F9,      // <cjk>
      $54AF,$9A5D,      // <cjk>
      $54B2,$8DE7,      // <cjk>
      $54B3,$8A50,      // <cjk>
      $54B8,$99F7,      // <cjk>
      $54BC,$9A44,      // <cjk>
      $54BD,$88F4,      // <cjk>
      $54BE,$9A43,      // <cjk>
      $54C0,$88A3,      // <cjk>
      $54C1,$9569,      // <cjk>
      $54C2,$9A41,      // <cjk>
      $54C4,$99FA,      // <cjk>
      $54C7,$99F5,      // <cjk>
      $54C8,$99FB,      // <cjk>
      $54C9,$8DC6,      // <cjk>
      $54D8,$9A45,      // <cjk>
      $54E1,$88F5,      // <cjk>
      $54E2,$9A4E,      // <cjk>
      $54E5,$9A46,      // <cjk>
      $54E6,$9A47,      // <cjk>
      $54E8,$8FA3,      // <cjk>
      $54E9,$9689,      // <cjk>
      $54ED,$9A4C,      // <cjk>
      $54EE,$9A4B,      // <cjk>
      $54F2,$934E,      // <cjk>
      $54FA,$9A4D,      // <cjk>
      $54FD,$9A4A,      // <cjk>
      $5504,$8953,      // <cjk>
      $5506,$8DB4,      // <cjk>
      $5507,$904F,      // <cjk>
      $550F,$9A48,      // <cjk>
      $5510,$9382,      // <cjk>
      $5514,$9A49,      // <cjk>
      $5516,$88A0,      // <cjk>
      $552E,$9A53,      // <cjk>
      $552F,$9742,      // <cjk>
      $5531,$8FA5,      // <cjk>
      $5533,$9A59,      // <cjk>
      $5538,$9A58,      // <cjk>
      $5539,$9A4F,      // <cjk>
      $553E,$91C1,      // <cjk>
      $5540,$9A50,      // <cjk>
      $5544,$91ED,      // <cjk>
      $5545,$9A55,      // <cjk>
      $5546,$8FA4,      // <cjk>
      $554C,$9A52,      // <cjk>
      $554F,$96E2,      // <cjk>
      $5556,$9A56,      // <cjk>
      $5557,$9A57,      // <cjk>
      $555C,$9A54,      // <cjk>
      $555D,$9A5A,      // <cjk>
      $5563,$9A51,      // <cjk>
      $557B,$9A60,      // <cjk>
      $557C,$9A65,      // <cjk>
      $557E,$9A61,      // <cjk>
      $5580,$9A5C,      // <cjk>
      $5583,$9A66,      // <cjk>
      $5584,$9150,      // <cjk>
      $5587,$9A68,      // <cjk>
      $5589,$8D41,      // <cjk>
      $558A,$9A5E,      // <cjk>
      $558B,$929D,      // <cjk>
      $5598,$9A62,      // <cjk>
      $559A,$8AAB,      // <cjk>
      $559C,$8AEC,      // <cjk>
      $559D,$8A85,      // <cjk>
      $559E,$9A63,      // <cjk>
      $559F,$9A5F,      // <cjk>
      $55A7,$8C96,      // <cjk>
      $55A8,$9A69,      // <cjk>
      $55A9,$9A67,      // <cjk>
      $55AA,$9172,      // <cjk>
      $55AB,$8B69,      // <cjk>
      $55AC,$8BAA,      // <cjk>
      $55AE,$9A64,      // <cjk>
      $55B0,$8BF2,      // <cjk>
      $55B6,$8963,      // <cjk>
      $55C4,$9A6D,      // <cjk>
      $55C5,$9A6B,      // <cjk>
      $55C7,$9AA5,      // <cjk>
      $55D4,$9A70,      // <cjk>
      $55DA,$9A6A,      // <cjk>
      $55DC,$9A6E,      // <cjk>
      $55DF,$9A6C,      // <cjk>
      $55E3,$8E6B,      // <cjk>
      $55E4,$9A6F,      // <cjk>
      $55F7,$9A72,      // <cjk>
      $55F9,$9A77,      // <cjk>
      $55FD,$9A75,      // <cjk>
      $55FE,$9A74,      // <cjk>
      $5606,$9251,      // <cjk>
      $5609,$89C3,      // <cjk>
      $5614,$9A71,      // <cjk>
      $5616,$9A73,      // <cjk>
      $5617,$8FA6,      // <cjk>
      $5618,$8952,      // <cjk>
      $561B,$9A76,      // <cjk>
      $5629,$89DC,      // <cjk>
      $562F,$9A82,      // <cjk>
      $5631,$8FFA,      // <cjk>
      $5632,$9A7D,      // <cjk>
      $5634,$9A7B,      // <cjk>
      $5636,$9A7C,      // <cjk>
      $5638,$9A7E,      // <cjk>
      $5642,$895C,      // <cjk>
      $564C,$9158,      // <cjk>
      $564E,$9A78,      // <cjk>
      $5650,$9A79,      // <cjk>
      $565B,$8A9A,      // <cjk>
      $5664,$9A81,      // <cjk>
      $5668,$8AED,      // <cjk>
      $566A,$9A84,      // <cjk>
      $566B,$9A80,      // <cjk>
      $566C,$9A83,      // <cjk>
      $5674,$95AC,      // <cjk>
      $5678,$93D3,      // <cjk>
      $567A,$94B6,      // <cjk>
      $5680,$9A86,      // <cjk>
      $5686,$9A85,      // <cjk>
      $5687,$8A64,      // <cjk>
      $568A,$9A87,      // <cjk>
      $568F,$9A8A,      // <cjk>
      $5694,$9A89,      // <cjk>
      $56A0,$9A88,      // <cjk>
      $56A2,$9458,      // <cjk>
      $56A5,$9A8B,      // <cjk>
      $56AE,$9A8C,      // <cjk>
      $56B4,$9A8E,      // <cjk>
      $56B6,$9A8D,      // <cjk>
      $56BC,$9A90,      // <cjk>
      $56C0,$9A93,      // <cjk>
      $56C1,$9A91,      // <cjk>
      $56C2,$9A8F,      // <cjk>
      $56C3,$9A92,      // <cjk>
      $56C8,$9A94,      // <cjk>
      $56CE,$9A95,      // <cjk>
      $56D1,$9A96,      // <cjk>
      $56D3,$9A97,      // <cjk>
      $56D7,$9A98,      // <cjk>
      $56D8,$9964,      // <cjk>
      $56DA,$8EFA,      // <cjk>
      $56DB,$8E6C,      // <cjk>
      $56DE,$89F1,      // <cjk>
      $56E0,$88F6,      // <cjk>
      $56E3,$9263,      // <cjk>
      $56EE,$9A99,      // <cjk>
      $56F0,$8DA2,      // <cjk>
      $56F2,$88CD,      // <cjk>
      $56F3,$907D,      // <cjk>
      $56F9,$9A9A,      // <cjk>
      $56FA,$8CC5,      // <cjk>
      $56FD,$8D91,      // <cjk>
      $56FF,$9A9C,      // <cjk>
      $5700,$9A9B,      // <cjk>
      $5703,$95DE,      // <cjk>
      $5704,$9A9D,      // <cjk>
      $5708,$9A9F,      // <cjk>
      $5709,$9A9E,      // <cjk>
      $570B,$9AA0,      // <cjk>
      $570D,$9AA1,      // <cjk>
      $570F,$8C97,      // <cjk>
      $5712,$8980,      // <cjk>
      $5713,$9AA2,      // <cjk>
      $5716,$9AA4,      // <cjk>
      $5718,$9AA3,      // <cjk>
      $571C,$9AA6,      // <cjk>
      $571F,$9379,      // <cjk>
      $5726,$9AA7,      // <cjk>
      $5727,$88B3,      // <cjk>
      $5728,$8DDD,      // <cjk>
      $572D,$8C5C,      // <cjk>
      $5730,$926E,      // <cjk>
      $5737,$9AA8,      // <cjk>
      $5738,$9AA9,      // <cjk>
      $573B,$9AAB,      // <cjk>
      $5740,$9AAC,      // <cjk>
      $5742,$8DE2,      // <cjk>
      $5747,$8BCF,      // <cjk>
      $574A,$9656,      // <cjk>
      $574E,$9AAA,      // <cjk>
      $574F,$9AAD,      // <cjk>
      $5750,$8DBF,      // <cjk>
      $5751,$8D42,      // <cjk>
      $5761,$9AB1,      // <cjk>
      $5764,$8DA3,      // <cjk>
      $5766,$9252,      // <cjk>
      $5769,$9AAE,      // <cjk>
      $576A,$92D8,      // <cjk>
      $577F,$9AB2,      // <cjk>
      $5782,$9082,      // <cjk>
      $5788,$9AB0,      // <cjk>
      $5789,$9AB3,      // <cjk>
      $578B,$8C5E,      // <cjk>
      $5793,$9AB4,      // <cjk>
      $57A0,$9AB5,      // <cjk>
      $57A2,$8D43,      // <cjk>
      $57A3,$8A5F,      // <cjk>
      $57A4,$9AB7,      // <cjk>
      $57AA,$9AB8,      // <cjk>
      $57B0,$9AB9,      // <cjk>
      $57B3,$9AB6,      // <cjk>
      $57C0,$9AAF,      // <cjk>
      $57C3,$9ABA,      // <cjk>
      $57C6,$9ABB,      // <cjk>
      $57CB,$9684,      // <cjk>
      $57CE,$8FE9,      // <cjk>
      $57D2,$9ABD,      // <cjk>
      $57D3,$9ABE,      // <cjk>
      $57D4,$9ABC,      // <cjk>
      $57D6,$9AC0,      // <cjk>
      $57DC,$9457,      // <cjk>
      $57DF,$88E6,      // <cjk>
      $57E0,$9575,      // <cjk>
      $57E3,$9AC1,      // <cjk>
      $57F4,$8FFB,      // <cjk>
      $57F7,$8EB7,      // <cjk>
      $57F9,$947C,      // <cjk>
      $57FA,$8AEE,      // <cjk>
      $57FC,$8DE9,      // <cjk>
      $5800,$9678,      // <cjk>
      $5802,$93B0,      // <cjk>
      $5805,$8C98,      // <cjk>
      $5806,$91CD,      // <cjk>
      $580A,$9ABF,      // <cjk>
      $580B,$9AC2,      // <cjk>
      $5815,$91C2,      // <cjk>
      $5819,$9AC3,      // <cjk>
      $581D,$9AC4,      // <cjk>
      $5821,$9AC6,      // <cjk>
      $5824,$92E7,      // <cjk>
      $582A,$8AAC,      // <cjk>
      $582F,$EA9F,      // <cjk>
      $5830,$8981,      // <cjk>
      $5831,$95F1,      // <cjk>
      $5834,$8FEA,      // <cjk>
      $5835,$9367,      // <cjk>
      $583A,$8DE4,      // <cjk>
      $583D,$9ACC,      // <cjk>
      $5840,$95BB,      // <cjk>
      $5841,$97DB,      // <cjk>
      $584A,$89F2,      // <cjk>
      $584B,$9AC8,      // <cjk>
      $5851,$9159,      // <cjk>
      $5852,$9ACB,      // <cjk>
      $5854,$9383,      // <cjk>
      $5857,$9368,      // <cjk>
      $5858,$9384,      // <cjk>
      $5859,$94B7,      // <cjk>
      $585A,$92CB,      // <cjk>
      $585E,$8DC7,      // <cjk>
      $5862,$9AC7,      // <cjk>
      $5869,$8996,      // <cjk>
      $586B,$9355,      // <cjk>
      $5870,$9AC9,      // <cjk>
      $5872,$9AC5,      // <cjk>
      $5875,$906F,      // <cjk>
      $5879,$9ACD,      // <cjk>
      $587E,$8F6D,      // <cjk>
      $5883,$8BAB,      // <cjk>
      $5885,$9ACE,      // <cjk>
      $5893,$95E6,      // <cjk>
      $5897,$919D,      // <cjk>
      $589C,$92C4,      // <cjk>
      $589F,$9AD0,      // <cjk>
      $58A8,$966E,      // <cjk>
      $58AB,$9AD1,      // <cjk>
      $58AE,$9AD6,      // <cjk>
      $58B3,$95AD,      // <cjk>
      $58B8,$9AD5,      // <cjk>
      $58B9,$9ACF,      // <cjk>
      $58BA,$9AD2,      // <cjk>
      $58BB,$9AD4,      // <cjk>
      $58BE,$8DA4,      // <cjk>
      $58C1,$95C7,      // <cjk>
      $58C5,$9AD7,      // <cjk>
      $58C7,$9264,      // <cjk>
      $58CA,$89F3,      // <cjk>
      $58CC,$8FEB,      // <cjk>
      $58D1,$9AD9,      // <cjk>
      $58D3,$9AD8,      // <cjk>
      $58D5,$8D88,      // <cjk>
      $58D7,$9ADA,      // <cjk>
      $58D8,$9ADC,      // <cjk>
      $58D9,$9ADB,      // <cjk>
      $58DC,$9ADE,      // <cjk>
      $58DE,$9AD3,      // <cjk>
      $58DF,$9AE0,      // <cjk>
      $58E4,$9ADF,      // <cjk>
      $58E5,$9ADD,      // <cjk>
      $58EB,$8E6D,      // <cjk>
      $58EC,$9070,      // <cjk>
      $58EE,$9173,      // <cjk>
      $58EF,$9AE1,      // <cjk>
      $58F0,$90BA,      // <cjk>
      $58F1,$88EB,      // <cjk>
      $58F2,$9484,      // <cjk>
      $58F7,$92D9,      // <cjk>
      $58F9,$9AE3,      // <cjk>
      $58FA,$9AE2,      // <cjk>
      $58FB,$9AE4,      // <cjk>
      $58FC,$9AE5,      // <cjk>
      $58FD,$9AE6,      // <cjk>
      $5902,$9AE7,      // <cjk>
      $5909,$95CF,      // <cjk>
      $590A,$9AE8,      // <cjk>
      $590F,$89C4,      // <cjk>
      $5910,$9AE9,      // <cjk>
      $5916,$8A4F,      // <cjk>
      $5918,$99C7,      // <cjk>
      $5919,$8F67,      // <cjk>
      $591A,$91BD,      // <cjk>
      $591B,$9AEA,      // <cjk>
      $591C,$96E9,      // <cjk>
      $5922,$96B2,      // <cjk>
      $5925,$9AEC,      // <cjk>
      $5927,$91E5,      // <cjk>
      $5929,$9356,      // <cjk>
      $592A,$91BE,      // <cjk>
      $592B,$9576,      // <cjk>
      $592C,$9AED,      // <cjk>
      $592D,$9AEE,      // <cjk>
      $592E,$899B,      // <cjk>
      $5931,$8EB8,      // <cjk>
      $5932,$9AEF,      // <cjk>
      $5937,$88CE,      // <cjk>
      $5938,$9AF0,      // <cjk>
      $593E,$9AF1,      // <cjk>
      $5944,$8982,      // <cjk>
      $5947,$8AEF,      // <cjk>
      $5948,$93DE,      // <cjk>
      $5949,$95F2,      // <cjk>
      $594E,$9AF5,      // <cjk>
      $594F,$9174,      // <cjk>
      $5950,$9AF4,      // <cjk>
      $5951,$8C5F,      // <cjk>
      $5954,$967A,      // <cjk>
      $5955,$9AF3,      // <cjk>
      $5957,$9385,      // <cjk>
      $5958,$9AF7,      // <cjk>
      $595A,$9AF6,      // <cjk>
      $5960,$9AF9,      // <cjk>
      $5962,$9AF8,      // <cjk>
      $5965,$899C,      // <cjk>
      $5967,$9AFA,      // <cjk>
      $5968,$8FA7,      // <cjk>
      $5969,$9AFC,      // <cjk>
      $596A,$9244,      // <cjk>
      $596C,$9AFB,      // <cjk>
      $596E,$95B1,      // <cjk>
      $5973,$8F97,      // <cjk>
      $5974,$937A,      // <cjk>
      $5978,$9B40,      // <cjk>
      $597D,$8D44,      // <cjk>
      $5981,$9B41,      // <cjk>
      $5982,$9440,      // <cjk>
      $5983,$94DC,      // <cjk>
      $5984,$96CF,      // <cjk>
      $598A,$9444,      // <cjk>
      $598D,$9B4A,      // <cjk>
      $5993,$8B57,      // <cjk>
      $5996,$9764,      // <cjk>
      $5999,$96AD,      // <cjk>
      $599B,$9BAA,      // <cjk>
      $599D,$9B42,      // <cjk>
      $59A3,$9B45,      // <cjk>
      $59A5,$91C3,      // <cjk>
      $59A8,$9657,      // <cjk>
      $59AC,$9369,      // <cjk>
      $59B2,$9B46,      // <cjk>
      $59B9,$9685,      // <cjk>
      $59BB,$8DC8,      // <cjk>
      $59BE,$8FA8,      // <cjk>
      $59C6,$9B47,      // <cjk>
      $59C9,$8E6F,      // <cjk>
      $59CB,$8E6E,      // <cjk>
      $59D0,$88B7,      // <cjk>
      $59D1,$8CC6,      // <cjk>
      $59D3,$90A9,      // <cjk>
      $59D4,$88CF,      // <cjk>
      $59D9,$9B4B,      // <cjk>
      $59DA,$9B4C,      // <cjk>
      $59DC,$9B49,      // <cjk>
      $59E5,$8957,      // <cjk>
      $59E6,$8AAD,      // <cjk>
      $59E8,$9B48,      // <cjk>
      $59EA,$96C3,      // <cjk>
      $59EB,$9550,      // <cjk>
      $59F6,$88A6,      // <cjk>
      $59FB,$88F7,      // <cjk>
      $59FF,$8E70,      // <cjk>
      $5A01,$88D0,      // <cjk>
      $5A03,$88A1,      // <cjk>
      $5A09,$9B51,      // <cjk>
      $5A11,$9B4F,      // <cjk>
      $5A18,$96BA,      // <cjk>
      $5A1A,$9B52,      // <cjk>
      $5A1C,$9B50,      // <cjk>
      $5A1F,$9B4E,      // <cjk>
      $5A20,$9050,      // <cjk>
      $5A25,$9B4D,      // <cjk>
      $5A29,$95D8,      // <cjk>
      $5A2F,$8CE2,      // <cjk>
      $5A35,$9B56,      // <cjk>
      $5A36,$9B57,      // <cjk>
      $5A3C,$8FA9,      // <cjk>
      $5A40,$9B53,      // <cjk>
      $5A41,$984B,      // <cjk>
      $5A46,$946B,      // <cjk>
      $5A49,$9B55,      // <cjk>
      $5A5A,$8DA5,      // <cjk>
      $5A62,$9B58,      // <cjk>
      $5A66,$9577,      // <cjk>
      $5A6A,$9B59,      // <cjk>
      $5A6C,$9B54,      // <cjk>
      $5A7F,$96B9,      // <cjk>
      $5A92,$947D,      // <cjk>
      $5A9A,$9B5A,      // <cjk>
      $5A9B,$9551,      // <cjk>
      $5ABD,$9B5F,      // <cjk>
      $5ABE,$9B5C,      // <cjk>
      $5AC1,$89C5,      // <cjk>
      $5AC2,$9B5E,      // <cjk>
      $5AC9,$8EB9,      // <cjk>
      $5ACB,$9B5D,      // <cjk>
      $5ACC,$8C99,      // <cjk>
      $5AD0,$9B6B,      // <cjk>
      $5AD6,$9B64,      // <cjk>
      $5AD7,$9B61,      // <cjk>
      $5AE1,$9284,      // <cjk>
      $5AE3,$9B60,      // <cjk>
      $5AE6,$9B62,      // <cjk>
      $5AE9,$9B63,      // <cjk>
      $5AFA,$9B65,      // <cjk>
      $5AFB,$9B66,      // <cjk>
      $5B09,$8AF0,      // <cjk>
      $5B0B,$9B68,      // <cjk>
      $5B0C,$9B67,      // <cjk>
      $5B16,$9B69,      // <cjk>
      $5B22,$8FEC,      // <cjk>
      $5B2A,$9B6C,      // <cjk>
      $5B2C,$92DA,      // <cjk>
      $5B30,$8964,      // <cjk>
      $5B32,$9B6A,      // <cjk>
      $5B36,$9B6D,      // <cjk>
      $5B3E,$9B6E,      // <cjk>
      $5B40,$9B71,      // <cjk>
      $5B43,$9B6F,      // <cjk>
      $5B45,$9B70,      // <cjk>
      $5B50,$8E71,      // <cjk>
      $5B51,$9B72,      // <cjk>
      $5B54,$8D45,      // <cjk>
      $5B55,$9B73,      // <cjk>
      $5B57,$8E9A,      // <cjk>
      $5B58,$91B6,      // <cjk>
      $5B5A,$9B74,      // <cjk>
      $5B5B,$9B75,      // <cjk>
      $5B5C,$8E79,      // <cjk>
      $5B5D,$8D46,      // <cjk>
      $5B5F,$96D0,      // <cjk>
      $5B63,$8B47,      // <cjk>
      $5B64,$8CC7,      // <cjk>
      $5B65,$9B76,      // <cjk>
      $5B66,$8A77,      // <cjk>
      $5B69,$9B77,      // <cjk>
      $5B6B,$91B7,      // <cjk>
      $5B70,$9B78,      // <cjk>
      $5B71,$9BA1,      // <cjk>
      $5B73,$9B79,      // <cjk>
      $5B75,$9B7A,      // <cjk>
      $5B78,$9B7B,      // <cjk>
      $5B7A,$9B7D,      // <cjk>
      $5B80,$9B7E,      // <cjk>
      $5B83,$9B80,      // <cjk>
      $5B85,$91EE,      // <cjk>
      $5B87,$8946,      // <cjk>
      $5B88,$8EE7,      // <cjk>
      $5B89,$88C0,      // <cjk>
      $5B8B,$9176,      // <cjk>
      $5B8C,$8AAE,      // <cjk>
      $5B8D,$8EB3,      // <cjk>
      $5B8F,$8D47,      // <cjk>
      $5B95,$9386,      // <cjk>
      $5B97,$8F40,      // <cjk>
      $5B98,$8AAF,      // <cjk>
      $5B99,$9288,      // <cjk>
      $5B9A,$92E8,      // <cjk>
      $5B9B,$88B6,      // <cjk>
      $5B9C,$8B58,      // <cjk>
      $5B9D,$95F3,      // <cjk>
      $5B9F,$8EC0,      // <cjk>
      $5BA2,$8B71,      // <cjk>
      $5BA3,$90E9,      // <cjk>
      $5BA4,$8EBA,      // <cjk>
      $5BA5,$9747,      // <cjk>
      $5BA6,$9B81,      // <cjk>
      $5BAE,$8B7B,      // <cjk>
      $5BB0,$8DC9,      // <cjk>
      $5BB3,$8A51,      // <cjk>
      $5BB4,$8983,      // <cjk>
      $5BB5,$8FAA,      // <cjk>
      $5BB6,$89C6,      // <cjk>
      $5BB8,$9B82,      // <cjk>
      $5BB9,$9765,      // <cjk>
      $5BBF,$8F68,      // <cjk>
      $5BC2,$8EE2,      // <cjk>
      $5BC3,$9B83,      // <cjk>
      $5BC4,$8AF1,      // <cjk>
      $5BC5,$93D0,      // <cjk>
      $5BC6,$96A7,      // <cjk>
      $5BC7,$9B84,      // <cjk>
      $5BC9,$9B85,      // <cjk>
      $5BCC,$9578,      // <cjk>
      $5BD0,$9B87,      // <cjk>
      $5BD2,$8AA6,      // <cjk>
      $5BD3,$8BF5,      // <cjk>
      $5BD4,$9B86,      // <cjk>
      $5BDB,$8AB0,      // <cjk>
      $5BDD,$9051,      // <cjk>
      $5BDE,$9B8B,      // <cjk>
      $5BDF,$8E40,      // <cjk>
      $5BE1,$89C7,      // <cjk>
      $5BE2,$9B8A,      // <cjk>
      $5BE4,$9B88,      // <cjk>
      $5BE5,$9B8C,      // <cjk>
      $5BE6,$9B89,      // <cjk>
      $5BE7,$944A,      // <cjk>
      $5BE8,$9ECB,      // <cjk>
      $5BE9,$9052,      // <cjk>
      $5BEB,$9B8D,      // <cjk>
      $5BEE,$97BE,      // <cjk>
      $5BF0,$9B8E,      // <cjk>
      $5BF3,$9B90,      // <cjk>
      $5BF5,$929E,      // <cjk>
      $5BF6,$9B8F,      // <cjk>
      $5BF8,$90A1,      // <cjk>
      $5BFA,$8E9B,      // <cjk>
      $5BFE,$91CE,      // <cjk>
      $5BFF,$8EF5,      // <cjk>
      $5C01,$9595,      // <cjk>
      $5C02,$90EA,      // <cjk>
      $5C04,$8ECB,      // <cjk>
      $5C05,$9B91,      // <cjk>
      $5C06,$8FAB,      // <cjk>
      $5C07,$9B92,      // <cjk>
      $5C08,$9B93,      // <cjk>
      $5C09,$88D1,      // <cjk>
      $5C0A,$91B8,      // <cjk>
      $5C0B,$9071,      // <cjk>
      $5C0D,$9B94,      // <cjk>
      $5C0E,$93B1,      // <cjk>
      $5C0F,$8FAC,      // <cjk>
      $5C11,$8FAD,      // <cjk>
      $5C13,$9B95,      // <cjk>
      $5C16,$90EB,      // <cjk>
      $5C1A,$8FAE,      // <cjk>
      $5C20,$9B96,      // <cjk>
      $5C22,$9B97,      // <cjk>
      $5C24,$96DE,      // <cjk>
      $5C28,$9B98,      // <cjk>
      $5C2D,$8BC4,      // <cjk>
      $5C31,$8F41,      // <cjk>
      $5C38,$9B99,      // <cjk>
      $5C39,$9B9A,      // <cjk>
      $5C3A,$8EDA,      // <cjk>
      $5C3B,$904B,      // <cjk>
      $5C3C,$93F2,      // <cjk>
      $5C3D,$9073,      // <cjk>
      $5C3E,$94F6,      // <cjk>
      $5C3F,$9441,      // <cjk>
      $5C40,$8BC7,      // <cjk>
      $5C41,$9B9B,      // <cjk>
      $5C45,$8B8F,      // <cjk>
      $5C46,$9B9C,      // <cjk>
      $5C48,$8BFC,      // <cjk>
      $5C4A,$93CD,      // <cjk>
      $5C4B,$89AE,      // <cjk>
      $5C4D,$8E72,      // <cjk>
      $5C4E,$9B9D,      // <cjk>
      $5C4F,$9BA0,      // <cjk>
      $5C50,$9B9F,      // <cjk>
      $5C51,$8BFB,      // <cjk>
      $5C53,$9B9E,      // <cjk>
      $5C55,$9357,      // <cjk>
      $5C5E,$91AE,      // <cjk>
      $5C60,$936A,      // <cjk>
      $5C61,$8EC6,      // <cjk>
      $5C64,$9177,      // <cjk>
      $5C65,$979A,      // <cjk>
      $5C6C,$9BA2,      // <cjk>
      $5C6E,$9BA3,      // <cjk>
      $5C6F,$93D4,      // <cjk>
      $5C71,$8E52,      // <cjk>
      $5C76,$9BA5,      // <cjk>
      $5C79,$9BA6,      // <cjk>
      $5C8C,$9BA7,      // <cjk>
      $5C90,$8AF2,      // <cjk>
      $5C91,$9BA8,      // <cjk>
      $5C94,$9BA9,      // <cjk>
      $5CA1,$89AA,      // <cjk>
      $5CA8,$915A,      // <cjk>
      $5CA9,$8AE2,      // <cjk>
      $5CAB,$9BAB,      // <cjk>
      $5CAC,$96A6,      // <cjk>
      $5CB1,$91D0,      // <cjk>
      $5CB3,$8A78,      // <cjk>
      $5CB6,$9BAD,      // <cjk>
      $5CB7,$9BAF,      // <cjk>
      $5CB8,$8ADD,      // <cjk>
      $5CBB,$9BAC,      // <cjk>
      $5CBC,$9BAE,      // <cjk>
      $5CBE,$9BB1,      // <cjk>
      $5CC5,$9BB0,      // <cjk>
      $5CC7,$9BB2,      // <cjk>
      $5CD9,$9BB3,      // <cjk>
      $5CE0,$93BB,      // <cjk>
      $5CE1,$8BAC,      // <cjk>
      $5CE8,$89E3,      // <cjk>
      $5CE9,$9BB4,      // <cjk>
      $5CEA,$9BB9,      // <cjk>
      $5CED,$9BB7,      // <cjk>
      $5CEF,$95F5,      // <cjk>
      $5CF0,$95F4,      // <cjk>
      $5CF6,$9387,      // <cjk>
      $5CFA,$9BB6,      // <cjk>
      $5CFB,$8F73,      // <cjk>
      $5CFD,$9BB5,      // <cjk>
      $5D07,$9092,      // <cjk>
      $5D0B,$9BBA,      // <cjk>
      $5D0E,$8DE8,      // <cjk>
      $5D11,$9BC0,      // <cjk>
      $5D14,$9BC1,      // <cjk>
      $5D15,$9BBB,      // <cjk>
      $5D16,$8A52,      // <cjk>
      $5D17,$9BBC,      // <cjk>
      $5D18,$9BC5,      // <cjk>
      $5D19,$9BC4,      // <cjk>
      $5D1A,$9BC3,      // <cjk>
      $5D1B,$9BBF,      // <cjk>
      $5D1F,$9BBE,      // <cjk>
      $5D22,$9BC2,      // <cjk>
      $5D29,$95F6,      // <cjk>
      $5D4B,$9BC9,      // <cjk>
      $5D4C,$9BC6,      // <cjk>
      $5D4E,$9BC8,      // <cjk>
      $5D50,$9792,      // <cjk>
      $5D52,$9BC7,      // <cjk>
      $5D5C,$9BBD,      // <cjk>
      $5D69,$9093,      // <cjk>
      $5D6C,$9BCA,      // <cjk>
      $5D6F,$8DB5,      // <cjk>
      $5D73,$9BCB,      // <cjk>
      $5D76,$9BCC,      // <cjk>
      $5D82,$9BCF,      // <cjk>
      $5D84,$9BCE,      // <cjk>
      $5D87,$9BCD,      // <cjk>
      $5D8B,$9388,      // <cjk>
      $5D8C,$9BB8,      // <cjk>
      $5D90,$9BD5,      // <cjk>
      $5D9D,$9BD1,      // <cjk>
      $5DA2,$9BD0,      // <cjk>
      $5DAC,$9BD2,      // <cjk>
      $5DAE,$9BD3,      // <cjk>
      $5DB7,$9BD6,      // <cjk>
      $5DBA,$97E4,      // <cjk>
      $5DBC,$9BD7,      // <cjk>
      $5DBD,$9BD4,      // <cjk>
      $5DC9,$9BD8,      // <cjk>
      $5DCC,$8ADE,      // <cjk>
      $5DCD,$9BD9,      // <cjk>
      $5DD2,$9BDB,      // <cjk>
      $5DD3,$9BDA,      // <cjk>
      $5DD6,$9BDC,      // <cjk>
      $5DDB,$9BDD,      // <cjk>
      $5DDD,$90EC,      // <cjk>
      $5DDE,$8F42,      // <cjk>
      $5DE1,$8F84,      // <cjk>
      $5DE3,$9183,      // <cjk>
      $5DE5,$8D48,      // <cjk>
      $5DE6,$8DB6,      // <cjk>
      $5DE7,$8D49,      // <cjk>
      $5DE8,$8B90,      // <cjk>
      $5DEB,$9BDE,      // <cjk>
      $5DEE,$8DB7,      // <cjk>
      $5DF1,$8CC8,      // <cjk>
      $5DF2,$9BDF,      // <cjk>
      $5DF3,$96A4,      // <cjk>
      $5DF4,$9462,      // <cjk>
      $5DF5,$9BE0,      // <cjk>
      $5DF7,$8D4A,      // <cjk>
      $5DFB,$8AAA,      // <cjk>
      $5DFD,$9246,      // <cjk>
      $5DFE,$8BD0,      // <cjk>
      $5E02,$8E73,      // <cjk>
      $5E03,$957A,      // <cjk>
      $5E06,$94BF,      // <cjk>
      $5E0B,$9BE1,      // <cjk>
      $5E0C,$8AF3,      // <cjk>
      $5E11,$9BE4,      // <cjk>
      $5E16,$929F,      // <cjk>
      $5E19,$9BE3,      // <cjk>
      $5E1A,$9BE2,      // <cjk>
      $5E1B,$9BE5,      // <cjk>
      $5E1D,$92E9,      // <cjk>
      $5E25,$9083,      // <cjk>
      $5E2B,$8E74,      // <cjk>
      $5E2D,$90C8,      // <cjk>
      $5E2F,$91D1,      // <cjk>
      $5E30,$8B41,      // <cjk>
      $5E33,$92A0,      // <cjk>
      $5E36,$9BE6,      // <cjk>
      $5E37,$9BE7,      // <cjk>
      $5E38,$8FED,      // <cjk>
      $5E3D,$9658,      // <cjk>
      $5E40,$9BEA,      // <cjk>
      $5E43,$9BE9,      // <cjk>
      $5E44,$9BE8,      // <cjk>
      $5E45,$959D,      // <cjk>
      $5E47,$9BF1,      // <cjk>
      $5E4C,$9679,      // <cjk>
      $5E4E,$9BEB,      // <cjk>
      $5E54,$9BED,      // <cjk>
      $5E55,$968B,      // <cjk>
      $5E57,$9BEC,      // <cjk>
      $5E5F,$9BEE,      // <cjk>
      $5E61,$94A6,      // <cjk>
      $5E62,$9BEF,      // <cjk>
      $5E63,$95BC,      // <cjk>
      $5E64,$9BF0,      // <cjk>
      $5E72,$8AB1,      // <cjk>
      $5E73,$95BD,      // <cjk>
      $5E74,$944E,      // <cjk>
      $5E75,$9BF2,      // <cjk>
      $5E76,$9BF3,      // <cjk>
      $5E78,$8D4B,      // <cjk>
      $5E79,$8AB2,      // <cjk>
      $5E7A,$9BF4,      // <cjk>
      $5E7B,$8CB6,      // <cjk>
      $5E7C,$9763,      // <cjk>
      $5E7D,$9748,      // <cjk>
      $5E7E,$8AF4,      // <cjk>
      $5E7F,$9BF6,      // <cjk>
      $5E81,$92A1,      // <cjk>
      $5E83,$8D4C,      // <cjk>
      $5E84,$8FAF,      // <cjk>
      $5E87,$94DD,      // <cjk>
      $5E8A,$8FB0,      // <cjk>
      $5E8F,$8F98,      // <cjk>
      $5E95,$92EA,      // <cjk>
      $5E96,$95F7,      // <cjk>
      $5E97,$9358,      // <cjk>
      $5E9A,$8D4D,      // <cjk>
      $5E9C,$957B,      // <cjk>
      $5EA0,$9BF7,      // <cjk>
      $5EA6,$9378,      // <cjk>
      $5EA7,$8DC0,      // <cjk>
      $5EAB,$8CC9,      // <cjk>
      $5EAD,$92EB,      // <cjk>
      $5EB5,$88C1,      // <cjk>
      $5EB6,$8F8E,      // <cjk>
      $5EB7,$8D4E,      // <cjk>
      $5EB8,$9766,      // <cjk>
      $5EC1,$9BF8,      // <cjk>
      $5EC2,$9BF9,      // <cjk>
      $5EC3,$9470,      // <cjk>
      $5EC8,$9BFA,      // <cjk>
      $5EC9,$97F5,      // <cjk>
      $5ECA,$984C,      // <cjk>
      $5ECF,$9BFC,      // <cjk>
      $5ED0,$9BFB,      // <cjk>
      $5ED3,$8A66,      // <cjk>
      $5ED6,$9C40,      // <cjk>
      $5EDA,$9C43,      // <cjk>
      $5EDB,$9C44,      // <cjk>
      $5EDD,$9C42,      // <cjk>
      $5EDF,$955F,      // <cjk>
      $5EE0,$8FB1,      // <cjk>
      $5EE1,$9C46,      // <cjk>
      $5EE2,$9C45,      // <cjk>
      $5EE3,$9C41,      // <cjk>
      $5EE8,$9C47,      // <cjk>
      $5EE9,$9C48,      // <cjk>
      $5EEC,$9C49,      // <cjk>
      $5EF0,$9C4C,      // <cjk>
      $5EF1,$9C4A,      // <cjk>
      $5EF3,$9C4B,      // <cjk>
      $5EF4,$9C4D,      // <cjk>
      $5EF6,$8984,      // <cjk>
      $5EF7,$92EC,      // <cjk>
      $5EF8,$9C4E,      // <cjk>
      $5EFA,$8C9A,      // <cjk>
      $5EFB,$89F4,      // <cjk>
      $5EFC,$9455,      // <cjk>
      $5EFE,$9C4F,      // <cjk>
      $5EFF,$93F9,      // <cjk>
      $5F01,$95D9,      // <cjk>
      $5F03,$9C50,      // <cjk>
      $5F04,$984D,      // <cjk>
      $5F09,$9C51,      // <cjk>
      $5F0A,$95BE,      // <cjk>
      $5F0B,$9C54,      // <cjk>
      $5F0C,$989F,      // <cjk>
      $5F0D,$98AF,      // <cjk>
      $5F0F,$8EAE,      // <cjk>
      $5F10,$93F3,      // <cjk>
      $5F11,$9C55,      // <cjk>
      $5F13,$8B7C,      // <cjk>
      $5F14,$92A2,      // <cjk>
      $5F15,$88F8,      // <cjk>
      $5F16,$9C56,      // <cjk>
      $5F17,$95A4,      // <cjk>
      $5F18,$8D4F,      // <cjk>
      $5F1B,$926F,      // <cjk>
      $5F1F,$92ED,      // <cjk>
      $5F25,$96ED,      // <cjk>
      $5F26,$8CB7,      // <cjk>
      $5F27,$8CCA,      // <cjk>
      $5F29,$9C57,      // <cjk>
      $5F2D,$9C58,      // <cjk>
      $5F2F,$9C5E,      // <cjk>
      $5F31,$8EE3,      // <cjk>
      $5F35,$92A3,      // <cjk>
      $5F37,$8BAD,      // <cjk>
      $5F38,$9C59,      // <cjk>
      $5F3C,$954A,      // <cjk>
      $5F3E,$9265,      // <cjk>
      $5F41,$9C5A,      // <cjk>
      $5F4A,$8BAE,      // <cjk>
      $5F4C,$9C5C,      // <cjk>
      $5F4E,$9C5D,      // <cjk>
      $5F51,$9C5F,      // <cjk>
      $5F53,$9396,      // <cjk>
      $5F56,$9C60,      // <cjk>
      $5F57,$9C61,      // <cjk>
      $5F59,$9C62,      // <cjk>
      $5F5C,$9C53,      // <cjk>
      $5F5D,$9C52,      // <cjk>
      $5F61,$9C63,      // <cjk>
      $5F62,$8C60,      // <cjk>
      $5F66,$9546,      // <cjk>
      $5F69,$8DCA,      // <cjk>
      $5F6A,$9556,      // <cjk>
      $5F6B,$92A4,      // <cjk>
      $5F6C,$956A,      // <cjk>
      $5F6D,$9C64,      // <cjk>
      $5F70,$8FB2,      // <cjk>
      $5F71,$8965,      // <cjk>
      $5F73,$9C65,      // <cjk>
      $5F77,$9C66,      // <cjk>
      $5F79,$96F0,      // <cjk>
      $5F7C,$94DE,      // <cjk>
      $5F7F,$9C69,      // <cjk>
      $5F80,$899D,      // <cjk>
      $5F81,$90AA,      // <cjk>
      $5F82,$9C68,      // <cjk>
      $5F83,$9C67,      // <cjk>
      $5F84,$8C61,      // <cjk>
      $5F85,$91D2,      // <cjk>
      $5F87,$9C6D,      // <cjk>
      $5F88,$9C6B,      // <cjk>
      $5F8A,$9C6A,      // <cjk>
      $5F8B,$97A5,      // <cjk>
      $5F8C,$8CE3,      // <cjk>
      $5F90,$8F99,      // <cjk>
      $5F91,$9C6C,      // <cjk>
      $5F92,$936B,      // <cjk>
      $5F93,$8F5D,      // <cjk>
      $5F97,$93BE,      // <cjk>
      $5F98,$9C70,      // <cjk>
      $5F99,$9C6F,      // <cjk>
      $5F9E,$9C6E,      // <cjk>
      $5FA0,$9C71,      // <cjk>
      $5FA1,$8CE4,      // <cjk>
      $5FA8,$9C72,      // <cjk>
      $5FA9,$959C,      // <cjk>
      $5FAA,$8F7A,      // <cjk>
      $5FAD,$9C73,      // <cjk>
      $5FAE,$94F7,      // <cjk>
      $5FB3,$93BF,      // <cjk>
      $5FB4,$92A5,      // <cjk>
      $5FB9,$934F,      // <cjk>
      $5FBC,$9C74,      // <cjk>
      $5FBD,$8B4A,      // <cjk>
      $5FC3,$9053,      // <cjk>
      $5FC5,$954B,      // <cjk>
      $5FCC,$8AF5,      // <cjk>
      $5FCD,$9445,      // <cjk>
      $5FD6,$9C75,      // <cjk>
      $5FD7,$8E75,      // <cjk>
      $5FD8,$9659,      // <cjk>
      $5FD9,$965A,      // <cjk>
      $5FDC,$899E,      // <cjk>
      $5FDD,$9C7A,      // <cjk>
      $5FE0,$9289,      // <cjk>
      $5FE4,$9C77,      // <cjk>
      $5FEB,$89F5,      // <cjk>
      $5FF0,$9CAB,      // <cjk>
      $5FF1,$9C79,      // <cjk>
      $5FF5,$944F,      // <cjk>
      $5FF8,$9C78,      // <cjk>
      $5FFB,$9C76,      // <cjk>
      $5FFD,$8D9A,      // <cjk>
      $5FFF,$9C7C,      // <cjk>
      $600E,$9C83,      // <cjk>
      $600F,$9C89,      // <cjk>
      $6010,$9C81,      // <cjk>
      $6012,$937B,      // <cjk>
      $6015,$9C86,      // <cjk>
      $6016,$957C,      // <cjk>
      $6019,$9C80,      // <cjk>
      $601B,$9C85,      // <cjk>
      $601C,$97E5,      // <cjk>
      $601D,$8E76,      // <cjk>
      $6020,$91D3,      // <cjk>
      $6021,$9C7D,      // <cjk>
      $6025,$8B7D,      // <cjk>
      $6026,$9C88,      // <cjk>
      $6027,$90AB,      // <cjk>
      $6028,$8985,      // <cjk>
      $6029,$9C82,      // <cjk>
      $602A,$89F6,      // <cjk>
      $602B,$9C87,      // <cjk>
      $602F,$8BAF,      // <cjk>
      $6031,$9C84,      // <cjk>
      $603A,$9C8A,      // <cjk>
      $6041,$9C8C,      // <cjk>
      $6042,$9C96,      // <cjk>
      $6043,$9C94,      // <cjk>
      $6046,$9C91,      // <cjk>
      $604A,$9C90,      // <cjk>
      $604B,$97F6,      // <cjk>
      $604D,$9C92,      // <cjk>
      $6050,$8BB0,      // <cjk>
      $6052,$8D50,      // <cjk>
      $6055,$8F9A,      // <cjk>
      $6059,$9C99,      // <cjk>
      $605A,$9C8B,      // <cjk>
      $605F,$9C8F,      // <cjk>
      $6060,$9C7E,      // <cjk>
      $6062,$89F8,      // <cjk>
      $6063,$9C93,      // <cjk>
      $6064,$9C95,      // <cjk>
      $6065,$9270,      // <cjk>
      $6068,$8DA6,      // <cjk>
      $6069,$89B6,      // <cjk>
      $606A,$9C8D,      // <cjk>
      $606B,$9C98,      // <cjk>
      $606C,$9C97,      // <cjk>
      $606D,$8BB1,      // <cjk>
      $606F,$91A7,      // <cjk>
      $6070,$8A86,      // <cjk>
      $6075,$8C62,      // <cjk>
      $6077,$9C8E,      // <cjk>
      $6081,$9C9A,      // <cjk>
      $6083,$9C9D,      // <cjk>
      $6084,$9C9F,      // <cjk>
      $6089,$8EBB,      // <cjk>
      $608B,$9CA5,      // <cjk>
      $608C,$92EE,      // <cjk>
      $608D,$9C9B,      // <cjk>
      $6092,$9CA3,      // <cjk>
      $6094,$89F7,      // <cjk>
      $6096,$9CA1,      // <cjk>
      $6097,$9CA2,      // <cjk>
      $609A,$9C9E,      // <cjk>
      $609B,$9CA0,      // <cjk>
      $609F,$8CE5,      // <cjk>
      $60A0,$9749,      // <cjk>
      $60A3,$8AB3,      // <cjk>
      $60A6,$8978,      // <cjk>
      $60A7,$9CA4,      // <cjk>
      $60A9,$9459,      // <cjk>
      $60AA,$88AB,      // <cjk>
      $60B2,$94DF,      // <cjk>
      $60B3,$9C7B,      // <cjk>
      $60B4,$9CAA,      // <cjk>
      $60B5,$9CAE,      // <cjk>
      $60B6,$96E3,      // <cjk>
      $60B8,$9CA7,      // <cjk>
      $60BC,$9389,      // <cjk>
      $60BD,$9CAC,      // <cjk>
      $60C5,$8FEE,      // <cjk>
      $60C6,$9CAD,      // <cjk>
      $60C7,$93D5,      // <cjk>
      $60D1,$9866,      // <cjk>
      $60D3,$9CA9,      // <cjk>
      $60D8,$9CAF,      // <cjk>
      $60DA,$8D9B,      // <cjk>
      $60DC,$90C9,      // <cjk>
      $60DF,$88D2,      // <cjk>
      $60E0,$9CA8,      // <cjk>
      $60E1,$9CA6,      // <cjk>
      $60E3,$9179,      // <cjk>
      $60E7,$9C9C,      // <cjk>
      $60E8,$8E53,      // <cjk>
      $60F0,$91C4,      // <cjk>
      $60F1,$9CBB,      // <cjk>
      $60F3,$917A,      // <cjk>
      $60F4,$9CB6,      // <cjk>
      $60F6,$9CB3,      // <cjk>
      $60F7,$9CB4,      // <cjk>
      $60F9,$8EE4,      // <cjk>
      $60FA,$9CB7,      // <cjk>
      $60FB,$9CBA,      // <cjk>
      $6100,$9CB5,      // <cjk>
      $6101,$8F44,      // <cjk>
      $6103,$9CB8,      // <cjk>
      $6106,$9CB2,      // <cjk>
      $6108,$96FA,      // <cjk>
      $6109,$96F9,      // <cjk>
      $610D,$9CBC,      // <cjk>
      $610E,$9CBD,      // <cjk>
      $610F,$88D3,      // <cjk>
      $6115,$9CB1,      // <cjk>
      $611A,$8BF0,      // <cjk>
      $611B,$88A4,      // <cjk>
      $611F,$8AB4,      // <cjk>
      $6121,$9CB9,      // <cjk>
      $6127,$9CC1,      // <cjk>
      $6128,$9CC0,      // <cjk>
      $612C,$9CC5,      // <cjk>
      $6134,$9CC6,      // <cjk>
      $613C,$9CC4,      // <cjk>
      $613D,$9CC7,      // <cjk>
      $613E,$9CBF,      // <cjk>
      $613F,$9CC3,      // <cjk>
      $6142,$9CC8,      // <cjk>
      $6144,$9CC9,      // <cjk>
      $6147,$9CBE,      // <cjk>
      $6148,$8E9C,      // <cjk>
      $614A,$9CC2,      // <cjk>
      $614B,$91D4,      // <cjk>
      $614C,$8D51,      // <cjk>
      $614D,$9CB0,      // <cjk>
      $614E,$9054,      // <cjk>
      $6153,$9CD6,      // <cjk>
      $6155,$95E7,      // <cjk>
      $6158,$9CCC,      // <cjk>
      $6159,$9CCD,      // <cjk>
      $615A,$9CCE,      // <cjk>
      $615D,$9CD5,      // <cjk>
      $615F,$9CD4,      // <cjk>
      $6162,$969D,      // <cjk>
      $6163,$8AB5,      // <cjk>
      $6165,$9CD2,      // <cjk>
      $6167,$8C64,      // <cjk>
      $6168,$8A53,      // <cjk>
      $616B,$9CCF,      // <cjk>
      $616E,$97B6,      // <cjk>
      $616F,$9CD1,      // <cjk>
      $6170,$88D4,      // <cjk>
      $6171,$9CD3,      // <cjk>
      $6173,$9CCA,      // <cjk>
      $6174,$9CD0,      // <cjk>
      $6175,$9CD7,      // <cjk>
      $6176,$8C63,      // <cjk>
      $6177,$9CCB,      // <cjk>
      $617E,$977C,      // <cjk>
      $6182,$974A,      // <cjk>
      $6187,$9CDA,      // <cjk>
      $618A,$9CDE,      // <cjk>
      $618E,$919E,      // <cjk>
      $6190,$97F7,      // <cjk>
      $6191,$9CDF,      // <cjk>
      $6194,$9CDC,      // <cjk>
      $6196,$9CD9,      // <cjk>
      $6199,$9CD8,      // <cjk>
      $619A,$9CDD,      // <cjk>
      $61A4,$95AE,      // <cjk>
      $61A7,$93B2,      // <cjk>
      $61A9,$8C65,      // <cjk>
      $61AB,$9CE0,      // <cjk>
      $61AC,$9CDB,      // <cjk>
      $61AE,$9CE1,      // <cjk>
      $61B2,$8C9B,      // <cjk>
      $61B6,$89AF,      // <cjk>
      $61BA,$9CE9,      // <cjk>
      $61BE,$8AB6,      // <cjk>
      $61C3,$9CE7,      // <cjk>
      $61C6,$9CE8,      // <cjk>
      $61C7,$8DA7,      // <cjk>
      $61C8,$9CE6,      // <cjk>
      $61C9,$9CE4,      // <cjk>
      $61CA,$9CE3,      // <cjk>
      $61CB,$9CEA,      // <cjk>
      $61CC,$9CE2,      // <cjk>
      $61CD,$9CEC,      // <cjk>
      $61D0,$89F9,      // <cjk>
      $61E3,$9CEE,      // <cjk>
      $61E6,$9CED,      // <cjk>
      $61F2,$92A6,      // <cjk>
      $61F4,$9CF1,      // <cjk>
      $61F6,$9CEF,      // <cjk>
      $61F7,$9CE5,      // <cjk>
      $61F8,$8C9C,      // <cjk>
      $61FA,$9CF0,      // <cjk>
      $61FC,$9CF4,      // <cjk>
      $61FD,$9CF3,      // <cjk>
      $61FE,$9CF5,      // <cjk>
      $61FF,$9CF2,      // <cjk>
      $6200,$9CF6,      // <cjk>
      $6208,$9CF7,      // <cjk>
      $6209,$9CF8,      // <cjk>
      $620A,$95E8,      // <cjk>
      $620C,$9CFA,      // <cjk>
      $620D,$9CF9,      // <cjk>
      $620E,$8F5E,      // <cjk>
      $6210,$90AC,      // <cjk>
      $6211,$89E4,      // <cjk>
      $6212,$89FA,      // <cjk>
      $6214,$9CFB,      // <cjk>
      $6216,$88BD,      // <cjk>
      $621A,$90CA,      // <cjk>
      $621B,$9CFC,      // <cjk>
      $621D,$E6C1,      // <cjk>
      $621E,$9D40,      // <cjk>
      $621F,$8C81,      // <cjk>
      $6221,$9D41,      // <cjk>
      $6226,$90ED,      // <cjk>
      $622A,$9D42,      // <cjk>
      $622E,$9D43,      // <cjk>
      $622F,$8B59,      // <cjk>
      $6230,$9D44,      // <cjk>
      $6232,$9D45,      // <cjk>
      $6233,$9D46,      // <cjk>
      $6234,$91D5,      // <cjk>
      $6238,$8CCB,      // <cjk>
      $623B,$96DF,      // <cjk>
      $6240,$8F8A,      // <cjk>
      $6241,$9D47,      // <cjk>
      $6247,$90EE,      // <cjk>
      $6248,$E7BB,      // <cjk>
      $6249,$94E0,      // <cjk>
      $624B,$8EE8,      // <cjk>
      $624D,$8DCB,      // <cjk>
      $624E,$9D48,      // <cjk>
      $6253,$91C5,      // <cjk>
      $6255,$95A5,      // <cjk>
      $6258,$91EF,      // <cjk>
      $625B,$9D4B,      // <cjk>
      $625E,$9D49,      // <cjk>
      $6260,$9D4C,      // <cjk>
      $6263,$9D4A,      // <cjk>
      $6268,$9D4D,      // <cjk>
      $626E,$95AF,      // <cjk>
      $6271,$88B5,      // <cjk>
      $6276,$957D,      // <cjk>
      $6279,$94E1,      // <cjk>
      $627C,$9D4E,      // <cjk>
      $627E,$9D51,      // <cjk>
      $627F,$8FB3,      // <cjk>
      $6280,$8B5A,      // <cjk>
      $6282,$9D4F,      // <cjk>
      $6283,$9D56,      // <cjk>
      $6284,$8FB4,      // <cjk>
      $6289,$9D50,      // <cjk>
      $628A,$9463,      // <cjk>
      $6291,$977D,      // <cjk>
      $6292,$9D52,      // <cjk>
      $6293,$9D53,      // <cjk>
      $6294,$9D57,      // <cjk>
      $6295,$938A,      // <cjk>
      $6296,$9D54,      // <cjk>
      $6297,$8D52,      // <cjk>
      $6298,$90DC,      // <cjk>
      $629B,$9D65,      // <cjk>
      $629C,$94B2,      // <cjk>
      $629E,$91F0,      // <cjk>
      $62AB,$94E2,      // <cjk>
      $62AC,$9DAB,      // <cjk>
      $62B1,$95F8,      // <cjk>
      $62B5,$92EF,      // <cjk>
      $62B9,$9695,      // <cjk>
      $62BB,$9D5A,      // <cjk>
      $62BC,$899F,      // <cjk>
      $62BD,$928A,      // <cjk>
      $62C2,$9D63,      // <cjk>
      $62C5,$9253,      // <cjk>
      $62C6,$9D5D,      // <cjk>
      $62C7,$9D64,      // <cjk>
      $62C8,$9D5F,      // <cjk>
      $62C9,$9D66,      // <cjk>
      $62CA,$9D62,      // <cjk>
      $62CC,$9D61,      // <cjk>
      $62CD,$948F,      // <cjk>
      $62D0,$89FB,      // <cjk>
      $62D1,$9D59,      // <cjk>
      $62D2,$8B91,      // <cjk>
      $62D3,$91F1,      // <cjk>
      $62D4,$9D55,      // <cjk>
      $62D7,$9D58,      // <cjk>
      $62D8,$8D53,      // <cjk>
      $62D9,$90D9,      // <cjk>
      $62DB,$8FB5,      // <cjk>
      $62DC,$9D60,      // <cjk>
      $62DD,$9471,      // <cjk>
      $62E0,$8B92,      // <cjk>
      $62E1,$8A67,      // <cjk>
      $62EC,$8A87,      // <cjk>
      $62ED,$9040,      // <cjk>
      $62EE,$9D68,      // <cjk>
      $62EF,$9D6D,      // <cjk>
      $62F1,$9D69,      // <cjk>
      $62F3,$8C9D,      // <cjk>
      $62F5,$9D6E,      // <cjk>
      $62F6,$8E41,      // <cjk>
      $62F7,$8D89,      // <cjk>
      $62FE,$8F45,      // <cjk>
      $62FF,$9D5C,      // <cjk>
      $6301,$8E9D,      // <cjk>
      $6302,$9D6B,      // <cjk>
      $6307,$8E77,      // <cjk>
      $6308,$9D6C,      // <cjk>
      $6309,$88C2,      // <cjk>
      $630C,$9D67,      // <cjk>
      $6311,$92A7,      // <cjk>
      $6319,$8B93,      // <cjk>
      $631F,$8BB2,      // <cjk>
      $6327,$9D6A,      // <cjk>
      $6328,$88A5,      // <cjk>
      $632B,$8DC1,      // <cjk>
      $632F,$9055,      // <cjk>
      $633A,$92F0,      // <cjk>
      $633D,$94D2,      // <cjk>
      $633E,$9D70,      // <cjk>
      $633F,$917D,      // <cjk>
      $6349,$91A8,      // <cjk>
      $634C,$8E4A,      // <cjk>
      $634D,$9D71,      // <cjk>
      $634F,$9D73,      // <cjk>
      $6350,$9D6F,      // <cjk>
      $6355,$95DF,      // <cjk>
      $6357,$92BB,      // <cjk>
      $635C,$917B,      // <cjk>
      $6367,$95F9,      // <cjk>
      $6368,$8ECC,      // <cjk>
      $6369,$9D80,      // <cjk>
      $636B,$9D7E,      // <cjk>
      $636E,$9098,      // <cjk>
      $6372,$8C9E,      // <cjk>
      $6376,$9D78,      // <cjk>
      $6377,$8FB7,      // <cjk>
      $637A,$93E6,      // <cjk>
      $637B,$9450,      // <cjk>
      $6380,$9D76,      // <cjk>
      $6383,$917C,      // <cjk>
      $6388,$8EF6,      // <cjk>
      $6389,$9D7B,      // <cjk>
      $638C,$8FB6,      // <cjk>
      $638E,$9D75,      // <cjk>
      $638F,$9D7A,      // <cjk>
      $6392,$9472,      // <cjk>
      $6396,$9D74,      // <cjk>
      $6398,$8C40,      // <cjk>
      $639B,$8A7C,      // <cjk>
      $639F,$9D7C,      // <cjk>
      $63A0,$97A9,      // <cjk>
      $63A1,$8DCC,      // <cjk>
      $63A2,$9254,      // <cjk>
      $63A3,$9D79,      // <cjk>
      $63A5,$90DA,      // <cjk>
      $63A7,$8D54,      // <cjk>
      $63A8,$9084,      // <cjk>
      $63A9,$8986,      // <cjk>
      $63AB,$9D77,      // <cjk>
      $63AC,$8B64,      // <cjk>
      $63B2,$8C66,      // <cjk>
      $63B4,$92CD,      // <cjk>
      $63B5,$9D7D,      // <cjk>
      $63BB,$917E,      // <cjk>
      $63BE,$9D81,      // <cjk>
      $63C0,$9D83,      // <cjk>
      $63C3,$91B5,      // <cjk>
      $63C4,$9D89,      // <cjk>
      $63C6,$9D84,      // <cjk>
      $63C9,$9D86,      // <cjk>
      $63CF,$9560,      // <cjk>
      $63D0,$92F1,      // <cjk>
      $63D2,$9D87,      // <cjk>
      $63D6,$974B,      // <cjk>
      $63DA,$9767,      // <cjk>
      $63DB,$8AB7,      // <cjk>
      $63E1,$88AC,      // <cjk>
      $63E3,$9D85,      // <cjk>
      $63E9,$9D82,      // <cjk>
      $63EE,$8AF6,      // <cjk>
      $63F4,$8987,      // <cjk>
      $63F6,$9D88,      // <cjk>
      $63FA,$9768,      // <cjk>
      $6406,$9D8C,      // <cjk>
      $640D,$91B9,      // <cjk>
      $640F,$9D93,      // <cjk>
      $6413,$9D8D,      // <cjk>
      $6416,$9D8A,      // <cjk>
      $6417,$9D91,      // <cjk>
      $641C,$9D72,      // <cjk>
      $6426,$9D8E,      // <cjk>
      $6428,$9D92,      // <cjk>
      $642C,$94C0,      // <cjk>
      $642D,$938B,      // <cjk>
      $6434,$9D8B,      // <cjk>
      $6436,$9D8F,      // <cjk>
      $643A,$8C67,      // <cjk>
      $643E,$8DEF,      // <cjk>
      $6442,$90DB,      // <cjk>
      $644E,$9D97,      // <cjk>
      $6458,$9345,      // <cjk>
      $6467,$9D94,      // <cjk>
      $6469,$9680,      // <cjk>
      $646F,$9D95,      // <cjk>
      $6476,$9D96,      // <cjk>
      $6478,$96CC,      // <cjk>
      $647A,$90A0,      // <cjk>
      $6483,$8C82,      // <cjk>
      $6488,$9D9D,      // <cjk>
      $6492,$8E54,      // <cjk>
      $6493,$9D9A,      // <cjk>
      $6495,$9D99,      // <cjk>
      $649A,$9451,      // <cjk>
      $649E,$93B3,      // <cjk>
      $64A4,$9350,      // <cjk>
      $64A5,$9D9B,      // <cjk>
      $64A9,$9D9C,      // <cjk>
      $64AB,$958F,      // <cjk>
      $64AD,$9464,      // <cjk>
      $64AE,$8E42,      // <cjk>
      $64B0,$90EF,      // <cjk>
      $64B2,$966F,      // <cjk>
      $64B9,$8A68,      // <cjk>
      $64BB,$9DA3,      // <cjk>
      $64BC,$9D9E,      // <cjk>
      $64C1,$9769,      // <cjk>
      $64C2,$9DA5,      // <cjk>
      $64C5,$9DA1,      // <cjk>
      $64C7,$9DA2,      // <cjk>
      $64CD,$9180,      // <cjk>
      $64D2,$9DA0,      // <cjk>
      $64D4,$9D5E,      // <cjk>
      $64D8,$9DA4,      // <cjk>
      $64DA,$9D9F,      // <cjk>
      $64E0,$9DA9,      // <cjk>
      $64E1,$9DAA,      // <cjk>
      $64E2,$9346,      // <cjk>
      $64E3,$9DAC,      // <cjk>
      $64E6,$8E43,      // <cjk>
      $64E7,$9DA7,      // <cjk>
      $64EF,$9DAD,      // <cjk>
      $64F1,$9DA6,      // <cjk>
      $64F2,$9DB1,      // <cjk>
      $64F4,$9DB0,      // <cjk>
      $64F6,$9DAF,      // <cjk>
      $64FA,$9DB2,      // <cjk>
      $64FD,$9DB4,      // <cjk>
      $64FE,$8FEF,      // <cjk>
      $6500,$9DB3,      // <cjk>
      $6505,$9DB7,      // <cjk>
      $6518,$9DB5,      // <cjk>
      $651C,$9DB6,      // <cjk>
      $651D,$9D90,      // <cjk>
      $6523,$9DB9,      // <cjk>
      $6524,$9DB8,      // <cjk>
      $652A,$9D98,      // <cjk>
      $652B,$9DBA,      // <cjk>
      $652C,$9DAE,      // <cjk>
      $652F,$8E78,      // <cjk>
      $6534,$9DBB,      // <cjk>
      $6535,$9DBC,      // <cjk>
      $6536,$9DBE,      // <cjk>
      $6537,$9DBD,      // <cjk>
      $6538,$9DBF,      // <cjk>
      $6539,$89FC,      // <cjk>
      $653B,$8D55,      // <cjk>
      $653E,$95FA,      // <cjk>
      $653F,$90AD,      // <cjk>
      $6545,$8CCC,      // <cjk>
      $6548,$9DC1,      // <cjk>
      $654D,$9DC4,      // <cjk>
      $654F,$9571,      // <cjk>
      $6551,$8B7E,      // <cjk>
      $6555,$9DC3,      // <cjk>
      $6556,$9DC2,      // <cjk>
      $6557,$9473,      // <cjk>
      $6558,$9DC5,      // <cjk>
      $6559,$8BB3,      // <cjk>
      $655D,$9DC7,      // <cjk>
      $655E,$9DC6,      // <cjk>
      $6562,$8AB8,      // <cjk>
      $6563,$8E55,      // <cjk>
      $6566,$93D6,      // <cjk>
      $656C,$8C68,      // <cjk>
      $6570,$9094,      // <cjk>
      $6572,$9DC8,      // <cjk>
      $6574,$90AE,      // <cjk>
      $6575,$9347,      // <cjk>
      $6577,$957E,      // <cjk>
      $6578,$9DC9,      // <cjk>
      $6582,$9DCA,      // <cjk>
      $6583,$9DCB,      // <cjk>
      $6587,$95B6,      // <cjk>
      $6588,$9B7C,      // <cjk>
      $6589,$90C4,      // <cjk>
      $658C,$956B,      // <cjk>
      $658E,$8DD6,      // <cjk>
      $6590,$94E3,      // <cjk>
      $6591,$94C1,      // <cjk>
      $6597,$936C,      // <cjk>
      $6599,$97BF,      // <cjk>
      $659B,$9DCD,      // <cjk>
      $659C,$8ECE,      // <cjk>
      $659F,$9DCE,      // <cjk>
      $65A1,$88B4,      // <cjk>
      $65A4,$8BD2,      // <cjk>
      $65A5,$90CB,      // <cjk>
      $65A7,$9580,      // <cjk>
      $65AB,$9DCF,      // <cjk>
      $65AC,$8E61,      // <cjk>
      $65AD,$9266,      // <cjk>
      $65AF,$8E7A,      // <cjk>
      $65B0,$9056,      // <cjk>
      $65B7,$9DD0,      // <cjk>
      $65B9,$95FB,      // <cjk>
      $65BC,$8997,      // <cjk>
      $65BD,$8E7B,      // <cjk>
      $65C1,$9DD3,      // <cjk>
      $65C3,$9DD1,      // <cjk>
      $65C4,$9DD4,      // <cjk>
      $65C5,$97B7,      // <cjk>
      $65C6,$9DD2,      // <cjk>
      $65CB,$90F9,      // <cjk>
      $65CC,$9DD5,      // <cjk>
      $65CF,$91B0,      // <cjk>
      $65D2,$9DD6,      // <cjk>
      $65D7,$8AF8,      // <cjk>
      $65D9,$9DD8,      // <cjk>
      $65DB,$9DD7,      // <cjk>
      $65E0,$9DD9,      // <cjk>
      $65E1,$9DDA,      // <cjk>
      $65E2,$8AF9,      // <cjk>
      $65E5,$93FA,      // <cjk>
      $65E6,$9255,      // <cjk>
      $65E7,$8B8C,      // <cjk>
      $65E8,$8E7C,      // <cjk>
      $65E9,$9181,      // <cjk>
      $65EC,$8F7B,      // <cjk>
      $65ED,$88AE,      // <cjk>
      $65F1,$9DDB,      // <cjk>
      $65FA,$89A0,      // <cjk>
      $65FB,$9DDF,      // <cjk>
      $6602,$8D56,      // <cjk>
      $6603,$9DDE,      // <cjk>
      $6606,$8DA9,      // <cjk>
      $6607,$8FB8,      // <cjk>
      $660A,$9DDD,      // <cjk>
      $660C,$8FB9,      // <cjk>
      $660E,$96BE,      // <cjk>
      $660F,$8DA8,      // <cjk>
      $6613,$88D5,      // <cjk>
      $6614,$90CC,      // <cjk>
      $661C,$9DE4,      // <cjk>
      $661F,$90AF,      // <cjk>
      $6620,$8966,      // <cjk>
      $6625,$8F74,      // <cjk>
      $6627,$9686,      // <cjk>
      $6628,$8DF0,      // <cjk>
      $662D,$8FBA,      // <cjk>
      $662F,$90A5,      // <cjk>
      $6634,$9DE3,      // <cjk>
      $6635,$9DE1,      // <cjk>
      $6636,$9DE2,      // <cjk>
      $663C,$928B,      // <cjk>
      $663F,$9E45,      // <cjk>
      $6641,$9DE8,      // <cjk>
      $6642,$8E9E,      // <cjk>
      $6643,$8D57,      // <cjk>
      $6644,$9DE6,      // <cjk>
      $6649,$9DE7,      // <cjk>
      $664B,$9057,      // <cjk>
      $664F,$9DE5,      // <cjk>
      $6652,$8E4E,      // <cjk>
      $665D,$9DEA,      // <cjk>
      $665E,$9DE9,      // <cjk>
      $665F,$9DEE,      // <cjk>
      $6662,$9DEF,      // <cjk>
      $6664,$9DEB,      // <cjk>
      $6666,$8A41,      // <cjk>
      $6667,$9DEC,      // <cjk>
      $6668,$9DED,      // <cjk>
      $6669,$94D3,      // <cjk>
      $666E,$9581,      // <cjk>
      $666F,$8C69,      // <cjk>
      $6670,$9DF0,      // <cjk>
      $6674,$90B0,      // <cjk>
      $6676,$8FBB,      // <cjk>
      $667A,$9271,      // <cjk>
      $6681,$8BC5,      // <cjk>
      $6683,$9DF1,      // <cjk>
      $6684,$9DF5,      // <cjk>
      $6687,$89C9,      // <cjk>
      $6688,$9DF2,      // <cjk>
      $6689,$9DF4,      // <cjk>
      $668E,$9DF3,      // <cjk>
      $6691,$8F8B,      // <cjk>
      $6696,$9267,      // <cjk>
      $6697,$88C3,      // <cjk>
      $6698,$9DF6,      // <cjk>
      $669D,$9DF7,      // <cjk>
      $66A2,$92A8,      // <cjk>
      $66A6,$97EF,      // <cjk>
      $66AB,$8E62,      // <cjk>
      $66AE,$95E9,      // <cjk>
      $66B4,$965C,      // <cjk>
      $66B8,$9E41,      // <cjk>
      $66B9,$9DF9,      // <cjk>
      $66BC,$9DFC,      // <cjk>
      $66BE,$9DFB,      // <cjk>
      $66C1,$9DF8,      // <cjk>
      $66C4,$9E40,      // <cjk>
      $66C7,$93DC,      // <cjk>
      $66C9,$9DFA,      // <cjk>
      $66D6,$9E42,      // <cjk>
      $66D9,$8F8C,      // <cjk>
      $66DA,$9E43,      // <cjk>
      $66DC,$976A,      // <cjk>
      $66DD,$9498,      // <cjk>
      $66E0,$9E44,      // <cjk>
      $66E6,$9E46,      // <cjk>
      $66E9,$9E47,      // <cjk>
      $66F0,$9E48,      // <cjk>
      $66F2,$8BC8,      // <cjk>
      $66F3,$8967,      // <cjk>
      $66F4,$8D58,      // <cjk>
      $66F5,$9E49,      // <cjk>
      $66F7,$9E4A,      // <cjk>
      $66F8,$8F91,      // <cjk>
      $66F9,$9182,      // <cjk>
      $66FC,$99D6,      // <cjk>
      $66FD,$915D,      // <cjk>
      $66FE,$915C,      // <cjk>
      $66FF,$91D6,      // <cjk>
      $6700,$8DC5,      // <cjk>
      $6703,$98F0,      // <cjk>
      $6708,$8C8E,      // <cjk>
      $6709,$974C,      // <cjk>
      $670B,$95FC,      // <cjk>
      $670D,$959E,      // <cjk>
      $670F,$9E4B,      // <cjk>
      $6714,$8DF1,      // <cjk>
      $6715,$92BD,      // <cjk>
      $6716,$9E4C,      // <cjk>
      $6717,$984E,      // <cjk>
      $671B,$965D,      // <cjk>
      $671D,$92A9,      // <cjk>
      $671E,$9E4D,      // <cjk>
      $671F,$8AFA,      // <cjk>
      $6726,$9E4E,      // <cjk>
      $6727,$9E4F,      // <cjk>
      $6728,$96D8,      // <cjk>
      $672A,$96A2,      // <cjk>
      $672B,$9696,      // <cjk>
      $672C,$967B,      // <cjk>
      $672D,$8E44,      // <cjk>
      $672E,$9E51,      // <cjk>
      $6731,$8EE9,      // <cjk>
      $6734,$9670,      // <cjk>
      $6736,$9E53,      // <cjk>
      $6737,$9E56,      // <cjk>
      $6738,$9E55,      // <cjk>
      $673A,$8AF7,      // <cjk>
      $673D,$8B80,      // <cjk>
      $673F,$9E52,      // <cjk>
      $6741,$9E54,      // <cjk>
      $6746,$9E57,      // <cjk>
      $6749,$9099,      // <cjk>
      $674E,$979B,      // <cjk>
      $674F,$88C7,      // <cjk>
      $6750,$8DDE,      // <cjk>
      $6751,$91BA,      // <cjk>
      $6753,$8EDB,      // <cjk>
      $6756,$8FF1,      // <cjk>
      $6759,$9E5A,      // <cjk>
      $675C,$936D,      // <cjk>
      $675E,$9E58,      // <cjk>
      $675F,$91A9,      // <cjk>
      $6760,$9E59,      // <cjk>
      $6761,$8FF0,      // <cjk>
      $6762,$96DB,      // <cjk>
      $6764,$9E5C,      // <cjk>
      $6765,$9788,      // <cjk>
      $676A,$9E61,      // <cjk>
      $676D,$8D59,      // <cjk>
      $676F,$9474,      // <cjk>
      $6770,$9E5E,      // <cjk>
      $6771,$938C,      // <cjk>
      $6772,$9DDC,      // <cjk>
      $6773,$9DE0,      // <cjk>
      $6775,$8B6E,      // <cjk>
      $6777,$9466,      // <cjk>
      $677C,$9E60,      // <cjk>
      $677E,$8FBC,      // <cjk>
      $677F,$94C2,      // <cjk>
      $6785,$9E66,      // <cjk>
      $6787,$94F8,      // <cjk>
      $6789,$9E5D,      // <cjk>
      $678B,$9E63,      // <cjk>
      $678C,$9E62,      // <cjk>
      $6790,$90CD,      // <cjk>
      $6795,$968D,      // <cjk>
      $6797,$97D1,      // <cjk>
      $679A,$9687,      // <cjk>
      $679C,$89CA,      // <cjk>
      $679D,$8E7D,      // <cjk>
      $67A0,$9867,      // <cjk>
      $67A1,$9E65,      // <cjk>
      $67A2,$9095,      // <cjk>
      $67A6,$9E64,      // <cjk>
      $67A9,$9E5F,      // <cjk>
      $67AF,$8CCD,      // <cjk>
      $67B3,$9E6B,      // <cjk>
      $67B4,$9E69,      // <cjk>
      $67B6,$89CB,      // <cjk>
      $67B7,$9E67,      // <cjk>
      $67B8,$9E6D,      // <cjk>
      $67B9,$9E73,      // <cjk>
      $67C1,$91C6,      // <cjk>
      $67C4,$95BF,      // <cjk>
      $67C6,$9E75,      // <cjk>
      $67CA,$9541,      // <cjk>
      $67CE,$9E74,      // <cjk>
      $67CF,$9490,      // <cjk>
      $67D0,$965E,      // <cjk>
      $67D1,$8AB9,      // <cjk>
      $67D3,$90F5,      // <cjk>
      $67D4,$8F5F,      // <cjk>
      $67D8,$92D1,      // <cjk>
      $67DA,$974D,      // <cjk>
      $67DD,$9E70,      // <cjk>
      $67DE,$9E6F,      // <cjk>
      $67E2,$9E71,      // <cjk>
      $67E4,$9E6E,      // <cjk>
      $67E7,$9E76,      // <cjk>
      $67E9,$9E6C,      // <cjk>
      $67EC,$9E6A,      // <cjk>
      $67EE,$9E72,      // <cjk>
      $67EF,$9E68,      // <cjk>
      $67F1,$928C,      // <cjk>
      $67F3,$96F6,      // <cjk>
      $67F4,$8EC4,      // <cjk>
      $67F5,$8DF2,      // <cjk>
      $67FB,$8DB8,      // <cjk>
      $67FE,$968F,      // <cjk>
      $67FF,$8A60,      // <cjk>
      $6802,$92CC,      // <cjk>
      $6803,$93C8,      // <cjk>
      $6804,$8968,      // <cjk>
      $6813,$90F0,      // <cjk>
      $6816,$90B2,      // <cjk>
      $6817,$8C49,      // <cjk>
      $681E,$9E78,      // <cjk>
      $6821,$8D5A,      // <cjk>
      $6822,$8A9C,      // <cjk>
      $6829,$9E7A,      // <cjk>
      $682A,$8A94,      // <cjk>
      $682B,$9E81,      // <cjk>
      $6832,$9E7D,      // <cjk>
      $6834,$90F1,      // <cjk>
      $6838,$8A6A,      // <cjk>
      $6839,$8DAA,      // <cjk>
      $683C,$8A69,      // <cjk>
      $683D,$8DCD,      // <cjk>
      $6840,$9E7B,      // <cjk>
      $6841,$8C85,      // <cjk>
      $6842,$8C6A,      // <cjk>
      $6843,$938D,      // <cjk>
      $6846,$9E79,      // <cjk>
      $6848,$88C4,      // <cjk>
      $684D,$9E7C,      // <cjk>
      $684E,$9E7E,      // <cjk>
      $6850,$8BCB,      // <cjk>
      $6851,$8C4B,      // <cjk>
      $6853,$8ABA,      // <cjk>
      $6854,$8B6A,      // <cjk>
      $6859,$9E82,      // <cjk>
      $685C,$8DF7,      // <cjk>
      $685D,$9691,      // <cjk>
      $685F,$8E56,      // <cjk>
      $6863,$9E83,      // <cjk>
      $6867,$954F,      // <cjk>
      $6874,$9E8F,      // <cjk>
      $6876,$89B1,      // <cjk>
      $6877,$9E84,      // <cjk>
      $687E,$9E95,      // <cjk>
      $687F,$9E85,      // <cjk>
      $6881,$97C0,      // <cjk>
      $6883,$9E8C,      // <cjk>
      $6885,$947E,      // <cjk>
      $688D,$9E94,      // <cjk>
      $688F,$9E87,      // <cjk>
      $6893,$88B2,      // <cjk>
      $6894,$9E89,      // <cjk>
      $689B,$9E8B,      // <cjk>
      $689D,$9E8A,      // <cjk>
      $689F,$9E86,      // <cjk>
      $68A0,$9E91,      // <cjk>
      $68A2,$8FBD,      // <cjk>
      $68A6,$9AEB,      // <cjk>
      $68A7,$8CE6,      // <cjk>
      $68A8,$979C,      // <cjk>
      $68AD,$9E88,      // <cjk>
      $68AF,$92F2,      // <cjk>
      $68B0,$8A42,      // <cjk>
      $68B1,$8DAB,      // <cjk>
      $68B3,$9E80,      // <cjk>
      $68B5,$9E90,      // <cjk>
      $68B6,$8A81,      // <cjk>
      $68B9,$9E8E,      // <cjk>
      $68BA,$9E92,      // <cjk>
      $68BC,$938E,      // <cjk>
      $68C4,$8AFC,      // <cjk>
      $68C6,$9EB0,      // <cjk>
      $68C9,$96C7,      // <cjk>
      $68CA,$9E97,      // <cjk>
      $68CB,$8AFB,      // <cjk>
      $68CD,$9E9E,      // <cjk>
      $68D2,$965F,      // <cjk>
      $68D4,$9E9F,      // <cjk>
      $68D5,$9EA1,      // <cjk>
      $68D7,$9EA5,      // <cjk>
      $68D8,$9E99,      // <cjk>
      $68DA,$9249,      // <cjk>
      $68DF,$938F,      // <cjk>
      $68E0,$9EA9,      // <cjk>
      $68E1,$9E9C,      // <cjk>
      $68E3,$9EA6,      // <cjk>
      $68E7,$9EA0,      // <cjk>
      $68EE,$9058,      // <cjk>
      $68EF,$9EAA,      // <cjk>
      $68F2,$90B1,      // <cjk>
      $68F9,$9EA8,      // <cjk>
      $68FA,$8ABB,      // <cjk>
      $6900,$986F,      // <cjk>
      $6901,$9E96,      // <cjk>
      $6904,$9EA4,      // <cjk>
      $6905,$88D6,      // <cjk>
      $6908,$9E98,      // <cjk>
      $690B,$96B8,      // <cjk>
      $690C,$9E9D,      // <cjk>
      $690D,$9041,      // <cjk>
      $690E,$92C5,      // <cjk>
      $690F,$9E93,      // <cjk>
      $6912,$9EA3,      // <cjk>
      $6919,$909A,      // <cjk>
      $691A,$9EAD,      // <cjk>
      $691B,$8A91,      // <cjk>
      $691C,$8C9F,      // <cjk>
      $6921,$9EAF,      // <cjk>
      $6922,$9E9A,      // <cjk>
      $6923,$9EAE,      // <cjk>
      $6925,$9EA7,      // <cjk>
      $6926,$9E9B,      // <cjk>
      $6928,$9EAB,      // <cjk>
      $692A,$9EAC,      // <cjk>
      $6930,$9EBD,      // <cjk>
      $6934,$93CC,      // <cjk>
      $6936,$9EA2,      // <cjk>
      $6939,$9EB9,      // <cjk>
      $693D,$9EBB,      // <cjk>
      $693F,$92D6,      // <cjk>
      $694A,$976B,      // <cjk>
      $6953,$9596,      // <cjk>
      $6954,$9EB6,      // <cjk>
      $6955,$91C8,      // <cjk>
      $6959,$9EBC,      // <cjk>
      $695A,$915E,      // <cjk>
      $695C,$9EB3,      // <cjk>
      $695D,$9EC0,      // <cjk>
      $695E,$9EBF,      // <cjk>
      $6960,$93ED,      // <cjk>
      $6961,$9EBE,      // <cjk>
      $6962,$93E8,      // <cjk>
      $696A,$9EC2,      // <cjk>
      $696B,$9EB5,      // <cjk>
      $696D,$8BC6,      // <cjk>
      $696E,$9EB8,      // <cjk>
      $696F,$8F7C,      // <cjk>
      $6973,$9480,      // <cjk>
      $6974,$9EBA,      // <cjk>
      $6975,$8BC9,      // <cjk>
      $6977,$9EB2,      // <cjk>
      $6978,$9EB4,      // <cjk>
      $6979,$9EB1,      // <cjk>
      $697C,$984F,      // <cjk>
      $697D,$8A79,      // <cjk>
      $697E,$9EB7,      // <cjk>
      $6981,$9EC1,      // <cjk>
      $6982,$8A54,      // <cjk>
      $698A,$8DE5,      // <cjk>
      $698E,$897C,      // <cjk>
      $6991,$9ED2,      // <cjk>
      $6994,$9850,      // <cjk>
      $6995,$9ED5,      // <cjk>
      $699B,$9059,      // <cjk>
      $699C,$9ED4,      // <cjk>
      $69A0,$9ED3,      // <cjk>
      $69A7,$9ED0,      // <cjk>
      $69AE,$9EC4,      // <cjk>
      $69B1,$9EE1,      // <cjk>
      $69B2,$9EC3,      // <cjk>
      $69B4,$9ED6,      // <cjk>
      $69BB,$9ECE,      // <cjk>
      $69BE,$9EC9,      // <cjk>
      $69BF,$9EC6,      // <cjk>
      $69C1,$9EC7,      // <cjk>
      $69C3,$9ECF,      // <cjk>
      $69C7,$EAA0,      // <cjk>
      $69CA,$9ECC,      // <cjk>
      $69CB,$8D5C,      // <cjk>
      $69CC,$92C6,      // <cjk>
      $69CD,$9184,      // <cjk>
      $69CE,$9ECA,      // <cjk>
      $69D0,$9EC5,      // <cjk>
      $69D3,$9EC8,      // <cjk>
      $69D8,$976C,      // <cjk>
      $69D9,$968A,      // <cjk>
      $69DD,$9ECD,      // <cjk>
      $69DE,$9ED7,      // <cjk>
      $69E7,$9EDF,      // <cjk>
      $69E8,$9ED8,      // <cjk>
      $69EB,$9EE5,      // <cjk>
      $69ED,$9EE3,      // <cjk>
      $69F2,$9EDE,      // <cjk>
      $69F9,$9EDD,      // <cjk>
      $69FB,$92CE,      // <cjk>
      $69FD,$9185,      // <cjk>
      $69FF,$9EDB,      // <cjk>
      $6A02,$9ED9,      // <cjk>
      $6A05,$9EE0,      // <cjk>
      $6A0A,$9EE6,      // <cjk>
      $6A0B,$94F3,      // <cjk>
      $6A0C,$9EEC,      // <cjk>
      $6A12,$9EE7,      // <cjk>
      $6A13,$9EEA,      // <cjk>
      $6A14,$9EE4,      // <cjk>
      $6A17,$9294,      // <cjk>
      $6A19,$9557,      // <cjk>
      $6A1B,$9EDA,      // <cjk>
      $6A1E,$9EE2,      // <cjk>
      $6A1F,$8FBE,      // <cjk>
      $6A21,$96CD,      // <cjk>
      $6A22,$9EF6,      // <cjk>
      $6A23,$9EE9,      // <cjk>
      $6A29,$8CA0,      // <cjk>
      $6A2A,$89A1,      // <cjk>
      $6A2B,$8A7E,      // <cjk>
      $6A2E,$9ED1,      // <cjk>
      $6A35,$8FBF,      // <cjk>
      $6A36,$9EEE,      // <cjk>
      $6A38,$9EF5,      // <cjk>
      $6A39,$8EF7,      // <cjk>
      $6A3A,$8A92,      // <cjk>
      $6A3D,$924D,      // <cjk>
      $6A44,$9EEB,      // <cjk>
      $6A47,$9EF0,      // <cjk>
      $6A48,$9EF4,      // <cjk>
      $6A4B,$8BB4,      // <cjk>
      $6A58,$8B6B,      // <cjk>
      $6A59,$9EF2,      // <cjk>
      $6A5F,$8B40,      // <cjk>
      $6A61,$93C9,      // <cjk>
      $6A62,$9EF1,      // <cjk>
      $6A66,$9EF3,      // <cjk>
      $6A72,$9EED,      // <cjk>
      $6A78,$9EEF,      // <cjk>
      $6A7F,$8A80,      // <cjk>
      $6A80,$9268,      // <cjk>
      $6A84,$9EFA,      // <cjk>
      $6A8D,$9EF8,      // <cjk>
      $6A8E,$8CE7,      // <cjk>
      $6A90,$9EF7,      // <cjk>
      $6A97,$9F40,      // <cjk>
      $6A9C,$9E77,      // <cjk>
      $6AA0,$9EF9,      // <cjk>
      $6AA2,$9EFB,      // <cjk>
      $6AA3,$9EFC,      // <cjk>
      $6AAA,$9F4B,      // <cjk>
      $6AAC,$9F47,      // <cjk>
      $6AAE,$9E8D,      // <cjk>
      $6AB3,$9F46,      // <cjk>
      $6AB8,$9F45,      // <cjk>
      $6ABB,$9F42,      // <cjk>
      $6AC1,$9EE8,      // <cjk>
      $6AC2,$9F44,      // <cjk>
      $6AC3,$9F43,      // <cjk>
      $6AD1,$9F49,      // <cjk>
      $6AD3,$9845,      // <cjk>
      $6ADA,$9F4C,      // <cjk>
      $6ADB,$8BF9,      // <cjk>
      $6ADE,$9F48,      // <cjk>
      $6ADF,$9F4A,      // <cjk>
      $6AE8,$94A5,      // <cjk>
      $6AEA,$9F4D,      // <cjk>
      $6AFA,$9F51,      // <cjk>
      $6AFB,$9F4E,      // <cjk>
      $6B04,$9793,      // <cjk>
      $6B05,$9F4F,      // <cjk>
      $6B0A,$9EDC,      // <cjk>
      $6B12,$9F52,      // <cjk>
      $6B16,$9F53,      // <cjk>
      $6B1D,$8954,      // <cjk>
      $6B1F,$9F55,      // <cjk>
      $6B20,$8C87,      // <cjk>
      $6B21,$8E9F,      // <cjk>
      $6B23,$8BD3,      // <cjk>
      $6B27,$89A2,      // <cjk>
      $6B32,$977E,      // <cjk>
      $6B37,$9F57,      // <cjk>
      $6B38,$9F56,      // <cjk>
      $6B39,$9F59,      // <cjk>
      $6B3A,$8B5C,      // <cjk>
      $6B3D,$8BD4,      // <cjk>
      $6B3E,$8ABC,      // <cjk>
      $6B43,$9F5C,      // <cjk>
      $6B49,$9F5D,      // <cjk>
      $6B4C,$89CC,      // <cjk>
      $6B4E,$9256,      // <cjk>
      $6B50,$9F5E,      // <cjk>
      $6B53,$8ABD,      // <cjk>
      $6B54,$9F60,      // <cjk>
      $6B59,$9F5F,      // <cjk>
      $6B5B,$9F61,      // <cjk>
      $6B5F,$9F62,      // <cjk>
      $6B61,$9F63,      // <cjk>
      $6B62,$8E7E,      // <cjk>
      $6B63,$90B3,      // <cjk>
      $6B64,$8D9F,      // <cjk>
      $6B66,$9590,      // <cjk>
      $6B69,$95E0,      // <cjk>
      $6B6A,$9863,      // <cjk>
      $6B6F,$8E95,      // <cjk>
      $6B73,$8DCE,      // <cjk>
      $6B74,$97F0,      // <cjk>
      $6B78,$9F64,      // <cjk>
      $6B79,$9F65,      // <cjk>
      $6B7B,$8E80,      // <cjk>
      $6B7F,$9F66,      // <cjk>
      $6B80,$9F67,      // <cjk>
      $6B83,$9F69,      // <cjk>
      $6B84,$9F68,      // <cjk>
      $6B86,$9677,      // <cjk>
      $6B89,$8F7D,      // <cjk>
      $6B8A,$8EEA,      // <cjk>
      $6B8B,$8E63,      // <cjk>
      $6B8D,$9F6A,      // <cjk>
      $6B95,$9F6C,      // <cjk>
      $6B96,$9042,      // <cjk>
      $6B98,$9F6B,      // <cjk>
      $6B9E,$9F6D,      // <cjk>
      $6BA4,$9F6E,      // <cjk>
      $6BAA,$9F6F,      // <cjk>
      $6BAB,$9F70,      // <cjk>
      $6BAF,$9F71,      // <cjk>
      $6BB1,$9F73,      // <cjk>
      $6BB2,$9F72,      // <cjk>
      $6BB3,$9F74,      // <cjk>
      $6BB4,$89A3,      // <cjk>
      $6BB5,$9269,      // <cjk>
      $6BB7,$9F75,      // <cjk>
      $6BBA,$8E45,      // <cjk>
      $6BBB,$8A6B,      // <cjk>
      $6BBC,$9F76,      // <cjk>
      $6BBF,$9361,      // <cjk>
      $6BC0,$9ACA,      // <cjk>
      $6BC5,$8B42,      // <cjk>
      $6BC6,$9F77,      // <cjk>
      $6BCB,$9F78,      // <cjk>
      $6BCD,$95EA,      // <cjk>
      $6BCE,$9688,      // <cjk>
      $6BD2,$93C5,      // <cjk>
      $6BD3,$9F79,      // <cjk>
      $6BD4,$94E4,      // <cjk>
      $6BD8,$94F9,      // <cjk>
      $6BDB,$96D1,      // <cjk>
      $6BDF,$9F7A,      // <cjk>
      $6BEB,$9F7C,      // <cjk>
      $6BEC,$9F7B,      // <cjk>
      $6BEF,$9F7E,      // <cjk>
      $6BF3,$9F7D,      // <cjk>
      $6C08,$9F81,      // <cjk>
      $6C0F,$8E81,      // <cjk>
      $6C11,$96AF,      // <cjk>
      $6C13,$9F82,      // <cjk>
      $6C14,$9F83,      // <cjk>
      $6C17,$8B43,      // <cjk>
      $6C1B,$9F84,      // <cjk>
      $6C23,$9F86,      // <cjk>
      $6C24,$9F85,      // <cjk>
      $6C34,$9085,      // <cjk>
      $6C37,$9558,      // <cjk>
      $6C38,$8969,      // <cjk>
      $6C3E,$94C3,      // <cjk>
      $6C40,$92F3,      // <cjk>
      $6C41,$8F60,      // <cjk>
      $6C42,$8B81,      // <cjk>
      $6C4E,$94C4,      // <cjk>
      $6C50,$8EAC,      // <cjk>
      $6C55,$9F88,      // <cjk>
      $6C57,$8ABE,      // <cjk>
      $6C5A,$8998,      // <cjk>
      $6C5D,$93F0,      // <cjk>
      $6C5E,$9F87,      // <cjk>
      $6C5F,$8D5D,      // <cjk>
      $6C60,$9272,      // <cjk>
      $6C62,$9F89,      // <cjk>
      $6C68,$9F91,      // <cjk>
      $6C6A,$9F8A,      // <cjk>
      $6C70,$91BF,      // <cjk>
      $6C72,$8B82,      // <cjk>
      $6C73,$9F92,      // <cjk>
      $6C7A,$8C88,      // <cjk>
      $6C7D,$8B44,      // <cjk>
      $6C7E,$9F90,      // <cjk>
      $6C81,$9F8E,      // <cjk>
      $6C82,$9F8B,      // <cjk>
      $6C83,$9780,      // <cjk>
      $6C88,$92BE,      // <cjk>
      $6C8C,$93D7,      // <cjk>
      $6C8D,$9F8C,      // <cjk>
      $6C90,$9F94,      // <cjk>
      $6C92,$9F93,      // <cjk>
      $6C93,$8C42,      // <cjk>
      $6C96,$89AB,      // <cjk>
      $6C99,$8DB9,      // <cjk>
      $6C9A,$9F8D,      // <cjk>
      $6C9B,$9F8F,      // <cjk>
      $6CA1,$9676,      // <cjk>
      $6CA2,$91F2,      // <cjk>
      $6CAB,$9697,      // <cjk>
      $6CAE,$9F9C,      // <cjk>
      $6CB1,$9F9D,      // <cjk>
      $6CB3,$89CD,      // <cjk>
      $6CB8,$95A6,      // <cjk>
      $6CB9,$96FB,      // <cjk>
      $6CBA,$9F9F,      // <cjk>
      $6CBB,$8EA1,      // <cjk>
      $6CBC,$8FC0,      // <cjk>
      $6CBD,$9F98,      // <cjk>
      $6CBE,$9F9E,      // <cjk>
      $6CBF,$8988,      // <cjk>
      $6CC1,$8BB5,      // <cjk>
      $6CC4,$9F95,      // <cjk>
      $6CC5,$9F9A,      // <cjk>
      $6CC9,$90F2,      // <cjk>
      $6CCA,$9491,      // <cjk>
      $6CCC,$94E5,      // <cjk>
      $6CD3,$9F97,      // <cjk>
      $6CD5,$9640,      // <cjk>
      $6CD7,$9F99,      // <cjk>
      $6CD9,$9FA2,      // <cjk>
      $6CDB,$9FA0,      // <cjk>
      $6CDD,$9F9B,      // <cjk>
      $6CE1,$9641,      // <cjk>
      $6CE2,$9467,      // <cjk>
      $6CE3,$8B83,      // <cjk>
      $6CE5,$9344,      // <cjk>
      $6CE8,$928D,      // <cjk>
      $6CEA,$9FA3,      // <cjk>
      $6CEF,$9FA1,      // <cjk>
      $6CF0,$91D7,      // <cjk>
      $6CF1,$9F96,      // <cjk>
      $6CF3,$896A,      // <cjk>
      $6D0B,$976D,      // <cjk>
      $6D0C,$9FAE,      // <cjk>
      $6D12,$9FAD,      // <cjk>
      $6D17,$90F4,      // <cjk>
      $6D19,$9FAA,      // <cjk>
      $6D1B,$978C,      // <cjk>
      $6D1E,$93B4,      // <cjk>
      $6D1F,$9FA4,      // <cjk>
      $6D25,$92C3,      // <cjk>
      $6D29,$896B,      // <cjk>
      $6D2A,$8D5E,      // <cjk>
      $6D2B,$9FA7,      // <cjk>
      $6D32,$8F46,      // <cjk>
      $6D33,$9FAC,      // <cjk>
      $6D35,$9FAB,      // <cjk>
      $6D36,$9FA6,      // <cjk>
      $6D38,$9FA9,      // <cjk>
      $6D3B,$8A88,      // <cjk>
      $6D3D,$9FA8,      // <cjk>
      $6D3E,$9468,      // <cjk>
      $6D41,$97AC,      // <cjk>
      $6D44,$8FF2,      // <cjk>
      $6D45,$90F3,      // <cjk>
      $6D59,$9FB4,      // <cjk>
      $6D5A,$9FB2,      // <cjk>
      $6D5C,$956C,      // <cjk>
      $6D63,$9FAF,      // <cjk>
      $6D64,$9FB1,      // <cjk>
      $6D66,$8959,      // <cjk>
      $6D69,$8D5F,      // <cjk>
      $6D6A,$9851,      // <cjk>
      $6D6C,$8A5C,      // <cjk>
      $6D6E,$9582,      // <cjk>
      $6D74,$9781,      // <cjk>
      $6D77,$8A43,      // <cjk>
      $6D78,$905A,      // <cjk>
      $6D79,$9FB3,      // <cjk>
      $6D85,$9FB8,      // <cjk>
      $6D88,$8FC1,      // <cjk>
      $6D8C,$974F,      // <cjk>
      $6D8E,$9FB5,      // <cjk>
      $6D93,$9FB0,      // <cjk>
      $6D95,$9FB6,      // <cjk>
      $6D99,$97DC,      // <cjk>
      $6D9B,$9393,      // <cjk>
      $6D9C,$93C0,      // <cjk>
      $6DAF,$8A55,      // <cjk>
      $6DB2,$8974,      // <cjk>
      $6DB5,$9FBC,      // <cjk>
      $6DB8,$9FBF,      // <cjk>
      $6DBC,$97C1,      // <cjk>
      $6DC0,$9784,      // <cjk>
      $6DC5,$9FC6,      // <cjk>
      $6DC6,$9FC0,      // <cjk>
      $6DC7,$9FBD,      // <cjk>
      $6DCB,$97D2,      // <cjk>
      $6DCC,$9FC3,      // <cjk>
      $6DD1,$8F69,      // <cjk>
      $6DD2,$9FC5,      // <cjk>
      $6DD5,$9FCA,      // <cjk>
      $6DD8,$9391,      // <cjk>
      $6DD9,$9FC8,      // <cjk>
      $6DDE,$9FC2,      // <cjk>
      $6DE1,$9257,      // <cjk>
      $6DE4,$9FC9,      // <cjk>
      $6DE6,$9FBE,      // <cjk>
      $6DE8,$9FC4,      // <cjk>
      $6DEA,$9FCB,      // <cjk>
      $6DEB,$88FA,      // <cjk>
      $6DEC,$9FC1,      // <cjk>
      $6DEE,$9FCC,      // <cjk>
      $6DF3,$8F7E,      // <cjk>
      $6DF5,$95A3,      // <cjk>
      $6DF7,$8DAC,      // <cjk>
      $6DF9,$9FB9,      // <cjk>
      $6DFA,$9FC7,      // <cjk>
      $6DFB,$9359,      // <cjk>
      $6E05,$90B4,      // <cjk>
      $6E07,$8A89,      // <cjk>
      $6E08,$8DCF,      // <cjk>
      $6E09,$8FC2,      // <cjk>
      $6E0A,$9FBB,      // <cjk>
      $6E0B,$8F61,      // <cjk>
      $6E13,$8C6B,      // <cjk>
      $6E15,$9FBA,      // <cjk>
      $6E19,$9FD0,      // <cjk>
      $6E1A,$8F8D,      // <cjk>
      $6E1B,$8CB8,      // <cjk>
      $6E1D,$9FDF,      // <cjk>
      $6E1F,$9FD9,      // <cjk>
      $6E20,$8B94,      // <cjk>
      $6E21,$936E,      // <cjk>
      $6E23,$9FD4,      // <cjk>
      $6E24,$9FDD,      // <cjk>
      $6E25,$88AD,      // <cjk>
      $6E26,$8951,      // <cjk>
      $6E29,$89B7,      // <cjk>
      $6E2B,$9FD6,      // <cjk>
      $6E2C,$91AA,      // <cjk>
      $6E2D,$9FCD,      // <cjk>
      $6E2E,$9FCF,      // <cjk>
      $6E2F,$8D60,      // <cjk>
      $6E38,$9FE0,      // <cjk>
      $6E3A,$9FDB,      // <cjk>
      $6E3E,$9FD3,      // <cjk>
      $6E43,$9FDA,      // <cjk>
      $6E4A,$96A9,      // <cjk>
      $6E4D,$9FD8,      // <cjk>
      $6E4E,$9FDC,      // <cjk>
      $6E56,$8CCE,      // <cjk>
      $6E58,$8FC3,      // <cjk>
      $6E5B,$9258,      // <cjk>
      $6E5F,$9FD2,      // <cjk>
      $6E67,$974E,      // <cjk>
      $6E6B,$9FD5,      // <cjk>
      $6E6E,$9FCE,      // <cjk>
      $6E6F,$9392,      // <cjk>
      $6E72,$9FD1,      // <cjk>
      $6E76,$9FD7,      // <cjk>
      $6E7E,$9870,      // <cjk>
      $6E7F,$8EBC,      // <cjk>
      $6E80,$969E,      // <cjk>
      $6E82,$9FE1,      // <cjk>
      $6E8C,$94AC,      // <cjk>
      $6E8F,$9FED,      // <cjk>
      $6E90,$8CB9,      // <cjk>
      $6E96,$8F80,      // <cjk>
      $6E98,$9FE3,      // <cjk>
      $6E9C,$97AD,      // <cjk>
      $6E9D,$8D61,      // <cjk>
      $6E9F,$9FF0,      // <cjk>
      $6EA2,$88EC,      // <cjk>
      $6EA5,$9FEE,      // <cjk>
      $6EAA,$9FE2,      // <cjk>
      $6EAF,$9FE8,      // <cjk>
      $6EB2,$9FEA,      // <cjk>
      $6EB6,$976E,      // <cjk>
      $6EB7,$9FE5,      // <cjk>
      $6EBA,$934D,      // <cjk>
      $6EBD,$9FE7,      // <cjk>
      $6EC2,$9FEF,      // <cjk>
      $6EC4,$9FE9,      // <cjk>
      $6EC5,$96C5,      // <cjk>
      $6EC9,$9FE4,      // <cjk>
      $6ECB,$8EA0,      // <cjk>
      $6ECC,$9FFC,      // <cjk>
      $6ED1,$8A8A,      // <cjk>
      $6ED3,$9FE6,      // <cjk>
      $6ED4,$9FEB,      // <cjk>
      $6ED5,$9FEC,      // <cjk>
      $6EDD,$91EA,      // <cjk>
      $6EDE,$91D8,      // <cjk>
      $6EEC,$9FF4,      // <cjk>
      $6EEF,$9FFA,      // <cjk>
      $6EF2,$9FF8,      // <cjk>
      $6EF4,$9348,      // <cjk>
      $6EF7,$E042,      // <cjk>
      $6EF8,$9FF5,      // <cjk>
      $6EFE,$9FF6,      // <cjk>
      $6EFF,$9FDE,      // <cjk>
      $6F01,$8B99,      // <cjk>
      $6F02,$9559,      // <cjk>
      $6F06,$8EBD,      // <cjk>
      $6F09,$8D97,      // <cjk>
      $6F0F,$9852,      // <cjk>
      $6F11,$9FF2,      // <cjk>
      $6F13,$E041,      // <cjk>
      $6F14,$8989,      // <cjk>
      $6F15,$9186,      // <cjk>
      $6F20,$9499,      // <cjk>
      $6F22,$8ABF,      // <cjk>
      $6F23,$97F8,      // <cjk>
      $6F2B,$969F,      // <cjk>
      $6F2C,$92D0,      // <cjk>
      $6F31,$9FF9,      // <cjk>
      $6F32,$9FFB,      // <cjk>
      $6F38,$9151,      // <cjk>
      $6F3E,$E040,      // <cjk>
      $6F3F,$9FF7,      // <cjk>
      $6F41,$9FF1,      // <cjk>
      $6F45,$8AC1,      // <cjk>
      $6F54,$8C89,      // <cjk>
      $6F58,$E04E,      // <cjk>
      $6F5B,$E049,      // <cjk>
      $6F5C,$90F6,      // <cjk>
      $6F5F,$8A83,      // <cjk>
      $6F64,$8F81,      // <cjk>
      $6F66,$E052,      // <cjk>
      $6F6D,$E04B,      // <cjk>
      $6F6E,$92AA,      // <cjk>
      $6F6F,$E048,      // <cjk>
      $6F70,$92D7,      // <cjk>
      $6F74,$E06B,      // <cjk>
      $6F78,$E045,      // <cjk>
      $6F7A,$E044,      // <cjk>
      $6F7C,$E04D,      // <cjk>
      $6F80,$E047,      // <cjk>
      $6F81,$E046,      // <cjk>
      $6F82,$E04C,      // <cjk>
      $6F84,$909F,      // <cjk>
      $6F86,$E043,      // <cjk>
      $6F8E,$E04F,      // <cjk>
      $6F91,$E050,      // <cjk>
      $6F97,$8AC0,      // <cjk>
      $6FA1,$E055,      // <cjk>
      $6FA3,$E054,      // <cjk>
      $6FA4,$E056,      // <cjk>
      $6FAA,$E059,      // <cjk>
      $6FB1,$9362,      // <cjk>
      $6FB3,$E053,      // <cjk>
      $6FB9,$E057,      // <cjk>
      $6FC0,$8C83,      // <cjk>
      $6FC1,$91F7,      // <cjk>
      $6FC2,$E051,      // <cjk>
      $6FC3,$945A,      // <cjk>
      $6FC6,$E058,      // <cjk>
      $6FD4,$E05D,      // <cjk>
      $6FD8,$E05E,      // <cjk>
      $6FDB,$E061,      // <cjk>
      $6FDF,$E05A,      // <cjk>
      $6FE0,$8D8A,      // <cjk>
      $6FE1,$9447,      // <cjk>
      $6FE4,$9FB7,      // <cjk>
      $6FEB,$9794,      // <cjk>
      $6FEC,$E05C,      // <cjk>
      $6FEE,$E060,      // <cjk>
      $6FEF,$91F3,      // <cjk>
      $6FF1,$E05F,      // <cjk>
      $6FF3,$E04A,      // <cjk>
      $6FF6,$E889,      // <cjk>
      $6FFA,$E064,      // <cjk>
      $6FFE,$E068,      // <cjk>
      $7001,$E066,      // <cjk>
      $7009,$E062,      // <cjk>
      $700B,$E063,      // <cjk>
      $700F,$E067,      // <cjk>
      $7011,$E065,      // <cjk>
      $7015,$956D,      // <cjk>
      $7018,$E06D,      // <cjk>
      $701A,$E06A,      // <cjk>
      $701B,$E069,      // <cjk>
      $701D,$E06C,      // <cjk>
      $701E,$93D2,      // <cjk>
      $701F,$E06E,      // <cjk>
      $7026,$9295,      // <cjk>
      $7027,$91EB,      // <cjk>
      $702C,$90A3,      // <cjk>
      $7030,$E06F,      // <cjk>
      $7032,$E071,      // <cjk>
      $703E,$E070,      // <cjk>
      $704C,$9FF3,      // <cjk>
      $7051,$E072,      // <cjk>
      $7058,$93E5,      // <cjk>
      $7063,$E073,      // <cjk>
      $706B,$89CE,      // <cjk>
      $706F,$9394,      // <cjk>
      $7070,$8A44,      // <cjk>
      $7078,$8B84,      // <cjk>
      $707C,$8EDC,      // <cjk>
      $707D,$8DD0,      // <cjk>
      $7089,$9846,      // <cjk>
      $708A,$9086,      // <cjk>
      $708E,$898A,      // <cjk>
      $7092,$E075,      // <cjk>
      $7099,$E074,      // <cjk>
      $70AC,$E078,      // <cjk>
      $70AD,$9259,      // <cjk>
      $70AE,$E07B,      // <cjk>
      $70AF,$E076,      // <cjk>
      $70B3,$E07A,      // <cjk>
      $70B8,$E079,      // <cjk>
      $70B9,$935F,      // <cjk>
      $70BA,$88D7,      // <cjk>
      $70C8,$97F3,      // <cjk>
      $70CB,$E07D,      // <cjk>
      $70CF,$8947,      // <cjk>
      $70D9,$E080,      // <cjk>
      $70DD,$E07E,      // <cjk>
      $70DF,$E07C,      // <cjk>
      $70F1,$E077,      // <cjk>
      $70F9,$9642,      // <cjk>
      $70FD,$E082,      // <cjk>
      $7109,$E081,      // <cjk>
      $7114,$898B,      // <cjk>
      $7119,$E084,      // <cjk>
      $711A,$95B0,      // <cjk>
      $711C,$E083,      // <cjk>
      $7121,$96B3,      // <cjk>
      $7126,$8FC5,      // <cjk>
      $7136,$9152,      // <cjk>
      $713C,$8FC4,      // <cjk>
      $7149,$97F9,      // <cjk>
      $714C,$E08A,      // <cjk>
      $714E,$90F7,      // <cjk>
      $7155,$E086,      // <cjk>
      $7156,$E08B,      // <cjk>
      $7159,$898C,      // <cjk>
      $7162,$E089,      // <cjk>
      $7164,$9481,      // <cjk>
      $7165,$E085,      // <cjk>
      $7166,$E088,      // <cjk>
      $7167,$8FC6,      // <cjk>
      $7169,$94CF,      // <cjk>
      $716C,$E08C,      // <cjk>
      $716E,$8ECF,      // <cjk>
      $717D,$90F8,      // <cjk>
      $7184,$E08F,      // <cjk>
      $7188,$E087,      // <cjk>
      $718A,$8C46,      // <cjk>
      $718F,$E08D,      // <cjk>
      $7194,$976F,      // <cjk>
      $7195,$E090,      // <cjk>
      $7199,$EAA4,      // <cjk>
      $719F,$8F6E,      // <cjk>
      $71A8,$E091,      // <cjk>
      $71AC,$E092,      // <cjk>
      $71B1,$944D,      // <cjk>
      $71B9,$E094,      // <cjk>
      $71BE,$E095,      // <cjk>
      $71C3,$9452,      // <cjk>
      $71C8,$9395,      // <cjk>
      $71C9,$E097,      // <cjk>
      $71CE,$E099,      // <cjk>
      $71D0,$97D3,      // <cjk>
      $71D2,$E096,      // <cjk>
      $71D4,$E098,      // <cjk>
      $71D5,$898D,      // <cjk>
      $71D7,$E093,      // <cjk>
      $71DF,$9A7A,      // <cjk>
      $71E0,$E09A,      // <cjk>
      $71E5,$9187,      // <cjk>
      $71E6,$8E57,      // <cjk>
      $71E7,$E09C,      // <cjk>
      $71EC,$E09B,      // <cjk>
      $71ED,$9043,      // <cjk>
      $71EE,$99D7,      // <cjk>
      $71F5,$E09D,      // <cjk>
      $71F9,$E09F,      // <cjk>
      $71FB,$E08E,      // <cjk>
      $71FC,$E09E,      // <cjk>
      $71FF,$E0A0,      // <cjk>
      $7206,$949A,      // <cjk>
      $720D,$E0A1,      // <cjk>
      $7210,$E0A2,      // <cjk>
      $721B,$E0A3,      // <cjk>
      $7228,$E0A4,      // <cjk>
      $722A,$92DC,      // <cjk>
      $722C,$E0A6,      // <cjk>
      $722D,$E0A5,      // <cjk>
      $7230,$E0A7,      // <cjk>
      $7232,$E0A8,      // <cjk>
      $7235,$8EDD,      // <cjk>
      $7236,$9583,      // <cjk>
      $723A,$96EA,      // <cjk>
      $723B,$E0A9,      // <cjk>
      $723C,$E0AA,      // <cjk>
      $723D,$9175,      // <cjk>
      $723E,$8EA2,      // <cjk>
      $723F,$E0AB,      // <cjk>
      $7240,$E0AC,      // <cjk>
      $7246,$E0AD,      // <cjk>
      $7247,$95D0,      // <cjk>
      $7248,$94C5,      // <cjk>
      $724B,$E0AE,      // <cjk>
      $724C,$9476,      // <cjk>
      $7252,$92AB,      // <cjk>
      $7258,$E0AF,      // <cjk>
      $7259,$89E5,      // <cjk>
      $725B,$8B8D,      // <cjk>
      $725D,$96C4,      // <cjk>
      $725F,$96B4,      // <cjk>
      $7261,$89B2,      // <cjk>
      $7262,$9853,      // <cjk>
      $7267,$9671,      // <cjk>
      $7269,$95A8,      // <cjk>
      $7272,$90B5,      // <cjk>
      $7274,$E0B0,      // <cjk>
      $7279,$93C1,      // <cjk>
      $727D,$8CA1,      // <cjk>
      $727E,$E0B1,      // <cjk>
      $7280,$8DD2,      // <cjk>
      $7281,$E0B3,      // <cjk>
      $7282,$E0B2,      // <cjk>
      $7287,$E0B4,      // <cjk>
      $7292,$E0B5,      // <cjk>
      $7296,$E0B6,      // <cjk>
      $72A0,$8B5D,      // <cjk>
      $72A2,$E0B7,      // <cjk>
      $72A7,$E0B8,      // <cjk>
      $72AC,$8CA2,      // <cjk>
      $72AF,$94C6,      // <cjk>
      $72B2,$E0BA,      // <cjk>
      $72B6,$8FF3,      // <cjk>
      $72B9,$E0B9,      // <cjk>
      $72C2,$8BB6,      // <cjk>
      $72C3,$E0BB,      // <cjk>
      $72C4,$E0BD,      // <cjk>
      $72C6,$E0BC,      // <cjk>
      $72CE,$E0BE,      // <cjk>
      $72D0,$8CCF,      // <cjk>
      $72D2,$E0BF,      // <cjk>
      $72D7,$8BE7,      // <cjk>
      $72D9,$915F,      // <cjk>
      $72DB,$8D9D,      // <cjk>
      $72E0,$E0C1,      // <cjk>
      $72E1,$E0C2,      // <cjk>
      $72E2,$E0C0,      // <cjk>
      $72E9,$8EEB,      // <cjk>
      $72EC,$93C6,      // <cjk>
      $72ED,$8BB7,      // <cjk>
      $72F7,$E0C4,      // <cjk>
      $72F8,$924B,      // <cjk>
      $72F9,$E0C3,      // <cjk>
      $72FC,$9854,      // <cjk>
      $72FD,$9482,      // <cjk>
      $730A,$E0C7,      // <cjk>
      $7316,$E0C9,      // <cjk>
      $7317,$E0C6,      // <cjk>
      $731B,$96D2,      // <cjk>
      $731C,$E0C8,      // <cjk>
      $731D,$E0CA,      // <cjk>
      $731F,$97C2,      // <cjk>
      $7325,$E0CE,      // <cjk>
      $7329,$E0CD,      // <cjk>
      $732A,$9296,      // <cjk>
      $732B,$944C,      // <cjk>
      $732E,$8CA3,      // <cjk>
      $732F,$E0CC,      // <cjk>
      $7334,$E0CB,      // <cjk>
      $7336,$9750,      // <cjk>
      $7337,$9751,      // <cjk>
      $733E,$E0CF,      // <cjk>
      $733F,$898E,      // <cjk>
      $7344,$8D96,      // <cjk>
      $7345,$8E82,      // <cjk>
      $734E,$E0D0,      // <cjk>
      $734F,$E0D1,      // <cjk>
      $7357,$E0D3,      // <cjk>
      $7363,$8F62,      // <cjk>
      $7368,$E0D5,      // <cjk>
      $736A,$E0D4,      // <cjk>
      $7370,$E0D6,      // <cjk>
      $7372,$8A6C,      // <cjk>
      $7375,$E0D8,      // <cjk>
      $7378,$E0D7,      // <cjk>
      $737A,$E0DA,      // <cjk>
      $737B,$E0D9,      // <cjk>
      $7384,$8CBA,      // <cjk>
      $7387,$97A6,      // <cjk>
      $7389,$8BCA,      // <cjk>
      $738B,$89A4,      // <cjk>
      $7396,$8BE8,      // <cjk>
      $73A9,$8ADF,      // <cjk>
      $73B2,$97E6,      // <cjk>
      $73B3,$E0DC,      // <cjk>
      $73BB,$E0DE,      // <cjk>
      $73C0,$E0DF,      // <cjk>
      $73C2,$89CF,      // <cjk>
      $73C8,$E0DB,      // <cjk>
      $73CA,$8E58,      // <cjk>
      $73CD,$92BF,      // <cjk>
      $73CE,$E0DD,      // <cjk>
      $73DE,$E0E2,      // <cjk>
      $73E0,$8EEC,      // <cjk>
      $73E5,$E0E0,      // <cjk>
      $73EA,$8C5D,      // <cjk>
      $73ED,$94C7,      // <cjk>
      $73EE,$E0E1,      // <cjk>
      $73F1,$E0FC,      // <cjk>
      $73F8,$E0E7,      // <cjk>
      $73FE,$8CBB,      // <cjk>
      $7403,$8B85,      // <cjk>
      $7405,$E0E4,      // <cjk>
      $7406,$979D,      // <cjk>
      $7409,$97AE,      // <cjk>
      $7422,$91F4,      // <cjk>
      $7425,$E0E6,      // <cjk>
      $7432,$E0E8,      // <cjk>
      $7433,$97D4,      // <cjk>
      $7434,$8BD5,      // <cjk>
      $7435,$94FA,      // <cjk>
      $7436,$9469,      // <cjk>
      $743A,$E0E9,      // <cjk>
      $743F,$E0EB,      // <cjk>
      $7441,$E0EE,      // <cjk>
      $7455,$E0EA,      // <cjk>
      $7459,$E0ED,      // <cjk>
      $745A,$8CE8,      // <cjk>
      $745B,$896C,      // <cjk>
      $745C,$E0EF,      // <cjk>
      $745E,$9090,      // <cjk>
      $745F,$E0EC,      // <cjk>
      $7460,$97DA,      // <cjk>
      $7463,$E0F2,      // <cjk>
      $7464,$EAA2,      // <cjk>
      $7469,$E0F0,      // <cjk>
      $746A,$E0F3,      // <cjk>
      $746F,$E0E5,      // <cjk>
      $7470,$E0F1,      // <cjk>
      $7473,$8DBA,      // <cjk>
      $7476,$E0F4,      // <cjk>
      $747E,$E0F5,      // <cjk>
      $7483,$979E,      // <cjk>
      $748B,$E0F6,      // <cjk>
      $749E,$E0F7,      // <cjk>
      $74A2,$E0E3,      // <cjk>
      $74A7,$E0F8,      // <cjk>
      $74B0,$8AC2,      // <cjk>
      $74BD,$8EA3,      // <cjk>
      $74CA,$E0F9,      // <cjk>
      $74CF,$E0FA,      // <cjk>
      $74D4,$E0FB,      // <cjk>
      $74DC,$895A,      // <cjk>
      $74E0,$E140,      // <cjk>
      $74E2,$955A,      // <cjk>
      $74E3,$E141,      // <cjk>
      $74E6,$8AA2,      // <cjk>
      $74E7,$E142,      // <cjk>
      $74E9,$E143,      // <cjk>
      $74EE,$E144,      // <cjk>
      $74F0,$E146,      // <cjk>
      $74F1,$E147,      // <cjk>
      $74F2,$E145,      // <cjk>
      $74F6,$9572,      // <cjk>
      $74F7,$E149,      // <cjk>
      $74F8,$E148,      // <cjk>
      $7503,$E14B,      // <cjk>
      $7504,$E14A,      // <cjk>
      $7505,$E14C,      // <cjk>
      $750C,$E14D,      // <cjk>
      $750D,$E14F,      // <cjk>
      $750E,$E14E,      // <cjk>
      $7511,$8D99,      // <cjk>
      $7513,$E151,      // <cjk>
      $7515,$E150,      // <cjk>
      $7518,$8AC3,      // <cjk>
      $751A,$9072,      // <cjk>
      $751E,$E152,      // <cjk>
      $751F,$90B6,      // <cjk>
      $7523,$8E59,      // <cjk>
      $7525,$8999,      // <cjk>
      $7526,$E153,      // <cjk>
      $7528,$9770,      // <cjk>
      $752B,$95E1,      // <cjk>
      $752C,$E154,      // <cjk>
      $7530,$9363,      // <cjk>
      $7531,$9752,      // <cjk>
      $7532,$8D62,      // <cjk>
      $7533,$905C,      // <cjk>
      $7537,$926A,      // <cjk>
      $7538,$99B2,      // <cjk>
      $753A,$92AC,      // <cjk>
      $753B,$89E6,      // <cjk>
      $753C,$E155,      // <cjk>
      $7544,$E156,      // <cjk>
      $7549,$E159,      // <cjk>
      $754A,$E158,      // <cjk>
      $754B,$9DC0,      // <cjk>
      $754C,$8A45,      // <cjk>
      $754D,$E157,      // <cjk>
      $754F,$88D8,      // <cjk>
      $7551,$94A8,      // <cjk>
      $7554,$94C8,      // <cjk>
      $7559,$97AF,      // <cjk>
      $755A,$E15C,      // <cjk>
      $755B,$E15A,      // <cjk>
      $755C,$927B,      // <cjk>
      $755D,$90A4,      // <cjk>
      $7560,$94A9,      // <cjk>
      $7562,$954C,      // <cjk>
      $7564,$E15E,      // <cjk>
      $7565,$97AA,      // <cjk>
      $7566,$8C6C,      // <cjk>
      $7567,$E15F,      // <cjk>
      $7569,$E15D,      // <cjk>
      $756A,$94D4,      // <cjk>
      $756B,$E160,      // <cjk>
      $756D,$E161,      // <cjk>
      $7570,$88D9,      // <cjk>
      $7573,$8FF4,      // <cjk>
      $7574,$E166,      // <cjk>
      $7576,$E163,      // <cjk>
      $7577,$93EB,      // <cjk>
      $7578,$E162,      // <cjk>
      $757F,$8B45,      // <cjk>
      $7582,$E169,      // <cjk>
      $7586,$E164,      // <cjk>
      $7587,$E165,      // <cjk>
      $7589,$E168,      // <cjk>
      $758A,$E167,      // <cjk>
      $758B,$9544,      // <cjk>
      $758E,$9161,      // <cjk>
      $758F,$9160,      // <cjk>
      $7591,$8B5E,      // <cjk>
      $7594,$E16A,      // <cjk>
      $759A,$E16B,      // <cjk>
      $759D,$E16C,      // <cjk>
      $75A3,$E16E,      // <cjk>
      $75A5,$E16D,      // <cjk>
      $75AB,$8975,      // <cjk>
      $75B1,$E176,      // <cjk>
      $75B2,$94E6,      // <cjk>
      $75B3,$E170,      // <cjk>
      $75B5,$E172,      // <cjk>
      $75B8,$E174,      // <cjk>
      $75B9,$905D,      // <cjk>
      $75BC,$E175,      // <cjk>
      $75BD,$E173,      // <cjk>
      $75BE,$8EBE,      // <cjk>
      $75C2,$E16F,      // <cjk>
      $75C3,$E171,      // <cjk>
      $75C5,$9561,      // <cjk>
      $75C7,$8FC7,      // <cjk>
      $75CA,$E178,      // <cjk>
      $75CD,$E177,      // <cjk>
      $75D2,$E179,      // <cjk>
      $75D4,$8EA4,      // <cjk>
      $75D5,$8DAD,      // <cjk>
      $75D8,$9397,      // <cjk>
      $75D9,$E17A,      // <cjk>
      $75DB,$92C9,      // <cjk>
      $75DE,$E17C,      // <cjk>
      $75E2,$979F,      // <cjk>
      $75E3,$E17B,      // <cjk>
      $75E9,$9189,      // <cjk>
      $75F0,$E182,      // <cjk>
      $75F2,$E184,      // <cjk>
      $75F3,$E185,      // <cjk>
      $75F4,$9273,      // <cjk>
      $75FA,$E183,      // <cjk>
      $75FC,$E180,      // <cjk>
      $75FE,$E17D,      // <cjk>
      $75FF,$E17E,      // <cjk>
      $7601,$E181,      // <cjk>
      $7609,$E188,      // <cjk>
      $760B,$E186,      // <cjk>
      $760D,$E187,      // <cjk>
      $761F,$E189,      // <cjk>
      $7620,$E18B,      // <cjk>
      $7621,$E18C,      // <cjk>
      $7622,$E18D,      // <cjk>
      $7624,$E18E,      // <cjk>
      $7627,$E18A,      // <cjk>
      $7630,$E190,      // <cjk>
      $7634,$E18F,      // <cjk>
      $763B,$E191,      // <cjk>
      $7642,$97C3,      // <cjk>
      $7646,$E194,      // <cjk>
      $7647,$E192,      // <cjk>
      $7648,$E193,      // <cjk>
      $764C,$8AE0,      // <cjk>
      $7652,$96FC,      // <cjk>
      $7656,$95C8,      // <cjk>
      $7658,$E196,      // <cjk>
      $765C,$E195,      // <cjk>
      $7661,$E197,      // <cjk>
      $7662,$E198,      // <cjk>
      $7667,$E19C,      // <cjk>
      $7668,$E199,      // <cjk>
      $7669,$E19A,      // <cjk>
      $766A,$E19B,      // <cjk>
      $766C,$E19D,      // <cjk>
      $7670,$E19E,      // <cjk>
      $7672,$E19F,      // <cjk>
      $7676,$E1A0,      // <cjk>
      $7678,$E1A1,      // <cjk>
      $767A,$94AD,      // <cjk>
      $767B,$936F,      // <cjk>
      $767C,$E1A2,      // <cjk>
      $767D,$9492,      // <cjk>
      $767E,$9553,      // <cjk>
      $7680,$E1A3,      // <cjk>
      $7683,$E1A4,      // <cjk>
      $7684,$9349,      // <cjk>
      $7686,$8A46,      // <cjk>
      $7687,$8D63,      // <cjk>
      $7688,$E1A5,      // <cjk>
      $768B,$E1A6,      // <cjk>
      $768E,$E1A7,      // <cjk>
      $7690,$8E48,      // <cjk>
      $7693,$E1A9,      // <cjk>
      $7696,$E1A8,      // <cjk>
      $7699,$E1AA,      // <cjk>
      $769A,$E1AB,      // <cjk>
      $76AE,$94E7,      // <cjk>
      $76B0,$E1AC,      // <cjk>
      $76B4,$E1AD,      // <cjk>
      $76B7,$EA89,      // <cjk>
      $76B8,$E1AE,      // <cjk>
      $76B9,$E1AF,      // <cjk>
      $76BA,$E1B0,      // <cjk>
      $76BF,$8E4D,      // <cjk>
      $76C2,$E1B1,      // <cjk>
      $76C3,$9475,      // <cjk>
      $76C6,$967E,      // <cjk>
      $76C8,$896D,      // <cjk>
      $76CA,$8976,      // <cjk>
      $76CD,$E1B2,      // <cjk>
      $76D2,$E1B4,      // <cjk>
      $76D6,$E1B3,      // <cjk>
      $76D7,$9390,      // <cjk>
      $76DB,$90B7,      // <cjk>
      $76DC,$9F58,      // <cjk>
      $76DE,$E1B5,      // <cjk>
      $76DF,$96BF,      // <cjk>
      $76E1,$E1B6,      // <cjk>
      $76E3,$8AC4,      // <cjk>
      $76E4,$94D5,      // <cjk>
      $76E5,$E1B7,      // <cjk>
      $76E7,$E1B8,      // <cjk>
      $76EA,$E1B9,      // <cjk>
      $76EE,$96DA,      // <cjk>
      $76F2,$96D3,      // <cjk>
      $76F4,$92BC,      // <cjk>
      $76F8,$918A,      // <cjk>
      $76FB,$E1BB,      // <cjk>
      $76FE,$8F82,      // <cjk>
      $7701,$8FC8,      // <cjk>
      $7704,$E1BE,      // <cjk>
      $7707,$E1BD,      // <cjk>
      $7708,$E1BC,      // <cjk>
      $7709,$94FB,      // <cjk>
      $770B,$8AC5,      // <cjk>
      $770C,$8CA7,      // <cjk>
      $771B,$E1C4,      // <cjk>
      $771E,$E1C1,      // <cjk>
      $771F,$905E,      // <cjk>
      $7720,$96B0,      // <cjk>
      $7724,$E1C0,      // <cjk>
      $7725,$E1C2,      // <cjk>
      $7726,$E1C3,      // <cjk>
      $7729,$E1BF,      // <cjk>
      $7737,$E1C5,      // <cjk>
      $7738,$E1C6,      // <cjk>
      $773A,$92AD,      // <cjk>
      $773C,$8AE1,      // <cjk>
      $7740,$9285,      // <cjk>
      $7747,$E1C7,      // <cjk>
      $775A,$E1C8,      // <cjk>
      $775B,$E1CB,      // <cjk>
      $7761,$9087,      // <cjk>
      $7763,$93C2,      // <cjk>
      $7765,$E1CC,      // <cjk>
      $7766,$9672,      // <cjk>
      $7768,$E1C9,      // <cjk>
      $776B,$E1CA,      // <cjk>
      $7779,$E1CF,      // <cjk>
      $777E,$E1CE,      // <cjk>
      $777F,$E1CD,      // <cjk>
      $778B,$E1D1,      // <cjk>
      $778E,$E1D0,      // <cjk>
      $7791,$E1D2,      // <cjk>
      $779E,$E1D4,      // <cjk>
      $77A0,$E1D3,      // <cjk>
      $77A5,$95CB,      // <cjk>
      $77AC,$8F75,      // <cjk>
      $77AD,$97C4,      // <cjk>
      $77B0,$E1D5,      // <cjk>
      $77B3,$93B5,      // <cjk>
      $77B6,$E1D6,      // <cjk>
      $77B9,$E1D7,      // <cjk>
      $77BB,$E1DB,      // <cjk>
      $77BC,$E1D9,      // <cjk>
      $77BD,$E1DA,      // <cjk>
      $77BF,$E1D8,      // <cjk>
      $77C7,$E1DC,      // <cjk>
      $77CD,$E1DD,      // <cjk>
      $77D7,$E1DE,      // <cjk>
      $77DA,$E1DF,      // <cjk>
      $77DB,$96B5,      // <cjk>
      $77DC,$E1E0,      // <cjk>
      $77E2,$96EE,      // <cjk>
      $77E3,$E1E1,      // <cjk>
      $77E5,$926D,      // <cjk>
      $77E7,$948A,      // <cjk>
      $77E9,$8BE9,      // <cjk>
      $77ED,$925A,      // <cjk>
      $77EE,$E1E2,      // <cjk>
      $77EF,$8BB8,      // <cjk>
      $77F3,$90CE,      // <cjk>
      $77FC,$E1E3,      // <cjk>
      $7802,$8DBB,      // <cjk>
      $780C,$E1E4,      // <cjk>
      $7812,$E1E5,      // <cjk>
      $7814,$8CA4,      // <cjk>
      $7815,$8DD3,      // <cjk>
      $7820,$E1E7,      // <cjk>
      $7825,$9375,      // <cjk>
      $7826,$8DD4,      // <cjk>
      $7827,$8B6D,      // <cjk>
      $7832,$9643,      // <cjk>
      $7834,$946A,      // <cjk>
      $783A,$9376,      // <cjk>
      $783F,$8D7B,      // <cjk>
      $7845,$E1E9,      // <cjk>
      $785D,$8FC9,      // <cjk>
      $786B,$97B0,      // <cjk>
      $786C,$8D64,      // <cjk>
      $786F,$8CA5,      // <cjk>
      $7872,$94A1,      // <cjk>
      $7874,$E1EB,      // <cjk>
      $787C,$E1ED,      // <cjk>
      $7881,$8CE9,      // <cjk>
      $7886,$E1EC,      // <cjk>
      $7887,$92F4,      // <cjk>
      $788C,$E1EF,      // <cjk>
      $788D,$8A56,      // <cjk>
      $788E,$E1EA,      // <cjk>
      $7891,$94E8,      // <cjk>
      $7893,$894F,      // <cjk>
      $7895,$8DEA,      // <cjk>
      $7897,$9871,      // <cjk>
      $789A,$E1EE,      // <cjk>
      $78A3,$E1F0,      // <cjk>
      $78A7,$95C9,      // <cjk>
      $78A9,$90D7,      // <cjk>
      $78AA,$E1F2,      // <cjk>
      $78AF,$E1F3,      // <cjk>
      $78B5,$E1F1,      // <cjk>
      $78BA,$8A6D,      // <cjk>
      $78BC,$E1F9,      // <cjk>
      $78BE,$E1F8,      // <cjk>
      $78C1,$8EA5,      // <cjk>
      $78C5,$E1FA,      // <cjk>
      $78C6,$E1F5,      // <cjk>
      $78CA,$E1FB,      // <cjk>
      $78CB,$E1F6,      // <cjk>
      $78D0,$94D6,      // <cjk>
      $78D1,$E1F4,      // <cjk>
      $78D4,$E1F7,      // <cjk>
      $78DA,$E241,      // <cjk>
      $78E7,$E240,      // <cjk>
      $78E8,$9681,      // <cjk>
      $78EC,$E1FC,      // <cjk>
      $78EF,$88E9,      // <cjk>
      $78F4,$E243,      // <cjk>
      $78FD,$E242,      // <cjk>
      $7901,$8FCA,      // <cjk>
      $7907,$E244,      // <cjk>
      $790E,$9162,      // <cjk>
      $7911,$E246,      // <cjk>
      $7912,$E245,      // <cjk>
      $7919,$E247,      // <cjk>
      $7926,$E1E6,      // <cjk>
      $792A,$E1E8,      // <cjk>
      $792B,$E249,      // <cjk>
      $792C,$E248,      // <cjk>
      $793A,$8EA6,      // <cjk>
      $793C,$97E7,      // <cjk>
      $793E,$8ED0,      // <cjk>
      $7940,$E24A,      // <cjk>
      $7941,$8C56,      // <cjk>
      $7947,$8B5F,      // <cjk>
      $7948,$8B46,      // <cjk>
      $7949,$8E83,      // <cjk>
      $7950,$9753,      // <cjk>
      $7953,$E250,      // <cjk>
      $7955,$E24F,      // <cjk>
      $7956,$9163,      // <cjk>
      $7957,$E24C,      // <cjk>
      $795A,$E24E,      // <cjk>
      $795D,$8F6A,      // <cjk>
      $795E,$905F,      // <cjk>
      $795F,$E24D,      // <cjk>
      $7960,$E24B,      // <cjk>
      $7962,$9449,      // <cjk>
      $7965,$8FCB,      // <cjk>
      $796D,$8DD5,      // <cjk>
      $7977,$9398,      // <cjk>
      $797A,$E251,      // <cjk>
      $797F,$E252,      // <cjk>
      $7980,$E268,      // <cjk>
      $7981,$8BD6,      // <cjk>
      $7984,$985C,      // <cjk>
      $7985,$9154,      // <cjk>
      $798A,$E253,      // <cjk>
      $798D,$89D0,      // <cjk>
      $798E,$92F5,      // <cjk>
      $798F,$959F,      // <cjk>
      $799D,$E254,      // <cjk>
      $79A6,$8B9A,      // <cjk>
      $79A7,$E255,      // <cjk>
      $79AA,$E257,      // <cjk>
      $79AE,$E258,      // <cjk>
      $79B0,$9448,      // <cjk>
      $79B3,$E259,      // <cjk>
      $79B9,$E25A,      // <cjk>
      $79BD,$8BD7,      // <cjk>
      $79BE,$89D1,      // <cjk>
      $79BF,$93C3,      // <cjk>
      $79C0,$8F47,      // <cjk>
      $79C1,$8E84,      // <cjk>
      $79C9,$E25C,      // <cjk>
      $79CB,$8F48,      // <cjk>
      $79D1,$89C8,      // <cjk>
      $79D2,$9562,      // <cjk>
      $79D5,$E25D,      // <cjk>
      $79D8,$94E9,      // <cjk>
      $79DF,$9164,      // <cjk>
      $79E1,$E260,      // <cjk>
      $79E3,$E261,      // <cjk>
      $79E4,$9489,      // <cjk>
      $79E6,$9060,      // <cjk>
      $79E7,$E25E,      // <cjk>
      $79E9,$9281,      // <cjk>
      $79EC,$E25F,      // <cjk>
      $79F0,$8FCC,      // <cjk>
      $79FB,$88DA,      // <cjk>
      $7A00,$8B48,      // <cjk>
      $7A08,$E262,      // <cjk>
      $7A0B,$92F6,      // <cjk>
      $7A0D,$E263,      // <cjk>
      $7A0E,$90C5,      // <cjk>
      $7A14,$96AB,      // <cjk>
      $7A17,$9542,      // <cjk>
      $7A18,$E264,      // <cjk>
      $7A19,$E265,      // <cjk>
      $7A1A,$9274,      // <cjk>
      $7A1C,$97C5,      // <cjk>
      $7A1F,$E267,      // <cjk>
      $7A20,$E266,      // <cjk>
      $7A2E,$8EED,      // <cjk>
      $7A31,$E269,      // <cjk>
      $7A32,$88EE,      // <cjk>
      $7A37,$E26C,      // <cjk>
      $7A3B,$E26A,      // <cjk>
      $7A3C,$89D2,      // <cjk>
      $7A3D,$8C6D,      // <cjk>
      $7A3E,$E26B,      // <cjk>
      $7A3F,$8D65,      // <cjk>
      $7A40,$8D92,      // <cjk>
      $7A42,$95E4,      // <cjk>
      $7A43,$E26D,      // <cjk>
      $7A46,$9673,      // <cjk>
      $7A49,$E26F,      // <cjk>
      $7A4D,$90CF,      // <cjk>
      $7A4E,$896E,      // <cjk>
      $7A4F,$89B8,      // <cjk>
      $7A50,$88AA,      // <cjk>
      $7A57,$E26E,      // <cjk>
      $7A61,$E270,      // <cjk>
      $7A62,$E271,      // <cjk>
      $7A63,$8FF5,      // <cjk>
      $7A69,$E272,      // <cjk>
      $7A6B,$8A6E,      // <cjk>
      $7A70,$E274,      // <cjk>
      $7A74,$8C8A,      // <cjk>
      $7A76,$8B86,      // <cjk>
      $7A79,$E275,      // <cjk>
      $7A7A,$8BF3,      // <cjk>
      $7A7D,$E276,      // <cjk>
      $7A7F,$90FA,      // <cjk>
      $7A81,$93CB,      // <cjk>
      $7A83,$90DE,      // <cjk>
      $7A84,$8DF3,      // <cjk>
      $7A88,$E277,      // <cjk>
      $7A92,$9282,      // <cjk>
      $7A93,$918B,      // <cjk>
      $7A95,$E279,      // <cjk>
      $7A96,$E27B,      // <cjk>
      $7A97,$E278,      // <cjk>
      $7A98,$E27A,      // <cjk>
      $7A9F,$8C41,      // <cjk>
      $7AA9,$E27C,      // <cjk>
      $7AAA,$8C45,      // <cjk>
      $7AAE,$8B87,      // <cjk>
      $7AAF,$9771,      // <cjk>
      $7AB0,$E27E,      // <cjk>
      $7AB6,$E280,      // <cjk>
      $7ABA,$894D,      // <cjk>
      $7ABF,$E283,      // <cjk>
      $7AC3,$8A96,      // <cjk>
      $7AC4,$E282,      // <cjk>
      $7AC5,$E281,      // <cjk>
      $7AC7,$E285,      // <cjk>
      $7AC8,$E27D,      // <cjk>
      $7ACA,$E286,      // <cjk>
      $7ACB,$97A7,      // <cjk>
      $7ACD,$E287,      // <cjk>
      $7ACF,$E288,      // <cjk>
      $7AD2,$9AF2,      // <cjk>
      $7AD3,$E28A,      // <cjk>
      $7AD5,$E289,      // <cjk>
      $7AD9,$E28B,      // <cjk>
      $7ADA,$E28C,      // <cjk>
      $7ADC,$97B3,      // <cjk>
      $7ADD,$E28D,      // <cjk>
      $7ADF,$E8ED,      // <cjk>
      $7AE0,$8FCD,      // <cjk>
      $7AE1,$E28E,      // <cjk>
      $7AE2,$E28F,      // <cjk>
      $7AE3,$8F76,      // <cjk>
      $7AE5,$93B6,      // <cjk>
      $7AE6,$E290,      // <cjk>
      $7AEA,$9247,      // <cjk>
      $7AED,$E291,      // <cjk>
      $7AF0,$E292,      // <cjk>
      $7AF6,$8BA3,      // <cjk>
      $7AF8,$995E,      // <cjk>
      $7AF9,$927C,      // <cjk>
      $7AFA,$8EB1,      // <cjk>
      $7AFF,$8AC6,      // <cjk>
      $7B02,$E293,      // <cjk>
      $7B04,$E2A0,      // <cjk>
      $7B06,$E296,      // <cjk>
      $7B08,$8B88,      // <cjk>
      $7B0A,$E295,      // <cjk>
      $7B0B,$E2A2,      // <cjk>
      $7B0F,$E294,      // <cjk>
      $7B11,$8FCE,      // <cjk>
      $7B18,$E298,      // <cjk>
      $7B19,$E299,      // <cjk>
      $7B1B,$934A,      // <cjk>
      $7B1E,$E29A,      // <cjk>
      $7B20,$8A7D,      // <cjk>
      $7B25,$9079,      // <cjk>
      $7B26,$9584,      // <cjk>
      $7B28,$E29C,      // <cjk>
      $7B2C,$91E6,      // <cjk>
      $7B33,$E297,      // <cjk>
      $7B35,$E29B,      // <cjk>
      $7B36,$E29D,      // <cjk>
      $7B39,$8DF9,      // <cjk>
      $7B45,$E2A4,      // <cjk>
      $7B46,$954D,      // <cjk>
      $7B48,$94A4,      // <cjk>
      $7B49,$9399,      // <cjk>
      $7B4B,$8BD8,      // <cjk>
      $7B4C,$E2A3,      // <cjk>
      $7B4D,$E2A1,      // <cjk>
      $7B4F,$94B3,      // <cjk>
      $7B50,$E29E,      // <cjk>
      $7B51,$927D,      // <cjk>
      $7B52,$939B,      // <cjk>
      $7B54,$939A,      // <cjk>
      $7B56,$8DF4,      // <cjk>
      $7B5D,$E2B6,      // <cjk>
      $7B65,$E2A6,      // <cjk>
      $7B67,$E2A8,      // <cjk>
      $7B6C,$E2AB,      // <cjk>
      $7B6E,$E2AC,      // <cjk>
      $7B70,$E2A9,      // <cjk>
      $7B71,$E2AA,      // <cjk>
      $7B74,$E2A7,      // <cjk>
      $7B75,$E2A5,      // <cjk>
      $7B7A,$E29F,      // <cjk>
      $7B86,$95CD,      // <cjk>
      $7B87,$89D3,      // <cjk>
      $7B8B,$E2B3,      // <cjk>
      $7B8D,$E2B0,      // <cjk>
      $7B8F,$E2B5,      // <cjk>
      $7B92,$E2B4,      // <cjk>
      $7B94,$9493,      // <cjk>
      $7B95,$96A5,      // <cjk>
      $7B97,$8E5A,      // <cjk>
      $7B98,$E2AE,      // <cjk>
      $7B99,$E2B7,      // <cjk>
      $7B9A,$E2B2,      // <cjk>
      $7B9C,$E2B1,      // <cjk>
      $7B9D,$E2AD,      // <cjk>
      $7B9F,$E2AF,      // <cjk>
      $7BA1,$8AC7,      // <cjk>
      $7BAA,$925C,      // <cjk>
      $7BAD,$90FB,      // <cjk>
      $7BB1,$94A0,      // <cjk>
      $7BB4,$E2BC,      // <cjk>
      $7BB8,$94A2,      // <cjk>
      $7BC0,$90DF,      // <cjk>
      $7BC1,$E2B9,      // <cjk>
      $7BC4,$94CD,      // <cjk>
      $7BC6,$E2BD,      // <cjk>
      $7BC7,$95D1,      // <cjk>
      $7BC9,$927A,      // <cjk>
      $7BCB,$E2B8,      // <cjk>
      $7BCC,$E2BA,      // <cjk>
      $7BCF,$E2BB,      // <cjk>
      $7BDD,$E2BE,      // <cjk>
      $7BE0,$8EC2,      // <cjk>
      $7BE4,$93C4,      // <cjk>
      $7BE5,$E2C3,      // <cjk>
      $7BE6,$E2C2,      // <cjk>
      $7BE9,$E2BF,      // <cjk>
      $7BED,$9855,      // <cjk>
      $7BF3,$E2C8,      // <cjk>
      $7BF6,$E2CC,      // <cjk>
      $7BF7,$E2C9,      // <cjk>
      $7C00,$E2C5,      // <cjk>
      $7C07,$E2C6,      // <cjk>
      $7C0D,$E2CB,      // <cjk>
      $7C11,$E2C0,      // <cjk>
      $7C12,$99D3,      // <cjk>
      $7C13,$E2C7,      // <cjk>
      $7C14,$E2C1,      // <cjk>
      $7C17,$E2CA,      // <cjk>
      $7C1F,$E2D0,      // <cjk>
      $7C21,$8AC8,      // <cjk>
      $7C23,$E2CD,      // <cjk>
      $7C27,$E2CE,      // <cjk>
      $7C2A,$E2CF,      // <cjk>
      $7C2B,$E2D2,      // <cjk>
      $7C37,$E2D1,      // <cjk>
      $7C38,$94F4,      // <cjk>
      $7C3D,$E2D3,      // <cjk>
      $7C3E,$97FA,      // <cjk>
      $7C3F,$95EB,      // <cjk>
      $7C40,$E2D8,      // <cjk>
      $7C43,$E2D5,      // <cjk>
      $7C4C,$E2D4,      // <cjk>
      $7C4D,$90D0,      // <cjk>
      $7C4F,$E2D7,      // <cjk>
      $7C50,$E2D9,      // <cjk>
      $7C54,$E2D6,      // <cjk>
      $7C56,$E2DD,      // <cjk>
      $7C58,$E2DA,      // <cjk>
      $7C5F,$E2DB,      // <cjk>
      $7C60,$E2C4,      // <cjk>
      $7C64,$E2DC,      // <cjk>
      $7C65,$E2DE,      // <cjk>
      $7C6C,$E2DF,      // <cjk>
      $7C73,$95C4,      // <cjk>
      $7C75,$E2E0,      // <cjk>
      $7C7E,$96E0,      // <cjk>
      $7C81,$8BCC,      // <cjk>
      $7C82,$8C48,      // <cjk>
      $7C83,$E2E1,      // <cjk>
      $7C89,$95B2,      // <cjk>
      $7C8B,$9088,      // <cjk>
      $7C8D,$96AE,      // <cjk>
      $7C90,$E2E2,      // <cjk>
      $7C92,$97B1,      // <cjk>
      $7C95,$9494,      // <cjk>
      $7C97,$9165,      // <cjk>
      $7C98,$9453,      // <cjk>
      $7C9B,$8F6C,      // <cjk>
      $7C9F,$88BE,      // <cjk>
      $7CA1,$E2E7,      // <cjk>
      $7CA2,$E2E5,      // <cjk>
      $7CA4,$E2E3,      // <cjk>
      $7CA5,$8A9F,      // <cjk>
      $7CA7,$8FCF,      // <cjk>
      $7CA8,$E2E8,      // <cjk>
      $7CAB,$E2E6,      // <cjk>
      $7CAD,$E2E4,      // <cjk>
      $7CAE,$E2EC,      // <cjk>
      $7CB1,$E2EB,      // <cjk>
      $7CB2,$E2EA,      // <cjk>
      $7CB3,$E2E9,      // <cjk>
      $7CB9,$E2ED,      // <cjk>
      $7CBD,$E2EE,      // <cjk>
      $7CBE,$90B8,      // <cjk>
      $7CC0,$E2EF,      // <cjk>
      $7CC2,$E2F1,      // <cjk>
      $7CC5,$E2F0,      // <cjk>
      $7CCA,$8CD0,      // <cjk>
      $7CCE,$9157,      // <cjk>
      $7CD2,$E2F3,      // <cjk>
      $7CD6,$939C,      // <cjk>
      $7CD8,$E2F2,      // <cjk>
      $7CDC,$E2F4,      // <cjk>
      $7CDE,$95B3,      // <cjk>
      $7CDF,$918C,      // <cjk>
      $7CE0,$8D66,      // <cjk>
      $7CE2,$E2F5,      // <cjk>
      $7CE7,$97C6,      // <cjk>
      $7CEF,$E2F7,      // <cjk>
      $7CF2,$E2F8,      // <cjk>
      $7CF4,$E2F9,      // <cjk>
      $7CF6,$E2FA,      // <cjk>
      $7CF8,$8E85,      // <cjk>
      $7CFA,$E2FB,      // <cjk>
      $7CFB,$8C6E,      // <cjk>
      $7CFE,$8B8A,      // <cjk>
      $7D00,$8B49,      // <cjk>
      $7D02,$E340,      // <cjk>
      $7D04,$96F1,      // <cjk>
      $7D05,$8D67,      // <cjk>
      $7D06,$E2FC,      // <cjk>
      $7D0A,$E343,      // <cjk>
      $7D0B,$96E4,      // <cjk>
      $7D10,$9552,      // <cjk>
      $7D14,$8F83,      // <cjk>
      $7D15,$E342,      // <cjk>
      $7D17,$8ED1,      // <cjk>
      $7D18,$8D68,      // <cjk>
      $7D19,$8E86,      // <cjk>
      $7D1A,$8B89,      // <cjk>
      $7D1B,$95B4,      // <cjk>
      $7D1C,$E341,      // <cjk>
      $7D20,$9166,      // <cjk>
      $7D21,$9661,      // <cjk>
      $7D22,$8DF5,      // <cjk>
      $7D2B,$8E87,      // <cjk>
      $7D2C,$92DB,      // <cjk>
      $7D2E,$E346,      // <cjk>
      $7D2F,$97DD,      // <cjk>
      $7D30,$8DD7,      // <cjk>
      $7D32,$E347,      // <cjk>
      $7D33,$9061,      // <cjk>
      $7D35,$E349,      // <cjk>
      $7D39,$8FD0,      // <cjk>
      $7D3A,$8DAE,      // <cjk>
      $7D3F,$E348,      // <cjk>
      $7D42,$8F49,      // <cjk>
      $7D43,$8CBC,      // <cjk>
      $7D44,$9167,      // <cjk>
      $7D45,$E344,      // <cjk>
      $7D46,$E34A,      // <cjk>
      $7D4B,$E345,      // <cjk>
      $7D4C,$8C6F,      // <cjk>
      $7D4E,$E34D,      // <cjk>
      $7D4F,$E351,      // <cjk>
      $7D50,$8C8B,      // <cjk>
      $7D56,$E34C,      // <cjk>
      $7D5B,$E355,      // <cjk>
      $7D5E,$8D69,      // <cjk>
      $7D61,$978D,      // <cjk>
      $7D62,$88BA,      // <cjk>
      $7D63,$E352,      // <cjk>
      $7D66,$8B8B,      // <cjk>
      $7D68,$E34F,      // <cjk>
      $7D6E,$E350,      // <cjk>
      $7D71,$939D,      // <cjk>
      $7D72,$E34E,      // <cjk>
      $7D73,$E34B,      // <cjk>
      $7D75,$8A47,      // <cjk>
      $7D76,$90E2,      // <cjk>
      $7D79,$8CA6,      // <cjk>
      $7D7D,$E357,      // <cjk>
      $7D89,$E354,      // <cjk>
      $7D8F,$E356,      // <cjk>
      $7D93,$E353,      // <cjk>
      $7D99,$8C70,      // <cjk>
      $7D9A,$91B1,      // <cjk>
      $7D9B,$E358,      // <cjk>
      $7D9C,$918E,      // <cjk>
      $7D9F,$E365,      // <cjk>
      $7DA2,$E361,      // <cjk>
      $7DAB,$E35F,      // <cjk>
      $7DAC,$8EF8,      // <cjk>
      $7DAD,$88DB,      // <cjk>
      $7DAE,$E35A,      // <cjk>
      $7DAF,$E362,      // <cjk>
      $7DB0,$E366,      // <cjk>
      $7DB1,$8D6A,      // <cjk>
      $7DB2,$96D4,      // <cjk>
      $7DB4,$92D4,      // <cjk>
      $7DB5,$E35C,      // <cjk>
      $7DB8,$E364,      // <cjk>
      $7DBA,$E359,      // <cjk>
      $7DBB,$925D,      // <cjk>
      $7DBD,$E35E,      // <cjk>
      $7DBE,$88BB,      // <cjk>
      $7DBF,$96C8,      // <cjk>
      $7DC7,$E35D,      // <cjk>
      $7DCA,$8BD9,      // <cjk>
      $7DCB,$94EA,      // <cjk>
      $7DCF,$918D,      // <cjk>
      $7DD1,$97CE,      // <cjk>
      $7DD2,$8F8F,      // <cjk>
      $7DD5,$E38E,      // <cjk>
      $7DD8,$E367,      // <cjk>
      $7DDA,$90FC,      // <cjk>
      $7DDC,$E363,      // <cjk>
      $7DDD,$E368,      // <cjk>
      $7DDE,$E36A,      // <cjk>
      $7DE0,$92F7,      // <cjk>
      $7DE1,$E36D,      // <cjk>
      $7DE4,$E369,      // <cjk>
      $7DE8,$95D2,      // <cjk>
      $7DE9,$8AC9,      // <cjk>
      $7DEC,$96C9,      // <cjk>
      $7DEF,$88DC,      // <cjk>
      $7DF2,$E36C,      // <cjk>
      $7DF4,$97FB,      // <cjk>
      $7DFB,$E36B,      // <cjk>
      $7E01,$898F,      // <cjk>
      $7E04,$93EA,      // <cjk>
      $7E05,$E36E,      // <cjk>
      $7E09,$E375,      // <cjk>
      $7E0A,$E36F,      // <cjk>
      $7E0B,$E376,      // <cjk>
      $7E12,$E372,      // <cjk>
      $7E1B,$949B,      // <cjk>
      $7E1E,$8EC8,      // <cjk>
      $7E1F,$E374,      // <cjk>
      $7E21,$E371,      // <cjk>
      $7E22,$E377,      // <cjk>
      $7E23,$E370,      // <cjk>
      $7E26,$8F63,      // <cjk>
      $7E2B,$9644,      // <cjk>
      $7E2E,$8F6B,      // <cjk>
      $7E31,$E373,      // <cjk>
      $7E32,$E380,      // <cjk>
      $7E35,$E37B,      // <cjk>
      $7E37,$E37E,      // <cjk>
      $7E39,$E37C,      // <cjk>
      $7E3A,$E381,      // <cjk>
      $7E3B,$E37A,      // <cjk>
      $7E3D,$E360,      // <cjk>
      $7E3E,$90D1,      // <cjk>
      $7E41,$94C9,      // <cjk>
      $7E43,$E37D,      // <cjk>
      $7E46,$E378,      // <cjk>
      $7E4A,$9140,      // <cjk>
      $7E4B,$8C71,      // <cjk>
      $7E4D,$8F4A,      // <cjk>
      $7E54,$9044,      // <cjk>
      $7E55,$9155,      // <cjk>
      $7E56,$E384,      // <cjk>
      $7E59,$E386,      // <cjk>
      $7E5A,$E387,      // <cjk>
      $7E5D,$E383,      // <cjk>
      $7E5E,$E385,      // <cjk>
      $7E66,$E379,      // <cjk>
      $7E67,$E382,      // <cjk>
      $7E69,$E38A,      // <cjk>
      $7E6A,$E389,      // <cjk>
      $7E6D,$969A,      // <cjk>
      $7E70,$8C4A,      // <cjk>
      $7E79,$E388,      // <cjk>
      $7E7B,$E38C,      // <cjk>
      $7E7C,$E38B,      // <cjk>
      $7E7D,$E38F,      // <cjk>
      $7E7F,$E391,      // <cjk>
      $7E83,$E38D,      // <cjk>
      $7E88,$E392,      // <cjk>
      $7E89,$E393,      // <cjk>
      $7E8C,$E394,      // <cjk>
      $7E8E,$E39A,      // <cjk>
      $7E8F,$935A,      // <cjk>
      $7E90,$E396,      // <cjk>
      $7E92,$E395,      // <cjk>
      $7E93,$E397,      // <cjk>
      $7E94,$E398,      // <cjk>
      $7E96,$E399,      // <cjk>
      $7E9B,$E39B,      // <cjk>
      $7E9C,$E39C,      // <cjk>
      $7F36,$8ACA,      // <cjk>
      $7F38,$E39D,      // <cjk>
      $7F3A,$E39E,      // <cjk>
      $7F45,$E39F,      // <cjk>
      $7F4C,$E3A0,      // <cjk>
      $7F4D,$E3A1,      // <cjk>
      $7F4E,$E3A2,      // <cjk>
      $7F50,$E3A3,      // <cjk>
      $7F51,$E3A4,      // <cjk>
      $7F54,$E3A6,      // <cjk>
      $7F55,$E3A5,      // <cjk>
      $7F58,$E3A7,      // <cjk>
      $7F5F,$E3A8,      // <cjk>
      $7F60,$E3A9,      // <cjk>
      $7F67,$E3AC,      // <cjk>
      $7F68,$E3AA,      // <cjk>
      $7F69,$E3AB,      // <cjk>
      $7F6A,$8DDF,      // <cjk>
      $7F6B,$8C72,      // <cjk>
      $7F6E,$9275,      // <cjk>
      $7F70,$94B1,      // <cjk>
      $7F72,$8F90,      // <cjk>
      $7F75,$946C,      // <cjk>
      $7F77,$94EB,      // <cjk>
      $7F78,$E3AD,      // <cjk>
      $7F79,$9CEB,      // <cjk>
      $7F82,$E3AE,      // <cjk>
      $7F83,$E3B0,      // <cjk>
      $7F85,$9785,      // <cjk>
      $7F86,$E3AF,      // <cjk>
      $7F87,$E3B2,      // <cjk>
      $7F88,$E3B1,      // <cjk>
      $7F8A,$9772,      // <cjk>
      $7F8C,$E3B3,      // <cjk>
      $7F8E,$94FC,      // <cjk>
      $7F94,$E3B4,      // <cjk>
      $7F9A,$E3B7,      // <cjk>
      $7F9D,$E3B6,      // <cjk>
      $7F9E,$E3B5,      // <cjk>
      $7FA3,$E3B8,      // <cjk>
      $7FA4,$8C51,      // <cjk>
      $7FA8,$9141,      // <cjk>
      $7FA9,$8B60,      // <cjk>
      $7FAE,$E3BC,      // <cjk>
      $7FAF,$E3B9,      // <cjk>
      $7FB2,$E3BA,      // <cjk>
      $7FB6,$E3BD,      // <cjk>
      $7FB8,$E3BE,      // <cjk>
      $7FB9,$E3BB,      // <cjk>
      $7FBD,$8948,      // <cjk>
      $7FC1,$89A5,      // <cjk>
      $7FC5,$E3C0,      // <cjk>
      $7FC6,$E3C1,      // <cjk>
      $7FCA,$E3C2,      // <cjk>
      $7FCC,$9782,      // <cjk>
      $7FD2,$8F4B,      // <cjk>
      $7FD4,$E3C4,      // <cjk>
      $7FD5,$E3C3,      // <cjk>
      $7FE0,$9089,      // <cjk>
      $7FE1,$E3C5,      // <cjk>
      $7FE6,$E3C6,      // <cjk>
      $7FE9,$E3C7,      // <cjk>
      $7FEB,$8AE3,      // <cjk>
      $7FF0,$8ACB,      // <cjk>
      $7FF3,$E3C8,      // <cjk>
      $7FF9,$E3C9,      // <cjk>
      $7FFB,$967C,      // <cjk>
      $7FFC,$9783,      // <cjk>
      $8000,$9773,      // <cjk>
      $8001,$9856,      // <cjk>
      $8003,$8D6C,      // <cjk>
      $8004,$E3CC,      // <cjk>
      $8005,$8ED2,      // <cjk>
      $8006,$E3CB,      // <cjk>
      $800B,$E3CD,      // <cjk>
      $800C,$8EA7,      // <cjk>
      $8010,$91CF,      // <cjk>
      $8012,$E3CE,      // <cjk>
      $8015,$8D6B,      // <cjk>
      $8017,$96D5,      // <cjk>
      $8018,$E3CF,      // <cjk>
      $8019,$E3D0,      // <cjk>
      $801C,$E3D1,      // <cjk>
      $8021,$E3D2,      // <cjk>
      $8028,$E3D3,      // <cjk>
      $8033,$8EA8,      // <cjk>
      $8036,$96EB,      // <cjk>
      $803B,$E3D5,      // <cjk>
      $803D,$925E,      // <cjk>
      $803F,$E3D4,      // <cjk>
      $8046,$E3D7,      // <cjk>
      $804A,$E3D6,      // <cjk>
      $8052,$E3D8,      // <cjk>
      $8056,$90B9,      // <cjk>
      $8058,$E3D9,      // <cjk>
      $805A,$E3DA,      // <cjk>
      $805E,$95B7,      // <cjk>
      $805F,$E3DB,      // <cjk>
      $8061,$918F,      // <cjk>
      $8062,$E3DC,      // <cjk>
      $8068,$E3DD,      // <cjk>
      $806F,$97FC,      // <cjk>
      $8070,$E3E0,      // <cjk>
      $8072,$E3DF,      // <cjk>
      $8073,$E3DE,      // <cjk>
      $8074,$92AE,      // <cjk>
      $8076,$E3E1,      // <cjk>
      $8077,$9045,      // <cjk>
      $8079,$E3E2,      // <cjk>
      $807D,$E3E3,      // <cjk>
      $807E,$9857,      // <cjk>
      $807F,$E3E4,      // <cjk>
      $8084,$E3E5,      // <cjk>
      $8085,$E3E7,      // <cjk>
      $8086,$E3E6,      // <cjk>
      $8087,$94A3,      // <cjk>
      $8089,$93F7,      // <cjk>
      $808B,$985D,      // <cjk>
      $808C,$94A7,      // <cjk>
      $8093,$E3E9,      // <cjk>
      $8096,$8FD1,      // <cjk>
      $8098,$9549,      // <cjk>
      $809A,$E3EA,      // <cjk>
      $809B,$E3E8,      // <cjk>
      $809D,$8ACC,      // <cjk>
      $80A1,$8CD2,      // <cjk>
      $80A2,$8E88,      // <cjk>
      $80A5,$94EC,      // <cjk>
      $80A9,$8CA8,      // <cjk>
      $80AA,$9662,      // <cjk>
      $80AC,$E3ED,      // <cjk>
      $80AD,$E3EB,      // <cjk>
      $80AF,$8D6D,      // <cjk>
      $80B1,$8D6E,      // <cjk>
      $80B2,$88E7,      // <cjk>
      $80B4,$8DE6,      // <cjk>
      $80BA,$9478,      // <cjk>
      $80C3,$88DD,      // <cjk>
      $80C4,$E3F2,      // <cjk>
      $80C6,$925F,      // <cjk>
      $80CC,$9477,      // <cjk>
      $80CE,$91D9,      // <cjk>
      $80D6,$E3F4,      // <cjk>
      $80D9,$E3F0,      // <cjk>
      $80DA,$E3F3,      // <cjk>
      $80DB,$E3EE,      // <cjk>
      $80DD,$E3F1,      // <cjk>
      $80DE,$9645,      // <cjk>
      $80E1,$8CD3,      // <cjk>
      $80E4,$88FB,      // <cjk>
      $80E5,$E3EF,      // <cjk>
      $80EF,$E3F6,      // <cjk>
      $80F1,$E3F7,      // <cjk>
      $80F4,$93B7,      // <cjk>
      $80F8,$8BB9,      // <cjk>
      $80FC,$E445,      // <cjk>
      $80FD,$945C,      // <cjk>
      $8102,$8E89,      // <cjk>
      $8105,$8BBA,      // <cjk>
      $8106,$90C6,      // <cjk>
      $8107,$9865,      // <cjk>
      $8108,$96AC,      // <cjk>
      $8109,$E3F5,      // <cjk>
      $810A,$90D2,      // <cjk>
      $811A,$8B72,      // <cjk>
      $811B,$E3F8,      // <cjk>
      $8123,$E3FA,      // <cjk>
      $8129,$E3F9,      // <cjk>
      $812F,$E3FB,      // <cjk>
      $8131,$9245,      // <cjk>
      $8133,$945D,      // <cjk>
      $8139,$92AF,      // <cjk>
      $813E,$E442,      // <cjk>
      $8146,$E441,      // <cjk>
      $814B,$E3FC,      // <cjk>
      $814E,$9074,      // <cjk>
      $8150,$9585,      // <cjk>
      $8151,$E444,      // <cjk>
      $8153,$E443,      // <cjk>
      $8154,$8D6F,      // <cjk>
      $8155,$9872,      // <cjk>
      $815F,$E454,      // <cjk>
      $8165,$E448,      // <cjk>
      $8166,$E449,      // <cjk>
      $816B,$8EEE,      // <cjk>
      $816E,$E447,      // <cjk>
      $8170,$8D98,      // <cjk>
      $8171,$E446,      // <cjk>
      $8174,$E44A,      // <cjk>
      $8178,$92B0,      // <cjk>
      $8179,$95A0,      // <cjk>
      $817A,$9142,      // <cjk>
      $817F,$91DA,      // <cjk>
      $8180,$E44E,      // <cjk>
      $8182,$E44F,      // <cjk>
      $8183,$E44B,      // <cjk>
      $8188,$E44C,      // <cjk>
      $818A,$E44D,      // <cjk>
      $818F,$8D70,      // <cjk>
      $8193,$E455,      // <cjk>
      $8195,$E451,      // <cjk>
      $819A,$9586,      // <cjk>
      $819C,$968C,      // <cjk>
      $819D,$9547,      // <cjk>
      $81A0,$E450,      // <cjk>
      $81A3,$E453,      // <cjk>
      $81A4,$E452,      // <cjk>
      $81A8,$9663,      // <cjk>
      $81A9,$E456,      // <cjk>
      $81B0,$E457,      // <cjk>
      $81B3,$9156,      // <cjk>
      $81B5,$E458,      // <cjk>
      $81B8,$E45A,      // <cjk>
      $81BA,$E45E,      // <cjk>
      $81BE,$E459,      // <cjk>
      $81BF,$945E,      // <cjk>
      $81C0,$E45C,      // <cjk>
      $81C2,$E45D,      // <cjk>
      $81C6,$89B0,      // <cjk>
      $81C8,$E464,      // <cjk>
      $81C9,$E45F,      // <cjk>
      $81CD,$E460,      // <cjk>
      $81D1,$E461,      // <cjk>
      $81D3,$919F,      // <cjk>
      $81D8,$E463,      // <cjk>
      $81D9,$E462,      // <cjk>
      $81DA,$E465,      // <cjk>
      $81DF,$E466,      // <cjk>
      $81E0,$E467,      // <cjk>
      $81E3,$9062,      // <cjk>
      $81E5,$89E7,      // <cjk>
      $81E7,$E468,      // <cjk>
      $81E8,$97D5,      // <cjk>
      $81EA,$8EA9,      // <cjk>
      $81ED,$8F4C,      // <cjk>
      $81F3,$8E8A,      // <cjk>
      $81F4,$9276,      // <cjk>
      $81FA,$E469,      // <cjk>
      $81FB,$E46A,      // <cjk>
      $81FC,$8950,      // <cjk>
      $81FE,$E46B,      // <cjk>
      $8201,$E46C,      // <cjk>
      $8202,$E46D,      // <cjk>
      $8205,$E46E,      // <cjk>
      $8207,$E46F,      // <cjk>
      $8208,$8BBB,      // <cjk>
      $8209,$9DA8,      // <cjk>
      $820A,$E470,      // <cjk>
      $820C,$90E3,      // <cjk>
      $820D,$E471,      // <cjk>
      $820E,$8EC9,      // <cjk>
      $8210,$E472,      // <cjk>
      $8212,$98AE,      // <cjk>
      $8216,$E473,      // <cjk>
      $8217,$95DC,      // <cjk>
      $8218,$8ADA,      // <cjk>
      $821B,$9143,      // <cjk>
      $821C,$8F77,      // <cjk>
      $821E,$9591,      // <cjk>
      $821F,$8F4D,      // <cjk>
      $8229,$E474,      // <cjk>
      $822A,$8D71,      // <cjk>
      $822B,$E475,      // <cjk>
      $822C,$94CA,      // <cjk>
      $822E,$E484,      // <cjk>
      $8233,$E477,      // <cjk>
      $8235,$91C7,      // <cjk>
      $8236,$9495,      // <cjk>
      $8237,$8CBD,      // <cjk>
      $8238,$E476,      // <cjk>
      $8239,$9144,      // <cjk>
      $8240,$E478,      // <cjk>
      $8247,$92F8,      // <cjk>
      $8258,$E47A,      // <cjk>
      $8259,$E479,      // <cjk>
      $825A,$E47C,      // <cjk>
      $825D,$E47B,      // <cjk>
      $825F,$E47D,      // <cjk>
      $8262,$E480,      // <cjk>
      $8264,$E47E,      // <cjk>
      $8266,$8ACD,      // <cjk>
      $8268,$E481,      // <cjk>
      $826A,$E482,      // <cjk>
      $826B,$E483,      // <cjk>
      $826E,$8DAF,      // <cjk>
      $826F,$97C7,      // <cjk>
      $8271,$E485,      // <cjk>
      $8272,$9046,      // <cjk>
      $8276,$8990,      // <cjk>
      $8277,$E486,      // <cjk>
      $8278,$E487,      // <cjk>
      $827E,$E488,      // <cjk>
      $828B,$88F0,      // <cjk>
      $828D,$E489,      // <cjk>
      $8292,$E48A,      // <cjk>
      $8299,$9587,      // <cjk>
      $829D,$8EC5,      // <cjk>
      $829F,$E48C,      // <cjk>
      $82A5,$8A48,      // <cjk>
      $82A6,$88B0,      // <cjk>
      $82AB,$E48B,      // <cjk>
      $82AC,$E48E,      // <cjk>
      $82AD,$946D,      // <cjk>
      $82AF,$9063,      // <cjk>
      $82B1,$89D4,      // <cjk>
      $82B3,$9646,      // <cjk>
      $82B8,$8C7C,      // <cjk>
      $82B9,$8BDA,      // <cjk>
      $82BB,$E48D,      // <cjk>
      $82BD,$89E8,      // <cjk>
      $82C5,$8AA1,      // <cjk>
      $82D1,$8991,      // <cjk>
      $82D2,$E492,      // <cjk>
      $82D3,$97E8,      // <cjk>
      $82D4,$91DB,      // <cjk>
      $82D7,$9563,      // <cjk>
      $82D9,$E49E,      // <cjk>
      $82DB,$89D5,      // <cjk>
      $82DC,$E49C,      // <cjk>
      $82DE,$E49A,      // <cjk>
      $82DF,$E491,      // <cjk>
      $82E1,$E48F,      // <cjk>
      $82E3,$E490,      // <cjk>
      $82E5,$8EE1,      // <cjk>
      $82E6,$8BEA,      // <cjk>
      $82E7,$9297,      // <cjk>
      $82EB,$93CF,      // <cjk>
      $82F1,$8970,      // <cjk>
      $82F3,$E494,      // <cjk>
      $82F4,$E493,      // <cjk>
      $82F9,$E499,      // <cjk>
      $82FA,$E495,      // <cjk>
      $82FB,$E498,      // <cjk>
      $8302,$96CE,      // <cjk>
      $8303,$E497,      // <cjk>
      $8304,$89D6,      // <cjk>
      $8305,$8A9D,      // <cjk>
      $8306,$E49B,      // <cjk>
      $8309,$E49D,      // <cjk>
      $830E,$8C73,      // <cjk>
      $8316,$E4A1,      // <cjk>
      $8317,$E4AA,      // <cjk>
      $8318,$E4AB,      // <cjk>
      $831C,$88A9,      // <cjk>
      $8323,$E4B2,      // <cjk>
      $8328,$88EF,      // <cjk>
      $832B,$E4A9,      // <cjk>
      $832F,$E4A8,      // <cjk>
      $8331,$E4A3,      // <cjk>
      $8332,$E4A2,      // <cjk>
      $8334,$E4A0,      // <cjk>
      $8335,$E49F,      // <cjk>
      $8336,$9283,      // <cjk>
      $8338,$91F9,      // <cjk>
      $8339,$E4A5,      // <cjk>
      $8340,$E4A4,      // <cjk>
      $8345,$E4A7,      // <cjk>
      $8349,$9190,      // <cjk>
      $834A,$8C74,      // <cjk>
      $834F,$8960,      // <cjk>
      $8350,$E4A6,      // <cjk>
      $8352,$8D72,      // <cjk>
      $8358,$9191,      // <cjk>
      $8373,$E4B8,      // <cjk>
      $8375,$E4B9,      // <cjk>
      $8377,$89D7,      // <cjk>
      $837B,$89AC,      // <cjk>
      $837C,$E4B6,      // <cjk>
      $8385,$E4AC,      // <cjk>
      $8387,$E4B4,      // <cjk>
      $8389,$E4BB,      // <cjk>
      $838A,$E4B5,      // <cjk>
      $838E,$E4B3,      // <cjk>
      $8393,$E496,      // <cjk>
      $8396,$E4B1,      // <cjk>
      $839A,$E4AD,      // <cjk>
      $839E,$8ACE,      // <cjk>
      $839F,$E4AF,      // <cjk>
      $83A0,$E4BA,      // <cjk>
      $83A2,$E4B0,      // <cjk>
      $83A8,$E4BC,      // <cjk>
      $83AA,$E4AE,      // <cjk>
      $83AB,$949C,      // <cjk>
      $83B1,$9789,      // <cjk>
      $83B5,$E4B7,      // <cjk>
      $83BD,$E4CD,      // <cjk>
      $83C1,$E4C5,      // <cjk>
      $83C5,$909B,      // <cjk>
      $83CA,$8B65,      // <cjk>
      $83CC,$8BDB,      // <cjk>
      $83CE,$E4C0,      // <cjk>
      $83D3,$89D9,      // <cjk>
      $83D6,$8FD2,      // <cjk>
      $83D8,$E4C3,      // <cjk>
      $83DC,$8DD8,      // <cjk>
      $83DF,$9370,      // <cjk>
      $83E0,$E4C8,      // <cjk>
      $83E9,$95EC,      // <cjk>
      $83EB,$E4BF,      // <cjk>
      $83EF,$89D8,      // <cjk>
      $83F0,$8CD4,      // <cjk>
      $83F1,$9548,      // <cjk>
      $83F2,$E4C9,      // <cjk>
      $83F4,$E4BD,      // <cjk>
      $83F7,$E4C6,      // <cjk>
      $83FB,$E4D0,      // <cjk>
      $83FD,$E4C1,      // <cjk>
      $8403,$E4C2,      // <cjk>
      $8404,$93B8,      // <cjk>
      $8407,$E4C7,      // <cjk>
      $840B,$E4C4,      // <cjk>
      $840C,$9647,      // <cjk>
      $840D,$E4CA,      // <cjk>
      $840E,$88DE,      // <cjk>
      $8413,$E4BE,      // <cjk>
      $8420,$E4CC,      // <cjk>
      $8422,$E4CB,      // <cjk>
      $8429,$948B,      // <cjk>
      $842A,$E4D2,      // <cjk>
      $842C,$E4DD,      // <cjk>
      $8431,$8A9E,      // <cjk>
      $8435,$E4E0,      // <cjk>
      $8438,$E4CE,      // <cjk>
      $843C,$E4D3,      // <cjk>
      $843D,$978E,      // <cjk>
      $8446,$E4DC,      // <cjk>
      $8449,$9774,      // <cjk>
      $844E,$97A8,      // <cjk>
      $8457,$9298,      // <cjk>
      $845B,$8A8B,      // <cjk>
      $8461,$9592,      // <cjk>
      $8462,$E4E2,      // <cjk>
      $8463,$939F,      // <cjk>
      $8466,$88AF,      // <cjk>
      $8469,$E4DB,      // <cjk>
      $846B,$E4D7,      // <cjk>
      $846C,$9192,      // <cjk>
      $846D,$E4D1,      // <cjk>
      $846E,$E4D9,      // <cjk>
      $846F,$E4DE,      // <cjk>
      $8471,$944B,      // <cjk>
      $8475,$88A8,      // <cjk>
      $8477,$E4D6,      // <cjk>
      $8479,$E4DF,      // <cjk>
      $847A,$9598,      // <cjk>
      $8482,$E4DA,      // <cjk>
      $8484,$E4D5,      // <cjk>
      $848B,$8FD3,      // <cjk>
      $8490,$8F4E,      // <cjk>
      $8494,$8EAA,      // <cjk>
      $8499,$96D6,      // <cjk>
      $849C,$9566,      // <cjk>
      $849F,$E4E5,      // <cjk>
      $84A1,$E4EE,      // <cjk>
      $84AD,$E4D8,      // <cjk>
      $84B2,$8A97,      // <cjk>
      $84B8,$8FF6,      // <cjk>
      $84B9,$E4E3,      // <cjk>
      $84BB,$E4E8,      // <cjk>
      $84BC,$9193,      // <cjk>
      $84BF,$E4E4,      // <cjk>
      $84C1,$E4EB,      // <cjk>
      $84C4,$927E,      // <cjk>
      $84C6,$E4EC,      // <cjk>
      $84C9,$9775,      // <cjk>
      $84CA,$E4E1,      // <cjk>
      $84CB,$8A57,      // <cjk>
      $84CD,$E4E7,      // <cjk>
      $84D0,$E4EA,      // <cjk>
      $84D1,$96AA,      // <cjk>
      $84D6,$E4ED,      // <cjk>
      $84D9,$E4E6,      // <cjk>
      $84DA,$E4E9,      // <cjk>
      $84EC,$9648,      // <cjk>
      $84EE,$9840,      // <cjk>
      $84F4,$E4F1,      // <cjk>
      $84FC,$E4F8,      // <cjk>
      $84FF,$E4F0,      // <cjk>
      $8500,$8EC1,      // <cjk>
      $8506,$E4CF,      // <cjk>
      $8511,$95CC,      // <cjk>
      $8513,$96A0,      // <cjk>
      $8514,$E4F7,      // <cjk>
      $8515,$E4F6,      // <cjk>
      $8517,$E4F2,      // <cjk>
      $8518,$E4F3,      // <cjk>
      $851A,$8955,      // <cjk>
      $851F,$E4F5,      // <cjk>
      $8521,$E4EF,      // <cjk>
      $8526,$92D3,      // <cjk>
      $852C,$E4F4,      // <cjk>
      $852D,$88FC,      // <cjk>
      $8535,$91A0,      // <cjk>
      $853D,$95C1,      // <cjk>
      $8540,$E4F9,      // <cjk>
      $8541,$E540,      // <cjk>
      $8543,$94D7,      // <cjk>
      $8548,$E4FC,      // <cjk>
      $8549,$8FD4,      // <cjk>
      $854A,$8EC7,      // <cjk>
      $854B,$E542,      // <cjk>
      $854E,$8BBC,      // <cjk>
      $8555,$E543,      // <cjk>
      $8557,$9599,      // <cjk>
      $8558,$E4FB,      // <cjk>
      $855A,$E4D4,      // <cjk>
      $8563,$E4FA,      // <cjk>
      $8568,$986E,      // <cjk>
      $8569,$93A0,      // <cjk>
      $856A,$9593,      // <cjk>
      $856D,$E54A,      // <cjk>
      $8577,$E550,      // <cjk>
      $857E,$E551,      // <cjk>
      $8580,$E544,      // <cjk>
      $8584,$9496,      // <cjk>
      $8587,$E54E,      // <cjk>
      $8588,$E546,      // <cjk>
      $858A,$E548,      // <cjk>
      $8590,$E552,      // <cjk>
      $8591,$E547,      // <cjk>
      $8594,$E54B,      // <cjk>
      $8597,$8992,      // <cjk>
      $8599,$93E3,      // <cjk>
      $859B,$E54C,      // <cjk>
      $859C,$E54F,      // <cjk>
      $85A4,$E545,      // <cjk>
      $85A6,$9145,      // <cjk>
      $85A8,$E549,      // <cjk>
      $85A9,$8E46,      // <cjk>
      $85AA,$9064,      // <cjk>
      $85AB,$8C4F,      // <cjk>
      $85AC,$96F2,      // <cjk>
      $85AE,$96F7,      // <cjk>
      $85AF,$8F92,      // <cjk>
      $85B9,$E556,      // <cjk>
      $85BA,$E554,      // <cjk>
      $85C1,$986D,      // <cjk>
      $85C9,$E553,      // <cjk>
      $85CD,$9795,      // <cjk>
      $85CF,$E555,      // <cjk>
      $85D0,$E557,      // <cjk>
      $85D5,$E558,      // <cjk>
      $85DD,$E559,      // <cjk>
      $85E4,$93A1,      // <cjk>
      $85E5,$E55A,      // <cjk>
      $85E9,$94CB,      // <cjk>
      $85EA,$E54D,      // <cjk>
      $85F7,$8F93,      // <cjk>
      $85F9,$E55C,      // <cjk>
      $85FA,$E561,      // <cjk>
      $85FB,$9194,      // <cjk>
      $85FE,$E560,      // <cjk>
      $8602,$E541,      // <cjk>
      $8606,$E562,      // <cjk>
      $8607,$9168,      // <cjk>
      $860A,$E55D,      // <cjk>
      $860B,$E55F,      // <cjk>
      $8613,$E55E,      // <cjk>
      $8616,$9F50,      // <cjk>
      $8617,$9F41,      // <cjk>
      $861A,$E564,      // <cjk>
      $8622,$E563,      // <cjk>
      $862D,$9796,      // <cjk>
      $862F,$E1BA,      // <cjk>
      $8630,$E565,      // <cjk>
      $863F,$E566,      // <cjk>
      $864D,$E567,      // <cjk>
      $864E,$8CD5,      // <cjk>
      $8650,$8B73,      // <cjk>
      $8654,$E569,      // <cjk>
      $8655,$997C,      // <cjk>
      $865A,$8B95,      // <cjk>
      $865C,$97B8,      // <cjk>
      $865E,$8BF1,      // <cjk>
      $865F,$E56A,      // <cjk>
      $8667,$E56B,      // <cjk>
      $866B,$928E,      // <cjk>
      $8671,$E56C,      // <cjk>
      $8679,$93F8,      // <cjk>
      $867B,$88B8,      // <cjk>
      $868A,$89E1,      // <cjk>
      $868B,$E571,      // <cjk>
      $868C,$E572,      // <cjk>
      $8693,$E56D,      // <cjk>
      $8695,$8E5C,      // <cjk>
      $86A3,$E56E,      // <cjk>
      $86A4,$9461,      // <cjk>
      $86A9,$E56F,      // <cjk>
      $86AA,$E570,      // <cjk>
      $86AB,$E57A,      // <cjk>
      $86AF,$E574,      // <cjk>
      $86B0,$E577,      // <cjk>
      $86B6,$E573,      // <cjk>
      $86C4,$E575,      // <cjk>
      $86C6,$E576,      // <cjk>
      $86C7,$8ED6,      // <cjk>
      $86C9,$E578,      // <cjk>
      $86CB,$9260,      // <cjk>
      $86CD,$8C75,      // <cjk>
      $86CE,$8A61,      // <cjk>
      $86D4,$E57B,      // <cjk>
      $86D9,$8A5E,      // <cjk>
      $86DB,$E581,      // <cjk>
      $86DE,$E57C,      // <cjk>
      $86DF,$E580,      // <cjk>
      $86E4,$94B8,      // <cjk>
      $86E9,$E57D,      // <cjk>
      $86EC,$E57E,      // <cjk>
      $86ED,$9567,      // <cjk>
      $86EE,$94D8,      // <cjk>
      $86EF,$E582,      // <cjk>
      $86F8,$91FB,      // <cjk>
      $86F9,$E58C,      // <cjk>
      $86FB,$E588,      // <cjk>
      $86FE,$89E9,      // <cjk>
      $8700,$E586,      // <cjk>
      $8702,$9649,      // <cjk>
      $8703,$E587,      // <cjk>
      $8706,$E584,      // <cjk>
      $8708,$E585,      // <cjk>
      $8709,$E58A,      // <cjk>
      $870A,$E58D,      // <cjk>
      $870D,$E58B,      // <cjk>
      $8711,$E589,      // <cjk>
      $8712,$E583,      // <cjk>
      $8718,$9277,      // <cjk>
      $871A,$E594,      // <cjk>
      $871C,$96A8,      // <cjk>
      $8725,$E592,      // <cjk>
      $8729,$E593,      // <cjk>
      $8734,$E58E,      // <cjk>
      $8737,$E590,      // <cjk>
      $873B,$E591,      // <cjk>
      $873F,$E58F,      // <cjk>
      $8749,$90E4,      // <cjk>
      $874B,$9858,      // <cjk>
      $874C,$E598,      // <cjk>
      $874E,$E599,      // <cjk>
      $8753,$E59F,      // <cjk>
      $8755,$9049,      // <cjk>
      $8757,$E59B,      // <cjk>
      $8759,$E59E,      // <cjk>
      $875F,$E596,      // <cjk>
      $8760,$E595,      // <cjk>
      $8763,$E5A0,      // <cjk>
      $8766,$89DA,      // <cjk>
      $8768,$E59C,      // <cjk>
      $876A,$E5A1,      // <cjk>
      $876E,$E59D,      // <cjk>
      $8774,$E59A,      // <cjk>
      $8776,$92B1,      // <cjk>
      $8778,$E597,      // <cjk>
      $877F,$9488,      // <cjk>
      $8782,$E5A5,      // <cjk>
      $878D,$975A,      // <cjk>
      $879F,$E5A4,      // <cjk>
      $87A2,$E5A3,      // <cjk>
      $87AB,$E5AC,      // <cjk>
      $87AF,$E5A6,      // <cjk>
      $87B3,$E5AE,      // <cjk>
      $87BA,$9786,      // <cjk>
      $87BB,$E5B1,      // <cjk>
      $87BD,$E5A8,      // <cjk>
      $87C0,$E5A9,      // <cjk>
      $87C4,$E5AD,      // <cjk>
      $87C6,$E5B0,      // <cjk>
      $87C7,$E5AF,      // <cjk>
      $87CB,$E5A7,      // <cjk>
      $87D0,$E5AA,      // <cjk>
      $87D2,$E5BB,      // <cjk>
      $87E0,$E5B4,      // <cjk>
      $87EF,$E5B2,      // <cjk>
      $87F2,$E5B3,      // <cjk>
      $87F6,$E5B8,      // <cjk>
      $87F7,$E5B9,      // <cjk>
      $87F9,$8A49,      // <cjk>
      $87FB,$8B61,      // <cjk>
      $87FE,$E5B7,      // <cjk>
      $8805,$E5A2,      // <cjk>
      $880D,$E5B6,      // <cjk>
      $880E,$E5BA,      // <cjk>
      $880F,$E5B5,      // <cjk>
      $8811,$E5BC,      // <cjk>
      $8815,$E5BE,      // <cjk>
      $8816,$E5BD,      // <cjk>
      $8821,$E5C0,      // <cjk>
      $8822,$E5BF,      // <cjk>
      $8823,$E579,      // <cjk>
      $8827,$E5C4,      // <cjk>
      $8831,$E5C1,      // <cjk>
      $8836,$E5C2,      // <cjk>
      $8839,$E5C3,      // <cjk>
      $883B,$E5C5,      // <cjk>
      $8840,$8C8C,      // <cjk>
      $8842,$E5C7,      // <cjk>
      $8844,$E5C6,      // <cjk>
      $8846,$8F4F,      // <cjk>
      $884C,$8D73,      // <cjk>
      $884D,$9FA5,      // <cjk>
      $8852,$E5C8,      // <cjk>
      $8853,$8F70,      // <cjk>
      $8857,$8A58,      // <cjk>
      $8859,$E5C9,      // <cjk>
      $885B,$8971,      // <cjk>
      $885D,$8FD5,      // <cjk>
      $885E,$E5CA,      // <cjk>
      $8861,$8D74,      // <cjk>
      $8862,$E5CB,      // <cjk>
      $8863,$88DF,      // <cjk>
      $8868,$955C,      // <cjk>
      $886B,$E5CC,      // <cjk>
      $8870,$908A,      // <cjk>
      $8872,$E5D3,      // <cjk>
      $8875,$E5D0,      // <cjk>
      $8877,$928F,      // <cjk>
      $887D,$E5D1,      // <cjk>
      $887E,$E5CE,      // <cjk>
      $887F,$8BDC,      // <cjk>
      $8881,$E5CD,      // <cjk>
      $8882,$E5D4,      // <cjk>
      $8888,$8C55,      // <cjk>
      $888B,$91DC,      // <cjk>
      $888D,$E5DA,      // <cjk>
      $8892,$E5D6,      // <cjk>
      $8896,$91B3,      // <cjk>
      $8897,$E5D5,      // <cjk>
      $8899,$E5D8,      // <cjk>
      $889E,$E5CF,      // <cjk>
      $88A2,$E5D9,      // <cjk>
      $88A4,$E5DB,      // <cjk>
      $88AB,$94ED,      // <cjk>
      $88AE,$E5D7,      // <cjk>
      $88B0,$E5DC,      // <cjk>
      $88B1,$E5DE,      // <cjk>
      $88B4,$8CD1,      // <cjk>
      $88B5,$E5D2,      // <cjk>
      $88B7,$88BF,      // <cjk>
      $88BF,$E5DD,      // <cjk>
      $88C1,$8DD9,      // <cjk>
      $88C2,$97F4,      // <cjk>
      $88C3,$E5DF,      // <cjk>
      $88C4,$E5E0,      // <cjk>
      $88C5,$9195,      // <cjk>
      $88CF,$97A0,      // <cjk>
      $88D4,$E5E1,      // <cjk>
      $88D5,$9754,      // <cjk>
      $88D8,$E5E2,      // <cjk>
      $88D9,$E5E3,      // <cjk>
      $88DC,$95E2,      // <cjk>
      $88DD,$E5E4,      // <cjk>
      $88DF,$8DBE,      // <cjk>
      $88E1,$97A1,      // <cjk>
      $88E8,$E5E9,      // <cjk>
      $88F2,$E5EA,      // <cjk>
      $88F3,$8FD6,      // <cjk>
      $88F4,$E5E8,      // <cjk>
      $88F8,$9787,      // <cjk>
      $88F9,$E5E5,      // <cjk>
      $88FC,$E5E7,      // <cjk>
      $88FD,$90BB,      // <cjk>
      $88FE,$909E,      // <cjk>
      $8902,$E5E6,      // <cjk>
      $8904,$E5EB,      // <cjk>
      $8907,$95A1,      // <cjk>
      $890A,$E5ED,      // <cjk>
      $890C,$E5EC,      // <cjk>
      $8910,$8A8C,      // <cjk>
      $8912,$964A,      // <cjk>
      $8913,$E5EE,      // <cjk>
      $891D,$E5FA,      // <cjk>
      $891E,$E5F0,      // <cjk>
      $8925,$E5F1,      // <cjk>
      $892A,$E5F2,      // <cjk>
      $892B,$E5F3,      // <cjk>
      $8936,$E5F7,      // <cjk>
      $8938,$E5F8,      // <cjk>
      $893B,$E5F6,      // <cjk>
      $8941,$E5F4,      // <cjk>
      $8943,$E5EF,      // <cjk>
      $8944,$E5F5,      // <cjk>
      $894C,$E5F9,      // <cjk>
      $894D,$E8B5,      // <cjk>
      $8956,$89A6,      // <cjk>
      $895E,$E5FC,      // <cjk>
      $895F,$8BDD,      // <cjk>
      $8960,$E5FB,      // <cjk>
      $8964,$E641,      // <cjk>
      $8966,$E640,      // <cjk>
      $896A,$E643,      // <cjk>
      $896D,$E642,      // <cjk>
      $896F,$E644,      // <cjk>
      $8972,$8F50,      // <cjk>
      $8974,$E645,      // <cjk>
      $8977,$E646,      // <cjk>
      $897E,$E647,      // <cjk>
      $897F,$90BC,      // <cjk>
      $8981,$9776,      // <cjk>
      $8983,$E648,      // <cjk>
      $8986,$95A2,      // <cjk>
      $8987,$9465,      // <cjk>
      $8988,$E649,      // <cjk>
      $898A,$E64A,      // <cjk>
      $898B,$8CA9,      // <cjk>
      $898F,$8B4B,      // <cjk>
      $8993,$E64B,      // <cjk>
      $8996,$8E8B,      // <cjk>
      $8997,$9460,      // <cjk>
      $8998,$E64C,      // <cjk>
      $899A,$8A6F,      // <cjk>
      $89A1,$E64D,      // <cjk>
      $89A6,$E64F,      // <cjk>
      $89A7,$9797,      // <cjk>
      $89A9,$E64E,      // <cjk>
      $89AA,$9065,      // <cjk>
      $89AC,$E650,      // <cjk>
      $89AF,$E651,      // <cjk>
      $89B2,$E652,      // <cjk>
      $89B3,$8ACF,      // <cjk>
      $89BA,$E653,      // <cjk>
      $89BD,$E654,      // <cjk>
      $89BF,$E655,      // <cjk>
      $89C0,$E656,      // <cjk>
      $89D2,$8A70,      // <cjk>
      $89DA,$E657,      // <cjk>
      $89DC,$E658,      // <cjk>
      $89DD,$E659,      // <cjk>
      $89E3,$89F0,      // <cjk>
      $89E6,$9047,      // <cjk>
      $89E7,$E65A,      // <cjk>
      $89F8,$E65C,      // <cjk>
      $8A00,$8CBE,      // <cjk>
      $8A02,$92F9,      // <cjk>
      $8A03,$E65D,      // <cjk>
      $8A08,$8C76,      // <cjk>
      $8A0A,$9075,      // <cjk>
      $8A0C,$E660,      // <cjk>
      $8A0E,$93A2,      // <cjk>
      $8A10,$E65F,      // <cjk>
      $8A13,$8C50,      // <cjk>
      $8A16,$E65E,      // <cjk>
      $8A17,$91F5,      // <cjk>
      $8A18,$8B4C,      // <cjk>
      $8A1B,$E661,      // <cjk>
      $8A1D,$E662,      // <cjk>
      $8A1F,$8FD7,      // <cjk>
      $8A23,$8C8D,      // <cjk>
      $8A25,$E663,      // <cjk>
      $8A2A,$964B,      // <cjk>
      $8A2D,$90DD,      // <cjk>
      $8A31,$8B96,      // <cjk>
      $8A33,$96F3,      // <cjk>
      $8A34,$9169,      // <cjk>
      $8A36,$E664,      // <cjk>
      $8A3A,$9066,      // <cjk>
      $8A3B,$9290,      // <cjk>
      $8A3C,$8FD8,      // <cjk>
      $8A41,$E665,      // <cjk>
      $8A46,$E668,      // <cjk>
      $8A48,$E669,      // <cjk>
      $8A50,$8DBC,      // <cjk>
      $8A51,$91C0,      // <cjk>
      $8A52,$E667,      // <cjk>
      $8A54,$8FD9,      // <cjk>
      $8A55,$955D,      // <cjk>
      $8A5B,$E666,      // <cjk>
      $8A5E,$8E8C,      // <cjk>
      $8A60,$8972,      // <cjk>
      $8A62,$E66D,      // <cjk>
      $8A63,$8C77,      // <cjk>
      $8A66,$8E8E,      // <cjk>
      $8A69,$8E8D,      // <cjk>
      $8A6B,$986C,      // <cjk>
      $8A6C,$E66C,      // <cjk>
      $8A6D,$E66B,      // <cjk>
      $8A6E,$9146,      // <cjk>
      $8A70,$8B6C,      // <cjk>
      $8A71,$9862,      // <cjk>
      $8A72,$8A59,      // <cjk>
      $8A73,$8FDA,      // <cjk>
      $8A7C,$E66A,      // <cjk>
      $8A82,$E66F,      // <cjk>
      $8A84,$E670,      // <cjk>
      $8A85,$E66E,      // <cjk>
      $8A87,$8CD6,      // <cjk>
      $8A89,$975F,      // <cjk>
      $8A8C,$8E8F,      // <cjk>
      $8A8D,$9446,      // <cjk>
      $8A91,$E673,      // <cjk>
      $8A93,$90BE,      // <cjk>
      $8A95,$9261,      // <cjk>
      $8A98,$9755,      // <cjk>
      $8A9A,$E676,      // <cjk>
      $8A9E,$8CEA,      // <cjk>
      $8AA0,$90BD,      // <cjk>
      $8AA1,$E672,      // <cjk>
      $8AA3,$E677,      // <cjk>
      $8AA4,$8CEB,      // <cjk>
      $8AA5,$E674,      // <cjk>
      $8AA6,$E675,      // <cjk>
      $8AA8,$E671,      // <cjk>
      $8AAC,$90E0,      // <cjk>
      $8AAD,$93C7,      // <cjk>
      $8AB0,$924E,      // <cjk>
      $8AB2,$89DB,      // <cjk>
      $8AB9,$94EE,      // <cjk>
      $8ABC,$8B62,      // <cjk>
      $8ABF,$92B2,      // <cjk>
      $8AC2,$E67A,      // <cjk>
      $8AC4,$E678,      // <cjk>
      $8AC7,$926B,      // <cjk>
      $8ACB,$90BF,      // <cjk>
      $8ACC,$8AD0,      // <cjk>
      $8ACD,$E679,      // <cjk>
      $8ACF,$907A,      // <cjk>
      $8AD2,$97C8,      // <cjk>
      $8AD6,$985F,      // <cjk>
      $8ADA,$E67B,      // <cjk>
      $8ADB,$E687,      // <cjk>
      $8ADC,$92B3,      // <cjk>
      $8ADE,$E686,      // <cjk>
      $8AE0,$E683,      // <cjk>
      $8AE1,$E68B,      // <cjk>
      $8AE2,$E684,      // <cjk>
      $8AE4,$E680,      // <cjk>
      $8AE6,$92FA,      // <cjk>
      $8AE7,$E67E,      // <cjk>
      $8AEB,$E67C,      // <cjk>
      $8AED,$9740,      // <cjk>
      $8AEE,$8E90,      // <cjk>
      $8AF1,$E681,      // <cjk>
      $8AF3,$E67D,      // <cjk>
      $8AF7,$E685,      // <cjk>
      $8AF8,$8F94,      // <cjk>
      $8AFA,$8CBF,      // <cjk>
      $8AFE,$91F8,      // <cjk>
      $8B00,$9664,      // <cjk>
      $8B01,$8979,      // <cjk>
      $8B02,$88E0,      // <cjk>
      $8B04,$93A3,      // <cjk>
      $8B07,$E689,      // <cjk>
      $8B0C,$E688,      // <cjk>
      $8B0E,$93E4,      // <cjk>
      $8B10,$E68D,      // <cjk>
      $8B14,$E682,      // <cjk>
      $8B16,$E68C,      // <cjk>
      $8B17,$E68E,      // <cjk>
      $8B19,$8CAA,      // <cjk>
      $8B1A,$E68A,      // <cjk>
      $8B1B,$8D75,      // <cjk>
      $8B1D,$8ED3,      // <cjk>
      $8B20,$E68F,      // <cjk>
      $8B21,$9777,      // <cjk>
      $8B26,$E692,      // <cjk>
      $8B28,$E695,      // <cjk>
      $8B2B,$E693,      // <cjk>
      $8B2C,$9554,      // <cjk>
      $8B33,$E690,      // <cjk>
      $8B39,$8BDE,      // <cjk>
      $8B3E,$E694,      // <cjk>
      $8B41,$E696,      // <cjk>
      $8B49,$E69A,      // <cjk>
      $8B4C,$E697,      // <cjk>
      $8B4E,$E699,      // <cjk>
      $8B4F,$E698,      // <cjk>
      $8B56,$E69B,      // <cjk>
      $8B58,$8EAF,      // <cjk>
      $8B5A,$E69D,      // <cjk>
      $8B5B,$E69C,      // <cjk>
      $8B5C,$9588,      // <cjk>
      $8B5F,$E69F,      // <cjk>
      $8B66,$8C78,      // <cjk>
      $8B6B,$E69E,      // <cjk>
      $8B6C,$E6A0,      // <cjk>
      $8B6F,$E6A1,      // <cjk>
      $8B70,$8B63,      // <cjk>
      $8B71,$E3BF,      // <cjk>
      $8B72,$8FF7,      // <cjk>
      $8B74,$E6A2,      // <cjk>
      $8B77,$8CEC,      // <cjk>
      $8B7D,$E6A3,      // <cjk>
      $8B80,$E6A4,      // <cjk>
      $8B83,$8E5D,      // <cjk>
      $8B8A,$9DCC,      // <cjk>
      $8B8C,$E6A5,      // <cjk>
      $8B8E,$E6A6,      // <cjk>
      $8B90,$8F51,      // <cjk>
      $8B92,$E6A7,      // <cjk>
      $8B93,$E6A8,      // <cjk>
      $8B96,$E6A9,      // <cjk>
      $8B99,$E6AA,      // <cjk>
      $8B9A,$E6AB,      // <cjk>
      $8C37,$924A,      // <cjk>
      $8C3A,$E6AC,      // <cjk>
      $8C3F,$E6AE,      // <cjk>
      $8C41,$E6AD,      // <cjk>
      $8C46,$93A4,      // <cjk>
      $8C48,$E6AF,      // <cjk>
      $8C4A,$964C,      // <cjk>
      $8C4C,$E6B0,      // <cjk>
      $8C4E,$E6B1,      // <cjk>
      $8C50,$E6B2,      // <cjk>
      $8C55,$E6B3,      // <cjk>
      $8C5A,$93D8,      // <cjk>
      $8C61,$8FDB,      // <cjk>
      $8C62,$E6B4,      // <cjk>
      $8C6A,$8D8B,      // <cjk>
      $8C6B,$98AC,      // <cjk>
      $8C6C,$E6B5,      // <cjk>
      $8C78,$E6B6,      // <cjk>
      $8C79,$955E,      // <cjk>
      $8C7A,$E6B7,      // <cjk>
      $8C7C,$E6BF,      // <cjk>
      $8C82,$E6B8,      // <cjk>
      $8C85,$E6BA,      // <cjk>
      $8C89,$E6B9,      // <cjk>
      $8C8A,$E6BB,      // <cjk>
      $8C8C,$9665,      // <cjk>
      $8C8D,$E6BC,      // <cjk>
      $8C8E,$E6BD,      // <cjk>
      $8C94,$E6BE,      // <cjk>
      $8C98,$E6C0,      // <cjk>
      $8C9D,$8A4C,      // <cjk>
      $8C9E,$92E5,      // <cjk>
      $8CA0,$9589,      // <cjk>
      $8CA1,$8DE0,      // <cjk>
      $8CA2,$8D76,      // <cjk>
      $8CA7,$956E,      // <cjk>
      $8CA8,$89DD,      // <cjk>
      $8CA9,$94CC,      // <cjk>
      $8CAA,$E6C3,      // <cjk>
      $8CAB,$8AD1,      // <cjk>
      $8CAC,$90D3,      // <cjk>
      $8CAD,$E6C2,      // <cjk>
      $8CAE,$E6C7,      // <cjk>
      $8CAF,$9299,      // <cjk>
      $8CB0,$96E1,      // <cjk>
      $8CB2,$E6C5,      // <cjk>
      $8CB3,$E6C6,      // <cjk>
      $8CB4,$8B4D,      // <cjk>
      $8CB6,$E6C8,      // <cjk>
      $8CB7,$9483,      // <cjk>
      $8CB8,$91DD,      // <cjk>
      $8CBB,$94EF,      // <cjk>
      $8CBC,$935C,      // <cjk>
      $8CBD,$E6C4,      // <cjk>
      $8CBF,$9666,      // <cjk>
      $8CC0,$89EA,      // <cjk>
      $8CC1,$E6CA,      // <cjk>
      $8CC2,$9847,      // <cjk>
      $8CC3,$92C0,      // <cjk>
      $8CC4,$9864,      // <cjk>
      $8CC7,$8E91,      // <cjk>
      $8CC8,$E6C9,      // <cjk>
      $8CCA,$91AF,      // <cjk>
      $8CCD,$E6DA,      // <cjk>
      $8CCE,$9147,      // <cjk>
      $8CD1,$93F6,      // <cjk>
      $8CD3,$956F,      // <cjk>
      $8CDA,$E6CD,      // <cjk>
      $8CDB,$8E5E,      // <cjk>
      $8CDC,$8E92,      // <cjk>
      $8CDE,$8FDC,      // <cjk>
      $8CE0,$9485,      // <cjk>
      $8CE2,$8CAB,      // <cjk>
      $8CE3,$E6CC,      // <cjk>
      $8CE4,$E6CB,      // <cjk>
      $8CE6,$958A,      // <cjk>
      $8CEA,$8EBF,      // <cjk>
      $8CED,$9371,      // <cjk>
      $8CFA,$E6CF,      // <cjk>
      $8CFB,$E6D0,      // <cjk>
      $8CFC,$8D77,      // <cjk>
      $8CFD,$E6CE,      // <cjk>
      $8D04,$E6D1,      // <cjk>
      $8D05,$E6D2,      // <cjk>
      $8D07,$E6D4,      // <cjk>
      $8D08,$91A1,      // <cjk>
      $8D0A,$E6D3,      // <cjk>
      $8D0B,$8AE4,      // <cjk>
      $8D0D,$E6D6,      // <cjk>
      $8D0F,$E6D5,      // <cjk>
      $8D10,$E6D7,      // <cjk>
      $8D13,$E6D9,      // <cjk>
      $8D14,$E6DB,      // <cjk>
      $8D16,$E6DC,      // <cjk>
      $8D64,$90D4,      // <cjk>
      $8D66,$8ECD,      // <cjk>
      $8D67,$E6DD,      // <cjk>
      $8D6B,$8A71,      // <cjk>
      $8D6D,$E6DE,      // <cjk>
      $8D70,$9196,      // <cjk>
      $8D71,$E6DF,      // <cjk>
      $8D73,$E6E0,      // <cjk>
      $8D74,$958B,      // <cjk>
      $8D77,$8B4E,      // <cjk>
      $8D81,$E6E1,      // <cjk>
      $8D85,$92B4,      // <cjk>
      $8D8A,$897A,      // <cjk>
      $8D99,$E6E2,      // <cjk>
      $8DA3,$8EEF,      // <cjk>
      $8DA8,$9096,      // <cjk>
      $8DB3,$91AB,      // <cjk>
      $8DBA,$E6E5,      // <cjk>
      $8DBE,$E6E4,      // <cjk>
      $8DC2,$E6E3,      // <cjk>
      $8DCB,$E6EB,      // <cjk>
      $8DCC,$E6E9,      // <cjk>
      $8DCF,$E6E6,      // <cjk>
      $8DD6,$E6E8,      // <cjk>
      $8DDA,$E6E7,      // <cjk>
      $8DDB,$E6EA,      // <cjk>
      $8DDD,$8B97,      // <cjk>
      $8DDF,$E6EE,      // <cjk>
      $8DE1,$90D5,      // <cjk>
      $8DE3,$E6EF,      // <cjk>
      $8DE8,$8CD7,      // <cjk>
      $8DEA,$E6EC,      // <cjk>
      $8DEB,$E6ED,      // <cjk>
      $8DEF,$9848,      // <cjk>
      $8DF3,$92B5,      // <cjk>
      $8DF5,$9148,      // <cjk>
      $8DFC,$E6F0,      // <cjk>
      $8DFF,$E6F3,      // <cjk>
      $8E08,$E6F1,      // <cjk>
      $8E09,$E6F2,      // <cjk>
      $8E0A,$9778,      // <cjk>
      $8E0F,$93A5,      // <cjk>
      $8E10,$E6F6,      // <cjk>
      $8E1D,$E6F4,      // <cjk>
      $8E1E,$E6F5,      // <cjk>
      $8E1F,$E6F7,      // <cjk>
      $8E2A,$E748,      // <cjk>
      $8E30,$E6FA,      // <cjk>
      $8E34,$E6FB,      // <cjk>
      $8E35,$E6F9,      // <cjk>
      $8E42,$E6F8,      // <cjk>
      $8E44,$92FB,      // <cjk>
      $8E47,$E740,      // <cjk>
      $8E48,$E744,      // <cjk>
      $8E49,$E741,      // <cjk>
      $8E4A,$E6FC,      // <cjk>
      $8E4C,$E742,      // <cjk>
      $8E50,$E743,      // <cjk>
      $8E55,$E74A,      // <cjk>
      $8E59,$E745,      // <cjk>
      $8E5F,$90D6,      // <cjk>
      $8E60,$E747,      // <cjk>
      $8E63,$E749,      // <cjk>
      $8E64,$E746,      // <cjk>
      $8E72,$E74C,      // <cjk>
      $8E74,$8F52,      // <cjk>
      $8E76,$E74B,      // <cjk>
      $8E7C,$E74D,      // <cjk>
      $8E81,$E74E,      // <cjk>
      $8E84,$E751,      // <cjk>
      $8E85,$E750,      // <cjk>
      $8E87,$E74F,      // <cjk>
      $8E8A,$E753,      // <cjk>
      $8E8B,$E752,      // <cjk>
      $8E8D,$96F4,      // <cjk>
      $8E91,$E755,      // <cjk>
      $8E93,$E754,      // <cjk>
      $8E94,$E756,      // <cjk>
      $8E99,$E757,      // <cjk>
      $8EA1,$E759,      // <cjk>
      $8EAA,$E758,      // <cjk>
      $8EAB,$9067,      // <cjk>
      $8EAC,$E75A,      // <cjk>
      $8EAF,$8BEB,      // <cjk>
      $8EB1,$E75D,      // <cjk>
      $8EBE,$E75E,      // <cjk>
      $8EC5,$E75F,      // <cjk>
      $8EC6,$E75C,      // <cjk>
      $8EC8,$E760,      // <cjk>
      $8ECA,$8ED4,      // <cjk>
      $8ECB,$E761,      // <cjk>
      $8ECC,$8B4F,      // <cjk>
      $8ECD,$8C52,      // <cjk>
      $8ED2,$8CAC,      // <cjk>
      $8EDB,$E762,      // <cjk>
      $8EDF,$93EE,      // <cjk>
      $8EE2,$935D,      // <cjk>
      $8EE3,$E763,      // <cjk>
      $8EEB,$E766,      // <cjk>
      $8EF8,$8EB2,      // <cjk>
      $8EFB,$E765,      // <cjk>
      $8EFC,$E764,      // <cjk>
      $8EFD,$8C79,      // <cjk>
      $8EFE,$E767,      // <cjk>
      $8F03,$8A72,      // <cjk>
      $8F05,$E769,      // <cjk>
      $8F09,$8DDA,      // <cjk>
      $8F0A,$E768,      // <cjk>
      $8F0C,$E771,      // <cjk>
      $8F12,$E76B,      // <cjk>
      $8F13,$E76D,      // <cjk>
      $8F14,$95E3,      // <cjk>
      $8F15,$E76A,      // <cjk>
      $8F19,$E76C,      // <cjk>
      $8F1B,$E770,      // <cjk>
      $8F1C,$E76E,      // <cjk>
      $8F1D,$8B50,      // <cjk>
      $8F1F,$E76F,      // <cjk>
      $8F26,$E772,      // <cjk>
      $8F29,$9479,      // <cjk>
      $8F2A,$97D6,      // <cjk>
      $8F2F,$8F53,      // <cjk>
      $8F33,$E773,      // <cjk>
      $8F38,$9741,      // <cjk>
      $8F39,$E775,      // <cjk>
      $8F3B,$E774,      // <cjk>
      $8F3E,$E778,      // <cjk>
      $8F3F,$9760,      // <cjk>
      $8F42,$E777,      // <cjk>
      $8F44,$8A8D,      // <cjk>
      $8F45,$E776,      // <cjk>
      $8F46,$E77B,      // <cjk>
      $8F49,$E77A,      // <cjk>
      $8F4C,$E779,      // <cjk>
      $8F4D,$9351,      // <cjk>
      $8F4E,$E77C,      // <cjk>
      $8F57,$E77D,      // <cjk>
      $8F5C,$E77E,      // <cjk>
      $8F5F,$8D8C,      // <cjk>
      $8F61,$8C44,      // <cjk>
      $8F62,$E780,      // <cjk>
      $8F63,$E781,      // <cjk>
      $8F64,$E782,      // <cjk>
      $8F9B,$9068,      // <cjk>
      $8F9C,$E783,      // <cjk>
      $8F9E,$8EAB,      // <cjk>
      $8F9F,$E784,      // <cjk>
      $8FA3,$E785,      // <cjk>
      $8FA7,$999F,      // <cjk>
      $8FA8,$999E,      // <cjk>
      $8FAD,$E786,      // <cjk>
      $8FAE,$E390,      // <cjk>
      $8FAF,$E787,      // <cjk>
      $8FB0,$9243,      // <cjk>
      $8FB1,$904A,      // <cjk>
      $8FB2,$945F,      // <cjk>
      $8FB7,$E788,      // <cjk>
      $8FBA,$95D3,      // <cjk>
      $8FBB,$92D2,      // <cjk>
      $8FBC,$8D9E,      // <cjk>
      $8FBF,$9248,      // <cjk>
      $8FC2,$8949,      // <cjk>
      $8FC4,$9698,      // <cjk>
      $8FC5,$9076,      // <cjk>
      $8FCE,$8C7D,      // <cjk>
      $8FD1,$8BDF,      // <cjk>
      $8FD4,$95D4,      // <cjk>
      $8FDA,$E789,      // <cjk>
      $8FE2,$E78B,      // <cjk>
      $8FE5,$E78A,      // <cjk>
      $8FE6,$89DE,      // <cjk>
      $8FE9,$93F4,      // <cjk>
      $8FEA,$E78C,      // <cjk>
      $8FEB,$9497,      // <cjk>
      $8FED,$9352,      // <cjk>
      $8FEF,$E78D,      // <cjk>
      $8FF0,$8F71,      // <cjk>
      $8FF4,$E78F,      // <cjk>
      $8FF7,$96C0,      // <cjk>
      $8FF8,$E79E,      // <cjk>
      $8FF9,$E791,      // <cjk>
      $8FFA,$E792,      // <cjk>
      $8FFD,$92C7,      // <cjk>
      $9000,$91DE,      // <cjk>
      $9001,$9197,      // <cjk>
      $9003,$93A6,      // <cjk>
      $9005,$E790,      // <cjk>
      $9006,$8B74,      // <cjk>
      $900B,$E799,      // <cjk>
      $900D,$E796,      // <cjk>
      $900E,$E7A3,      // <cjk>
      $900F,$93A7,      // <cjk>
      $9010,$9280,      // <cjk>
      $9011,$E793,      // <cjk>
      $9013,$92FC,      // <cjk>
      $9014,$9372,      // <cjk>
      $9015,$E794,      // <cjk>
      $9016,$E798,      // <cjk>
      $9017,$9080,      // <cjk>
      $9019,$9487,      // <cjk>
      $901A,$92CA,      // <cjk>
      $901D,$90C0,      // <cjk>
      $901E,$E797,      // <cjk>
      $901F,$91AC,      // <cjk>
      $9020,$91A2,      // <cjk>
      $9021,$E795,      // <cjk>
      $9022,$88A7,      // <cjk>
      $9023,$9841,      // <cjk>
      $9027,$E79A,      // <cjk>
      $902E,$91DF,      // <cjk>
      $9031,$8F54,      // <cjk>
      $9032,$9069,      // <cjk>
      $9035,$E79C,      // <cjk>
      $9036,$E79B,      // <cjk>
      $9038,$88ED,      // <cjk>
      $9039,$E79D,      // <cjk>
      $903C,$954E,      // <cjk>
      $903E,$E7A5,      // <cjk>
      $9041,$93D9,      // <cjk>
      $9042,$908B,      // <cjk>
      $9045,$9278,      // <cjk>
      $9047,$8BF6,      // <cjk>
      $9049,$E7A4,      // <cjk>
      $904A,$9756,      // <cjk>
      $904B,$895E,      // <cjk>
      $904D,$95D5,      // <cjk>
      $904E,$89DF,      // <cjk>
      $904F,$E79F,      // <cjk>
      $9050,$E7A0,      // <cjk>
      $9051,$E7A1,      // <cjk>
      $9052,$E7A2,      // <cjk>
      $9053,$93B9,      // <cjk>
      $9054,$9242,      // <cjk>
      $9055,$88E1,      // <cjk>
      $9056,$E7A6,      // <cjk>
      $9058,$E7A7,      // <cjk>
      $9059,$EAA1,      // <cjk>
      $905C,$91BB,      // <cjk>
      $905E,$E7A8,      // <cjk>
      $9060,$8993,      // <cjk>
      $9061,$916B,      // <cjk>
      $9063,$8CAD,      // <cjk>
      $9065,$9779,      // <cjk>
      $9068,$E7A9,      // <cjk>
      $9069,$934B,      // <cjk>
      $906D,$9198,      // <cjk>
      $906E,$8ED5,      // <cjk>
      $906F,$E7AA,      // <cjk>
      $9072,$E7AD,      // <cjk>
      $9075,$8F85,      // <cjk>
      $9076,$E7AB,      // <cjk>
      $9077,$914A,      // <cjk>
      $9078,$9149,      // <cjk>
      $907A,$88E2,      // <cjk>
      $907C,$97C9,      // <cjk>
      $907D,$E7AF,      // <cjk>
      $907F,$94F0,      // <cjk>
      $9080,$E7B1,      // <cjk>
      $9081,$E7B0,      // <cjk>
      $9082,$E7AE,      // <cjk>
      $9083,$E284,      // <cjk>
      $9084,$8AD2,      // <cjk>
      $9087,$E78E,      // <cjk>
      $9089,$E7B3,      // <cjk>
      $908A,$E7B2,      // <cjk>
      $908F,$E7B4,      // <cjk>
      $9091,$9757,      // <cjk>
      $90A3,$93DF,      // <cjk>
      $90A6,$964D,      // <cjk>
      $90A8,$E7B5,      // <cjk>
      $90AA,$8ED7,      // <cjk>
      $90AF,$E7B6,      // <cjk>
      $90B1,$E7B7,      // <cjk>
      $90B5,$E7B8,      // <cjk>
      $90B8,$9340,      // <cjk>
      $90C1,$88E8,      // <cjk>
      $90CA,$8D78,      // <cjk>
      $90CE,$9859,      // <cjk>
      $90DB,$E7BC,      // <cjk>
      $90E1,$8C53,      // <cjk>
      $90E2,$E7B9,      // <cjk>
      $90E4,$E7BA,      // <cjk>
      $90E8,$9594,      // <cjk>
      $90ED,$8A73,      // <cjk>
      $90F5,$9758,      // <cjk>
      $90F7,$8BBD,      // <cjk>
      $90FD,$9373,      // <cjk>
      $9102,$E7BD,      // <cjk>
      $9112,$E7BE,      // <cjk>
      $9119,$E7BF,      // <cjk>
      $912D,$9341,      // <cjk>
      $9130,$E7C1,      // <cjk>
      $9132,$E7C0,      // <cjk>
      $9149,$93D1,      // <cjk>
      $914A,$E7C2,      // <cjk>
      $914B,$8F55,      // <cjk>
      $914C,$8EDE,      // <cjk>
      $914D,$947A,      // <cjk>
      $914E,$9291,      // <cjk>
      $9152,$8EF0,      // <cjk>
      $9154,$908C,      // <cjk>
      $9156,$E7C3,      // <cjk>
      $9158,$E7C4,      // <cjk>
      $9162,$907C,      // <cjk>
      $9163,$E7C5,      // <cjk>
      $9165,$E7C6,      // <cjk>
      $9169,$E7C7,      // <cjk>
      $916A,$978F,      // <cjk>
      $916C,$8F56,      // <cjk>
      $9172,$E7C9,      // <cjk>
      $9173,$E7C8,      // <cjk>
      $9175,$8D79,      // <cjk>
      $9177,$8D93,      // <cjk>
      $9178,$8E5F,      // <cjk>
      $9182,$E7CC,      // <cjk>
      $9187,$8F86,      // <cjk>
      $9189,$E7CB,      // <cjk>
      $918B,$E7CA,      // <cjk>
      $918D,$91E7,      // <cjk>
      $9190,$8CED,      // <cjk>
      $9192,$90C1,      // <cjk>
      $9197,$94AE,      // <cjk>
      $919C,$8F58,      // <cjk>
      $91A2,$E7CD,      // <cjk>
      $91A4,$8FDD,      // <cjk>
      $91AA,$E7D0,      // <cjk>
      $91AB,$E7CE,      // <cjk>
      $91AF,$E7CF,      // <cjk>
      $91B4,$E7D2,      // <cjk>
      $91B5,$E7D1,      // <cjk>
      $91B8,$8FF8,      // <cjk>
      $91BA,$E7D3,      // <cjk>
      $91C0,$E7D4,      // <cjk>
      $91C1,$E7D5,      // <cjk>
      $91C6,$94CE,      // <cjk>
      $91C7,$8DD1,      // <cjk>
      $91C8,$8EDF,      // <cjk>
      $91C9,$E7D6,      // <cjk>
      $91CB,$E7D7,      // <cjk>
      $91CC,$97A2,      // <cjk>
      $91CD,$8F64,      // <cjk>
      $91CE,$96EC,      // <cjk>
      $91CF,$97CA,      // <cjk>
      $91D0,$E7D8,      // <cjk>
      $91D1,$8BE0,      // <cjk>
      $91D6,$E7D9,      // <cjk>
      $91D8,$9342,      // <cjk>
      $91DB,$E7DC,      // <cjk>
      $91DC,$8A98,      // <cjk>
      $91DD,$906A,      // <cjk>
      $91DF,$E7DA,      // <cjk>
      $91E1,$E7DB,      // <cjk>
      $91E3,$92DE,      // <cjk>
      $91E6,$9674,      // <cjk>
      $91E7,$8BFA,      // <cjk>
      $91F5,$E7DE,      // <cjk>
      $91F6,$E7DF,      // <cjk>
      $91FC,$E7DD,      // <cjk>
      $91FF,$E7E1,      // <cjk>
      $920D,$93DD,      // <cjk>
      $920E,$8A62,      // <cjk>
      $9211,$E7E5,      // <cjk>
      $9214,$E7E2,      // <cjk>
      $9215,$E7E4,      // <cjk>
      $921E,$E7E0,      // <cjk>
      $9229,$E86E,      // <cjk>
      $922C,$E7E3,      // <cjk>
      $9234,$97E9,      // <cjk>
      $9237,$8CD8,      // <cjk>
      $923F,$E7ED,      // <cjk>
      $9244,$9353,      // <cjk>
      $9245,$E7E8,      // <cjk>
      $9248,$E7EB,      // <cjk>
      $9249,$E7E9,      // <cjk>
      $924B,$E7EE,      // <cjk>
      $9250,$E7EF,      // <cjk>
      $9257,$E7E7,      // <cjk>
      $925A,$E7F4,      // <cjk>
      $925B,$8994,      // <cjk>
      $925E,$E7E6,      // <cjk>
      $9262,$94AB,      // <cjk>
      $9264,$E7EA,      // <cjk>
      $9266,$8FDE,      // <cjk>
      $9271,$8D7A,      // <cjk>
      $927E,$9667,      // <cjk>
      $9280,$8BE2,      // <cjk>
      $9283,$8F65,      // <cjk>
      $9285,$93BA,      // <cjk>
      $9291,$914C,      // <cjk>
      $9293,$E7F2,      // <cjk>
      $9295,$E7EC,      // <cjk>
      $9296,$E7F1,      // <cjk>
      $9298,$96C1,      // <cjk>
      $929A,$92B6,      // <cjk>
      $929B,$E7F3,      // <cjk>
      $929C,$E7F0,      // <cjk>
      $92AD,$914B,      // <cjk>
      $92B7,$E7F7,      // <cjk>
      $92B9,$E7F6,      // <cjk>
      $92CF,$E7F5,      // <cjk>
      $92D2,$964E,      // <cjk>
      $92E4,$8F9B,      // <cjk>
      $92E9,$E7F8,      // <cjk>
      $92EA,$95DD,      // <cjk>
      $92ED,$8973,      // <cjk>
      $92F2,$9565,      // <cjk>
      $92F3,$9292,      // <cjk>
      $92F8,$8B98,      // <cjk>
      $92FA,$E7FA,      // <cjk>
      $92FC,$8D7C,      // <cjk>
      $9306,$8E4B,      // <cjk>
      $930F,$E7F9,      // <cjk>
      $9310,$908D,      // <cjk>
      $9318,$908E,      // <cjk>
      $9319,$E840,      // <cjk>
      $931A,$E842,      // <cjk>
      $9320,$8FF9,      // <cjk>
      $9322,$E841,      // <cjk>
      $9323,$E843,      // <cjk>
      $9326,$8BD1,      // <cjk>
      $9328,$9564,      // <cjk>
      $932B,$8EE0,      // <cjk>
      $932C,$9842,      // <cjk>
      $932E,$E7FC,      // <cjk>
      $932F,$8DF6,      // <cjk>
      $9332,$985E,      // <cjk>
      $9335,$E845,      // <cjk>
      $933A,$E844,      // <cjk>
      $933B,$E846,      // <cjk>
      $9344,$E7FB,      // <cjk>
      $934B,$93E7,      // <cjk>
      $934D,$9374,      // <cjk>
      $9354,$92D5,      // <cjk>
      $9356,$E84B,      // <cjk>
      $935B,$9262,      // <cjk>
      $935C,$E847,      // <cjk>
      $9360,$E848,      // <cjk>
      $936C,$8C4C,      // <cjk>
      $936E,$E84A,      // <cjk>
      $9375,$8CAE,      // <cjk>
      $937C,$E849,      // <cjk>
      $937E,$8FDF,      // <cjk>
      $938C,$8A99,      // <cjk>
      $9394,$E84F,      // <cjk>
      $9396,$8DBD,      // <cjk>
      $9397,$9199,      // <cjk>
      $939A,$92C8,      // <cjk>
      $93A7,$8A5A,      // <cjk>
      $93AC,$E84D,      // <cjk>
      $93AD,$E84E,      // <cjk>
      $93AE,$92C1,      // <cjk>
      $93B0,$E84C,      // <cjk>
      $93B9,$E850,      // <cjk>
      $93C3,$E856,      // <cjk>
      $93C8,$E859,      // <cjk>
      $93D0,$E858,      // <cjk>
      $93D1,$934C,      // <cjk>
      $93D6,$E851,      // <cjk>
      $93D7,$E852,      // <cjk>
      $93D8,$E855,      // <cjk>
      $93DD,$E857,      // <cjk>
      $93E1,$8BBE,      // <cjk>
      $93E4,$E85A,      // <cjk>
      $93E5,$E854,      // <cjk>
      $93E8,$E853,      // <cjk>
      $9403,$E85E,      // <cjk>
      $9407,$E85F,      // <cjk>
      $9410,$E860,      // <cjk>
      $9413,$E85D,      // <cjk>
      $9414,$E85C,      // <cjk>
      $9418,$8FE0,      // <cjk>
      $9419,$93A8,      // <cjk>
      $9421,$E864,      // <cjk>
      $942B,$E862,      // <cjk>
      $9435,$E863,      // <cjk>
      $9436,$E861,      // <cjk>
      $9438,$91F6,      // <cjk>
      $943A,$E865,      // <cjk>
      $9441,$E866,      // <cjk>
      $9444,$E868,      // <cjk>
      $9451,$8AD3,      // <cjk>
      $9452,$E867,      // <cjk>
      $9453,$96F8,      // <cjk>
      $945A,$E873,      // <cjk>
      $945B,$E869,      // <cjk>
      $945E,$E86C,      // <cjk>
      $9460,$E86A,      // <cjk>
      $9462,$E86B,      // <cjk>
      $946A,$E86D,      // <cjk>
      $9470,$E86F,      // <cjk>
      $9475,$E870,      // <cjk>
      $9477,$E871,      // <cjk>
      $947C,$E874,      // <cjk>
      $947D,$E872,      // <cjk>
      $947E,$E875,      // <cjk>
      $947F,$E877,      // <cjk>
      $9481,$E876,      // <cjk>
      $9577,$92B7,      // <cjk>
      $9580,$96E5,      // <cjk>
      $9582,$E878,      // <cjk>
      $9583,$914D,      // <cjk>
      $9587,$E879,      // <cjk>
      $9589,$95C2,      // <cjk>
      $958A,$E87A,      // <cjk>
      $958B,$8A4A,      // <cjk>
      $9591,$8AD5,      // <cjk>
      $9593,$8AD4,      // <cjk>
      $9594,$E87B,      // <cjk>
      $9596,$E87C,      // <cjk>
      $9598,$E87D,      // <cjk>
      $9599,$E87E,      // <cjk>
      $95A0,$E880,      // <cjk>
      $95A2,$8AD6,      // <cjk>
      $95A3,$8A74,      // <cjk>
      $95A4,$8D7D,      // <cjk>
      $95A5,$94B4,      // <cjk>
      $95A7,$E882,      // <cjk>
      $95A8,$E881,      // <cjk>
      $95AD,$E883,      // <cjk>
      $95B2,$897B,      // <cjk>
      $95B9,$E886,      // <cjk>
      $95BB,$E885,      // <cjk>
      $95BC,$E884,      // <cjk>
      $95BE,$E887,      // <cjk>
      $95C3,$E88A,      // <cjk>
      $95C7,$88C5,      // <cjk>
      $95CA,$E888,      // <cjk>
      $95CC,$E88C,      // <cjk>
      $95CD,$E88B,      // <cjk>
      $95D4,$E88E,      // <cjk>
      $95D5,$E88D,      // <cjk>
      $95D6,$E88F,      // <cjk>
      $95D8,$93AC,      // <cjk>
      $95DC,$E890,      // <cjk>
      $95E1,$E891,      // <cjk>
      $95E2,$E893,      // <cjk>
      $95E5,$E892,      // <cjk>
      $961C,$958C,      // <cjk>
      $9621,$E894,      // <cjk>
      $9628,$E895,      // <cjk>
      $962A,$8DE3,      // <cjk>
      $962E,$E896,      // <cjk>
      $962F,$E897,      // <cjk>
      $9632,$9668,      // <cjk>
      $963B,$916A,      // <cjk>
      $963F,$88A2,      // <cjk>
      $9640,$91C9,      // <cjk>
      $9642,$E898,      // <cjk>
      $9644,$958D,      // <cjk>
      $964B,$E89B,      // <cjk>
      $964C,$E899,      // <cjk>
      $964D,$8D7E,      // <cjk>
      $964F,$E89A,      // <cjk>
      $9650,$8CC0,      // <cjk>
      $965B,$95C3,      // <cjk>
      $965C,$E89D,      // <cjk>
      $965D,$E89F,      // <cjk>
      $965E,$E89E,      // <cjk>
      $965F,$E8A0,      // <cjk>
      $9662,$8940,      // <cjk>
      $9663,$9077,      // <cjk>
      $9664,$8F9C,      // <cjk>
      $9665,$8AD7,      // <cjk>
      $9666,$E8A1,      // <cjk>
      $966A,$9486,      // <cjk>
      $966C,$E8A3,      // <cjk>
      $9670,$8941,      // <cjk>
      $9672,$E8A2,      // <cjk>
      $9673,$92C2,      // <cjk>
      $9675,$97CB,      // <cjk>
      $9676,$93A9,      // <cjk>
      $9677,$E89C,      // <cjk>
      $9678,$97A4,      // <cjk>
      $967A,$8CAF,      // <cjk>
      $967D,$977A,      // <cjk>
      $9685,$8BF7,      // <cjk>
      $9686,$97B2,      // <cjk>
      $9688,$8C47,      // <cjk>
      $968A,$91E0,      // <cjk>
      $968B,$E440,      // <cjk>
      $968D,$E8A4,      // <cjk>
      $968E,$8A4B,      // <cjk>
      $968F,$908F,      // <cjk>
      $9694,$8A75,      // <cjk>
      $9695,$E8A6,      // <cjk>
      $9697,$E8A7,      // <cjk>
      $9698,$E8A5,      // <cjk>
      $9699,$8C84,      // <cjk>
      $969B,$8DDB,      // <cjk>
      $969C,$8FE1,      // <cjk>
      $96A0,$8942,      // <cjk>
      $96A3,$97D7,      // <cjk>
      $96A7,$E8A9,      // <cjk>
      $96A8,$E7AC,      // <cjk>
      $96AA,$E8A8,      // <cjk>
      $96B0,$E8AC,      // <cjk>
      $96B1,$E8AA,      // <cjk>
      $96B2,$E8AB,      // <cjk>
      $96B4,$E8AD,      // <cjk>
      $96B6,$E8AE,      // <cjk>
      $96B7,$97EA,      // <cjk>
      $96B8,$E8AF,      // <cjk>
      $96B9,$E8B0,      // <cjk>
      $96BB,$90C7,      // <cjk>
      $96BC,$94B9,      // <cjk>
      $96C0,$909D,      // <cjk>
      $96C1,$8AE5,      // <cjk>
      $96C4,$9759,      // <cjk>
      $96C5,$89EB,      // <cjk>
      $96C6,$8F57,      // <cjk>
      $96C7,$8CD9,      // <cjk>
      $96C9,$E8B3,      // <cjk>
      $96CB,$E8B2,      // <cjk>
      $96CC,$8E93,      // <cjk>
      $96CD,$E8B4,      // <cjk>
      $96CE,$E8B1,      // <cjk>
      $96D1,$8E47,      // <cjk>
      $96D5,$E8B8,      // <cjk>
      $96D6,$E5AB,      // <cjk>
      $96D9,$99D4,      // <cjk>
      $96DB,$9097,      // <cjk>
      $96DC,$E8B6,      // <cjk>
      $96E2,$97A3,      // <cjk>
      $96E3,$93EF,      // <cjk>
      $96E8,$894A,      // <cjk>
      $96EA,$90E1,      // <cjk>
      $96EB,$8EB4,      // <cjk>
      $96F0,$95B5,      // <cjk>
      $96F2,$895F,      // <cjk>
      $96F6,$97EB,      // <cjk>
      $96F7,$978B,      // <cjk>
      $96F9,$E8B9,      // <cjk>
      $96FB,$9364,      // <cjk>
      $9700,$8EF9,      // <cjk>
      $9704,$E8BA,      // <cjk>
      $9706,$E8BB,      // <cjk>
      $9707,$906B,      // <cjk>
      $9708,$E8BC,      // <cjk>
      $970A,$97EC,      // <cjk>
      $970D,$E8B7,      // <cjk>
      $970E,$E8BE,      // <cjk>
      $970F,$E8C0,      // <cjk>
      $9711,$E8BF,      // <cjk>
      $9713,$E8BD,      // <cjk>
      $9716,$E8C1,      // <cjk>
      $9719,$E8C2,      // <cjk>
      $971C,$919A,      // <cjk>
      $971E,$89E0,      // <cjk>
      $9724,$E8C3,      // <cjk>
      $9727,$96B6,      // <cjk>
      $972A,$E8C4,      // <cjk>
      $9730,$E8C5,      // <cjk>
      $9732,$9849,      // <cjk>
      $9738,$9E50,      // <cjk>
      $9739,$E8C6,      // <cjk>
      $973D,$E8C7,      // <cjk>
      $973E,$E8C8,      // <cjk>
      $9742,$E8CC,      // <cjk>
      $9744,$E8C9,      // <cjk>
      $9746,$E8CA,      // <cjk>
      $9748,$E8CB,      // <cjk>
      $9749,$E8CD,      // <cjk>
      $9752,$90C2,      // <cjk>
      $9756,$96F5,      // <cjk>
      $9759,$90C3,      // <cjk>
      $975C,$E8CE,      // <cjk>
      $975E,$94F1,      // <cjk>
      $9760,$E8CF,      // <cjk>
      $9761,$EA72,      // <cjk>
      $9762,$96CA,      // <cjk>
      $9764,$E8D0,      // <cjk>
      $9766,$E8D1,      // <cjk>
      $9768,$E8D2,      // <cjk>
      $9769,$8A76,      // <cjk>
      $976B,$E8D4,      // <cjk>
      $976D,$9078,      // <cjk>
      $9771,$E8D5,      // <cjk>
      $9774,$8C43,      // <cjk>
      $9779,$E8D6,      // <cjk>
      $977A,$E8DA,      // <cjk>
      $977C,$E8D8,      // <cjk>
      $9781,$E8D9,      // <cjk>
      $9784,$8A93,      // <cjk>
      $9785,$E8D7,      // <cjk>
      $9786,$E8DB,      // <cjk>
      $978B,$E8DC,      // <cjk>
      $978D,$88C6,      // <cjk>
      $978F,$E8DD,      // <cjk>
      $9790,$E8DE,      // <cjk>
      $9798,$8FE2,      // <cjk>
      $979C,$E8DF,      // <cjk>
      $97A0,$8B66,      // <cjk>
      $97A3,$E8E2,      // <cjk>
      $97A6,$E8E1,      // <cjk>
      $97A8,$E8E0,      // <cjk>
      $97AB,$E691,      // <cjk>
      $97AD,$95DA,      // <cjk>
      $97B3,$E8E3,      // <cjk>
      $97B4,$E8E4,      // <cjk>
      $97C3,$E8E5,      // <cjk>
      $97C6,$E8E6,      // <cjk>
      $97C8,$E8E7,      // <cjk>
      $97CB,$E8E8,      // <cjk>
      $97D3,$8AD8,      // <cjk>
      $97DC,$E8E9,      // <cjk>
      $97ED,$E8EA,      // <cjk>
      $97EE,$9442,      // <cjk>
      $97F2,$E8EC,      // <cjk>
      $97F3,$89B9,      // <cjk>
      $97F5,$E8EF,      // <cjk>
      $97F6,$E8EE,      // <cjk>
      $97FB,$8943,      // <cjk>
      $97FF,$8BBF,      // <cjk>
      $9801,$95C5,      // <cjk>
      $9802,$92B8,      // <cjk>
      $9803,$8DA0,      // <cjk>
      $9805,$8D80,      // <cjk>
      $9806,$8F87,      // <cjk>
      $9808,$907B,      // <cjk>
      $980C,$E8F1,      // <cjk>
      $980F,$E8F0,      // <cjk>
      $9810,$9761,      // <cjk>
      $9811,$8AE6,      // <cjk>
      $9812,$94D0,      // <cjk>
      $9813,$93DA,      // <cjk>
      $9817,$909C,      // <cjk>
      $9818,$97CC,      // <cjk>
      $981A,$8C7A,      // <cjk>
      $9821,$E8F4,      // <cjk>
      $9824,$E8F3,      // <cjk>
      $982C,$966A,      // <cjk>
      $982D,$93AA,      // <cjk>
      $9834,$896F,      // <cjk>
      $9837,$E8F5,      // <cjk>
      $9838,$E8F2,      // <cjk>
      $983B,$9570,      // <cjk>
      $983C,$978A,      // <cjk>
      $983D,$E8F6,      // <cjk>
      $9846,$E8F7,      // <cjk>
      $984B,$E8F9,      // <cjk>
      $984C,$91E8,      // <cjk>
      $984D,$8A7A,      // <cjk>
      $984E,$8A7B,      // <cjk>
      $984F,$E8F8,      // <cjk>
      $9854,$8AE7,      // <cjk>
      $9855,$8CB0,      // <cjk>
      $9858,$8AE8,      // <cjk>
      $985B,$935E,      // <cjk>
      $985E,$97DE,      // <cjk>
      $9867,$8CDA,      // <cjk>
      $986B,$E8FA,      // <cjk>
      $986F,$E8FB,      // <cjk>
      $9870,$E8FC,      // <cjk>
      $9871,$E940,      // <cjk>
      $9873,$E942,      // <cjk>
      $9874,$E941,      // <cjk>
      $98A8,$9597,      // <cjk>
      $98AA,$E943,      // <cjk>
      $98AF,$E944,      // <cjk>
      $98B1,$E945,      // <cjk>
      $98B6,$E946,      // <cjk>
      $98C3,$E948,      // <cjk>
      $98C4,$E947,      // <cjk>
      $98C6,$E949,      // <cjk>
      $98DB,$94F2,      // <cjk>
      $98DC,$E3CA,      // <cjk>
      $98DF,$9048,      // <cjk>
      $98E2,$8B51,      // <cjk>
      $98E9,$E94A,      // <cjk>
      $98EB,$E94B,      // <cjk>
      $98ED,$99AA,      // <cjk>
      $98EE,$9F5A,      // <cjk>
      $98EF,$94D1,      // <cjk>
      $98F2,$88F9,      // <cjk>
      $98F4,$88B9,      // <cjk>
      $98FC,$8E94,      // <cjk>
      $98FD,$964F,      // <cjk>
      $98FE,$8FFC,      // <cjk>
      $9903,$E94C,      // <cjk>
      $9905,$96DD,      // <cjk>
      $9909,$E94D,      // <cjk>
      $990A,$977B,      // <cjk>
      $990C,$8961,      // <cjk>
      $9910,$8E60,      // <cjk>
      $9912,$E94E,      // <cjk>
      $9913,$89EC,      // <cjk>
      $9914,$E94F,      // <cjk>
      $9918,$E950,      // <cjk>
      $991D,$E952,      // <cjk>
      $991E,$E953,      // <cjk>
      $9920,$E955,      // <cjk>
      $9921,$E951,      // <cjk>
      $9924,$E954,      // <cjk>
      $9928,$8AD9,      // <cjk>
      $992C,$E956,      // <cjk>
      $992E,$E957,      // <cjk>
      $993D,$E958,      // <cjk>
      $993E,$E959,      // <cjk>
      $9942,$E95A,      // <cjk>
      $9945,$E95C,      // <cjk>
      $994B,$E95E,      // <cjk>
      $994C,$E961,      // <cjk>
      $9950,$E95D,      // <cjk>
      $9951,$E95F,      // <cjk>
      $9952,$E960,      // <cjk>
      $9955,$E962,      // <cjk>
      $9957,$8BC0,      // <cjk>
      $9996,$8EF1,      // <cjk>
      $9997,$E963,      // <cjk>
      $9998,$E964,      // <cjk>
      $9999,$8D81,      // <cjk>
      $99A5,$E965,      // <cjk>
      $99A8,$8A5D,      // <cjk>
      $99AC,$946E,      // <cjk>
      $99AD,$E966,      // <cjk>
      $99AE,$E967,      // <cjk>
      $99B3,$9279,      // <cjk>
      $99B4,$93E9,      // <cjk>
      $99BC,$E968,      // <cjk>
      $99C1,$949D,      // <cjk>
      $99C4,$91CA,      // <cjk>
      $99C5,$8977,      // <cjk>
      $99C6,$8BEC,      // <cjk>
      $99C8,$8BED,      // <cjk>
      $99D0,$9293,      // <cjk>
      $99D1,$E96D,      // <cjk>
      $99D2,$8BEE,      // <cjk>
      $99D5,$89ED,      // <cjk>
      $99D8,$E96C,      // <cjk>
      $99DB,$E96A,      // <cjk>
      $99DD,$E96B,      // <cjk>
      $99DF,$E969,      // <cjk>
      $99E2,$E977,      // <cjk>
      $99ED,$E96E,      // <cjk>
      $99EE,$E96F,      // <cjk>
      $99F1,$E970,      // <cjk>
      $99F2,$E971,      // <cjk>
      $99F8,$E973,      // <cjk>
      $99FB,$E972,      // <cjk>
      $99FF,$8F78,      // <cjk>
      $9A01,$E974,      // <cjk>
      $9A05,$E976,      // <cjk>
      $9A0E,$8B52,      // <cjk>
      $9A0F,$E975,      // <cjk>
      $9A12,$919B,      // <cjk>
      $9A13,$8CB1,      // <cjk>
      $9A19,$E978,      // <cjk>
      $9A28,$91CB,      // <cjk>
      $9A2B,$E979,      // <cjk>
      $9A30,$93AB,      // <cjk>
      $9A37,$E97A,      // <cjk>
      $9A3E,$E980,      // <cjk>
      $9A40,$E97D,      // <cjk>
      $9A42,$E97C,      // <cjk>
      $9A43,$E97E,      // <cjk>
      $9A45,$E97B,      // <cjk>
      $9A4D,$E982,      // <cjk>
      $9A55,$E981,      // <cjk>
      $9A57,$E984,      // <cjk>
      $9A5A,$8BC1,      // <cjk>
      $9A5B,$E983,      // <cjk>
      $9A5F,$E985,      // <cjk>
      $9A62,$E986,      // <cjk>
      $9A64,$E988,      // <cjk>
      $9A65,$E987,      // <cjk>
      $9A69,$E989,      // <cjk>
      $9A6A,$E98B,      // <cjk>
      $9A6B,$E98A,      // <cjk>
      $9AA8,$8D9C,      // <cjk>
      $9AAD,$E98C,      // <cjk>
      $9AB0,$E98D,      // <cjk>
      $9ABC,$E98E,      // <cjk>
      $9AC0,$E98F,      // <cjk>
      $9AC4,$9091,      // <cjk>
      $9ACF,$E990,      // <cjk>
      $9AD1,$E991,      // <cjk>
      $9AD3,$E992,      // <cjk>
      $9AD4,$E993,      // <cjk>
      $9AD8,$8D82,      // <cjk>
      $9ADE,$E994,      // <cjk>
      $9ADF,$E995,      // <cjk>
      $9AE2,$E996,      // <cjk>
      $9AE3,$E997,      // <cjk>
      $9AE6,$E998,      // <cjk>
      $9AEA,$94AF,      // <cjk>
      $9AEB,$E99A,      // <cjk>
      $9AED,$9545,      // <cjk>
      $9AEE,$E99B,      // <cjk>
      $9AEF,$E999,      // <cjk>
      $9AF1,$E99D,      // <cjk>
      $9AF4,$E99C,      // <cjk>
      $9AF7,$E99E,      // <cjk>
      $9AFB,$E99F,      // <cjk>
      $9B06,$E9A0,      // <cjk>
      $9B18,$E9A1,      // <cjk>
      $9B1A,$E9A2,      // <cjk>
      $9B1F,$E9A3,      // <cjk>
      $9B22,$E9A4,      // <cjk>
      $9B23,$E9A5,      // <cjk>
      $9B25,$E9A6,      // <cjk>
      $9B27,$E9A7,      // <cjk>
      $9B28,$E9A8,      // <cjk>
      $9B29,$E9A9,      // <cjk>
      $9B2A,$E9AA,      // <cjk>
      $9B2E,$E9AB,      // <cjk>
      $9B2F,$E9AC,      // <cjk>
      $9B31,$9F54,      // <cjk>
      $9B32,$E9AD,      // <cjk>
      $9B3B,$E2F6,      // <cjk>
      $9B3C,$8B53,      // <cjk>
      $9B41,$8A40,      // <cjk>
      $9B42,$8DB0,      // <cjk>
      $9B43,$E9AF,      // <cjk>
      $9B44,$E9AE,      // <cjk>
      $9B45,$96A3,      // <cjk>
      $9B4D,$E9B1,      // <cjk>
      $9B4E,$E9B2,      // <cjk>
      $9B4F,$E9B0,      // <cjk>
      $9B51,$E9B3,      // <cjk>
      $9B54,$9682,      // <cjk>
      $9B58,$E9B4,      // <cjk>
      $9B5A,$8B9B,      // <cjk>
      $9B6F,$9844,      // <cjk>
      $9B74,$E9B5,      // <cjk>
      $9B83,$E9B7,      // <cjk>
      $9B8E,$88BC,      // <cjk>
      $9B91,$E9B8,      // <cjk>
      $9B92,$95A9,      // <cjk>
      $9B93,$E9B6,      // <cjk>
      $9B96,$E9B9,      // <cjk>
      $9B97,$E9BA,      // <cjk>
      $9B9F,$E9BB,      // <cjk>
      $9BA0,$E9BC,      // <cjk>
      $9BA8,$E9BD,      // <cjk>
      $9BAA,$968E,      // <cjk>
      $9BAB,$8E4C,      // <cjk>
      $9BAD,$8DF8,      // <cjk>
      $9BAE,$914E,      // <cjk>
      $9BB4,$E9BE,      // <cjk>
      $9BB9,$E9C1,      // <cjk>
      $9BC0,$E9BF,      // <cjk>
      $9BC6,$E9C2,      // <cjk>
      $9BC9,$8CEF,      // <cjk>
      $9BCA,$E9C0,      // <cjk>
      $9BCF,$E9C3,      // <cjk>
      $9BD1,$E9C4,      // <cjk>
      $9BD2,$E9C5,      // <cjk>
      $9BD4,$E9C9,      // <cjk>
      $9BD6,$8E49,      // <cjk>
      $9BDB,$91E2,      // <cjk>
      $9BE1,$E9CA,      // <cjk>
      $9BE2,$E9C7,      // <cjk>
      $9BE3,$E9C6,      // <cjk>
      $9BE4,$E9C8,      // <cjk>
      $9BE8,$8C7E,      // <cjk>
      $9BF0,$E9CE,      // <cjk>
      $9BF1,$E9CD,      // <cjk>
      $9BF2,$E9CC,      // <cjk>
      $9BF5,$88B1,      // <cjk>
      $9C04,$E9D8,      // <cjk>
      $9C06,$E9D4,      // <cjk>
      $9C08,$E9D5,      // <cjk>
      $9C09,$E9D1,      // <cjk>
      $9C0A,$E9D7,      // <cjk>
      $9C0C,$E9D3,      // <cjk>
      $9C0D,$8A82,      // <cjk>
      $9C10,$986B,      // <cjk>
      $9C12,$E9D6,      // <cjk>
      $9C13,$E9D2,      // <cjk>
      $9C14,$E9D0,      // <cjk>
      $9C15,$E9CF,      // <cjk>
      $9C1B,$E9DA,      // <cjk>
      $9C21,$E9DD,      // <cjk>
      $9C24,$E9DC,      // <cjk>
      $9C25,$E9DB,      // <cjk>
      $9C2D,$9568,      // <cjk>
      $9C2E,$E9D9,      // <cjk>
      $9C2F,$88F1,      // <cjk>
      $9C30,$E9DE,      // <cjk>
      $9C32,$E9E0,      // <cjk>
      $9C39,$8A8F,      // <cjk>
      $9C3A,$E9CB,      // <cjk>
      $9C3B,$8956,      // <cjk>
      $9C3E,$E9E2,      // <cjk>
      $9C46,$E9E1,      // <cjk>
      $9C47,$E9DF,      // <cjk>
      $9C48,$924C,      // <cjk>
      $9C52,$9690,      // <cjk>
      $9C57,$97D8,      // <cjk>
      $9C5A,$E9E3,      // <cjk>
      $9C60,$E9E4,      // <cjk>
      $9C67,$E9E5,      // <cjk>
      $9C76,$E9E6,      // <cjk>
      $9C78,$E9E7,      // <cjk>
      $9CE5,$92B9,      // <cjk>
      $9CE7,$E9E8,      // <cjk>
      $9CE9,$94B5,      // <cjk>
      $9CEB,$E9ED,      // <cjk>
      $9CEC,$E9E9,      // <cjk>
      $9CF0,$E9EA,      // <cjk>
      $9CF3,$9650,      // <cjk>
      $9CF4,$96C2,      // <cjk>
      $9CF6,$93CE,      // <cjk>
      $9D03,$E9EE,      // <cjk>
      $9D06,$E9EF,      // <cjk>
      $9D07,$93BC,      // <cjk>
      $9D08,$E9EC,      // <cjk>
      $9D09,$E9EB,      // <cjk>
      $9D0E,$89A8,      // <cjk>
      $9D12,$E9F7,      // <cjk>
      $9D15,$E9F6,      // <cjk>
      $9D1B,$8995,      // <cjk>
      $9D1F,$E9F4,      // <cjk>
      $9D23,$E9F3,      // <cjk>
      $9D26,$E9F1,      // <cjk>
      $9D28,$8A9B,      // <cjk>
      $9D2A,$E9F0,      // <cjk>
      $9D2B,$8EB0,      // <cjk>
      $9D2C,$89A7,      // <cjk>
      $9D3B,$8D83,      // <cjk>
      $9D3E,$E9FA,      // <cjk>
      $9D3F,$E9F9,      // <cjk>
      $9D41,$E9F8,      // <cjk>
      $9D44,$E9F5,      // <cjk>
      $9D46,$E9FB,      // <cjk>
      $9D48,$E9FC,      // <cjk>
      $9D50,$EA44,      // <cjk>
      $9D51,$EA43,      // <cjk>
      $9D59,$EA45,      // <cjk>
      $9D5C,$894C,      // <cjk>
      $9D5D,$EA40,      // <cjk>
      $9D5E,$EA41,      // <cjk>
      $9D60,$8D94,      // <cjk>
      $9D61,$96B7,      // <cjk>
      $9D64,$EA42,      // <cjk>
      $9D6C,$9651,      // <cjk>
      $9D6F,$EA4A,      // <cjk>
      $9D72,$EA46,      // <cjk>
      $9D7A,$EA4B,      // <cjk>
      $9D87,$EA48,      // <cjk>
      $9D89,$EA47,      // <cjk>
      $9D8F,$8C7B,      // <cjk>
      $9D9A,$EA4C,      // <cjk>
      $9DA4,$EA4D,      // <cjk>
      $9DA9,$EA4E,      // <cjk>
      $9DAB,$EA49,      // <cjk>
      $9DAF,$E9F2,      // <cjk>
      $9DB2,$EA4F,      // <cjk>
      $9DB4,$92DF,      // <cjk>
      $9DB8,$EA53,      // <cjk>
      $9DBA,$EA54,      // <cjk>
      $9DBB,$EA52,      // <cjk>
      $9DC1,$EA51,      // <cjk>
      $9DC2,$EA57,      // <cjk>
      $9DC4,$EA50,      // <cjk>
      $9DC6,$EA55,      // <cjk>
      $9DCF,$EA56,      // <cjk>
      $9DD3,$EA59,      // <cjk>
      $9DD9,$EA58,      // <cjk>
      $9DED,$EA5C,      // <cjk>
      $9DEF,$EA5D,      // <cjk>
      $9DF2,$9868,      // <cjk>
      $9DF8,$EA5A,      // <cjk>
      $9DF9,$91E9,      // <cjk>
      $9DFA,$8DEB,      // <cjk>
      $9DFD,$EA5E,      // <cjk>
      $9E1A,$EA5F,      // <cjk>
      $9E1B,$EA60,      // <cjk>
      $9E1E,$EA61,      // <cjk>
      $9E75,$EA62,      // <cjk>
      $9E78,$8CB2,      // <cjk>
      $9E79,$EA63,      // <cjk>
      $9E7D,$EA64,      // <cjk>
      $9E7F,$8EAD,      // <cjk>
      $9E81,$EA65,      // <cjk>
      $9E88,$EA66,      // <cjk>
      $9E8B,$EA67,      // <cjk>
      $9E8C,$EA68,      // <cjk>
      $9E91,$EA6B,      // <cjk>
      $9E92,$EA69,      // <cjk>
      $9E95,$EA6A,      // <cjk>
      $9E97,$97ED,      // <cjk>
      $9E9D,$EA6C,      // <cjk>
      $9E9F,$97D9,      // <cjk>
      $9EA5,$EA6D,      // <cjk>
      $9EA6,$949E,      // <cjk>
      $9EA9,$EA6E,      // <cjk>
      $9EAA,$EA70,      // <cjk>
      $9EAD,$EA71,      // <cjk>
      $9EB8,$EA6F,      // <cjk>
      $9EB9,$8D8D,      // <cjk>
      $9EBA,$96CB,      // <cjk>
      $9EBB,$9683,      // <cjk>
      $9EBC,$9BF5,      // <cjk>
      $9EBE,$9F80,      // <cjk>
      $9EBF,$969B,      // <cjk>
      $9EC4,$89A9,      // <cjk>
      $9ECC,$EA73,      // <cjk>
      $9ECD,$8B6F,      // <cjk>
      $9ECE,$EA74,      // <cjk>
      $9ECF,$EA75,      // <cjk>
      $9ED0,$EA76,      // <cjk>
      $9ED2,$8D95,      // <cjk>
      $9ED4,$EA77,      // <cjk>
      $9ED8,$E0D2,      // <cjk>
      $9ED9,$96D9,      // <cjk>
      $9EDB,$91E1,      // <cjk>
      $9EDC,$EA78,      // <cjk>
      $9EDD,$EA7A,      // <cjk>
      $9EDE,$EA79,      // <cjk>
      $9EE0,$EA7B,      // <cjk>
      $9EE5,$EA7C,      // <cjk>
      $9EE8,$EA7D,      // <cjk>
      $9EEF,$EA7E,      // <cjk>
      $9EF4,$EA80,      // <cjk>
      $9EF6,$EA81,      // <cjk>
      $9EF7,$EA82,      // <cjk>
      $9EF9,$EA83,      // <cjk>
      $9EFB,$EA84,      // <cjk>
      $9EFC,$EA85,      // <cjk>
      $9EFD,$EA86,      // <cjk>
      $9F07,$EA87,      // <cjk>
      $9F08,$EA88,      // <cjk>
      $9F0E,$9343,      // <cjk>
      $9F13,$8CDB,      // <cjk>
      $9F15,$EA8A,      // <cjk>
      $9F20,$916C,      // <cjk>
      $9F21,$EA8B,      // <cjk>
      $9F2C,$EA8C,      // <cjk>
      $9F3B,$9540,      // <cjk>
      $9F3E,$EA8D,      // <cjk>
      $9F4A,$EA8E,      // <cjk>
      $9F4B,$E256,      // <cjk>
      $9F4E,$E6D8,      // <cjk>
      $9F4F,$E8EB,      // <cjk>
      $9F52,$EA8F,      // <cjk>
      $9F54,$EA90,      // <cjk>
      $9F5F,$EA92,      // <cjk>
      $9F60,$EA93,      // <cjk>
      $9F61,$EA94,      // <cjk>
      $9F62,$97EE,      // <cjk>
      $9F63,$EA91,      // <cjk>
      $9F66,$EA95,      // <cjk>
      $9F67,$EA96,      // <cjk>
      $9F6A,$EA98,      // <cjk>
      $9F6C,$EA97,      // <cjk>
      $9F72,$EA9A,      // <cjk>
      $9F76,$EA9B,      // <cjk>
      $9F77,$EA99,      // <cjk>
      $9F8D,$97B4,      // <cjk>
      $9F95,$EA9C,      // <cjk>
      $9F9C,$EA9D,      // <cjk>
      $9F9D,$E273,      // <cjk>
      $9FA0,$EA9E,      // <cjk>
      $FF01,$8149,      // FULLWIDTH EXCLAMATION MARK
      $FF03,$8194,      // FULLWIDTH NUMBER SIGN
      $FF04,$8190,      // FULLWIDTH DOLLAR SIGN
      $FF05,$8193,      // FULLWIDTH PERCENT SIGN
      $FF06,$8195,      // FULLWIDTH AMPERSAND
      $FF07,$81AD,      // FULLWIDTH APOSTROPHE
      $FF08,$8169,      // FULLWIDTH LEFT PARENTHESIS
      $FF09,$816A,      // FULLWIDTH RIGHT PARENTHESIS
      $FF0A,$8196,      // FULLWIDTH ASTERISK
      $FF0B,$817B,      // FULLWIDTH PLUS SIGN
      $FF0C,$8143,      // FULLWIDTH COMMA
      $FF0E,$8144,      // FULLWIDTH FULL STOP
      $FF0F,$815E,      // FULLWIDTH SOLIDUS
      $FF10,$824F,      // FULLWIDTH DIGIT ZERO
      $FF11,$8250,      // FULLWIDTH DIGIT ONE
      $FF12,$8251,      // FULLWIDTH DIGIT TWO
      $FF13,$8252,      // FULLWIDTH DIGIT THREE
      $FF14,$8253,      // FULLWIDTH DIGIT FOUR
      $FF15,$8254,      // FULLWIDTH DIGIT FIVE
      $FF16,$8255,      // FULLWIDTH DIGIT SIX
      $FF17,$8256,      // FULLWIDTH DIGIT SEVEN
      $FF18,$8257,      // FULLWIDTH DIGIT EIGHT
      $FF19,$8258,      // FULLWIDTH DIGIT NINE
      $FF1A,$8146,      // FULLWIDTH COLON
      $FF1B,$8147,      // FULLWIDTH SEMICOLON
      $FF1C,$8183,      // FULLWIDTH LESS-THAN SIGN
      $FF1D,$8181,      // FULLWIDTH EQUALS SIGN
      $FF1E,$8184,      // FULLWIDTH GREATER-THAN SIGN
      $FF1F,$8148,      // FULLWIDTH QUESTION MARK
      $FF20,$8197,      // FULLWIDTH COMMERCIAL AT
      $FF21,$8260,      // FULLWIDTH LATIN CAPITAL LETTER A
      $FF22,$8261,      // FULLWIDTH LATIN CAPITAL LETTER B
      $FF23,$8262,      // FULLWIDTH LATIN CAPITAL LETTER C
      $FF24,$8263,      // FULLWIDTH LATIN CAPITAL LETTER D
      $FF25,$8264,      // FULLWIDTH LATIN CAPITAL LETTER E
      $FF26,$8265,      // FULLWIDTH LATIN CAPITAL LETTER F
      $FF27,$8266,      // FULLWIDTH LATIN CAPITAL LETTER G
      $FF28,$8267,      // FULLWIDTH LATIN CAPITAL LETTER H
      $FF29,$8268,      // FULLWIDTH LATIN CAPITAL LETTER I
      $FF2A,$8269,      // FULLWIDTH LATIN CAPITAL LETTER J
      $FF2B,$826A,      // FULLWIDTH LATIN CAPITAL LETTER K
      $FF2C,$826B,      // FULLWIDTH LATIN CAPITAL LETTER L
      $FF2D,$826C,      // FULLWIDTH LATIN CAPITAL LETTER M
      $FF2E,$826D,      // FULLWIDTH LATIN CAPITAL LETTER N
      $FF2F,$826E,      // FULLWIDTH LATIN CAPITAL LETTER O
      $FF30,$826F,      // FULLWIDTH LATIN CAPITAL LETTER P
      $FF31,$8270,      // FULLWIDTH LATIN CAPITAL LETTER Q
      $FF32,$8271,      // FULLWIDTH LATIN CAPITAL LETTER R
      $FF33,$8272,      // FULLWIDTH LATIN CAPITAL LETTER S
      $FF34,$8273,      // FULLWIDTH LATIN CAPITAL LETTER T
      $FF35,$8274,      // FULLWIDTH LATIN CAPITAL LETTER U
      $FF36,$8275,      // FULLWIDTH LATIN CAPITAL LETTER V
      $FF37,$8276,      // FULLWIDTH LATIN CAPITAL LETTER W
      $FF38,$8277,      // FULLWIDTH LATIN CAPITAL LETTER X
      $FF39,$8278,      // FULLWIDTH LATIN CAPITAL LETTER Y
      $FF3A,$8279,      // FULLWIDTH LATIN CAPITAL LETTER Z
      $FF3B,$816D,      // FULLWIDTH LEFT SQUARE BRACKET
      $FF3D,$816E,      // FULLWIDTH RIGHT SQUARE BRACKET
      $FF3E,$814F,      // FULLWIDTH CIRCUMFLEX ACCENT
      $FF3F,$8151,      // FULLWIDTH LOW LINE
      $FF40,$814D,      // FULLWIDTH GRAVE ACCENT
      $FF41,$8281,      // FULLWIDTH LATIN SMALL LETTER A
      $FF42,$8282,      // FULLWIDTH LATIN SMALL LETTER B
      $FF43,$8283,      // FULLWIDTH LATIN SMALL LETTER C
      $FF44,$8284,      // FULLWIDTH LATIN SMALL LETTER D
      $FF45,$8285,      // FULLWIDTH LATIN SMALL LETTER E
      $FF46,$8286,      // FULLWIDTH LATIN SMALL LETTER F
      $FF47,$8287,      // FULLWIDTH LATIN SMALL LETTER G
      $FF48,$8288,      // FULLWIDTH LATIN SMALL LETTER H
      $FF49,$8289,      // FULLWIDTH LATIN SMALL LETTER I
      $FF4A,$828A,      // FULLWIDTH LATIN SMALL LETTER J
      $FF4B,$828B,      // FULLWIDTH LATIN SMALL LETTER K
      $FF4C,$828C,      // FULLWIDTH LATIN SMALL LETTER L
      $FF4D,$828D,      // FULLWIDTH LATIN SMALL LETTER M
      $FF4E,$828E,      // FULLWIDTH LATIN SMALL LETTER N
      $FF4F,$828F,      // FULLWIDTH LATIN SMALL LETTER O
      $FF50,$8290,      // FULLWIDTH LATIN SMALL LETTER P
      $FF51,$8291,      // FULLWIDTH LATIN SMALL LETTER Q
      $FF52,$8292,      // FULLWIDTH LATIN SMALL LETTER R
      $FF53,$8293,      // FULLWIDTH LATIN SMALL LETTER S
      $FF54,$8294,      // FULLWIDTH LATIN SMALL LETTER T
      $FF55,$8295,      // FULLWIDTH LATIN SMALL LETTER U
      $FF56,$8296,      // FULLWIDTH LATIN SMALL LETTER V
      $FF57,$8297,      // FULLWIDTH LATIN SMALL LETTER W
      $FF58,$8298,      // FULLWIDTH LATIN SMALL LETTER X
      $FF59,$8299,      // FULLWIDTH LATIN SMALL LETTER Y
      $FF5A,$829A,      // FULLWIDTH LATIN SMALL LETTER Z
      $FF5B,$816F,      // FULLWIDTH LEFT CURLY BRACKET
      $FF5C,$8162,      // FULLWIDTH VERTICAL LINE
      $FF5D,$8170,      // FULLWIDTH RIGHT CURLY BRACKET
      $FFE3,$8150,      // FULLWIDTH MACRON
      $FFE5,$818F       // FULLWIDTH YEN SIGN
);

implementation

end.
