unit zint_aztec;

{
  Based on Zint (done by Robin Stuart and the Zint team)
  http://github.com/zint/zint

  Translation by TheUnknownOnes
  http://theunknownones.net

  License: Apache License 2.0

  Status:
    3432bc9aff311f2aea40f0e9883abfe6564c080b complete

}

{$IFDEF FPC}
{$mode objfpc}{$H+}
{$ENDIF}

interface

uses
  SysUtils, zint, zint_helper;

function aztec_runes(symbol : zint_symbol; source : TArrayOfByte; _length : Integer) : Integer;
function aztec(symbol : zint_symbol; source : TArrayOfByte; _length : Integer) : Integer;

implementation

uses zint_common, zint_reedsol;

const
  UPPER	= 1;
  LOWER	= 2;
  MIXED	= 4;
  PUNC = 8;
  DIGIT	= 16;
  BINARY = 32;

const AztecMap : array[0..22800] of Integer = ( { 151 x 151 data grid }
	19969,19968,18851,18853,18855,18857,18859,18861,18863,18865,18867,0,18869,18871,18873,18875,18877,18879,18881,18883,18885,18887,18889,18891,18893,18895,18897,0,18899,18901,18903,18905,18907,18909,18911,18913,18915,18917,18919,18921,18923,18925,18927,0,18929,18931,18933,18935,18937,18939,18941,18943,18945,18947,18949,18951,18953,18955,18957,0,18959,18961,18963,18965,18967,18969,18971,18973,18975,18977,18979,18981,18983,18985,18987,0,18989,18991,18993,18995,18997,18999,19001,19003,19005,19007,19009,19011,19013,19015,19017,0,19019,19021,19023,19025,19027,19029,19031,19033,19035,19037,19039,19041,19043,19045,19047,0,19049,19051,19053,19055,19057,19059,19061,19063,19065,19067,19069,19071,19073,19075,19077,0,19079,19081,19083,19085,19087,19089,19091,19093,19095,19097,19099,19101,19103,19105,19107,0,19109,19111,19113,19115,19117,19119,19121,19123,19125,19127,19129,
	19967,19966,18850,18852,18854,18856,18858,18860,18862,18864,18866,1,18868,18870,18872,18874,18876,18878,18880,18882,18884,18886,18888,18890,18892,18894,18896,1,18898,18900,18902,18904,18906,18908,18910,18912,18914,18916,18918,18920,18922,18924,18926,1,18928,18930,18932,18934,18936,18938,18940,18942,18944,18946,18948,18950,18952,18954,18956,1,18958,18960,18962,18964,18966,18968,18970,18972,18974,18976,18978,18980,18982,18984,18986,1,18988,18990,18992,18994,18996,18998,19000,19002,19004,19006,19008,19010,19012,19014,19016,1,19018,19020,19022,19024,19026,19028,19030,19032,19034,19036,19038,19040,19042,19044,19046,1,19048,19050,19052,19054,19056,19058,19060,19062,19064,19066,19068,19070,19072,19074,19076,1,19078,19080,19082,19084,19086,19088,19090,19092,19094,19096,19098,19100,19102,19104,19106,1,19108,19110,19112,19114,19116,19118,19120,19122,19124,19126,19128,
	19965,19964,18849,18848,17763,17765,17767,17769,17771,17773,17775,0,17777,17779,17781,17783,17785,17787,17789,17791,17793,17795,17797,17799,17801,17803,17805,0,17807,17809,17811,17813,17815,17817,17819,17821,17823,17825,17827,17829,17831,17833,17835,0,17837,17839,17841,17843,17845,17847,17849,17851,17853,17855,17857,17859,17861,17863,17865,0,17867,17869,17871,17873,17875,17877,17879,17881,17883,17885,17887,17889,17891,17893,17895,0,17897,17899,17901,17903,17905,17907,17909,17911,17913,17915,17917,17919,17921,17923,17925,0,17927,17929,17931,17933,17935,17937,17939,17941,17943,17945,17947,17949,17951,17953,17955,0,17957,17959,17961,17963,17965,17967,17969,17971,17973,17975,17977,17979,17981,17983,17985,0,17987,17989,17991,17993,17995,17997,17999,18001,18003,18005,18007,18009,18011,18013,18015,0,18017,18019,18021,18023,18025,18027,18029,18031,18033,19130,19131,
	19963,19962,18847,18846,17762,17764,17766,17768,17770,17772,17774,1,17776,17778,17780,17782,17784,17786,17788,17790,17792,17794,17796,17798,17800,17802,17804,1,17806,17808,17810,17812,17814,17816,17818,17820,17822,17824,17826,17828,17830,17832,17834,1,17836,17838,17840,17842,17844,17846,17848,17850,17852,17854,17856,17858,17860,17862,17864,1,17866,17868,17870,17872,17874,17876,17878,17880,17882,17884,17886,17888,17890,17892,17894,1,17896,17898,17900,17902,17904,17906,17908,17910,17912,17914,17916,17918,17920,17922,17924,1,17926,17928,17930,17932,17934,17936,17938,17940,17942,17944,17946,17948,17950,17952,17954,1,17956,17958,17960,17962,17964,17966,17968,17970,17972,17974,17976,17978,17980,17982,17984,1,17986,17988,17990,17992,17994,17996,17998,18000,18002,18004,18006,18008,18010,18012,18014,1,18016,18018,18020,18022,18024,18026,18028,18030,18032,19132,19133,
	19961,19960,18845,18844,17761,17760,16707,16709,16711,16713,16715,0,16717,16719,16721,16723,16725,16727,16729,16731,16733,16735,16737,16739,16741,16743,16745,0,16747,16749,16751,16753,16755,16757,16759,16761,16763,16765,16767,16769,16771,16773,16775,0,16777,16779,16781,16783,16785,16787,16789,16791,16793,16795,16797,16799,16801,16803,16805,0,16807,16809,16811,16813,16815,16817,16819,16821,16823,16825,16827,16829,16831,16833,16835,0,16837,16839,16841,16843,16845,16847,16849,16851,16853,16855,16857,16859,16861,16863,16865,0,16867,16869,16871,16873,16875,16877,16879,16881,16883,16885,16887,16889,16891,16893,16895,0,16897,16899,16901,16903,16905,16907,16909,16911,16913,16915,16917,16919,16921,16923,16925,0,16927,16929,16931,16933,16935,16937,16939,16941,16943,16945,16947,16949,16951,16953,16955,0,16957,16959,16961,16963,16965,16967,16969,18034,18035,19134,19135,
	19959,19958,18843,18842,17759,17758,16706,16708,16710,16712,16714,1,16716,16718,16720,16722,16724,16726,16728,16730,16732,16734,16736,16738,16740,16742,16744,1,16746,16748,16750,16752,16754,16756,16758,16760,16762,16764,16766,16768,16770,16772,16774,1,16776,16778,16780,16782,16784,16786,16788,16790,16792,16794,16796,16798,16800,16802,16804,1,16806,16808,16810,16812,16814,16816,16818,16820,16822,16824,16826,16828,16830,16832,16834,1,16836,16838,16840,16842,16844,16846,16848,16850,16852,16854,16856,16858,16860,16862,16864,1,16866,16868,16870,16872,16874,16876,16878,16880,16882,16884,16886,16888,16890,16892,16894,1,16896,16898,16900,16902,16904,16906,16908,16910,16912,16914,16916,16918,16920,16922,16924,1,16926,16928,16930,16932,16934,16936,16938,16940,16942,16944,16946,16948,16950,16952,16954,1,16956,16958,16960,16962,16964,16966,16968,18036,18037,19136,19137,
	19957,19956,18841,18840,17757,17756,16705,16704,15683,15685,15687,0,15689,15691,15693,15695,15697,15699,15701,15703,15705,15707,15709,15711,15713,15715,15717,0,15719,15721,15723,15725,15727,15729,15731,15733,15735,15737,15739,15741,15743,15745,15747,0,15749,15751,15753,15755,15757,15759,15761,15763,15765,15767,15769,15771,15773,15775,15777,0,15779,15781,15783,15785,15787,15789,15791,15793,15795,15797,15799,15801,15803,15805,15807,0,15809,15811,15813,15815,15817,15819,15821,15823,15825,15827,15829,15831,15833,15835,15837,0,15839,15841,15843,15845,15847,15849,15851,15853,15855,15857,15859,15861,15863,15865,15867,0,15869,15871,15873,15875,15877,15879,15881,15883,15885,15887,15889,15891,15893,15895,15897,0,15899,15901,15903,15905,15907,15909,15911,15913,15915,15917,15919,15921,15923,15925,15927,0,15929,15931,15933,15935,15937,16970,16971,18038,18039,19138,19139,
	19955,19954,18839,18838,17755,17754,16703,16702,15682,15684,15686,1,15688,15690,15692,15694,15696,15698,15700,15702,15704,15706,15708,15710,15712,15714,15716,1,15718,15720,15722,15724,15726,15728,15730,15732,15734,15736,15738,15740,15742,15744,15746,1,15748,15750,15752,15754,15756,15758,15760,15762,15764,15766,15768,15770,15772,15774,15776,1,15778,15780,15782,15784,15786,15788,15790,15792,15794,15796,15798,15800,15802,15804,15806,1,15808,15810,15812,15814,15816,15818,15820,15822,15824,15826,15828,15830,15832,15834,15836,1,15838,15840,15842,15844,15846,15848,15850,15852,15854,15856,15858,15860,15862,15864,15866,1,15868,15870,15872,15874,15876,15878,15880,15882,15884,15886,15888,15890,15892,15894,15896,1,15898,15900,15902,15904,15906,15908,15910,15912,15914,15916,15918,15920,15922,15924,15926,1,15928,15930,15932,15934,15936,16972,16973,18040,18041,19140,19141,
	19953,19952,18837,18836,17753,17752,16701,16700,15681,15680,14691,0,14693,14695,14697,14699,14701,14703,14705,14707,14709,14711,14713,14715,14717,14719,14721,0,14723,14725,14727,14729,14731,14733,14735,14737,14739,14741,14743,14745,14747,14749,14751,0,14753,14755,14757,14759,14761,14763,14765,14767,14769,14771,14773,14775,14777,14779,14781,0,14783,14785,14787,14789,14791,14793,14795,14797,14799,14801,14803,14805,14807,14809,14811,0,14813,14815,14817,14819,14821,14823,14825,14827,14829,14831,14833,14835,14837,14839,14841,0,14843,14845,14847,14849,14851,14853,14855,14857,14859,14861,14863,14865,14867,14869,14871,0,14873,14875,14877,14879,14881,14883,14885,14887,14889,14891,14893,14895,14897,14899,14901,0,14903,14905,14907,14909,14911,14913,14915,14917,14919,14921,14923,14925,14927,14929,14931,0,14933,14935,14937,15938,15939,16974,16975,18042,18043,19142,19143,
	19951,19950,18835,18834,17751,17750,16699,16698,15679,15678,14690,1,14692,14694,14696,14698,14700,14702,14704,14706,14708,14710,14712,14714,14716,14718,14720,1,14722,14724,14726,14728,14730,14732,14734,14736,14738,14740,14742,14744,14746,14748,14750,1,14752,14754,14756,14758,14760,14762,14764,14766,14768,14770,14772,14774,14776,14778,14780,1,14782,14784,14786,14788,14790,14792,14794,14796,14798,14800,14802,14804,14806,14808,14810,1,14812,14814,14816,14818,14820,14822,14824,14826,14828,14830,14832,14834,14836,14838,14840,1,14842,14844,14846,14848,14850,14852,14854,14856,14858,14860,14862,14864,14866,14868,14870,1,14872,14874,14876,14878,14880,14882,14884,14886,14888,14890,14892,14894,14896,14898,14900,1,14902,14904,14906,14908,14910,14912,14914,14916,14918,14920,14922,14924,14926,14928,14930,1,14932,14934,14936,15940,15941,16976,16977,18044,18045,19144,19145,
	19949,19948,18833,18832,17749,17748,16697,16696,15677,15676,14689,0,14688,13731,13733,13735,13737,13739,13741,13743,13745,13747,13749,13751,13753,13755,13757,0,13759,13761,13763,13765,13767,13769,13771,13773,13775,13777,13779,13781,13783,13785,13787,0,13789,13791,13793,13795,13797,13799,13801,13803,13805,13807,13809,13811,13813,13815,13817,0,13819,13821,13823,13825,13827,13829,13831,13833,13835,13837,13839,13841,13843,13845,13847,0,13849,13851,13853,13855,13857,13859,13861,13863,13865,13867,13869,13871,13873,13875,13877,0,13879,13881,13883,13885,13887,13889,13891,13893,13895,13897,13899,13901,13903,13905,13907,0,13909,13911,13913,13915,13917,13919,13921,13923,13925,13927,13929,13931,13933,13935,13937,0,13939,13941,13943,13945,13947,13949,13951,13953,13955,13957,13959,13961,13963,13965,13967,0,13969,14938,14939,15942,15943,16978,16979,18046,18047,19146,19147,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19947,19946,18831,18830,17747,17746,16695,16694,15675,15674,14687,0,14686,13730,13732,13734,13736,13738,13740,13742,13744,13746,13748,13750,13752,13754,13756,0,13758,13760,13762,13764,13766,13768,13770,13772,13774,13776,13778,13780,13782,13784,13786,0,13788,13790,13792,13794,13796,13798,13800,13802,13804,13806,13808,13810,13812,13814,13816,0,13818,13820,13822,13824,13826,13828,13830,13832,13834,13836,13838,13840,13842,13844,13846,0,13848,13850,13852,13854,13856,13858,13860,13862,13864,13866,13868,13870,13872,13874,13876,0,13878,13880,13882,13884,13886,13888,13890,13892,13894,13896,13898,13900,13902,13904,13906,0,13908,13910,13912,13914,13916,13918,13920,13922,13924,13926,13928,13930,13932,13934,13936,0,13938,13940,13942,13944,13946,13948,13950,13952,13954,13956,13958,13960,13962,13964,13966,0,13968,14940,14941,15944,15945,16980,16981,18048,18049,19148,19149,
	19945,19944,18829,18828,17745,17744,16693,16692,15673,15672,14685,1,14684,13729,13728,12803,12805,12807,12809,12811,12813,12815,12817,12819,12821,12823,12825,1,12827,12829,12831,12833,12835,12837,12839,12841,12843,12845,12847,12849,12851,12853,12855,1,12857,12859,12861,12863,12865,12867,12869,12871,12873,12875,12877,12879,12881,12883,12885,1,12887,12889,12891,12893,12895,12897,12899,12901,12903,12905,12907,12909,12911,12913,12915,1,12917,12919,12921,12923,12925,12927,12929,12931,12933,12935,12937,12939,12941,12943,12945,1,12947,12949,12951,12953,12955,12957,12959,12961,12963,12965,12967,12969,12971,12973,12975,1,12977,12979,12981,12983,12985,12987,12989,12991,12993,12995,12997,12999,13001,13003,13005,1,13007,13009,13011,13013,13015,13017,13019,13021,13023,13025,13027,13029,13031,13033,13970,1,13971,14942,14943,15946,15947,16982,16983,18050,18051,19150,19151,
	19943,19942,18827,18826,17743,17742,16691,16690,15671,15670,14683,0,14682,13727,13726,12802,12804,12806,12808,12810,12812,12814,12816,12818,12820,12822,12824,0,12826,12828,12830,12832,12834,12836,12838,12840,12842,12844,12846,12848,12850,12852,12854,0,12856,12858,12860,12862,12864,12866,12868,12870,12872,12874,12876,12878,12880,12882,12884,0,12886,12888,12890,12892,12894,12896,12898,12900,12902,12904,12906,12908,12910,12912,12914,0,12916,12918,12920,12922,12924,12926,12928,12930,12932,12934,12936,12938,12940,12942,12944,0,12946,12948,12950,12952,12954,12956,12958,12960,12962,12964,12966,12968,12970,12972,12974,0,12976,12978,12980,12982,12984,12986,12988,12990,12992,12994,12996,12998,13000,13002,13004,0,13006,13008,13010,13012,13014,13016,13018,13020,13022,13024,13026,13028,13030,13032,13972,0,13973,14944,14945,15948,15949,16984,16985,18052,18053,19152,19153,
	19941,19940,18825,18824,17741,17740,16689,16688,15669,15668,14681,1,14680,13725,13724,12801,12800,11907,11909,11911,11913,11915,11917,11919,11921,11923,11925,1,11927,11929,11931,11933,11935,11937,11939,11941,11943,11945,11947,11949,11951,11953,11955,1,11957,11959,11961,11963,11965,11967,11969,11971,11973,11975,11977,11979,11981,11983,11985,1,11987,11989,11991,11993,11995,11997,11999,12001,12003,12005,12007,12009,12011,12013,12015,1,12017,12019,12021,12023,12025,12027,12029,12031,12033,12035,12037,12039,12041,12043,12045,1,12047,12049,12051,12053,12055,12057,12059,12061,12063,12065,12067,12069,12071,12073,12075,1,12077,12079,12081,12083,12085,12087,12089,12091,12093,12095,12097,12099,12101,12103,12105,1,12107,12109,12111,12113,12115,12117,12119,12121,12123,12125,12127,12129,13034,13035,13974,1,13975,14946,14947,15950,15951,16986,16987,18054,18055,19154,19155,
	19939,19938,18823,18822,17739,17738,16687,16686,15667,15666,14679,0,14678,13723,13722,12799,12798,11906,11908,11910,11912,11914,11916,11918,11920,11922,11924,0,11926,11928,11930,11932,11934,11936,11938,11940,11942,11944,11946,11948,11950,11952,11954,0,11956,11958,11960,11962,11964,11966,11968,11970,11972,11974,11976,11978,11980,11982,11984,0,11986,11988,11990,11992,11994,11996,11998,12000,12002,12004,12006,12008,12010,12012,12014,0,12016,12018,12020,12022,12024,12026,12028,12030,12032,12034,12036,12038,12040,12042,12044,0,12046,12048,12050,12052,12054,12056,12058,12060,12062,12064,12066,12068,12070,12072,12074,0,12076,12078,12080,12082,12084,12086,12088,12090,12092,12094,12096,12098,12100,12102,12104,0,12106,12108,12110,12112,12114,12116,12118,12120,12122,12124,12126,12128,13036,13037,13976,0,13977,14948,14949,15952,15953,16988,16989,18056,18057,19156,19157,
	19937,19936,18821,18820,17737,17736,16685,16684,15665,15664,14677,1,14676,13721,13720,12797,12796,11905,11904,11043,11045,11047,11049,11051,11053,11055,11057,1,11059,11061,11063,11065,11067,11069,11071,11073,11075,11077,11079,11081,11083,11085,11087,1,11089,11091,11093,11095,11097,11099,11101,11103,11105,11107,11109,11111,11113,11115,11117,1,11119,11121,11123,11125,11127,11129,11131,11133,11135,11137,11139,11141,11143,11145,11147,1,11149,11151,11153,11155,11157,11159,11161,11163,11165,11167,11169,11171,11173,11175,11177,1,11179,11181,11183,11185,11187,11189,11191,11193,11195,11197,11199,11201,11203,11205,11207,1,11209,11211,11213,11215,11217,11219,11221,11223,11225,11227,11229,11231,11233,11235,11237,1,11239,11241,11243,11245,11247,11249,11251,11253,11255,11257,12130,12131,13038,13039,13978,1,13979,14950,14951,15954,15955,16990,16991,18058,18059,19158,19159,
	19935,19934,18819,18818,17735,17734,16683,16682,15663,15662,14675,0,14674,13719,13718,12795,12794,11903,11902,11042,11044,11046,11048,11050,11052,11054,11056,0,11058,11060,11062,11064,11066,11068,11070,11072,11074,11076,11078,11080,11082,11084,11086,0,11088,11090,11092,11094,11096,11098,11100,11102,11104,11106,11108,11110,11112,11114,11116,0,11118,11120,11122,11124,11126,11128,11130,11132,11134,11136,11138,11140,11142,11144,11146,0,11148,11150,11152,11154,11156,11158,11160,11162,11164,11166,11168,11170,11172,11174,11176,0,11178,11180,11182,11184,11186,11188,11190,11192,11194,11196,11198,11200,11202,11204,11206,0,11208,11210,11212,11214,11216,11218,11220,11222,11224,11226,11228,11230,11232,11234,11236,0,11238,11240,11242,11244,11246,11248,11250,11252,11254,11256,12132,12133,13040,13041,13980,0,13981,14952,14953,15956,15957,16992,16993,18060,18061,19160,19161,
	19933,19932,18817,18816,17733,17732,16681,16680,15661,15660,14673,1,14672,13717,13716,12793,12792,11901,11900,11041,11040,10211,10213,10215,10217,10219,10221,1,10223,10225,10227,10229,10231,10233,10235,10237,10239,10241,10243,10245,10247,10249,10251,1,10253,10255,10257,10259,10261,10263,10265,10267,10269,10271,10273,10275,10277,10279,10281,1,10283,10285,10287,10289,10291,10293,10295,10297,10299,10301,10303,10305,10307,10309,10311,1,10313,10315,10317,10319,10321,10323,10325,10327,10329,10331,10333,10335,10337,10339,10341,1,10343,10345,10347,10349,10351,10353,10355,10357,10359,10361,10363,10365,10367,10369,10371,1,10373,10375,10377,10379,10381,10383,10385,10387,10389,10391,10393,10395,10397,10399,10401,1,10403,10405,10407,10409,10411,10413,10415,10417,11258,11259,12134,12135,13042,13043,13982,1,13983,14954,14955,15958,15959,16994,16995,18062,18063,19162,19163,
	19931,19930,18815,18814,17731,17730,16679,16678,15659,15658,14671,0,14670,13715,13714,12791,12790,11899,11898,11039,11038,10210,10212,10214,10216,10218,10220,0,10222,10224,10226,10228,10230,10232,10234,10236,10238,10240,10242,10244,10246,10248,10250,0,10252,10254,10256,10258,10260,10262,10264,10266,10268,10270,10272,10274,10276,10278,10280,0,10282,10284,10286,10288,10290,10292,10294,10296,10298,10300,10302,10304,10306,10308,10310,0,10312,10314,10316,10318,10320,10322,10324,10326,10328,10330,10332,10334,10336,10338,10340,0,10342,10344,10346,10348,10350,10352,10354,10356,10358,10360,10362,10364,10366,10368,10370,0,10372,10374,10376,10378,10380,10382,10384,10386,10388,10390,10392,10394,10396,10398,10400,0,10402,10404,10406,10408,10410,10412,10414,10416,11260,11261,12136,12137,13044,13045,13984,0,13985,14956,14957,15960,15961,16996,16997,18064,18065,19164,19165,
	19929,19928,18813,18812,17729,17728,16677,16676,15657,15656,14669,1,14668,13713,13712,12789,12788,11897,11896,11037,11036,10209,10208,9411,9413,9415,9417,1,9419,9421,9423,9425,9427,9429,9431,9433,9435,9437,9439,9441,9443,9445,9447,1,9449,9451,9453,9455,9457,9459,9461,9463,9465,9467,9469,9471,9473,9475,9477,1,9479,9481,9483,9485,9487,9489,9491,9493,9495,9497,9499,9501,9503,9505,9507,1,9509,9511,9513,9515,9517,9519,9521,9523,9525,9527,9529,9531,9533,9535,9537,1,9539,9541,9543,9545,9547,9549,9551,9553,9555,9557,9559,9561,9563,9565,9567,1,9569,9571,9573,9575,9577,9579,9581,9583,9585,9587,9589,9591,9593,9595,9597,1,9599,9601,9603,9605,9607,9609,10418,10419,11262,11263,12138,12139,13046,13047,13986,1,13987,14958,14959,15962,15963,16998,16999,18066,18067,19166,19167,
	19927,19926,18811,18810,17727,17726,16675,16674,15655,15654,14667,0,14666,13711,13710,12787,12786,11895,11894,11035,11034,10207,10206,9410,9412,9414,9416,0,9418,9420,9422,9424,9426,9428,9430,9432,9434,9436,9438,9440,9442,9444,9446,0,9448,9450,9452,9454,9456,9458,9460,9462,9464,9466,9468,9470,9472,9474,9476,0,9478,9480,9482,9484,9486,9488,9490,9492,9494,9496,9498,9500,9502,9504,9506,0,9508,9510,9512,9514,9516,9518,9520,9522,9524,9526,9528,9530,9532,9534,9536,0,9538,9540,9542,9544,9546,9548,9550,9552,9554,9556,9558,9560,9562,9564,9566,0,9568,9570,9572,9574,9576,9578,9580,9582,9584,9586,9588,9590,9592,9594,9596,0,9598,9600,9602,9604,9606,9608,10420,10421,11264,11265,12140,12141,13048,13049,13988,0,13989,14960,14961,15964,15965,17000,17001,18068,18069,19168,19169,
	19925,19924,18809,18808,17725,17724,16673,16672,15653,15652,14665,1,14664,13709,13708,12785,12784,11893,11892,11033,11032,10205,10204,9409,9408,8643,8645,1,8647,8649,8651,8653,8655,8657,8659,8661,8663,8665,8667,8669,8671,8673,8675,1,8677,8679,8681,8683,8685,8687,8689,8691,8693,8695,8697,8699,8701,8703,8705,1,8707,8709,8711,8713,8715,8717,8719,8721,8723,8725,8727,8729,8731,8733,8735,1,8737,8739,8741,8743,8745,8747,8749,8751,8753,8755,8757,8759,8761,8763,8765,1,8767,8769,8771,8773,8775,8777,8779,8781,8783,8785,8787,8789,8791,8793,8795,1,8797,8799,8801,8803,8805,8807,8809,8811,8813,8815,8817,8819,8821,8823,8825,1,8827,8829,8831,8833,9610,9611,10422,10423,11266,11267,12142,12143,13050,13051,13990,1,13991,14962,14963,15966,15967,17002,17003,18070,18071,19170,19171,
	19923,19922,18807,18806,17723,17722,16671,16670,15651,15650,14663,0,14662,13707,13706,12783,12782,11891,11890,11031,11030,10203,10202,9407,9406,8642,8644,0,8646,8648,8650,8652,8654,8656,8658,8660,8662,8664,8666,8668,8670,8672,8674,0,8676,8678,8680,8682,8684,8686,8688,8690,8692,8694,8696,8698,8700,8702,8704,0,8706,8708,8710,8712,8714,8716,8718,8720,8722,8724,8726,8728,8730,8732,8734,0,8736,8738,8740,8742,8744,8746,8748,8750,8752,8754,8756,8758,8760,8762,8764,0,8766,8768,8770,8772,8774,8776,8778,8780,8782,8784,8786,8788,8790,8792,8794,0,8796,8798,8800,8802,8804,8806,8808,8810,8812,8814,8816,8818,8820,8822,8824,0,8826,8828,8830,8832,9612,9613,10424,10425,11268,11269,12144,12145,13052,13053,13992,0,13993,14964,14965,15968,15969,17004,17005,18072,18073,19172,19173,
	19921,19920,18805,18804,17721,17720,16669,16668,15649,15648,14661,1,14660,13705,13704,12781,12780,11889,11888,11029,11028,10201,10200,9405,9404,8641,8640,1,7907,7909,7911,7913,7915,7917,7919,7921,7923,7925,7927,7929,7931,7933,7935,1,7937,7939,7941,7943,7945,7947,7949,7951,7953,7955,7957,7959,7961,7963,7965,1,7967,7969,7971,7973,7975,7977,7979,7981,7983,7985,7987,7989,7991,7993,7995,1,7997,7999,8001,8003,8005,8007,8009,8011,8013,8015,8017,8019,8021,8023,8025,1,8027,8029,8031,8033,8035,8037,8039,8041,8043,8045,8047,8049,8051,8053,8055,1,8057,8059,8061,8063,8065,8067,8069,8071,8073,8075,8077,8079,8081,8083,8085,1,8087,8089,8834,8835,9614,9615,10426,10427,11270,11271,12146,12147,13054,13055,13994,1,13995,14966,14967,15970,15971,17006,17007,18074,18075,19174,19175,
	19919,19918,18803,18802,17719,17718,16667,16666,15647,15646,14659,0,14658,13703,13702,12779,12778,11887,11886,11027,11026,10199,10198,9403,9402,8639,8638,0,7906,7908,7910,7912,7914,7916,7918,7920,7922,7924,7926,7928,7930,7932,7934,0,7936,7938,7940,7942,7944,7946,7948,7950,7952,7954,7956,7958,7960,7962,7964,0,7966,7968,7970,7972,7974,7976,7978,7980,7982,7984,7986,7988,7990,7992,7994,0,7996,7998,8000,8002,8004,8006,8008,8010,8012,8014,8016,8018,8020,8022,8024,0,8026,8028,8030,8032,8034,8036,8038,8040,8042,8044,8046,8048,8050,8052,8054,0,8056,8058,8060,8062,8064,8066,8068,8070,8072,8074,8076,8078,8080,8082,8084,0,8086,8088,8836,8837,9616,9617,10428,10429,11272,11273,12148,12149,13056,13057,13996,0,13997,14968,14969,15972,15973,17008,17009,18076,18077,19176,19177,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19917,19916,18801,18800,17717,17716,16665,16664,15645,15644,14657,0,14656,13701,13700,12777,12776,11885,11884,11025,11024,10197,10196,9401,9400,8637,8636,0,7905,7904,7203,7205,7207,7209,7211,7213,7215,7217,7219,7221,7223,7225,7227,0,7229,7231,7233,7235,7237,7239,7241,7243,7245,7247,7249,7251,7253,7255,7257,0,7259,7261,7263,7265,7267,7269,7271,7273,7275,7277,7279,7281,7283,7285,7287,0,7289,7291,7293,7295,7297,7299,7301,7303,7305,7307,7309,7311,7313,7315,7317,0,7319,7321,7323,7325,7327,7329,7331,7333,7335,7337,7339,7341,7343,7345,7347,0,7349,7351,7353,7355,7357,7359,7361,7363,7365,7367,7369,7371,7373,7375,7377,0,8090,8091,8838,8839,9618,9619,10430,10431,11274,11275,12150,12151,13058,13059,13998,0,13999,14970,14971,15974,15975,17010,17011,18078,18079,19178,19179,
	19915,19914,18799,18798,17715,17714,16663,16662,15643,15642,14655,1,14654,13699,13698,12775,12774,11883,11882,11023,11022,10195,10194,9399,9398,8635,8634,1,7903,7902,7202,7204,7206,7208,7210,7212,7214,7216,7218,7220,7222,7224,7226,1,7228,7230,7232,7234,7236,7238,7240,7242,7244,7246,7248,7250,7252,7254,7256,1,7258,7260,7262,7264,7266,7268,7270,7272,7274,7276,7278,7280,7282,7284,7286,1,7288,7290,7292,7294,7296,7298,7300,7302,7304,7306,7308,7310,7312,7314,7316,1,7318,7320,7322,7324,7326,7328,7330,7332,7334,7336,7338,7340,7342,7344,7346,1,7348,7350,7352,7354,7356,7358,7360,7362,7364,7366,7368,7370,7372,7374,7376,1,8092,8093,8840,8841,9620,9621,10432,10433,11276,11277,12152,12153,13060,13061,14000,1,14001,14972,14973,15976,15977,17012,17013,18080,18081,19180,19181,
	19913,19912,18797,18796,17713,17712,16661,16660,15641,15640,14653,0,14652,13697,13696,12773,12772,11881,11880,11021,11020,10193,10192,9397,9396,8633,8632,0,7901,7900,7201,7200,6531,6533,6535,6537,6539,6541,6543,6545,6547,6549,6551,0,6553,6555,6557,6559,6561,6563,6565,6567,6569,6571,6573,6575,6577,6579,6581,0,6583,6585,6587,6589,6591,6593,6595,6597,6599,6601,6603,6605,6607,6609,6611,0,6613,6615,6617,6619,6621,6623,6625,6627,6629,6631,6633,6635,6637,6639,6641,0,6643,6645,6647,6649,6651,6653,6655,6657,6659,6661,6663,6665,6667,6669,6671,0,6673,6675,6677,6679,6681,6683,6685,6687,6689,6691,6693,6695,6697,7378,7379,0,8094,8095,8842,8843,9622,9623,10434,10435,11278,11279,12154,12155,13062,13063,14002,0,14003,14974,14975,15978,15979,17014,17015,18082,18083,19182,19183,
	19911,19910,18795,18794,17711,17710,16659,16658,15639,15638,14651,1,14650,13695,13694,12771,12770,11879,11878,11019,11018,10191,10190,9395,9394,8631,8630,1,7899,7898,7199,7198,6530,6532,6534,6536,6538,6540,6542,6544,6546,6548,6550,1,6552,6554,6556,6558,6560,6562,6564,6566,6568,6570,6572,6574,6576,6578,6580,1,6582,6584,6586,6588,6590,6592,6594,6596,6598,6600,6602,6604,6606,6608,6610,1,6612,6614,6616,6618,6620,6622,6624,6626,6628,6630,6632,6634,6636,6638,6640,1,6642,6644,6646,6648,6650,6652,6654,6656,6658,6660,6662,6664,6666,6668,6670,1,6672,6674,6676,6678,6680,6682,6684,6686,6688,6690,6692,6694,6696,7380,7381,1,8096,8097,8844,8845,9624,9625,10436,10437,11280,11281,12156,12157,13064,13065,14004,1,14005,14976,14977,15980,15981,17016,17017,18084,18085,19184,19185,
	19909,19908,18793,18792,17709,17708,16657,16656,15637,15636,14649,0,14648,13693,13692,12769,12768,11877,11876,11017,11016,10189,10188,9393,9392,8629,8628,0,7897,7896,7197,7196,6529,6528,5891,5893,5895,5897,5899,5901,5903,5905,5907,0,5909,5911,5913,5915,5917,5919,5921,5923,5925,5927,5929,5931,5933,5935,5937,0,5939,5941,5943,5945,5947,5949,5951,5953,5955,5957,5959,5961,5963,5965,5967,0,5969,5971,5973,5975,5977,5979,5981,5983,5985,5987,5989,5991,5993,5995,5997,0,5999,6001,6003,6005,6007,6009,6011,6013,6015,6017,6019,6021,6023,6025,6027,0,6029,6031,6033,6035,6037,6039,6041,6043,6045,6047,6049,6698,6699,7382,7383,0,8098,8099,8846,8847,9626,9627,10438,10439,11282,11283,12158,12159,13066,13067,14006,0,14007,14978,14979,15982,15983,17018,17019,18086,18087,19186,19187,
	19907,19906,18791,18790,17707,17706,16655,16654,15635,15634,14647,1,14646,13691,13690,12767,12766,11875,11874,11015,11014,10187,10186,9391,9390,8627,8626,1,7895,7894,7195,7194,6527,6526,5890,5892,5894,5896,5898,5900,5902,5904,5906,1,5908,5910,5912,5914,5916,5918,5920,5922,5924,5926,5928,5930,5932,5934,5936,1,5938,5940,5942,5944,5946,5948,5950,5952,5954,5956,5958,5960,5962,5964,5966,1,5968,5970,5972,5974,5976,5978,5980,5982,5984,5986,5988,5990,5992,5994,5996,1,5998,6000,6002,6004,6006,6008,6010,6012,6014,6016,6018,6020,6022,6024,6026,1,6028,6030,6032,6034,6036,6038,6040,6042,6044,6046,6048,6700,6701,7384,7385,1,8100,8101,8848,8849,9628,9629,10440,10441,11284,11285,12160,12161,13068,13069,14008,1,14009,14980,14981,15984,15985,17020,17021,18088,18089,19188,19189,
	19905,19904,18789,18788,17705,17704,16653,16652,15633,15632,14645,0,14644,13689,13688,12765,12764,11873,11872,11013,11012,10185,10184,9389,9388,8625,8624,0,7893,7892,7193,7192,6525,6524,5889,5888,5283,5285,5287,5289,5291,5293,5295,0,5297,5299,5301,5303,5305,5307,5309,5311,5313,5315,5317,5319,5321,5323,5325,0,5327,5329,5331,5333,5335,5337,5339,5341,5343,5345,5347,5349,5351,5353,5355,0,5357,5359,5361,5363,5365,5367,5369,5371,5373,5375,5377,5379,5381,5383,5385,0,5387,5389,5391,5393,5395,5397,5399,5401,5403,5405,5407,5409,5411,5413,5415,0,5417,5419,5421,5423,5425,5427,5429,5431,5433,6050,6051,6702,6703,7386,7387,0,8102,8103,8850,8851,9630,9631,10442,10443,11286,11287,12162,12163,13070,13071,14010,0,14011,14982,14983,15986,15987,17022,17023,18090,18091,19190,19191,
	19903,19902,18787,18786,17703,17702,16651,16650,15631,15630,14643,1,14642,13687,13686,12763,12762,11871,11870,11011,11010,10183,10182,9387,9386,8623,8622,1,7891,7890,7191,7190,6523,6522,5887,5886,5282,5284,5286,5288,5290,5292,5294,1,5296,5298,5300,5302,5304,5306,5308,5310,5312,5314,5316,5318,5320,5322,5324,1,5326,5328,5330,5332,5334,5336,5338,5340,5342,5344,5346,5348,5350,5352,5354,1,5356,5358,5360,5362,5364,5366,5368,5370,5372,5374,5376,5378,5380,5382,5384,1,5386,5388,5390,5392,5394,5396,5398,5400,5402,5404,5406,5408,5410,5412,5414,1,5416,5418,5420,5422,5424,5426,5428,5430,5432,6052,6053,6704,6705,7388,7389,1,8104,8105,8852,8853,9632,9633,10444,10445,11288,11289,12164,12165,13072,13073,14012,1,14013,14984,14985,15988,15989,17024,17025,18092,18093,19192,19193,
	19901,19900,18785,18784,17701,17700,16649,16648,15629,15628,14641,0,14640,13685,13684,12761,12760,11869,11868,11009,11008,10181,10180,9385,9384,8621,8620,0,7889,7888,7189,7188,6521,6520,5885,5884,5281,5280,4707,4709,4711,4713,4715,0,4717,4719,4721,4723,4725,4727,4729,4731,4733,4735,4737,4739,4741,4743,4745,0,4747,4749,4751,4753,4755,4757,4759,4761,4763,4765,4767,4769,4771,4773,4775,0,4777,4779,4781,4783,4785,4787,4789,4791,4793,4795,4797,4799,4801,4803,4805,0,4807,4809,4811,4813,4815,4817,4819,4821,4823,4825,4827,4829,4831,4833,4835,0,4837,4839,4841,4843,4845,4847,4849,5434,5435,6054,6055,6706,6707,7390,7391,0,8106,8107,8854,8855,9634,9635,10446,10447,11290,11291,12166,12167,13074,13075,14014,0,14015,14986,14987,15990,15991,17026,17027,18094,18095,19194,19195,
	19899,19898,18783,18782,17699,17698,16647,16646,15627,15626,14639,1,14638,13683,13682,12759,12758,11867,11866,11007,11006,10179,10178,9383,9382,8619,8618,1,7887,7886,7187,7186,6519,6518,5883,5882,5279,5278,4706,4708,4710,4712,4714,1,4716,4718,4720,4722,4724,4726,4728,4730,4732,4734,4736,4738,4740,4742,4744,1,4746,4748,4750,4752,4754,4756,4758,4760,4762,4764,4766,4768,4770,4772,4774,1,4776,4778,4780,4782,4784,4786,4788,4790,4792,4794,4796,4798,4800,4802,4804,1,4806,4808,4810,4812,4814,4816,4818,4820,4822,4824,4826,4828,4830,4832,4834,1,4836,4838,4840,4842,4844,4846,4848,5436,5437,6056,6057,6708,6709,7392,7393,1,8108,8109,8856,8857,9636,9637,10448,10449,11292,11293,12168,12169,13076,13077,14016,1,14017,14988,14989,15992,15993,17028,17029,18096,18097,19196,19197,
	19897,19896,18781,18780,17697,17696,16645,16644,15625,15624,14637,0,14636,13681,13680,12757,12756,11865,11864,11005,11004,10177,10176,9381,9380,8617,8616,0,7885,7884,7185,7184,6517,6516,5881,5880,5277,5276,4705,4704,4163,4165,4167,0,4169,4171,4173,4175,4177,4179,4181,4183,4185,4187,4189,4191,4193,4195,4197,0,4199,4201,4203,4205,4207,4209,4211,4213,4215,4217,4219,4221,4223,4225,4227,0,4229,4231,4233,4235,4237,4239,4241,4243,4245,4247,4249,4251,4253,4255,4257,0,4259,4261,4263,4265,4267,4269,4271,4273,4275,4277,4279,4281,4283,4285,4287,0,4289,4291,4293,4295,4297,4850,4851,5438,5439,6058,6059,6710,6711,7394,7395,0,8110,8111,8858,8859,9638,9639,10450,10451,11294,11295,12170,12171,13078,13079,14018,0,14019,14990,14991,15994,15995,17030,17031,18098,18099,19198,19199,
	19895,19894,18779,18778,17695,17694,16643,16642,15623,15622,14635,1,14634,13679,13678,12755,12754,11863,11862,11003,11002,10175,10174,9379,9378,8615,8614,1,7883,7882,7183,7182,6515,6514,5879,5878,5275,5274,4703,4702,4162,4164,4166,1,4168,4170,4172,4174,4176,4178,4180,4182,4184,4186,4188,4190,4192,4194,4196,1,4198,4200,4202,4204,4206,4208,4210,4212,4214,4216,4218,4220,4222,4224,4226,1,4228,4230,4232,4234,4236,4238,4240,4242,4244,4246,4248,4250,4252,4254,4256,1,4258,4260,4262,4264,4266,4268,4270,4272,4274,4276,4278,4280,4282,4284,4286,1,4288,4290,4292,4294,4296,4852,4853,5440,5441,6060,6061,6712,6713,7396,7397,1,8112,8113,8860,8861,9640,9641,10452,10453,11296,11297,12172,12173,13080,13081,14020,1,14021,14992,14993,15996,15997,17032,17033,18100,18101,19200,19201,
	19893,19892,18777,18776,17693,17692,16641,16640,15621,15620,14633,0,14632,13677,13676,12753,12752,11861,11860,11001,11000,10173,10172,9377,9376,8613,8612,0,7881,7880,7181,7180,6513,6512,5877,5876,5273,5272,4701,4700,4161,4160,3651,0,3653,3655,3657,3659,3661,3663,3665,3667,3669,3671,3673,3675,3677,3679,3681,0,3683,3685,3687,3689,3691,3693,3695,3697,3699,3701,3703,3705,3707,3709,3711,0,3713,3715,3717,3719,3721,3723,3725,3727,3729,3731,3733,3735,3737,3739,3741,0,3743,3745,3747,3749,3751,3753,3755,3757,3759,3761,3763,3765,3767,3769,3771,0,3773,3775,3777,4298,4299,4854,4855,5442,5443,6062,6063,6714,6715,7398,7399,0,8114,8115,8862,8863,9642,9643,10454,10455,11298,11299,12174,12175,13082,13083,14022,0,14023,14994,14995,15998,15999,17034,17035,18102,18103,19202,19203,
	19891,19890,18775,18774,17691,17690,16639,16638,15619,15618,14631,1,14630,13675,13674,12751,12750,11859,11858,10999,10998,10171,10170,9375,9374,8611,8610,1,7879,7878,7179,7178,6511,6510,5875,5874,5271,5270,4699,4698,4159,4158,3650,1,3652,3654,3656,3658,3660,3662,3664,3666,3668,3670,3672,3674,3676,3678,3680,1,3682,3684,3686,3688,3690,3692,3694,3696,3698,3700,3702,3704,3706,3708,3710,1,3712,3714,3716,3718,3720,3722,3724,3726,3728,3730,3732,3734,3736,3738,3740,1,3742,3744,3746,3748,3750,3752,3754,3756,3758,3760,3762,3764,3766,3768,3770,1,3772,3774,3776,4300,4301,4856,4857,5444,5445,6064,6065,6716,6717,7400,7401,1,8116,8117,8864,8865,9644,9645,10456,10457,11300,11301,12176,12177,13084,13085,14024,1,14025,14996,14997,16000,16001,17036,17037,18104,18105,19204,19205,
	19889,19888,18773,18772,17689,17688,16637,16636,15617,15616,14629,0,14628,13673,13672,12749,12748,11857,11856,10997,10996,10169,10168,9373,9372,8609,8608,0,7877,7876,7177,7176,6509,6508,5873,5872,5269,5268,4697,4696,4157,4156,3649,0,3648,3171,3173,3175,3177,3179,3181,3183,3185,3187,3189,3191,3193,3195,3197,0,3199,3201,3203,3205,3207,3209,3211,3213,3215,3217,3219,3221,3223,3225,3227,0,3229,3231,3233,3235,3237,3239,3241,3243,3245,3247,3249,3251,3253,3255,3257,0,3259,3261,3263,3265,3267,3269,3271,3273,3275,3277,3279,3281,3283,3285,3287,0,3289,3778,3779,4302,4303,4858,4859,5446,5447,6066,6067,6718,6719,7402,7403,0,8118,8119,8866,8867,9646,9647,10458,10459,11302,11303,12178,12179,13086,13087,14026,0,14027,14998,14999,16002,16003,17038,17039,18106,18107,19206,19207,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19887,19886,18771,18770,17687,17686,16635,16634,15615,15614,14627,0,14626,13671,13670,12747,12746,11855,11854,10995,10994,10167,10166,9371,9370,8607,8606,0,7875,7874,7175,7174,6507,6506,5871,5870,5267,5266,4695,4694,4155,4154,3647,0,3646,3170,3172,3174,3176,3178,3180,3182,3184,3186,3188,3190,3192,3194,3196,0,3198,3200,3202,3204,3206,3208,3210,3212,3214,3216,3218,3220,3222,3224,3226,0,3228,3230,3232,3234,3236,3238,3240,3242,3244,3246,3248,3250,3252,3254,3256,0,3258,3260,3262,3264,3266,3268,3270,3272,3274,3276,3278,3280,3282,3284,3286,0,3288,3780,3781,4304,4305,4860,4861,5448,5449,6068,6069,6720,6721,7404,7405,0,8120,8121,8868,8869,9648,9649,10460,10461,11304,11305,12180,12181,13088,13089,14028,0,14029,15000,15001,16004,16005,17040,17041,18108,18109,19208,19209,
	19885,19884,18769,18768,17685,17684,16633,16632,15613,15612,14625,1,14624,13669,13668,12745,12744,11853,11852,10993,10992,10165,10164,9369,9368,8605,8604,1,7873,7872,7173,7172,6505,6504,5869,5868,5265,5264,4693,4692,4153,4152,3645,1,3644,3169,3168,2723,2725,2727,2729,2731,2733,2735,2737,2739,2741,2743,2745,1,2747,2749,2751,2753,2755,2757,2759,2761,2763,2765,2767,2769,2771,2773,2775,1,2777,2779,2781,2783,2785,2787,2789,2791,2793,2795,2797,2799,2801,2803,2805,1,2807,2809,2811,2813,2815,2817,2819,2821,2823,2825,2827,2829,2831,2833,3290,1,3291,3782,3783,4306,4307,4862,4863,5450,5451,6070,6071,6722,6723,7406,7407,1,8122,8123,8870,8871,9650,9651,10462,10463,11306,11307,12182,12183,13090,13091,14030,1,14031,15002,15003,16006,16007,17042,17043,18110,18111,19210,19211,
	19883,19882,18767,18766,17683,17682,16631,16630,15611,15610,14623,0,14622,13667,13666,12743,12742,11851,11850,10991,10990,10163,10162,9367,9366,8603,8602,0,7871,7870,7171,7170,6503,6502,5867,5866,5263,5262,4691,4690,4151,4150,3643,0,3642,3167,3166,2722,2724,2726,2728,2730,2732,2734,2736,2738,2740,2742,2744,0,2746,2748,2750,2752,2754,2756,2758,2760,2762,2764,2766,2768,2770,2772,2774,0,2776,2778,2780,2782,2784,2786,2788,2790,2792,2794,2796,2798,2800,2802,2804,0,2806,2808,2810,2812,2814,2816,2818,2820,2822,2824,2826,2828,2830,2832,3292,0,3293,3784,3785,4308,4309,4864,4865,5452,5453,6072,6073,6724,6725,7408,7409,0,8124,8125,8872,8873,9652,9653,10464,10465,11308,11309,12184,12185,13092,13093,14032,0,14033,15004,15005,16008,16009,17044,17045,18112,18113,19212,19213,
	19881,19880,18765,18764,17681,17680,16629,16628,15609,15608,14621,1,14620,13665,13664,12741,12740,11849,11848,10989,10988,10161,10160,9365,9364,8601,8600,1,7869,7868,7169,7168,6501,6500,5865,5864,5261,5260,4689,4688,4149,4148,3641,1,3640,3165,3164,2721,2720,2307,2309,2311,2313,2315,2317,2319,2321,2323,2325,1,2327,2329,2331,2333,2335,2337,2339,2341,2343,2345,2347,2349,2351,2353,2355,1,2357,2359,2361,2363,2365,2367,2369,2371,2373,2375,2377,2379,2381,2383,2385,1,2387,2389,2391,2393,2395,2397,2399,2401,2403,2405,2407,2409,2834,2835,3294,1,3295,3786,3787,4310,4311,4866,4867,5454,5455,6074,6075,6726,6727,7410,7411,1,8126,8127,8874,8875,9654,9655,10466,10467,11310,11311,12186,12187,13094,13095,14034,1,14035,15006,15007,16010,16011,17046,17047,18114,18115,19214,19215,
	19879,19878,18763,18762,17679,17678,16627,16626,15607,15606,14619,0,14618,13663,13662,12739,12738,11847,11846,10987,10986,10159,10158,9363,9362,8599,8598,0,7867,7866,7167,7166,6499,6498,5863,5862,5259,5258,4687,4686,4147,4146,3639,0,3638,3163,3162,2719,2718,2306,2308,2310,2312,2314,2316,2318,2320,2322,2324,0,2326,2328,2330,2332,2334,2336,2338,2340,2342,2344,2346,2348,2350,2352,2354,0,2356,2358,2360,2362,2364,2366,2368,2370,2372,2374,2376,2378,2380,2382,2384,0,2386,2388,2390,2392,2394,2396,2398,2400,2402,2404,2406,2408,2836,2837,3296,0,3297,3788,3789,4312,4313,4868,4869,5456,5457,6076,6077,6728,6729,7412,7413,0,8128,8129,8876,8877,9656,9657,10468,10469,11312,11313,12188,12189,13096,13097,14036,0,14037,15008,15009,16012,16013,17048,17049,18116,18117,19216,19217,
	19877,19876,18761,18760,17677,17676,16625,16624,15605,15604,14617,1,14616,13661,13660,12737,12736,11845,11844,10985,10984,10157,10156,9361,9360,8597,8596,1,7865,7864,7165,7164,6497,6496,5861,5860,5257,5256,4685,4684,4145,4144,3637,1,3636,3161,3160,2717,2716,2305,2304,1923,1925,1927,1929,1931,1933,1935,1937,1,1939,1941,1943,1945,1947,1949,1951,1953,1955,1957,1959,1961,1963,1965,1967,1,1969,1971,1973,1975,1977,1979,1981,1983,1985,1987,1989,1991,1993,1995,1997,1,1999,2001,2003,2005,2007,2009,2011,2013,2015,2017,2410,2411,2838,2839,3298,1,3299,3790,3791,4314,4315,4870,4871,5458,5459,6078,6079,6730,6731,7414,7415,1,8130,8131,8878,8879,9658,9659,10470,10471,11314,11315,12190,12191,13098,13099,14038,1,14039,15010,15011,16014,16015,17050,17051,18118,18119,19218,19219,
	19875,19874,18759,18758,17675,17674,16623,16622,15603,15602,14615,0,14614,13659,13658,12735,12734,11843,11842,10983,10982,10155,10154,9359,9358,8595,8594,0,7863,7862,7163,7162,6495,6494,5859,5858,5255,5254,4683,4682,4143,4142,3635,0,3634,3159,3158,2715,2714,2303,2302,1922,1924,1926,1928,1930,1932,1934,1936,0,1938,1940,1942,1944,1946,1948,1950,1952,1954,1956,1958,1960,1962,1964,1966,0,1968,1970,1972,1974,1976,1978,1980,1982,1984,1986,1988,1990,1992,1994,1996,0,1998,2000,2002,2004,2006,2008,2010,2012,2014,2016,2412,2413,2840,2841,3300,0,3301,3792,3793,4316,4317,4872,4873,5460,5461,6080,6081,6732,6733,7416,7417,0,8132,8133,8880,8881,9660,9661,10472,10473,11316,11317,12192,12193,13100,13101,14040,0,14041,15012,15013,16016,16017,17052,17053,18120,18121,19220,19221,
	19873,19872,18757,18756,17673,17672,16621,16620,15601,15600,14613,1,14612,13657,13656,12733,12732,11841,11840,10981,10980,10153,10152,9357,9356,8593,8592,1,7861,7860,7161,7160,6493,6492,5857,5856,5253,5252,4681,4680,4141,4140,3633,1,3632,3157,3156,2713,2712,2301,2300,1921,1920,1571,1573,1575,1577,1579,1581,1,1583,1585,1587,1589,1591,1593,1595,1597,1599,1601,1603,1605,1607,1609,1611,1,1613,1615,1617,1619,1621,1623,1625,1627,1629,1631,1633,1635,1637,1639,1641,1,1643,1645,1647,1649,1651,1653,1655,1657,2018,2019,2414,2415,2842,2843,3302,1,3303,3794,3795,4318,4319,4874,4875,5462,5463,6082,6083,6734,6735,7418,7419,1,8134,8135,8882,8883,9662,9663,10474,10475,11318,11319,12194,12195,13102,13103,14042,1,14043,15014,15015,16018,16019,17054,17055,18122,18123,19222,19223,
	19871,19870,18755,18754,17671,17670,16619,16618,15599,15598,14611,0,14610,13655,13654,12731,12730,11839,11838,10979,10978,10151,10150,9355,9354,8591,8590,0,7859,7858,7159,7158,6491,6490,5855,5854,5251,5250,4679,4678,4139,4138,3631,0,3630,3155,3154,2711,2710,2299,2298,1919,1918,1570,1572,1574,1576,1578,1580,0,1582,1584,1586,1588,1590,1592,1594,1596,1598,1600,1602,1604,1606,1608,1610,0,1612,1614,1616,1618,1620,1622,1624,1626,1628,1630,1632,1634,1636,1638,1640,0,1642,1644,1646,1648,1650,1652,1654,1656,2020,2021,2416,2417,2844,2845,3304,0,3305,3796,3797,4320,4321,4876,4877,5464,5465,6084,6085,6736,6737,7420,7421,0,8136,8137,8884,8885,9664,9665,10476,10477,11320,11321,12196,12197,13104,13105,14044,0,14045,15016,15017,16020,16021,17056,17057,18124,18125,19224,19225,
	19869,19868,18753,18752,17669,17668,16617,16616,15597,15596,14609,1,14608,13653,13652,12729,12728,11837,11836,10977,10976,10149,10148,9353,9352,8589,8588,1,7857,7856,7157,7156,6489,6488,5853,5852,5249,5248,4677,4676,4137,4136,3629,1,3628,3153,3152,2709,2708,2297,2296,1917,1916,1569,1568,1251,1253,1255,1257,1,1259,1261,1263,1265,1267,1269,1271,1273,1275,1277,1279,1281,1283,1285,1287,1,1289,1291,1293,1295,1297,1299,1301,1303,1305,1307,1309,1311,1313,1315,1317,1,1319,1321,1323,1325,1327,1329,1658,1659,2022,2023,2418,2419,2846,2847,3306,1,3307,3798,3799,4322,4323,4878,4879,5466,5467,6086,6087,6738,6739,7422,7423,1,8138,8139,8886,8887,9666,9667,10478,10479,11322,11323,12198,12199,13106,13107,14046,1,14047,15018,15019,16022,16023,17058,17059,18126,18127,19226,19227,
	19867,19866,18751,18750,17667,17666,16615,16614,15595,15594,14607,0,14606,13651,13650,12727,12726,11835,11834,10975,10974,10147,10146,9351,9350,8587,8586,0,7855,7854,7155,7154,6487,6486,5851,5850,5247,5246,4675,4674,4135,4134,3627,0,3626,3151,3150,2707,2706,2295,2294,1915,1914,1567,1566,1250,1252,1254,1256,0,1258,1260,1262,1264,1266,1268,1270,1272,1274,1276,1278,1280,1282,1284,1286,0,1288,1290,1292,1294,1296,1298,1300,1302,1304,1306,1308,1310,1312,1314,1316,0,1318,1320,1322,1324,1326,1328,1660,1661,2024,2025,2420,2421,2848,2849,3308,0,3309,3800,3801,4324,4325,4880,4881,5468,5469,6088,6089,6740,6741,7424,7425,0,8140,8141,8888,8889,9668,9669,10480,10481,11324,11325,12200,12201,13108,13109,14048,0,14049,15020,15021,16024,16025,17060,17061,18128,18129,19228,19229,
	19865,19864,18749,18748,17665,17664,16613,16612,15593,15592,14605,1,14604,13649,13648,12725,12724,11833,11832,10973,10972,10145,10144,9349,9348,8585,8584,1,7853,7852,7153,7152,6485,6484,5849,5848,5245,5244,4673,4672,4133,4132,3625,1,3624,3149,3148,2705,2704,2293,2292,1913,1912,1565,1564,1249,1248,963,965,1,967,969,971,973,975,977,979,981,983,985,987,989,991,993,995,1,997,999,1001,1003,1005,1007,1009,1011,1013,1015,1017,1019,1021,1023,1025,1,1027,1029,1031,1033,1330,1331,1662,1663,2026,2027,2422,2423,2850,2851,3310,1,3311,3802,3803,4326,4327,4882,4883,5470,5471,6090,6091,6742,6743,7426,7427,1,8142,8143,8890,8891,9670,9671,10482,10483,11326,11327,12202,12203,13110,13111,14050,1,14051,15022,15023,16026,16027,17062,17063,18130,18131,19230,19231,
	19863,19862,18747,18746,17663,17662,16611,16610,15591,15590,14603,0,14602,13647,13646,12723,12722,11831,11830,10971,10970,10143,10142,9347,9346,8583,8582,0,7851,7850,7151,7150,6483,6482,5847,5846,5243,5242,4671,4670,4131,4130,3623,0,3622,3147,3146,2703,2702,2291,2290,1911,1910,1563,1562,1247,1246,962,964,0,966,968,970,972,974,976,978,980,982,984,986,988,990,992,994,0,996,998,1000,1002,1004,1006,1008,1010,1012,1014,1016,1018,1020,1022,1024,0,1026,1028,1030,1032,1332,1333,1664,1665,2028,2029,2424,2425,2852,2853,3312,0,3313,3804,3805,4328,4329,4884,4885,5472,5473,6092,6093,6744,6745,7428,7429,0,8144,8145,8892,8893,9672,9673,10484,10485,11328,11329,12204,12205,13112,13113,14052,0,14053,15024,15025,16028,16029,17064,17065,18132,18133,19232,19233,
	19861,19860,18745,18744,17661,17660,16609,16608,15589,15588,14601,1,14600,13645,13644,12721,12720,11829,11828,10969,10968,10141,10140,9345,9344,8581,8580,1,7849,7848,7149,7148,6481,6480,5845,5844,5241,5240,4669,4668,4129,4128,3621,1,3620,3145,3144,2701,2700,2289,2288,1909,1908,1561,1560,1245,1244,961,960,1,707,709,711,713,715,717,719,721,723,725,727,729,731,733,735,1,737,739,741,743,745,747,749,751,753,755,757,759,761,763,765,1,767,769,1034,1035,1334,1335,1666,1667,2030,2031,2426,2427,2854,2855,3314,1,3315,3806,3807,4330,4331,4886,4887,5474,5475,6094,6095,6746,6747,7430,7431,1,8146,8147,8894,8895,9674,9675,10486,10487,11330,11331,12206,12207,13114,13115,14054,1,14055,15026,15027,16030,16031,17066,17067,18134,18135,19234,19235,
	19859,19858,18743,18742,17659,17658,16607,16606,15587,15586,14599,0,14598,13643,13642,12719,12718,11827,11826,10967,10966,10139,10138,9343,9342,8579,8578,0,7847,7846,7147,7146,6479,6478,5843,5842,5239,5238,4667,4666,4127,4126,3619,0,3618,3143,3142,2699,2698,2287,2286,1907,1906,1559,1558,1243,1242,959,958,0,706,708,710,712,714,716,718,720,722,724,726,728,730,732,734,0,736,738,740,742,744,746,748,750,752,754,756,758,760,762,764,0,766,768,1036,1037,1336,1337,1668,1669,2032,2033,2428,2429,2856,2857,3316,0,3317,3808,3809,4332,4333,4888,4889,5476,5477,6096,6097,6748,6749,7432,7433,0,8148,8149,8896,8897,9676,9677,10488,10489,11332,11333,12208,12209,13116,13117,14056,0,14057,15028,15029,16032,16033,17068,17069,18136,18137,19236,19237,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19857,19856,18741,18740,17657,17656,16605,16604,15585,15584,14597,0,14596,13641,13640,12717,12716,11825,11824,10965,10964,10137,10136,9341,9340,8577,8576,0,7845,7844,7145,7144,6477,6476,5841,5840,5237,5236,4665,4664,4125,4124,3617,0,3616,3141,3140,2697,2696,2285,2284,1905,1904,1557,1556,1241,1240,957,956,0,705,704,483,485,487,489,491,493,495,497,499,501,503,505,507,0,509,511,513,515,517,519,521,523,525,527,529,531,533,535,537,0,770,771,1038,1039,1338,1339,1670,1671,2034,2035,2430,2431,2858,2859,3318,0,3319,3810,3811,4334,4335,4890,4891,5478,5479,6098,6099,6750,6751,7434,7435,0,8150,8151,8898,8899,9678,9679,10490,10491,11334,11335,12210,12211,13118,13119,14058,0,14059,15030,15031,16034,16035,17070,17071,18138,18139,19238,19239,
	19855,19854,18739,18738,17655,17654,16603,16602,15583,15582,14595,1,14594,13639,13638,12715,12714,11823,11822,10963,10962,10135,10134,9339,9338,8575,8574,1,7843,7842,7143,7142,6475,6474,5839,5838,5235,5234,4663,4662,4123,4122,3615,1,3614,3139,3138,2695,2694,2283,2282,1903,1902,1555,1554,1239,1238,955,954,1,703,702,482,484,486,488,490,492,494,496,498,500,502,504,506,1,508,510,512,514,516,518,520,522,524,526,528,530,532,534,536,1,772,773,1040,1041,1340,1341,1672,1673,2036,2037,2432,2433,2860,2861,3320,1,3321,3812,3813,4336,4337,4892,4893,5480,5481,6100,6101,6752,6753,7436,7437,1,8152,8153,8900,8901,9680,9681,10492,10493,11336,11337,12212,12213,13120,13121,14060,1,14061,15032,15033,16036,16037,17072,17073,18140,18141,19240,19241,
	19853,19852,18737,18736,17653,17652,16601,16600,15581,15580,14593,0,14592,13637,13636,12713,12712,11821,11820,10961,10960,10133,10132,9337,9336,8573,8572,0,7841,7840,7141,7140,6473,6472,5837,5836,5233,5232,4661,4660,4121,4120,3613,0,3612,3137,3136,2693,2692,2281,2280,1901,1900,1553,1552,1237,1236,953,952,0,701,700,481,480,291,293,295,297,299,301,303,305,307,309,311,0,313,315,317,319,321,323,325,327,329,331,333,335,337,538,539,0,774,775,1042,1043,1342,1343,1674,1675,2038,2039,2434,2435,2862,2863,3322,0,3323,3814,3815,4338,4339,4894,4895,5482,5483,6102,6103,6754,6755,7438,7439,0,8154,8155,8902,8903,9682,9683,10494,10495,11338,11339,12214,12215,13122,13123,14062,0,14063,15034,15035,16038,16039,17074,17075,18142,18143,19242,19243,
	19851,19850,18735,18734,17651,17650,16599,16598,15579,15578,14591,1,14590,13635,13634,12711,12710,11819,11818,10959,10958,10131,10130,9335,9334,8571,8570,1,7839,7838,7139,7138,6471,6470,5835,5834,5231,5230,4659,4658,4119,4118,3611,1,3610,3135,3134,2691,2690,2279,2278,1899,1898,1551,1550,1235,1234,951,950,1,699,698,479,478,290,292,294,296,298,300,302,304,306,308,310,1,312,314,316,318,320,322,324,326,328,330,332,334,336,540,541,1,776,777,1044,1045,1344,1345,1676,1677,2040,2041,2436,2437,2864,2865,3324,1,3325,3816,3817,4340,4341,4896,4897,5484,5485,6104,6105,6756,6757,7440,7441,1,8156,8157,8904,8905,9684,9685,10496,10497,11340,11341,12216,12217,13124,13125,14064,1,14065,15036,15037,16040,16041,17076,17077,18144,18145,19244,19245,
	19849,19848,18733,18732,17649,17648,16597,16596,15577,15576,14589,0,14588,13633,13632,12709,12708,11817,11816,10957,10956,10129,10128,9333,9332,8569,8568,0,7837,7836,7137,7136,6469,6468,5833,5832,5229,5228,4657,4656,4117,4116,3609,0,3608,3133,3132,2689,2688,2277,2276,1897,1896,1549,1548,1233,1232,949,948,0,697,696,477,476,289,288,131,133,135,137,139,141,143,145,147,0,149,151,153,155,157,159,161,163,165,167,169,338,339,542,543,0,778,779,1046,1047,1346,1347,1678,1679,2042,2043,2438,2439,2866,2867,3326,0,3327,3818,3819,4342,4343,4898,4899,5486,5487,6106,6107,6758,6759,7442,7443,0,8158,8159,8906,8907,9686,9687,10498,10499,11342,11343,12218,12219,13126,13127,14066,0,14067,15038,15039,16042,16043,17078,17079,18146,18147,19246,19247,
	19847,19846,18731,18730,17647,17646,16595,16594,15575,15574,14587,1,14586,13631,13630,12707,12706,11815,11814,10955,10954,10127,10126,9331,9330,8567,8566,1,7835,7834,7135,7134,6467,6466,5831,5830,5227,5226,4655,4654,4115,4114,3607,1,3606,3131,3130,2687,2686,2275,2274,1895,1894,1547,1546,1231,1230,947,946,1,695,694,475,474,287,286,130,132,134,136,138,140,142,144,146,1,148,150,152,154,156,158,160,162,164,166,168,340,341,544,545,1,780,781,1048,1049,1348,1349,1680,1681,2044,2045,2440,2441,2868,2869,3328,1,3329,3820,3821,4344,4345,4900,4901,5488,5489,6108,6109,6760,6761,7444,7445,1,8160,8161,8908,8909,9688,9689,10500,10501,11344,11345,12220,12221,13128,13129,14068,1,14069,15040,15041,16044,16045,17080,17081,18148,18149,19248,19249,
	19845,19844,18729,18728,17645,17644,16593,16592,15573,15572,14585,0,14584,13629,13628,12705,12704,11813,11812,10953,10952,10125,10124,9329,9328,8565,8564,0,7833,7832,7133,7132,6465,6464,5829,5828,5225,5224,4653,4652,4113,4112,3605,0,3604,3129,3128,2685,2684,2273,2272,1893,1892,1545,1544,1229,1228,945,944,0,693,692,473,472,285,284,129,128,3,5,7,9,11,13,15,0,17,19,21,23,25,27,29,31,33,170,171,342,343,546,547,0,782,783,1050,1051,1350,1351,1682,1683,2046,2047,2442,2443,2870,2871,3330,0,3331,3822,3823,4346,4347,4902,4903,5490,5491,6110,6111,6762,6763,7446,7447,0,8162,8163,8910,8911,9690,9691,10502,10503,11346,11347,12222,12223,13130,13131,14070,0,14071,15042,15043,16046,16047,17082,17083,18150,18151,19250,19251,
	19843,19842,18727,18726,17643,17642,16591,16590,15571,15570,14583,1,14582,13627,13626,12703,12702,11811,11810,10951,10950,10123,10122,9327,9326,8563,8562,1,7831,7830,7131,7130,6463,6462,5827,5826,5223,5222,4651,4650,4111,4110,3603,1,3602,3127,3126,2683,2682,2271,2270,1891,1890,1543,1542,1227,1226,943,942,1,691,690,471,470,283,282,127,126,2,4,6,8,10,12,14,1,16,18,20,22,24,26,28,30,32,172,173,344,345,548,549,1,784,785,1052,1053,1352,1353,1684,1685,2048,2049,2444,2445,2872,2873,3332,1,3333,3824,3825,4348,4349,4904,4905,5492,5493,6112,6113,6764,6765,7448,7449,1,8164,8165,8912,8913,9692,9693,10504,10505,11348,11349,12224,12225,13132,13133,14072,1,14073,15044,15045,16048,16049,17084,17085,18152,18153,19252,19253,
	19841,19840,18725,18724,17641,17640,16589,16588,15569,15568,14581,0,14580,13625,13624,12701,12700,11809,11808,10949,10948,10121,10120,9325,9324,8561,8560,0,7829,7828,7129,7128,6461,6460,5825,5824,5221,5220,4649,4648,4109,4108,3601,0,3600,3125,3124,2681,2680,2269,2268,1889,1888,1541,1540,1225,1224,941,940,0,689,688,469,468,281,280,125,124,1,1,20000,20001,20002,20003,20004,0,20005,20006,20007,20008,20009,0,1,34,35,174,175,346,347,550,551,0,786,787,1054,1055,1354,1355,1686,1687,2050,2051,2446,2447,2874,2875,3334,0,3335,3826,3827,4350,4351,4906,4907,5494,5495,6114,6115,6766,6767,7450,7451,0,8166,8167,8914,8915,9694,9695,10506,10507,11350,11351,12226,12227,13134,13135,14074,0,14075,15046,15047,16050,16051,17086,17087,18154,18155,19254,19255,
	19839,19838,18723,18722,17639,17638,16587,16586,15567,15566,14579,1,14578,13623,13622,12699,12698,11807,11806,10947,10946,10119,10118,9323,9322,8559,8558,1,7827,7826,7127,7126,6459,6458,5823,5822,5219,5218,4647,4646,4107,4106,3599,1,3598,3123,3122,2679,2678,2267,2266,1887,1886,1539,1538,1223,1222,939,938,1,687,686,467,466,279,278,123,122,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,36,37,176,177,348,349,552,553,1,788,789,1056,1057,1356,1357,1688,1689,2052,2053,2448,2449,2876,2877,3336,1,3337,3828,3829,4352,4353,4908,4909,5496,5497,6116,6117,6768,6769,7452,7453,1,8168,8169,8916,8917,9696,9697,10508,10509,11352,11353,12228,12229,13136,13137,14076,1,14077,15048,15049,16052,16053,17088,17089,18156,18157,19256,19257,
	19837,19836,18721,18720,17637,17636,16585,16584,15565,15564,14577,0,14576,13621,13620,12697,12696,11805,11804,10945,10944,10117,10116,9321,9320,8557,8556,0,7825,7824,7125,7124,6457,6456,5821,5820,5217,5216,4645,4644,4105,4104,3597,0,3596,3121,3120,2677,2676,2265,2264,1885,1884,1537,1536,1221,1220,937,936,0,685,684,465,464,277,276,121,120,20039,1,0,0,0,0,0,0,0,0,0,0,0,1,20010,38,39,178,179,350,351,554,555,0,790,791,1058,1059,1358,1359,1690,1691,2054,2055,2450,2451,2878,2879,3338,0,3339,3830,3831,4354,4355,4910,4911,5498,5499,6118,6119,6770,6771,7454,7455,0,8170,8171,8918,8919,9698,9699,10510,10511,11354,11355,12230,12231,13138,13139,14078,0,14079,15050,15051,16054,16055,17090,17091,18158,18159,19258,19259,
	19835,19834,18719,18718,17635,17634,16583,16582,15563,15562,14575,1,14574,13619,13618,12695,12694,11803,11802,10943,10942,10115,10114,9319,9318,8555,8554,1,7823,7822,7123,7122,6455,6454,5819,5818,5215,5214,4643,4642,4103,4102,3595,1,3594,3119,3118,2675,2674,2263,2262,1883,1882,1535,1534,1219,1218,935,934,1,683,682,463,462,275,274,119,118,20038,1,0,1,1,1,1,1,1,1,1,1,0,1,20011,40,41,180,181,352,353,556,557,1,792,793,1060,1061,1360,1361,1692,1693,2056,2057,2452,2453,2880,2881,3340,1,3341,3832,3833,4356,4357,4912,4913,5500,5501,6120,6121,6772,6773,7456,7457,1,8172,8173,8920,8921,9700,9701,10512,10513,11356,11357,12232,12233,13140,13141,14080,1,14081,15052,15053,16056,16057,17092,17093,18160,18161,19260,19261,
	19833,19832,18717,18716,17633,17632,16581,16580,15561,15560,14573,0,14572,13617,13616,12693,12692,11801,11800,10941,10940,10113,10112,9317,9316,8553,8552,0,7821,7820,7121,7120,6453,6452,5817,5816,5213,5212,4641,4640,4101,4100,3593,0,3592,3117,3116,2673,2672,2261,2260,1881,1880,1533,1532,1217,1216,933,932,0,681,680,461,460,273,272,117,116,20037,1,0,1,0,0,0,0,0,0,0,1,0,1,20012,42,43,182,183,354,355,558,559,0,794,795,1062,1063,1362,1363,1694,1695,2058,2059,2454,2455,2882,2883,3342,0,3343,3834,3835,4358,4359,4914,4915,5502,5503,6122,6123,6774,6775,7458,7459,0,8174,8175,8922,8923,9702,9703,10514,10515,11358,11359,12234,12235,13142,13143,14082,0,14083,15054,15055,16058,16059,17094,17095,18162,18163,19262,19263,
	19831,19830,18715,18714,17631,17630,16579,16578,15559,15558,14571,1,14570,13615,13614,12691,12690,11799,11798,10939,10938,10111,10110,9315,9314,8551,8550,1,7819,7818,7119,7118,6451,6450,5815,5814,5211,5210,4639,4638,4099,4098,3591,1,3590,3115,3114,2671,2670,2259,2258,1879,1878,1531,1530,1215,1214,931,930,1,679,678,459,458,271,270,115,114,20036,1,0,1,0,1,1,1,1,1,0,1,0,1,20013,44,45,184,185,356,357,560,561,1,796,797,1064,1065,1364,1365,1696,1697,2060,2061,2456,2457,2884,2885,3344,1,3345,3836,3837,4360,4361,4916,4917,5504,5505,6124,6125,6776,6777,7460,7461,1,8176,8177,8924,8925,9704,9705,10516,10517,11360,11361,12236,12237,13144,13145,14084,1,14085,15056,15057,16060,16061,17096,17097,18164,18165,19264,19265,
	19829,19828,18713,18712,17629,17628,16577,16576,15557,15556,14569,0,14568,13613,13612,12689,12688,11797,11796,10937,10936,10109,10108,9313,9312,8549,8548,0,7817,7816,7117,7116,6449,6448,5813,5812,5209,5208,4637,4636,4097,4096,3589,0,3588,3113,3112,2669,2668,2257,2256,1877,1876,1529,1528,1213,1212,929,928,0,677,676,457,456,269,268,113,112,20035,1,0,1,0,1,0,0,0,1,0,1,0,1,20014,46,47,186,187,358,359,562,563,0,798,799,1066,1067,1366,1367,1698,1699,2062,2063,2458,2459,2886,2887,3346,0,3347,3838,3839,4362,4363,4918,4919,5506,5507,6126,6127,6778,6779,7462,7463,0,8178,8179,8926,8927,9706,9707,10518,10519,11362,11363,12238,12239,13146,13147,14086,0,14087,15058,15059,16062,16063,17098,17099,18166,18167,19266,19267,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19827,19826,18711,18710,17627,17626,16575,16574,15555,15554,14567,0,14566,13611,13610,12687,12686,11795,11794,10935,10934,10107,10106,9311,9310,8547,8546,0,7815,7814,7115,7114,6447,6446,5811,5810,5207,5206,4635,4634,4095,4094,3587,0,3586,3111,3110,2667,2666,2255,2254,1875,1874,1527,1526,1211,1210,927,926,0,675,674,455,454,267,266,111,110,20034,1,0,1,0,1,0,0,0,1,0,1,0,1,20015,48,49,188,189,360,361,564,565,0,800,801,1068,1069,1368,1369,1700,1701,2064,2065,2460,2461,2888,2889,3348,0,3349,3840,3841,4364,4365,4920,4921,5508,5509,6128,6129,6780,6781,7464,7465,0,8180,8181,8928,8929,9708,9709,10520,10521,11364,11365,12240,12241,13148,13149,14088,0,14089,15060,15061,16064,16065,17100,17101,18168,18169,19268,19269,
	19825,19824,18709,18708,17625,17624,16573,16572,15553,15552,14565,1,14564,13609,13608,12685,12684,11793,11792,10933,10932,10105,10104,9309,9308,8545,8544,1,7813,7812,7113,7112,6445,6444,5809,5808,5205,5204,4633,4632,4093,4092,3585,1,3584,3109,3108,2665,2664,2253,2252,1873,1872,1525,1524,1209,1208,925,924,1,673,672,453,452,265,264,109,108,20033,1,0,1,0,1,1,1,1,1,0,1,0,1,20016,50,51,190,191,362,363,566,567,1,802,803,1070,1071,1370,1371,1702,1703,2066,2067,2462,2463,2890,2891,3350,1,3351,3842,3843,4366,4367,4922,4923,5510,5511,6130,6131,6782,6783,7466,7467,1,8182,8183,8930,8931,9710,9711,10522,10523,11366,11367,12242,12243,13150,13151,14090,1,14091,15062,15063,16066,16067,17102,17103,18170,18171,19270,19271,
	19823,19822,18707,18706,17623,17622,16571,16570,15551,15550,14563,0,14562,13607,13606,12683,12682,11791,11790,10931,10930,10103,10102,9307,9306,8543,8542,0,7811,7810,7111,7110,6443,6442,5807,5806,5203,5202,4631,4630,4091,4090,3583,0,3582,3107,3106,2663,2662,2251,2250,1871,1870,1523,1522,1207,1206,923,922,0,671,670,451,450,263,262,107,106,20032,1,0,1,0,0,0,0,0,0,0,1,0,1,20017,52,53,192,193,364,365,568,569,0,804,805,1072,1073,1372,1373,1704,1705,2068,2069,2464,2465,2892,2893,3352,0,3353,3844,3845,4368,4369,4924,4925,5512,5513,6132,6133,6784,6785,7468,7469,0,8184,8185,8932,8933,9712,9713,10524,10525,11368,11369,12244,12245,13152,13153,14092,0,14093,15064,15065,16068,16069,17104,17105,18172,18173,19272,19273,
	19821,19820,18705,18704,17621,17620,16569,16568,15549,15548,14561,1,14560,13605,13604,12681,12680,11789,11788,10929,10928,10101,10100,9305,9304,8541,8540,1,7809,7808,7109,7108,6441,6440,5805,5804,5201,5200,4629,4628,4089,4088,3581,1,3580,3105,3104,2661,2660,2249,2248,1869,1868,1521,1520,1205,1204,921,920,1,669,668,449,448,261,260,105,104,20031,1,0,1,1,1,1,1,1,1,1,1,0,1,20018,54,55,194,195,366,367,570,571,1,806,807,1074,1075,1374,1375,1706,1707,2070,2071,2466,2467,2894,2895,3354,1,3355,3846,3847,4370,4371,4926,4927,5514,5515,6134,6135,6786,6787,7470,7471,1,8186,8187,8934,8935,9714,9715,10526,10527,11370,11371,12246,12247,13154,13155,14094,1,14095,15066,15067,16070,16071,17106,17107,18174,18175,19274,19275,
	19819,19818,18703,18702,17619,17618,16567,16566,15547,15546,14559,0,14558,13603,13602,12679,12678,11787,11786,10927,10926,10099,10098,9303,9302,8539,8538,0,7807,7806,7107,7106,6439,6438,5803,5802,5199,5198,4627,4626,4087,4086,3579,0,3578,3103,3102,2659,2658,2247,2246,1867,1866,1519,1518,1203,1202,919,918,0,667,666,447,446,259,258,103,102,20030,1,0,0,0,0,0,0,0,0,0,0,0,1,20019,56,57,196,197,368,369,572,573,0,808,809,1076,1077,1376,1377,1708,1709,2072,2073,2468,2469,2896,2897,3356,0,3357,3848,3849,4372,4373,4928,4929,5516,5517,6136,6137,6788,6789,7472,7473,0,8188,8189,8936,8937,9716,9717,10528,10529,11372,11373,12248,12249,13156,13157,14096,0,14097,15068,15069,16072,16073,17108,17109,18176,18177,19276,19277,
	19817,19816,18701,18700,17617,17616,16565,16564,15545,15544,14557,1,14556,13601,13600,12677,12676,11785,11784,10925,10924,10097,10096,9301,9300,8537,8536,1,7805,7804,7105,7104,6437,6436,5801,5800,5197,5196,4625,4624,4085,4084,3577,1,3576,3101,3100,2657,2656,2245,2244,1865,1864,1517,1516,1201,1200,917,916,1,665,664,445,444,257,256,101,100,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,58,59,198,199,370,371,574,575,1,810,811,1078,1079,1378,1379,1710,1711,2074,2075,2470,2471,2898,2899,3358,1,3359,3850,3851,4374,4375,4930,4931,5518,5519,6138,6139,6790,6791,7474,7475,1,8190,8191,8938,8939,9718,9719,10530,10531,11374,11375,12250,12251,13158,13159,14098,1,14099,15070,15071,16074,16075,17110,17111,18178,18179,19278,19279,
	19815,19814,18699,18698,17615,17614,16563,16562,15543,15542,14555,0,14554,13599,13598,12675,12674,11783,11782,10923,10922,10095,10094,9299,9298,8535,8534,0,7803,7802,7103,7102,6435,6434,5799,5798,5195,5194,4623,4622,4083,4082,3575,0,3574,3099,3098,2655,2654,2243,2242,1863,1862,1515,1514,1199,1198,915,914,0,663,662,443,442,255,254,99,98,0,0,20029,20028,20027,20026,20025,0,20024,20023,20022,20021,20020,0,0,60,61,200,201,372,373,576,577,0,812,813,1080,1081,1380,1381,1712,1713,2076,2077,2472,2473,2900,2901,3360,0,3361,3852,3853,4376,4377,4932,4933,5520,5521,6140,6141,6792,6793,7476,7477,0,8192,8193,8940,8941,9720,9721,10532,10533,11376,11377,12252,12253,13160,13161,14100,0,14101,15072,15073,16076,16077,17112,17113,18180,18181,19280,19281,
	19813,19812,18697,18696,17613,17612,16561,16560,15541,15540,14553,1,14552,13597,13596,12673,12672,11781,11780,10921,10920,10093,10092,9297,9296,8533,8532,1,7801,7800,7101,7100,6433,6432,5797,5796,5193,5192,4621,4620,4081,4080,3573,1,3572,3097,3096,2653,2652,2241,2240,1861,1860,1513,1512,1197,1196,913,912,1,661,660,441,440,253,252,96,94,92,90,88,86,84,82,80,1,78,76,74,72,70,68,66,62,63,202,203,374,375,578,579,1,814,815,1082,1083,1382,1383,1714,1715,2078,2079,2474,2475,2902,2903,3362,1,3363,3854,3855,4378,4379,4934,4935,5522,5523,6142,6143,6794,6795,7478,7479,1,8194,8195,8942,8943,9722,9723,10534,10535,11378,11379,12254,12255,13162,13163,14102,1,14103,15074,15075,16078,16079,17114,17115,18182,18183,19282,19283,
	19811,19810,18695,18694,17611,17610,16559,16558,15539,15538,14551,0,14550,13595,13594,12671,12670,11779,11778,10919,10918,10091,10090,9295,9294,8531,8530,0,7799,7798,7099,7098,6431,6430,5795,5794,5191,5190,4619,4618,4079,4078,3571,0,3570,3095,3094,2651,2650,2239,2238,1859,1858,1511,1510,1195,1194,911,910,0,659,658,439,438,251,250,97,95,93,91,89,87,85,83,81,0,79,77,75,73,71,69,67,64,65,204,205,376,377,580,581,0,816,817,1084,1085,1384,1385,1716,1717,2080,2081,2476,2477,2904,2905,3364,0,3365,3856,3857,4380,4381,4936,4937,5524,5525,6144,6145,6796,6797,7480,7481,0,8196,8197,8944,8945,9724,9725,10536,10537,11380,11381,12256,12257,13164,13165,14104,0,14105,15076,15077,16080,16081,17116,17117,18184,18185,19284,19285,
	19809,19808,18693,18692,17609,17608,16557,16556,15537,15536,14549,1,14548,13593,13592,12669,12668,11777,11776,10917,10916,10089,10088,9293,9292,8529,8528,1,7797,7796,7097,7096,6429,6428,5793,5792,5189,5188,4617,4616,4077,4076,3569,1,3568,3093,3092,2649,2648,2237,2236,1857,1856,1509,1508,1193,1192,909,908,1,657,656,437,436,248,246,244,242,240,238,236,234,232,230,228,1,226,224,222,220,218,216,214,212,210,206,207,378,379,582,583,1,818,819,1086,1087,1386,1387,1718,1719,2082,2083,2478,2479,2906,2907,3366,1,3367,3858,3859,4382,4383,4938,4939,5526,5527,6146,6147,6798,6799,7482,7483,1,8198,8199,8946,8947,9726,9727,10538,10539,11382,11383,12258,12259,13166,13167,14106,1,14107,15078,15079,16082,16083,17118,17119,18186,18187,19286,19287,
	19807,19806,18691,18690,17607,17606,16555,16554,15535,15534,14547,0,14546,13591,13590,12667,12666,11775,11774,10915,10914,10087,10086,9291,9290,8527,8526,0,7795,7794,7095,7094,6427,6426,5791,5790,5187,5186,4615,4614,4075,4074,3567,0,3566,3091,3090,2647,2646,2235,2234,1855,1854,1507,1506,1191,1190,907,906,0,655,654,435,434,249,247,245,243,241,239,237,235,233,231,229,0,227,225,223,221,219,217,215,213,211,208,209,380,381,584,585,0,820,821,1088,1089,1388,1389,1720,1721,2084,2085,2480,2481,2908,2909,3368,0,3369,3860,3861,4384,4385,4940,4941,5528,5529,6148,6149,6800,6801,7484,7485,0,8200,8201,8948,8949,9728,9729,10540,10541,11384,11385,12260,12261,13168,13169,14108,0,14109,15080,15081,16084,16085,17120,17121,18188,18189,19288,19289,
	19805,19804,18689,18688,17605,17604,16553,16552,15533,15532,14545,1,14544,13589,13588,12665,12664,11773,11772,10913,10912,10085,10084,9289,9288,8525,8524,1,7793,7792,7093,7092,6425,6424,5789,5788,5185,5184,4613,4612,4073,4072,3565,1,3564,3089,3088,2645,2644,2233,2232,1853,1852,1505,1504,1189,1188,905,904,1,653,652,432,430,428,426,424,422,420,418,416,414,412,410,408,1,406,404,402,400,398,396,394,392,390,388,386,382,383,586,587,1,822,823,1090,1091,1390,1391,1722,1723,2086,2087,2482,2483,2910,2911,3370,1,3371,3862,3863,4386,4387,4942,4943,5530,5531,6150,6151,6802,6803,7486,7487,1,8202,8203,8950,8951,9730,9731,10542,10543,11386,11387,12262,12263,13170,13171,14110,1,14111,15082,15083,16086,16087,17122,17123,18190,18191,19290,19291,
	19803,19802,18687,18686,17603,17602,16551,16550,15531,15530,14543,0,14542,13587,13586,12663,12662,11771,11770,10911,10910,10083,10082,9287,9286,8523,8522,0,7791,7790,7091,7090,6423,6422,5787,5786,5183,5182,4611,4610,4071,4070,3563,0,3562,3087,3086,2643,2642,2231,2230,1851,1850,1503,1502,1187,1186,903,902,0,651,650,433,431,429,427,425,423,421,419,417,415,413,411,409,0,407,405,403,401,399,397,395,393,391,389,387,384,385,588,589,0,824,825,1092,1093,1392,1393,1724,1725,2088,2089,2484,2485,2912,2913,3372,0,3373,3864,3865,4388,4389,4944,4945,5532,5533,6152,6153,6804,6805,7488,7489,0,8204,8205,8952,8953,9732,9733,10544,10545,11388,11389,12264,12265,13172,13173,14112,0,14113,15084,15085,16088,16089,17124,17125,18192,18193,19292,19293,
	19801,19800,18685,18684,17601,17600,16549,16548,15529,15528,14541,1,14540,13585,13584,12661,12660,11769,11768,10909,10908,10081,10080,9285,9284,8521,8520,1,7789,7788,7089,7088,6421,6420,5785,5784,5181,5180,4609,4608,4069,4068,3561,1,3560,3085,3084,2641,2640,2229,2228,1849,1848,1501,1500,1185,1184,901,900,1,648,646,644,642,640,638,636,634,632,630,628,626,624,622,620,1,618,616,614,612,610,608,606,604,602,600,598,596,594,590,591,1,826,827,1094,1095,1394,1395,1726,1727,2090,2091,2486,2487,2914,2915,3374,1,3375,3866,3867,4390,4391,4946,4947,5534,5535,6154,6155,6806,6807,7490,7491,1,8206,8207,8954,8955,9734,9735,10546,10547,11390,11391,12266,12267,13174,13175,14114,1,14115,15086,15087,16090,16091,17126,17127,18194,18195,19294,19295,
	19799,19798,18683,18682,17599,17598,16547,16546,15527,15526,14539,0,14538,13583,13582,12659,12658,11767,11766,10907,10906,10079,10078,9283,9282,8519,8518,0,7787,7786,7087,7086,6419,6418,5783,5782,5179,5178,4607,4606,4067,4066,3559,0,3558,3083,3082,2639,2638,2227,2226,1847,1846,1499,1498,1183,1182,899,898,0,649,647,645,643,641,639,637,635,633,631,629,627,625,623,621,0,619,617,615,613,611,609,607,605,603,601,599,597,595,592,593,0,828,829,1096,1097,1396,1397,1728,1729,2092,2093,2488,2489,2916,2917,3376,0,3377,3868,3869,4392,4393,4948,4949,5536,5537,6156,6157,6808,6809,7492,7493,0,8208,8209,8956,8957,9736,9737,10548,10549,11392,11393,12268,12269,13176,13177,14116,0,14117,15088,15089,16092,16093,17128,17129,18196,18197,19296,19297,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19797,19796,18681,18680,17597,17596,16545,16544,15525,15524,14537,0,14536,13581,13580,12657,12656,11765,11764,10905,10904,10077,10076,9281,9280,8517,8516,0,7785,7784,7085,7084,6417,6416,5781,5780,5177,5176,4605,4604,4065,4064,3557,0,3556,3081,3080,2637,2636,2225,2224,1845,1844,1497,1496,1181,1180,896,894,0,892,890,888,886,884,882,880,878,876,874,872,870,868,866,864,0,862,860,858,856,854,852,850,848,846,844,842,840,838,836,834,0,830,831,1098,1099,1398,1399,1730,1731,2094,2095,2490,2491,2918,2919,3378,0,3379,3870,3871,4394,4395,4950,4951,5538,5539,6158,6159,6810,6811,7494,7495,0,8210,8211,8958,8959,9738,9739,10550,10551,11394,11395,12270,12271,13178,13179,14118,0,14119,15090,15091,16094,16095,17130,17131,18198,18199,19298,19299,
	19795,19794,18679,18678,17595,17594,16543,16542,15523,15522,14535,1,14534,13579,13578,12655,12654,11763,11762,10903,10902,10075,10074,9279,9278,8515,8514,1,7783,7782,7083,7082,6415,6414,5779,5778,5175,5174,4603,4602,4063,4062,3555,1,3554,3079,3078,2635,2634,2223,2222,1843,1842,1495,1494,1179,1178,897,895,1,893,891,889,887,885,883,881,879,877,875,873,871,869,867,865,1,863,861,859,857,855,853,851,849,847,845,843,841,839,837,835,1,832,833,1100,1101,1400,1401,1732,1733,2096,2097,2492,2493,2920,2921,3380,1,3381,3872,3873,4396,4397,4952,4953,5540,5541,6160,6161,6812,6813,7496,7497,1,8212,8213,8960,8961,9740,9741,10552,10553,11396,11397,12272,12273,13180,13181,14120,1,14121,15092,15093,16096,16097,17132,17133,18200,18201,19300,19301,
	19793,19792,18677,18676,17593,17592,16541,16540,15521,15520,14533,0,14532,13577,13576,12653,12652,11761,11760,10901,10900,10073,10072,9277,9276,8513,8512,0,7781,7780,7081,7080,6413,6412,5777,5776,5173,5172,4601,4600,4061,4060,3553,0,3552,3077,3076,2633,2632,2221,2220,1841,1840,1493,1492,1176,1174,1172,1170,0,1168,1166,1164,1162,1160,1158,1156,1154,1152,1150,1148,1146,1144,1142,1140,0,1138,1136,1134,1132,1130,1128,1126,1124,1122,1120,1118,1116,1114,1112,1110,0,1108,1106,1102,1103,1402,1403,1734,1735,2098,2099,2494,2495,2922,2923,3382,0,3383,3874,3875,4398,4399,4954,4955,5542,5543,6162,6163,6814,6815,7498,7499,0,8214,8215,8962,8963,9742,9743,10554,10555,11398,11399,12274,12275,13182,13183,14122,0,14123,15094,15095,16098,16099,17134,17135,18202,18203,19302,19303,
	19791,19790,18675,18674,17591,17590,16539,16538,15519,15518,14531,1,14530,13575,13574,12651,12650,11759,11758,10899,10898,10071,10070,9275,9274,8511,8510,1,7779,7778,7079,7078,6411,6410,5775,5774,5171,5170,4599,4598,4059,4058,3551,1,3550,3075,3074,2631,2630,2219,2218,1839,1838,1491,1490,1177,1175,1173,1171,1,1169,1167,1165,1163,1161,1159,1157,1155,1153,1151,1149,1147,1145,1143,1141,1,1139,1137,1135,1133,1131,1129,1127,1125,1123,1121,1119,1117,1115,1113,1111,1,1109,1107,1104,1105,1404,1405,1736,1737,2100,2101,2496,2497,2924,2925,3384,1,3385,3876,3877,4400,4401,4956,4957,5544,5545,6164,6165,6816,6817,7500,7501,1,8216,8217,8964,8965,9744,9745,10556,10557,11400,11401,12276,12277,13184,13185,14124,1,14125,15096,15097,16100,16101,17136,17137,18204,18205,19304,19305,
	19789,19788,18673,18672,17589,17588,16537,16536,15517,15516,14529,0,14528,13573,13572,12649,12648,11757,11756,10897,10896,10069,10068,9273,9272,8509,8508,0,7777,7776,7077,7076,6409,6408,5773,5772,5169,5168,4597,4596,4057,4056,3549,0,3548,3073,3072,2629,2628,2217,2216,1837,1836,1488,1486,1484,1482,1480,1478,0,1476,1474,1472,1470,1468,1466,1464,1462,1460,1458,1456,1454,1452,1450,1448,0,1446,1444,1442,1440,1438,1436,1434,1432,1430,1428,1426,1424,1422,1420,1418,0,1416,1414,1412,1410,1406,1407,1738,1739,2102,2103,2498,2499,2926,2927,3386,0,3387,3878,3879,4402,4403,4958,4959,5546,5547,6166,6167,6818,6819,7502,7503,0,8218,8219,8966,8967,9746,9747,10558,10559,11402,11403,12278,12279,13186,13187,14126,0,14127,15098,15099,16102,16103,17138,17139,18206,18207,19306,19307,
	19787,19786,18671,18670,17587,17586,16535,16534,15515,15514,14527,1,14526,13571,13570,12647,12646,11755,11754,10895,10894,10067,10066,9271,9270,8507,8506,1,7775,7774,7075,7074,6407,6406,5771,5770,5167,5166,4595,4594,4055,4054,3547,1,3546,3071,3070,2627,2626,2215,2214,1835,1834,1489,1487,1485,1483,1481,1479,1,1477,1475,1473,1471,1469,1467,1465,1463,1461,1459,1457,1455,1453,1451,1449,1,1447,1445,1443,1441,1439,1437,1435,1433,1431,1429,1427,1425,1423,1421,1419,1,1417,1415,1413,1411,1408,1409,1740,1741,2104,2105,2500,2501,2928,2929,3388,1,3389,3880,3881,4404,4405,4960,4961,5548,5549,6168,6169,6820,6821,7504,7505,1,8220,8221,8968,8969,9748,9749,10560,10561,11404,11405,12280,12281,13188,13189,14128,1,14129,15100,15101,16104,16105,17140,17141,18208,18209,19308,19309,
	19785,19784,18669,18668,17585,17584,16533,16532,15513,15512,14525,0,14524,13569,13568,12645,12644,11753,11752,10893,10892,10065,10064,9269,9268,8505,8504,0,7773,7772,7073,7072,6405,6404,5769,5768,5165,5164,4593,4592,4053,4052,3545,0,3544,3069,3068,2625,2624,2213,2212,1832,1830,1828,1826,1824,1822,1820,1818,0,1816,1814,1812,1810,1808,1806,1804,1802,1800,1798,1796,1794,1792,1790,1788,0,1786,1784,1782,1780,1778,1776,1774,1772,1770,1768,1766,1764,1762,1760,1758,0,1756,1754,1752,1750,1748,1746,1742,1743,2106,2107,2502,2503,2930,2931,3390,0,3391,3882,3883,4406,4407,4962,4963,5550,5551,6170,6171,6822,6823,7506,7507,0,8222,8223,8970,8971,9750,9751,10562,10563,11406,11407,12282,12283,13190,13191,14130,0,14131,15102,15103,16106,16107,17142,17143,18210,18211,19310,19311,
	19783,19782,18667,18666,17583,17582,16531,16530,15511,15510,14523,1,14522,13567,13566,12643,12642,11751,11750,10891,10890,10063,10062,9267,9266,8503,8502,1,7771,7770,7071,7070,6403,6402,5767,5766,5163,5162,4591,4590,4051,4050,3543,1,3542,3067,3066,2623,2622,2211,2210,1833,1831,1829,1827,1825,1823,1821,1819,1,1817,1815,1813,1811,1809,1807,1805,1803,1801,1799,1797,1795,1793,1791,1789,1,1787,1785,1783,1781,1779,1777,1775,1773,1771,1769,1767,1765,1763,1761,1759,1,1757,1755,1753,1751,1749,1747,1744,1745,2108,2109,2504,2505,2932,2933,3392,1,3393,3884,3885,4408,4409,4964,4965,5552,5553,6172,6173,6824,6825,7508,7509,1,8224,8225,8972,8973,9752,9753,10564,10565,11408,11409,12284,12285,13192,13193,14132,1,14133,15104,15105,16108,16109,17144,17145,18212,18213,19312,19313,
	19781,19780,18665,18664,17581,17580,16529,16528,15509,15508,14521,0,14520,13565,13564,12641,12640,11749,11748,10889,10888,10061,10060,9265,9264,8501,8500,0,7769,7768,7069,7068,6401,6400,5765,5764,5161,5160,4589,4588,4049,4048,3541,0,3540,3065,3064,2621,2620,2208,2206,2204,2202,2200,2198,2196,2194,2192,2190,0,2188,2186,2184,2182,2180,2178,2176,2174,2172,2170,2168,2166,2164,2162,2160,0,2158,2156,2154,2152,2150,2148,2146,2144,2142,2140,2138,2136,2134,2132,2130,0,2128,2126,2124,2122,2120,2118,2116,2114,2110,2111,2506,2507,2934,2935,3394,0,3395,3886,3887,4410,4411,4966,4967,5554,5555,6174,6175,6826,6827,7510,7511,0,8226,8227,8974,8975,9754,9755,10566,10567,11410,11411,12286,12287,13194,13195,14134,0,14135,15106,15107,16110,16111,17146,17147,18214,18215,19314,19315,
	19779,19778,18663,18662,17579,17578,16527,16526,15507,15506,14519,1,14518,13563,13562,12639,12638,11747,11746,10887,10886,10059,10058,9263,9262,8499,8498,1,7767,7766,7067,7066,6399,6398,5763,5762,5159,5158,4587,4586,4047,4046,3539,1,3538,3063,3062,2619,2618,2209,2207,2205,2203,2201,2199,2197,2195,2193,2191,1,2189,2187,2185,2183,2181,2179,2177,2175,2173,2171,2169,2167,2165,2163,2161,1,2159,2157,2155,2153,2151,2149,2147,2145,2143,2141,2139,2137,2135,2133,2131,1,2129,2127,2125,2123,2121,2119,2117,2115,2112,2113,2508,2509,2936,2937,3396,1,3397,3888,3889,4412,4413,4968,4969,5556,5557,6176,6177,6828,6829,7512,7513,1,8228,8229,8976,8977,9756,9757,10568,10569,11412,11413,12288,12289,13196,13197,14136,1,14137,15108,15109,16112,16113,17148,17149,18216,18217,19316,19317,
	19777,19776,18661,18660,17577,17576,16525,16524,15505,15504,14517,0,14516,13561,13560,12637,12636,11745,11744,10885,10884,10057,10056,9261,9260,8497,8496,0,7765,7764,7065,7064,6397,6396,5761,5760,5157,5156,4585,4584,4045,4044,3537,0,3536,3061,3060,2616,2614,2612,2610,2608,2606,2604,2602,2600,2598,2596,2594,0,2592,2590,2588,2586,2584,2582,2580,2578,2576,2574,2572,2570,2568,2566,2564,0,2562,2560,2558,2556,2554,2552,2550,2548,2546,2544,2542,2540,2538,2536,2534,0,2532,2530,2528,2526,2524,2522,2520,2518,2516,2514,2510,2511,2938,2939,3398,0,3399,3890,3891,4414,4415,4970,4971,5558,5559,6178,6179,6830,6831,7514,7515,0,8230,8231,8978,8979,9758,9759,10570,10571,11414,11415,12290,12291,13198,13199,14138,0,14139,15110,15111,16114,16115,17150,17151,18218,18219,19318,19319,
	19775,19774,18659,18658,17575,17574,16523,16522,15503,15502,14515,1,14514,13559,13558,12635,12634,11743,11742,10883,10882,10055,10054,9259,9258,8495,8494,1,7763,7762,7063,7062,6395,6394,5759,5758,5155,5154,4583,4582,4043,4042,3535,1,3534,3059,3058,2617,2615,2613,2611,2609,2607,2605,2603,2601,2599,2597,2595,1,2593,2591,2589,2587,2585,2583,2581,2579,2577,2575,2573,2571,2569,2567,2565,1,2563,2561,2559,2557,2555,2553,2551,2549,2547,2545,2543,2541,2539,2537,2535,1,2533,2531,2529,2527,2525,2523,2521,2519,2517,2515,2512,2513,2940,2941,3400,1,3401,3892,3893,4416,4417,4972,4973,5560,5561,6180,6181,6832,6833,7516,7517,1,8232,8233,8980,8981,9760,9761,10572,10573,11416,11417,12292,12293,13200,13201,14140,1,14141,15112,15113,16116,16117,17152,17153,18220,18221,19320,19321,
	19773,19772,18657,18656,17573,17572,16521,16520,15501,15500,14513,0,14512,13557,13556,12633,12632,11741,11740,10881,10880,10053,10052,9257,9256,8493,8492,0,7761,7760,7061,7060,6393,6392,5757,5756,5153,5152,4581,4580,4041,4040,3533,0,3532,3056,3054,3052,3050,3048,3046,3044,3042,3040,3038,3036,3034,3032,3030,0,3028,3026,3024,3022,3020,3018,3016,3014,3012,3010,3008,3006,3004,3002,3000,0,2998,2996,2994,2992,2990,2988,2986,2984,2982,2980,2978,2976,2974,2972,2970,0,2968,2966,2964,2962,2960,2958,2956,2954,2952,2950,2948,2946,2942,2943,3402,0,3403,3894,3895,4418,4419,4974,4975,5562,5563,6182,6183,6834,6835,7518,7519,0,8234,8235,8982,8983,9762,9763,10574,10575,11418,11419,12294,12295,13202,13203,14142,0,14143,15114,15115,16118,16119,17154,17155,18222,18223,19322,19323,
	19771,19770,18655,18654,17571,17570,16519,16518,15499,15498,14511,1,14510,13555,13554,12631,12630,11739,11738,10879,10878,10051,10050,9255,9254,8491,8490,1,7759,7758,7059,7058,6391,6390,5755,5754,5151,5150,4579,4578,4039,4038,3531,1,3530,3057,3055,3053,3051,3049,3047,3045,3043,3041,3039,3037,3035,3033,3031,1,3029,3027,3025,3023,3021,3019,3017,3015,3013,3011,3009,3007,3005,3003,3001,1,2999,2997,2995,2993,2991,2989,2987,2985,2983,2981,2979,2977,2975,2973,2971,1,2969,2967,2965,2963,2961,2959,2957,2955,2953,2951,2949,2947,2944,2945,3404,1,3405,3896,3897,4420,4421,4976,4977,5564,5565,6184,6185,6836,6837,7520,7521,1,8236,8237,8984,8985,9764,9765,10576,10577,11420,11421,12296,12297,13204,13205,14144,1,14145,15116,15117,16120,16121,17156,17157,18224,18225,19324,19325,
	19769,19768,18653,18652,17569,17568,16517,16516,15497,15496,14509,0,14508,13553,13552,12629,12628,11737,11736,10877,10876,10049,10048,9253,9252,8489,8488,0,7757,7756,7057,7056,6389,6388,5753,5752,5149,5148,4577,4576,4037,4036,3528,0,3526,3524,3522,3520,3518,3516,3514,3512,3510,3508,3506,3504,3502,3500,3498,0,3496,3494,3492,3490,3488,3486,3484,3482,3480,3478,3476,3474,3472,3470,3468,0,3466,3464,3462,3460,3458,3456,3454,3452,3450,3448,3446,3444,3442,3440,3438,0,3436,3434,3432,3430,3428,3426,3424,3422,3420,3418,3416,3414,3412,3410,3406,0,3407,3898,3899,4422,4423,4978,4979,5566,5567,6186,6187,6838,6839,7522,7523,0,8238,8239,8986,8987,9766,9767,10578,10579,11422,11423,12298,12299,13206,13207,14146,0,14147,15118,15119,16122,16123,17158,17159,18226,18227,19326,19327,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19767,19766,18651,18650,17567,17566,16515,16514,15495,15494,14507,0,14506,13551,13550,12627,12626,11735,11734,10875,10874,10047,10046,9251,9250,8487,8486,0,7755,7754,7055,7054,6387,6386,5751,5750,5147,5146,4575,4574,4035,4034,3529,0,3527,3525,3523,3521,3519,3517,3515,3513,3511,3509,3507,3505,3503,3501,3499,0,3497,3495,3493,3491,3489,3487,3485,3483,3481,3479,3477,3475,3473,3471,3469,0,3467,3465,3463,3461,3459,3457,3455,3453,3451,3449,3447,3445,3443,3441,3439,0,3437,3435,3433,3431,3429,3427,3425,3423,3421,3419,3417,3415,3413,3411,3408,0,3409,3900,3901,4424,4425,4980,4981,5568,5569,6188,6189,6840,6841,7524,7525,0,8240,8241,8988,8989,9768,9769,10580,10581,11424,11425,12300,12301,13208,13209,14148,0,14149,15120,15121,16124,16125,17160,17161,18228,18229,19328,19329,
	19765,19764,18649,18648,17565,17564,16513,16512,15493,15492,14505,1,14504,13549,13548,12625,12624,11733,11732,10873,10872,10045,10044,9249,9248,8485,8484,1,7753,7752,7053,7052,6385,6384,5749,5748,5145,5144,4573,4572,4032,4030,4028,1,4026,4024,4022,4020,4018,4016,4014,4012,4010,4008,4006,4004,4002,4000,3998,1,3996,3994,3992,3990,3988,3986,3984,3982,3980,3978,3976,3974,3972,3970,3968,1,3966,3964,3962,3960,3958,3956,3954,3952,3950,3948,3946,3944,3942,3940,3938,1,3936,3934,3932,3930,3928,3926,3924,3922,3920,3918,3916,3914,3912,3910,3908,1,3906,3902,3903,4426,4427,4982,4983,5570,5571,6190,6191,6842,6843,7526,7527,1,8242,8243,8990,8991,9770,9771,10582,10583,11426,11427,12302,12303,13210,13211,14150,1,14151,15122,15123,16126,16127,17162,17163,18230,18231,19330,19331,
	19763,19762,18647,18646,17563,17562,16511,16510,15491,15490,14503,0,14502,13547,13546,12623,12622,11731,11730,10871,10870,10043,10042,9247,9246,8483,8482,0,7751,7750,7051,7050,6383,6382,5747,5746,5143,5142,4571,4570,4033,4031,4029,0,4027,4025,4023,4021,4019,4017,4015,4013,4011,4009,4007,4005,4003,4001,3999,0,3997,3995,3993,3991,3989,3987,3985,3983,3981,3979,3977,3975,3973,3971,3969,0,3967,3965,3963,3961,3959,3957,3955,3953,3951,3949,3947,3945,3943,3941,3939,0,3937,3935,3933,3931,3929,3927,3925,3923,3921,3919,3917,3915,3913,3911,3909,0,3907,3904,3905,4428,4429,4984,4985,5572,5573,6192,6193,6844,6845,7528,7529,0,8244,8245,8992,8993,9772,9773,10584,10585,11428,11429,12304,12305,13212,13213,14152,0,14153,15124,15125,16128,16129,17164,17165,18232,18233,19332,19333,
	19761,19760,18645,18644,17561,17560,16509,16508,15489,15488,14501,1,14500,13545,13544,12621,12620,11729,11728,10869,10868,10041,10040,9245,9244,8481,8480,1,7749,7748,7049,7048,6381,6380,5745,5744,5141,5140,4568,4566,4564,4562,4560,1,4558,4556,4554,4552,4550,4548,4546,4544,4542,4540,4538,4536,4534,4532,4530,1,4528,4526,4524,4522,4520,4518,4516,4514,4512,4510,4508,4506,4504,4502,4500,1,4498,4496,4494,4492,4490,4488,4486,4484,4482,4480,4478,4476,4474,4472,4470,1,4468,4466,4464,4462,4460,4458,4456,4454,4452,4450,4448,4446,4444,4442,4440,1,4438,4436,4434,4430,4431,4986,4987,5574,5575,6194,6195,6846,6847,7530,7531,1,8246,8247,8994,8995,9774,9775,10586,10587,11430,11431,12306,12307,13214,13215,14154,1,14155,15126,15127,16130,16131,17166,17167,18234,18235,19334,19335,
	19759,19758,18643,18642,17559,17558,16507,16506,15487,15486,14499,0,14498,13543,13542,12619,12618,11727,11726,10867,10866,10039,10038,9243,9242,8479,8478,0,7747,7746,7047,7046,6379,6378,5743,5742,5139,5138,4569,4567,4565,4563,4561,0,4559,4557,4555,4553,4551,4549,4547,4545,4543,4541,4539,4537,4535,4533,4531,0,4529,4527,4525,4523,4521,4519,4517,4515,4513,4511,4509,4507,4505,4503,4501,0,4499,4497,4495,4493,4491,4489,4487,4485,4483,4481,4479,4477,4475,4473,4471,0,4469,4467,4465,4463,4461,4459,4457,4455,4453,4451,4449,4447,4445,4443,4441,0,4439,4437,4435,4432,4433,4988,4989,5576,5577,6196,6197,6848,6849,7532,7533,0,8248,8249,8996,8997,9776,9777,10588,10589,11432,11433,12308,12309,13216,13217,14156,0,14157,15128,15129,16132,16133,17168,17169,18236,18237,19336,19337,
	19757,19756,18641,18640,17557,17556,16505,16504,15485,15484,14497,1,14496,13541,13540,12617,12616,11725,11724,10865,10864,10037,10036,9241,9240,8477,8476,1,7745,7744,7045,7044,6377,6376,5741,5740,5136,5134,5132,5130,5128,5126,5124,1,5122,5120,5118,5116,5114,5112,5110,5108,5106,5104,5102,5100,5098,5096,5094,1,5092,5090,5088,5086,5084,5082,5080,5078,5076,5074,5072,5070,5068,5066,5064,1,5062,5060,5058,5056,5054,5052,5050,5048,5046,5044,5042,5040,5038,5036,5034,1,5032,5030,5028,5026,5024,5022,5020,5018,5016,5014,5012,5010,5008,5006,5004,1,5002,5000,4998,4996,4994,4990,4991,5578,5579,6198,6199,6850,6851,7534,7535,1,8250,8251,8998,8999,9778,9779,10590,10591,11434,11435,12310,12311,13218,13219,14158,1,14159,15130,15131,16134,16135,17170,17171,18238,18239,19338,19339,
	19755,19754,18639,18638,17555,17554,16503,16502,15483,15482,14495,0,14494,13539,13538,12615,12614,11723,11722,10863,10862,10035,10034,9239,9238,8475,8474,0,7743,7742,7043,7042,6375,6374,5739,5738,5137,5135,5133,5131,5129,5127,5125,0,5123,5121,5119,5117,5115,5113,5111,5109,5107,5105,5103,5101,5099,5097,5095,0,5093,5091,5089,5087,5085,5083,5081,5079,5077,5075,5073,5071,5069,5067,5065,0,5063,5061,5059,5057,5055,5053,5051,5049,5047,5045,5043,5041,5039,5037,5035,0,5033,5031,5029,5027,5025,5023,5021,5019,5017,5015,5013,5011,5009,5007,5005,0,5003,5001,4999,4997,4995,4992,4993,5580,5581,6200,6201,6852,6853,7536,7537,0,8252,8253,9000,9001,9780,9781,10592,10593,11436,11437,12312,12313,13220,13221,14160,0,14161,15132,15133,16136,16137,17172,17173,18240,18241,19340,19341,
	19753,19752,18637,18636,17553,17552,16501,16500,15481,15480,14493,1,14492,13537,13536,12613,12612,11721,11720,10861,10860,10033,10032,9237,9236,8473,8472,1,7741,7740,7041,7040,6373,6372,5736,5734,5732,5730,5728,5726,5724,5722,5720,1,5718,5716,5714,5712,5710,5708,5706,5704,5702,5700,5698,5696,5694,5692,5690,1,5688,5686,5684,5682,5680,5678,5676,5674,5672,5670,5668,5666,5664,5662,5660,1,5658,5656,5654,5652,5650,5648,5646,5644,5642,5640,5638,5636,5634,5632,5630,1,5628,5626,5624,5622,5620,5618,5616,5614,5612,5610,5608,5606,5604,5602,5600,1,5598,5596,5594,5592,5590,5588,5586,5582,5583,6202,6203,6854,6855,7538,7539,1,8254,8255,9002,9003,9782,9783,10594,10595,11438,11439,12314,12315,13222,13223,14162,1,14163,15134,15135,16138,16139,17174,17175,18242,18243,19342,19343,
	19751,19750,18635,18634,17551,17550,16499,16498,15479,15478,14491,0,14490,13535,13534,12611,12610,11719,11718,10859,10858,10031,10030,9235,9234,8471,8470,0,7739,7738,7039,7038,6371,6370,5737,5735,5733,5731,5729,5727,5725,5723,5721,0,5719,5717,5715,5713,5711,5709,5707,5705,5703,5701,5699,5697,5695,5693,5691,0,5689,5687,5685,5683,5681,5679,5677,5675,5673,5671,5669,5667,5665,5663,5661,0,5659,5657,5655,5653,5651,5649,5647,5645,5643,5641,5639,5637,5635,5633,5631,0,5629,5627,5625,5623,5621,5619,5617,5615,5613,5611,5609,5607,5605,5603,5601,0,5599,5597,5595,5593,5591,5589,5587,5584,5585,6204,6205,6856,6857,7540,7541,0,8256,8257,9004,9005,9784,9785,10596,10597,11440,11441,12316,12317,13224,13225,14164,0,14165,15136,15137,16140,16141,17176,17177,18244,18245,19344,19345,
	19749,19748,18633,18632,17549,17548,16497,16496,15477,15476,14489,1,14488,13533,13532,12609,12608,11717,11716,10857,10856,10029,10028,9233,9232,8469,8468,1,7737,7736,7037,7036,6368,6366,6364,6362,6360,6358,6356,6354,6352,6350,6348,1,6346,6344,6342,6340,6338,6336,6334,6332,6330,6328,6326,6324,6322,6320,6318,1,6316,6314,6312,6310,6308,6306,6304,6302,6300,6298,6296,6294,6292,6290,6288,1,6286,6284,6282,6280,6278,6276,6274,6272,6270,6268,6266,6264,6262,6260,6258,1,6256,6254,6252,6250,6248,6246,6244,6242,6240,6238,6236,6234,6232,6230,6228,1,6226,6224,6222,6220,6218,6216,6214,6212,6210,6206,6207,6858,6859,7542,7543,1,8258,8259,9006,9007,9786,9787,10598,10599,11442,11443,12318,12319,13226,13227,14166,1,14167,15138,15139,16142,16143,17178,17179,18246,18247,19346,19347,
	19747,19746,18631,18630,17547,17546,16495,16494,15475,15474,14487,0,14486,13531,13530,12607,12606,11715,11714,10855,10854,10027,10026,9231,9230,8467,8466,0,7735,7734,7035,7034,6369,6367,6365,6363,6361,6359,6357,6355,6353,6351,6349,0,6347,6345,6343,6341,6339,6337,6335,6333,6331,6329,6327,6325,6323,6321,6319,0,6317,6315,6313,6311,6309,6307,6305,6303,6301,6299,6297,6295,6293,6291,6289,0,6287,6285,6283,6281,6279,6277,6275,6273,6271,6269,6267,6265,6263,6261,6259,0,6257,6255,6253,6251,6249,6247,6245,6243,6241,6239,6237,6235,6233,6231,6229,0,6227,6225,6223,6221,6219,6217,6215,6213,6211,6208,6209,6860,6861,7544,7545,0,8260,8261,9008,9009,9788,9789,10600,10601,11444,11445,12320,12321,13228,13229,14168,0,14169,15140,15141,16144,16145,17180,17181,18248,18249,19348,19349,
	19745,19744,18629,18628,17545,17544,16493,16492,15473,15472,14485,1,14484,13529,13528,12605,12604,11713,11712,10853,10852,10025,10024,9229,9228,8465,8464,1,7733,7732,7032,7030,7028,7026,7024,7022,7020,7018,7016,7014,7012,7010,7008,1,7006,7004,7002,7000,6998,6996,6994,6992,6990,6988,6986,6984,6982,6980,6978,1,6976,6974,6972,6970,6968,6966,6964,6962,6960,6958,6956,6954,6952,6950,6948,1,6946,6944,6942,6940,6938,6936,6934,6932,6930,6928,6926,6924,6922,6920,6918,1,6916,6914,6912,6910,6908,6906,6904,6902,6900,6898,6896,6894,6892,6890,6888,1,6886,6884,6882,6880,6878,6876,6874,6872,6870,6868,6866,6862,6863,7546,7547,1,8262,8263,9010,9011,9790,9791,10602,10603,11446,11447,12322,12323,13230,13231,14170,1,14171,15142,15143,16146,16147,17182,17183,18250,18251,19350,19351,
	19743,19742,18627,18626,17543,17542,16491,16490,15471,15470,14483,0,14482,13527,13526,12603,12602,11711,11710,10851,10850,10023,10022,9227,9226,8463,8462,0,7731,7730,7033,7031,7029,7027,7025,7023,7021,7019,7017,7015,7013,7011,7009,0,7007,7005,7003,7001,6999,6997,6995,6993,6991,6989,6987,6985,6983,6981,6979,0,6977,6975,6973,6971,6969,6967,6965,6963,6961,6959,6957,6955,6953,6951,6949,0,6947,6945,6943,6941,6939,6937,6935,6933,6931,6929,6927,6925,6923,6921,6919,0,6917,6915,6913,6911,6909,6907,6905,6903,6901,6899,6897,6895,6893,6891,6889,0,6887,6885,6883,6881,6879,6877,6875,6873,6871,6869,6867,6864,6865,7548,7549,0,8264,8265,9012,9013,9792,9793,10604,10605,11448,11449,12324,12325,13232,13233,14172,0,14173,15144,15145,16148,16149,17184,17185,18252,18253,19352,19353,
	19741,19740,18625,18624,17541,17540,16489,16488,15469,15468,14481,1,14480,13525,13524,12601,12600,11709,11708,10849,10848,10021,10020,9225,9224,8461,8460,1,7728,7726,7724,7722,7720,7718,7716,7714,7712,7710,7708,7706,7704,7702,7700,1,7698,7696,7694,7692,7690,7688,7686,7684,7682,7680,7678,7676,7674,7672,7670,1,7668,7666,7664,7662,7660,7658,7656,7654,7652,7650,7648,7646,7644,7642,7640,1,7638,7636,7634,7632,7630,7628,7626,7624,7622,7620,7618,7616,7614,7612,7610,1,7608,7606,7604,7602,7600,7598,7596,7594,7592,7590,7588,7586,7584,7582,7580,1,7578,7576,7574,7572,7570,7568,7566,7564,7562,7560,7558,7556,7554,7550,7551,1,8266,8267,9014,9015,9794,9795,10606,10607,11450,11451,12326,12327,13234,13235,14174,1,14175,15146,15147,16150,16151,17186,17187,18254,18255,19354,19355,
	19739,19738,18623,18622,17539,17538,16487,16486,15467,15466,14479,0,14478,13523,13522,12599,12598,11707,11706,10847,10846,10019,10018,9223,9222,8459,8458,0,7729,7727,7725,7723,7721,7719,7717,7715,7713,7711,7709,7707,7705,7703,7701,0,7699,7697,7695,7693,7691,7689,7687,7685,7683,7681,7679,7677,7675,7673,7671,0,7669,7667,7665,7663,7661,7659,7657,7655,7653,7651,7649,7647,7645,7643,7641,0,7639,7637,7635,7633,7631,7629,7627,7625,7623,7621,7619,7617,7615,7613,7611,0,7609,7607,7605,7603,7601,7599,7597,7595,7593,7591,7589,7587,7585,7583,7581,0,7579,7577,7575,7573,7571,7569,7567,7565,7563,7561,7559,7557,7555,7552,7553,0,8268,8269,9016,9017,9796,9797,10608,10609,11452,11453,12328,12329,13236,13237,14176,0,14177,15148,15149,16152,16153,17188,17189,18256,18257,19356,19357,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19737,19736,18621,18620,17537,17536,16485,16484,15465,15464,14477,0,14476,13521,13520,12597,12596,11705,11704,10845,10844,10017,10016,9221,9220,8456,8454,0,8452,8450,8448,8446,8444,8442,8440,8438,8436,8434,8432,8430,8428,8426,8424,0,8422,8420,8418,8416,8414,8412,8410,8408,8406,8404,8402,8400,8398,8396,8394,0,8392,8390,8388,8386,8384,8382,8380,8378,8376,8374,8372,8370,8368,8366,8364,0,8362,8360,8358,8356,8354,8352,8350,8348,8346,8344,8342,8340,8338,8336,8334,0,8332,8330,8328,8326,8324,8322,8320,8318,8316,8314,8312,8310,8308,8306,8304,0,8302,8300,8298,8296,8294,8292,8290,8288,8286,8284,8282,8280,8278,8276,8274,0,8270,8271,9018,9019,9798,9799,10610,10611,11454,11455,12330,12331,13238,13239,14178,0,14179,15150,15151,16154,16155,17190,17191,18258,18259,19358,19359,
	19735,19734,18619,18618,17535,17534,16483,16482,15463,15462,14475,1,14474,13519,13518,12595,12594,11703,11702,10843,10842,10015,10014,9219,9218,8457,8455,1,8453,8451,8449,8447,8445,8443,8441,8439,8437,8435,8433,8431,8429,8427,8425,1,8423,8421,8419,8417,8415,8413,8411,8409,8407,8405,8403,8401,8399,8397,8395,1,8393,8391,8389,8387,8385,8383,8381,8379,8377,8375,8373,8371,8369,8367,8365,1,8363,8361,8359,8357,8355,8353,8351,8349,8347,8345,8343,8341,8339,8337,8335,1,8333,8331,8329,8327,8325,8323,8321,8319,8317,8315,8313,8311,8309,8307,8305,1,8303,8301,8299,8297,8295,8293,8291,8289,8287,8285,8283,8281,8279,8277,8275,1,8272,8273,9020,9021,9800,9801,10612,10613,11456,11457,12332,12333,13240,13241,14180,1,14181,15152,15153,16156,16157,17192,17193,18260,18261,19360,19361,
	19733,19732,18617,18616,17533,17532,16481,16480,15461,15460,14473,0,14472,13517,13516,12593,12592,11701,11700,10841,10840,10013,10012,9216,9214,9212,9210,0,9208,9206,9204,9202,9200,9198,9196,9194,9192,9190,9188,9186,9184,9182,9180,0,9178,9176,9174,9172,9170,9168,9166,9164,9162,9160,9158,9156,9154,9152,9150,0,9148,9146,9144,9142,9140,9138,9136,9134,9132,9130,9128,9126,9124,9122,9120,0,9118,9116,9114,9112,9110,9108,9106,9104,9102,9100,9098,9096,9094,9092,9090,0,9088,9086,9084,9082,9080,9078,9076,9074,9072,9070,9068,9066,9064,9062,9060,0,9058,9056,9054,9052,9050,9048,9046,9044,9042,9040,9038,9036,9034,9032,9030,0,9028,9026,9022,9023,9802,9803,10614,10615,11458,11459,12334,12335,13242,13243,14182,0,14183,15154,15155,16158,16159,17194,17195,18262,18263,19362,19363,
	19731,19730,18615,18614,17531,17530,16479,16478,15459,15458,14471,1,14470,13515,13514,12591,12590,11699,11698,10839,10838,10011,10010,9217,9215,9213,9211,1,9209,9207,9205,9203,9201,9199,9197,9195,9193,9191,9189,9187,9185,9183,9181,1,9179,9177,9175,9173,9171,9169,9167,9165,9163,9161,9159,9157,9155,9153,9151,1,9149,9147,9145,9143,9141,9139,9137,9135,9133,9131,9129,9127,9125,9123,9121,1,9119,9117,9115,9113,9111,9109,9107,9105,9103,9101,9099,9097,9095,9093,9091,1,9089,9087,9085,9083,9081,9079,9077,9075,9073,9071,9069,9067,9065,9063,9061,1,9059,9057,9055,9053,9051,9049,9047,9045,9043,9041,9039,9037,9035,9033,9031,1,9029,9027,9024,9025,9804,9805,10616,10617,11460,11461,12336,12337,13244,13245,14184,1,14185,15156,15157,16160,16161,17196,17197,18264,18265,19364,19365,
	19729,19728,18613,18612,17529,17528,16477,16476,15457,15456,14469,0,14468,13513,13512,12589,12588,11697,11696,10837,10836,10008,10006,10004,10002,10000,9998,0,9996,9994,9992,9990,9988,9986,9984,9982,9980,9978,9976,9974,9972,9970,9968,0,9966,9964,9962,9960,9958,9956,9954,9952,9950,9948,9946,9944,9942,9940,9938,0,9936,9934,9932,9930,9928,9926,9924,9922,9920,9918,9916,9914,9912,9910,9908,0,9906,9904,9902,9900,9898,9896,9894,9892,9890,9888,9886,9884,9882,9880,9878,0,9876,9874,9872,9870,9868,9866,9864,9862,9860,9858,9856,9854,9852,9850,9848,0,9846,9844,9842,9840,9838,9836,9834,9832,9830,9828,9826,9824,9822,9820,9818,0,9816,9814,9812,9810,9806,9807,10618,10619,11462,11463,12338,12339,13246,13247,14186,0,14187,15158,15159,16162,16163,17198,17199,18266,18267,19366,19367,
	19727,19726,18611,18610,17527,17526,16475,16474,15455,15454,14467,1,14466,13511,13510,12587,12586,11695,11694,10835,10834,10009,10007,10005,10003,10001,9999,1,9997,9995,9993,9991,9989,9987,9985,9983,9981,9979,9977,9975,9973,9971,9969,1,9967,9965,9963,9961,9959,9957,9955,9953,9951,9949,9947,9945,9943,9941,9939,1,9937,9935,9933,9931,9929,9927,9925,9923,9921,9919,9917,9915,9913,9911,9909,1,9907,9905,9903,9901,9899,9897,9895,9893,9891,9889,9887,9885,9883,9881,9879,1,9877,9875,9873,9871,9869,9867,9865,9863,9861,9859,9857,9855,9853,9851,9849,1,9847,9845,9843,9841,9839,9837,9835,9833,9831,9829,9827,9825,9823,9821,9819,1,9817,9815,9813,9811,9808,9809,10620,10621,11464,11465,12340,12341,13248,13249,14188,1,14189,15160,15161,16164,16165,17200,17201,18268,18269,19368,19369,
	19725,19724,18609,18608,17525,17524,16473,16472,15453,15452,14465,0,14464,13509,13508,12585,12584,11693,11692,10832,10830,10828,10826,10824,10822,10820,10818,0,10816,10814,10812,10810,10808,10806,10804,10802,10800,10798,10796,10794,10792,10790,10788,0,10786,10784,10782,10780,10778,10776,10774,10772,10770,10768,10766,10764,10762,10760,10758,0,10756,10754,10752,10750,10748,10746,10744,10742,10740,10738,10736,10734,10732,10730,10728,0,10726,10724,10722,10720,10718,10716,10714,10712,10710,10708,10706,10704,10702,10700,10698,0,10696,10694,10692,10690,10688,10686,10684,10682,10680,10678,10676,10674,10672,10670,10668,0,10666,10664,10662,10660,10658,10656,10654,10652,10650,10648,10646,10644,10642,10640,10638,0,10636,10634,10632,10630,10628,10626,10622,10623,11466,11467,12342,12343,13250,13251,14190,0,14191,15162,15163,16166,16167,17202,17203,18270,18271,19370,19371,
	19723,19722,18607,18606,17523,17522,16471,16470,15451,15450,14463,1,14462,13507,13506,12583,12582,11691,11690,10833,10831,10829,10827,10825,10823,10821,10819,1,10817,10815,10813,10811,10809,10807,10805,10803,10801,10799,10797,10795,10793,10791,10789,1,10787,10785,10783,10781,10779,10777,10775,10773,10771,10769,10767,10765,10763,10761,10759,1,10757,10755,10753,10751,10749,10747,10745,10743,10741,10739,10737,10735,10733,10731,10729,1,10727,10725,10723,10721,10719,10717,10715,10713,10711,10709,10707,10705,10703,10701,10699,1,10697,10695,10693,10691,10689,10687,10685,10683,10681,10679,10677,10675,10673,10671,10669,1,10667,10665,10663,10661,10659,10657,10655,10653,10651,10649,10647,10645,10643,10641,10639,1,10637,10635,10633,10631,10629,10627,10624,10625,11468,11469,12344,12345,13252,13253,14192,1,14193,15164,15165,16168,16169,17204,17205,18272,18273,19372,19373,
	19721,19720,18605,18604,17521,17520,16469,16468,15449,15448,14461,0,14460,13505,13504,12581,12580,11688,11686,11684,11682,11680,11678,11676,11674,11672,11670,0,11668,11666,11664,11662,11660,11658,11656,11654,11652,11650,11648,11646,11644,11642,11640,0,11638,11636,11634,11632,11630,11628,11626,11624,11622,11620,11618,11616,11614,11612,11610,0,11608,11606,11604,11602,11600,11598,11596,11594,11592,11590,11588,11586,11584,11582,11580,0,11578,11576,11574,11572,11570,11568,11566,11564,11562,11560,11558,11556,11554,11552,11550,0,11548,11546,11544,11542,11540,11538,11536,11534,11532,11530,11528,11526,11524,11522,11520,0,11518,11516,11514,11512,11510,11508,11506,11504,11502,11500,11498,11496,11494,11492,11490,0,11488,11486,11484,11482,11480,11478,11476,11474,11470,11471,12346,12347,13254,13255,14194,0,14195,15166,15167,16170,16171,17206,17207,18274,18275,19374,19375,
	19719,19718,18603,18602,17519,17518,16467,16466,15447,15446,14459,1,14458,13503,13502,12579,12578,11689,11687,11685,11683,11681,11679,11677,11675,11673,11671,1,11669,11667,11665,11663,11661,11659,11657,11655,11653,11651,11649,11647,11645,11643,11641,1,11639,11637,11635,11633,11631,11629,11627,11625,11623,11621,11619,11617,11615,11613,11611,1,11609,11607,11605,11603,11601,11599,11597,11595,11593,11591,11589,11587,11585,11583,11581,1,11579,11577,11575,11573,11571,11569,11567,11565,11563,11561,11559,11557,11555,11553,11551,1,11549,11547,11545,11543,11541,11539,11537,11535,11533,11531,11529,11527,11525,11523,11521,1,11519,11517,11515,11513,11511,11509,11507,11505,11503,11501,11499,11497,11495,11493,11491,1,11489,11487,11485,11483,11481,11479,11477,11475,11472,11473,12348,12349,13256,13257,14196,1,14197,15168,15169,16172,16173,17208,17209,18276,18277,19376,19377,
	19717,19716,18601,18600,17517,17516,16465,16464,15445,15444,14457,0,14456,13501,13500,12576,12574,12572,12570,12568,12566,12564,12562,12560,12558,12556,12554,0,12552,12550,12548,12546,12544,12542,12540,12538,12536,12534,12532,12530,12528,12526,12524,0,12522,12520,12518,12516,12514,12512,12510,12508,12506,12504,12502,12500,12498,12496,12494,0,12492,12490,12488,12486,12484,12482,12480,12478,12476,12474,12472,12470,12468,12466,12464,0,12462,12460,12458,12456,12454,12452,12450,12448,12446,12444,12442,12440,12438,12436,12434,0,12432,12430,12428,12426,12424,12422,12420,12418,12416,12414,12412,12410,12408,12406,12404,0,12402,12400,12398,12396,12394,12392,12390,12388,12386,12384,12382,12380,12378,12376,12374,0,12372,12370,12368,12366,12364,12362,12360,12358,12356,12354,12350,12351,13258,13259,14198,0,14199,15170,15171,16174,16175,17210,17211,18278,18279,19378,19379,
	19715,19714,18599,18598,17515,17514,16463,16462,15443,15442,14455,1,14454,13499,13498,12577,12575,12573,12571,12569,12567,12565,12563,12561,12559,12557,12555,1,12553,12551,12549,12547,12545,12543,12541,12539,12537,12535,12533,12531,12529,12527,12525,1,12523,12521,12519,12517,12515,12513,12511,12509,12507,12505,12503,12501,12499,12497,12495,1,12493,12491,12489,12487,12485,12483,12481,12479,12477,12475,12473,12471,12469,12467,12465,1,12463,12461,12459,12457,12455,12453,12451,12449,12447,12445,12443,12441,12439,12437,12435,1,12433,12431,12429,12427,12425,12423,12421,12419,12417,12415,12413,12411,12409,12407,12405,1,12403,12401,12399,12397,12395,12393,12391,12389,12387,12385,12383,12381,12379,12377,12375,1,12373,12371,12369,12367,12365,12363,12361,12359,12357,12355,12352,12353,13260,13261,14200,1,14201,15172,15173,16176,16177,17212,17213,18280,18281,19380,19381,
	19713,19712,18597,18596,17513,17512,16461,16460,15441,15440,14453,0,14452,13496,13494,13492,13490,13488,13486,13484,13482,13480,13478,13476,13474,13472,13470,0,13468,13466,13464,13462,13460,13458,13456,13454,13452,13450,13448,13446,13444,13442,13440,0,13438,13436,13434,13432,13430,13428,13426,13424,13422,13420,13418,13416,13414,13412,13410,0,13408,13406,13404,13402,13400,13398,13396,13394,13392,13390,13388,13386,13384,13382,13380,0,13378,13376,13374,13372,13370,13368,13366,13364,13362,13360,13358,13356,13354,13352,13350,0,13348,13346,13344,13342,13340,13338,13336,13334,13332,13330,13328,13326,13324,13322,13320,0,13318,13316,13314,13312,13310,13308,13306,13304,13302,13300,13298,13296,13294,13292,13290,0,13288,13286,13284,13282,13280,13278,13276,13274,13272,13270,13268,13266,13262,13263,14202,0,14203,15174,15175,16178,16179,17214,17215,18282,18283,19382,19383,
	19711,19710,18595,18594,17511,17510,16459,16458,15439,15438,14451,1,14450,13497,13495,13493,13491,13489,13487,13485,13483,13481,13479,13477,13475,13473,13471,1,13469,13467,13465,13463,13461,13459,13457,13455,13453,13451,13449,13447,13445,13443,13441,1,13439,13437,13435,13433,13431,13429,13427,13425,13423,13421,13419,13417,13415,13413,13411,1,13409,13407,13405,13403,13401,13399,13397,13395,13393,13391,13389,13387,13385,13383,13381,1,13379,13377,13375,13373,13371,13369,13367,13365,13363,13361,13359,13357,13355,13353,13351,1,13349,13347,13345,13343,13341,13339,13337,13335,13333,13331,13329,13327,13325,13323,13321,1,13319,13317,13315,13313,13311,13309,13307,13305,13303,13301,13299,13297,13295,13293,13291,1,13289,13287,13285,13283,13281,13279,13277,13275,13273,13271,13269,13267,13264,13265,14204,1,14205,15176,15177,16180,16181,17216,17217,18284,18285,19384,19385,
	19709,19708,18593,18592,17509,17508,16457,16456,15437,15436,14448,0,14446,14444,14442,14440,14438,14436,14434,14432,14430,14428,14426,14424,14422,14420,14418,0,14416,14414,14412,14410,14408,14406,14404,14402,14400,14398,14396,14394,14392,14390,14388,0,14386,14384,14382,14380,14378,14376,14374,14372,14370,14368,14366,14364,14362,14360,14358,0,14356,14354,14352,14350,14348,14346,14344,14342,14340,14338,14336,14334,14332,14330,14328,0,14326,14324,14322,14320,14318,14316,14314,14312,14310,14308,14306,14304,14302,14300,14298,0,14296,14294,14292,14290,14288,14286,14284,14282,14280,14278,14276,14274,14272,14270,14268,0,14266,14264,14262,14260,14258,14256,14254,14252,14250,14248,14246,14244,14242,14240,14238,0,14236,14234,14232,14230,14228,14226,14224,14222,14220,14218,14216,14214,14212,14210,14206,0,14207,15178,15179,16182,16183,17218,17219,18286,18287,19386,19387,
	0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,
	19707,19706,18591,18590,17507,17506,16455,16454,15435,15434,14449,0,14447,14445,14443,14441,14439,14437,14435,14433,14431,14429,14427,14425,14423,14421,14419,0,14417,14415,14413,14411,14409,14407,14405,14403,14401,14399,14397,14395,14393,14391,14389,0,14387,14385,14383,14381,14379,14377,14375,14373,14371,14369,14367,14365,14363,14361,14359,0,14357,14355,14353,14351,14349,14347,14345,14343,14341,14339,14337,14335,14333,14331,14329,0,14327,14325,14323,14321,14319,14317,14315,14313,14311,14309,14307,14305,14303,14301,14299,0,14297,14295,14293,14291,14289,14287,14285,14283,14281,14279,14277,14275,14273,14271,14269,0,14267,14265,14263,14261,14259,14257,14255,14253,14251,14249,14247,14245,14243,14241,14239,0,14237,14235,14233,14231,14229,14227,14225,14223,14221,14219,14217,14215,14213,14211,14208,0,14209,15180,15181,16184,16185,17220,17221,18288,18289,19388,19389,
	19705,19704,18589,18588,17505,17504,16453,16452,15432,15430,15428,1,15426,15424,15422,15420,15418,15416,15414,15412,15410,15408,15406,15404,15402,15400,15398,1,15396,15394,15392,15390,15388,15386,15384,15382,15380,15378,15376,15374,15372,15370,15368,1,15366,15364,15362,15360,15358,15356,15354,15352,15350,15348,15346,15344,15342,15340,15338,1,15336,15334,15332,15330,15328,15326,15324,15322,15320,15318,15316,15314,15312,15310,15308,1,15306,15304,15302,15300,15298,15296,15294,15292,15290,15288,15286,15284,15282,15280,15278,1,15276,15274,15272,15270,15268,15266,15264,15262,15260,15258,15256,15254,15252,15250,15248,1,15246,15244,15242,15240,15238,15236,15234,15232,15230,15228,15226,15224,15222,15220,15218,1,15216,15214,15212,15210,15208,15206,15204,15202,15200,15198,15196,15194,15192,15190,15188,1,15186,15182,15183,16186,16187,17222,17223,18290,18291,19390,19391,
	19703,19702,18587,18586,17503,17502,16451,16450,15433,15431,15429,0,15427,15425,15423,15421,15419,15417,15415,15413,15411,15409,15407,15405,15403,15401,15399,0,15397,15395,15393,15391,15389,15387,15385,15383,15381,15379,15377,15375,15373,15371,15369,0,15367,15365,15363,15361,15359,15357,15355,15353,15351,15349,15347,15345,15343,15341,15339,0,15337,15335,15333,15331,15329,15327,15325,15323,15321,15319,15317,15315,15313,15311,15309,0,15307,15305,15303,15301,15299,15297,15295,15293,15291,15289,15287,15285,15283,15281,15279,0,15277,15275,15273,15271,15269,15267,15265,15263,15261,15259,15257,15255,15253,15251,15249,0,15247,15245,15243,15241,15239,15237,15235,15233,15231,15229,15227,15225,15223,15221,15219,0,15217,15215,15213,15211,15209,15207,15205,15203,15201,15199,15197,15195,15193,15191,15189,0,15187,15184,15185,16188,16189,17224,17225,18292,18293,19392,19393,
	19701,19700,18585,18584,17501,17500,16448,16446,16444,16442,16440,1,16438,16436,16434,16432,16430,16428,16426,16424,16422,16420,16418,16416,16414,16412,16410,1,16408,16406,16404,16402,16400,16398,16396,16394,16392,16390,16388,16386,16384,16382,16380,1,16378,16376,16374,16372,16370,16368,16366,16364,16362,16360,16358,16356,16354,16352,16350,1,16348,16346,16344,16342,16340,16338,16336,16334,16332,16330,16328,16326,16324,16322,16320,1,16318,16316,16314,16312,16310,16308,16306,16304,16302,16300,16298,16296,16294,16292,16290,1,16288,16286,16284,16282,16280,16278,16276,16274,16272,16270,16268,16266,16264,16262,16260,1,16258,16256,16254,16252,16250,16248,16246,16244,16242,16240,16238,16236,16234,16232,16230,1,16228,16226,16224,16222,16220,16218,16216,16214,16212,16210,16208,16206,16204,16202,16200,1,16198,16196,16194,16190,16191,17226,17227,18294,18295,19394,19395,
	19699,19698,18583,18582,17499,17498,16449,16447,16445,16443,16441,0,16439,16437,16435,16433,16431,16429,16427,16425,16423,16421,16419,16417,16415,16413,16411,0,16409,16407,16405,16403,16401,16399,16397,16395,16393,16391,16389,16387,16385,16383,16381,0,16379,16377,16375,16373,16371,16369,16367,16365,16363,16361,16359,16357,16355,16353,16351,0,16349,16347,16345,16343,16341,16339,16337,16335,16333,16331,16329,16327,16325,16323,16321,0,16319,16317,16315,16313,16311,16309,16307,16305,16303,16301,16299,16297,16295,16293,16291,0,16289,16287,16285,16283,16281,16279,16277,16275,16273,16271,16269,16267,16265,16263,16261,0,16259,16257,16255,16253,16251,16249,16247,16245,16243,16241,16239,16237,16235,16233,16231,0,16229,16227,16225,16223,16221,16219,16217,16215,16213,16211,16209,16207,16205,16203,16201,0,16199,16197,16195,16192,16193,17228,17229,18296,18297,19396,19397,
	19697,19696,18581,18580,17496,17494,17492,17490,17488,17486,17484,1,17482,17480,17478,17476,17474,17472,17470,17468,17466,17464,17462,17460,17458,17456,17454,1,17452,17450,17448,17446,17444,17442,17440,17438,17436,17434,17432,17430,17428,17426,17424,1,17422,17420,17418,17416,17414,17412,17410,17408,17406,17404,17402,17400,17398,17396,17394,1,17392,17390,17388,17386,17384,17382,17380,17378,17376,17374,17372,17370,17368,17366,17364,1,17362,17360,17358,17356,17354,17352,17350,17348,17346,17344,17342,17340,17338,17336,17334,1,17332,17330,17328,17326,17324,17322,17320,17318,17316,17314,17312,17310,17308,17306,17304,1,17302,17300,17298,17296,17294,17292,17290,17288,17286,17284,17282,17280,17278,17276,17274,1,17272,17270,17268,17266,17264,17262,17260,17258,17256,17254,17252,17250,17248,17246,17244,1,17242,17240,17238,17236,17234,17230,17231,18298,18299,19398,19399,
	19695,19694,18579,18578,17497,17495,17493,17491,17489,17487,17485,0,17483,17481,17479,17477,17475,17473,17471,17469,17467,17465,17463,17461,17459,17457,17455,0,17453,17451,17449,17447,17445,17443,17441,17439,17437,17435,17433,17431,17429,17427,17425,0,17423,17421,17419,17417,17415,17413,17411,17409,17407,17405,17403,17401,17399,17397,17395,0,17393,17391,17389,17387,17385,17383,17381,17379,17377,17375,17373,17371,17369,17367,17365,0,17363,17361,17359,17357,17355,17353,17351,17349,17347,17345,17343,17341,17339,17337,17335,0,17333,17331,17329,17327,17325,17323,17321,17319,17317,17315,17313,17311,17309,17307,17305,0,17303,17301,17299,17297,17295,17293,17291,17289,17287,17285,17283,17281,17279,17277,17275,0,17273,17271,17269,17267,17265,17263,17261,17259,17257,17255,17253,17251,17249,17247,17245,0,17243,17241,17239,17237,17235,17232,17233,18300,18301,19400,19401,
	19693,19692,18576,18574,18572,18570,18568,18566,18564,18562,18560,1,18558,18556,18554,18552,18550,18548,18546,18544,18542,18540,18538,18536,18534,18532,18530,1,18528,18526,18524,18522,18520,18518,18516,18514,18512,18510,18508,18506,18504,18502,18500,1,18498,18496,18494,18492,18490,18488,18486,18484,18482,18480,18478,18476,18474,18472,18470,1,18468,18466,18464,18462,18460,18458,18456,18454,18452,18450,18448,18446,18444,18442,18440,1,18438,18436,18434,18432,18430,18428,18426,18424,18422,18420,18418,18416,18414,18412,18410,1,18408,18406,18404,18402,18400,18398,18396,18394,18392,18390,18388,18386,18384,18382,18380,1,18378,18376,18374,18372,18370,18368,18366,18364,18362,18360,18358,18356,18354,18352,18350,1,18348,18346,18344,18342,18340,18338,18336,18334,18332,18330,18328,18326,18324,18322,18320,1,18318,18316,18314,18312,18310,18308,18306,18302,18303,19402,19403,
	19691,19690,18577,18575,18573,18571,18569,18567,18565,18563,18561,0,18559,18557,18555,18553,18551,18549,18547,18545,18543,18541,18539,18537,18535,18533,18531,0,18529,18527,18525,18523,18521,18519,18517,18515,18513,18511,18509,18507,18505,18503,18501,0,18499,18497,18495,18493,18491,18489,18487,18485,18483,18481,18479,18477,18475,18473,18471,0,18469,18467,18465,18463,18461,18459,18457,18455,18453,18451,18449,18447,18445,18443,18441,0,18439,18437,18435,18433,18431,18429,18427,18425,18423,18421,18419,18417,18415,18413,18411,0,18409,18407,18405,18403,18401,18399,18397,18395,18393,18391,18389,18387,18385,18383,18381,0,18379,18377,18375,18373,18371,18369,18367,18365,18363,18361,18359,18357,18355,18353,18351,0,18349,18347,18345,18343,18341,18339,18337,18335,18333,18331,18329,18327,18325,18323,18321,0,18319,18317,18315,18313,18311,18309,18307,18304,18305,19404,19405,
	19688,19686,19684,19682,19680,19678,19676,19674,19672,19670,19668,1,19666,19664,19662,19660,19658,19656,19654,19652,19650,19648,19646,19644,19642,19640,19638,1,19636,19634,19632,19630,19628,19626,19624,19622,19620,19618,19616,19614,19612,19610,19608,1,19606,19604,19602,19600,19598,19596,19594,19592,19590,19588,19586,19584,19582,19580,19578,1,19576,19574,19572,19570,19568,19566,19564,19562,19560,19558,19556,19554,19552,19550,19548,1,19546,19544,19542,19540,19538,19536,19534,19532,19530,19528,19526,19524,19522,19520,19518,1,19516,19514,19512,19510,19508,19506,19504,19502,19500,19498,19496,19494,19492,19490,19488,1,19486,19484,19482,19480,19478,19476,19474,19472,19470,19468,19466,19464,19462,19460,19458,1,19456,19454,19452,19450,19448,19446,19444,19442,19440,19438,19436,19434,19432,19430,19428,1,19426,19424,19422,19420,19418,19416,19414,19412,19410,19406,19407,
	19689,19687,19685,19683,19681,19679,19677,19675,19673,19671,19669,0,19667,19665,19663,19661,19659,19657,19655,19653,19651,19649,19647,19645,19643,19641,19639,0,19637,19635,19633,19631,19629,19627,19625,19623,19621,19619,19617,19615,19613,19611,19609,0,19607,19605,19603,19601,19599,19597,19595,19593,19591,19589,19587,19585,19583,19581,19579,0,19577,19575,19573,19571,19569,19567,19565,19563,19561,19559,19557,19555,19553,19551,19549,0,19547,19545,19543,19541,19539,19537,19535,19533,19531,19529,19527,19525,19523,19521,19519,0,19517,19515,19513,19511,19509,19507,19505,19503,19501,19499,19497,19495,19493,19491,19489,0,19487,19485,19483,19481,19479,19477,19475,19473,19471,19469,19467,19465,19463,19461,19459,0,19457,19455,19453,19451,19449,19447,19445,19443,19441,19439,19437,19435,19433,19431,19429,0,19427,19425,19423,19421,19419,19417,19415,19413,19411,19408,19409
);

const CompactAztecMap : array[0..728] of Integer = ( { 27 x 27 data grid }
	609,608,411,413,415,417,419,421,423,425,427,429,431,433,435,437,439,441,443,445,447,449,451,453,455,457,459,
	607,606,410,412,414,416,418,420,422,424,426,428,430,432,434,436,438,440,442,444,446,448,450,452,454,456,458,
	605,604,409,408,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,460,461,
	603,602,407,406,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,462,463,
	601,600,405,404,241,240,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,284,285,464,465,
	599,598,403,402,239,238,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,286,287,466,467,
	597,596,401,400,237,236,105,104,3,5,7,9,11,13,15,17,19,21,23,25,27,140,141,288,289,468,469,
	595,594,399,398,235,234,103,102,2,4,6,8,10,12,14,16,18,20,22,24,26,142,143,290,291,470,471,
	593,592,397,396,233,232,101,100,1,1,2000,2001,2002,2003,2004,2005,2006,0,1,28,29,144,145,292,293,472,473,
	591,590,395,394,231,230,99,98,1,1,1,1,1,1,1,1,1,1,1,30,31,146,147,294,295,474,475,
	589,588,393,392,229,228,97,96,2027,1,0,0,0,0,0,0,0,1,2007,32,33,148,149,296,297,476,477,
	587,586,391,390,227,226,95,94,2026,1,0,1,1,1,1,1,0,1,2008,34,35,150,151,298,299,478,479,
	585,584,389,388,225,224,93,92,2025,1,0,1,0,0,0,1,0,1,2009,36,37,152,153,300,301,480,481,
	583,582,387,386,223,222,91,90,2024,1,0,1,0,1,0,1,0,1,2010,38,39,154,155,302,303,482,483,
	581,580,385,384,221,220,89,88,2023,1,0,1,0,0,0,1,0,1,2011,40,41,156,157,304,305,484,485,
	579,578,383,382,219,218,87,86,2022,1,0,1,1,1,1,1,0,1,2012,42,43,158,159,306,307,486,487,
	577,576,381,380,217,216,85,84,2021,1,0,0,0,0,0,0,0,1,2013,44,45,160,161,308,309,488,489,
	575,574,379,378,215,214,83,82,0,1,1,1,1,1,1,1,1,1,1,46,47,162,163,310,311,490,491,
	573,572,377,376,213,212,81,80,0,0,2020,2019,2018,2017,2016,2015,2014,0,0,48,49,164,165,312,313,492,493,
	571,570,375,374,211,210,78,76,74,72,70,68,66,64,62,60,58,56,54,50,51,166,167,314,315,494,495,
	569,568,373,372,209,208,79,77,75,73,71,69,67,65,63,61,59,57,55,52,53,168,169,316,317,496,497,
	567,566,371,370,206,204,202,200,198,196,194,192,190,188,186,184,182,180,178,176,174,170,171,318,319,498,499,
	565,564,369,368,207,205,203,201,199,197,195,193,191,189,187,185,183,181,179,177,175,172,173,320,321,500,501,
	563,562,366,364,362,360,358,356,354,352,350,348,346,344,342,340,338,336,334,332,330,328,326,322,323,502,503,
	561,560,367,365,363,361,359,357,355,353,351,349,347,345,343,341,339,337,335,333,331,329,327,324,325,504,505,
	558,556,554,552,550,548,546,544,542,540,538,536,534,532,530,528,526,524,522,520,518,516,514,512,510,506,507,
	559,557,555,553,551,549,547,545,543,541,539,537,535,533,531,529,527,525,523,521,519,517,515,513,511,508,509
);

const AztecCodeSet : array[0..127] of Integer = ( { From Table 2 }
	32, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 12, 32, 32, 32, 32, 32, 32,
	32, 32, 32, 32, 32, 32, 32, 4, 4, 4, 4, 4, 23, 8, 8, 8, 8, 8, 8, 8,
	8, 8, 8, 8, 24, 8, 24, 8, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 8, 8,
	8, 8, 8, 8, 4, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
	1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 4, 8, 4, 4, 4, 2, 2, 2,
	2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
	2, 2, 2, 8, 4, 8, 4, 4
);

const AztecSymbolChar : array[0..127] of Integer = ( { From Table 2 }
	0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 300, 14, 15, 16, 17, 18, 19,
	20, 21, 22, 23, 24, 25, 26, 15, 16, 17, 18, 19, 1, 6, 7, 8, 9, 10, 11, 12,
	13, 14, 15, 16, 301, 18, 302, 20, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 21, 22,
	23, 24, 25, 26, 20, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16,
	17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 27, 21, 28, 22, 23, 24, 2, 3, 4,
	5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24,
	25, 26, 27, 29, 25, 30, 26, 27
);

{ Problem characters are:
	300: Carriage Return (ASCII 13)
	301: Comma (ASCII 44)
	302: Full Stop (ASCII 46)
}

const hexbit : array[0..31] of String = ('00000', '00001', '00010', '00011', '00100', '00101', '00110', '00111', '01000', '01001',
	'01010', '01011', '01100', '01101', '01110', '01111', '10000', '10001', '10010', '10011', '10100', '10101',
	'10110', '10111', '11000', '11001', '11010', '11011', '11100', '11101', '11110', '11111'
);

const pentbit : array[0..15] of String = ('0000', '0001', '0010', '0011', '0100', '0101', '0110', '0111', '1000', '1001',
	'1010', '1011', '1100', '1101', '1110', '1111'
);

const tribit : array[0..7] of String = ('000', '001', '010', '011', '100', '101', '110', '111');

const AztecSizes : array[0..31] of Integer = ( { Codewords per symbol }
	21, 48, 60, 88, 120, 156, 196, 240, 230, 272, 316, 364, 416, 470, 528, 588, 652, 720, 790,
	864, 940, 1020, 920, 992, 1066, 1144, 1224, 1306, 1392, 1480, 1570, 1664
);

const AztecCompactSizes : array[0..3] of Integer = ( 17, 40, 51, 76 );

const Aztec10DataSizes : array[0..31] of Integer = ( { Data bits per symbol maximum with 10% error correction }
	96, 246, 408, 616, 840, 1104, 1392, 1704, 2040, 2420, 2820, 3250, 3720, 4200, 4730,
	5270, 5840, 6450, 7080, 7750, 8430, 9150, 9900, 10680, 11484, 12324, 13188, 14076,
	15000, 15948, 16920, 17940
);

const Aztec23DataSizes : array[0..31] of Integer = ( { Data bits per symbol maximum with 23% error correction }
	84, 204, 352, 520, 720, 944, 1184, 1456, 1750, 2070, 2410, 2780, 3180, 3590, 4040,
	4500, 5000, 5520, 6060, 6630, 7210, 7830, 8472, 9132, 9816, 10536, 11280, 12036,
	12828, 13644, 14472, 15348
);

const Aztec36DataSizes : array[0..31] of Integer = ( { Data bits per symbol maximum with 36% error correction }
	66, 168, 288, 432, 592, 776, 984, 1208, 1450, 1720, 2000, 2300, 2640, 2980, 3350,
	3740, 4150, 4580, 5030, 5500, 5990, 6500, 7032, 7584, 8160, 8760, 9372, 9996, 10656,
	11340, 12024, 12744
);

const Aztec50DataSizes : array[0..31] of Integer = ( { Data bits per symbol maximum with 50% error correction }
	48, 126, 216, 328, 456, 600, 760, 936, 1120, 1330, 1550, 1790, 2050, 2320, 2610,
	2910, 3230, 3570, 3920, 4290, 4670, 5070, 5484, 5916, 6360, 6828, 7308, 7800, 8316,
	8844, 9384, 9948
);

const AztecCompact10DataSizes : array[0..3] of Integer = ( 78, 198, 336, 520 );
const AztecCompact23DataSizes : array[0..3] of Integer = ( 66, 168, 288, 440 );
const AztecCompact36DataSizes : array[0..3] of Integer = ( 48, 138, 232, 360 );
const AztecCompact50DataSizes : array[0..3] of Integer = ( 36, 102, 176, 280 );

const AztecOffset : array[0..31] of Integer = (
	66, 64, 62, 60, 57, 55, 53, 51, 49, 47, 45, 42, 40, 38, 36, 34, 32, 30, 28, 25, 23, 21,
	19, 17, 15, 13, 10, 8, 6, 4, 2, 0
);

const AztecCompactOffset : array[0..3] of Integer = ( 6, 4, 2, 0 );

procedure mapshorten(var charmap : TArrayOfInteger; var typemap : TArrayOfInteger; start : Integer; _length : Integer);
begin
  Move(charmap[start + 2], charmap[start + 1], (_length - 1) * SizeOf(Integer));
  Move(typemap[start + 2], typemap[start + 1], (_length - 1) * SizeOf(Integer));
end;

{*
 * Insert a character into the middle of a string at position posn
 }
{procedure insert(var binary_string : TArrayOfChar; posn : Integer; newbit : Char);
var
  i, _end : Integer;
begin
  _end := strlen(binary_string);
  for i := _end downto posn + 1  do
    binary_string[i] := binary_string[i - 1];

  binary_string[posn] := newbit;
end;}

{*
 * Encode input data into a binary string
 }
function aztec_text_process(source : TArrayOfChar; const src_len : Cardinal; var binary_string : TArrayOfChar; gs1 : Integer) : Integer;
var
  bytes : Integer;
  curtable, newtable, lasttable, chartype, map_length, blocks : Integer;
  charmap, typemap : TArrayOfInteger;
  blockmap : array[0..1] of TArrayOfInteger;
  i, j, k : Integer;
  adjusted : Integer;
begin
  SetLength(charmap, src_len * 2);
  SetLength(typemap, src_len * 2);
  SetLength(blockmap[0], src_len); SetLength(blockmap[1], src_len);
  { Lookup input string in encoding table }
  map_length := 0;

  for i := 0 to src_len - 1 do
  begin
    if (gs1 <> 0) and (i = 0) then
    begin
      { Add FNC1 to beginning of GS1 messages }
      charmap[map_length] := 0;
      typemap[map_length] := PUNC; Inc(map_length);
      charmap[map_length] := 400;
      typemap[map_length] := PUNC; Inc(map_length);
    end;
    if ((gs1 <> 0) and (source[i] = '[')) then
    begin
      { FNC1 represented by FLG(0) }
      charmap[map_length] := 0;
      typemap[map_length] := PUNC; Inc(map_length);
      charmap[map_length] := 400;
      typemap[map_length] := PUNC; Inc(map_length);
    end
    else
    begin
      if (source[i] > #127) or (source[i] = #0) then
      begin
        charmap[map_length] := Ord(source[i]);
        typemap[map_length] := BINARY; Inc(map_length);
      end
      else
      begin
        charmap[map_length] := AztecSymbolChar[Ord(source[i])];
        typemap[map_length] := AztecCodeSet[Ord(source[i])]; Inc(map_length);
      end;
    end;
  end;

  { Look for double character encoding possibilities }
  i := 0;
  repeat
    if (((charmap[i] = 300) and (charmap[i + 1] = 11)) and ((typemap[i] = PUNC) and (typemap[i + 1] = PUNC))) then
    begin
      { CR LF combination }
      charmap[i] := 2;
      typemap[i] := PUNC;
      mapshorten(charmap, typemap, i, map_length);
      Dec(map_length);
    end;

    if (((charmap[i] = 302) and (charmap[i + 1] = 1)) and ((typemap[i] = 24) and (typemap[i + 1] = 23))) then
    begin
      { . SP combination }
      charmap[i] := 3;
      typemap[i] := PUNC;
      mapshorten(charmap, typemap, i, map_length);
      Dec(map_length);
    end;

    if (((charmap[i] = 301) and (charmap[i + 1] = 1)) and ((typemap[i] = 24) and (typemap[i + 1] = 23))) then
    begin
      { , SP combination }
      charmap[i] := 4;
      typemap[i] := PUNC;
      mapshorten(charmap, typemap, i, map_length);
      Dec(map_length);
    end;

    if (((charmap[i] = 21) and (charmap[i + 1] = 1)) and ((typemap[i] = PUNC) and (typemap[i + 1] = 23))) then
    begin
      { : SP combination }
      charmap[i] := 5;
      typemap[i] := PUNC;
      mapshorten(charmap, typemap, i, map_length);
      Dec(map_length);
    end;

    Inc(i);
  until not (i < (map_length - 1));

  { look for blocks of characters which use the same table }
  blocks := 1;
  blockmap[0][0] := typemap[0];
  blockmap[1][0] := 1;
  for i := 1 to map_length - 1 do
  begin
    if (typemap[i] = typemap[i - 1]) then
      Inc(blockmap[1][blocks - 1])
    else
    begin
      Inc(blocks);
      blockmap[0][blocks - 1] := typemap[i];
      blockmap[1][blocks - 1] := 1;
    end;
  end;

  i := 1;
  while i <= 8 do
  begin
    if (blockmap[0][0] and i) <> 0 then
    begin
      blockmap[0][0] := i;
      break;
    end;
    i := i shl 1;
  end;

  if (blocks > 1) then
  begin
    { look for adjacent blocks which can use the same table (left to right search) }
    for i := 1 to blocks - 1 do
    begin
      if (blockmap[0][i] and blockmap[0][i - 1]) <> 0 then
        blockmap[0][i] := (blockmap[0][i] and blockmap[0][i - 1]);
    end;


    i := 1;
    while i <= 8 do
    begin
      if (blockmap[0][blocks - 1] and i) <> 0 then
      begin
        blockmap[0][blocks - 1] := i;
        break;
      end;
      i := i shl 1;
    end;

    { look for adjacent blocks which can use the same table (right to left search) }
    for i := blocks - 1 downto 1 do
    begin
      if (blockmap[0][i] and blockmap[0][i + 1]) <> 0 then
        blockmap[0][i] := (blockmap[0][i] and blockmap[0][i + 1]);
    end;

    { determine the encoding table for characters which do not fit
       with adjacent blocks }
    for i := 1 to blocks - 1 do
    begin
      j := 8;
      while j <> 0 do
      begin
        if (blockmap[0][i] and j) <> 0 then
        begin
          blockmap[0][i] := j;
          break;
        end;
      j := j shr 1;
      end;
    end;

    { Combine blocks of the same type }
    i := 0;
    repeat
      if (blockmap[0][i] = blockmap[0][i + 1]) then
      begin
        Inc(blockmap[1][i], blockmap[1][i + 1]);
        for j := i + 1 to blocks - 1 do
        begin
          blockmap[0][j] := blockmap[0][j + 1];
          blockmap[1][j] := blockmap[1][j + 1];
        end;
        Dec(blocks);
      end
      else
        Inc(i);
    until not (i < blocks);
  end;

  { Put the adjusted block data back into typemap }
  j := 0;
  for i := 0 to blocks - 1 do
  begin
    if ((blockmap[1][i] < 3) and (blockmap[0][i] <> 32)) then
    begin { Shift character(s) needed }
      for k := 0 to blockmap[1][i] - 1 do
        typemap[j + k] := blockmap[0][i] + 64;
    end
    else
    begin { Latch character (or byte mode) needed }
      for k := 0 to blockmap[1][i] - 1 do
        typemap[j + k] := blockmap[0][i];
    end;
    Inc(j, blockmap[1][i]);
  end;

  { Don't shift an initial capital letter }
  if (typemap[0] = 65) then typemap[0] := 1;

  { Problem characters (those that appear in different tables with different values) can now be resolved into their tables }
  for i := 0 to map_length - 1 do
  begin
    if ((charmap[i] >= 300) and (charmap[i] < 400)) then
    begin
      curtable := typemap[i];
      if (curtable > 64) then
        Dec(curtable, 64);

      case charmap[i] of
        300: { Carriage Return }
        begin
          case curtable of
            PUNC: charmap[i] := 1;
            MIXED: charmap[i] := 14;
          end;
        end;
        301: { Comma }
        begin
          case curtable of
            PUNC: charmap[i] := 17;
            DIGIT: charmap[i] := 12;
          end;
        end;
        302: { Full Stop }
        begin
          case curtable of
            PUNC: charmap[i] := 19;
            DIGIT: charmap[i] := 13;
          end;
        end;
      end;
    end;
  end;
  binary_string[0]  := #0;

  curtable := UPPER; { start with UPPER table }
  lasttable := UPPER;
  for i := 0 to map_length - 1 do
  begin
    newtable := curtable;
    if ((typemap[i] <> curtable) and (charmap[i] < 400)) then
    begin
      { Change table }
      if (curtable = BINARY) then
      begin
        { If ending binary mode the current table is the same as when entering binary mode }
        curtable := lasttable;
        newtable := lasttable;
      end;
      if (typemap[i] > 64) then
      begin
        { Shift character }
        case typemap[i] of
          (64 + UPPER): { To UPPER }
          begin
            case curtable of
              LOWER: { US }
                concat(binary_string, hexbit[28]);
              MIXED: { UL }
              begin
                concat(binary_string, hexbit[29]);
                newtable := UPPER;
              end;
              PUNC: { UL }
              begin
                concat(binary_string, hexbit[31]);
                newtable := UPPER;
              end;
              DIGIT: { US }
                concat(binary_string, pentbit[15]);
            end;
          end;
          (64 + LOWER): { To LOWER }
          begin
            case curtable of
              UPPER: { LL }
              begin
                concat(binary_string, hexbit[28]);
                newtable := LOWER;
              end;
              MIXED: { LL }
              begin
                concat(binary_string, hexbit[28]);
                newtable := LOWER;
              end;
              PUNC: { UL LL }
              begin
                concat(binary_string, hexbit[31]);
                concat(binary_string, hexbit[28]);
                newtable := LOWER;
              end;
              DIGIT: { UL LL }
              begin
                concat(binary_string, pentbit[14]);
                concat(binary_string, hexbit[28]);
                newtable := LOWER;
              end;
            end;
          end;
          (64 + MIXED): { To MIXED }
          begin
            case curtable of
              UPPER: { ML }
              begin
                concat(binary_string, hexbit[29]);
                newtable := MIXED;
              end;
              LOWER: { ML }
              begin
                concat(binary_string, hexbit[29]);
                newtable := MIXED;
              end;
              PUNC: { UL ML }
              begin
                concat(binary_string, hexbit[31]);
                concat(binary_string, hexbit[29]);
                newtable := MIXED;
              end;
              DIGIT: { UL ML }
              begin
                concat(binary_string, pentbit[14]);
                concat(binary_string, hexbit[29]);
                newtable := MIXED;
              end;
            end;
          end;
          (64 + PUNC): { To PUNC }
          begin
            case curtable of
              UPPER: { PS }
                concat(binary_string, hexbit[0]);
              LOWER: { PS }
                concat(binary_string, hexbit[0]);
              MIXED: { PS }
                concat(binary_string, hexbit[0]);
              DIGIT: { PS }
                concat(binary_string, pentbit[0]);
            end;
          end;
          (64 + DIGIT): { To DIGIT }
          begin
            case curtable of
              UPPER: { DL }
              begin
                concat(binary_string, hexbit[30]);
                newtable := DIGIT;
              end;
              LOWER: { DL }
              begin
                concat(binary_string, hexbit[30]);
                newtable := DIGIT;
              end;
              MIXED: { UL DL }
              begin
                concat(binary_string, hexbit[29]);
                concat(binary_string, hexbit[30]);
                newtable := DIGIT;
              end;
              PUNC: { UL DL }
              begin
                concat(binary_string, hexbit[31]);
                concat(binary_string, hexbit[30]);
                newtable := DIGIT;
              end;
            end;
          end;
        end;
      end
      else
      begin
        { Latch character }
        case typemap[i] of
          UPPER: { To UPPER }
          begin
            case curtable of
              LOWER: { ML UL }
              begin
                concat(binary_string, hexbit[29]);
                concat(binary_string, hexbit[29]);
                newtable := UPPER;
              end;
              MIXED: { UL }
              begin
                concat(binary_string, hexbit[29]);
                newtable := UPPER;
              end;
              PUNC: { UL }
              begin
                concat(binary_string, hexbit[31]);
                newtable := UPPER;
              end;
              DIGIT: { UL }
              begin
                concat(binary_string, pentbit[14]);
                newtable := UPPER;
              end;
            end;
          end;
          LOWER: { To LOWER }
          begin
            case curtable of
              UPPER: { LL }
              begin
                concat(binary_string, hexbit[28]);
                newtable := LOWER;
              end;
              MIXED: { LL }
              begin
                concat(binary_string, hexbit[28]);
                newtable := LOWER;
              end;
              PUNC: { UL LL }
              begin
                concat(binary_string, hexbit[31]);
                concat(binary_string, hexbit[28]);
                newtable := LOWER;
              end;
              DIGIT: { UL LL }
              begin
                concat(binary_string, pentbit[14]);
                concat(binary_string, hexbit[28]);
                newtable := LOWER;
              end;
            end;
          end;
          MIXED: { To MIXED }
          begin
            case curtable of
              UPPER: { ML }
              begin
                concat(binary_string, hexbit[29]);
                newtable := MIXED;
              end;
              LOWER: { ML }
              begin
                concat(binary_string, hexbit[29]);
                newtable := MIXED;
              end;
              PUNC: { UL ML }
              begin
                concat(binary_string, hexbit[31]);
                concat(binary_string, hexbit[29]);
                newtable := MIXED;
              end;
              DIGIT: { UL ML }
              begin
                concat(binary_string, pentbit[14]);
                concat(binary_string, hexbit[29]);
                newtable := MIXED;
              end;
            end;
          end;
          PUNC: { To PUNC }
          begin
            case curtable of
              UPPER: { ML PL }
              begin
                concat(binary_string, hexbit[29]);
                concat(binary_string, hexbit[30]);
                newtable := PUNC;
              end;
              LOWER: { ML PL }
              begin
                concat(binary_string, hexbit[29]);
                concat(binary_string, hexbit[30]);
                newtable := PUNC;
              end;
              MIXED: { PL }
              begin
                concat(binary_string, hexbit[30]);
                newtable := PUNC;
              end;
              DIGIT: { UL ML PL }
              begin
                concat(binary_string, pentbit[14]);
                concat(binary_string, hexbit[29]);
                concat(binary_string, hexbit[30]);
                newtable := PUNC;
              end;
            end;
          end;
          DIGIT: { To DIGIT }
          begin
            case curtable of
              UPPER: { DL }
              begin
                concat(binary_string, hexbit[30]);
                newtable := DIGIT;
              end;
              LOWER: { DL }
              begin
                concat(binary_string, hexbit[30]);
                newtable := DIGIT;
              end;
              MIXED: { UL DL }
              begin
                concat(binary_string, hexbit[29]);
                concat(binary_string, hexbit[30]);
                newtable := DIGIT;
              end;
              PUNC: { UL DL }
              begin
                concat(binary_string, hexbit[31]);
                concat(binary_string, hexbit[30]);
                newtable := DIGIT;
              end;
            end;
          end;
          BINARY: { To BINARY }
          begin
            lasttable := curtable;
            case curtable of
              UPPER: { BS }
              begin
                concat(binary_string, hexbit[31]);
                newtable := BINARY;
              end;
              LOWER: { BS }
              begin
                concat(binary_string, hexbit[31]);
                newtable := BINARY;
              end;
              MIXED: { BS }
              begin
                concat(binary_string, hexbit[31]);
                newtable := BINARY;
              end;
              PUNC: { UL BS }
              begin
                concat(binary_string, hexbit[31]);
                concat(binary_string, hexbit[31]);
                newtable := BINARY;
              end;
              DIGIT: { UL BS }
              begin
                concat(binary_string, pentbit[14]);
                concat(binary_string, hexbit[31]);
                newtable := BINARY;
              end;
            end;

            bytes := 0;
            repeat
              Inc(bytes);
            until not (typemap[i + (bytes - 1)] = BINARY);
            Dec(bytes);

            if (bytes > 2079) then
            begin
              result := ZERROR_TOO_LONG; exit;
            end;

            if (bytes > 31) then
            begin { Put 00000 followed by 11-bit number of bytes less 31 }
              adjusted := bytes - 31;
              concat(binary_string, '00000');
              bscan(binary_string, adjusted, $400);
            end
            else
            begin { Put 5-bit number of bytes }
              bscan(binary_string, bytes, $10);
            end;
          end;
        end;
      end;
    end;
    { Add data to the binary string }
    curtable := newtable;
    chartype := typemap[i];
    if (chartype > 64) then Dec(chartype, 64);
    case chartype of
      UPPER,
      LOWER,
      MIXED,
      PUNC:
      begin
        if (charmap[i] >= 400) then
          concat(binary_string, tribit[charmap[i] - 400])
        else
          concat(binary_string, hexbit[charmap[i]]);
      end;
      DIGIT:
        concat(binary_string, pentbit[charmap[i]]);
      BINARY:
        bscan(binary_string, charmap[i], $80);
    end;
  end;

  if (strlen(binary_string) > 14970) then
  begin
    result := ZERROR_TOO_LONG; exit;
  end;

  result := 0; exit;
end;

function aztec(symbol : zint_symbol; source : TArrayOfByte; _length : Integer) : Integer;
var
  x, y, i, j, data_blocks, ecc_blocks, layers, total_bits : Integer;
  binary_string : TArrayOfChar;
  bit_pattern : TArrayOfChar;
  descriptor : TArrayOfChar;
  adjusted_string : TArrayOfChar;
  desc_data, desc_ecc : TArrayOfByte;
  err_code, ecc_level, compact, data_length, data_maxsize, codeword_size, adjusted_length : Integer;
  remainder, padbits, count, gs1, adjustment_size : Integer;
  reader : Integer;
  comp_loop : Integer;
  local_source : TArrayOfChar;
  t, done, v : Integer;
  data_part, ecc_part : TArrayOfCardinal;
  RSGlobals : TRSGlobals;
begin
  SetLength(binary_string, 20000);
  SetLength(adjusted_string, 20000);
  SetLength(bit_pattern, 20045);
  SetLength(descriptor, 42);
  SetLength(desc_data, 4);
  SetLength(desc_ecc, 6);
  reader := 0;
  comp_loop := 4;
  SetLength(local_source, _length + 1);

  if (symbol.input_mode = GS1_MODE) then gs1 := 1 else gs1 := 0;
  if (symbol.output_options and READER_INIT) <> 0 then begin reader := 1; comp_loop := 1; end;
  if ((gs1 = 1) and (reader = 1)) then
  begin
    strcpy(symbol.errtxt, 'Cannot encode in GS1 and Reader Initialisation mode at the same time');
    result := ZERROR_INVALID_OPTION; exit;
  end;

  //chaosben: imho, the following is a bug, because its done the second time (1st one in zint_library -> reduced_charset)
  {case symbol.input_mode of
    DATA_MODE:
    GS1_MODE:
      memcpy(local_source, source, _length);
      local_source[_length] := '\0';
      break;
    UNICODE_MODE:
      err_code := latin1_process(symbol, source, local_source, &_length);
      if (err_code <> 0) begin result := err_code; end; exit;
      break;
  end;}

  ArrayCopy(local_source, source);
  local_source[_length] := #0;

  err_code := aztec_text_process(local_source, _length, binary_string, gs1);

  if (err_code <> 0) then
  begin
    strcpy(symbol.errtxt, 'Input too long or too many extended ASCII characters');
    result := err_code; exit;
  end;

  if (not ((symbol.option_1 >= -1) and (symbol.option_1 <= 4))) then
  begin
    strcpy(symbol.errtxt, 'Invalid error correction level - using default instead');
    err_code := ZWARN_INVALID_OPTION;
    symbol.option_1 := -1;
  end;

  ecc_level := symbol.option_1;

  if ((ecc_level = -1) or (ecc_level = 0)) then
    ecc_level := 2;

  data_length := strlen(binary_string);

  layers := 0; { Keep compiler happy! }
  data_maxsize := 0; { Keep compiler happy! }
  adjustment_size := 0;
  if (symbol.option_2 = 0) then
  begin { The size of the symbol can be determined by Zint }
    repeat
      { Decide what size symbol to use - the smallest that fits the data }
      compact := 0; { 1 := Aztec Compact, 0 := Normal Aztec }
      layers := 0;

      case ecc_level of
        { For each level of error correction work out the smallest symbol which
        the data will fit in }
        1:
        begin
          for i := 32 downto 1 do
          begin
            if ((data_length + adjustment_size) < Aztec10DataSizes[i - 1]) then
            begin
              layers := i;
              compact := 0;
              data_maxsize := Aztec10DataSizes[i - 1];
            end;
          end;
          for i := comp_loop downto 1 do
          begin
            if ((data_length + adjustment_size) < AztecCompact10DataSizes[i - 1]) then
            begin
              layers := i;
              compact := 1;
              data_maxsize := AztecCompact10DataSizes[i - 1];
            end;
          end;
        end;
        2:
        begin
          for i := 32 downto 1 do
          begin
            if ((data_length + adjustment_size) < Aztec23DataSizes[i - 1]) then
            begin
              layers := i;
              compact := 0;
              data_maxsize := Aztec23DataSizes[i - 1];
            end;
          end;
          for i := comp_loop downto 1 do
          begin
            if ((data_length + adjustment_size) < AztecCompact23DataSizes[i - 1]) then
            begin
              layers := i;
              compact := 1;
              data_maxsize := AztecCompact23DataSizes[i - 1];
            end;
          end;
        end;
        3:
        begin
          for i := 32 downto 0 do
          begin
            if ((data_length + adjustment_size) < Aztec36DataSizes[i - 1]) then
            begin
              layers := i;
              compact := 0;
              data_maxsize := Aztec36DataSizes[i - 1];
            end;
          end;
          for i := comp_loop downto 1 do
          begin
            if ((data_length + adjustment_size) < AztecCompact36DataSizes[i - 1]) then
            begin
              layers := i;
              compact := 1;
              data_maxsize := AztecCompact36DataSizes[i - 1];
            end;
          end;
        end;
        4:
        begin
          for i := 32 downto 1 do
          begin
            if ((data_length + adjustment_size) < Aztec50DataSizes[i - 1]) then
            begin
              layers := i;
              compact := 0;
              data_maxsize := Aztec50DataSizes[i - 1];
            end;
          end;
          for i := comp_loop downto 1 do
          begin
            if ((data_length + adjustment_size) < AztecCompact50DataSizes[i - 1]) then
            begin
              layers := i;
              compact := 1;
              data_maxsize := AztecCompact50DataSizes[i - 1];
            end;
          end;
        end;
      end;

      if (layers = 0) then
      begin { Couldn't find a symbol which fits the data }
        strcpy(symbol.errtxt, 'Input too long (too many bits for selected ECC)');
        result := ZERROR_TOO_LONG; exit;
      end;

      { Determine codeword bit_length - Table 3 }
      codeword_size := 6; { if (layers <= 2) }
      if ((layers >= 3) and (layers <= 8)) then codeword_size := 8;
      if ((layers >= 9) and (layers <= 22)) then codeword_size := 10;
      if (layers >= 23) then codeword_size := 12;

      adjusted_string[0] := #0;
      j := 0; i := 0;
      repeat
        if ((j + 1) mod codeword_size) = 0 then
        begin
          { Last bit of codeword }
          done := 0;
          count := 0;

          { Discover how many '1's in current codeword }
          for t := 0 to codeword_size - 2 do
          begin
            if (binary_string[(i - (codeword_size - 1)) + t] = '1') then Inc(count);
          end;

          if (count = (codeword_size - 1)) then
          begin
            adjusted_string[j] := '0';
            Inc(j);
            done := 1;
          end;

          if (count = 0) then
          begin
						adjusted_string[j] := '1';
            Inc(j);
            done := 1;
          end;

          if (done = 0) then
          begin
						adjusted_string[j] := binary_string[i];
            Inc(j);
            Inc(i);
          end;
        end
        else
        begin
						adjusted_string[j] := binary_string[i];
          Inc(j);
          Inc(i);
        end;
      until not (i <= data_length + 1);
      adjusted_length := strlen(adjusted_string);
      adjustment_size := adjusted_length - data_length;

      { Add padding }
      remainder := adjusted_length mod codeword_size;

      padbits := codeword_size - remainder;
      if (padbits = codeword_size) then padbits := 0;

      for i := 0 to padbits - 1 do
        concat(adjusted_string, '1');
      adjusted_length := strlen(adjusted_string);

      count := 0;
      for i := (adjusted_length - codeword_size) to adjusted_length - 1 do
      begin
        if (adjusted_string[i] = '1') then Inc(count);
      end;
      if (count = codeword_size) then adjusted_string[adjusted_length - 1] := '0';

    until not (adjusted_length > data_maxsize);
    { This loop will only repeat on the rare occasions when the rule about not having all 1s or all 0s
    means that the binary string has had to be _lengthened beyond the maximum number of bits that can
    be encoded in a symbol of the selected size }

  end
  else
  begin { The size of the symbol has been specified by the user }
    if ((reader = 1) and ((symbol.option_2 >= 2) and (symbol.option_2 <= 4))) then
      symbol.option_2 := 5;
    compact := 1; //prevent compiler warning, the next 3 queries cover all cases.
    if ((symbol.option_2 >= 1) and (symbol.option_2 <= 4)) then
    begin
      compact := 1;
      layers := symbol.option_2;
    end;
    if ((symbol.option_2 >= 5) and (symbol.option_2 <= 36)) then
    begin
      compact := 0;
      layers := symbol.option_2 - 4;
    end;
    if ((symbol.option_2 < 0) or (symbol.option_2 > 36)) then
    begin
      strcpy(symbol.errtxt, 'Invalid Aztec Code size');
      result := ZERROR_INVALID_OPTION; exit;
    end;

    { Determine codeword bit_length - Table 3 }
    codeword_size := 6; {if ((layers >= 0) and (layers <= 2))}
    if ((layers >= 3) and (layers <= 8)) then codeword_size := 8;
    if ((layers >= 9) and (layers <= 22)) then codeword_size := 10;
    if (layers >= 23) then codeword_size := 12;

    adjusted_string[0] := #0;
    j := 0; i := 0;
    repeat
      if ((j + 1) mod codeword_size = 0) then
      begin
        { Last bit of codeword }
        done := 0;
        count := 0;

        { Discover how many '1's in current codeword }
        for t := 0 to (codeword_size - 2) do
        begin
          if (binary_string[(i - (codeword_size - 1)) + t] = '1') then Inc(count);
        end;

        if (count = (codeword_size - 1)) then
        begin
          adjusted_string[j] := '0';
          Inc(j);
          done := 1;
        end;

        if (count = 0) then
        begin
          adjusted_string[j] := '1';
          Inc(j);
          done := 1;
        end;

        if (done = 0) then
        begin
          adjusted_string[j] := binary_string[i];
          Inc(j);
          Inc(i);
        end;
      end
      else
      begin
        adjusted_string[j] := binary_string[i];
        Inc(j);
        Inc(i);
      end;

    until not (i <= data_length + 1);
    adjusted_length := strlen(adjusted_string);

    remainder := adjusted_length mod codeword_size;

    padbits := codeword_size - remainder;
    if (padbits = codeword_size) then padbits := 0;

    for i := 0 to padbits - 1 do
      concat(adjusted_string, '1');
    adjusted_length := strlen(adjusted_string);

    count := 0;
    for i := (adjusted_length - codeword_size) to adjusted_length - 1 do
    begin
      if (adjusted_string[i] = '1') then Inc(count);
    end;
    if (count = codeword_size) then adjusted_string[adjusted_length - 1] := '0';

    { Check if the data actually fits into the selected symbol size }
    if (compact <> 0) then
      data_maxsize := codeword_size * (AztecCompactSizes[layers - 1] - 3)
    else
      data_maxsize := codeword_size * (AztecSizes[layers - 1] - 3);

    if (adjusted_length > data_maxsize) then
    begin
      strcpy(symbol.errtxt, 'Data too long for specified Aztec Code symbol size');
      result := ZERROR_TOO_LONG; exit;
    end;

  end;

  if ((reader <> 0) and (layers > 22)) then
  begin
    strcpy(symbol.errtxt, 'Data too long for reader initialisation symbol');
    result := ZERROR_TOO_LONG; exit;
  end;

  data_blocks := adjusted_length div codeword_size;

  if (compact <> 0) then
    ecc_blocks := AztecCompactSizes[layers - 1] - data_blocks
  else
    ecc_blocks := AztecSizes[layers - 1] - data_blocks;

  SetLength(data_part, data_blocks + 3);
  SetLength(ecc_part, ecc_blocks + 3);
  { Copy across data into separate integers }
  FillChar(data_part[0], data_blocks + 2 * SizeOf(Cardinal), 0);
  FillChar(ecc_part[0], ecc_blocks + 2 * SizeOf(Cardinal), 0);

  { Split into codewords and calculate reed-colomon error correction codes }
  case codeword_size of
    6:
    begin
      for i := 0 to data_blocks - 1 do
      begin
        if (adjusted_string[i * codeword_size] = '1') then Inc(data_part[i], 32);
        if (adjusted_string[(i * codeword_size) + 1] = '1') then Inc(data_part[i], 16);
        if (adjusted_string[(i * codeword_size) + 2] = '1') then Inc(data_part[i], 8);
        if (adjusted_string[(i * codeword_size) + 3] = '1') then Inc(data_part[i], 4);
        if (adjusted_string[(i * codeword_size) + 4] = '1') then Inc(data_part[i], 2);
        if (adjusted_string[(i * codeword_size) + 5] = '1') then Inc(data_part[i], 1);
      end;
      rs_init_gf($43, RSGlobals);
      rs_init_code(ecc_blocks, 1, RSGlobals);
      rs_encode_long(data_blocks, data_part, ecc_part, RSGlobals);
      for i := ecc_blocks - 1 downto 0 do
        bscan(adjusted_string, ecc_part[i], $20);
      rs_free(RSGlobals);
    end;
    8:
    begin
      for i := 0 to data_blocks - 1 do
      begin
        if (adjusted_string[i * codeword_size] = '1') then Inc(data_part[i], 128);
        if (adjusted_string[(i * codeword_size) + 1] = '1') then Inc(data_part[i], 64);
        if (adjusted_string[(i * codeword_size) + 2] = '1') then Inc(data_part[i], 32);
        if (adjusted_string[(i * codeword_size) + 3] = '1') then Inc(data_part[i], 16);
        if (adjusted_string[(i * codeword_size) + 4] = '1') then Inc(data_part[i], 8);
        if (adjusted_string[(i * codeword_size) + 5] = '1') then Inc(data_part[i], 4);
        if (adjusted_string[(i * codeword_size) + 6] = '1') then Inc(data_part[i], 2);
        if (adjusted_string[(i * codeword_size) + 7] = '1') then Inc(data_part[i], 1);
      end;
      rs_init_gf($12d, RSGlobals);
      rs_init_code(ecc_blocks, 1, RSGlobals);
      rs_encode_long(data_blocks, data_part, ecc_part, RSGlobals);
      for i := (ecc_blocks - 1) downto 0 do
        bscan(adjusted_string, ecc_part[i], $80);
      rs_free(RSGlobals);
    end;
    10:
    begin
      for i := 0 to data_blocks - 1 do
      begin
        if (adjusted_string[i * codeword_size] = '1') then Inc(data_part[i], 512);
        if (adjusted_string[(i * codeword_size) + 1] = '1') then Inc(data_part[i], 256);
        if (adjusted_string[(i * codeword_size) + 2] = '1') then Inc(data_part[i], 128);
        if (adjusted_string[(i * codeword_size) + 3] = '1') then Inc(data_part[i], 64);
        if (adjusted_string[(i * codeword_size) + 4] = '1') then Inc(data_part[i], 32);
        if (adjusted_string[(i * codeword_size) + 5] = '1') then Inc(data_part[i], 16);
        if (adjusted_string[(i * codeword_size) + 6] = '1') then Inc(data_part[i], 8);
        if (adjusted_string[(i * codeword_size) + 7] = '1') then Inc(data_part[i], 4);
        if (adjusted_string[(i * codeword_size) + 8] = '1') then Inc(data_part[i], 2);
        if (adjusted_string[(i * codeword_size) + 9] = '1') then Inc(data_part[i], 1);
      end;
      rs_init_gf($409, RSGlobals);
      rs_init_code(ecc_blocks, 1, RSGlobals);
      rs_encode_long(data_blocks, data_part, ecc_part, RSGlobals);
      for i := ecc_blocks - 1 downto 0 do
        bscan(adjusted_string, ecc_part[i], $200);
      rs_free(RSGlobals);
    end;
    12:
    begin
      for  i := 0 to data_blocks - 1 do
      begin
        if (adjusted_string[i * codeword_size] = '1') then Inc(data_part[i], 2048);
        if (adjusted_string[(i * codeword_size) + 1] = '1') then Inc(data_part[i], 1024);
        if (adjusted_string[(i * codeword_size) + 2] = '1') then Inc(data_part[i], 512);
        if (adjusted_string[(i * codeword_size) + 3] = '1') then Inc(data_part[i], 256);
        if (adjusted_string[(i * codeword_size) + 4] = '1') then Inc(data_part[i], 128);
        if (adjusted_string[(i * codeword_size) + 5] = '1') then Inc(data_part[i], 64);
        if (adjusted_string[(i * codeword_size) + 6] = '1') then Inc(data_part[i], 32);
        if (adjusted_string[(i * codeword_size) + 7] = '1') then Inc(data_part[i], 16);
        if (adjusted_string[(i * codeword_size) + 8] = '1') then Inc(data_part[i], 8);
        if (adjusted_string[(i * codeword_size) + 9] = '1') then Inc(data_part[i], 4);
        if (adjusted_string[(i * codeword_size) + 10] = '1') then Inc(data_part[i], 2);
        if (adjusted_string[(i * codeword_size) + 11] = '1') then Inc(data_part[i], 1);
      end;
      rs_init_gf($1069, RSGlobals);
      rs_init_code(ecc_blocks, 1, RSGlobals);
      rs_encode_long(data_blocks, data_part, ecc_part, RSGlobals);
      for i := ecc_blocks - 1 downto 0 do
        bscan(adjusted_string, ecc_part[i], $800);
      rs_free(RSGlobals);
    end;
  end;

  { Invert the data so that actual data is on the outside and reed-solomon on the inside }
  FillChar(bit_pattern[0], Length(bit_pattern), '0');

  total_bits := (data_blocks + ecc_blocks) * codeword_size;
  for i := 0 to total_bits - 1 do
  begin
    bit_pattern[i] := adjusted_string[total_bits - i - 1];
  end;

  { Now add the symbol descriptor }
  FillChar(desc_data[0], 4, 0);
  FillChar(desc_ecc[0], 6, 0);
  FillChar(descriptor[0], 42, 0);

  if (compact <> 0) then
  begin
    { The first 2 bits represent the number of layers minus 1 }
    if ((layers - 1) and 2) <> 0 then descriptor[0] := '1' else descriptor[0] := '0';
    if ((layers - 1) and 1) <> 0 then descriptor[1] := '1' else descriptor[1] := '0';
    { The next 6 bits represent the number of data blocks minus 1 }
    if (reader <> 0) then
      descriptor[2] := '1'
    else
      if ((data_blocks - 1) and $20) <> 0 then descriptor[2] := '1' else descriptor[2] := '0';

    i := 3;
    v := $10;
    while v <> 0 do
    begin
      if ((data_blocks - 1) and v) <> 0 then descriptor[i] := '1' else descriptor[i] := '0';
      Inc(i);
      v := v shr 1;
    end;
    descriptor[8] := #0;
  end
  else
  begin
    { The first 5 bits represent the number of layers minus 1 }
    i := 0;
    v := $10;
    while v <> 0 do
    begin
      if ((layers - 1) and v) <> 0 then descriptor[i] := '1' else descriptor[i] := '0';
      Inc(i);
      v := v shr 1;
    end;
    { The next 11 bits represent the number of data blocks minus 1 }
    if (reader <> 0) then
      descriptor[5] := '1'
    else
    begin
      if ((data_blocks - 1) and $400) <> 0 then descriptor[5] :=  '1' else descriptor[5] := '0';
    end;
    i := 6;
    v := $200;
    while v <> 0 do
    begin
      if ((data_blocks - 1) and v) <> 0 then descriptor[i] := '1' else descriptor[i] := '0';
      Inc(i);
      v := v shr 1;
    end;
    descriptor[16] := #0;
  end;

  { Split into 4-bit codewords }
  for i := 0 to 3 do
  begin
    j := i shl 2;
    v := 8;
    while v <> 0 do
    begin
      if (descriptor[j] = '1') then
        Inc(desc_data[i], v);
      Inc(j);
      v := v shr 1;
    end;
  end;

  { Add reed-solomon error correction with Galois field GF(16) and prime
     modulus x^4 + x + 1 (section 7.2.3) }

  rs_init_gf($13, RSGlobals);
  if (compact <> 0) then
  begin
    rs_init_code(5, 1, RSGlobals);
    rs_encode(2, desc_data, desc_ecc, RSGlobals);
    for i := 0 to 4 do
    begin
      j := i shl 2 + 8;
      v := 8;
      while v <> 0 do
      begin
        if (desc_ecc[4 - i] and v) <> 0 then descriptor[j] :=  '1' else descriptor[j] := '0';
        Inc(j);
        v := v shr 1;
      end;
    end;
  end
  else
  begin
    rs_init_code(6, 1, RSGlobals);
    rs_encode(4, desc_data, desc_ecc, RSGlobals);
    for i := 0 to 5 do
    begin
      j := (i shl 2) + 16;
      v := 8;
      while v <> 0 do
      begin
        if (desc_ecc[5 - i] and v) <> 0 then descriptor[j] := '1' else descriptor[j] := '0';
        Inc(j);
        v := v shr 1;
      end;
    end;
  end;
  rs_free(RSGlobals);

  { Merge descriptor with the rest of the symbol }
  for i := 0 to 39 do
  begin
    if (compact <> 0) then
      bit_pattern[2000 + i - 2] := descriptor[i]
    else
      bit_pattern[20000 + i - 2] := descriptor[i];
  end;

  { Plot all of the data into the symbol in pre-defined spiral pattern }
  if (compact <> 0) then
  begin

    for y := AztecCompactOffset[layers - 1] to (27 - AztecCompactOffset[layers - 1]) - 1 do
    begin
      for x := AztecCompactOffset[layers - 1] to (27 - AztecCompactOffset[layers - 1]) - 1 do
      begin
        if (CompactAztecMap[(y * 27) + x] = 1) then
        begin
          set_module(symbol, y - AztecCompactOffset[layers - 1], x - AztecCompactOffset[layers - 1]);
        end;
        if (CompactAztecMap[(y * 27) + x] >= 2) then
        begin
          if (bit_pattern[CompactAztecMap[(y * 27) + x] - 2] = '1') then
          begin
            set_module(symbol, y - AztecCompactOffset[layers - 1], x - AztecCompactOffset[layers - 1]);
          end;
        end;
      end;
      symbol.row_height[y - AztecCompactOffset[layers - 1]] := 1;
    end;
    symbol.rows := 27 - (2 * AztecCompactOffset[layers - 1]);
    symbol.width := 27 - (2 * AztecCompactOffset[layers - 1]);
  end
  else
  begin

    for y := AztecOffset[layers - 1] to (151 - AztecOffset[layers - 1]) - 1 do
    begin
      for x := AztecOffset[layers - 1] to (151 - AztecOffset[layers - 1]) - 1 do
      begin
        if (AztecMap[(y * 151) + x] = 1) then
        begin
          set_module(symbol, y - AztecOffset[layers - 1], x - AztecOffset[layers - 1]);
        end;
        if (AztecMap[(y * 151) + x] >= 2) then
        begin
          if (bit_pattern[AztecMap[(y * 151) + x] - 2] = '1') then
          begin
            set_module(symbol, y - AztecOffset[layers - 1], x - AztecOffset[layers - 1]);
          end;
        end;
      end;
      symbol.row_height[y - AztecOffset[layers - 1]] := 1;
    end;
    symbol.rows := 151 - (2 * AztecOffset[layers - 1]);
    symbol.width := 151 - (2 * AztecOffset[layers - 1]);
  end;

  result := err_code; exit;
end;

function aztec_runes(symbol : zint_symbol; source : TArrayOfByte; _length : Integer) : Integer;
var
  input_value, error_number : Integer;
  binary_string : TArrayOfChar;
  data_codewords, ecc_codewords : TArrayOfByte;
  i, j, v, x, y : Integer;
  RSGlobals : TRSGlobals;
begin
  SetLength(binary_string, 28);
  input_value := 0;
  //error_number := 0;
  SetLength(data_codewords, 3);
  SetLength(ecc_codewords, 6);

  if (_length > 3) then
  begin
    strcpy(symbol.errtxt, 'Input too large');
    result := ZERROR_INVALID_DATA; exit;
  end;

  error_number := is_sane(NEON, source, _length);
  if (error_number <> 0) then
  begin
    strcpy(symbol.errtxt, 'Invalid characters in input');
    result := ZERROR_INVALID_DATA; exit;
  end;

  case _length of
    3:
    begin
      input_value := 100 * StrToInt(Chr(source[0]));
      Inc(input_value, 10 * StrToInt(Chr(source[1])));
      Inc(input_value, StrToInt(Chr(source[2])));
    end;
    2:
    begin
      input_value := 10 * StrToInt(Chr(source[0]));
      Inc(input_value, StrToInt(Chr(source[1])));
    end;
    1: input_value := StrToInt(Chr(source[0]));
  end;

  if (input_value > 255) then
  begin
    strcpy(symbol.errtxt, 'Input too large');
    result := ZERROR_INVALID_DATA; exit;
  end;

  strcpy(binary_string, '');
  bscan(binary_string, input_value, $80);
  SetLength(binary_string, 28);

  data_codewords[0] := 0;
  data_codewords[1] := 0;

  for i := 0 to 1 do
  begin
    j := i shl 2;
    v := 8;
    while v <> 0 do
    begin
      if (binary_string[j] = '1') then
        Inc(data_codewords[i], v);
      Inc(j);
      v := v shr 1;
    end;
  end;

  rs_init_gf($13, RSGlobals);
  rs_init_code(5, 1, RSGlobals);
  rs_encode(2, data_codewords, ecc_codewords, RSGlobals);
  rs_free(RSGlobals);

  strcpy(binary_string, '');

  for i := 0 to 4 do
  begin
    j := (i shl 2) + 8;
    v := 8;
    while v <> 0 do
    begin
      if (ecc_codewords[4 - i] and v) <> 0 then binary_string[j] := '1' else binary_string[j] := '0';
      Inc(j);
      v := v shr 1;
    end;
  end;

  i := 0;
  while i < 28 do
  begin
    if (binary_string[i] = '1') then binary_string[i] := '0' else binary_string[i] := '1';
    Inc(i, 2);
  end;

  for y := 8 to 18 do
  begin
    for x := 8 to 18 do
    begin
      if (CompactAztecMap[(y * 27) + x] = 1) then
      begin
        set_module(symbol, y - 8, x - 8);
      end;
      if (CompactAztecMap[(y * 27) + x] >= 2) then
      begin
        if (binary_string[CompactAztecMap[(y * 27) + x] - 2000] = '1') then
        begin
          set_module(symbol, y - 8, x - 8);
        end;
      end;
    end;
    symbol.row_height[y - 8] := 1;
  end;
  symbol.rows := 11;
  symbol.width := 11;

  result := 0; exit;
end;

end.

