---
id: intro
sidebar_position: 1
---

# LakeSoul 介绍

<!--
SPDX-FileCopyrightText: 2023 LakeSoul Contributors

SPDX-License-Identifier: Apache-2.0
-->

LakeSoul 是由数元灵科技研发并于 2023 年 5 月捐赠给 Linux Foundation AI & Data 基金会的一个的云原生湖仓一体框架，具备高可扩展的元数据管理、ACID 事务、高效灵活的 upsert 操作、Schema 演进和批流一体化处理等特性。

# LakeSoul 的主要特性：
* 弹性架构：计算存储完全分离，不需要固定节点和磁盘，计算存储各自弹性扩容。并且针对云存储做了大量优化，在对象存储上实现了并发一致性、增量更新等功能；使用 LakeSoul 不需要维护固定的存储节点，云上对象存储的成本只有本地磁盘的 1/10，极大地降低了存储成本和运维成本；
* 高效可扩展的元数据管理：LakeSoul 使用 Postgres 数据库来管理文件元数据，可以高效的处理元数据的修改，并能够支持多并发写入，解决了 Hive 等元数据层的性能瓶颈，如长时间运行后元数据解析缓慢的痛点。元数据层的表结构经过精心设计，所有读写操作都能够使用主键索引，达到很高的 Ops。同时，元数据库在云上也能够很容易地进行扩容。
* ACID 事务：通过元数据库事务机制实现了两阶段提交协议，保证了流批一体提交的事务性，用户不会看到不一致数据；支持多并发写入，自动冲突处理机制；
* 多级分区模式和高效灵活的 upsert 操作：LakeSoul 支持 range 和 hash 分区，通过灵活的 upsert 功能，支持行、列级别的增、删、改等更新操作，将 upsert 数据以 delta file 的形式保存，大幅提高了写数据效率和并发性，而优化过的 merge scan 提供了高效的 MergeOnRead 读取性能；
* 批流一体：LakeSoul 支持 streaming sink，可以同时处理流式数据摄入和历史数据批量回填、交互式查询等场景；
* Schema 演进：支持新增、删除列，并在读取时自动兼容旧数据；
* CDC 流、日志流自动同步：支持 MySQL 整库千表同步，自动建表和自动 Schema 变更；支持 Kafka 多 topic 合并同步、自动 Schema 解析、自动新 Topic 感知；
* 高性能 IO：使用 Rust Arrow 实现原生 Parquet IO，并对对象存储访问做了专门优化，性能优势明显；
* 完整支持 Flink Changelog 语义，能够支持增量流式读取，通过 Flink SQL 即可实现实时数仓全链路增量计算；
* 多种计算引擎支持：目前支持 Spark、Flink 以流或批的方式进行读和写，支持 Presto 查询，支持 Python/PyTorch 直接读取湖仓表。
* 支持多空间多租户权限隔离：LakeSoul 使用 Postgres 的 RBAC 和行级别安全策略，实现了元数据的权限隔离。配合 Hadoop 用户和组，可以实现物理数据隔离。LakeSoul 的权限隔离对 SQL/Java/Python 的 作业都是有效的。
* 支持自动压缩、自动过期数据清理、自动冗余数据清理。

## LakeSoul 的适用场景
* 为 BI、AI 提供统一的数据底座，多种计算引擎直接高效读写；
* 构建实时湖仓，并且新增数据需要高效实时大批量写入，同时需要行、列级别的并发增量更新的场景；
* 历史数据存储量很大，并且需要对大跨度时间范围做明细查询、修改，同时希望使用对象存储控制成本的场景；
* 查询请求不固定，资源消耗变化较大，希望计算资源能够独立弹性伸缩的场景；
* 需要多并发写，同时文件数量多，对元数据性能和并发有较高要求的场景；
* 针对主键进行数据更新，对写吞吐有较高有求的场景；