<!--
SPDX-FileCopyrightText: 2023 LakeSoul Contributors

SPDX-License-Identifier: Apache-2.0
-->

# Community Roles
## Users: 
Users are technology users who only use products but do not contribute, but users can still play a role in the community, including but not limited to: 
- Participates in an event hosted by LakeSoul
- Recommend LakeSoul
- Propose requirements for the product 

## Contributors: 
Contributors are technical people who contribute code or combine code. Contributors can make a difference in several ways, including but not limited to: 
- Authoring or reviewing PRs, but do not have the right to merge
- Filing or commenting on issues
- Contributing to SIG, WG, or community discussions (e.g., IRC, meetings, email discussion forums, Stack Overflow.)
- Content creator, promoting and advocating the community.

## Technical Manager: 
The technical manager is the contributor with authority to merge the code. The technical manager is responsible for reviewing the acceptance of contributions, not only for code quality but also for the overall impact of the contribution, including compatibility, performance, and interaction with other areas. The Technical Managers need to be active contributors for at least four months and be selected by all relevant contributors in a voting process within the Project Innovation Group and community Governance Committee. The first batch of technical managers will serve for one year. After the first year, all technical managers need to qualify through open elections. 

## Community Manager: 
The community manager is the person who helps manage day-to-day governance operations. This role is appointed by the Technical Governance Board and does not have any code or voting privileges. This role has no term limit, and its duration is only subject to the governance charter approved by the Technical Governance Committee. 

## Partners: 
Community partners are organizations (including but not limited to companies, universities, research institutes, industry associations, open-source foundations/communities/projects.) that support LakeSoul in one or more of the following ways: 
- Involve staff or students in the project innovation team, community governance committee, or technology governance committee 
- Host a workshop or meetup for LakeSoul 
- Provide resources to build or host an asset
- Promote the product by participating in the media or PR campaign
- Lent support for products 
- Collaborate with for open source development

## Organizational Structure
The organizational structure of the community is as follows, with all governance and execution planning and coordination as follows: 

- The Technical Governance Board is composed of several people whose primary task is to define and iterate on the vision, goals, products, and governance processes of the community. 
- Community Governance Committee is composed of a certain number of people whose main task is to maintain the friendly atmosphere of the community and build the open source ecology. 
- The project Innovation team is responsible for specific projects. The project innovation team must have an open and transparent process. Anyone is welcome to participate and contribute, subject to the code of conduct. The purpose of the project innovation team is to develop a goal to be achieved over some time, then collect input, drive consensus and closure, and implement code contributions and other related activities to achieve the goal. The project innovation team is also responsible for the ongoing maintenance of the code in its area. 

## Organization function 
### Technical Governance Committee 
A technology governance board participates in a series of rights and responsibilities, including: 
- Define, evolve, and defend the community's vision, values, mission, and scope.
- Define, develop and uphold a code of conduct, including a neutral and impartial process for resolving conflict. 
- Define and develop the project governance structure and strategy, including how members become contributors, technical managers, chairs of a technical governance committee, and more. 
- Charter and refine policy for defining new community groups and promote transparency and accountability for those groups 
- Decide who is a member of the community and what privileges are required.
- Decide which functional areas and areas are part of the community, including projects by the project innovation team.
- Decide how and when product is officially released.
- Declare releases when quality/feature/other requirements are met.
- Static Defines any authentication process. 
- Make decisions by majority vote if consensus cannot be reached.

### Community Governance Committee 
Consolidate code, specifications, recommendations, or implementations for submission to the relevant project innovation team for approval and acceptance. 
Manage the brand and any external marketing 
Identify specific problems to be solved and user needs 
Maintain good community ecology

### Project Innovation Team
There are two project innovation groups, including LakeSoul and MetaSpore. 
The community's project innovation team consists of individuals from multiple companies and organizations with the common purpose of advancing projects on specific topics. Our goal is to implement a distributed decision structure and code ownership and provide a forum for completing work, making decisions, and joining new contributors. Each identifiable part of the project (for example, repositories, subdirectories, APIs, tests, questions, PR, IRC) is intended to be owned by a project innovation team. 

## Criteria: 
All code projects are under the Apache 2.0 license 
Must use creative Commons License Version 4.0 
