<!--
SPDX-FileCopyrightText: 2023 LakeSoul Contributors

SPDX-License-Identifier: Apache-2.0
-->

# Community guidelines
Welcome to the community! In the community, any voice of users is valued. We hope you can share your scenarios of using products and the problems you encounter when using products. No matter the functional requirements, or the bugs in the code, community members will solve them for you. We hope you can actively communicate with other community members to provide a continuous energy flow. Welcome every technical practitioner to participate in the governance of the community (including but not limited to product updates and iteration and community ecological maintenance.). To better understand and participate in the management of the open source community, please read the following community guidelines to understand the principles, usage specifications, and community organization structure of the community. We hope you can join us in building a friendly, inclusive, and leading open source community.

# Overview
We embrace open source to create a truly open ecosystem that provides a friendly atmosphere for developers. We focus on providing one-stop cloud-native data intelligent platform services for data scientists and AI practitioners, one-stop supporting services for the digital transformation and intelligent upgrading of governments and SMEs, accelerating the implementation and empowerment of AI technology to the actual business. 

# Usage
- Code or tutorial: available via Code/Wiki 
- Bugs or Issues: Raise any problems you encounter via Issues 
- Feedback or Suggestions: Submit via Discussion, which is better in the format of "Scenarios used, several feature points of most interest, and question feedback."

# Feedback Format 
It's better to publish your content **in the following format**: 
- Your organization, company, or school 
- Your area 
- Your contact information, including but not limited to email, wechat, social network account, etc 
- Scenarios in which you use/expect to use a telethon product 
- Feature points you are interested in/looking forward to 
- Your suggestions or feedback 

**Example**: 

    Enterprise: Your Company

    Location: Beijing, China 

    Contact: lakesoul-technical-discuss@lists.lfaidata.foundation

    Usage scenario: Use LakeSoul to build the real-time machine learning sample library 
    
    Function points of interest: Upsert; Set primary key; Historical data batch update backtracking 

    Suggestions or feedback: improve more features to provide users with a better experience 

# Principles
The LakeSoul community adheres to the following principles:
- **Open and transparent**: LakeSoul is open source, and anyone can openly discuss all kinds of technical issues. 
- **Collaboration, inclusion**: Any work or issue is welcome to be discussed in the community. 
- **Friendly and respectful**: anyone is welcome to use LakeSoul, and everyone's contribution is respected. 
- **Industry-leading**: LakeSoul will provide the latest technology so that every technical practitioner can enjoy the frontier dividend of data intelligence.

Click on [Community Roles](./community-roles.md) to learn more about community organizations.
 
