<?php

namespace Edamam\Support;

class Nutrient
{
    /**
     * Calcium in mg.
     *
     * @return string
     */
    const CALCIUM = 'CA';

    /**
     * Energy in kcal.
     *
     * @return string
     */
    const CALORIES = 'ENERC_KCAL';

    /**
     * Carbohydrates in g.
     *
     * @return string
     */
    const CARBS = 'CHOCDF';

    /**
     * Niacin (Vitamin B3) in mg.
     *
     * @return string
     */
    const VITAMIN_B3 = 'NIA';

    /**
     * Cholesterol in mg.
     *
     * @return string
     */
    const CHOLESTEROL = 'CHOLE';

    /**
     * Phosphorus in mg.
     *
     * @return string
     */
    const PHOSPHORUS = 'P';

    /**
     * Monounsaturated fats in g.
     *
     * @return string
     */
    const MONOUNSATURATED_FAT = 'FAMS';

    /**
     * Protein in g.
     *
     * @return string
     */
    const PROTEIN = 'PROCNT';

    /**
     * Polyunsaturated fats in g.
     *
     * @return string
     */
    const POLYUNSATURATED_FAT = 'FAPU';

    /**
     * Riboflavin (Vitamin B2) in mg.
     *
     * @return string
     */
    const VITAMIN_B2 = 'RIBF';

    /**
     * Sugar in g.
     *
     * @return string
     */
    const SUGAR = 'SUGAR';

    /**
     * Added sugars in g.
     *
     * @return string
     */
    const SUGAR_ADDED = 'SUGAR.added';

    /**
     * Fat in g.
     *
     * @return string
     */
    const FAT = 'FAT';

    /**
     * Saturated fats in g.
     *
     * @return string
     */
    const SATURATED_FAT = 'FASAT';

    /**
     * Trans-fats in g.
     *
     * @return string
     */
    const TRANS_FAT = 'FATRN';

    /**
     * Vitamin E in mg.
     *
     * @return string
     */
    const VITAMIN_E = 'TOCPHA';

    /**
     * Iron in mg.
     *
     * @return string
     */
    const IRON = 'FE';

    /**
     * Vitamin A in mcg.
     *
     * @return string
     */
    const VITAMIN_A = 'VITA_RAE';

    /**
     * Fiber measured in g.
     *
     * @return string
     */
    const FIBER = 'FIBTG';

    /**
     * Vitamin B12 measured in mcg.
     *
     * @return string
     */
    const VITAMIN_B12 = 'VITB12';

    /**
     * Folate (Vitamin B9) measured in mcg.
     *
     * @return string
     */
    const VITAMIN_B9 = 'FOLDFE';

    /**
     * Potassium measured in mg.
     *
     * @return string
     */
    const POTASSIUM = 'K';

    /**
     * Vitamin C measured in mg.
     *
     * @return string
     */
    const VITAMIN_C = 'VITC';

    /**
     * Magnesium measured in mg.
     *
     * @return string
     */
    const MAGNESIUM = 'MG';

    /**
     * Vitamin D measured in mcg.
     *
     * @return string
     */
    const VITAMIN_D = 'VITD';

    /**
     * Sodium measured in mg.
     *
     * @return string
     */
    const SODIUM = 'NA';

    /**
     * Vitamin K measured in mcg.
     *
     * @return string
     */
    const VITAMIN_K = 'VITK1';

    /**
     * Vitamin B6 measured in mg.
     *
     * @return string
     */
    const VITAMIN_B6 = 'VITB6A';

    /**
     * Thiamin (Vitamin B1) measured in mg.
     *
     * @return string
     */
    const VITAMIN_B1 = 'THIA';

    /**
     * Zinc measured in mg.
     */
    const ZINC = 'ZN';
}
