#!/usr/bin/python3

import csv
import os
import tempfile
import exploitdb
import shodandb
import display
import time

class Main:

  def __init__(self): 
    self.file = "files.csv"
    self.os = os.name
    self.foundList = []
    self.headerList = []
    self.width = None
    self.height = None
    self.file = "files.csv"
      #Calls to main Functions of program
  ##
  ##  self.searchDB(search)
  ##  self.getTerminalSize()
  ##  resultsPagesList = self.createPageLists(self.foundList)
  ##  self.createPageListing(resultsPagesList)

    self.getTerminalSize()
      
  def getTerminalSize(self):

    env = os.environ
    def ioctl_GWINSZ(fd):
        try:
            import fcntl, termios, struct, os
            cr = struct.unpack('hh', fcntl.ioctl(fd, termios.TIOCGWINSZ,
        '1234'))
        except:
            return
        return cr
    cr = ioctl_GWINSZ(0) or ioctl_GWINSZ(1) or ioctl_GWINSZ(2)
    if not cr:
        try:
            fd = os.open(os.ctermid(), os.O_RDONLY)
            cr = ioctl_GWINSZ(fd)
            os.close(fd)
        except:
            pass
    if not cr:
        cr = (env.get('LINES', 25), env.get('COLUMNS', 80))

        ### Use get(key[, default]) instead of a try/catch
        #try:
        #    cr = (env['LINES'], env['COLUMNS'])
        #except:
        #    cr = (25, 80)

    self.width = int(cr[1])
    self.height = int(cr[0])
    

  def createTempFile(self,path):    #Writes and opens a temporary file with the shell code in it.
    with open(path,mode="r",encoding="utf-8") as myFile:
      content = myFile.readlines()
    
    with tempfile.NamedTemporaryFile(mode="w",delete=False) as temp:
      
      for line in content:
        temp.write(line)
      
      temp.flush()
      
      if self.os == "nt": #NT Systems - Windows
          
          os.system('start notepad.exe ' + temp.name)
          
      else: #Linux Systems
          os.system('%s %s' % (os.getenv('EDITOR'), temp.name))

  def createTempFileShodan(self,content):    #Writes and opens a temporary file with the shell code in it.

    with tempfile.NamedTemporaryFile(mode="w",delete=False) as temp:
      
      for line in content:
        temp.write(line)
      
      temp.flush()
      
      if self.os == "nt": #NT Systems - Windows
          
          os.system('start notepad.exe ' + temp.name)
          
      else: #Linux Systems

          os.system('%s %s' % (os.getenv('EDITOR'), temp.name))

  def createPageListingExploitDB(self,resultsPagesList):
    
    width  = self.width
    height = self.height

    totalResults = len(self.foundList)
      

    end = False
    print("-" * width)

    currentPage = 0
    pageNavigation = """
          ________________________________________________________________
         |                                                                |
         |  Navigation Options                                            |
         |                                                                |
         |  - Enter 'p' followed by page number (e.g. 'p4', 'p5')         |
         |  - Enter 'e' followed by the exploit number (e.g. 'e3', 'e11') |
         |  - Enter 'exit' to return to the main menu                     |
         |________________________________________________________________|
         
         """
    totalNumOfPages = len(resultsPagesList)
    print(pageNavigation)
    input("Press [enter] to continue...")
    while end == False:
      
      print("-" * width)
      print("Current page - {0}".format(currentPage + 1),end=" | ")
      print("Exploits - {0}".format(totalResults),end=" | ")
      print("Pages - {0}".format(totalNumOfPages),end="\n")
      print()
      
      for num in range(0,len(resultsPagesList[currentPage])):

        print("{0}. {1}".format((((currentPage + 1) * 10) - 10 + (num + 1)),resultsPagesList[currentPage][num][2]))
        #resultsPagesList[currentPage][num]['pagenum'] = currentPage
      print()
      print("-" * width)
      print()


      
      
      try:
        
        choice = input("Enter option: ")

        if choice == 'exit':
        
          break

        else:
          pNumber = int(choice[1:])

          ##Navigate pages
          
          
          if choice[0] == "p":

              
              if pNumber > 0 and pNumber <= totalNumOfPages:

                currentPage = int(choice[1:]) - 1
              else:
                print()
                print("Please choose a page number in range...")


          ##Navigate Exploits
          
          elif choice[0] == "e":
              exploitNumber = int(choice[1:])

              exploitMenu = """
          _______________________________
         |                               |
         |  Exploit Options              |
         |                               |
         |  1. View Full Details         |
         |  2. View Shell Code           |
         |  3. Continue                  |
         |_______________________________|
         
         """
              print(exploitMenu)

              exploitMenuChoice = 0
              while exploitMenuChoice != 3:
                  
                  if exploitNumber % 10 == 0:
                              
                              pageOfExploit = (exploitNumber // 10) - 1
                              exploitNumInList = 9
                              
                          
                  else:
                              
                      pageOfExploit = (exploitNumber // 10)
                      exploitNumInList = (exploitNumber % 10) - 1

                  print("-" * width)
            
                  exploitMenuChoice = int(input("Please choose an option: "))
                  
                  if exploitMenuChoice == 1:
                      print("\nFull Details\n")
                      for each in self.headerList:

                        print(each)
                          
                  elif exploitMenuChoice == 2:
                      try:
                    #Open the code of the exploit in a temp file
                          if exploitNumber % 10 == 0:
                              
                              pageOfExploit = (exploitNumber // 10) - 1
                              exploitNumInList = 9
                              self.createTempFile(resultsPagesList[pageOfExploit][exploitNumInList][1])

                          
                          else:
                              pageOfExploit = (exploitNumber // 10)
                              exploitNumInList = (exploitNumber % 10) - 1
                          
                              self.createTempFile(resultsPagesList[pageOfExploit][exploitNumInList][1])
                      except KeyError:
                          print("Code unvailable for this exploit. Refer to online site for database provider.")
                  elif choice == 3:
                      continue
                  
             
            
      except ValueError:
        print()
        print("Please enter a valid option !")



  def createPageListingShodan(self,resultsPagesList, keyDataList):
    
    width, height = self.width, self.height

    totalResults = keyDataList[0]
      

    end = False
    print("-" * width)

    currentPage = 0
    pageNavigation = """
          ________________________________________________________________
         |                                                                |
         |  Navigation Options                                            |
         |                                                                |
         |  - Enter 'p' followed by page number (e.g. 'p4', 'p5')         |
         |  - Enter 'e' followed by the exploit number (e.g. 'e3', 'e11') |
         |  - Enter 'exit' to return to the main menu                     |
         |________________________________________________________________|
         
         """
    totalNumOfPages = len(resultsPagesList)
    print(pageNavigation)
    input("Press [enter] to continue...")
    while end == False:
      
      print("-" * width)
      print("Current page - {0}".format(currentPage + 1),end=" | ")
      print("Exploits - {0}".format(totalResults),end=" | ")
      print("Pages - {0}".format(totalNumOfPages),end="\n")
      print()
      
      for num in range(0,len(resultsPagesList[currentPage])):
        descTitle = resultsPagesList[currentPage][num]['description'].split('\n',1)
        descTitle = descTitle[0]
        print("{0}. {1}".format((((currentPage + 1) * 10) - 10 + (num + 1)),descTitle))
        resultsPagesList[currentPage][num]['pagenum'] = currentPage
      print()
      print("-" * width)
      print()


      
      
      try:
        
        choice = input("Enter option: ")

        if choice == 'exit':
        
          break

        else:
          pNumber = int(choice[1:])

          ##Navigate pages
          
          
          if choice[0] == "p":

              
              if pNumber > 0 and pNumber <= totalNumOfPages:

                currentPage = int(choice[1:]) - 1
              else:
                print()
                print("Please choose a page number in range...")


          ##Navigate Exploits
          
          elif choice[0] == "e":
              exploitNumber = int(choice[1:])

              exploitMenu = """
          _______________________________
         |                               |
         |  Exploit Options              |
         |                               |
         |  1. View Full Details         |
         |  2. View Shell Code           |
         |  3. Continue                  |
         |_______________________________|
         
         """
              print(exploitMenu)

              exploitMenuChoice = 0
              while exploitMenuChoice != 3:
                  
                  if exploitNumber % 10 == 0:
                              
                              pageOfExploit = (exploitNumber // 10) - 1
                              exploitNumInList = 9
                              
                          
                  else:
                              
                      pageOfExploit = (exploitNumber // 10)
                      exploitNumInList = (exploitNumber % 10) - 1

                  print("-" * width)
            
                  exploitMenuChoice = int(input("Please choose an option: "))
                  
                  if exploitMenuChoice == 1:
                      print("\nFull Details\n")
                      for key,value in resultsPagesList[pageOfExploit][exploitNumInList].items():
                          if key == 'code':
                              print("Code \t\t\t See Code Option")
                          elif key == 'description':
                              print("Desc \t\t\t",value)
                          elif key == 'platform':
                              print(key.title(), "\t\t",value)
                          elif key == 'pagenum':
                              print(key.title(), "\t\t",value)
                          else:
                              print(key.title(), "\t\t\t",value)
                  elif exploitMenuChoice == 2:
                      try:
                    #Open the code of the exploit in a temp file
                          if exploitNumber % 10 == 0:
                              
                              pageOfExploit = (exploitNumber // 10) - 1
                              exploitNumInList = 9
                              self.createTempFileShodan(resultsPagesList[pageOfExploit][exploitNumInList]['code'])

                          
                          else:
                              pageOfExploit = (exploitNumber // 10)
                              exploitNumInList = (exploitNumber % 10) - 1
                          
                              self.createTempFileShodan(resultsPagesList[pageOfExploit][exploitNumInList]['code'])
                      except KeyError:
                          print("Code unvailable for this exploit. Refer to online site for database provider.")
                  elif choice == 3:
                      continue
                  
             
            
      except ValueError:
        print()
        print("Please enter a valid option !")
        
  def createPageListsExploitDB(self,results):
    
      #Too much data to output at once format into pages
    resultsPagesList = []

    totalResults = len(results)
    
    if totalResults > 10:

      totalPages = int(totalResults // 10)

      if (totalResults % 10) > 0:

        totalPages += 1

      
      
      for page in range(1,totalPages + 1):

        resultsList = []

        #Counter Variables for creating lists for each page
        
        endNum = (page * 10)

        startNum = (page * 10) - 10
        
        #If last page use the total pages variable as the end number
        
        if endNum > totalResults:

          endNum = totalResults

        #Create lists
          
        resultsList = results[startNum:endNum]
       
        resultsPagesList.append(resultsList)
         

    #10 or less results = one page
        
    else:
      
      endNum = totalResults

      startNum = 0

      #Create lists
        
      resultsList = results[startNum:endNum]

      resultsPagesList.append(resultsList)


      return resultsPagesList

    endNum = (page * 10)

    startNum = (page * 10) - 10
        
        #If last page use the total pages variable as the end number
        
    if endNum > totalResults:

          endNum = totalResults

        #Create lists
          
          resultsList = results[startNum:endNum]
       
          resultsPagesList.append(resultsList)
         

    #10 or less results = one page
        
    else:
      
      endNum = totalResults

      startNum = 0

      #Create lists
        
      resultsList = results[startNum:endNum]

      resultsPagesList.append(resultsList)


    return resultsPagesList


  
if __name__ == "__main__":

  end = False

  while end != True:
    displayLib = display.Display()
    option = int(input("Please choose now:"))
    main = Main()
    if option == 1:
      try:
        try:
          searchQuery = input("Search Query:")
        except ValueError:
          print("Please enter a correct search string...")
        newShodan = shodandb.ShodanDB_Search(searchQuery)
        resultsPagesList, keyDataList = newShodan.searchShodan()
        main.createPageListingShodan(resultsPagesList, keyDataList)
      except Exception as e:
        print("\nError Reporting: {0}\n".format(e))
        input("Press enter to continue...")
        
    elif option == 2:
      searchQuery = input("Search Query:")
      eDB = exploitdb.ExploitDB_Search(searchQuery)
      eDB.searchDB()
      foundList = eDB.foundList
      resultsPagesList = main.createPageListsExploitDB(foundList)
      main.createPageListingExploitDB(resultsPagesList)

    

  
