# Contributing

Thank you for your interest in contributing to Zeta! We welcome contributions from the community to help improve usability and readability. By contributing, you can be a part of creating a dynamic and interactive AI system.

To get started, please follow the guidelines below.


## Optimization Priorities

To continuously improve Zeta, we prioritize the following design objectives:

1. **Usability**: Increase the ease of use and user-friendliness of the swarm system to facilitate adoption and interaction with basic input.

2. **Reliability**: Improve the swarm's ability to obtain the desired output even with basic and un-detailed input.

3. **Speed**: Reduce the time it takes for the swarm to accomplish tasks by improving the communication layer, critiquing, and self-alignment with meta prompting.

4. **Scalability**: Ensure that the system is asynchronous, concurrent, and self-healing to support scalability.

Our goal is to continuously improve Zeta by following this roadmap while also being adaptable to new needs and opportunities as they arise.

## Join the Zeta Community

Join the Zeta community on Discord to connect with other contributors, coordinate work, and receive support.

- [Join the Zeta Discord Server](https://discord.gg/qUtxnK2NMf)


## Report and Issue
The easiest way to contribute to our docs is through our public [issue tracker](https://github.com/kyegomez/zeta-docs/issues). Feel free to submit bugs, request features or changes, or contribute to the project directly. 

## Pull Requests

Zeta docs are built using [MkDocs](https://squidfunk.github.io/mkdocs-material/getting-started/). 

To directly contribute to Zeta documentation, first fork the [zeta-docs](https://github.com/kyegomez/zeta-docs) repository to your GitHub account. Then clone your repository to your local machine.

From inside the directory run: 

```pip install -r requirements.txt```

To run `zeta-docs` locally run: 

```mkdocs serve```

You should see something similar to the following: 

```
INFO     -  Building documentation...
INFO     -  Cleaning site directory
INFO     -  Documentation built in 0.19 seconds
INFO     -  [09:28:33] Watching paths for changes: 'docs', 'mkdocs.yml'
INFO     -  [09:28:33] Serving on http://127.0.0.1:8000/
INFO     -  [09:28:37] Browser connected: http://127.0.0.1:8000/
```

Follow the typical PR process to contribute changes. 

* Create a feature branch.
* Commit changes.
* Submit a PR.


-------
---

## Taking on Tasks

We have a growing list of tasks and issues that you can contribute to. To get started, follow these steps:

1. Visit the [Zeta GitHub repository](https://github.com/kyegomez/zeta) and browse through the existing issues.

2. Find an issue that interests you and make a comment stating that you would like to work on it. Include a brief description of how you plan to solve the problem and any questions you may have.

3. Once a project coordinator assigns the issue to you, you can start working on it.

If you come across an issue that is unclear but still interests you, please post in the Discord server mentioned above. Someone from the community will be able to help clarify the issue in more detail.

We also welcome contributions to documentation, such as updating markdown files, adding docstrings, creating system architecture diagrams, and other related tasks.

## Submitting Your Work

To contribute your changes to Zeta, please follow these steps:

1. Fork the Zeta repository to your GitHub account. You can do this by clicking on the "Fork" button on the repository page.

2. Clone the forked repository to your local machine using the `git clone` command.

3. Before making any changes, make sure to sync your forked repository with the original repository to keep it up to date. You can do this by following the instructions [here](https://docs.github.com/en/github/collaborating-with-pull-requests/syncing-a-fork).

4. Create a new branch for your changes. This branch should have a descriptive name that reflects the task or issue you are working on.

5. Make your changes in the branch, focusing on a small, focused change that only affects a few files.

6. Run any necessary formatting or linting tools to ensure that your changes adhere to the project's coding standards.

7. Once your changes are ready, commit them to your branch with descriptive commit messages.

8. Push the branch to your forked repository.

9. Create a pull request (PR) from your branch to the main Zeta repository. Provide a clear and concise description of your changes in the PR.

10. Request a review from the project maintainers. They will review your changes, provide feedback, and suggest any necessary improvements.

11. Make any required updates or address any feedback provided during the review process.

12. Once your changes have been reviewed and approved, they will be merged into the main branch of the Zeta repository.

13. Congratulations! You have successfully contributed to Zeta.

Please note that during the review process, you may be asked to make changes or address certain issues. It is important to engage in open and constructive communication with the project maintainers to ensure the quality of your contributions.

## Developer Setup

If you are interested in setting up the Zeta development environment, please follow the instructions provided in the [developer setup guide](docs/developer-setup.md). This guide provides an overview of the different tools and technologies used in the project.

## Join the Agora Community

Zeta is brought to you by Agora, the open-source AI research organization. Join the Agora community to connect with other researchers and developers working on AI projects.

- [Join the Agora Discord Server](https://discord.gg/qUtxnK2NMf)

Thank you for your contributions and for being a part of the Zeta and Agora community! Together, we can advance Humanity through the power of AI.