# Frontend Tool List

For the bad memory, listing various tools thay you may needed as a frontend developer or a designer. And also, we are not possible to know everything(tools), so find out the ideas, tools, libraries here that you haven't known but might useful for you.

> The useful tools, libraries you known but not listed here? [Contribute](#contribution-guide) to this project.

## Table of contents

1. [Design](#design)
2. [Color](#color)
3. [Font & Icons](#font--icons)
4. [Browser](#browser)
5. [JS library](#js-library)
6. [UI library](#ui-library)
7. [Framework](#framework)
8. [Image tools](#image-tools)
9. [Online playground](#online-playground)


## Design

- [Pinterest](https://www.pinterest.com/)
- [Behance](https://www.behance.net/)
- [Collect UI](https://collectui.com/)
- [Unsplash](https://unsplash.com/)


## Color

- [UI Gradient](https://uigradients.com/#GradeGrey)
- [Color hex](https://www.color-hex.com/)
- [Html color code](https://htmlcolorcodes.com/)
- [Colorzilla](https://www.colorzilla.com/)
- [WebAIM: Contrast Checker](https://webaim.org/resources/contrastchecker/)
- [Color Safe](http://colorsafe.co/)

## Font & Icons

- [FontAwesome](https://fontawesome.com/)
- [Google fonts](https://fonts.google.com/)
- [Font Space](https://www.fontspace.com/)


## Browser

- [Screen Sizes](https://screensiz.es/phone)
- [YesViz - Device Insight](https://yesviz.com/)
- [caniuse](https://caniuse.com/)
- [opengraph](https://www.opengraph.xyz/) - Check if head meta tag set properly for your website

## JS Library

- [jQuery](https://api.jquery.com/)
- [d3.js](https://d3js.org/)
- [three.js](https://threejs.org/)
- [Green Sock](https://greensock.com/docs/)
- [RxJS](https://rxjs.dev/)
- [howler.js](https://github.com/goldfire/howler.js#documentation)
- [paper.js](http://paperjs.org/)


## UI Library

- [Tailwind](https://tailwindcss.com/)
- [Unocss](https://uno.antfu.me/)
- [Bootstrap](https://getbootstrap.com/)
- [Pure.css](https://purecss.io/)
- [Vuetify](https://vuetifyjs.com/en/)
- [Ant Design](https://ant.design/)
- [Terminal.css](https://terminalcss.xyz/) - Terminal like components.
- [NES.css](https://nostalgic-css.github.io/NES.css/) - 8bit style components.

## Framework

- [Vue](https://vuejs.org/)
- [React](https://zh-hant.reactjs.org/)
- [Angular](https://angular.io/)
- [Svelte](https://svelte.dev/)
- [SolidJS](https://www.solidjs.com/)
- [qwik](https://qwik.builder.io/)
- [aurelia](https://aurelia.io/)
- [Alpine.js](https://alpinejs.dev/)


## Image tools

- [tinypng](https://tinypng.com/)
- [ezgif](https://ezgif.com/video-to-gif)


## Online playground

- [flexbox playground](https://flexbox.tech/)
- [StackBlitz](https://stackblitz.com/)
- [jsfiddle](https://jsfiddle.net/)
- [vue sfc playground](https://sfc.vuejs.org/)
- [play code](https://playcode.io/)
- [uno css playground](https://uno.antfu.me/play/)
- [Codepen](https://codepen.io/)
- [CodeSandbox](https://codesandbox.io/)

---

## Contribution Guide

<details open>
  <summary> <strong>Guide</strong> </summary>

- Give it a **STAR**😊
- Fork this repo
- If the topic exists, add a link under the topic.
- If not, **add topic first** and **add the link under the topic**. At last, add topic to contents.
- Commit to your fork repo.
- Create a [PR](https://github.com/kurt-liao/frontend-tool-list/pulls)


</details>

## Contributors

@see [CONTRIBUTING](/CONTRIBUTING.md)
