/**
 * @description
 * Positions enum
 * @enum {string}
 */
export enum POSITIONS {
  BOTTOM = 'BOTTOM',
  BOTTOM_CENTER = 'BOTTOM_CENTER',
  BOTTOM_LEFT = 'BOTTOM_LEFT',
  BOTTOM_LEFT_FIT_CONTENT = 'BOTTOM_LEFT_FIT_CONTENT',
  BOTTOM_RIGHT = 'BOTTOM_RIGHT',
  CENTER = 'CENTER',
  LEFT = 'LEFT',
  RIGHT = 'RIGHT',
  TOP = 'TOP',
  TOP_LEFT = 'TOP_LEFT',
  TOP_RIGHT = 'TOP_RIGHT',
  TOP_CENTER = 'TOP_CENTER',
  //
  LEFT_FIXED = 'LEFT_FIXED',
  BOTTOM_FIXED = 'BOTTOM_FIXED',
  RIGHT_FIXED = 'RIGHT_FIXED',
  BOTTOM_CENTER_FIXED = 'BOTTOM_CENTER_FIXED',
  TOP_CENTER_FIXED = 'TOP_CENTER_FIXED',
  LEFT_BOTTOM_FIXED = 'LEFT_BOTTOM_FIXED',
  // custom
  BOTTOM_GAP_RIGHT = 'BOTTOM_GAP_RIGHT',
}

/**
 * @description
 * Mirror positions
 * @enum {string}
 */
export const MIRROR_POSITIONS = {
  [POSITIONS.BOTTOM_CENTER]: POSITIONS.TOP_CENTER,
  [POSITIONS.TOP_CENTER]: POSITIONS.BOTTOM_CENTER,
  [POSITIONS.LEFT]: POSITIONS.RIGHT,
  [POSITIONS.RIGHT]: POSITIONS.LEFT,
  [POSITIONS.TOP]: POSITIONS.BOTTOM,
  [POSITIONS.BOTTOM]: POSITIONS.TOP,
};
