import { CSSProp, createGlobalStyle, css } from 'styled-components';

type GlobalStyle = {
  custom?: CSSProp;
  customFonts?: CSSProp;
};

export const commonElementStyles = css`
  margin: 0;
  padding: 0;
  vertical-align: baseline;
  margin-block-start: 0;
  margin-block-end: 0;
  margin-inline-start: 0;
  margin-inline-end: 0;
  box-sizing: border-box;
  background-color: transparent;
  border: 0;
`;

export const GlobalStyle = createGlobalStyle<GlobalStyle>`
    ${props => props.custom}
    ${props => props.customFonts}

    @supports (font: -apple-system-body) {
        html {
            font: -apple-system-body;
        }
    }

    html {        
        ${commonElementStyles}
    }

    body, div, span, applet, object, iframe,
    h1, h2, h3, h4, h5, h6, p, blockquote, pre,
    a, abbr, acronym, address, big, cite, code,
    del, dfn, em, img, ins, kbd, q, s, samp,
    small, strike, strong, sub, sup, tt, var,
    b, u, i, center,
    dl, dt, dd, ol, ul, li,
    fieldset, form, label, legend,
    table, caption, tbody, tfoot, thead, tr, th, td,
    article, aside, canvas, details, embed, 
    figure, figcaption, footer, header, hgroup, 
    menu, nav, output, ruby, section, summary,
    time, mark, audio, video, dialog, input, button {
        font-size: 100%;
        ${commonElementStyles}
    }
    dialog {
        border: 0;
        padding: 0;
    }
    /* HTML5 display-role reset for older browsers */
    article, aside, details, figcaption, figure, 
    footer, header, hgroup, menu, nav, section {
        display: block;
        margin: 0;
        margin-block-start: 0;
        margin-block-end: 0;
        margin-inline-start: 0;
        margin-inline-end: 0;
    }
    body {
        line-height: 1;
    }
    ol, ul {
        list-style: none;
        margin: 0;
        padding: 0;
    }
    blockquote, q {
        quotes: none;
    }
    blockquote:before, blockquote:after,
    q:before, q:after {
        content: '';
        content: none;
    }
    
    table {
        border-collapse: collapse;
        border-spacing: 0;
    }
`;
