const ESCAPE = {
  key: [
    'Escape',
    // IE11 Escape
    'Esc',
  ],
  which: 27,
  keyCode: 27,
  code: 'Esc',
};

const ENTER = {
  key: 'Enter',
  which: 13,
  keyCode: 13,
  code: 'Enter',
};

const SPACE = {
  key: ' ',
  which: 32,
  keyCode: 32,
  code: 'Space',
};

const PAGE_UP = {
  key: 'PageUp',
  which: 33,
  keyCode: 33,
  code: 'PageUp',
};

const PAGE_DOWN = {
  key: 'PageDown',
  which: 34,
  keyCode: 34,
  code: 'PageDown',
};

const ARROW_LEFT = {
  key: 'ArrowLeft',
  which: 37,
  keyCode: 37,
  code: 'ArrowLeft',
};

const ARROW_UP = {
  key: 'ArrowUp',
  which: 38,
  keyCode: 38,
  code: 'ArrowUp',
};

const ARROW_RIGHT = {
  key: 'ArrowRight',
  which: 39,
  keyCode: 39,
  code: 'ArrowRight',
};

const ARROW_DOWN = {
  key: 'ArrowDown',
  which: 40,
  keyCode: 40,
  code: 'ArrowDown',
};

const DELETE = {
  key: 'Delete',
  which: 46,
  keyCode: 46,
  code: 'ArrowDecimal',
};

const TAB = {
  key: 'Tab',
  which: 9,
  keyCode: 9,
  code: 'Tab',
};

const BACKSPACE = {
  key: 'Backspace',
  which: 8,
  keyCode: 8,
  code: 'Backspace',
};

const HOME = {
  key: 'Home',
};

const END = {
  key: 'End',
};

/**
 * Keyboard keys
 * @see https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/key/Key_Values
 */
export {
  ESCAPE,
  ENTER,
  SPACE,
  PAGE_UP,
  PAGE_DOWN,
  ARROW_LEFT,
  ARROW_UP,
  ARROW_RIGHT,
  ARROW_DOWN,
  DELETE,
  TAB,
  BACKSPACE,
  HOME,
  END,
};
