import React from 'react';

import { Button } from '@/components/button/button';
import { IconPositionType } from '@/components/button/types/buttonIconPosition';
import { Text } from '@/components/text/text';
import { TextComponentType } from '@/components/text/types/component';

import { AriaLiveOptionType } from '../../types/ariaLiveOption/ariaLiveOption';
import { ElementOrIcon } from '../elementOrIcon/elementOrIcon';
import { InputDigit } from './components/inputDigit';
import { InputDigitSequenceHelpText } from './components/inputDigitSequenceHelpText';
import { InputDigitSequenceTooltip } from './components/inputDigitSquenceTooltip';
import {
  AnimationInputsContainer,
  ButtonContainer,
  IconAndErrorTextContainer,
  InputDigitsContainer,
  InputDigitsContainerAnimated,
  ParentContainer,
  TitleTooltipContainer,
} from './inputDigitSequence.styled';
import { IInputDigitSequenceStandAlone } from './types/inputDigitSequence';

const InputDigitSequenceStandAloneComponent = (
  {
    error = false,
    inputMode = 'numeric',
    dataTestId = 'input-digit-sequence',
    ...props
  }: IInputDigitSequenceStandAlone,
  ref: React.ForwardedRef<HTMLDivElement>
): JSX.Element => {
  const stateStyles = props.styles?.[props.state];
  return (
    <ParentContainer ref={ref} data-testid={dataTestId} styles={stateStyles}>
      <TitleTooltipContainer styles={stateStyles}>
        <Text
          component={TextComponentType.PARAGRAPH}
          customTypography={stateStyles?.title}
          {...props.title}
        >
          {props.title?.content}
        </Text>
        <InputDigitSequenceTooltip
          stateStyles={stateStyles}
          tooltip={props.tooltip}
          tooltipIcon={props.tooltipIcon}
        />
      </TitleTooltipContainer>
      <AnimationInputsContainer styles={stateStyles}>
        {props.animated && !props.labelAnimationDone && (
          <InputDigitsContainerAnimated
            animated={props.animated}
            aria-hidden={true}
            boxesAnimationDone={props.boxesAnimationDone}
            data-id="input-container-animated"
            styles={stateStyles}
          >
            {props.inputDigits.map((_, index) => {
              return (
                <InputDigit
                  key={index}
                  animated={props.animated}
                  ariaHidden={true}
                  boxesAnimationDone={props.boxesAnimationDone}
                  disabled={true}
                  label={index + 1}
                  state={props.state}
                  styles={props.styles}
                  tabIndex={-1}
                />
              );
            })}
          </InputDigitsContainerAnimated>
        )}
        <InputDigitsContainer
          animated={props.animated}
          boxesAnimationDone={props.boxesAnimationDone}
          data-id="input-container"
          labelAnimationDone={props.labelAnimationDone}
          styles={stateStyles}
        >
          {props.inputDigits.map((inputDigit, index) => {
            return (
              <InputDigit
                key={index}
                animated={props.animated}
                boxesAnimationDone={props.boxesAnimationDone}
                disabled={props.disabled}
                error={error}
                inputDigit={inputDigit}
                inputId={`${props.digitId}-${index}`}
                inputMode={inputMode}
                label={index + 1}
                showPassword={props.showPassword || props.passwordIndex === index}
                state={props.state}
                styles={props.styles}
                onChange={props.onInputChange(index)}
              />
            );
          })}
        </InputDigitsContainer>
      </AnimationInputsContainer>
      <IconAndErrorTextContainer aria-live={AriaLiveOptionType.POLITE} styles={stateStyles}>
        {error && !!props.errorText && (
          <>
            <ElementOrIcon customIconStyles={stateStyles?.errorIcon} {...props.errorIcon} />
            <Text
              component={TextComponentType.PARAGRAPH}
              customTypography={stateStyles?.errorText}
              {...props.errorText}
            >
              {props.errorText.content}
            </Text>
          </>
        )}
      </IconAndErrorTextContainer>
      <InputDigitSequenceHelpText
        dataTestId={`${dataTestId}-help-text`}
        helpText={props.helpText}
        styles={stateStyles}
      />
      {props.actionButton?.content &&
        (stateStyles?.actionButtonSize || props.actionButton?.size) && (
          <ButtonContainer styles={stateStyles}>
            <Button
              disabled={props.disabled}
              iconPosition={IconPositionType.LEFT}
              size={stateStyles?.actionButtonSize}
              {...props.actionButton}
              onClick={props.onActionButtonClick}
            >
              {props.actionButton?.content}
            </Button>
          </ButtonContainer>
        )}
    </ParentContainer>
  );
};

export const InputDigitSequenceStandAlone = React.forwardRef(InputDigitSequenceStandAloneComponent);
