import styled, { css } from 'styled-components';

import { CommonStyleType } from '@/types/styles/commonStyle';
import { getStyles } from '@/utils/getStyles/getStyles';

// mixins
import {
  getIconPadding,
  getIconPaddingDeprecated,
  inputFocusWidthMixin,
  mapBaseStyles,
  mapLabelTypeStyles,
  mapVariableStyles,
} from '../../styles/mixins/input.mixin';
import { InputCounterStateProps } from '../inputCounter/types/inputCounterTheme';
import { InputStateProps } from './types/input';
import {
  ErrorAndHelpMessageWrapperStyledProps,
  ErrorMessageStyledProps,
  HelpMessageStyledProps,
  InformationAssociatedStyledProps,
  InputIconStyledProps,
  InputStyledProps,
  InputWrapperStyledProps,
  LabelStyledProps,
  LoaderStyledProps,
  TitleStyledProps,
  TopContentWrapperStyledProps,
} from './types/inputStyledPropsType';
import { InputIconPosition, InputState } from './types/inputTheme';

// Component styles
export const TitleWrapperStyled = styled.div.withConfig({
  shouldForwardProp: () => true,
})<TitleStyledProps>`
  margin-bottom: ${({ $titleStyles }) => $titleStyles?.titleContainer?.margin_bottom};
`;

export const LabelWrapperStyled = styled.div<LabelStyledProps>`
  ${mapLabelTypeStyles}
`;

export const AdditionalInfoWrapperStyled = styled.div<{ styles?: InputStateProps }>`
  ${({ styles }) => getStyles(styles?.additionalInfoContainer)};
`;

export const TitleAndAdditionalInfoWrapperStyled = styled.div<{ styles?: InputStateProps }>`
  ${({ styles }) => getStyles(styles?.titleAndAdditionalInfoContainer)};
`;

export const InformationAssociatedWrapperStyled = styled.div<InformationAssociatedStyledProps>`
  flex-direction: ${({ iconPosition }) =>
    iconPosition === InputIconPosition.RIGHT ? 'row-reverse' : 'row'};
  ${({ styles }) => getStyles(styles?.informationAssociatedContainer)};
`;

export const InfoAssociatedTextAndDecorativeStyled = styled.div<InformationAssociatedStyledProps>`
  ${({ styles }) => getStyles(styles?.informationAssociatedTextAndDecorativeContainer)};
`;

export const InfoAssociatedButtonStyled = styled.div<InformationAssociatedStyledProps>``;

export const InputErrorAndHelpMessageWrapperStyled = styled.div<ErrorAndHelpMessageWrapperStyledProps>`
  ${({ styles }) => getStyles(styles?.errorAndHelpMessageContainer)};
`;

export const InputErrorStyled = styled.div<ErrorMessageStyledProps>`
  ${({ styles }) => getStyles(styles?.errorMessageContainer)};

  p {
    display: flex;
  }
`;

export const ErrorIconWrapperStyled = styled.span<ErrorMessageStyledProps>`
  ${({ styles }) => getStyles(styles?.errorMessageIconContainer)};
`;

export const HelpMessageWrapperStyled = styled.div<HelpMessageStyledProps>`
  ${({ align }) =>
    !align &&
    css`
      margin-left: auto;
    `};
  ${({ styles }) => getStyles(styles?.helpMessageContainer)};
`;

export const TextCounterStyled = styled.div<{ styles?: InputCounterStateProps }>`
  display: flex;
  flex-direction: row;
  justify-content: space-between;
  ${({ styles }) => getStyles(styles?.textCounterContainer)};
`;

export const LoaderWrapperStyled = styled.div<LoaderStyledProps>`
  ${({ styles }) => getStyles(styles?.loaderContainer)};
`;

export const InputIconContainerStyled = styled.div<
  InputIconStyledProps & { inputIconContainerStyles?: CommonStyleType }
>`
  display: flex;
  align-items: center;
  justify-content: center;
  pointer-events: ${({ $pointerEvents }) => ($pointerEvents ? 'auto' : 'none')};
  ${({ inputIconContainerStyles }) => getStyles(inputIconContainerStyles)};
`;

export const InputIconStyled = styled.div<InputIconStyledProps>`
  display: flex;
  align-items: center;
  justify-content: center;
  pointer-events: ${({ $pointerEvents }) => ($pointerEvents ? 'auto' : 'none')};
  ${({ iconPosition, styles }) => css`
    ${getStyles(
      iconPosition === InputIconPosition.RIGHT
        ? styles?.inputIconContainerRight
        : styles?.inputIconContainer
    )};
  `}
`;

// Input Styles
export const TopContentWrapperStyled = styled.div<TopContentWrapperStyledProps>`
  ${({ styles }) => getStyles(styles?.topContentContainer)};
`;

export const BottomContentWrapperStyled = styled.div<{ isExpanded?: boolean }>`
  ${({ isExpanded }) =>
    isExpanded &&
    css`
      display: none;
    `}
`;

export const MessagesAndCounterWrapperStyled = styled.div`
  display: flex;
  justify-content: space-between;
`;

export const RightContentWrapperStyled = styled.div``;

export const LeftContentWrapperStyled = styled.div``;

export const InputStyled = styled.input<InputStyledProps>`
  &::-webkit-inner-spin-button {
    -webkit-appearance: none;
    margin: 0;
  }
  &::-webkit-outer-spin-button {
    -webkit-appearance: none;
    margin: 0;
  }
  &::-ms-reveal {
    display: none;
  }

  width: 100%;
  box-sizing: border-box;
  ${mapBaseStyles}

  &:not(:placeholder-shown) {
    ${({ styles }) => mapVariableStyles(styles?.[InputState.FILLED])}
    ${({ icon, iconPosition, leftIcon, rightIcon, styles, state }) =>
      icon
        ? getIconPaddingDeprecated(iconPosition, styles?.[state])
        : getIconPadding(!!leftIcon?.icon, !!rightIcon?.icon, styles?.[state])}
  }

  &:placeholder-shown {
    ${({ styles }) => mapVariableStyles(styles?.[InputState.EMPTY])}
    ${({ icon, iconPosition, leftIcon, rightIcon, styles, state }) =>
      icon
        ? getIconPaddingDeprecated(iconPosition, styles?.[state])
        : getIconPadding(!!leftIcon?.icon, !!rightIcon?.icon, styles?.[state])}
  }

  &:disabled {
    ${({ styles, state }) => mapVariableStyles(styles?.[state])}
  }

  &:is([aria-invalid='true']) {
    ${({ styles, state }) => mapVariableStyles(styles?.[state])}
  }

  &:focus {
    ${({ styles, state }) => mapVariableStyles(styles?.[state])}
  }

  &:focus-visible {
    ${({ styles, state }) =>
      styles?.[state]?.focusVisibleCustom
        ? getStyles(styles?.[state]?.focusVisibleCustom)
        : inputFocusWidthMixin}
  }

  &[data-truncate='true'] {
    text-overflow: ellipsis;
    white-space: nowrap;
    overflow: hidden;
  }

  ${({ cursorPointer }) =>
    cursorPointer &&
    `
    cursor: ${cursorPointer};
  `}

  box-shadow: ${({ styles, state }) => styles?.[state]?.inputContainer?.box_shadow};
  ${({
    theme: {
      MEDIA_QUERIES: { onlyDesktop, onlyTablet, onlyMobile },
    },
    styles,
    state,
  }) => css`
    ${onlyDesktop} {
      caret-color: ${styles?.[state]?.inputCaretColor?.DESKTOP};
    }
    ${onlyTablet} {
      caret-color: ${styles?.[state]?.inputCaretColor?.TABLET};
    }
    ${onlyMobile} {
      caret-color: ${styles?.[state]?.inputCaretColor?.MOBILE};
    }
  `};
`;

export const InputWrapperStyled = styled.div<InputWrapperStyledProps>`
  width: 100%;
  position: relative;
  display: flex;
  flex-direction: column;
  ${({ styles }) => getStyles(styles?.inputWrapperContainer)};
  /* to avoid "-internal-autofill-selected" style to be applied */
  input:-webkit-autofill,
  input:-webkit-autofill:focus {
    transition:
      background-color 600000s 0s,
      color 600000s 0s;
  }
  /* Removing input background colour for autocomplete when it is disabled */
  input:-webkit-autofill:disabled {
    -webkit-text-fill-color: ${props => props.styles?.input?.color};
    -webkit-box-shadow: 0 0 0px 1000px ${props => props.styles?.inputContainer?.background_color}
      inset;
    transition: background-color 5000s ease-in-out 0s;
  }
`;
