import { CATEGORY_CONTROL } from '@/constants/categoryControl/categoryControl';
import { IThemeObjectVariants } from '@/designSystem/themesObject/themesObject';
import { ArgTypesReturn } from '@/types/type/type';

export const argtypes = (variants: IThemeObjectVariants, themeSelected: string): ArgTypesReturn => {
  return {
    themeArgs: {
      table: {
        disable: true,
      },
    },
    variant: {
      type: { name: 'string', required: true },
      control: { type: 'select' },
      description: 'Dot variant',
      options: Object.keys(variants[themeSelected].DotVariantType || {}),
      table: {
        type: {
          summary: 'string',
        },
        category: CATEGORY_CONTROL.MODIFIERS,
      },
    },
    size: {
      type: { name: 'string', required: true },
      control: { type: 'select' },
      description: 'Dot size',
      options: Object.keys(variants[themeSelected].DotSizeType || {}),
      table: {
        type: {
          summary: 'string',
        },
        category: CATEGORY_CONTROL.MODIFIERS,
      },
    },
    number: {
      control: { type: 'number' },
      type: { name: 'number' },
      description: 'Number shown inside the dot when is less than maxNumber',
      table: {
        type: {
          summary: 'number',
        },
        defaultValue: { summary: 0 },
        category: CATEGORY_CONTROL.CONTENT,
      },
    },
    maxNumber: {
      control: { type: 'number', max: 99 },
      type: { name: 'number' },
      description: 'Number shown inside the dot with a plus symbol',
      table: {
        type: {
          summary: 'number',
        },
        defaultValue: { summary: 10 },
        category: CATEGORY_CONTROL.CONTENT,
      },
    },
    width: {
      control: { type: 'text' },
      type: { name: 'string' },
      description: 'Add width to the dot',
      table: {
        type: {
          summary: 'string',
        },
        category: CATEGORY_CONTROL.MODIFIERS,
      },
    },
    height: {
      control: { type: 'text' },
      type: { name: 'string' },
      description: 'Add height to the dot',
      table: {
        type: {
          summary: 'string',
        },
        category: CATEGORY_CONTROL.MODIFIERS,
      },
    },
    dataTestId: {
      control: { type: 'text' },
      type: { name: 'string' },
      description: 'String used for testing',
      table: {
        type: {
          summary: 'string',
        },
        category: CATEGORY_CONTROL.TESTING,
      },
    },
    ctv: {
      description: 'Object used for update variant styles',
      type: { name: 'object' },
      control: { type: 'object' },
      table: {
        type: {
          summary: 'object',
        },
        category: CATEGORY_CONTROL.CUSTOMIZATION,
      },
    },
    cts: {
      description: 'Object used for update size styles',
      type: { name: 'object' },
      control: { type: 'object' },
      table: {
        type: {
          summary: 'object',
        },
        category: CATEGORY_CONTROL.CUSTOMIZATION,
      },
    },
  };
};
