import React from 'react';

import { ICONS } from '@/assets/storybook/icons/icons';
import { variantsObject } from '@/designSystem/themesObject/themesObject';

import { Button } from '../../../button/button';
import { IDataTable } from '../../types/dataTable';

const themeSelected = localStorage.getItem('themeSelected') || 'kubit';

export const DataTableSimpleColumnGetValueStory: IDataTable = {
  variant: Object.values(variantsObject[themeSelected].DataTableVariantType || {})[0] as string,
  columns: [
    { field: 'ref', headerContent: 'Ref', textAlign: 'left' },
    { field: 'firstName', headerContent: 'First name', textAlign: 'left' },
    { field: 'lastName', headerContent: 'Last name', textAlign: 'left' },
    { field: 'profile', headerContent: 'Profile', textAlign: 'left' },
    {
      field: 'delete',
      headerContent: 'Delete',
      valueGetter: (_value, row) => (
        <Button
          aria-label="Delete"
          icon={{ icon: ICONS.ICON_PLACEHOLDER }}
          size="SMALL"
          variant="PRIMARY"
          onClick={() => window.alert(`Delete id - ${row.id}`)}
        />
      ),
      textAlign: 'center',
    },
  ],
  rows: [
    { id: '1', ref: '1', firstName: 'John', lastName: 'Snow', profile: 'Admin' },
    { id: '2', ref: '2', firstName: 'Arya', lastName: 'Stark', profile: 'User' },
    { id: '3', ref: '3', firstName: 'Tyrion', lastName: 'Lannister', profile: 'User' },
    { id: '4', ref: '4', firstName: 'Daenerys', lastName: 'Targaryen', profile: 'User' },
    { id: '5', ref: '5', firstName: 'Cersei', lastName: 'Lannister', profile: 'Admin' },
    { id: '6', ref: '6', firstName: 'Sansa', lastName: 'Stark', profile: 'User' },
  ],
};
