# Security policy

## Supported versions

The versions of the project that are currently supported with security updates.

| Version | Supported          |
| ------: | :----------------- |
|   1.x.x | :white_check_mark: |

## Reporting a Vulnerability

We take the security of our project seriously. If you discover any security vulnerabilities, please report them to our security team on discussion board. We will investigate all reports and do our best to address any issues as quickly as possible. We appreciate your help in keeping our project safe and secure.

Please include the following details in your report:

- Description of the vulnerability
- Steps to reproduce the vulnerability
- Any additional information or proof of concept

Our security team will review your report and respond as soon as possible. We kindly request that you do not publicly disclose any vulnerabilities until we have had a chance to address them.

## Security Updates

We are committed to addressing security vulnerabilities promptly. When a security vulnerability is identified and verified, we will release a security update as soon as possible. These updates will be provided for all supported versions.

To stay informed about security updates, we recommend subscribing to our mailing list or following our project's official channels.

## Security Best Practices

To help ensure the security of your application, we recommend following these best practices:

- Keep your dependencies up to date
- Use strong and unique passwords for all accounts
- Regularly review and audit your code for security vulnerabilities
- Implement secure coding practices
- Enable two-factor authentication where possible

By following these best practices, you can help protect your application and its users from potential security threats.
