## Getting Started and Beyond: An Overview of the Krixik System
[🇨🇴 Versión en español de este documento](https://krixik-docs.readthedocs.io/es-main/sistema/introduccion_al_sistema/)

In this section we take a deeper look at the methods and underlying concepts of the Krixik system—at all the tools you will need to assemble, parameterize, and consume Krixik pipelines. The topics we'll review herein are the following:

### Initialization

- [Installing the Python Client](initialization/install_client.md)

- [Initializing and Authenticating](initialization/initialize_and_authenticate.md)

### Pipeline Creation

- [Components of a Krixik Pipeline](pipeline_creation/components_of_a_krixik_pipeline.md)

- [Creating a Pipeline](pipeline_creation/create_pipeline.md)

- [Pipeline `.config`](pipeline_creation/pipeline_config.md)

- [Saving and Loading Pipelines](pipeline_creation/saving_and_loading_pipelines.md)

### Parameters + Processing Files Through Pipelines

- [Process Files with the Parameterizable `process` Method](parameters_processing_files_through_pipelines/process_method.md)

- [JSON Input Format](parameters_processing_files_through_pipelines/JSON_input_format.md)

- [The `process_status` Method](parameters_processing_files_through_pipelines/process_status_method.md)

- [The `fetch_output` Method](parameters_processing_files_through_pipelines/fetch_output_method.md)

- [Data Deletion Policy](parameters_processing_files_through_pipelines/data_deletion_policy.md)

### The File System

- [The `list` Method](file_system/list_method.md)

- [The `update` Method](file_system/update_method.md)

- [The `delete` Method](file_system/delete_method.md)

- [The `show_tree` Method](file_system/show_tree_method.md)

### Search Methods

- [The `semantic_search` Method](search_methods/semantic_search_method.md)

- [The `keyword_search` Method](search_methods/keyword_search_method.md)

### Convenience Methods and More

- [Convenience Methods (and More!)](convenience_methods/convenience_methods.md)
