/*
 * Decompiled with CFR 0.152.
 */
package novartis.utilities;

public class Tokenizer {
    String source = null;
    int pos = 0;
    public String sval = "";
    public int ival = 0;
    public int ttype = 0;
    public static final int BOF = 0;
    public static final int SPECIAL_IDENT = 1;
    public static final int IDENT = 2;
    public static final int RING_NUMBER = 4;
    public static final int UNSIGNED = 8;
    public static final int ATTACHMENT = 16;
    public static final int BRACE_STRING = 32;
    public static final int BRACKET_STRING = 64;
    public static final int CHARACTER = 128;
    public static final int UCIDENT = 256;
    public static final int EOF = 512;
    public static final int ERROR = -1;

    private final char charAt(int n) {
        if (this.pos + n >= this.source.length()) {
            return '\u0000';
        }
        return this.source.charAt(this.pos + n);
    }

    public Tokenizer(String string) {
        this.source = string;
        this.pos = 0;
        this.ttype = 0;
        this.sval = "";
        this.ival = 0;
    }

    public int nextToken(int n, String[] stringArray) {
        int n2;
        this.sval = "";
        this.ival = 0;
        if (this.pos >= this.source.length()) {
            this.ttype = 512;
            return 512;
        }
        if (0 != (1 & n)) {
            if (stringArray == null) {
                return -1;
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (this.charAt(0) != stringArray[n2].charAt(0) || !this.source.substring(this.pos).startsWith(stringArray[n2])) continue;
                this.sval = stringArray[n2];
                this.pos += stringArray[n2].length();
                this.ttype = 1;
                return 1;
            }
        }
        if (0 != (0x100 & n) && Character.isUpperCase(this.charAt(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.charAt(0));
            ++this.pos;
            while (Character.isUpperCase(this.charAt(0))) {
                stringBuffer.append(this.charAt(0));
                ++this.pos;
            }
            this.sval = stringBuffer.toString();
            this.ttype = 256;
            return 256;
        }
        if (0 != (2 & n) && Character.isUpperCase(this.charAt(0))) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.charAt(0));
            ++this.pos;
            while (Character.isLowerCase(this.charAt(0))) {
                stringBuffer.append(this.charAt(0));
                ++this.pos;
            }
            this.sval = stringBuffer.toString();
            this.ttype = 2;
            return 2;
        }
        if (0 != (4 & n) && (this.charAt(0) == '%' && Character.isDigit(this.charAt(1)) || Character.isDigit(this.charAt(0)))) {
            if (this.charAt(0) == '%') {
                ++this.pos;
                if (Character.isDigit(this.charAt(1))) {
                    this.ival = 10 * (this.charAt(0) - 48) + (this.charAt(1) - 48);
                    this.pos += 2;
                } else {
                    this.ival = this.charAt(0) - 48;
                    ++this.pos;
                }
            } else {
                this.ival = this.charAt(0) - 48;
                ++this.pos;
            }
            this.sval = Integer.toString(this.ival);
            this.ttype = 4;
            return 4;
        }
        if (0 != (8 & n) && Character.isDigit(this.charAt(0))) {
            this.ival = this.charAt(0) - 48;
            ++this.pos;
            while (Character.isDigit(this.charAt(0))) {
                this.ival *= 10;
                this.ival += this.charAt(0) - 48;
                ++this.pos;
            }
            this.sval = Integer.toString(this.ival);
            this.ttype = 8;
            return 8;
        }
        if (0 != (0x10 & n) && this.charAt(0) == '&' && Character.isDigit(this.charAt(1))) {
            this.ival = this.charAt(1) - 48;
            this.pos += 2;
            this.sval = Integer.toString(this.ival);
            this.ttype = 16;
            return 16;
        }
        if (0 != (0x20 & n) && this.charAt(0) == '{') {
            n2 = 1;
            StringBuffer stringBuffer = new StringBuffer();
            ++this.pos;
            while (this.pos < this.source.length()) {
                if (this.charAt(0) == '}') {
                    --n2;
                }
                if (this.charAt(0) == '{') {
                    ++n2;
                }
                if (n2 == 0) break;
                stringBuffer.append(this.charAt(0));
                ++this.pos;
            }
            if (this.charAt(0) != '}') {
                ++this.pos;
                return -1;
            }
            ++this.pos;
            this.sval = stringBuffer.toString();
            this.ttype = 32;
            return 32;
        }
        if (0 != (0x40 & n) && this.charAt(0) == '[') {
            n2 = 1;
            StringBuffer stringBuffer = new StringBuffer();
            ++this.pos;
            while (this.pos < this.source.length()) {
                if (this.charAt(0) == ']') {
                    --n2;
                }
                if (this.charAt(0) == '[') {
                    ++n2;
                }
                if (n2 == 0) break;
                stringBuffer.append(this.charAt(0));
                ++this.pos;
            }
            if (this.charAt(0) != ']') {
                ++this.pos;
                return -1;
            }
            ++this.pos;
            this.sval = stringBuffer.toString();
            this.ttype = 64;
            return 64;
        }
        if (0 != (0x80 & n)) {
            this.sval = this.source.substring(this.pos, this.pos + 1);
            ++this.pos;
            this.ttype = 128;
            return 128;
        }
        this.ttype = -1;
        return -1;
    }

    public static void main(String[] stringArray) {
        Tokenizer tokenizer = new Tokenizer("c1ccccc1[NH2]");
        do {
            String[] stringArray2 = new String[]{"c", "n", "o", "s", "p"};
            tokenizer.nextToken(223, stringArray2);
            System.err.println("ttype = " + tokenizer.ttype + ",  sval = '" + tokenizer.sval + "', ival = " + tokenizer.ival);
        } while (tokenizer.ttype != 512 && tokenizer.ttype != -1);
    }
}

