/*
 * Decompiled with CFR 0.152.
 */
package novartis.utilities;

public class HigherMath {
    public static final double sqr(double d) {
        return d * d;
    }

    public static double Distance(double d, double d2, double d3, double d4) {
        return HigherMath.Distance(d, d2, 0.0, d3, d4, 0.0);
    }

    public static double Distance(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sqrt(HigherMath.sqr(d - d4) + HigherMath.sqr(d2 - d5) + HigherMath.sqr(d3 - d6));
        return d7;
    }

    public static double Angle(double d, double d2, double d3, double d4) {
        return HigherMath.Angle(d, d2, 0.0, d3, d4, 0.0);
    }

    public static double Angle(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 < 1.0E-5 || d8 < 1.0E-5) {
            return 0.0;
        }
        double d9 = (d * d4 + d2 * d5 + d3 * d6) / (d7 * d8);
        if (d9 > 1.0) {
            d9 = 1.0;
        }
        double d10 = d2 * d6 - d3 * d5;
        double d11 = d3 * d4 - d6 * d;
        double d12 = d * d5 - d4 * d2;
        double d13 = (d10 + d11 + d12) / (d7 * d8);
        double d14 = Math.acos(d9);
        if (d13 < 0.0) {
            d14 = Math.PI * 2 - d14;
        }
        return d14;
    }

    public static double AngleSmall(double d, double d2, double d3, double d4) {
        return HigherMath.AngleSmall(d, d2, 0.0, d3, d4, 0.0);
    }

    public static double AngleSmall(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        double d8 = Math.sqrt(d4 * d4 + d5 * d5 + d6 * d6);
        if (d7 < 1.0E-5 || d8 < 1.0E-5) {
            return 0.0;
        }
        double d9 = (d * d4 + d2 * d5 + d3 * d6) / (d7 * d8);
        if (d9 > 1.0) {
            d9 = 1.0;
        }
        double d10 = d2 * d6 - d3 * d5;
        double d11 = d3 * d4 - d6 * d;
        double d12 = d * d5 - d4 * d2;
        double d13 = Math.acos(d9);
        if (d13 > Math.PI) {
            d13 = Math.PI * 2 - d13;
        }
        if (d13 < -Math.PI) {
            d13 = Math.PI * 2 + d13;
        }
        return d13;
    }

    public static double Angle_3p(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d - d4;
        double d11 = d2 - d5;
        double d12 = d3 - d6;
        double d13 = d7 - d4;
        double d14 = d8 - d5;
        double d15 = d9 - d6;
        double d16 = HigherMath.AngleSmall(d10, d11, d12, d13, d14, d15);
        return d16;
    }

    public static double[] Normale(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d - d4;
        double d11 = d2 - d5;
        double d12 = d3 - d6;
        double d13 = d7 - d4;
        double d14 = d8 - d5;
        double d15 = d9 - d6;
        double d16 = d11 * d15 - d14 * d12;
        double d17 = d12 * d13 - d15 * d10;
        double d18 = d10 * d14 - d13 * d11;
        double d19 = Math.sqrt(d16 * d16 + d17 * d17 + d18 * d18);
        double d20 = d16 / d19;
        double d21 = d17 / d19;
        double d22 = d18 / d19;
        double[] dArray = new double[]{d20, d21, d22};
        return dArray;
    }

    public static double Torsion_4p(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        double[] dArray = HigherMath.Normale(d, d2, d3, d4, d5, d6, d7, d8, d9);
        double[] dArray2 = HigherMath.Normale(d4, d5, d6, d7, d8, d9, d10, d11, d12);
        double d13 = HigherMath.AngleSmall(dArray[0], dArray[1], dArray[2], dArray2[0], dArray2[1], dArray2[2]);
        return d13;
    }

    public static void transformPoints(double[][] dArray, int n, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5) {
        double d;
        double d2;
        double d3;
        int n2;
        double[] dArray6 = new double[2];
        double[] dArray7 = new double[2];
        double[] dArray8 = new double[2];
        double[] dArray9 = new double[2];
        double[] dArray10 = new double[2];
        double d4 = 0.0;
        double d5 = 0.0;
        for (n2 = 0; n2 < 2; ++n2) {
            dArray7[n2] = dArray2[n2] - dArray3[n2];
            dArray8[n2] = dArray4[n2] - dArray5[n2];
            dArray9[n2] = (dArray2[n2] + dArray3[n2]) / 2.0;
            dArray10[n2] = (dArray4[n2] + dArray5[n2]) / 2.0;
            d5 += dArray7[n2] * dArray7[n2];
            d4 += dArray8[n2] * dArray8[n2];
        }
        if (d5 < 1.0E-5 || d4 < 1.0E-5) {
            d3 = 1.0;
            d2 = 0.0;
            d = 1.0;
        } else {
            d3 = (dArray7[0] * dArray8[0] + dArray7[1] * dArray8[1]) / d5;
            d2 = (dArray8[0] * dArray7[1] - dArray7[0] * dArray8[1]) / d5;
            d = Math.sqrt(d4 / d5);
        }
        for (int i = 0; i < n; ++i) {
            for (n2 = 0; n2 < 2; ++n2) {
                dArray6[n2] = dArray[i][n2] - dArray9[n2];
            }
            dArray[i][0] = d3 * dArray6[0] + d2 * dArray6[1];
            dArray[i][1] = -d2 * dArray6[0] + d3 * dArray6[1];
            for (n2 = 0; n2 < 2; ++n2) {
                dArray6[n2] = dArray[i][n2] / d;
            }
            for (n2 = 0; n2 < 2; ++n2) {
                dArray[i][n2] = dArray6[n2] + dArray10[n2];
            }
        }
    }

    public static double[] nextSubstituentPoint(double[][] dArray, int[][] nArray, int n, boolean bl) {
        int n2;
        int n3;
        double[][] dArrayArray;
        int n4;
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        int n5 = 2;
        double[] dArray6 = new double[]{0.866025, -0.866025, 0.707107, -0.707107};
        double[] dArray7 = new double[]{-0.5, -0.5, 0.707107, 0.707107};
        dArray3[0] = dArray[n][0];
        dArray3[1] = dArray[n][1];
        int n6 = 0;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            if (nArray[n4][0] != n && nArray[n4][1] != n) continue;
            ++n6;
        }
        if (n6 == 0) {
            dArrayArray = new double[4 * n5 + 2][];
            n3 = 0;
            dArray5[0] = 1.514;
            dArray5[1] = 0.0;
            dArrayArray[n3] = new double[2];
            dArrayArray[n3][0] = dArray5[0] + dArray3[0];
            dArrayArray[n3][1] = dArray5[1] + dArray3[1];
            dArrayArray[++n3] = new double[2];
            dArrayArray[n3][0] = -dArray5[0] + dArray3[0];
            dArrayArray[n3][1] = -dArray5[1] + dArray3[1];
            ++n3;
            for (n4 = 0; n4 < 2 * n5; ++n4) {
                dArrayArray[n3] = new double[2];
                dArrayArray[n3][0] = dArray3[0] + dArray5[0] * dArray7[n4] - dArray5[1] * dArray6[n4];
                dArrayArray[n3][1] = dArray3[1] + dArray5[0] * dArray6[n4] + dArray5[1] * dArray7[n4];
                ++n3;
            }
            for (n4 = 0; n4 < 2 * n5; ++n4) {
                dArrayArray[n3] = new double[2];
                dArrayArray[n3][0] = dArray3[0] - dArray5[0] * dArray7[n4] + dArray5[1] * dArray6[n4];
                dArrayArray[n3][1] = dArray3[1] - dArray5[0] * dArray6[n4] - dArray5[1] * dArray7[n4];
                ++n3;
            }
        } else {
            double[][] dArrayArray2 = new double[n6][];
            n6 = 0;
            for (n4 = 0; n4 < nArray.length; ++n4) {
                if (nArray[n4][0] == n) {
                    dArrayArray2[n6] = new double[2];
                    dArrayArray2[n6][0] = dArray[nArray[n4][1]][0];
                    dArrayArray2[n6][1] = dArray[nArray[n4][1]][1];
                    ++n6;
                }
                if (nArray[n4][1] != n) continue;
                dArrayArray2[n6] = new double[2];
                dArrayArray2[n6][0] = dArray[nArray[n4][0]][0];
                dArrayArray2[n6][1] = dArray[nArray[n4][0]][1];
                ++n6;
            }
            dArrayArray = new double[n5 + (n6 - 1) * n6][];
            n3 = 0;
            double d = 0.0;
            for (n4 = 0; n4 < n6; ++n4) {
                d += HigherMath.distSquare(dArray3[0], dArray3[1], dArrayArray2[n4][0], dArrayArray2[n4][1]);
            }
            d = Math.sqrt(d / (double)n6);
            double d2 = HigherMath.distSquare(dArray3[0], dArray3[1], dArrayArray2[0][0], dArrayArray2[0][1]);
            if ((d2 = Math.sqrt(d2)) > 0.001) {
                dArray5[0] = (dArrayArray2[0][0] - dArray3[0]) * d / d2;
                dArray5[1] = (dArrayArray2[0][1] - dArray3[1]) * d / d2;
                for (n4 = 0; n4 < n5; ++n4) {
                    dArrayArray[n3] = new double[2];
                    dArrayArray[n3][0] = dArray5[0] * dArray7[n4] - dArray5[1] * dArray6[n4] + dArray3[0];
                    dArrayArray[n3][1] = dArray5[0] * dArray6[n4] + dArray5[1] * dArray7[n4] + dArray3[1];
                    ++n3;
                }
            }
            for (n4 = 0; n4 < n6; ++n4) {
                for (n2 = n4 + 1; n2 < n6; ++n2) {
                    dArray4[0] = dArrayArray2[n4][0] - dArray3[0];
                    dArray4[1] = dArrayArray2[n4][1] - dArray3[1];
                    d2 = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1]);
                    if (d2 > 0.001) {
                        dArray4[0] = dArray4[0] / d2;
                        dArray4[1] = dArray4[1] / d2;
                    }
                    dArray5[0] = dArrayArray2[n2][0] - dArray3[0];
                    dArray5[1] = dArrayArray2[n2][1] - dArray3[1];
                    d2 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1]);
                    if (d2 > 0.001) {
                        dArray5[0] = dArray5[0] / d2;
                        dArray5[1] = dArray5[1] / d2;
                    }
                    dArray4[0] = dArray4[0] + dArray5[0];
                    dArray4[1] = dArray4[1] + dArray5[1];
                    d2 = Math.sqrt(dArray4[0] * dArray4[0] + dArray4[1] * dArray4[1]);
                    if (!(d2 > 0.001)) continue;
                    dArrayArray[n3] = new double[2];
                    dArrayArray[n3][0] = dArray3[0] - dArray4[0] * d / d2;
                    dArrayArray[n3][1] = dArray3[1] - dArray4[1] * d / d2;
                    ++n3;
                    if (!bl || n6 <= 2) continue;
                    dArrayArray[n3] = new double[2];
                    dArrayArray[n3][0] = dArray3[0] + dArray4[0] * d / d2;
                    dArrayArray[n3][1] = dArray3[1] + dArray4[1] * d / d2;
                    ++n3;
                }
            }
        }
        double d = 1.0E7;
        for (n4 = 0; n4 < n3; ++n4) {
            double d3 = 0.0;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                d3 += 1.0 / (0.001 + HigherMath.distSquare(dArrayArray[n4][0], dArrayArray[n4][1], dArray[n2][0], dArray[n2][1]));
            }
            if (n4 < n5) {
                d3 *= 1.5;
            }
            if (!(d3 < d)) continue;
            d = d3;
            dArray2[0] = dArrayArray[n4][0];
            dArray2[1] = dArrayArray[n4][1];
        }
        return dArray2;
    }

    public static double distSquare(double d, double d2, double d3, double d4) {
        return (d - d3) * (d - d3) + (d2 - d4) * (d2 - d4);
    }
}

