/*
 * Decompiled with CFR 0.152.
 */
package novartis.utilities;

import java.io.PrintStream;
import java.util.Random;
import java.util.Vector;
import novartis.chemistry.molecule.Bond;
import novartis.utilities.CountedBitSet;
import novartis.utilities.TreeCell;

public class Graph {
    int[][] graph = null;

    public Graph(Bond[] bondArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < bondArray.length; ++n) {
            int[] nArray = bondArray[n].getAtomNumbers();
            if (nArray[0] > n2) {
                n2 = nArray[0];
            }
            if (nArray[1] <= n2) continue;
            n2 = nArray[1];
        }
        this.graph = new int[bondArray.length][];
        for (n = 0; n < bondArray.length; ++n) {
            if ((bondArray[n].getBondFlags() & 0x100) != 0) {
                this.graph[n] = new int[2];
                this.graph[n][0] = ++n2;
                this.graph[n][1] = ++n2;
                continue;
            }
            this.graph[n] = bondArray[n].getAtomNumbers();
        }
    }

    public Graph(int[][] nArray) {
        this.graph = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            this.graph[i] = new int[2];
            this.graph[i][0] = nArray[i][0];
            this.graph[i][1] = nArray[i][1];
        }
    }

    private static final int theOtherAtom(int[] nArray, int n) {
        if (nArray[0] == n) {
            return nArray[1];
        }
        return nArray[0];
    }

    public CountedBitSet[] ringList() {
        int n;
        Vector<CountedBitSet> vector = new Vector<CountedBitSet>();
        int n2 = 0;
        for (n = 0; n < this.graph.length; ++n) {
            if (n2 < this.graph[n][0]) {
                n2 = this.graph[n][0];
            }
            if (n2 >= this.graph[n][1]) continue;
            n2 = this.graph[n][1];
        }
        TreeCell[] treeCellArray = new TreeCell[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            treeCellArray[n] = new TreeCell();
        }
        int n3 = TreeCell.NO_COLOR;
        for (int i = 0; i < this.graph.length; ++i) {
            int n4 = this.graph[i][0];
            int n5 = this.graph[i][1];
            if (treeCellArray[n4].color == TreeCell.NO_COLOR && treeCellArray[n5].color == TreeCell.NO_COLOR) {
                treeCellArray[n5].link = i;
                treeCellArray[n4].color = treeCellArray[n5].color = ++n3;
                continue;
            }
            if (treeCellArray[n4].color == TreeCell.NO_COLOR) {
                treeCellArray[n4].color = treeCellArray[n5].color;
                treeCellArray[n4].link = i;
                continue;
            }
            if (treeCellArray[n5].color == TreeCell.NO_COLOR) {
                treeCellArray[n5].color = treeCellArray[n4].color;
                treeCellArray[n5].link = i;
                continue;
            }
            if (treeCellArray[n4].color != treeCellArray[n5].color) {
                int n6 = treeCellArray[n4].color;
                int n7 = treeCellArray[n5].color;
                for (n = 0; n <= n2; ++n) {
                    if (treeCellArray[n].color != n7) continue;
                    treeCellArray[n].color = n6;
                }
                int n8 = treeCellArray[n5].link;
                treeCellArray[n5].link = i;
                while (n8 != TreeCell.UNLINKED) {
                    n5 = Graph.theOtherAtom(this.graph[n8], n5);
                    int n9 = n8;
                    n8 = treeCellArray[n5].link;
                    treeCellArray[n5].link = n9;
                }
                continue;
            }
            int n10 = n4;
            int n11 = 0;
            while (treeCellArray[n10].link != TreeCell.UNLINKED) {
                n10 = Graph.theOtherAtom(this.graph[treeCellArray[n10].link], n10);
                ++n11;
            }
            n10 = n5;
            int n12 = 0;
            while (treeCellArray[n10].link != TreeCell.UNLINKED) {
                n10 = Graph.theOtherAtom(this.graph[treeCellArray[n10].link], n10);
                ++n12;
            }
            if (n11 > n12) {
                int n13 = n11;
                n11 = n12;
                n12 = n13;
                n13 = n4;
                n4 = n5;
                n5 = n13;
            }
            CountedBitSet countedBitSet = new CountedBitSet();
            vector.addElement(countedBitSet);
            countedBitSet.set(i);
            for (n = 0; n < n12 - n11; ++n) {
                countedBitSet.set(treeCellArray[n5].link);
                n5 = Graph.theOtherAtom(this.graph[treeCellArray[n5].link], n5);
            }
            while (n4 != n5) {
                countedBitSet.set(treeCellArray[n4].link);
                n4 = Graph.theOtherAtom(this.graph[treeCellArray[n4].link], n4);
                countedBitSet.set(treeCellArray[n5].link);
                n5 = Graph.theOtherAtom(this.graph[treeCellArray[n5].link], n5);
            }
        }
        CountedBitSet[] countedBitSetArray = new CountedBitSet[vector.size()];
        for (int i = 0; i < countedBitSetArray.length; ++i) {
            countedBitSetArray[i] = (CountedBitSet)vector.elementAt(i);
        }
        return countedBitSetArray;
    }

    public static CountedBitSet[] SortRings(CountedBitSet[] countedBitSetArray) {
        for (int i = 1; i < countedBitSetArray.length; ++i) {
            for (int j = i - 1; j >= 0 && countedBitSetArray[j].getCardinality() < countedBitSetArray[j + 1].getCardinality(); --j) {
                CountedBitSet countedBitSet = countedBitSetArray[j];
                countedBitSetArray[j] = countedBitSetArray[j + 1];
                countedBitSetArray[j + 1] = countedBitSet;
            }
        }
        return countedBitSetArray;
    }

    public CountedBitSet[] combineRings(CountedBitSet[] countedBitSetArray) {
        boolean bl;
        Random random = new Random(1L);
        if (countedBitSetArray == null) {
            return countedBitSetArray;
        }
        int n = 0;
        do {
            bl = false;
            countedBitSetArray = Graph.SortRings(countedBitSetArray);
            for (int i = 0; i < countedBitSetArray.length; ++i) {
                CountedBitSet countedBitSet = countedBitSetArray[i];
                for (int j = i + 1; j < countedBitSetArray.length; ++j) {
                    CountedBitSet countedBitSet2 = countedBitSetArray[j];
                    CountedBitSet countedBitSet3 = countedBitSet.xor(countedBitSet2);
                    int n2 = countedBitSet3.getCardinality();
                    if (n2 <= 0 || n2 > countedBitSet.getCardinality() && n2 > countedBitSet2.getCardinality()) continue;
                    if (countedBitSet.getCardinality() > countedBitSet2.getCardinality()) {
                        if (countedBitSet.getCardinality() <= n2 && random.nextInt() / 10 % 2 == 0) continue;
                        n = countedBitSet.getCardinality() == n2 ? ++n : 0;
                        bl = true;
                        countedBitSetArray[i] = countedBitSet3;
                        countedBitSet = countedBitSet3;
                        continue;
                    }
                    if (countedBitSet2.getCardinality() <= n2 && random.nextInt() / 10 % 2 == 0) continue;
                    n = countedBitSet2.getCardinality() == n2 ? ++n : 0;
                    bl = true;
                    countedBitSetArray[j] = countedBitSet3;
                    countedBitSet2 = countedBitSet3;
                }
            }
            if (n <= 4) continue;
            bl = false;
        } while (bl);
        return countedBitSetArray;
    }

    public void printRing(PrintStream printStream, CountedBitSet countedBitSet) {
        int n = 0;
        printStream.print("[" + countedBitSet.getCardinality() + "] : ");
        int n2 = 0;
        while (n < countedBitSet.getCardinality()) {
            if (countedBitSet.get(n2)) {
                ++n;
                printStream.print(" " + this.graph[n2][0] + "-" + this.graph[n2][1]);
            }
            ++n2;
        }
        printStream.println();
    }

    public void printRingList(PrintStream printStream, CountedBitSet[] countedBitSetArray) {
        for (int i = 0; i < countedBitSetArray.length; ++i) {
            this.printRing(printStream, countedBitSetArray[i]);
        }
    }

    public static void main(String[] stringArray) {
        int[][] nArrayArray = new int[][]{{21, 22}, {22, 23}, {23, 24}, {24, 25}, {25, 21}, {25, 26}, {1, 2}, {2, 3}, {3, 4}, {4, 5}, {5, 1}, {1, 6}, {6, 7}, {7, 8}, {8, 9}, {9, 10}, {10, 2}};
        Graph graph = new Graph(nArrayArray);
        CountedBitSet[] countedBitSetArray = graph.ringList();
        countedBitSetArray = graph.combineRings(countedBitSetArray);
        System.err.println();
        graph.printRingList(System.err, countedBitSetArray);
    }
}

