/*
 * Decompiled with CFR 0.152.
 */
package novartis.combinatorics;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class Permutation {
    static final int MAXN = 16000;
    static final int[] ident_perm = new int[]{0, 1};
    public static final Permutation identity = new Permutation(ident_perm, 1);
    protected int[] perm;
    protected int n;

    Permutation(int[] nArray, int n) {
        this.perm = new int[n + 1];
        this.n = n;
        for (int i = 1; i <= n; ++i) {
            this.perm[i] = nArray[i];
        }
    }

    Permutation inverse() {
        int[] nArray = new int[this.n + 1];
        for (int i = 1; i <= this.n; ++i) {
            nArray[this.perm[i]] = i;
        }
        return new Permutation(nArray, this.n);
    }

    public Object clone() {
        return new Permutation(this.perm, this.n);
    }

    public Permutation(String string) {
        int n;
        int n2;
        int n3;
        int[] nArray;
        StreamTokenizer streamTokenizer;
        block15: {
            streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.parseNumbers();
            nArray = new int[16];
            for (n3 = 1; n3 < 16; ++n3) {
                nArray[n3] = n3;
            }
            n2 = 0;
            try {
                n = streamTokenizer.nextToken();
                if (n == -2) {
                    n3 = 1;
                    do {
                        if (n == 95) {
                            n = streamTokenizer.nextToken();
                            continue;
                        }
                        if (streamTokenizer.nval > 16000.0) {
                            throw new IllegalArgumentException("Permutation: Illegal token '" + streamTokenizer.sval + "' found");
                        }
                        if (n3 >= nArray.length || streamTokenizer.nval >= (double)nArray.length) {
                            int n4;
                            int[] nArray2 = nArray;
                            nArray = new int[Math.max(n3 + 16, (int)streamTokenizer.nval + 16)];
                            for (n4 = 1; n4 < nArray2.length; ++n4) {
                                nArray[n4] = nArray2[n4];
                            }
                            for (n4 = nArray2.length; n4 < nArray.length; ++n4) {
                                nArray[n4] = n4;
                            }
                        }
                        nArray[n3] = (int)streamTokenizer.nval;
                        if (n2 < n3) {
                            n2 = n3;
                        }
                        if ((double)n2 < streamTokenizer.nval) {
                            n2 = (int)streamTokenizer.nval;
                        }
                        ++n3;
                        n = streamTokenizer.nextToken();
                    } while (n == -2 || n == 95);
                    break block15;
                }
                throw new IllegalArgumentException("Permutation: Illegal token '" + streamTokenizer.sval + "' found");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Permutation: IOException for '" + string + "'");
            }
        }
        if (n != -1 && n != 10) {
            throw new IllegalArgumentException("Permutation: Illegal token '" + streamTokenizer.sval + "' found");
        }
        this.perm = new int[n2 + 1];
        this.n = n2;
        for (n3 = 1; n3 <= n2; ++n3) {
            this.perm[n3] = nArray[n3];
        }
        if (!this.permOK()) {
            throw new IllegalArgumentException("Permutation: Syntax check failed for '" + string + "'");
        }
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof Permutation)) {
            return false;
        }
        Permutation permutation = (Permutation)object;
        int n2 = Math.min(this.n, permutation.n);
        for (n = 1; n <= n2; ++n) {
            if (this.perm[n] == permutation.perm[n]) continue;
            return false;
        }
        if (this.n > permutation.n) {
            for (n = n2 + 1; n <= this.n; ++n) {
                if (this.perm[n] == n) continue;
                return false;
            }
        } else {
            for (n = n2 + 1; n <= permutation.n; ++n) {
                if (permutation.perm[n] == n) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n = this.getClass().getName().hashCode();
        n <<= 2;
        return n ^= this.toString().hashCode();
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(this.perm[1]));
        int n2 = 1;
        for (n = 2; n <= this.n; ++n) {
            if (n == this.perm[n]) continue;
            n2 = n;
        }
        for (n = 2; n <= n2; ++n) {
            stringBuffer.append(" " + this.perm[n]);
        }
        return new String(stringBuffer);
    }

    String toCycleString() {
        boolean[] blArray = new boolean[this.n + 1];
        StringBuffer stringBuffer = null;
        int n = 1;
        do {
            if (this.perm[n] == n || blArray[n]) {
                ++n;
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer("(" + n);
            } else {
                stringBuffer.append(" (" + n);
            }
            blArray[n] = true;
            int n2 = this.perm[n];
            while (!blArray[n2]) {
                blArray[n2] = true;
                stringBuffer.append(" " + n2);
                n2 = this.perm[n2];
            }
            stringBuffer.append(")");
            ++n;
        } while (n < this.n);
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer("()");
        }
        return new String(stringBuffer);
    }

    public Permutation times(Permutation permutation) {
        int n = Math.max(this.n, permutation.n);
        int[] nArray = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            int n2 = this.n < i ? i : this.perm[i];
            nArray[i] = permutation.n < n2 ? n2 : permutation.perm[n2];
        }
        return new Permutation(nArray, n);
    }

    public Permutation dtv_times(Permutation permutation) {
        int n = Math.max(this.n, permutation.n);
        int[] nArray = new int[n + 1];
        for (int i = 1; i <= n; ++i) {
            int n2 = permutation.n < i ? i : permutation.perm[i];
            nArray[i] = this.n < n2 ? n2 : this.perm[n2];
        }
        return new Permutation(nArray, n);
    }

    public boolean permOK() {
        int n;
        int[] nArray = new int[this.n + 1];
        for (n = 1; n <= this.n; ++n) {
            if (this.perm[n] > this.n) {
                return false;
            }
            int n2 = this.perm[n];
            nArray[n2] = nArray[n2] + 1;
        }
        for (n = 1; n <= this.n; ++n) {
            if (nArray[n] == 1) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 2) {
            System.out.println(stringArray[0]);
            System.out.println(stringArray[1]);
            System.out.println("");
            Permutation permutation = new Permutation(stringArray[0]);
            Permutation permutation2 = new Permutation(stringArray[1]);
            System.out.println(permutation);
            System.out.println(permutation2);
            System.out.println(permutation.times(permutation2));
            System.out.println("");
            System.out.println(permutation.toCycleString());
            System.out.println(permutation2.toCycleString());
            System.out.println(permutation.times(permutation2).toCycleString());
        } else {
            System.out.println("sample usage: java Permutation '1 2 3' '2 3 1'");
        }
    }
}

