/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import novartis.chemistry.molecule.Molecule;
import novartis.combinatorics.Permutation;

public class StereoDescription {
    Molecule parent;
    Object depictor;
    int[] atoms;
    int stereoclass;
    public static final int IMPLICIT_H = Integer.MAX_VALUE;
    public static final int NONE = 0;
    public static final int TH = 1;
    public final Permutation[] THPermutations = new Permutation[]{new Permutation("1 2 3 4"), new Permutation("1 3 4 2"), new Permutation("1 4 2 3"), new Permutation("2 3 1 4"), new Permutation("2 1 4 3"), new Permutation("2 4 3 1"), new Permutation("3 1 2 4"), new Permutation("3 2 4 1"), new Permutation("3 4 1 2"), new Permutation("4 2 1 3"), new Permutation("4 1 3 2"), new Permutation("4 3 2 1")};
    public static final int DB = 2;
    public final Permutation[] DBPermutations = new Permutation[]{new Permutation("1 2 3 4"), new Permutation("2 1 4 3"), new Permutation("3 4 1 2"), new Permutation("4 3 2 1")};

    public StereoDescription(Molecule molecule, Object object, int[] nArray, int n) {
        this.parent = molecule;
        this.depictor = object;
        this.atoms = new int[nArray.length];
        System.arraycopy(nArray, 0, this.atoms, 0, nArray.length);
        this.stereoclass = n;
    }

    public StereoDescription(Molecule molecule, StereoDescription stereoDescription) {
        int n;
        this.parent = molecule;
        this.depictor = null;
        this.atoms = new int[stereoDescription.atoms.length];
        System.arraycopy(stereoDescription.atoms, 0, this.atoms, 0, stereoDescription.atoms.length);
        this.stereoclass = stereoDescription.stereoclass;
        if (stereoDescription.parent.atoms != null) {
            for (n = 0; n < stereoDescription.parent.atoms.length; ++n) {
                if (stereoDescription.depictor != stereoDescription.parent.atoms[n]) continue;
                this.depictor = molecule.atoms[n];
                return;
            }
        }
        if (stereoDescription.parent.bonds != null) {
            for (n = 0; n < stereoDescription.parent.bonds.length; ++n) {
                if (stereoDescription.depictor != stereoDescription.parent.bonds[n]) continue;
                this.depictor = molecule.bonds[n];
                return;
            }
        }
    }

    public Object clone(Molecule molecule) {
        StereoDescription stereoDescription = new StereoDescription(molecule, this);
        return stereoDescription;
    }
}

