/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import novartis.chemistry.molecule.Molecule;
import novartis.chemistry.molecule.MoleculeDepicter;
import novartis.utilities.FortranInputStream;

public class StandardMOL
extends Molecule {
    String molname = "";
    String user_initials = "";
    String program = "";
    String date = "";
    int dimensionality = 2;
    int int_scale = 1;
    double double_scale = 1.0;
    double energy = 0.0;
    int regno = 0;
    String comment;

    public void readMOLFile(FortranInputStream fortranInputStream) throws IOException {
        this.modifyOn();
        if (fortranInputStream.buffer.startsWith(">") && fortranInputStream.buffer.indexOf(60) >= 0) {
            return;
        }
        this.molname = fortranInputStream.buffer;
        fortranInputStream.getBuffer();
        this.user_initials = fortranInputStream.a(2);
        this.program = fortranInputStream.a(8);
        this.date = fortranInputStream.a(10);
        String string = fortranInputStream.a(2);
        this.dimensionality = string.equals("3D") ? 3 : 2;
        try {
            this.int_scale = fortranInputStream.i(2);
            this.double_scale = fortranInputStream.f(10);
            this.energy = fortranInputStream.f(12);
            this.regno = fortranInputStream.i(6);
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
        if (this.int_scale == 0) {
            this.int_scale = 1;
        }
        if (this.double_scale == 0.0) {
            this.double_scale = 1.0;
        }
        fortranInputStream.getBuffer();
        this.comment = fortranInputStream.buffer;
        fortranInputStream.getBuffer();
        this.readMDLCTable(fortranInputStream);
        this.modifyOff();
    }

    public static void main(String[] stringArray) throws IOException {
        FortranInputStream fortranInputStream = new FortranInputStream(new BufferedReader(new FileReader(stringArray[0])));
        StandardMOL standardMOL = new StandardMOL();
        standardMOL.readMOLFile(fortranInputStream);
        String[] stringArray2 = new MoleculeDepicter().computeDepiction(standardMOL, 0, 0, 3, null, null);
        for (int i = 0; i < stringArray2.length; ++i) {
            System.err.println(stringArray2[i]);
        }
    }
}

