/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import java.util.Stack;
import java.util.Vector;
import novartis.chemistry.molecule.Atom;
import novartis.chemistry.molecule.Bond;
import novartis.chemistry.molecule.Molecule;
import novartis.chemistry.molecule.StereoDescription;
import novartis.utilities.Tokenizer;

public class SmilesParser {
    static final int IS_AROMATIC = 1;

    private static int[] appendInt(int[] nArray, int n) {
        int[] nArray2 = new int[nArray.length + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        nArray2[nArray2.length - 1] = n;
        return nArray2;
    }

    public static Molecule smilesToMolecule(String string) {
        return SmilesParser.smilesToMolecule(string, true);
    }

    /*
     * Unable to fully structure code
     */
    public static Molecule smilesToMolecule(String var0, boolean var1_1) {
        var2_2 = new Vector<Atom>();
        var3_3 = new Vector<Bond>();
        var4_4 = new int[var0.length()][];
        var5_5 = new Stack<Atom>();
        var6_6 = new Atom[100];
        var7_7 = new int[100];
        var8_8 = new int[100];
        var9_9 = new Tokenizer(var0);
        var10_10 = new String[]{"Cl", "Br", "C", "B", "N", "O", "P", "S", "F", "I", "*", "c", "n", "o", "s", "p"};
        var11_11 = 215;
        var12_12 = 0;
        var13_13 = 0;
        var14_14 = 0;
        var15_15 = null;
        block19: while (true) {
            switch (var9_9.nextToken(var11_11, var10_10)) {
                case 512: {
                    break block19;
                }
                case -1: {
                    throw new IllegalArgumentException("Syntax error in SMILES '" + var0 + "'");
                }
                case 1: 
                case 2: 
                case 64: {
                    if (var9_9.ttype == 1) {
                        if (Character.isLowerCase(var9_9.sval.charAt(0))) {
                            var17_19 = new StringBuffer();
                            var17_19.append(var9_9.sval.toUpperCase());
                            var16_16 = var9_9.sval.equals("c") != false ? new Atom("C", 0, 0, 0, 0) : new Atom(0.0, 0.0, 0.0, var17_19.toString(), null, false, 0, 0, 0, 0, 0);
                            var16_16.color |= 1;
                        } else if (var9_9.sval.equals("*")) {
                            var16_16 = new Atom(0.0, 0.0, 0.0, "R#", null, false, 0, 0, 0, 0, 0);
                            var16_16.setIntProperty("RGP", 0);
                        } else {
                            var16_16 = new Atom(var9_9.sval, 0, 0, 0, 0);
                        }
                    } else {
                        var16_16 = var9_9.ttype == 64 ? SmilesParser.parseSmilesAtom(var9_9.sval) : new Atom(var9_9.sval, 0, 0, 0, 0);
                    }
                    var2_2.addElement(var16_16);
                    var4_4[var2_2.size() - 1] = new int[0];
                    if (var15_15 != null) {
                        var17_20 = var2_2.lastIndexOf(var15_15) + 1;
                        var18_24 = var2_2.size();
                        var4_4[var17_20 - 1] = SmilesParser.appendInt(var4_4[var17_20 - 1], var18_24);
                        var4_4[var18_24 - 1] = SmilesParser.appendInt(var4_4[var18_24 - 1], var17_20);
                        if (var12_12 == 0) {
                            var12_12 = (((Atom)var2_2.elementAt((int)(var17_20 - 1))).color & 1) != 0 && (((Atom)var2_2.elementAt((int)(var18_24 - 1))).color & 1) != 0 ? 16 : 2;
                        }
                        var19_25 = new Bond(var17_20, var18_24, var12_12, 0, 0, 0);
                        var19_25.color = var13_13 + 256 * var14_14;
                        var3_3.addElement(var19_25);
                    }
                    var12_12 = 0;
                    var14_14 = 0;
                    var13_13 = 0;
                    if (var16_16.implicit_H_count == 1) {
                        var4_4[var2_2.size() - 1] = SmilesParser.appendInt(var4_4[var2_2.size() - 1], 0x7FFFFFFF);
                    }
                    var15_15 = var16_16;
                    ** GOTO lbl153
                }
                case 16: {
                    if (var15_15 == null) ** GOTO lbl75
                    var16_16 = new Atom("R#", 0, 0, 0, 0);
                    var16_16.setIntProperty("RGP", var9_9.ival);
                    var2_2.addElement(var16_16);
                    var4_4[var2_2.size() - 1] = new int[0];
                    var17_21 = var2_2.lastIndexOf(var15_15) + 1;
                    var18_24 = var2_2.size();
                    var4_4[var17_21 - 1] = SmilesParser.appendInt(var4_4[var17_21 - 1], var18_24);
                    var4_4[var18_24 - 1] = SmilesParser.appendInt(var4_4[var18_24 - 1], var17_21);
                    if (var12_12 == 0) {
                        var12_12 = 2;
                    }
                    var19_25 = new Bond(var17_21, var18_24, var12_12, 0, 0, 0);
                    var19_25.color = var13_13 + 256 * var14_14;
                    var3_3.addElement(var19_25);
                    var12_12 = 0;
                    var14_14 = 0;
                    var13_13 = 0;
                    ** GOTO lbl153
lbl75:
                    // 1 sources

                    throw new IllegalArgumentException("Illegal attachment in SMILES '" + var0 + "'");
                }
                case 4: {
                    if (var6_6[var9_9.ival] == null) {
                        var17_22 = var2_2.lastIndexOf(var15_15) + 1;
                        var4_4[var17_22 - 1] = SmilesParser.appendInt(var4_4[var17_22 - 1], 0);
                        var6_6[var9_9.ival] = var15_15;
                        var7_7[var9_9.ival] = var4_4[var17_22 - 1].length - 1;
                        var8_8[var9_9.ival] = var12_12;
                    } else {
                        var17_22 = var2_2.lastIndexOf(var6_6[var9_9.ival]) + 1;
                        var4_4[var17_22 - 1][var7_7[var9_9.ival]] = var18_24 = var2_2.lastIndexOf(var15_15) + 1;
                        var4_4[var18_24 - 1] = SmilesParser.appendInt(var4_4[var18_24 - 1], var17_22);
                        if (var8_8[var9_9.ival] != 0) {
                            var12_12 = Math.max(var12_12, var8_8[var9_9.ival]);
                        }
                        if (var12_12 == 0) {
                            var12_12 = (((Atom)var2_2.elementAt((int)(var17_22 - 1))).color & 1) != 0 && (((Atom)var2_2.elementAt((int)(var18_24 - 1))).color & 1) != 0 ? 16 : 2;
                        }
                        var19_25 = new Bond(var17_22, var18_24, var12_12, 0, 0, 0);
                        var19_25.color = var13_13 + 256 * var14_14;
                        var3_3.addElement(var19_25);
                        var6_6[var9_9.ival] = null;
                        var8_8[var9_9.ival] = 0;
                    }
                    var12_12 = 0;
                    var14_14 = 0;
                    var13_13 = 0;
                    ** GOTO lbl153
                }
                case 128: {
                    switch (var9_9.sval.charAt(0)) {
                        case '(': {
                            var5_5.push(var15_15);
                            var12_12 = 0;
                            var14_14 = 0;
                            var13_13 = 0;
                            break;
                        }
                        case ')': {
                            var15_15 = (Atom)var5_5.pop();
                            var12_12 = 0;
                            var14_14 = 0;
                            var13_13 = 0;
                            break;
                        }
                        case '-': {
                            var12_12 = 2;
                            var13_13 = var14_14;
                            var14_14 = 0;
                            break;
                        }
                        case '/': {
                            var12_12 = 2;
                            var13_13 = var14_14;
                            var14_14 = 1;
                            break;
                        }
                        case '\\': {
                            var12_12 = 2;
                            var13_13 = var14_14;
                            var14_14 = 2;
                            break;
                        }
                        case ':': {
                            var12_12 = 16;
                            var14_14 = 0;
                            var13_13 = 0;
                            break;
                        }
                        case '=': {
                            var12_12 = 4;
                            var14_14 = 0;
                            var13_13 = 0;
                            break;
                        }
                        case '#': {
                            var12_12 = 8;
                            var14_14 = 0;
                            var13_13 = 0;
                            break;
                        }
                        case '.': {
                            var12_12 = 0;
                            var14_14 = 0;
                            var13_13 = 0;
                            var15_15 = null;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Illegal character '" + var9_9.sval.charAt(0) + "' in SMILES '" + var0 + "'");
                        }
                    }
                }
lbl153:
                // 13 sources

                default: {
                    continue block19;
                }
            }
            break;
        }
        if (!var5_5.empty()) {
            throw new IllegalArgumentException("Branches left open in SMILES '" + var0 + "'");
        }
        if (var12_12 != 0) {
            throw new IllegalArgumentException("Terminal bond character in SMILES '" + var0 + "'");
        }
        for (var16_17 = 0; var16_17 < 100; ++var16_17) {
            if (var6_6[var16_17] == null) continue;
            throw new IllegalArgumentException("Ring bond left open in SMILES '" + var0 + "'");
        }
        var16_18 = new Molecule();
        var16_18.atoms = new Atom[var2_2.size()];
        for (var17_23 = 0; var17_23 < var16_18.atoms.length; ++var17_23) {
            var16_18.atoms[var17_23] = (Atom)var2_2.elementAt(var17_23);
        }
        var16_18.bonds = new Bond[var3_3.size()];
        for (var17_23 = 0; var17_23 < var16_18.bonds.length; ++var17_23) {
            var16_18.bonds[var17_23] = (Bond)var3_3.elementAt(var17_23);
        }
        SmilesParser.decodeSmilesAtomStereo(var16_18, var4_4);
        SmilesParser.decodeSmilesBondStereo(var16_18);
        var16_18.resetColors();
        if (var1_1) {
            var16_18.denormalize();
        }
        return var16_18;
    }

    static Atom parseSmilesAtom(String string) {
        Atom atom;
        int n = 0;
        String string2 = "C";
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string3 = "";
        int n5 = 0;
        boolean bl = false;
        Tokenizer tokenizer = new Tokenizer(string);
        String[] stringArray = new String[]{"c", "n", "o", "s", "p"};
        int n6 = 139;
        tokenizer.nextToken(n6, stringArray);
        if (tokenizer.ttype == 8) {
            n = tokenizer.ival;
            n6 = 131;
            tokenizer.nextToken(n6, stringArray);
        }
        if (tokenizer.ttype == 2 || tokenizer.ttype == 1 || tokenizer.ttype == 128 && tokenizer.sval.equals("*")) {
            if (tokenizer.ttype == 2 || tokenizer.ttype == 128 && tokenizer.sval.equals("*")) {
                string2 = tokenizer.sval;
                bl = false;
            } else {
                string2 = tokenizer.sval.toUpperCase();
                bl = true;
            }
        } else {
            throw new IllegalArgumentException("Syntax error in SMILES atom [" + string + "]");
        }
        n6 = 136;
        tokenizer.nextToken(n6, null);
        if (tokenizer.ttype == 128 && tokenizer.sval.equals("@")) {
            string3 = "TH";
            n5 = 1;
            n6 = 136;
            tokenizer.nextToken(392, null);
            if (tokenizer.ttype == 128 && tokenizer.sval.equals("@")) {
                n5 = 2;
                n6 = 136;
                tokenizer.nextToken(n6, null);
            } else if (tokenizer.ttype == 256 && !tokenizer.sval.equals("H")) {
                string3 = tokenizer.sval;
                n6 = 128;
                tokenizer.nextToken(n6, null);
                if (tokenizer.ttype == 8) {
                    n5 = tokenizer.ival;
                    n6 = 128;
                    tokenizer.nextToken(n6, null);
                }
            }
        }
        if (tokenizer.ttype == 2 || tokenizer.ttype == 256 || tokenizer.ttype == 128 && tokenizer.sval.equals("H")) {
            if (!tokenizer.sval.equals("H")) {
                throw new IllegalArgumentException("Syntax error in SMILES atom [" + string + "]");
            }
            n2 = 1;
            n6 = 136;
            tokenizer.nextToken(n6, null);
            if (tokenizer.ttype == 8) {
                n2 = tokenizer.ival;
                tokenizer.nextToken(n6, null);
            }
        }
        if (tokenizer.ttype == 128 && (tokenizer.sval.equals("+") || tokenizer.sval.equals("-"))) {
            n3 = tokenizer.sval.equals("+") ? 1 : -1;
            tokenizer.nextToken(136, null);
            if (tokenizer.ttype == 8) {
                n3 *= tokenizer.ival;
                tokenizer.nextToken(128, null);
            }
        }
        if (tokenizer.ttype == 128 && tokenizer.sval.equals(":")) {
            tokenizer.nextToken(8, null);
            if (tokenizer.ttype == 8) {
                n4 = tokenizer.ival + 1;
                tokenizer.nextToken(128, null);
            } else {
                throw new IllegalArgumentException("Syntax error in SMILES atom [" + string + "]");
            }
        }
        if (tokenizer.ttype != 512) {
            throw new IllegalArgumentException("Syntax error in SMILES atom [" + string + "]");
        }
        if (string2.equals("*")) {
            atom = new Atom(0.0, 0.0, 0.0, "R#", null, false, n2, n, 0, 0, n4);
            atom.setIntProperty("RGP", n3);
        } else {
            atom = new Atom(0.0, 0.0, 0.0, string2, null, false, n2, n, n3, 0, n4);
        }
        if (bl) {
            atom.color |= 1;
        }
        if (!string3.equals("")) {
            atom.setIntProperty(string3, n5);
        }
        return atom;
    }

    static void decodeSmilesAtomStereo(Molecule molecule, int[][] nArray) {
        int n;
        Vector<StereoDescription> vector = new Vector<StereoDescription>();
        for (n = 0; n < molecule.atoms.length; ++n) {
            Atom atom = molecule.atoms[n];
            if (atom.getIntProperty("TH", 0) == 0) continue;
            int n2 = atom.getIntProperty("TH", 0);
            atom.removeIntProperty("TH");
            if (n2 != 1 && n2 != 2) {
                System.err.println("Illegal TH coset label '" + n2 + "' ignored");
                continue;
            }
            if (nArray[n].length != 4) {
                System.err.println("tetrahedral stereochemistry for atom with " + nArray[n].length + " ligands");
                continue;
            }
            if (n2 == 1) {
                int n3 = nArray[n][2];
                nArray[n][2] = nArray[n][3];
                nArray[n][3] = n3;
            }
            vector.addElement(new StereoDescription(molecule, atom, nArray[n], 1));
        }
        if (vector.size() > 0) {
            molecule.stereodescs = new StereoDescription[vector.size()];
            for (n = 0; n < vector.size(); ++n) {
                molecule.stereodescs[n] = (StereoDescription)vector.elementAt(n);
            }
        }
    }

    static void decodeSmilesBondStereo(Molecule molecule) {
    }

    public static String bondTypeToString(int n) {
        if (n == 0) {
            return ".";
        }
        if (n == 1) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append('.');
        }
        if ((n & 2) != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",-");
            } else {
                stringBuffer.append('-');
            }
        }
        if ((n & 4) != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",=");
            } else {
                stringBuffer.append('=');
            }
        }
        if ((n & 8) != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",#");
            } else {
                stringBuffer.append('#');
            }
        }
        if ((n & 0x10) != 0) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(",:");
            } else {
                stringBuffer.append(':');
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Molecule molecule = SmilesParser.smilesToMolecule("CS(=O)c1c(N)nc(Cl)nc1Cl.CS(=O)c1c(Cl)nc(N)nc1Cl");
    }
}

