/*
 * Decompiled with CFR 0.152.
 */
package novartis.chemistry.molecule;

import java.util.StringTokenizer;

public class PTable {
    int atomic_number;
    String symbol;
    int normal_valence;
    float natural_mass;
    float electronegativity;
    int[] allowed_valences = null;
    static final int HALOGENE = 120;
    static final int HETERO = 121;
    static final int METAL = 122;
    static final int RGROUP = 123;
    static final int ERROR_NUMBER = -1;
    static final int QUERY_STRING = -2;
    static PTable[] ptable = new PTable[]{new PTable("C", 4, 12.01115, 2.55, 6, 4, 4, 1), new PTable("N", 3, 14.0067, 3.04, 7, 3, 5, 2), new PTable("O", 2, 15.9994, 3.44, 8, 2, 2, 1), new PTable("H", 1, 1.00797, 2.2, 1, -1, 1, 2), new PTable("D", 1, 2.014, 2.2, 1), new PTable("T", 1, 3.0161, 2.2, 1), new PTable("He", 0, 4.0026, 0.0, 2), new PTable("Li", 1, 6.939, 0.98, 3, -1, 1, 2), new PTable("Be", 2, 9.0122, 1.57, 4, -2, 2, 2), new PTable("B", 3, 10.811, 2.04, 5, 3, 3, 1), new PTable("C", 4, 12.01115, 2.55, 6, 4, 4, 1), new PTable("N", 3, 14.0067, 3.04, 7, 3, 5, 2), new PTable("O", 2, 15.9994, 3.44, 8, 2, 2, 1), new PTable("F", 1, 18.9984, 3.98, 9, 1, 1, 1), new PTable("Ne", 0, 20.183, 0.0, 10), new PTable("Na", 1, 22.9898, 0.93, 11, -1, 1, 2), new PTable("Mg", 2, 24.312, 1.31, 12, -2, 2, 2), new PTable("Al", 3, 26.9815, 1.61, 13, -3, 3, 2), new PTable("Si", 4, 28.086, 1.9, 14, 4, 4, 1), new PTable("P", 5, 30.9738, 2.19, 15, 3, 5, 2), new PTable("S", 2, 32.064, 2.58, 16, 2, 6, 2), new PTable("Cl", 1, 35.453, 3.16, 17, 1, 7, 2), new PTable("Ar", 0, 39.948, 0.0, 18), new PTable("K", 1, 39.102, 0.82, 19, -1, 1, 2), new PTable("Ca", 2, 40.08, 1.0, 20), new PTable("Sc", 3, 44.956, 1.36, 21), new PTable("Ti", 3, 47.9, 1.54, 22), new PTable("V", 3, 50.942, 1.63, 23), new PTable("Cr", 3, 51.996, 1.66, 24), new PTable("Mn", 4, 54.938, 1.55, 25), new PTable("Fe", 2, 55.847, 1.83, 26), new PTable("Co", 2, 58.9332, 1.88, 27), new PTable("Ni", 2, 58.71, 1.91, 28), new PTable("Cu", 1, 63.546, 1.9, 29), new PTable("Zn", 2, 65.37, 1.65, 30), new PTable("Ga", 2, 69.72, 1.81, 31, -3, 3, 2), new PTable("Ge", 4, 72.59, 2.01, 32), new PTable("As", 3, 74.9216, 2.18, 33), new PTable("Se", 4, 78.96, 2.55, 34, 2, 6, 2), new PTable("Br", 1, 79.904, 2.96, 35, 1, 7, 2), new PTable("Kr", 0, 83.8, 0.0, 36), new PTable("Rb", 1, 85.47, 0.82, 37, -1, 1, 2), new PTable("Sr", 2, 87.62, 0.95, 38), new PTable("Y", 3, 88.905, 1.22, 39), new PTable("Zr", 4, 91.22, 1.33, 40), new PTable("Nb", 3, 92.906, 1.6, 41), new PTable("Mo", 4, 95.94, 2.16, 42), new PTable("Tc", 6, 98.9062, 1.9, 43), new PTable("Ru", 4, 101.07, 2.2, 44), new PTable("Rh", 3, 102.905, 2.28, 45), new PTable("Pd", 4, 106.4, 2.2, 46), new PTable("Ag", 1, 107.868, 1.93, 47), new PTable("Cd", 2, 112.4, 1.69, 48), new PTable("In", 3, 114.82, 1.78, 49, -3, 3, 2), new PTable("Sn", 2, 118.69, 1.96, 50), new PTable("Sb", 3, 121.75, 2.05, 51), new PTable("Te", 4, 127.6, 2.1, 52, 2, 6, 2), new PTable("I", 1, 126.9044, 2.66, 53, 1, 7, 2), new PTable("Xe", 0, 131.3, 0.0, 54), new PTable("Cs", 1, 132.905, 0.79, 55, -1, 1, 2), new PTable("Ba", 2, 137.33, 0.89, 56), new PTable("La", 3, 138.91, 1.1, 57, -3, 3, 2), new PTable("Ce", 3, 140.12, 1.12, 58, -3, 3, 2), new PTable("Pr", 3, 140.907, 1.13, 59, -3, 3, 2), new PTable("Nd", 3, 144.24, 1.14, 60, -3, 3, 2), new PTable("Pm", 3, 145.0, 1.2, 61, -3, 3, 2), new PTable("Sm", 2, 150.35, 1.17, 62, -3, 3, 2), new PTable("Eu", 2, 151.96, 1.2, 63, -3, 3, 2), new PTable("Gd", 3, 157.25, 1.2, 64, -3, 3, 2), new PTable("Tb", 3, 158.924, 1.2, 65, -3, 3, 2), new PTable("Dy", 3, 162.5, 1.22, 66, -3, 3, 2), new PTable("Ho", 3, 164.93, 1.23, 67, -3, 3, 2), new PTable("Er", 3, 167.26, 1.24, 68, -3, 3, 2), new PTable("Tm", 3, 168.934, 1.25, 69, -3, 3, 2), new PTable("Yb", 2, 173.04, 1.1, 70, -3, 3, 2), new PTable("Lu", 3, 174.97, 1.27, 71, -3, 3, 2), new PTable("Hf", 4, 178.49, 1.3, 72), new PTable("Ta", 5, 180.948, 1.5, 73), new PTable("W", 6, 183.85, 2.36, 74), new PTable("Re", 0, 186.2, 1.9, 75), new PTable("Os", 3, 190.2, 2.2, 76), new PTable("Ir", 3, 192.2, 2.2, 77), new PTable("Pt", 2, 195.09, 2.28, 78), new PTable("Au", 1, 196.967, 2.54, 79), new PTable("Hg", 2, 200.59, 2.0, 80), new PTable("Tl", 1, 204.37, 2.04, 81, -3, 3, 2), new PTable("Pb", 2, 207.19, 2.33, 82), new PTable("Bi", 3, 208.98, 2.02, 83), new PTable("Po", 0, 209.0, 2.0, 84), new PTable("At", 3, 210.0, 2.2, 85), new PTable("Rn", 0, 222.0, 0.0, 86), new PTable("Fr", 1, 223.0, 0.7, 87), new PTable("Ra", 2, 226.03, 0.9, 88), new PTable("Ac", 0, 227.0, 1.1, 89), new PTable("Th", 4, 232.038, 1.3, 90), new PTable("Pa", 0, 231.04, 1.5, 91), new PTable("U", 6, 238.03, 1.38, 92), new PTable("Np", 5, 237.05, 1.36, 93), new PTable("Pu", 4, 244.0, 1.28, 94), new PTable("Am", 4, 243.0, 1.3, 95), new PTable("Cm", 3, 247.0, 1.3, 96), new PTable("Bk", 3, 247.0, 1.3, 97), new PTable("Cf", 0, 251.0, 1.3, 98), new PTable("Es", 0, 254.0, 1.3, 99), new PTable("Fm", 0, 257.0, 1.3, 100), new PTable("Md", 0, 258.0, 0.0, 101), new PTable("No", 0, 259.0, 0.0, 102), new PTable("Lr", 0, 260.0, 0.0, 103), new PTable("X", 1, 260.0, 0.0, 120), new PTable("Q", 0, 260.0, 0.0, 121), new PTable("M", 0, 260.0, 0.0, 122), new PTable("R#", 0, 260.0, 0.0, 123)};
    private static String[] HC_table = new String[]{"H", "C"};
    private static String[] non_metal_hetero_elements = new String[]{"He", "B", "N", "O", "F", "Ne", "Si", "P", "S", "Cl", "Ar", "As", "Se", "Br", "Kr", "Sb", "Te", "I", "Xe", "At"};
    private static String[] metals = new String[]{"Li", "Be", "Na", "Mg", "Al", "K", "Ca", "Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Ga", "Rb", "Sr", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "In", "Sn", "Cs", "Ba", "La", "Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg", "Tl", "Pb", "Bi", "Po", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu"};
    private static String[] non_metal_small_solution = new String[]{"H", "B", "C", "N", "O", "F", "Si", "P", "S", "Cl", "Se", "Br", "I"};
    private static String[] alkali_metals = new String[]{"Li", "Na", "K", "Rb", "Cs", "Fr"};
    private static String[] gr2 = new String[]{"Be", "Mg", "Ca", "Sr", "Ba", "Ra"};
    private static String[] gr3 = new String[]{"B", "Al", "Ga", "In", "Tl"};
    private static String[] gr4 = new String[]{"C", "Si", "Ge", "Sn", "Pb"};
    private static String[] ONS_table = new String[]{"O", "N", "S"};
    private static String[] on2 = new String[]{"O", "N", "S", "P", "Se", "Te", "Po"};
    private static String[] halogenes = new String[]{"F", "Cl", "Br", "I", "At"};
    private static String[] ha2 = new String[]{"Cl", "Br", "I", "At"};
    private static String[] transition_metals = new String[]{"Sc", "Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Cu", "Zn", "Y", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Ag", "Cd", "La", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt", "Au", "Hg"};
    private static String[] tra = new String[]{"Ti", "V", "Cr", "Mn", "Fe", "Co", "Ni", "Zr", "Nb", "Mo", "Tc", "Ru", "Rh", "Pd", "Hf", "Ta", "W", "Re", "Os", "Ir", "Pt"};
    private static String[] trb = new String[]{"Cu", "Zn", "Ag", "Cd", "Au", "Hg"};
    private static String[] tm1 = new String[]{"Cu", "Ag", "Au"};
    private static String[] tm2 = new String[]{"Zn", "Cd", "Hg"};
    private static String[] tm3 = new String[]{"Sc", "Y", "La"};
    private static String[] tm4 = new String[]{"Ti", "Zr", "Hf"};
    private static String[] tm5 = new String[]{"V", "Nb", "Ta"};
    private static String[] tm6 = new String[]{"Cr", "Mo", "W"};
    private static String[] tm7 = new String[]{"Mn", "Tc", "Re"};
    private static String[] tm8 = new String[]{"Fe", "Co", "Ni", "Ru", "Rh", "Pd", "Os", "Ir", "Pt"};
    private static String[] lanthanoids = new String[]{"Ce", "Pr", "Nd", "Pm", "Sm", "Eu", "Gd", "Tb", "Dy", "Ho", "Er", "Tm", "Yb", "Lu"};
    private static String[] amino_acids = new String[]{"Ala", "Arg", "Asn", "Asp", "Cys", "Gln", "Glu", "Gly", "His", "Ile", "Leu", "Lys", "Met", "Phe", "Pro", "Ser", "Thr", "Trp", "Tyr", "Val"};

    PTable(String string, int n, double d, double d2, int n2) {
        this.symbol = string;
        this.normal_valence = n;
        this.natural_mass = (float)d;
        this.electronegativity = (float)d2;
        this.atomic_number = n2;
        this.allowed_valences = null;
    }

    PTable(String string, int n, double d, double d2, int n2, int n3, int n4, int n5) {
        int n6;
        this.symbol = string;
        this.normal_valence = n;
        this.natural_mass = (float)d;
        this.electronegativity = (float)d2;
        this.atomic_number = n2;
        int n7 = 0;
        for (n6 = n3; n6 <= n4; n6 += n5) {
            ++n7;
        }
        this.allowed_valences = new int[n7];
        n6 = n3;
        int n8 = 0;
        while (n6 <= n4) {
            this.allowed_valences[n8] = n6;
            n6 += n5;
            ++n8;
        }
    }

    public static int SymbolToAtomicNumber(String string) {
        for (int i = 0; i < ptable.length; ++i) {
            if (!string.equals(PTable.ptable[i].symbol)) continue;
            return PTable.ptable[i].atomic_number;
        }
        return -1;
    }

    public static String AtomicNumberToSymbol(int n) {
        for (int i = 0; i < ptable.length; ++i) {
            if (n != PTable.ptable[i].atomic_number) continue;
            return PTable.ptable[i].symbol;
        }
        return null;
    }

    public static int mdiffToIsotope(String string, int n) {
        if (n == 0) {
            return 0;
        }
        for (int i = 0; i < ptable.length; ++i) {
            if (!string.equals(PTable.ptable[i].symbol)) continue;
            return (int)((double)(PTable.ptable[i].natural_mass + (float)n) + 0.49999);
        }
        return 0;
    }

    public static int symbolToValence(String string) {
        for (int i = 0; i < ptable.length; ++i) {
            if (!string.equals(PTable.ptable[i].symbol)) continue;
            return PTable.ptable[i].normal_valence;
        }
        return 0;
    }

    public static int implicitHydrogens(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        PTable pTable = null;
        for (n7 = 0; n7 < ptable.length; ++n7) {
            if (!string.equals(PTable.ptable[n7].symbol)) continue;
            pTable = ptable[n7];
            break;
        }
        if (pTable == null || pTable.allowed_valences == null) {
            return 0;
        }
        int n8 = n + 2 * n3 + 3 * n4;
        if (n5 == 2) {
            ++n8;
        } else if (n5 == 1) {
            n8 += 2;
        } else if (n5 == 4) {
            n8 += 2;
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n8 += 2;
                break;
            }
            case 2: {
                n8 += 3;
                break;
            }
            case 3: {
                n8 += 4;
                break;
            }
            default: {
                n8 += n2 + 1;
            }
        }
        for (n7 = 0; n7 < pTable.allowed_valences.length; ++n7) {
            int n9 = pTable.allowed_valences[n7] - n8 + n6;
            if (0 > n9) continue;
            return n9;
        }
        return 0;
    }

    private static boolean isInStringTable(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean atomSymbolMatch(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (Character.isLowerCase(string3.charAt(0)) && ("alk".equals(string3) ? PTable.isInStringTable(string, alkali_metals) : ("gr2".equals(string3) ? PTable.isInStringTable(string, gr2) : ("gr3".equals(string3) ? PTable.isInStringTable(string, gr3) : ("gr4".equals(string3) ? PTable.isInStringTable(string, gr4) : ("ons".equals(string3) ? PTable.isInStringTable(string, ONS_table) : ("on2".equals(string3) ? PTable.isInStringTable(string, on2) : ("hal".equals(string3) ? PTable.isInStringTable(string, halogenes) : ("ha2".equals(string3) ? PTable.isInStringTable(string, ha2) : ("trn".equals(string3) ? PTable.isInStringTable(string, transition_metals) : ("tra".equals(string3) ? PTable.isInStringTable(string, tra) : ("trb".equals(string3) ? PTable.isInStringTable(string, trb) : ("tm1".equals(string3) ? PTable.isInStringTable(string, tm1) : ("tm2".equals(string3) ? PTable.isInStringTable(string, tm2) : ("tm3".equals(string3) ? PTable.isInStringTable(string, tm3) : ("tm4".equals(string3) ? PTable.isInStringTable(string, tm4) : ("tm5".equals(string3) ? PTable.isInStringTable(string, tm5) : ("tm6".equals(string3) ? PTable.isInStringTable(string, tm6) : ("tm7".equals(string3) ? PTable.isInStringTable(string, tm7) : ("tm8".equals(string3) ? PTable.isInStringTable(string, tm8) : ("lan".equals(string3) ? PTable.isInStringTable(string, lanthanoids) : "ami".equals(string3) && PTable.isInStringTable(string, amino_acids)))))))))))))))))))))) {
                return true;
            }
            if (!string.equals(string3)) continue;
            return true;
        }
        if ("A".equals(string2)) {
            return !"H".equals(string);
        }
        if ("Qs".equals(string2)) {
            return PTable.isInStringTable(string, non_metal_small_solution);
        }
        if ("G".equals(string2)) {
            return PTable.isInStringTable(string, HC_table);
        }
        if ("ONS".equals(string2)) {
            return PTable.isInStringTable(string, ONS_table);
        }
        if ("X".equals(string2)) {
            return PTable.isInStringTable(string, halogenes);
        }
        if ("Q".equals(string2)) {
            return PTable.isInStringTable(string, non_metal_hetero_elements);
        }
        if ("M".equals(string2)) {
            return PTable.isInStringTable(string, metals);
        }
        if ("Ami".equals(string2)) {
            return PTable.isInStringTable(string, amino_acids);
        }
        return false;
    }
}

